/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.explanation;

import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.explanation.ExplanationDialog;
import org.protege.editor.owl.ui.explanation.ExplanationPlugin;
import org.protege.editor.owl.ui.explanation.ExplanationPluginLoader;
import org.protege.editor.owl.ui.explanation.ExplanationService;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplanationManager
implements Disposable {
    private final Logger logger = LoggerFactory.getLogger(ExplanationManager.class);
    private final OWLEditorKit editorKit;
    private final Collection<ExplanationService> explanationServices = new HashSet<ExplanationService>();
    private final Collection<ExplanationDialog> openedExplanations = new HashSet<ExplanationDialog>();

    public ExplanationManager(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
        this.reload();
    }

    public void reload() {
        ExplanationPluginLoader loader = new ExplanationPluginLoader(this.editorKit);
        this.explanationServices.clear();
        for (ExplanationPlugin plugin : loader.getPlugins()) {
            ExplanationService teacher = null;
            try {
                teacher = plugin.newInstance();
                teacher.initialise();
                this.explanationServices.add(teacher);
            }
            catch (Exception e) {
                this.logger.error("An error occurred whilst initialising an explanation service {}.", (Object)plugin.getName(), (Object)e);
            }
        }
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.editorKit;
    }

    public OWLModelManager getModelManager() {
        return this.editorKit.getModelManager();
    }

    public Collection<ExplanationService> getExplainers() {
        return this.explanationServices;
    }

    public Collection<ExplanationService> getTeachers(OWLAxiom axiom) {
        HashSet<ExplanationService> smartTeachers = new HashSet<ExplanationService>();
        for (ExplanationService teacher : this.explanationServices) {
            if (!teacher.hasExplanation(axiom)) continue;
            smartTeachers.add(teacher);
        }
        return smartTeachers;
    }

    public boolean hasExplanation(OWLAxiom axiom) {
        for (ExplanationService explanationService : this.explanationServices) {
            if (!explanationService.hasExplanation(axiom)) continue;
            return true;
        }
        return false;
    }

    public void handleExplain(Frame owner, OWLAxiom axiom) {
        final ExplanationDialog explanation = new ExplanationDialog(this, axiom);
        this.openedExplanations.add(explanation);
        JOptionPane op = new JOptionPane(explanation, -1, -1);
        JDialog dlg = op.createDialog(owner, this.getExplanationDialogTitle(axiom));
        dlg.setDefaultCloseOperation(2);
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ExplanationManager.this.dispose(explanation);
            }
        });
        dlg.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ExplanationManager.this.dispose(explanation);
            }
        });
        dlg.setModal(false);
        dlg.setResizable(true);
        dlg.pack();
        dlg.setVisible(true);
    }

    private void dispose(ExplanationDialog explanation) {
        if (this.openedExplanations.remove(explanation)) {
            explanation.dispose();
        }
    }

    private String getExplanationDialogTitle(OWLAxiom entailment) {
        String rendering = this.editorKit.getOWLModelManager().getRendering((OWLObject)entailment).replaceAll("\\s", " ");
        return "Explanation for " + rendering;
    }

    public void dispose() throws Exception {
        for (ExplanationDialog explanation : this.openedExplanations) {
            explanation.dispose();
        }
        this.openedExplanations.clear();
        for (ExplanationService teacher : this.explanationServices) {
            teacher.dispose();
        }
    }
}

