# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
BSplSLib module, see official documentation at
https://www.opencascade.com/doc/occt-7.6.0/refman/html/package_bsplslib.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _BSplSLib
else:
    import _BSplSLib

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BSplSLib.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _BSplSLib.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _BSplSLib.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _BSplSLib.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _BSplSLib.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _BSplSLib.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _BSplSLib.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _BSplSLib.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _BSplSLib.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _BSplSLib.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _BSplSLib.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _BSplSLib.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _BSplSLib.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _BSplSLib.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _BSplSLib.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _BSplSLib.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _BSplSLib.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _BSplSLib:
_BSplSLib.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _BSplSLib.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.TColgp
import OCC.Core.gp

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_BSplSLib_Cache_Create() -> "opencascade::handle< BSplSLib_Cache >":
    return _BSplSLib.Handle_BSplSLib_Cache_Create()

def Handle_BSplSLib_Cache_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BSplSLib_Cache >":
    return _BSplSLib.Handle_BSplSLib_Cache_DownCast(t)

def Handle_BSplSLib_Cache_IsNull(t: "opencascade::handle< BSplSLib_Cache > const &") -> "bool":
    return _BSplSLib.Handle_BSplSLib_Cache_IsNull(t)
class bsplslib(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def BuildCache(*args) -> "void":
        r"""
        Perform the evaluation of the taylor expansion of the bspline normalized between 0 and 1. if rational computes the homogeneous taylor expension for the numerator and stores it in cachepoles.

        Parameters
        ----------
        U: float
        V: float
        USpanDomain: float
        VSpanDomain: float
        UPeriodicFlag: bool
        VPeriodicFlag: bool
        UDegree: int
        VDegree: int
        UIndex: int
        VIndex: int
        UFlatKnots: TColStd_Array1OfReal
        VFlatKnots: TColStd_Array1OfReal
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        CachePoles: TColgp_Array2OfPnt
        CacheWeights: TColStd_Array2OfReal *

        Returns
        -------
        None
        Perform the evaluation of the taylor expansion of the bspline normalized between 0 and 1. structure of result optimized for bsplslib_cache.

        Parameters
        ----------
        theU: float
        theV: float
        theUSpanDomain: float
        theVSpanDomain: float
        theUPeriodic: bool
        theVPeriodic: bool
        theUDegree: int
        theVDegree: int
        theUIndex: int
        theVIndex: int
        theUFlatKnots: TColStd_Array1OfReal
        theVFlatKnots: TColStd_Array1OfReal
        thePoles: TColgp_Array2OfPnt
        theWeights: TColStd_Array2OfReal *
        theCacheArray: TColStd_Array2OfReal

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_BuildCache(*args)

    @staticmethod
    def CacheD0(*args) -> "void":
        r"""
        Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights this just evaluates the current point the cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effects.

        Parameters
        ----------
        U: float
        V: float
        UDegree: int
        VDegree: int
        UCacheParameter: float
        VCacheParameter: float
        USpanLenght: float
        VSpanLength: float
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        Point: gp_Pnt

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_CacheD0(*args)

    @staticmethod
    def CacheD1(*args) -> "void":
        r"""
        Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights this just evaluates the current point the cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effects.

        Parameters
        ----------
        U: float
        V: float
        UDegree: int
        VDegree: int
        UCacheParameter: float
        VCacheParameter: float
        USpanLenght: float
        VSpanLength: float
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        Point: gp_Pnt
        VecU: gp_Vec
        VecV: gp_Vec

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_CacheD1(*args)

    @staticmethod
    def CacheD2(*args) -> "void":
        r"""
        Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights this just evaluates the current point the cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effects.

        Parameters
        ----------
        U: float
        V: float
        UDegree: int
        VDegree: int
        UCacheParameter: float
        VCacheParameter: float
        USpanLenght: float
        VSpanLength: float
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        Point: gp_Pnt
        VecU: gp_Vec
        VecV: gp_Vec
        VecUU: gp_Vec
        VecUV: gp_Vec
        VecVV: gp_Vec

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_CacheD2(*args)

    @staticmethod
    def CoefsD0(*args) -> "void":
        r"""
        Calls cached0 for bezier surfaces arrays computed with the method polescoefficients. warning: to be used for beziersurfaces only!!!.

        Parameters
        ----------
        U: float
        V: float
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        Point: gp_Pnt

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_CoefsD0(*args)

    @staticmethod
    def CoefsD1(*args) -> "void":
        r"""
        Calls cached0 for bezier surfaces arrays computed with the method polescoefficients. warning: to be used for beziersurfaces only!!!.

        Parameters
        ----------
        U: float
        V: float
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        Point: gp_Pnt
        VecU: gp_Vec
        VecV: gp_Vec

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_CoefsD1(*args)

    @staticmethod
    def CoefsD2(*args) -> "void":
        r"""
        Calls cached0 for bezier surfaces arrays computed with the method polescoefficients. warning: to be used for beziersurfaces only!!!.

        Parameters
        ----------
        U: float
        V: float
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        Point: gp_Pnt
        VecU: gp_Vec
        VecV: gp_Vec
        VecUU: gp_Vec
        VecUV: gp_Vec
        VecVV: gp_Vec

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_CoefsD2(*args)

    @staticmethod
    def D0(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float
        V: float
        UIndex: int
        VIndex: int
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        UKnots: TColStd_Array1OfReal
        VKnots: TColStd_Array1OfReal
        UMults: TColStd_Array1OfInteger *
        VMults: TColStd_Array1OfInteger *
        UDegree: int
        VDegree: int
        URat: bool
        VRat: bool
        UPer: bool
        VPer: bool
        P: gp_Pnt

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_D0(*args)

    @staticmethod
    def D1(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float
        V: float
        UIndex: int
        VIndex: int
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        UKnots: TColStd_Array1OfReal
        VKnots: TColStd_Array1OfReal
        UMults: TColStd_Array1OfInteger *
        VMults: TColStd_Array1OfInteger *
        Degree: int
        VDegree: int
        URat: bool
        VRat: bool
        UPer: bool
        VPer: bool
        P: gp_Pnt
        Vu: gp_Vec
        Vv: gp_Vec

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_D1(*args)

    @staticmethod
    def D2(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float
        V: float
        UIndex: int
        VIndex: int
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        UKnots: TColStd_Array1OfReal
        VKnots: TColStd_Array1OfReal
        UMults: TColStd_Array1OfInteger *
        VMults: TColStd_Array1OfInteger *
        UDegree: int
        VDegree: int
        URat: bool
        VRat: bool
        UPer: bool
        VPer: bool
        P: gp_Pnt
        Vu: gp_Vec
        Vv: gp_Vec
        Vuu: gp_Vec
        Vvv: gp_Vec
        Vuv: gp_Vec

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_D2(*args)

    @staticmethod
    def D3(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float
        V: float
        UIndex: int
        VIndex: int
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        UKnots: TColStd_Array1OfReal
        VKnots: TColStd_Array1OfReal
        UMults: TColStd_Array1OfInteger *
        VMults: TColStd_Array1OfInteger *
        UDegree: int
        VDegree: int
        URat: bool
        VRat: bool
        UPer: bool
        VPer: bool
        P: gp_Pnt
        Vu: gp_Vec
        Vv: gp_Vec
        Vuu: gp_Vec
        Vvv: gp_Vec
        Vuv: gp_Vec
        Vuuu: gp_Vec
        Vvvv: gp_Vec
        Vuuv: gp_Vec
        Vuvv: gp_Vec

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_D3(*args)

    @staticmethod
    def DN(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float
        V: float
        Nu: int
        Nv: int
        UIndex: int
        VIndex: int
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        UKnots: TColStd_Array1OfReal
        VKnots: TColStd_Array1OfReal
        UMults: TColStd_Array1OfInteger *
        VMults: TColStd_Array1OfInteger *
        UDegree: int
        VDegree: int
        URat: bool
        VRat: bool
        UPer: bool
        VPer: bool
        Vn: gp_Vec

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_DN(*args)

    @staticmethod
    def FunctionMultiply(*args) -> "Standard_Integer &":
        r"""
        This will multiply a given bspline numerator n(u,v) and denominator d(u,v) defined by its u/vbsplinedegree and u/vbsplineknots, and u/vmults. its poles and weights are arrays which are coded as array2 of the form [1..unumpoles][1..vnumpoles] by a function a(u,v) which is assumed to satisfy the following : 1. a(u,v) * n(u,v) and a(u,v) * d(u,v) is a polynomial bspline that can be expressed exactly as a bspline of degree u/vnewdegree on the knots u/vflatknots 2. the range of a(u,v) is the same as the range of n(u,v) or d(u,v) ---warning: it is the caller's responsibility to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method -- thestatus will return 0 if ok else it will return the pivot index -- of the matrix that was inverted to compute the multiplied -- bspline : the method used is interpolation at schoenenberg -- points of a(u,v)* n(u,v) and a(u,v) * d(u,v) thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of a(u,v)*f(u,v) --.

        Parameters
        ----------
        Function: BSplSLib_EvaluatorFunction
        UBSplineDegree: int
        VBSplineDegree: int
        UBSplineKnots: TColStd_Array1OfReal
        VBSplineKnots: TColStd_Array1OfReal
        UMults: TColStd_Array1OfInteger *
        VMults: TColStd_Array1OfInteger *
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        UFlatKnots: TColStd_Array1OfReal
        VFlatKnots: TColStd_Array1OfReal
        UNewDegree: int
        VNewDegree: int
        NewNumerator: TColgp_Array2OfPnt
        NewDenominator: TColStd_Array2OfReal

        Returns
        -------
        theStatus: int

        """
        return _BSplSLib.bsplslib_FunctionMultiply(*args)

    @staticmethod
    def GetPoles(*args) -> "void":
        r"""
        Get from fp the coordinates of the poles.

        Parameters
        ----------
        FP: TColStd_Array1OfReal
        Poles: TColgp_Array2OfPnt
        UDirection: bool

        Returns
        -------
        None
        Get from fp the coordinates of the poles.

        Parameters
        ----------
        FP: TColStd_Array1OfReal
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal
        UDirection: bool

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_GetPoles(*args)

    @staticmethod
    def HomogeneousD0(*args) -> "Standard_Real &":
        r"""
        Makes an homogeneous evaluation of poles and weights any and returns in p the numerator value and in w the denominator value if weights are present otherwise returns 1.0e0.

        Parameters
        ----------
        U: float
        V: float
        UIndex: int
        VIndex: int
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        UKnots: TColStd_Array1OfReal
        VKnots: TColStd_Array1OfReal
        UMults: TColStd_Array1OfInteger *
        VMults: TColStd_Array1OfInteger *
        UDegree: int
        VDegree: int
        URat: bool
        VRat: bool
        UPer: bool
        VPer: bool
        P: gp_Pnt

        Returns
        -------
        W: float

        """
        return _BSplSLib.bsplslib_HomogeneousD0(*args)

    @staticmethod
    def HomogeneousD1(*args) -> "Standard_Real &, Standard_Real &, Standard_Real &":
        r"""
        Makes an homogeneous evaluation of poles and weights any and returns in p the numerator value and in w the denominator value if weights are present otherwise returns 1.0e0.

        Parameters
        ----------
        U: float
        V: float
        UIndex: int
        VIndex: int
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        UKnots: TColStd_Array1OfReal
        VKnots: TColStd_Array1OfReal
        UMults: TColStd_Array1OfInteger *
        VMults: TColStd_Array1OfInteger *
        UDegree: int
        VDegree: int
        URat: bool
        VRat: bool
        UPer: bool
        VPer: bool
        N: gp_Pnt
        Nu: gp_Vec
        Nv: gp_Vec

        Returns
        -------
        D: float
        Du: float
        Dv: float

        """
        return _BSplSLib.bsplslib_HomogeneousD1(*args)

    @staticmethod
    def IncreaseDegree(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        UDirection: bool
        Degree: int
        NewDegree: int
        Periodic: bool
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        NewPoles: TColgp_Array2OfPnt
        NewWeights: TColStd_Array2OfReal *
        NewKnots: TColStd_Array1OfReal
        NewMults: TColStd_Array1OfInteger

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_IncreaseDegree(*args)

    @staticmethod
    def InsertKnots(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        UDirection: bool
        Degree: int
        Periodic: bool
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        AddKnots: TColStd_Array1OfReal
        AddMults: TColStd_Array1OfInteger *
        NewPoles: TColgp_Array2OfPnt
        NewWeights: TColStd_Array2OfReal *
        NewKnots: TColStd_Array1OfReal
        NewMults: TColStd_Array1OfInteger
        Epsilon: float
        Add: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_InsertKnots(*args)

    @staticmethod
    def Interpolate(*args) -> "Standard_Integer &":
        r"""
        Performs the interpolation of the data points given in the poles array in the form [1,...,rl][1,...,rc][1...polesdimension] . the collength cl and the length of uparameters must be the same. the length of vflatknots is vdegree + cl + 1. //! the rowlength rl and the length of vparameters must be the same. the length of vflatknots is degree + rl + 1. //! warning: the method used to do that interpolation is gauss elimination without pivoting. thus if the diagonal is not dominant there is no guarantee that the algorithm will work. nevertheless for cubic interpolation at knots or interpolation at scheonberg points the method will work. the inversionproblem will report 0 if there was no problem else it will give the index of the faulty pivot.

        Parameters
        ----------
        UDegree: int
        VDegree: int
        UFlatKnots: TColStd_Array1OfReal
        VFlatKnots: TColStd_Array1OfReal
        UParameters: TColStd_Array1OfReal
        VParameters: TColStd_Array1OfReal
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal

        Returns
        -------
        InversionProblem: int
        Performs the interpolation of the data points given in the poles array. the collength cl and the length of uparameters must be the same. the length of vflatknots is vdegree + cl + 1. //! the rowlength rl and the length of vparameters must be the same. the length of vflatknots is degree + rl + 1. //! warning: the method used to do that interpolation is gauss elimination without pivoting. thus if the diagonal is not dominant there is no guarantee that the algorithm will work. nevertheless for cubic interpolation at knots or interpolation at scheonberg points the method will work. the inversionproblem will report 0 if there was no problem else it will give the index of the faulty pivot.

        Parameters
        ----------
        UDegree: int
        VDegree: int
        UFlatKnots: TColStd_Array1OfReal
        VFlatKnots: TColStd_Array1OfReal
        UParameters: TColStd_Array1OfReal
        VParameters: TColStd_Array1OfReal
        Poles: TColgp_Array2OfPnt

        Returns
        -------
        InversionProblem: int

        """
        return _BSplSLib.bsplslib_Interpolate(*args)

    @staticmethod
    def IsRational(*args) -> "Standard_Boolean":
        r"""
        Returns false if all the weights of the array <weights> in the area [i1,i2] * [j1,j2] are identic. epsilon is used for comparing weights. if epsilon is 0. the epsilon of the first weight is used.

        Parameters
        ----------
        Weights: TColStd_Array2OfReal
        I1: int
        I2: int
        J1: int
        J2: int
        Epsilon: float,optional
        	default value is 0.0

        Returns
        -------
        bool

        """
        return _BSplSLib.bsplslib_IsRational(*args)

    @staticmethod
    def Iso(*args) -> "void":
        r"""
        Computes the poles and weights of an isoparametric curve at parameter <param> (uiso if <isu> is true, viso else).

        Parameters
        ----------
        Param: float
        IsU: bool
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger *
        Degree: int
        Periodic: bool
        CPoles: TColgp_Array1OfPnt
        CWeights: TColStd_Array1OfReal *

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_Iso(*args)

    @staticmethod
    def MovePoint(*args) -> "Standard_Integer &, Standard_Integer &, Standard_Integer &, Standard_Integer &":
        r"""
        Find the new poles which allows an old point (with a given u,v as parameters) to reach a new position uindex1,uindex2 indicate the range of poles we can move for u (1, unbpoles-1) or (2, unbpoles) -> no constraint for one side in u (2, unbpoles-1) -> the ends are enforced for u don't enter (1,nbpoles) and (1,vnbpoles) -> error: rigid move if problem in bsplinebasis calculation, no change for the curve and ufirstindex, vlastindex = 0 vfirstindex, vlastindex = 0.

        Parameters
        ----------
        U: float
        V: float
        Displ: gp_Vec
        UIndex1: int
        UIndex2: int
        VIndex1: int
        VIndex2: int
        UDegree: int
        VDegree: int
        Rational: bool
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal
        UFlatKnots: TColStd_Array1OfReal
        VFlatKnots: TColStd_Array1OfReal
        NewPoles: TColgp_Array2OfPnt

        Returns
        -------
        UFirstIndex: int
        ULastIndex: int
        VFirstIndex: int
        VLastIndex: int

        """
        return _BSplSLib.bsplslib_MovePoint(*args)

    @staticmethod
    def NoWeights(*args) -> "TColStd_Array2OfReal *":
        r"""
        Used as argument for a non rational curve.

        Returns
        -------
        TColStd_Array2OfReal *

        """
        return _BSplSLib.bsplslib_NoWeights(*args)

    @staticmethod
    def PolesCoefficients(*args) -> "void":
        r"""
        Warning! to be used for beziersurfaces only!!!.

        Parameters
        ----------
        Poles: TColgp_Array2OfPnt
        CachePoles: TColgp_Array2OfPnt

        Returns
        -------
        None
        Encapsulation of buildcache to perform the evaluation of the taylor expansion for beziersurfaces at parameters 0.,0.; warning: to be used for beziersurfaces only!!!.

        Parameters
        ----------
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        CachePoles: TColgp_Array2OfPnt
        CacheWeights: TColStd_Array2OfReal *

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_PolesCoefficients(*args)

    @staticmethod
    def RationalDerivative(*args) -> "Standard_Real &, Standard_Real &":
        r"""
        This is a one dimensional function typedef void (*evaluatorfunction) ( standard_integer // derivative request standard_real * // startend[2][2] // [0] = u // [1] = v // [0] = start // [1] = end standard_real // uparameter standard_real // vparamerer standard_real & // result standard_integer &) ;// error code serves to multiply a given vectorial bspline by a function computes the derivatives of a ratio of two-variables functions x(u,v) / w(u,v) at orders <n,m>, x(u,v) is a vector in dimension <3>. //! <ders> is an array containing the values of the input derivatives from 0 to min(<n>,<udeg>), 0 to min(<m>,<vdeg>). for orders higher than <udeg,vdeg> the input derivatives are assumed to be 0. //! the <ders> is a 2d array and the dimension of the lines is always (<vdeg>+1) * (<3>+1), even if <n> is smaller than <udeg> (the derivatives higher than <n> are not used). //! content of <ders> : //! x(i,j)[k] means : the composant k of x derivated (i) times in u and (j) times in v. //! ... first line ... //! x[1],x[2],...,x[3],w x(0,1)[1],...,x(0,1)[3],w(1,0) ... x(0,vdeg)[1],...,x(0,vdeg)[3],w(0,vdeg) //! ... then second line ... //! x(1,0)[1],...,x(1,0)[3],w(1,0) x(1,1)[1],...,x(1,1)[3],w(1,1) ... x(1,vdeg)[1],...,x(1,vdeg)[3],w(1,vdeg) //! ... //! ... last line ... //! x(udeg,0)[1],...,x(udeg,0)[3],w(udeg,0) x(udeg,1)[1],...,x(udeg,1)[3],w(udeg,1) ... x(udeg,vdeg)[1],...,x(udeg,vdeg)[3],w(udeg,vdeg) //! if <all> is false, only the derivative at order <n,m> is computed. <rders> is an array of length 3 which will contain the result : //! x(1)/w , x(2)/w , ... derivated <n> <m> times //! if <all> is true multiples derivatives are computed. all the derivatives (i,j) with 0 <= i+j <= max(n,m) are computed. <rders> is an array of length 3 * (<n>+1) * (<m>+1) which will contains : //! x(1)/w , x(2)/w , ... x(1)/w , x(2)/w , ... derivated <0,1> times x(1)/w , x(2)/w , ... derivated <0,2> times ... x(1)/w , x(2)/w , ... derivated <0,n> times //! x(1)/w , x(2)/w , ... derivated <1,0> times x(1)/w , x(2)/w , ... derivated <1,1> times ... x(1)/w , x(2)/w , ... derivated <1,n> times //! x(1)/w , x(2)/w , ... derivated <n,0> times .... warning: <rders> must be dimensionned properly.

        Parameters
        ----------
        UDeg: int
        VDeg: int
        N: int
        M: int
        All: bool,optional
        	default value is Standard_True

        Returns
        -------
        Ders: float
        RDers: float

        """
        return _BSplSLib.bsplslib_RationalDerivative(*args)

    @staticmethod
    def RemoveKnot(*args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        UDirection: bool
        Index: int
        Mult: int
        Degree: int
        Periodic: bool
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        NewPoles: TColgp_Array2OfPnt
        NewWeights: TColStd_Array2OfReal *
        NewKnots: TColStd_Array1OfReal
        NewMults: TColStd_Array1OfInteger
        Tolerance: float

        Returns
        -------
        bool

        """
        return _BSplSLib.bsplslib_RemoveKnot(*args)

    @staticmethod
    def Resolution(*args) -> "Standard_Real &, Standard_Real &":
        r"""
        Given a tolerance in 3d space returns two tolerances, one in u one in v such that for all (u1,v1) and (u0,v0) in the domain of the surface f(u,v) we have : | u1 - u0 | < utolerance and | v1 - v0 | < vtolerance we have |f (u1,v1) - f (u0,v0)| < tolerance3d.

        Parameters
        ----------
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        UKnots: TColStd_Array1OfReal
        VKnots: TColStd_Array1OfReal
        UMults: TColStd_Array1OfInteger
        VMults: TColStd_Array1OfInteger
        UDegree: int
        VDegree: int
        URat: bool
        VRat: bool
        UPer: bool
        VPer: bool
        Tolerance3D: float

        Returns
        -------
        UTolerance: float
        VTolerance: float

        """
        return _BSplSLib.bsplslib_Resolution(*args)

    @staticmethod
    def Reverse(*args) -> "void":
        r"""
        Reverses the array of poles. last is the index of the new first row( col) of poles. on a non periodic surface last is poles.upper(). on a periodic curve last is (number of flat knots - degree - 1) or (sum of multiplicities(but for the last) + degree - 1).

        Parameters
        ----------
        Poles: TColgp_Array2OfPnt
        Last: int
        UDirection: bool

        Returns
        -------
        None
        Reverses the array of weights.

        Parameters
        ----------
        Weights: TColStd_Array2OfReal
        Last: int
        UDirection: bool

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_Reverse(*args)

    @staticmethod
    def SetPoles(*args) -> "void":
        r"""
        Copy in fp the coordinates of the poles.

        Parameters
        ----------
        Poles: TColgp_Array2OfPnt
        FP: TColStd_Array1OfReal
        UDirection: bool

        Returns
        -------
        None
        Copy in fp the coordinates of the poles.

        Parameters
        ----------
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal
        FP: TColStd_Array1OfReal
        UDirection: bool

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_SetPoles(*args)

    @staticmethod
    def Unperiodize(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        UDirection: bool
        Degree: int
        Mults: TColStd_Array1OfInteger
        Knots: TColStd_Array1OfReal
        Poles: TColgp_Array2OfPnt
        Weights: TColStd_Array2OfReal *
        NewMults: TColStd_Array1OfInteger
        NewKnots: TColStd_Array1OfReal
        NewPoles: TColgp_Array2OfPnt
        NewWeights: TColStd_Array2OfReal *

        Returns
        -------
        None

        """
        return _BSplSLib.bsplslib_Unperiodize(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _BSplSLib.bsplslib_swiginit(self, _BSplSLib.new_bsplslib())
    __swig_destroy__ = _BSplSLib.delete_bsplslib

# Register bsplslib in _BSplSLib:
_BSplSLib.bsplslib_swigregister(bsplslib)

def bsplslib_BuildCache(*args) -> "void":
    r"""
    Perform the evaluation of the taylor expansion of the bspline normalized between 0 and 1. if rational computes the homogeneous taylor expension for the numerator and stores it in cachepoles.

    Parameters
    ----------
    U: float
    V: float
    USpanDomain: float
    VSpanDomain: float
    UPeriodicFlag: bool
    VPeriodicFlag: bool
    UDegree: int
    VDegree: int
    UIndex: int
    VIndex: int
    UFlatKnots: TColStd_Array1OfReal
    VFlatKnots: TColStd_Array1OfReal
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    CachePoles: TColgp_Array2OfPnt
    CacheWeights: TColStd_Array2OfReal *

    Returns
    -------
    None
    Perform the evaluation of the taylor expansion of the bspline normalized between 0 and 1. structure of result optimized for bsplslib_cache.

    Parameters
    ----------
    theU: float
    theV: float
    theUSpanDomain: float
    theVSpanDomain: float
    theUPeriodic: bool
    theVPeriodic: bool
    theUDegree: int
    theVDegree: int
    theUIndex: int
    theVIndex: int
    theUFlatKnots: TColStd_Array1OfReal
    theVFlatKnots: TColStd_Array1OfReal
    thePoles: TColgp_Array2OfPnt
    theWeights: TColStd_Array2OfReal *
    theCacheArray: TColStd_Array2OfReal

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_BuildCache(*args)

def bsplslib_CacheD0(*args) -> "void":
    r"""
    Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights this just evaluates the current point the cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effects.

    Parameters
    ----------
    U: float
    V: float
    UDegree: int
    VDegree: int
    UCacheParameter: float
    VCacheParameter: float
    USpanLenght: float
    VSpanLength: float
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    Point: gp_Pnt

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_CacheD0(*args)

def bsplslib_CacheD1(*args) -> "void":
    r"""
    Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights this just evaluates the current point the cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effects.

    Parameters
    ----------
    U: float
    V: float
    UDegree: int
    VDegree: int
    UCacheParameter: float
    VCacheParameter: float
    USpanLenght: float
    VSpanLength: float
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    Point: gp_Pnt
    VecU: gp_Vec
    VecV: gp_Vec

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_CacheD1(*args)

def bsplslib_CacheD2(*args) -> "void":
    r"""
    Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights this just evaluates the current point the cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effects.

    Parameters
    ----------
    U: float
    V: float
    UDegree: int
    VDegree: int
    UCacheParameter: float
    VCacheParameter: float
    USpanLenght: float
    VSpanLength: float
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    Point: gp_Pnt
    VecU: gp_Vec
    VecV: gp_Vec
    VecUU: gp_Vec
    VecUV: gp_Vec
    VecVV: gp_Vec

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_CacheD2(*args)

def bsplslib_CoefsD0(*args) -> "void":
    r"""
    Calls cached0 for bezier surfaces arrays computed with the method polescoefficients. warning: to be used for beziersurfaces only!!!.

    Parameters
    ----------
    U: float
    V: float
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    Point: gp_Pnt

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_CoefsD0(*args)

def bsplslib_CoefsD1(*args) -> "void":
    r"""
    Calls cached0 for bezier surfaces arrays computed with the method polescoefficients. warning: to be used for beziersurfaces only!!!.

    Parameters
    ----------
    U: float
    V: float
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    Point: gp_Pnt
    VecU: gp_Vec
    VecV: gp_Vec

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_CoefsD1(*args)

def bsplslib_CoefsD2(*args) -> "void":
    r"""
    Calls cached0 for bezier surfaces arrays computed with the method polescoefficients. warning: to be used for beziersurfaces only!!!.

    Parameters
    ----------
    U: float
    V: float
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    Point: gp_Pnt
    VecU: gp_Vec
    VecV: gp_Vec
    VecUU: gp_Vec
    VecUV: gp_Vec
    VecVV: gp_Vec

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_CoefsD2(*args)

def bsplslib_D0(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    U: float
    V: float
    UIndex: int
    VIndex: int
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    UKnots: TColStd_Array1OfReal
    VKnots: TColStd_Array1OfReal
    UMults: TColStd_Array1OfInteger *
    VMults: TColStd_Array1OfInteger *
    UDegree: int
    VDegree: int
    URat: bool
    VRat: bool
    UPer: bool
    VPer: bool
    P: gp_Pnt

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_D0(*args)

def bsplslib_D1(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    U: float
    V: float
    UIndex: int
    VIndex: int
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    UKnots: TColStd_Array1OfReal
    VKnots: TColStd_Array1OfReal
    UMults: TColStd_Array1OfInteger *
    VMults: TColStd_Array1OfInteger *
    Degree: int
    VDegree: int
    URat: bool
    VRat: bool
    UPer: bool
    VPer: bool
    P: gp_Pnt
    Vu: gp_Vec
    Vv: gp_Vec

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_D1(*args)

def bsplslib_D2(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    U: float
    V: float
    UIndex: int
    VIndex: int
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    UKnots: TColStd_Array1OfReal
    VKnots: TColStd_Array1OfReal
    UMults: TColStd_Array1OfInteger *
    VMults: TColStd_Array1OfInteger *
    UDegree: int
    VDegree: int
    URat: bool
    VRat: bool
    UPer: bool
    VPer: bool
    P: gp_Pnt
    Vu: gp_Vec
    Vv: gp_Vec
    Vuu: gp_Vec
    Vvv: gp_Vec
    Vuv: gp_Vec

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_D2(*args)

def bsplslib_D3(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    U: float
    V: float
    UIndex: int
    VIndex: int
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    UKnots: TColStd_Array1OfReal
    VKnots: TColStd_Array1OfReal
    UMults: TColStd_Array1OfInteger *
    VMults: TColStd_Array1OfInteger *
    UDegree: int
    VDegree: int
    URat: bool
    VRat: bool
    UPer: bool
    VPer: bool
    P: gp_Pnt
    Vu: gp_Vec
    Vv: gp_Vec
    Vuu: gp_Vec
    Vvv: gp_Vec
    Vuv: gp_Vec
    Vuuu: gp_Vec
    Vvvv: gp_Vec
    Vuuv: gp_Vec
    Vuvv: gp_Vec

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_D3(*args)

def bsplslib_DN(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    U: float
    V: float
    Nu: int
    Nv: int
    UIndex: int
    VIndex: int
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    UKnots: TColStd_Array1OfReal
    VKnots: TColStd_Array1OfReal
    UMults: TColStd_Array1OfInteger *
    VMults: TColStd_Array1OfInteger *
    UDegree: int
    VDegree: int
    URat: bool
    VRat: bool
    UPer: bool
    VPer: bool
    Vn: gp_Vec

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_DN(*args)

def bsplslib_FunctionMultiply(*args) -> "Standard_Integer &":
    r"""
    This will multiply a given bspline numerator n(u,v) and denominator d(u,v) defined by its u/vbsplinedegree and u/vbsplineknots, and u/vmults. its poles and weights are arrays which are coded as array2 of the form [1..unumpoles][1..vnumpoles] by a function a(u,v) which is assumed to satisfy the following : 1. a(u,v) * n(u,v) and a(u,v) * d(u,v) is a polynomial bspline that can be expressed exactly as a bspline of degree u/vnewdegree on the knots u/vflatknots 2. the range of a(u,v) is the same as the range of n(u,v) or d(u,v) ---warning: it is the caller's responsibility to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method -- thestatus will return 0 if ok else it will return the pivot index -- of the matrix that was inverted to compute the multiplied -- bspline : the method used is interpolation at schoenenberg -- points of a(u,v)* n(u,v) and a(u,v) * d(u,v) thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of a(u,v)*f(u,v) --.

    Parameters
    ----------
    Function: BSplSLib_EvaluatorFunction
    UBSplineDegree: int
    VBSplineDegree: int
    UBSplineKnots: TColStd_Array1OfReal
    VBSplineKnots: TColStd_Array1OfReal
    UMults: TColStd_Array1OfInteger *
    VMults: TColStd_Array1OfInteger *
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    UFlatKnots: TColStd_Array1OfReal
    VFlatKnots: TColStd_Array1OfReal
    UNewDegree: int
    VNewDegree: int
    NewNumerator: TColgp_Array2OfPnt
    NewDenominator: TColStd_Array2OfReal

    Returns
    -------
    theStatus: int

    """
    return _BSplSLib.bsplslib_FunctionMultiply(*args)

def bsplslib_GetPoles(*args) -> "void":
    r"""
    Get from fp the coordinates of the poles.

    Parameters
    ----------
    FP: TColStd_Array1OfReal
    Poles: TColgp_Array2OfPnt
    UDirection: bool

    Returns
    -------
    None
    Get from fp the coordinates of the poles.

    Parameters
    ----------
    FP: TColStd_Array1OfReal
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal
    UDirection: bool

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_GetPoles(*args)

def bsplslib_HomogeneousD0(*args) -> "Standard_Real &":
    r"""
    Makes an homogeneous evaluation of poles and weights any and returns in p the numerator value and in w the denominator value if weights are present otherwise returns 1.0e0.

    Parameters
    ----------
    U: float
    V: float
    UIndex: int
    VIndex: int
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    UKnots: TColStd_Array1OfReal
    VKnots: TColStd_Array1OfReal
    UMults: TColStd_Array1OfInteger *
    VMults: TColStd_Array1OfInteger *
    UDegree: int
    VDegree: int
    URat: bool
    VRat: bool
    UPer: bool
    VPer: bool
    P: gp_Pnt

    Returns
    -------
    W: float

    """
    return _BSplSLib.bsplslib_HomogeneousD0(*args)

def bsplslib_HomogeneousD1(*args) -> "Standard_Real &, Standard_Real &, Standard_Real &":
    r"""
    Makes an homogeneous evaluation of poles and weights any and returns in p the numerator value and in w the denominator value if weights are present otherwise returns 1.0e0.

    Parameters
    ----------
    U: float
    V: float
    UIndex: int
    VIndex: int
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    UKnots: TColStd_Array1OfReal
    VKnots: TColStd_Array1OfReal
    UMults: TColStd_Array1OfInteger *
    VMults: TColStd_Array1OfInteger *
    UDegree: int
    VDegree: int
    URat: bool
    VRat: bool
    UPer: bool
    VPer: bool
    N: gp_Pnt
    Nu: gp_Vec
    Nv: gp_Vec

    Returns
    -------
    D: float
    Du: float
    Dv: float

    """
    return _BSplSLib.bsplslib_HomogeneousD1(*args)

def bsplslib_IncreaseDegree(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    UDirection: bool
    Degree: int
    NewDegree: int
    Periodic: bool
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    NewPoles: TColgp_Array2OfPnt
    NewWeights: TColStd_Array2OfReal *
    NewKnots: TColStd_Array1OfReal
    NewMults: TColStd_Array1OfInteger

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_IncreaseDegree(*args)

def bsplslib_InsertKnots(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    UDirection: bool
    Degree: int
    Periodic: bool
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    AddKnots: TColStd_Array1OfReal
    AddMults: TColStd_Array1OfInteger *
    NewPoles: TColgp_Array2OfPnt
    NewWeights: TColStd_Array2OfReal *
    NewKnots: TColStd_Array1OfReal
    NewMults: TColStd_Array1OfInteger
    Epsilon: float
    Add: bool,optional
    	default value is Standard_True

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_InsertKnots(*args)

def bsplslib_Interpolate(*args) -> "Standard_Integer &":
    r"""
    Performs the interpolation of the data points given in the poles array in the form [1,...,rl][1,...,rc][1...polesdimension] . the collength cl and the length of uparameters must be the same. the length of vflatknots is vdegree + cl + 1. //! the rowlength rl and the length of vparameters must be the same. the length of vflatknots is degree + rl + 1. //! warning: the method used to do that interpolation is gauss elimination without pivoting. thus if the diagonal is not dominant there is no guarantee that the algorithm will work. nevertheless for cubic interpolation at knots or interpolation at scheonberg points the method will work. the inversionproblem will report 0 if there was no problem else it will give the index of the faulty pivot.

    Parameters
    ----------
    UDegree: int
    VDegree: int
    UFlatKnots: TColStd_Array1OfReal
    VFlatKnots: TColStd_Array1OfReal
    UParameters: TColStd_Array1OfReal
    VParameters: TColStd_Array1OfReal
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal

    Returns
    -------
    InversionProblem: int
    Performs the interpolation of the data points given in the poles array. the collength cl and the length of uparameters must be the same. the length of vflatknots is vdegree + cl + 1. //! the rowlength rl and the length of vparameters must be the same. the length of vflatknots is degree + rl + 1. //! warning: the method used to do that interpolation is gauss elimination without pivoting. thus if the diagonal is not dominant there is no guarantee that the algorithm will work. nevertheless for cubic interpolation at knots or interpolation at scheonberg points the method will work. the inversionproblem will report 0 if there was no problem else it will give the index of the faulty pivot.

    Parameters
    ----------
    UDegree: int
    VDegree: int
    UFlatKnots: TColStd_Array1OfReal
    VFlatKnots: TColStd_Array1OfReal
    UParameters: TColStd_Array1OfReal
    VParameters: TColStd_Array1OfReal
    Poles: TColgp_Array2OfPnt

    Returns
    -------
    InversionProblem: int

    """
    return _BSplSLib.bsplslib_Interpolate(*args)

def bsplslib_IsRational(*args) -> "Standard_Boolean":
    r"""
    Returns false if all the weights of the array <weights> in the area [i1,i2] * [j1,j2] are identic. epsilon is used for comparing weights. if epsilon is 0. the epsilon of the first weight is used.

    Parameters
    ----------
    Weights: TColStd_Array2OfReal
    I1: int
    I2: int
    J1: int
    J2: int
    Epsilon: float,optional
    	default value is 0.0

    Returns
    -------
    bool

    """
    return _BSplSLib.bsplslib_IsRational(*args)

def bsplslib_Iso(*args) -> "void":
    r"""
    Computes the poles and weights of an isoparametric curve at parameter <param> (uiso if <isu> is true, viso else).

    Parameters
    ----------
    Param: float
    IsU: bool
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger *
    Degree: int
    Periodic: bool
    CPoles: TColgp_Array1OfPnt
    CWeights: TColStd_Array1OfReal *

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_Iso(*args)

def bsplslib_MovePoint(*args) -> "Standard_Integer &, Standard_Integer &, Standard_Integer &, Standard_Integer &":
    r"""
    Find the new poles which allows an old point (with a given u,v as parameters) to reach a new position uindex1,uindex2 indicate the range of poles we can move for u (1, unbpoles-1) or (2, unbpoles) -> no constraint for one side in u (2, unbpoles-1) -> the ends are enforced for u don't enter (1,nbpoles) and (1,vnbpoles) -> error: rigid move if problem in bsplinebasis calculation, no change for the curve and ufirstindex, vlastindex = 0 vfirstindex, vlastindex = 0.

    Parameters
    ----------
    U: float
    V: float
    Displ: gp_Vec
    UIndex1: int
    UIndex2: int
    VIndex1: int
    VIndex2: int
    UDegree: int
    VDegree: int
    Rational: bool
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal
    UFlatKnots: TColStd_Array1OfReal
    VFlatKnots: TColStd_Array1OfReal
    NewPoles: TColgp_Array2OfPnt

    Returns
    -------
    UFirstIndex: int
    ULastIndex: int
    VFirstIndex: int
    VLastIndex: int

    """
    return _BSplSLib.bsplslib_MovePoint(*args)

def bsplslib_NoWeights(*args) -> "TColStd_Array2OfReal *":
    r"""
    Used as argument for a non rational curve.

    Returns
    -------
    TColStd_Array2OfReal *

    """
    return _BSplSLib.bsplslib_NoWeights(*args)

def bsplslib_PolesCoefficients(*args) -> "void":
    r"""
    Warning! to be used for beziersurfaces only!!!.

    Parameters
    ----------
    Poles: TColgp_Array2OfPnt
    CachePoles: TColgp_Array2OfPnt

    Returns
    -------
    None
    Encapsulation of buildcache to perform the evaluation of the taylor expansion for beziersurfaces at parameters 0.,0.; warning: to be used for beziersurfaces only!!!.

    Parameters
    ----------
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    CachePoles: TColgp_Array2OfPnt
    CacheWeights: TColStd_Array2OfReal *

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_PolesCoefficients(*args)

def bsplslib_RationalDerivative(*args) -> "Standard_Real &, Standard_Real &":
    r"""
    This is a one dimensional function typedef void (*evaluatorfunction) ( standard_integer // derivative request standard_real * // startend[2][2] // [0] = u // [1] = v // [0] = start // [1] = end standard_real // uparameter standard_real // vparamerer standard_real & // result standard_integer &) ;// error code serves to multiply a given vectorial bspline by a function computes the derivatives of a ratio of two-variables functions x(u,v) / w(u,v) at orders <n,m>, x(u,v) is a vector in dimension <3>. //! <ders> is an array containing the values of the input derivatives from 0 to min(<n>,<udeg>), 0 to min(<m>,<vdeg>). for orders higher than <udeg,vdeg> the input derivatives are assumed to be 0. //! the <ders> is a 2d array and the dimension of the lines is always (<vdeg>+1) * (<3>+1), even if <n> is smaller than <udeg> (the derivatives higher than <n> are not used). //! content of <ders> : //! x(i,j)[k] means : the composant k of x derivated (i) times in u and (j) times in v. //! ... first line ... //! x[1],x[2],...,x[3],w x(0,1)[1],...,x(0,1)[3],w(1,0) ... x(0,vdeg)[1],...,x(0,vdeg)[3],w(0,vdeg) //! ... then second line ... //! x(1,0)[1],...,x(1,0)[3],w(1,0) x(1,1)[1],...,x(1,1)[3],w(1,1) ... x(1,vdeg)[1],...,x(1,vdeg)[3],w(1,vdeg) //! ... //! ... last line ... //! x(udeg,0)[1],...,x(udeg,0)[3],w(udeg,0) x(udeg,1)[1],...,x(udeg,1)[3],w(udeg,1) ... x(udeg,vdeg)[1],...,x(udeg,vdeg)[3],w(udeg,vdeg) //! if <all> is false, only the derivative at order <n,m> is computed. <rders> is an array of length 3 which will contain the result : //! x(1)/w , x(2)/w , ... derivated <n> <m> times //! if <all> is true multiples derivatives are computed. all the derivatives (i,j) with 0 <= i+j <= max(n,m) are computed. <rders> is an array of length 3 * (<n>+1) * (<m>+1) which will contains : //! x(1)/w , x(2)/w , ... x(1)/w , x(2)/w , ... derivated <0,1> times x(1)/w , x(2)/w , ... derivated <0,2> times ... x(1)/w , x(2)/w , ... derivated <0,n> times //! x(1)/w , x(2)/w , ... derivated <1,0> times x(1)/w , x(2)/w , ... derivated <1,1> times ... x(1)/w , x(2)/w , ... derivated <1,n> times //! x(1)/w , x(2)/w , ... derivated <n,0> times .... warning: <rders> must be dimensionned properly.

    Parameters
    ----------
    UDeg: int
    VDeg: int
    N: int
    M: int
    All: bool,optional
    	default value is Standard_True

    Returns
    -------
    Ders: float
    RDers: float

    """
    return _BSplSLib.bsplslib_RationalDerivative(*args)

def bsplslib_RemoveKnot(*args) -> "Standard_Boolean":
    r"""
    No available documentation.

    Parameters
    ----------
    UDirection: bool
    Index: int
    Mult: int
    Degree: int
    Periodic: bool
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    NewPoles: TColgp_Array2OfPnt
    NewWeights: TColStd_Array2OfReal *
    NewKnots: TColStd_Array1OfReal
    NewMults: TColStd_Array1OfInteger
    Tolerance: float

    Returns
    -------
    bool

    """
    return _BSplSLib.bsplslib_RemoveKnot(*args)

def bsplslib_Resolution(*args) -> "Standard_Real &, Standard_Real &":
    r"""
    Given a tolerance in 3d space returns two tolerances, one in u one in v such that for all (u1,v1) and (u0,v0) in the domain of the surface f(u,v) we have : | u1 - u0 | < utolerance and | v1 - v0 | < vtolerance we have |f (u1,v1) - f (u0,v0)| < tolerance3d.

    Parameters
    ----------
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    UKnots: TColStd_Array1OfReal
    VKnots: TColStd_Array1OfReal
    UMults: TColStd_Array1OfInteger
    VMults: TColStd_Array1OfInteger
    UDegree: int
    VDegree: int
    URat: bool
    VRat: bool
    UPer: bool
    VPer: bool
    Tolerance3D: float

    Returns
    -------
    UTolerance: float
    VTolerance: float

    """
    return _BSplSLib.bsplslib_Resolution(*args)

def bsplslib_Reverse(*args) -> "void":
    r"""
    Reverses the array of poles. last is the index of the new first row( col) of poles. on a non periodic surface last is poles.upper(). on a periodic curve last is (number of flat knots - degree - 1) or (sum of multiplicities(but for the last) + degree - 1).

    Parameters
    ----------
    Poles: TColgp_Array2OfPnt
    Last: int
    UDirection: bool

    Returns
    -------
    None
    Reverses the array of weights.

    Parameters
    ----------
    Weights: TColStd_Array2OfReal
    Last: int
    UDirection: bool

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_Reverse(*args)

def bsplslib_SetPoles(*args) -> "void":
    r"""
    Copy in fp the coordinates of the poles.

    Parameters
    ----------
    Poles: TColgp_Array2OfPnt
    FP: TColStd_Array1OfReal
    UDirection: bool

    Returns
    -------
    None
    Copy in fp the coordinates of the poles.

    Parameters
    ----------
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal
    FP: TColStd_Array1OfReal
    UDirection: bool

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_SetPoles(*args)

def bsplslib_Unperiodize(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    UDirection: bool
    Degree: int
    Mults: TColStd_Array1OfInteger
    Knots: TColStd_Array1OfReal
    Poles: TColgp_Array2OfPnt
    Weights: TColStd_Array2OfReal *
    NewMults: TColStd_Array1OfInteger
    NewKnots: TColStd_Array1OfReal
    NewPoles: TColgp_Array2OfPnt
    NewWeights: TColStd_Array2OfReal *

    Returns
    -------
    None

    """
    return _BSplSLib.bsplslib_Unperiodize(*args)

class BSplSLib_Cache(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor for caching of the span for the surface \param thedegreeu degree along the first parameter (u) of the surface \param theperiodicu identify the surface is periodical along u axis \param theflatknotsu knots of the surface (with repetition) along u axis \param thedegreev degree alogn the second parameter (v) of the surface \param theperiodicv identify the surface is periodical along v axis \param theflatknotsv knots of the surface (with repetition) along v axis \param theweights array of weights of corresponding poles.

        Parameters
        ----------
        theDegreeU: int
        thePeriodicU: bool
        theFlatKnotsU: TColStd_Array1OfReal
        theDegreeV: int
        thePeriodicV: bool
        theFlatKnotsV: TColStd_Array1OfReal
        theWeights: TColStd_Array2OfReal *,optional
        	default value is NULL

        Returns
        -------
        None

        """
        _BSplSLib.BSplSLib_Cache_swiginit(self, _BSplSLib.new_BSplSLib_Cache(*args))

    def BuildCache(self, *args) -> "void":
        r"""
        Recomputes the cache data. does not verify validity of the cache \param theparameteru the parametric value on the u axis to identify the span \param theparameterv the parametric value on the v axis to identify the span \param thedegreeu degree along u axis \param theperiodicu identify whether the surface is periodic along u axis \param theflatknotsu flat knots of the surface along u axis \param thedegreev degree along v axis \param theperiodicv identify whether the surface is periodic along v axis \param theflatknotsv flat knots of the surface along v axis \param thepoles array of poles of the surface \param theweights array of weights of corresponding poles.

        Parameters
        ----------
        theParameterU: float
        theParameterV: float
        theFlatKnotsU: TColStd_Array1OfReal
        theFlatKnotsV: TColStd_Array1OfReal
        thePoles: TColgp_Array2OfPnt
        theWeights: TColStd_Array2OfReal *,optional
        	default value is NULL

        Returns
        -------
        None

        """
        return _BSplSLib.BSplSLib_Cache_BuildCache(self, *args)

    def D0(self, *args) -> "void":
        r"""
        Calculates the point on the surface for specified parameters \param[in] theu first parameter for calculation of the value \param[in] thev second parameter for calculation of the value \param[out] thepoint the result of calculation (the point on the surface).

        Parameters
        ----------
        theU: float
        theV: float
        thePoint: gp_Pnt

        Returns
        -------
        None

        """
        return _BSplSLib.BSplSLib_Cache_D0(self, *args)

    def D1(self, *args) -> "void":
        r"""
        Calculates the point on the surface and its first derivative \param[in] theu first parameter of calculation of the value \param[in] thev second parameter of calculation of the value \param[out] thepoint the result of calculation (the point on the surface) \param[out] thetangentu tangent vector along u axis in the calculated point \param[out] thetangentv tangent vector along v axis in the calculated point.

        Parameters
        ----------
        theU: float
        theV: float
        thePoint: gp_Pnt
        theTangentU: gp_Vec
        theTangentV: gp_Vec

        Returns
        -------
        None

        """
        return _BSplSLib.BSplSLib_Cache_D1(self, *args)

    def D2(self, *args) -> "void":
        r"""
        Calculates the point on the surface and derivatives till second order \param[in] theu first parameter of calculation of the value \param[in] thev second parameter of calculation of the value \param[out] thepoint the result of calculation (the point on the surface) \param[out] thetangentu tangent vector along u axis in the calculated point \param[out] thetangentv tangent vector along v axis in the calculated point \param[out] thecurvatureu curvature vector (2nd derivative on u) along u axis \param[out] thecurvaturev curvature vector (2nd derivative on v) along v axis \param[out] thecurvatureuv 2nd mixed derivative on u anv v.

        Parameters
        ----------
        theU: float
        theV: float
        thePoint: gp_Pnt
        theTangentU: gp_Vec
        theTangentV: gp_Vec
        theCurvatureU: gp_Vec
        theCurvatureV: gp_Vec
        theCurvatureUV: gp_Vec

        Returns
        -------
        None

        """
        return _BSplSLib.BSplSLib_Cache_D2(self, *args)

    def IsCacheValid(self, *args) -> "Standard_Boolean":
        r"""
        Verifies validity of the cache using parameters of the point \param theparameteru first parameter of the point placed in the span \param theparameterv second parameter of the point placed in the span.

        Parameters
        ----------
        theParameterU: float
        theParameterV: float

        Returns
        -------
        bool

        """
        return _BSplSLib.BSplSLib_Cache_IsCacheValid(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BSplSLib_Cache_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BSplSLib.delete_BSplSLib_Cache

# Register BSplSLib_Cache in _BSplSLib:
_BSplSLib.BSplSLib_Cache_swigregister(BSplSLib_Cache)

class BSplSLib_EvaluatorFunction(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Evaluate(self, *args) -> "void":
        r"""
        Function evaluation method to be defined by descendant.

        Parameters
        ----------
        theDerivativeRequest: int
        theUParameter: float
        theVParameter: float

        Returns
        -------
        theResult: float
        theErrorCode: int

        """
        return _BSplSLib.BSplSLib_EvaluatorFunction_Evaluate(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BSplSLib.delete_BSplSLib_EvaluatorFunction

# Register BSplSLib_EvaluatorFunction in _BSplSLib:
_BSplSLib.BSplSLib_EvaluatorFunction_swigregister(BSplSLib_EvaluatorFunction)





