# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
GC module, see official documentation at
https://www.opencascade.com/doc/occt-7.6.0/refman/html/package_gc.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _GC
else:
    import _GC

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _GC.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _GC.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _GC.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _GC.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _GC.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _GC.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _GC.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _GC.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _GC.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _GC.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _GC.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _GC.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _GC.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _GC.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _GC.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _GC.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _GC.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _GC:
_GC.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _GC.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.Geom
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.gce

from enum import IntEnum
from OCC.Core.Exception import *



class GC_MakeMirror(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Point: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Axis: gp_Ax1

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Line: gp_Lin

        Returns
        -------
        None
        Make a symmetry transformation af axis defined by <point> and <direc>.

        Parameters
        ----------
        Point: gp_Pnt
        Direc: gp_Dir

        Returns
        -------
        None
        Make a symmetry transformation of plane <plane>.

        Parameters
        ----------
        Plane: gp_Pln

        Returns
        -------
        None
        Make a symmetry transformation of plane <plane>.

        Parameters
        ----------
        Plane: gp_Ax2

        Returns
        -------
        None

        """
        _GC.GC_MakeMirror_swiginit(self, _GC.new_GC_MakeMirror(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_Transformation > const &":
        r"""
        Returns the constructed transformation.

        Returns
        -------
        opencascade::handle<Geom_Transformation>

        """
        return _GC.GC_MakeMirror_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakeMirror

# Register GC_MakeMirror in _GC:
_GC.GC_MakeMirror_swigregister(GC_MakeMirror)

class GC_MakeRotation(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs a rotation through angle angle about the axis defined by the line line.

        Parameters
        ----------
        Line: gp_Lin
        Angle: float

        Returns
        -------
        None
        Constructs a rotation through angle angle about the axis defined by the axis axis.

        Parameters
        ----------
        Axis: gp_Ax1
        Angle: float

        Returns
        -------
        None
        Constructs a rotation through angle angle about the axis defined by the point point and the unit vector direc.

        Parameters
        ----------
        Point: gp_Pnt
        Direc: gp_Dir
        Angle: float

        Returns
        -------
        None

        """
        _GC.GC_MakeRotation_swiginit(self, _GC.new_GC_MakeRotation(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_Transformation > const &":
        r"""
        Returns the constructed transformation.

        Returns
        -------
        opencascade::handle<Geom_Transformation>

        """
        return _GC.GC_MakeRotation_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakeRotation

# Register GC_MakeRotation in _GC:
_GC.GC_MakeRotation_swigregister(GC_MakeRotation)

class GC_MakeScale(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs a scaling transformation with - point as the center of the transformation, and - scale as the scale factor.

        Parameters
        ----------
        Point: gp_Pnt
        Scale: float

        Returns
        -------
        None

        """
        _GC.GC_MakeScale_swiginit(self, _GC.new_GC_MakeScale(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_Transformation > const &":
        r"""
        Returns the constructed transformation.

        Returns
        -------
        opencascade::handle<Geom_Transformation>

        """
        return _GC.GC_MakeScale_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakeScale

# Register GC_MakeScale in _GC:
_GC.GC_MakeScale_swigregister(GC_MakeScale)

class GC_MakeTranslation(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs a translation along the vector ' vect '.

        Parameters
        ----------
        Vect: gp_Vec

        Returns
        -------
        None
        Constructs a translation along the vector (point1,point2) defined from the point point1 to the point point2.

        Parameters
        ----------
        Point1: gp_Pnt
        Point2: gp_Pnt

        Returns
        -------
        None

        """
        _GC.GC_MakeTranslation_swiginit(self, _GC.new_GC_MakeTranslation(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_Transformation > const &":
        r"""
        Returns the constructed transformation.

        Returns
        -------
        opencascade::handle<Geom_Transformation>

        """
        return _GC.GC_MakeTranslation_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakeTranslation

# Register GC_MakeTranslation in _GC:
_GC.GC_MakeTranslation_swigregister(GC_MakeTranslation)

class GC_Root(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the construction is successful.

        Returns
        -------
        bool

        """
        return _GC.GC_Root_IsDone(self, *args)

    def Status(self, *args) -> "gce_ErrorType":
        r"""
        Returns the status of the construction: - gce_done, if the construction is successful, or - another value of the gce_errortype enumeration indicating why the construction failed.

        Returns
        -------
        gce_ErrorType

        """
        return _GC.GC_Root_Status(self, *args)

    __repr__ = _dumps_object


    def __init__(self):
        _GC.GC_Root_swiginit(self, _GC.new_GC_Root())
    __swig_destroy__ = _GC.delete_GC_Root

# Register GC_Root in _GC:
_GC.GC_Root_swigregister(GC_Root)

class GC_MakeArcOfCircle(GC_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Make an arc of circle (trimmedcurve from geom) from a circle between two angles alpha1 and alpha2 given in radiians.

        Parameters
        ----------
        Circ: gp_Circ
        Alpha1: float
        Alpha2: float
        Sense: bool

        Returns
        -------
        None
        Make an arc of circle (trimmedcurve from geom) from a circle between point <p> and the angle alpha given in radians.

        Parameters
        ----------
        Circ: gp_Circ
        P: gp_Pnt
        Alpha: float
        Sense: bool

        Returns
        -------
        None
        Make an arc of circle (trimmedcurve from geom) from a circle between two points p1 and p2.

        Parameters
        ----------
        Circ: gp_Circ
        P1: gp_Pnt
        P2: gp_Pnt
        Sense: bool

        Returns
        -------
        None
        Make an arc of circle (trimmedcurve from geom) from three points p1,p2,p3 between two points p1 and p2.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt

        Returns
        -------
        None
        Make an arc of circle (trimmedcurve from geom) from two points p1,p2 and the tangente to the solution at the point p1. the orientation of the arc is: - the sense determined by the order of the points p1, p3 and p2; - the sense defined by the vector v; or - for other syntaxes: - the sense of circ if sense is true, or - the opposite sense if sense is false. note: alpha1, alpha2 and alpha are angle values, given in radians. warning if an error occurs (that is, when isdone returns false), the status function returns: - gce_confusedpoints if: - any 2 of the 3 points p1, p2 and p3 are coincident, or - p1 and p2 are coincident; or - gce_intersectionerror if: - p1, p2 and p3 are collinear and not coincident, or - the vector defined by the points p1 and p2 is collinear with the vector v.

        Parameters
        ----------
        P1: gp_Pnt
        V: gp_Vec
        P2: gp_Pnt

        Returns
        -------
        None

        """
        _GC.GC_MakeArcOfCircle_swiginit(self, _GC.new_GC_MakeArcOfCircle(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_TrimmedCurve > const &":
        r"""
        Returns the constructed arc of circle. exceptions stdfail_notdone if no arc of circle is constructed.

        Returns
        -------
        opencascade::handle<Geom_TrimmedCurve>

        """
        return _GC.GC_MakeArcOfCircle_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakeArcOfCircle

# Register GC_MakeArcOfCircle in _GC:
_GC.GC_MakeArcOfCircle_swigregister(GC_MakeArcOfCircle)

class GC_MakeArcOfEllipse(GC_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an arc of ellipse (trimmedcurve from geom) from a ellipse between two parameters alpha1 and alpha2.

        Parameters
        ----------
        Elips: gp_Elips
        Alpha1: float
        Alpha2: float
        Sense: bool

        Returns
        -------
        None
        Constructs an arc of ellipse (trimmedcurve from geom) from a ellipse between point <p> and the angle alpha given in radians.

        Parameters
        ----------
        Elips: gp_Elips
        P: gp_Pnt
        Alpha: float
        Sense: bool

        Returns
        -------
        None
        Constructs an arc of ellipse (trimmedcurve from geom) from a ellipse between two points p1 and p2. the orientation of the arc of ellipse is: - the sense of elips if sense is true, or - the opposite sense if sense is false. notes: - alpha1, alpha2 and alpha are angle values, given in radians. - isdone always returns true.

        Parameters
        ----------
        Elips: gp_Elips
        P1: gp_Pnt
        P2: gp_Pnt
        Sense: bool

        Returns
        -------
        None

        """
        _GC.GC_MakeArcOfEllipse_swiginit(self, _GC.new_GC_MakeArcOfEllipse(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_TrimmedCurve > const &":
        r"""
        Returns the constructed arc of ellipse.

        Returns
        -------
        opencascade::handle<Geom_TrimmedCurve>

        """
        return _GC.GC_MakeArcOfEllipse_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakeArcOfEllipse

# Register GC_MakeArcOfEllipse in _GC:
_GC.GC_MakeArcOfEllipse_swigregister(GC_MakeArcOfEllipse)

class GC_MakeArcOfHyperbola(GC_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an arc of hyperbola (trimmedcurve from geom) from a hyperbola between two parameters alpha1 and alpha2 (given in radians).

        Parameters
        ----------
        Hypr: gp_Hypr
        Alpha1: float
        Alpha2: float
        Sense: bool

        Returns
        -------
        None
        Creates an arc of hyperbola (trimmedcurve from geom) from a hyperbola between point <p> and the parameter alpha (given in radians).

        Parameters
        ----------
        Hypr: gp_Hypr
        P: gp_Pnt
        Alpha: float
        Sense: bool

        Returns
        -------
        None
        Creates an arc of hyperbola (trimmedcurve from geom) from a hyperbola between two points p1 and p2. the orientation of the arc of hyperbola is: - the sense of hypr if sense is true, or - the opposite sense if sense is false.

        Parameters
        ----------
        Hypr: gp_Hypr
        P1: gp_Pnt
        P2: gp_Pnt
        Sense: bool

        Returns
        -------
        None

        """
        _GC.GC_MakeArcOfHyperbola_swiginit(self, _GC.new_GC_MakeArcOfHyperbola(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_TrimmedCurve > const &":
        r"""
        Returns the constructed arc of hyperbola.

        Returns
        -------
        opencascade::handle<Geom_TrimmedCurve>

        """
        return _GC.GC_MakeArcOfHyperbola_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakeArcOfHyperbola

# Register GC_MakeArcOfHyperbola in _GC:
_GC.GC_MakeArcOfHyperbola_swigregister(GC_MakeArcOfHyperbola)

class GC_MakeArcOfParabola(GC_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an arc of parabola (trimmedcurve from geom) from a parabola between two parameters alpha1 and alpha2 (given in radians).

        Parameters
        ----------
        Parab: gp_Parab
        Alpha1: float
        Alpha2: float
        Sense: bool

        Returns
        -------
        None
        Creates an arc of parabola (trimmedcurve from geom) from a parabola between point <p> and the parameter alpha (given in radians).

        Parameters
        ----------
        Parab: gp_Parab
        P: gp_Pnt
        Alpha: float
        Sense: bool

        Returns
        -------
        None
        Creates an arc of parabola (trimmedcurve from geom) from a parabola between two points p1 and p2.

        Parameters
        ----------
        Parab: gp_Parab
        P1: gp_Pnt
        P2: gp_Pnt
        Sense: bool

        Returns
        -------
        None

        """
        _GC.GC_MakeArcOfParabola_swiginit(self, _GC.new_GC_MakeArcOfParabola(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_TrimmedCurve > const &":
        r"""
        Returns the constructed arc of parabola.

        Returns
        -------
        opencascade::handle<Geom_TrimmedCurve>

        """
        return _GC.GC_MakeArcOfParabola_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakeArcOfParabola

# Register GC_MakeArcOfParabola in _GC:
_GC.GC_MakeArcOfParabola_swigregister(GC_MakeArcOfParabola)

class GC_MakeCircle(GC_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a circle from a non persistent circle c by its conversion.

        Parameters
        ----------
        C: gp_Circ

        Returns
        -------
        None
        A2 is the local coordinates system of the circle. it is not forbidden to create a circle with radius = 0.0 status is 'negativeradius' if radius < 0.

        Parameters
        ----------
        A2: gp_Ax2
        Radius: float

        Returns
        -------
        None
        Make a circle from geom <thecirc> parallel to another circ <circ> with a distance <dist>. if dist is greater than zero the result is enclosing the circle <circ>, else the result is enclosed by the circle <circ>.

        Parameters
        ----------
        Circ: gp_Circ
        Dist: float

        Returns
        -------
        None
        Make a circle from geom <thecirc> parallel to another circ <circ> and passing through a pnt <point>.

        Parameters
        ----------
        Circ: gp_Circ
        Point: gp_Pnt

        Returns
        -------
        None
        Make a circ from gp <thecirc> passing through 3 pnt2d <p1>,<p2>,<p3>.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt

        Returns
        -------
        None
        Make a circle from geom <thecirc> with its center <center> and the normal of its plane <norm> and its radius <radius>.

        Parameters
        ----------
        Center: gp_Pnt
        Norm: gp_Dir
        Radius: float

        Returns
        -------
        None
        Make a circle from geom <thecirc> with its center <center> and the normal of its plane defined by the two points <center> and <ptaxis> and its radius <radius>.

        Parameters
        ----------
        Center: gp_Pnt
        PtAxis: gp_Pnt
        Radius: float

        Returns
        -------
        None
        Make a circle from geom <thecirc> with its center <center> and its radius <radius>.

        Parameters
        ----------
        Axis: gp_Ax1
        Radius: float

        Returns
        -------
        None

        """
        _GC.GC_MakeCircle_swiginit(self, _GC.new_GC_MakeCircle(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_Circle > const &":
        r"""
        Returns the constructed circle. exceptions stdfail_notdone if no circle is constructed.

        Returns
        -------
        opencascade::handle<Geom_Circle>

        """
        return _GC.GC_MakeCircle_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakeCircle

# Register GC_MakeCircle in _GC:
_GC.GC_MakeCircle_swigregister(GC_MakeCircle)

class GC_MakeConicalSurface(GC_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        A2 defines the local coordinate system of the conical surface. ang is the conical surface semi-angle ]0, pi/2[. radius is the radius of the circle viso in the placement plane of the conical surface defined with 'xaxis' and 'yaxis'. the 'zdirection' of a2 defines the direction of the surface's axis of symmetry. if the location point of a2 is the apex of the surface radius = 0 . at the creation the parametrization of the surface is defined such that the normal vector (n = d1u ^ d1v) is oriented towards the 'outside region' of the surface. status is 'negativeradius' if radius < 0.0 or 'badangle' if ang < resolution from gp or ang >= pi/ - resolution.

        Parameters
        ----------
        A2: gp_Ax2
        Ang: float
        Radius: float

        Returns
        -------
        None
        Creates a conicalsurface from a non persistent cone from package gp.

        Parameters
        ----------
        C: gp_Cone

        Returns
        -------
        None
        Make a conicalsurface from geom <thecone> passing through 3 pnt <p1>,<p2>,<p3>. its axis is <p1p2> and the radius of its base is the distance between <p3> and <p1p2>. the distance between <p4> and <p1p2> is the radius of the section passing through <p4>. an error iss raised if <p1>,<p2>,<p3>,<p4> are colinear or if <p3p4> is perpendicular to <p1p2> or <p3p4> is colinear to <p1p2>.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt
        P4: gp_Pnt

        Returns
        -------
        None
        Make a conicalsurface with two points and two radius. the axis of the solution is the line passing through <p1> and <p2>. <r1> is the radius of the section passing through <p1> and <r2> the radius of the section passing through <p2>.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        R1: float
        R2: float

        Returns
        -------
        None

        """
        _GC.GC_MakeConicalSurface_swiginit(self, _GC.new_GC_MakeConicalSurface(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_ConicalSurface > const &":
        r"""
        Returns the constructed cone. exceptions stdfail_notdone if no cone is constructed.

        Returns
        -------
        opencascade::handle<Geom_ConicalSurface>

        """
        return _GC.GC_MakeConicalSurface_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakeConicalSurface

# Register GC_MakeConicalSurface in _GC:
_GC.GC_MakeConicalSurface_swigregister(GC_MakeConicalSurface)

class GC_MakeCylindricalSurface(GC_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        A2 defines the local coordinate system of the cylindrical surface. the 'zdirection' of a2 defines the direction of the surface's axis of symmetry. at the creation the parametrization of the surface is defined such that the normal vector (n = d1u ^ d1v) is oriented towards the 'outside region' of the surface. warnings : it is not forbidden to create a cylindrical surface with radius = 0.0 status is 'negativeradius' if radius < 0.0.

        Parameters
        ----------
        A2: gp_Ax2
        Radius: float

        Returns
        -------
        None
        Creates a cylindricalsurface from a non persistent cylinder from package gp.

        Parameters
        ----------
        C: gp_Cylinder

        Returns
        -------
        None
        Make a cylindricalsurface from geom <thecylinder> parallel to another cylindricalsurface <cylinder> and passing through a pnt <point>.

        Parameters
        ----------
        Cyl: gp_Cylinder
        Point: gp_Pnt

        Returns
        -------
        None
        Make a cylindricalsurface from geom <thecylinder> parallel to another cylindricalsurface <cylinder> at the distance <dist> which can be greater or lower than zero. the radius of the result is the absolute value of the radius of <cyl> plus <dist>.

        Parameters
        ----------
        Cyl: gp_Cylinder
        Dist: float

        Returns
        -------
        None
        Make a cylindricalsurface from geom <thecylinder> passing through 3 pnt <p1>,<p2>,<p3>. its axis is <p1p2> and its radius is the distance between <p3> and <p1p2>.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt

        Returns
        -------
        None
        Make a cylindricalsurface by its axis <axis> and radius <radius>.

        Parameters
        ----------
        Axis: gp_Ax1
        Radius: float

        Returns
        -------
        None
        Make a cylindricalsurface by its circular base.

        Parameters
        ----------
        Circ: gp_Circ

        Returns
        -------
        None

        """
        _GC.GC_MakeCylindricalSurface_swiginit(self, _GC.new_GC_MakeCylindricalSurface(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_CylindricalSurface > const &":
        r"""
        Returns the constructed cylinder. exceptions stdfail_notdone if no cylinder is constructed.

        Returns
        -------
        opencascade::handle<Geom_CylindricalSurface>

        """
        return _GC.GC_MakeCylindricalSurface_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakeCylindricalSurface

# Register GC_MakeCylindricalSurface in _GC:
_GC.GC_MakeCylindricalSurface_swigregister(GC_MakeCylindricalSurface)

class GC_MakeEllipse(GC_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an ellipse from a non persistent ellipse e from package gp by its conversion.

        Parameters
        ----------
        E: gp_Elips

        Returns
        -------
        None
        Constructs an ellipse with major and minor radii majorradius and minorradius, and located in the plane defined by the 'x axis' and 'y axis' of the coordinate system a2, where: - its center is the origin of a2, and - its major axis is the 'x axis' of a2; warnings : the makeellipse class does not prevent the construction of an ellipse where majorradius is equal to minorradius. if an error occurs (that is, when isdone returns false), the status function returns: - gce_invertradius if majorradius is less than minorradius; - gce_negativeradius if minorradius is less than 0.0; - gce_nullaxis if the points s1 and center are coincident; or - gce_invertaxis if: - the major radius computed with center and s1 is less than the minor radius computed with center, s1 and s2, or - center, s1 and s2 are collinear.

        Parameters
        ----------
        A2: gp_Ax2
        MajorRadius: float
        MinorRadius: float

        Returns
        -------
        None
        Constructs an ellipse centered on the point center, where - the plane of the ellipse is defined by center, s1 and s2, - its major axis is defined by center and s1, - its major radius is the distance between center and s1, and - its minor radius is the distance between s2 and the major axis.

        Parameters
        ----------
        S1: gp_Pnt
        S2: gp_Pnt
        Center: gp_Pnt

        Returns
        -------
        None

        """
        _GC.GC_MakeEllipse_swiginit(self, _GC.new_GC_MakeEllipse(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_Ellipse > const &":
        r"""
        Returns the constructed ellipse. exceptions stdfail_notdone if no ellipse is constructed.

        Returns
        -------
        opencascade::handle<Geom_Ellipse>

        """
        return _GC.GC_MakeEllipse_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakeEllipse

# Register GC_MakeEllipse in _GC:
_GC.GC_MakeEllipse_swigregister(GC_MakeEllipse)

class GC_MakeHyperbola(GC_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an hyperbola from a non persistent hyperbola from package gp by conversion.

        Parameters
        ----------
        H: gp_Hypr

        Returns
        -------
        None
        Constructs a hyperbola centered on the origin of the coordinate system a2, with major and minor radii majorradius and minorradius, where: the plane of the hyperbola is defined by the 'x axis' and 'y axis' of a2, - its major axis is the 'x axis' of a2.

        Parameters
        ----------
        A2: gp_Ax2
        MajorRadius: float
        MinorRadius: float

        Returns
        -------
        None
        Constructs a hyperbola centered on the point center, where - the plane of the hyperbola is defined by center, s1 and s2, - its major axis is defined by center and s1, - its major radius is the distance between center and s1, and - its minor radius is the distance between s2 and the major axis;.

        Parameters
        ----------
        S1: gp_Pnt
        S2: gp_Pnt
        Center: gp_Pnt

        Returns
        -------
        None

        """
        _GC.GC_MakeHyperbola_swiginit(self, _GC.new_GC_MakeHyperbola(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_Hyperbola > const &":
        r"""
        Returns the constructed hyperbola. exceptions stdfail_notdone if no hyperbola is constructed.

        Returns
        -------
        opencascade::handle<Geom_Hyperbola>

        """
        return _GC.GC_MakeHyperbola_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakeHyperbola

# Register GC_MakeHyperbola in _GC:
_GC.GC_MakeHyperbola_swigregister(GC_MakeHyperbola)

class GC_MakeLine(GC_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a line located in 3d space with the axis placement a1. the location of a1 is the origin of the line.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        Creates a line from a non persistent line from package gp.

        Parameters
        ----------
        L: gp_Lin

        Returns
        -------
        None
        P is the origin and v is the direction of the line.

        Parameters
        ----------
        P: gp_Pnt
        V: gp_Dir

        Returns
        -------
        None
        Make a line from geom <thelin> parallel to another lin <lin> and passing through a pnt <point>.

        Parameters
        ----------
        Lin: gp_Lin
        Point: gp_Pnt

        Returns
        -------
        None
        Make a line from geom <thelin> passing through 2 pnt <p1>,<p2>. it returns false if <p1> and <p2> are confused. warning if the points p1 and p2 are coincident (that is, when isdone returns false), the status function returns gce_confusedpoints.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        _GC.GC_MakeLine_swiginit(self, _GC.new_GC_MakeLine(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_Line > const &":
        r"""
        Returns the constructed line. exceptions stdfail_notdone if no line is constructed.

        Returns
        -------
        opencascade::handle<Geom_Line>

        """
        return _GC.GC_MakeLine_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakeLine

# Register GC_MakeLine in _GC:
_GC.GC_MakeLine_swigregister(GC_MakeLine)

class GC_MakePlane(GC_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a plane from a non persistent plane from package gp.

        Parameters
        ----------
        Pl: gp_Pln

        Returns
        -------
        None
        P is the 'location' point or origin of the plane. v is the direction normal to the plane.

        Parameters
        ----------
        P: gp_Pnt
        V: gp_Dir

        Returns
        -------
        None
        Creates a plane from its cartesian equation : ax + by + cz + d = 0.0 status is 'badequation' if sqrt (a*a + b*b + c*c) <= resolution from gp.

        Parameters
        ----------
        A: float
        B: float
        C: float
        D: float

        Returns
        -------
        None
        Make a plane from geom <theplane> parallel to another pln <pln> and passing through a pnt <point>.

        Parameters
        ----------
        Pln: gp_Pln
        Point: gp_Pnt

        Returns
        -------
        None
        Make a plane from geom <theplane> parallel to another pln <pln> at the distance <dist> which can be greater or lower than zero. in the first case the result is at the distance <dist> to the plane <pln> in the direction of the normal to <pln>. otherwise it is in the opposite direction.

        Parameters
        ----------
        Pln: gp_Pln
        Dist: float

        Returns
        -------
        None
        Make a plane from geom <theplane> passing through 3 pnt <p1>,<p2>,<p3>. it returns false if <p1> <p2> <p3> are confused.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt

        Returns
        -------
        None
        Make a plane passing through the location of <axis>and normal to the direction of <axis>.

        Parameters
        ----------
        Axis: gp_Ax1

        Returns
        -------
        None

        """
        _GC.GC_MakePlane_swiginit(self, _GC.new_GC_MakePlane(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_Plane > const &":
        r"""
        Returns the constructed plane. exceptions stdfail_notdone if no plane is constructed.

        Returns
        -------
        opencascade::handle<Geom_Plane>

        """
        return _GC.GC_MakePlane_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakePlane

# Register GC_MakePlane in _GC:
_GC.GC_MakePlane_swigregister(GC_MakePlane)

class GC_MakeSegment(GC_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Make a segment of line from the 2 points <p1> and <p2>. it returns nullobject if <p1> and <p2> are confused.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None
        Make a segment of line from the line <line1> between the two parameters u1 and u2. it returns nullobject if <u1> is equal <u2>.

        Parameters
        ----------
        Line: gp_Lin
        U1: float
        U2: float

        Returns
        -------
        None
        Make a segment of line from the line <line1> between the point <point> and the parameter ulast. it returns nullobject if <u1> is equal <u2>.

        Parameters
        ----------
        Line: gp_Lin
        Point: gp_Pnt
        Ulast: float

        Returns
        -------
        None
        Make a segment of line from the line <line1> between the two points <p1> and <p2>. it returns nullobject if <u1> is equal <u2>.

        Parameters
        ----------
        Line: gp_Lin
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        _GC.GC_MakeSegment_swiginit(self, _GC.new_GC_MakeSegment(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_TrimmedCurve > const &":
        r"""
        Returns the constructed line segment.

        Returns
        -------
        opencascade::handle<Geom_TrimmedCurve>

        """
        return _GC.GC_MakeSegment_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakeSegment

# Register GC_MakeSegment in _GC:
_GC.GC_MakeSegment_swigregister(GC_MakeSegment)

class GC_MakeTrimmedCone(GC_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Make a rectangulartrimmedsurface <thecone> from geom it is trimmed by p3 and p4. its axis is <p1p2> and the radius of its base is the distance between <p3> and <p1p2>. the distance between <p4> and <p1p2> is the radius of the section passing through <p4>. an error iss raised if <p1>,<p2>,<p3>,<p4> are colinear or if <p3p4> is perpendicular to <p1p2> or <p3p4> is colinear to <p1p2>.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt
        P4: gp_Pnt

        Returns
        -------
        None
        Make a rectangulartrimmedsurface from geom <thecone> from a cone and trimmed by two points p1 and p2 and the two radius <r1> and <r2> of the sections passing through <p1> an <p2>. warning if an error occurs (that is, when isdone returns false), the status function returns: - gce_confusedpoints if points p1 and p2, or p3 and p4, are coincident; - gce_nullangle if: - the lines joining p1 to p2 and p3 to p4 are parallel, or - r1 and r2 are equal (i.e. their difference is less than gp::resolution()); - gce_nullradius if: - the line joining p1 to p2 is perpendicular to the line joining p3 to p4, or - the points p1, p2, p3 and p4 are collinear; - gce_negativeradius if r1 or r2 is negative; or - gce_nullaxis if points p1 and p2 are coincident (2nd syntax only).

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        R1: float
        R2: float

        Returns
        -------
        None

        """
        _GC.GC_MakeTrimmedCone_swiginit(self, _GC.new_GC_MakeTrimmedCone(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_RectangularTrimmedSurface > const &":
        r"""
        Returns the constructed trimmed cone. stdfail_notdone if no trimmed cone is constructed.

        Returns
        -------
        opencascade::handle<Geom_RectangularTrimmedSurface>

        """
        return _GC.GC_MakeTrimmedCone_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakeTrimmedCone

# Register GC_MakeTrimmedCone in _GC:
_GC.GC_MakeTrimmedCone_swigregister(GC_MakeTrimmedCone)

class GC_MakeTrimmedCylinder(GC_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Make a cylindricalsurface <cyl> from geom its axis is <p1p2> and its radius is the distance between <p3> and <p1p2>. the height is the distance between p1 and p2.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt

        Returns
        -------
        None
        Make a cylindricalsurface <cyl> from gp by its base <circ>. its axis is the normal to the plane defined bi <circ>. <height> can be greater than zero or lower than zero. in the first case the v parametric direction of the result has the same orientation as the normal to <circ>. in the other case it has the opposite orientation.

        Parameters
        ----------
        Circ: gp_Circ
        Height: float

        Returns
        -------
        None
        Make a cylindricalsurface <cyl> from gp by its axis <a1> and its radius <radius>. it returns nullobject if <radius> is lower than zero. <height> can be greater than zero or lower than zero. in the first case the v parametric direction of the result has the same orientation as <a1>. in the other case it has the opposite orientation.

        Parameters
        ----------
        A1: gp_Ax1
        Radius: float
        Height: float

        Returns
        -------
        None

        """
        _GC.GC_MakeTrimmedCylinder_swiginit(self, _GC.new_GC_MakeTrimmedCylinder(*args))

    def Value(self, *args) -> "opencascade::handle< Geom_RectangularTrimmedSurface > const &":
        r"""
        Returns the constructed trimmed cylinder. exceptions stdfail_notdone if no trimmed cylinder is constructed.

        Returns
        -------
        opencascade::handle<Geom_RectangularTrimmedSurface>

        """
        return _GC.GC_MakeTrimmedCylinder_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GC.delete_GC_MakeTrimmedCylinder

# Register GC_MakeTrimmedCylinder in _GC:
_GC.GC_MakeTrimmedCylinder_swigregister(GC_MakeTrimmedCylinder)





