from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TColStd import *

#the following typedef cannot be wrapped as is
gp_Vec2f = NewType('gp_Vec2f', Any)
#the following typedef cannot be wrapped as is
gp_Vec3f = NewType('gp_Vec3f', Any)

class gp_TrsfForm(IntEnum):
    gp_Identity: int = ...
    gp_Rotation: int = ...
    gp_Translation: int = ...
    gp_PntMirror: int = ...
    gp_Ax1Mirror: int = ...
    gp_Ax2Mirror: int = ...
    gp_Scale: int = ...
    gp_CompoundTrsf: int = ...
    gp_Other: int = ...

gp_Identity = gp_TrsfForm.gp_Identity
gp_Rotation = gp_TrsfForm.gp_Rotation
gp_Translation = gp_TrsfForm.gp_Translation
gp_PntMirror = gp_TrsfForm.gp_PntMirror
gp_Ax1Mirror = gp_TrsfForm.gp_Ax1Mirror
gp_Ax2Mirror = gp_TrsfForm.gp_Ax2Mirror
gp_Scale = gp_TrsfForm.gp_Scale
gp_CompoundTrsf = gp_TrsfForm.gp_CompoundTrsf
gp_Other = gp_TrsfForm.gp_Other

class gp_EulerSequence(IntEnum):
    gp_EulerAngles: int = ...
    gp_YawPitchRoll: int = ...
    gp_Extrinsic_XYZ: int = ...
    gp_Extrinsic_XZY: int = ...
    gp_Extrinsic_YZX: int = ...
    gp_Extrinsic_YXZ: int = ...
    gp_Extrinsic_ZXY: int = ...
    gp_Extrinsic_ZYX: int = ...
    gp_Intrinsic_XYZ: int = ...
    gp_Intrinsic_XZY: int = ...
    gp_Intrinsic_YZX: int = ...
    gp_Intrinsic_YXZ: int = ...
    gp_Intrinsic_ZXY: int = ...
    gp_Intrinsic_ZYX: int = ...
    gp_Extrinsic_XYX: int = ...
    gp_Extrinsic_XZX: int = ...
    gp_Extrinsic_YZY: int = ...
    gp_Extrinsic_YXY: int = ...
    gp_Extrinsic_ZYZ: int = ...
    gp_Extrinsic_ZXZ: int = ...
    gp_Intrinsic_XYX: int = ...
    gp_Intrinsic_XZX: int = ...
    gp_Intrinsic_YZY: int = ...
    gp_Intrinsic_YXY: int = ...
    gp_Intrinsic_ZXZ: int = ...
    gp_Intrinsic_ZYZ: int = ...

gp_EulerAngles = gp_EulerSequence.gp_EulerAngles
gp_YawPitchRoll = gp_EulerSequence.gp_YawPitchRoll
gp_Extrinsic_XYZ = gp_EulerSequence.gp_Extrinsic_XYZ
gp_Extrinsic_XZY = gp_EulerSequence.gp_Extrinsic_XZY
gp_Extrinsic_YZX = gp_EulerSequence.gp_Extrinsic_YZX
gp_Extrinsic_YXZ = gp_EulerSequence.gp_Extrinsic_YXZ
gp_Extrinsic_ZXY = gp_EulerSequence.gp_Extrinsic_ZXY
gp_Extrinsic_ZYX = gp_EulerSequence.gp_Extrinsic_ZYX
gp_Intrinsic_XYZ = gp_EulerSequence.gp_Intrinsic_XYZ
gp_Intrinsic_XZY = gp_EulerSequence.gp_Intrinsic_XZY
gp_Intrinsic_YZX = gp_EulerSequence.gp_Intrinsic_YZX
gp_Intrinsic_YXZ = gp_EulerSequence.gp_Intrinsic_YXZ
gp_Intrinsic_ZXY = gp_EulerSequence.gp_Intrinsic_ZXY
gp_Intrinsic_ZYX = gp_EulerSequence.gp_Intrinsic_ZYX
gp_Extrinsic_XYX = gp_EulerSequence.gp_Extrinsic_XYX
gp_Extrinsic_XZX = gp_EulerSequence.gp_Extrinsic_XZX
gp_Extrinsic_YZY = gp_EulerSequence.gp_Extrinsic_YZY
gp_Extrinsic_YXY = gp_EulerSequence.gp_Extrinsic_YXY
gp_Extrinsic_ZYZ = gp_EulerSequence.gp_Extrinsic_ZYZ
gp_Extrinsic_ZXZ = gp_EulerSequence.gp_Extrinsic_ZXZ
gp_Intrinsic_XYX = gp_EulerSequence.gp_Intrinsic_XYX
gp_Intrinsic_XZX = gp_EulerSequence.gp_Intrinsic_XZX
gp_Intrinsic_YZY = gp_EulerSequence.gp_Intrinsic_YZY
gp_Intrinsic_YXY = gp_EulerSequence.gp_Intrinsic_YXY
gp_Intrinsic_ZXZ = gp_EulerSequence.gp_Intrinsic_ZXZ
gp_Intrinsic_ZYZ = gp_EulerSequence.gp_Intrinsic_ZYZ

class gp:
    @staticmethod
    def DX() -> gp_Dir: ...
    @staticmethod
    def DX2d() -> gp_Dir2d: ...
    @staticmethod
    def DY() -> gp_Dir: ...
    @staticmethod
    def DY2d() -> gp_Dir2d: ...
    @staticmethod
    def DZ() -> gp_Dir: ...
    @staticmethod
    def OX() -> gp_Ax1: ...
    @staticmethod
    def OX2d() -> gp_Ax2d: ...
    @staticmethod
    def OY() -> gp_Ax1: ...
    @staticmethod
    def OY2d() -> gp_Ax2d: ...
    @staticmethod
    def OZ() -> gp_Ax1: ...
    @staticmethod
    def Origin() -> gp_Pnt: ...
    @staticmethod
    def Origin2d() -> gp_Pnt2d: ...
    @staticmethod
    def Resolution() -> float: ...
    @staticmethod
    def XOY() -> gp_Ax2: ...
    @staticmethod
    def YOZ() -> gp_Ax2: ...
    @staticmethod
    def ZOX() -> gp_Ax2: ...

class gp_Ax1:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theP: gp_Pnt, theV: gp_Dir) -> None: ...
    def Angle(self, theOther: gp_Ax1) -> float: ...
    def Direction(self) -> gp_Dir: ...
    def InitFromJson(self, theSStream: Standard_SStream) -> Tuple[bool, int]: ...
    def IsCoaxial(self, Other: gp_Ax1, AngularTolerance: float, LinearTolerance: float) -> bool: ...
    def IsNormal(self, theOther: gp_Ax1, theAngularTolerance: float) -> bool: ...
    def IsOpposite(self, theOther: gp_Ax1, theAngularTolerance: float) -> bool: ...
    def IsParallel(self, theOther: gp_Ax1, theAngularTolerance: float) -> bool: ...
    def Location(self) -> gp_Pnt: ...
    @overload
    def Mirror(self, P: gp_Pnt) -> None: ...
    @overload
    def Mirror(self, A1: gp_Ax1) -> None: ...
    @overload
    def Mirror(self, A2: gp_Ax2) -> None: ...
    @overload
    def Mirrored(self, P: gp_Pnt) -> gp_Ax1: ...
    @overload
    def Mirrored(self, A1: gp_Ax1) -> gp_Ax1: ...
    @overload
    def Mirrored(self, A2: gp_Ax2) -> gp_Ax1: ...
    def Reverse(self) -> None: ...
    def Reversed(self) -> gp_Ax1: ...
    def Rotate(self, theA1: gp_Ax1, theAngRad: float) -> None: ...
    def Rotated(self, theA1: gp_Ax1, theAngRad: float) -> gp_Ax1: ...
    def Scale(self, theP: gp_Pnt, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt, theS: float) -> gp_Ax1: ...
    def SetDirection(self, theV: gp_Dir) -> None: ...
    def SetLocation(self, theP: gp_Pnt) -> None: ...
    def Transform(self, theT: gp_Trsf) -> None: ...
    def Transformed(self, theT: gp_Trsf) -> gp_Ax1: ...
    @overload
    def Translate(self, theV: gp_Vec) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt, theP2: gp_Pnt) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec) -> gp_Ax1: ...
    @overload
    def Translated(self, theP1: gp_Pnt, theP2: gp_Pnt) -> gp_Ax1: ...

class gp_Ax2:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, N: gp_Dir, Vx: gp_Dir) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, V: gp_Dir) -> None: ...
    def Angle(self, theOther: gp_Ax2) -> float: ...
    def Axis(self) -> gp_Ax1: ...
    def Direction(self) -> gp_Dir: ...
    def InitFromJson(self, theSStream: Standard_SStream) -> Tuple[bool, int]: ...
    @overload
    def IsCoplanar(self, Other: gp_Ax2, LinearTolerance: float, AngularTolerance: float) -> bool: ...
    @overload
    def IsCoplanar(self, A1: gp_Ax1, LinearTolerance: float, AngularTolerance: float) -> bool: ...
    def Location(self) -> gp_Pnt: ...
    @overload
    def Mirror(self, P: gp_Pnt) -> None: ...
    @overload
    def Mirror(self, A1: gp_Ax1) -> None: ...
    @overload
    def Mirror(self, A2: gp_Ax2) -> None: ...
    @overload
    def Mirrored(self, P: gp_Pnt) -> gp_Ax2: ...
    @overload
    def Mirrored(self, A1: gp_Ax1) -> gp_Ax2: ...
    @overload
    def Mirrored(self, A2: gp_Ax2) -> gp_Ax2: ...
    def Rotate(self, theA1: gp_Ax1, theAng: float) -> None: ...
    def Rotated(self, theA1: gp_Ax1, theAng: float) -> gp_Ax2: ...
    def Scale(self, theP: gp_Pnt, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt, theS: float) -> gp_Ax2: ...
    def SetAxis(self, A1: gp_Ax1) -> None: ...
    def SetDirection(self, V: gp_Dir) -> None: ...
    def SetLocation(self, theP: gp_Pnt) -> None: ...
    def SetXDirection(self, theVx: gp_Dir) -> None: ...
    def SetYDirection(self, theVy: gp_Dir) -> None: ...
    def Transform(self, theT: gp_Trsf) -> None: ...
    def Transformed(self, theT: gp_Trsf) -> gp_Ax2: ...
    @overload
    def Translate(self, theV: gp_Vec) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt, theP2: gp_Pnt) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec) -> gp_Ax2: ...
    @overload
    def Translated(self, theP1: gp_Pnt, theP2: gp_Pnt) -> gp_Ax2: ...
    def XDirection(self) -> gp_Dir: ...
    def YDirection(self) -> gp_Dir: ...

class gp_Ax22d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theP: gp_Pnt2d, theVx: gp_Dir2d, theVy: gp_Dir2d) -> None: ...
    @overload
    def __init__(self, theP: gp_Pnt2d, theV: gp_Dir2d, theIsSense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, theA: gp_Ax2d, theIsSense: Optional[bool] = True) -> None: ...
    def Location(self) -> gp_Pnt2d: ...
    @overload
    def Mirror(self, theP: gp_Pnt2d) -> None: ...
    @overload
    def Mirror(self, theA: gp_Ax2d) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt2d) -> gp_Ax22d: ...
    @overload
    def Mirrored(self, theA: gp_Ax2d) -> gp_Ax22d: ...
    def Rotate(self, theP: gp_Pnt2d, theAng: float) -> None: ...
    def Rotated(self, theP: gp_Pnt2d, theAng: float) -> gp_Ax22d: ...
    def Scale(self, theP: gp_Pnt2d, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt2d, theS: float) -> gp_Ax22d: ...
    def SetAxis(self, theA1: gp_Ax22d) -> None: ...
    def SetLocation(self, theP: gp_Pnt2d) -> None: ...
    def SetXAxis(self, theA1: gp_Ax2d) -> None: ...
    def SetXDirection(self, theVx: gp_Dir2d) -> None: ...
    def SetYAxis(self, theA1: gp_Ax2d) -> None: ...
    def SetYDirection(self, theVy: gp_Dir2d) -> None: ...
    def Transform(self, theT: gp_Trsf2d) -> None: ...
    def Transformed(self, theT: gp_Trsf2d) -> gp_Ax22d: ...
    @overload
    def Translate(self, theV: gp_Vec2d) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec2d) -> gp_Ax22d: ...
    @overload
    def Translated(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> gp_Ax22d: ...
    def XAxis(self) -> gp_Ax2d: ...
    def XDirection(self) -> gp_Dir2d: ...
    def YAxis(self) -> gp_Ax2d: ...
    def YDirection(self) -> gp_Dir2d: ...

class gp_Ax2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theP: gp_Pnt2d, theV: gp_Dir2d) -> None: ...
    def Angle(self, theOther: gp_Ax2d) -> float: ...
    def Direction(self) -> gp_Dir2d: ...
    def IsCoaxial(self, Other: gp_Ax2d, AngularTolerance: float, LinearTolerance: float) -> bool: ...
    def IsNormal(self, theOther: gp_Ax2d, theAngularTolerance: float) -> bool: ...
    def IsOpposite(self, theOther: gp_Ax2d, theAngularTolerance: float) -> bool: ...
    def IsParallel(self, theOther: gp_Ax2d, theAngularTolerance: float) -> bool: ...
    def Location(self) -> gp_Pnt2d: ...
    @overload
    def Mirror(self, P: gp_Pnt2d) -> None: ...
    @overload
    def Mirror(self, A: gp_Ax2d) -> None: ...
    @overload
    def Mirrored(self, P: gp_Pnt2d) -> gp_Ax2d: ...
    @overload
    def Mirrored(self, A: gp_Ax2d) -> gp_Ax2d: ...
    def Reverse(self) -> None: ...
    def Reversed(self) -> gp_Ax2d: ...
    def Rotate(self, theP: gp_Pnt2d, theAng: float) -> None: ...
    def Rotated(self, theP: gp_Pnt2d, theAng: float) -> gp_Ax2d: ...
    def Scale(self, P: gp_Pnt2d, S: float) -> None: ...
    def Scaled(self, theP: gp_Pnt2d, theS: float) -> gp_Ax2d: ...
    def SetDirection(self, theV: gp_Dir2d) -> None: ...
    def SetLocation(self, theP: gp_Pnt2d) -> None: ...
    def Transform(self, theT: gp_Trsf2d) -> None: ...
    def Transformed(self, theT: gp_Trsf2d) -> gp_Ax2d: ...
    @overload
    def Translate(self, theV: gp_Vec2d) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec2d) -> gp_Ax2d: ...
    @overload
    def Translated(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> gp_Ax2d: ...

class gp_Ax3:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theA: gp_Ax2) -> None: ...
    @overload
    def __init__(self, theP: gp_Pnt, theN: gp_Dir, theVx: gp_Dir) -> None: ...
    @overload
    def __init__(self, theP: gp_Pnt, theV: gp_Dir) -> None: ...
    def Angle(self, theOther: gp_Ax3) -> float: ...
    def Ax2(self) -> gp_Ax2: ...
    def Axis(self) -> gp_Ax1: ...
    def Direct(self) -> bool: ...
    def Direction(self) -> gp_Dir: ...
    def InitFromJson(self, theSStream: Standard_SStream) -> Tuple[bool, int]: ...
    @overload
    def IsCoplanar(self, theOther: gp_Ax3, theLinearTolerance: float, theAngularTolerance: float) -> bool: ...
    @overload
    def IsCoplanar(self, theA1: gp_Ax1, theLinearTolerance: float, theAngularTolerance: float) -> bool: ...
    def Location(self) -> gp_Pnt: ...
    @overload
    def Mirror(self, theP: gp_Pnt) -> None: ...
    @overload
    def Mirror(self, theA1: gp_Ax1) -> None: ...
    @overload
    def Mirror(self, theA2: gp_Ax2) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt) -> gp_Ax3: ...
    @overload
    def Mirrored(self, theA1: gp_Ax1) -> gp_Ax3: ...
    @overload
    def Mirrored(self, theA2: gp_Ax2) -> gp_Ax3: ...
    def Rotate(self, theA1: gp_Ax1, theAng: float) -> None: ...
    def Rotated(self, theA1: gp_Ax1, theAng: float) -> gp_Ax3: ...
    def Scale(self, theP: gp_Pnt, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt, theS: float) -> gp_Ax3: ...
    def SetAxis(self, theA1: gp_Ax1) -> None: ...
    def SetDirection(self, theV: gp_Dir) -> None: ...
    def SetLocation(self, theP: gp_Pnt) -> None: ...
    def SetXDirection(self, theVx: gp_Dir) -> None: ...
    def SetYDirection(self, theVy: gp_Dir) -> None: ...
    def Transform(self, theT: gp_Trsf) -> None: ...
    def Transformed(self, theT: gp_Trsf) -> gp_Ax3: ...
    @overload
    def Translate(self, theV: gp_Vec) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt, theP2: gp_Pnt) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec) -> gp_Ax3: ...
    @overload
    def Translated(self, theP1: gp_Pnt, theP2: gp_Pnt) -> gp_Ax3: ...
    def XDirection(self) -> gp_Dir: ...
    def XReverse(self) -> None: ...
    def YDirection(self) -> gp_Dir: ...
    def YReverse(self) -> None: ...
    def ZReverse(self) -> None: ...

class gp_Circ:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theA2: gp_Ax2, theRadius: float) -> None: ...
    def Area(self) -> float: ...
    def Axis(self) -> gp_Ax1: ...
    def Contains(self, theP: gp_Pnt, theLinearTolerance: float) -> bool: ...
    def Distance(self, theP: gp_Pnt) -> float: ...
    def Length(self) -> float: ...
    def Location(self) -> gp_Pnt: ...
    @overload
    def Mirror(self, theP: gp_Pnt) -> None: ...
    @overload
    def Mirror(self, theA1: gp_Ax1) -> None: ...
    @overload
    def Mirror(self, theA2: gp_Ax2) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt) -> gp_Circ: ...
    @overload
    def Mirrored(self, theA1: gp_Ax1) -> gp_Circ: ...
    @overload
    def Mirrored(self, theA2: gp_Ax2) -> gp_Circ: ...
    def Position(self) -> gp_Ax2: ...
    def Radius(self) -> float: ...
    def Rotate(self, theA1: gp_Ax1, theAng: float) -> None: ...
    def Rotated(self, theA1: gp_Ax1, theAng: float) -> gp_Circ: ...
    def Scale(self, theP: gp_Pnt, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt, theS: float) -> gp_Circ: ...
    def SetAxis(self, theA1: gp_Ax1) -> None: ...
    def SetLocation(self, theP: gp_Pnt) -> None: ...
    def SetPosition(self, theA2: gp_Ax2) -> None: ...
    def SetRadius(self, theRadius: float) -> None: ...
    def SquareDistance(self, theP: gp_Pnt) -> float: ...
    def Transform(self, theT: gp_Trsf) -> None: ...
    def Transformed(self, theT: gp_Trsf) -> gp_Circ: ...
    @overload
    def Translate(self, theV: gp_Vec) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt, theP2: gp_Pnt) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec) -> gp_Circ: ...
    @overload
    def Translated(self, theP1: gp_Pnt, theP2: gp_Pnt) -> gp_Circ: ...
    def XAxis(self) -> gp_Ax1: ...
    def YAxis(self) -> gp_Ax1: ...

class gp_Circ2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theXAxis: gp_Ax2d, theRadius: float, theIsSense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, theAxis: gp_Ax22d, theRadius: float) -> None: ...
    def Area(self) -> float: ...
    def Axis(self) -> gp_Ax22d: ...
    def Coefficients(self) -> Tuple[float, float, float, float, float, float]: ...
    def Contains(self, theP: gp_Pnt2d, theLinearTolerance: float) -> bool: ...
    def Distance(self, theP: gp_Pnt2d) -> float: ...
    def IsDirect(self) -> bool: ...
    def Length(self) -> float: ...
    def Location(self) -> gp_Pnt2d: ...
    @overload
    def Mirror(self, theP: gp_Pnt2d) -> None: ...
    @overload
    def Mirror(self, theA: gp_Ax2d) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt2d) -> gp_Circ2d: ...
    @overload
    def Mirrored(self, theA: gp_Ax2d) -> gp_Circ2d: ...
    def Position(self) -> gp_Ax22d: ...
    def Radius(self) -> float: ...
    def Reverse(self) -> None: ...
    def Reversed(self) -> gp_Circ2d: ...
    def Rotate(self, theP: gp_Pnt2d, theAng: float) -> None: ...
    def Rotated(self, theP: gp_Pnt2d, theAng: float) -> gp_Circ2d: ...
    def Scale(self, theP: gp_Pnt2d, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt2d, theS: float) -> gp_Circ2d: ...
    def SetAxis(self, theA: gp_Ax22d) -> None: ...
    def SetLocation(self, theP: gp_Pnt2d) -> None: ...
    def SetRadius(self, theRadius: float) -> None: ...
    def SetXAxis(self, theA: gp_Ax2d) -> None: ...
    def SetYAxis(self, theA: gp_Ax2d) -> None: ...
    def SquareDistance(self, theP: gp_Pnt2d) -> float: ...
    def Transform(self, theT: gp_Trsf2d) -> None: ...
    def Transformed(self, theT: gp_Trsf2d) -> gp_Circ2d: ...
    @overload
    def Translate(self, theV: gp_Vec2d) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec2d) -> gp_Circ2d: ...
    @overload
    def Translated(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> gp_Circ2d: ...
    def XAxis(self) -> gp_Ax2d: ...
    def YAxis(self) -> gp_Ax2d: ...

class gp_Cone:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theA3: gp_Ax3, theAng: float, theRadius: float) -> None: ...
    def Apex(self) -> gp_Pnt: ...
    def Axis(self) -> gp_Ax1: ...
    def Coefficients(self) -> Tuple[float, float, float, float, float, float, float, float, float, float]: ...
    def Direct(self) -> bool: ...
    def Location(self) -> gp_Pnt: ...
    @overload
    def Mirror(self, theP: gp_Pnt) -> None: ...
    @overload
    def Mirror(self, theA1: gp_Ax1) -> None: ...
    @overload
    def Mirror(self, theA2: gp_Ax2) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt) -> gp_Cone: ...
    @overload
    def Mirrored(self, theA1: gp_Ax1) -> gp_Cone: ...
    @overload
    def Mirrored(self, theA2: gp_Ax2) -> gp_Cone: ...
    def Position(self) -> gp_Ax3: ...
    def RefRadius(self) -> float: ...
    def Rotate(self, theA1: gp_Ax1, theAng: float) -> None: ...
    def Rotated(self, theA1: gp_Ax1, theAng: float) -> gp_Cone: ...
    def Scale(self, theP: gp_Pnt, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt, theS: float) -> gp_Cone: ...
    def SemiAngle(self) -> float: ...
    def SetAxis(self, theA1: gp_Ax1) -> None: ...
    def SetLocation(self, theLoc: gp_Pnt) -> None: ...
    def SetPosition(self, theA3: gp_Ax3) -> None: ...
    def SetRadius(self, theR: float) -> None: ...
    def SetSemiAngle(self, theAng: float) -> None: ...
    def Transform(self, theT: gp_Trsf) -> None: ...
    def Transformed(self, theT: gp_Trsf) -> gp_Cone: ...
    @overload
    def Translate(self, theV: gp_Vec) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt, theP2: gp_Pnt) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec) -> gp_Cone: ...
    @overload
    def Translated(self, theP1: gp_Pnt, theP2: gp_Pnt) -> gp_Cone: ...
    def UReverse(self) -> None: ...
    def VReverse(self) -> None: ...
    def XAxis(self) -> gp_Ax1: ...
    def YAxis(self) -> gp_Ax1: ...

class gp_Cylinder:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theA3: gp_Ax3, theRadius: float) -> None: ...
    def Axis(self) -> gp_Ax1: ...
    def Coefficients(self) -> Tuple[float, float, float, float, float, float, float, float, float, float]: ...
    def Direct(self) -> bool: ...
    def Location(self) -> gp_Pnt: ...
    @overload
    def Mirror(self, theP: gp_Pnt) -> None: ...
    @overload
    def Mirror(self, theA1: gp_Ax1) -> None: ...
    @overload
    def Mirror(self, theA2: gp_Ax2) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt) -> gp_Cylinder: ...
    @overload
    def Mirrored(self, theA1: gp_Ax1) -> gp_Cylinder: ...
    @overload
    def Mirrored(self, theA2: gp_Ax2) -> gp_Cylinder: ...
    def Position(self) -> gp_Ax3: ...
    def Radius(self) -> float: ...
    def Rotate(self, theA1: gp_Ax1, theAng: float) -> None: ...
    def Rotated(self, theA1: gp_Ax1, theAng: float) -> gp_Cylinder: ...
    def Scale(self, theP: gp_Pnt, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt, theS: float) -> gp_Cylinder: ...
    def SetAxis(self, theA1: gp_Ax1) -> None: ...
    def SetLocation(self, theLoc: gp_Pnt) -> None: ...
    def SetPosition(self, theA3: gp_Ax3) -> None: ...
    def SetRadius(self, theR: float) -> None: ...
    def Transform(self, theT: gp_Trsf) -> None: ...
    def Transformed(self, theT: gp_Trsf) -> gp_Cylinder: ...
    @overload
    def Translate(self, theV: gp_Vec) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt, theP2: gp_Pnt) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec) -> gp_Cylinder: ...
    @overload
    def Translated(self, theP1: gp_Pnt, theP2: gp_Pnt) -> gp_Cylinder: ...
    def UReverse(self) -> None: ...
    def VReverse(self) -> None: ...
    def XAxis(self) -> gp_Ax1: ...
    def YAxis(self) -> gp_Ax1: ...

class gp_Dir:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theV: gp_Vec) -> None: ...
    @overload
    def __init__(self, theCoord: gp_XYZ) -> None: ...
    @overload
    def __init__(self, theXv: float, theYv: float, theZv: float) -> None: ...
    def Angle(self, theOther: gp_Dir) -> float: ...
    def AngleWithRef(self, theOther: gp_Dir, theVRef: gp_Dir) -> float: ...
    @overload
    def Coord(self, theIndex: int) -> float: ...
    @overload
    def Coord(self) -> Tuple[float, float, float]: ...
    def Cross(self, theRight: gp_Dir) -> None: ...
    def CrossCross(self, theV1: gp_Dir, theV2: gp_Dir) -> None: ...
    def CrossCrossed(self, theV1: gp_Dir, theV2: gp_Dir) -> gp_Dir: ...
    def Crossed(self, theRight: gp_Dir) -> gp_Dir: ...
    def Dot(self, theOther: gp_Dir) -> float: ...
    def DotCross(self, theV1: gp_Dir, theV2: gp_Dir) -> float: ...
    def InitFromJson(self, theSStream: Standard_SStream) -> Tuple[bool, int]: ...
    def IsEqual(self, theOther: gp_Dir, theAngularTolerance: float) -> bool: ...
    def IsNormal(self, theOther: gp_Dir, theAngularTolerance: float) -> bool: ...
    def IsOpposite(self, theOther: gp_Dir, theAngularTolerance: float) -> bool: ...
    def IsParallel(self, theOther: gp_Dir, theAngularTolerance: float) -> bool: ...
    @overload
    def Mirror(self, theV: gp_Dir) -> None: ...
    @overload
    def Mirror(self, theA1: gp_Ax1) -> None: ...
    @overload
    def Mirror(self, theA2: gp_Ax2) -> None: ...
    @overload
    def Mirrored(self, theV: gp_Dir) -> gp_Dir: ...
    @overload
    def Mirrored(self, theA1: gp_Ax1) -> gp_Dir: ...
    @overload
    def Mirrored(self, theA2: gp_Ax2) -> gp_Dir: ...
    def Reverse(self) -> None: ...
    def Reversed(self) -> gp_Dir: ...
    def Rotate(self, theA1: gp_Ax1, theAng: float) -> None: ...
    def Rotated(self, theA1: gp_Ax1, theAng: float) -> gp_Dir: ...
    @overload
    def SetCoord(self, theIndex: int, theXi: float) -> None: ...
    @overload
    def SetCoord(self, theXv: float, theYv: float, theZv: float) -> None: ...
    def SetX(self, theX: float) -> None: ...
    def SetXYZ(self, theCoord: gp_XYZ) -> None: ...
    def SetY(self, theY: float) -> None: ...
    def SetZ(self, theZ: float) -> None: ...
    def Transform(self, theT: gp_Trsf) -> None: ...
    def Transformed(self, theT: gp_Trsf) -> gp_Dir: ...
    def X(self) -> float: ...
    def XYZ(self) -> gp_XYZ: ...
    def Y(self) -> float: ...
    def Z(self) -> float: ...

class gp_Dir2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theV: gp_Vec2d) -> None: ...
    @overload
    def __init__(self, theCoord: gp_XY) -> None: ...
    @overload
    def __init__(self, theXv: float, theYv: float) -> None: ...
    def Angle(self, theOther: gp_Dir2d) -> float: ...
    @overload
    def Coord(self, theIndex: int) -> float: ...
    @overload
    def Coord(self) -> Tuple[float, float]: ...
    def Crossed(self, theRight: gp_Dir2d) -> float: ...
    def Dot(self, theOther: gp_Dir2d) -> float: ...
    def IsEqual(self, theOther: gp_Dir2d, theAngularTolerance: float) -> bool: ...
    def IsNormal(self, theOther: gp_Dir2d, theAngularTolerance: float) -> bool: ...
    def IsOpposite(self, theOther: gp_Dir2d, theAngularTolerance: float) -> bool: ...
    def IsParallel(self, theOther: gp_Dir2d, theAngularTolerance: float) -> bool: ...
    @overload
    def Mirror(self, theV: gp_Dir2d) -> None: ...
    @overload
    def Mirror(self, theA: gp_Ax2d) -> None: ...
    @overload
    def Mirrored(self, theV: gp_Dir2d) -> gp_Dir2d: ...
    @overload
    def Mirrored(self, theA: gp_Ax2d) -> gp_Dir2d: ...
    def Reverse(self) -> None: ...
    def Reversed(self) -> gp_Dir2d: ...
    def Rotate(self, Ang: float) -> None: ...
    def Rotated(self, theAng: float) -> gp_Dir2d: ...
    @overload
    def SetCoord(self, theIndex: int, theXi: float) -> None: ...
    @overload
    def SetCoord(self, theXv: float, theYv: float) -> None: ...
    def SetX(self, theX: float) -> None: ...
    def SetXY(self, theCoord: gp_XY) -> None: ...
    def SetY(self, theY: float) -> None: ...
    def Transform(self, theT: gp_Trsf2d) -> None: ...
    def Transformed(self, theT: gp_Trsf2d) -> gp_Dir2d: ...
    def X(self) -> float: ...
    def XY(self) -> gp_XY: ...
    def Y(self) -> float: ...

class gp_Elips:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theA2: gp_Ax2, theMajorRadius: float, theMinorRadius: float) -> None: ...
    def Area(self) -> float: ...
    def Axis(self) -> gp_Ax1: ...
    def Directrix1(self) -> gp_Ax1: ...
    def Directrix2(self) -> gp_Ax1: ...
    def Eccentricity(self) -> float: ...
    def Focal(self) -> float: ...
    def Focus1(self) -> gp_Pnt: ...
    def Focus2(self) -> gp_Pnt: ...
    def Location(self) -> gp_Pnt: ...
    def MajorRadius(self) -> float: ...
    def MinorRadius(self) -> float: ...
    @overload
    def Mirror(self, theP: gp_Pnt) -> None: ...
    @overload
    def Mirror(self, theA1: gp_Ax1) -> None: ...
    @overload
    def Mirror(self, theA2: gp_Ax2) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt) -> gp_Elips: ...
    @overload
    def Mirrored(self, theA1: gp_Ax1) -> gp_Elips: ...
    @overload
    def Mirrored(self, theA2: gp_Ax2) -> gp_Elips: ...
    def Parameter(self) -> float: ...
    def Position(self) -> gp_Ax2: ...
    def Rotate(self, theA1: gp_Ax1, theAng: float) -> None: ...
    def Rotated(self, theA1: gp_Ax1, theAng: float) -> gp_Elips: ...
    def Scale(self, theP: gp_Pnt, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt, theS: float) -> gp_Elips: ...
    def SetAxis(self, theA1: gp_Ax1) -> None: ...
    def SetLocation(self, theP: gp_Pnt) -> None: ...
    def SetMajorRadius(self, theMajorRadius: float) -> None: ...
    def SetMinorRadius(self, theMinorRadius: float) -> None: ...
    def SetPosition(self, theA2: gp_Ax2) -> None: ...
    def Transform(self, theT: gp_Trsf) -> None: ...
    def Transformed(self, theT: gp_Trsf) -> gp_Elips: ...
    @overload
    def Translate(self, theV: gp_Vec) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt, theP2: gp_Pnt) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec) -> gp_Elips: ...
    @overload
    def Translated(self, theP1: gp_Pnt, theP2: gp_Pnt) -> gp_Elips: ...
    def XAxis(self) -> gp_Ax1: ...
    def YAxis(self) -> gp_Ax1: ...

class gp_Elips2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theMajorAxis: gp_Ax2d, theMajorRadius: float, theMinorRadius: float, theIsSense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, theA: gp_Ax22d, theMajorRadius: float, theMinorRadius: float) -> None: ...
    def Area(self) -> float: ...
    def Axis(self) -> gp_Ax22d: ...
    def Coefficients(self) -> Tuple[float, float, float, float, float, float]: ...
    def Directrix1(self) -> gp_Ax2d: ...
    def Directrix2(self) -> gp_Ax2d: ...
    def Eccentricity(self) -> float: ...
    def Focal(self) -> float: ...
    def Focus1(self) -> gp_Pnt2d: ...
    def Focus2(self) -> gp_Pnt2d: ...
    def IsDirect(self) -> bool: ...
    def Location(self) -> gp_Pnt2d: ...
    def MajorRadius(self) -> float: ...
    def MinorRadius(self) -> float: ...
    @overload
    def Mirror(self, theP: gp_Pnt2d) -> None: ...
    @overload
    def Mirror(self, theA: gp_Ax2d) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt2d) -> gp_Elips2d: ...
    @overload
    def Mirrored(self, theA: gp_Ax2d) -> gp_Elips2d: ...
    def Parameter(self) -> float: ...
    def Reverse(self) -> None: ...
    def Reversed(self) -> gp_Elips2d: ...
    def Rotate(self, theP: gp_Pnt2d, theAng: float) -> None: ...
    def Rotated(self, theP: gp_Pnt2d, theAng: float) -> gp_Elips2d: ...
    def Scale(self, theP: gp_Pnt2d, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt2d, theS: float) -> gp_Elips2d: ...
    def SetAxis(self, theA: gp_Ax22d) -> None: ...
    def SetLocation(self, theP: gp_Pnt2d) -> None: ...
    def SetMajorRadius(self, theMajorRadius: float) -> None: ...
    def SetMinorRadius(self, theMinorRadius: float) -> None: ...
    def SetXAxis(self, theA: gp_Ax2d) -> None: ...
    def SetYAxis(self, theA: gp_Ax2d) -> None: ...
    def Transform(self, theT: gp_Trsf2d) -> None: ...
    def Transformed(self, theT: gp_Trsf2d) -> gp_Elips2d: ...
    @overload
    def Translate(self, theV: gp_Vec2d) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec2d) -> gp_Elips2d: ...
    @overload
    def Translated(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> gp_Elips2d: ...
    def XAxis(self) -> gp_Ax2d: ...
    def YAxis(self) -> gp_Ax2d: ...

class gp_GTrsf:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theT: gp_Trsf) -> None: ...
    @overload
    def __init__(self, theM: gp_Mat, theV: gp_XYZ) -> None: ...
    def Form(self) -> gp_TrsfForm: ...
    def Invert(self) -> None: ...
    def Inverted(self) -> gp_GTrsf: ...
    def IsNegative(self) -> bool: ...
    def IsSingular(self) -> bool: ...
    def Multiplied(self, theT: gp_GTrsf) -> gp_GTrsf: ...
    def Multiply(self, theT: gp_GTrsf) -> None: ...
    def Power(self, theN: int) -> None: ...
    def Powered(self, theN: int) -> gp_GTrsf: ...
    def PreMultiply(self, theT: gp_GTrsf) -> None: ...
    @overload
    def SetAffinity(self, theA1: gp_Ax1, theRatio: float) -> None: ...
    @overload
    def SetAffinity(self, theA2: gp_Ax2, theRatio: float) -> None: ...
    def SetForm(self) -> None: ...
    def SetTranslationPart(self, theCoord: gp_XYZ) -> None: ...
    def SetTrsf(self, theT: gp_Trsf) -> None: ...
    def SetValue(self, theRow: int, theCol: int, theValue: float) -> None: ...
    def SetVectorialPart(self, theMatrix: gp_Mat) -> None: ...
    @overload
    def Transforms(self, theCoord: gp_XYZ) -> None: ...
    @overload
    def Transforms(self) -> Tuple[float, float, float]: ...
    def TranslationPart(self) -> gp_XYZ: ...
    def Trsf(self) -> gp_Trsf: ...
    def Value(self, theRow: int, theCol: int) -> float: ...
    def VectorialPart(self) -> gp_Mat: ...

class gp_GTrsf2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theT: gp_Trsf2d) -> None: ...
    @overload
    def __init__(self, theM: gp_Mat2d, theV: gp_XY) -> None: ...
    def Form(self) -> gp_TrsfForm: ...
    def Invert(self) -> None: ...
    def Inverted(self) -> gp_GTrsf2d: ...
    def IsNegative(self) -> bool: ...
    def IsSingular(self) -> bool: ...
    def Multiplied(self, theT: gp_GTrsf2d) -> gp_GTrsf2d: ...
    def Multiply(self, theT: gp_GTrsf2d) -> None: ...
    def Power(self, theN: int) -> None: ...
    def Powered(self, theN: int) -> gp_GTrsf2d: ...
    def PreMultiply(self, theT: gp_GTrsf2d) -> None: ...
    def SetAffinity(self, theA: gp_Ax2d, theRatio: float) -> None: ...
    def SetTranslationPart(self, theCoord: gp_XY) -> None: ...
    def SetTrsf2d(self, theT: gp_Trsf2d) -> None: ...
    def SetValue(self, theRow: int, theCol: int, theValue: float) -> None: ...
    def SetVectorialPart(self, theMatrix: gp_Mat2d) -> None: ...
    def Transformed(self, theCoord: gp_XY) -> gp_XY: ...
    @overload
    def Transforms(self, theCoord: gp_XY) -> None: ...
    @overload
    def Transforms(self) -> Tuple[float, float]: ...
    def TranslationPart(self) -> gp_XY: ...
    def Trsf2d(self) -> gp_Trsf2d: ...
    def Value(self, theRow: int, theCol: int) -> float: ...
    def VectorialPart(self) -> gp_Mat2d: ...

class gp_Hypr:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theA2: gp_Ax2, theMajorRadius: float, theMinorRadius: float) -> None: ...
    def Asymptote1(self) -> gp_Ax1: ...
    def Asymptote2(self) -> gp_Ax1: ...
    def Axis(self) -> gp_Ax1: ...
    def ConjugateBranch1(self) -> gp_Hypr: ...
    def ConjugateBranch2(self) -> gp_Hypr: ...
    def Directrix1(self) -> gp_Ax1: ...
    def Directrix2(self) -> gp_Ax1: ...
    def Eccentricity(self) -> float: ...
    def Focal(self) -> float: ...
    def Focus1(self) -> gp_Pnt: ...
    def Focus2(self) -> gp_Pnt: ...
    def Location(self) -> gp_Pnt: ...
    def MajorRadius(self) -> float: ...
    def MinorRadius(self) -> float: ...
    @overload
    def Mirror(self, theP: gp_Pnt) -> None: ...
    @overload
    def Mirror(self, theA1: gp_Ax1) -> None: ...
    @overload
    def Mirror(self, theA2: gp_Ax2) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt) -> gp_Hypr: ...
    @overload
    def Mirrored(self, theA1: gp_Ax1) -> gp_Hypr: ...
    @overload
    def Mirrored(self, theA2: gp_Ax2) -> gp_Hypr: ...
    def OtherBranch(self) -> gp_Hypr: ...
    def Parameter(self) -> float: ...
    def Position(self) -> gp_Ax2: ...
    def Rotate(self, theA1: gp_Ax1, theAng: float) -> None: ...
    def Rotated(self, theA1: gp_Ax1, theAng: float) -> gp_Hypr: ...
    def Scale(self, theP: gp_Pnt, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt, theS: float) -> gp_Hypr: ...
    def SetAxis(self, theA1: gp_Ax1) -> None: ...
    def SetLocation(self, theP: gp_Pnt) -> None: ...
    def SetMajorRadius(self, theMajorRadius: float) -> None: ...
    def SetMinorRadius(self, theMinorRadius: float) -> None: ...
    def SetPosition(self, theA2: gp_Ax2) -> None: ...
    def Transform(self, theT: gp_Trsf) -> None: ...
    def Transformed(self, theT: gp_Trsf) -> gp_Hypr: ...
    @overload
    def Translate(self, theV: gp_Vec) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt, theP2: gp_Pnt) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec) -> gp_Hypr: ...
    @overload
    def Translated(self, theP1: gp_Pnt, theP2: gp_Pnt) -> gp_Hypr: ...
    def XAxis(self) -> gp_Ax1: ...
    def YAxis(self) -> gp_Ax1: ...

class gp_Hypr2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theMajorAxis: gp_Ax2d, theMajorRadius: float, theMinorRadius: float, theIsSense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, theA: gp_Ax22d, theMajorRadius: float, theMinorRadius: float) -> None: ...
    def Asymptote1(self) -> gp_Ax2d: ...
    def Asymptote2(self) -> gp_Ax2d: ...
    def Axis(self) -> gp_Ax22d: ...
    def Coefficients(self) -> Tuple[float, float, float, float, float, float]: ...
    def ConjugateBranch1(self) -> gp_Hypr2d: ...
    def ConjugateBranch2(self) -> gp_Hypr2d: ...
    def Directrix1(self) -> gp_Ax2d: ...
    def Directrix2(self) -> gp_Ax2d: ...
    def Eccentricity(self) -> float: ...
    def Focal(self) -> float: ...
    def Focus1(self) -> gp_Pnt2d: ...
    def Focus2(self) -> gp_Pnt2d: ...
    def IsDirect(self) -> bool: ...
    def Location(self) -> gp_Pnt2d: ...
    def MajorRadius(self) -> float: ...
    def MinorRadius(self) -> float: ...
    @overload
    def Mirror(self, theP: gp_Pnt2d) -> None: ...
    @overload
    def Mirror(self, theA: gp_Ax2d) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt2d) -> gp_Hypr2d: ...
    @overload
    def Mirrored(self, theA: gp_Ax2d) -> gp_Hypr2d: ...
    def OtherBranch(self) -> gp_Hypr2d: ...
    def Parameter(self) -> float: ...
    def Reverse(self) -> None: ...
    def Reversed(self) -> gp_Hypr2d: ...
    def Rotate(self, theP: gp_Pnt2d, theAng: float) -> None: ...
    def Rotated(self, theP: gp_Pnt2d, theAng: float) -> gp_Hypr2d: ...
    def Scale(self, theP: gp_Pnt2d, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt2d, theS: float) -> gp_Hypr2d: ...
    def SetAxis(self, theA: gp_Ax22d) -> None: ...
    def SetLocation(self, theP: gp_Pnt2d) -> None: ...
    def SetMajorRadius(self, theMajorRadius: float) -> None: ...
    def SetMinorRadius(self, theMinorRadius: float) -> None: ...
    def SetXAxis(self, theA: gp_Ax2d) -> None: ...
    def SetYAxis(self, theA: gp_Ax2d) -> None: ...
    def Transform(self, theT: gp_Trsf2d) -> None: ...
    def Transformed(self, theT: gp_Trsf2d) -> gp_Hypr2d: ...
    @overload
    def Translate(self, theV: gp_Vec2d) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec2d) -> gp_Hypr2d: ...
    @overload
    def Translated(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> gp_Hypr2d: ...
    def XAxis(self) -> gp_Ax2d: ...
    def YAxis(self) -> gp_Ax2d: ...

class gp_Lin:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theA1: gp_Ax1) -> None: ...
    @overload
    def __init__(self, theP: gp_Pnt, theV: gp_Dir) -> None: ...
    def Angle(self, theOther: gp_Lin) -> float: ...
    def Contains(self, theP: gp_Pnt, theLinearTolerance: float) -> bool: ...
    def Direction(self) -> gp_Dir: ...
    @overload
    def Distance(self, theP: gp_Pnt) -> float: ...
    @overload
    def Distance(self, theOther: gp_Lin) -> float: ...
    def Location(self) -> gp_Pnt: ...
    @overload
    def Mirror(self, theP: gp_Pnt) -> None: ...
    @overload
    def Mirror(self, theA1: gp_Ax1) -> None: ...
    @overload
    def Mirror(self, theA2: gp_Ax2) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt) -> gp_Lin: ...
    @overload
    def Mirrored(self, theA1: gp_Ax1) -> gp_Lin: ...
    @overload
    def Mirrored(self, theA2: gp_Ax2) -> gp_Lin: ...
    def Normal(self, theP: gp_Pnt) -> gp_Lin: ...
    def Position(self) -> gp_Ax1: ...
    def Reverse(self) -> None: ...
    def Reversed(self) -> gp_Lin: ...
    def Rotate(self, theA1: gp_Ax1, theAng: float) -> None: ...
    def Rotated(self, theA1: gp_Ax1, theAng: float) -> gp_Lin: ...
    def Scale(self, theP: gp_Pnt, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt, theS: float) -> gp_Lin: ...
    def SetDirection(self, theV: gp_Dir) -> None: ...
    def SetLocation(self, theP: gp_Pnt) -> None: ...
    def SetPosition(self, theA1: gp_Ax1) -> None: ...
    @overload
    def SquareDistance(self, theP: gp_Pnt) -> float: ...
    @overload
    def SquareDistance(self, theOther: gp_Lin) -> float: ...
    def Transform(self, theT: gp_Trsf) -> None: ...
    def Transformed(self, theT: gp_Trsf) -> gp_Lin: ...
    @overload
    def Translate(self, theV: gp_Vec) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt, theP2: gp_Pnt) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec) -> gp_Lin: ...
    @overload
    def Translated(self, theP1: gp_Pnt, theP2: gp_Pnt) -> gp_Lin: ...

class gp_Lin2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theA: gp_Ax2d) -> None: ...
    @overload
    def __init__(self, theP: gp_Pnt2d, theV: gp_Dir2d) -> None: ...
    @overload
    def __init__(self, theA: float, theB: float, theC: float) -> None: ...
    def Angle(self, theOther: gp_Lin2d) -> float: ...
    def Coefficients(self) -> Tuple[float, float, float]: ...
    def Contains(self, theP: gp_Pnt2d, theLinearTolerance: float) -> bool: ...
    def Direction(self) -> gp_Dir2d: ...
    @overload
    def Distance(self, theP: gp_Pnt2d) -> float: ...
    @overload
    def Distance(self, theOther: gp_Lin2d) -> float: ...
    def Location(self) -> gp_Pnt2d: ...
    @overload
    def Mirror(self, theP: gp_Pnt2d) -> None: ...
    @overload
    def Mirror(self, theA: gp_Ax2d) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt2d) -> gp_Lin2d: ...
    @overload
    def Mirrored(self, theA: gp_Ax2d) -> gp_Lin2d: ...
    def Normal(self, theP: gp_Pnt2d) -> gp_Lin2d: ...
    def Position(self) -> gp_Ax2d: ...
    def Reverse(self) -> None: ...
    def Reversed(self) -> gp_Lin2d: ...
    def Rotate(self, theP: gp_Pnt2d, theAng: float) -> None: ...
    def Rotated(self, theP: gp_Pnt2d, theAng: float) -> gp_Lin2d: ...
    def Scale(self, theP: gp_Pnt2d, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt2d, theS: float) -> gp_Lin2d: ...
    def SetDirection(self, theV: gp_Dir2d) -> None: ...
    def SetLocation(self, theP: gp_Pnt2d) -> None: ...
    def SetPosition(self, theA: gp_Ax2d) -> None: ...
    @overload
    def SquareDistance(self, theP: gp_Pnt2d) -> float: ...
    @overload
    def SquareDistance(self, theOther: gp_Lin2d) -> float: ...
    def Transform(self, theT: gp_Trsf2d) -> None: ...
    def Transformed(self, theT: gp_Trsf2d) -> gp_Lin2d: ...
    @overload
    def Translate(self, theV: gp_Vec2d) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec2d) -> gp_Lin2d: ...
    @overload
    def Translated(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> gp_Lin2d: ...

class gp_Mat:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theA11: float, theA12: float, theA13: float, theA21: float, theA22: float, theA23: float, theA31: float, theA32: float, theA33: float) -> None: ...
    @overload
    def __init__(self, theCol1: gp_XYZ, theCol2: gp_XYZ, theCol3: gp_XYZ) -> None: ...
    def Add(self, theOther: gp_Mat) -> None: ...
    def Added(self, theOther: gp_Mat) -> gp_Mat: ...
    def GetChangeValue(self, theRow: int, theCol: int) -> float: ...
    def SetChangeValue(self, theRow: int, theCol: int, value: float) -> None: ...
    def Column(self, theCol: int) -> gp_XYZ: ...
    def Determinant(self) -> float: ...
    def Diagonal(self) -> gp_XYZ: ...
    def Divide(self, theScalar: float) -> None: ...
    def Divided(self, theScalar: float) -> gp_Mat: ...
    def Invert(self) -> None: ...
    def Inverted(self) -> gp_Mat: ...
    def IsSingular(self) -> bool: ...
    @overload
    def Multiplied(self, theOther: gp_Mat) -> gp_Mat: ...
    @overload
    def Multiplied(self, theScalar: float) -> gp_Mat: ...
    @overload
    def Multiply(self, theOther: gp_Mat) -> None: ...
    @overload
    def Multiply(self, theScalar: float) -> None: ...
    def Power(self, N: int) -> None: ...
    def Powered(self, theN: int) -> gp_Mat: ...
    def PreMultiply(self, theOther: gp_Mat) -> None: ...
    def Row(self, theRow: int) -> gp_XYZ: ...
    def SetCol(self, theCol: int, theValue: gp_XYZ) -> None: ...
    def SetCols(self, theCol1: gp_XYZ, theCol2: gp_XYZ, theCol3: gp_XYZ) -> None: ...
    def SetCross(self, theRef: gp_XYZ) -> None: ...
    def SetDiagonal(self, theX1: float, theX2: float, theX3: float) -> None: ...
    def SetDot(self, theRef: gp_XYZ) -> None: ...
    def SetIdentity(self) -> None: ...
    def SetRotation(self, theAxis: gp_XYZ, theAng: float) -> None: ...
    def SetRow(self, theRow: int, theValue: gp_XYZ) -> None: ...
    def SetRows(self, theRow1: gp_XYZ, theRow2: gp_XYZ, theRow3: gp_XYZ) -> None: ...
    def SetScale(self, theS: float) -> None: ...
    def SetValue(self, theRow: int, theCol: int, theValue: float) -> None: ...
    def Subtract(self, theOther: gp_Mat) -> None: ...
    def Subtracted(self, theOther: gp_Mat) -> gp_Mat: ...
    def Transpose(self) -> None: ...
    def Transposed(self) -> gp_Mat: ...
    def Value(self, theRow: int, theCol: int) -> float: ...

class gp_Mat2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theCol1: gp_XY, theCol2: gp_XY) -> None: ...
    def Add(self, Other: gp_Mat2d) -> None: ...
    def Added(self, theOther: gp_Mat2d) -> gp_Mat2d: ...
    def GetChangeValue(self, theRow: int, theCol: int) -> float: ...
    def SetChangeValue(self, theRow: int, theCol: int, value: float) -> None: ...
    def Column(self, theCol: int) -> gp_XY: ...
    def Determinant(self) -> float: ...
    def Diagonal(self) -> gp_XY: ...
    def Divide(self, theScalar: float) -> None: ...
    def Divided(self, theScalar: float) -> gp_Mat2d: ...
    def Invert(self) -> None: ...
    def Inverted(self) -> gp_Mat2d: ...
    def IsSingular(self) -> bool: ...
    @overload
    def Multiplied(self, theOther: gp_Mat2d) -> gp_Mat2d: ...
    @overload
    def Multiplied(self, theScalar: float) -> gp_Mat2d: ...
    @overload
    def Multiply(self, theOther: gp_Mat2d) -> None: ...
    @overload
    def Multiply(self, theScalar: float) -> None: ...
    def Power(self, theN: int) -> None: ...
    def Powered(self, theN: int) -> gp_Mat2d: ...
    def PreMultiply(self, theOther: gp_Mat2d) -> None: ...
    def Row(self, theRow: int) -> gp_XY: ...
    def SetCol(self, theCol: int, theValue: gp_XY) -> None: ...
    def SetCols(self, theCol1: gp_XY, theCol2: gp_XY) -> None: ...
    def SetDiagonal(self, theX1: float, theX2: float) -> None: ...
    def SetIdentity(self) -> None: ...
    def SetRotation(self, theAng: float) -> None: ...
    def SetRow(self, theRow: int, theValue: gp_XY) -> None: ...
    def SetRows(self, theRow1: gp_XY, theRow2: gp_XY) -> None: ...
    def SetScale(self, theS: float) -> None: ...
    def SetValue(self, theRow: int, theCol: int, theValue: float) -> None: ...
    def Subtract(self, theOther: gp_Mat2d) -> None: ...
    def Subtracted(self, theOther: gp_Mat2d) -> gp_Mat2d: ...
    def Transpose(self) -> None: ...
    def Transposed(self) -> gp_Mat2d: ...
    def Value(self, theRow: int, theCol: int) -> float: ...

class gp_Parab:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theA2: gp_Ax2, theFocal: float) -> None: ...
    @overload
    def __init__(self, theD: gp_Ax1, theF: gp_Pnt) -> None: ...
    def Axis(self) -> gp_Ax1: ...
    def Directrix(self) -> gp_Ax1: ...
    def Focal(self) -> float: ...
    def Focus(self) -> gp_Pnt: ...
    def Location(self) -> gp_Pnt: ...
    @overload
    def Mirror(self, theP: gp_Pnt) -> None: ...
    @overload
    def Mirror(self, theA1: gp_Ax1) -> None: ...
    @overload
    def Mirror(self, theA2: gp_Ax2) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt) -> gp_Parab: ...
    @overload
    def Mirrored(self, theA1: gp_Ax1) -> gp_Parab: ...
    @overload
    def Mirrored(self, theA2: gp_Ax2) -> gp_Parab: ...
    def Parameter(self) -> float: ...
    def Position(self) -> gp_Ax2: ...
    def Rotate(self, theA1: gp_Ax1, theAng: float) -> None: ...
    def Rotated(self, theA1: gp_Ax1, theAng: float) -> gp_Parab: ...
    def Scale(self, theP: gp_Pnt, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt, theS: float) -> gp_Parab: ...
    def SetAxis(self, theA1: gp_Ax1) -> None: ...
    def SetFocal(self, theFocal: float) -> None: ...
    def SetLocation(self, theP: gp_Pnt) -> None: ...
    def SetPosition(self, theA2: gp_Ax2) -> None: ...
    def Transform(self, theT: gp_Trsf) -> None: ...
    def Transformed(self, theT: gp_Trsf) -> gp_Parab: ...
    @overload
    def Translate(self, theV: gp_Vec) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt, theP2: gp_Pnt) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec) -> gp_Parab: ...
    @overload
    def Translated(self, theP1: gp_Pnt, theP2: gp_Pnt) -> gp_Parab: ...
    def XAxis(self) -> gp_Ax1: ...
    def YAxis(self) -> gp_Ax1: ...

class gp_Parab2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theMirrorAxis: gp_Ax2d, theFocalLength: float, theSense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, theAxes: gp_Ax22d, theFocalLength: float) -> None: ...
    @overload
    def __init__(self, theDirectrix: gp_Ax2d, theFocus: gp_Pnt2d, theSense: Optional[bool] = True) -> None: ...
    def Axis(self) -> gp_Ax22d: ...
    def Coefficients(self) -> Tuple[float, float, float, float, float, float]: ...
    def Directrix(self) -> gp_Ax2d: ...
    def Focal(self) -> float: ...
    def Focus(self) -> gp_Pnt2d: ...
    def IsDirect(self) -> bool: ...
    def Location(self) -> gp_Pnt2d: ...
    @overload
    def Mirror(self, theP: gp_Pnt2d) -> None: ...
    @overload
    def Mirror(self, theA: gp_Ax2d) -> None: ...
    def MirrorAxis(self) -> gp_Ax2d: ...
    @overload
    def Mirrored(self, theP: gp_Pnt2d) -> gp_Parab2d: ...
    @overload
    def Mirrored(self, theA: gp_Ax2d) -> gp_Parab2d: ...
    def Parameter(self) -> float: ...
    def Reverse(self) -> None: ...
    def Reversed(self) -> gp_Parab2d: ...
    def Rotate(self, theP: gp_Pnt2d, theAng: float) -> None: ...
    def Rotated(self, theP: gp_Pnt2d, theAng: float) -> gp_Parab2d: ...
    def Scale(self, theP: gp_Pnt2d, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt2d, theS: float) -> gp_Parab2d: ...
    def SetAxis(self, theA: gp_Ax22d) -> None: ...
    def SetFocal(self, theFocal: float) -> None: ...
    def SetLocation(self, theP: gp_Pnt2d) -> None: ...
    def SetMirrorAxis(self, theA: gp_Ax2d) -> None: ...
    def Transform(self, theT: gp_Trsf2d) -> None: ...
    def Transformed(self, theT: gp_Trsf2d) -> gp_Parab2d: ...
    @overload
    def Translate(self, theV: gp_Vec2d) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec2d) -> gp_Parab2d: ...
    @overload
    def Translated(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> gp_Parab2d: ...

class gp_Pln:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theA3: gp_Ax3) -> None: ...
    @overload
    def __init__(self, theP: gp_Pnt, theV: gp_Dir) -> None: ...
    @overload
    def __init__(self, theA: float, theB: float, theC: float, theD: float) -> None: ...
    def Axis(self) -> gp_Ax1: ...
    def Coefficients(self) -> Tuple[float, float, float, float]: ...
    @overload
    def Contains(self, theP: gp_Pnt, theLinearTolerance: float) -> bool: ...
    @overload
    def Contains(self, theL: gp_Lin, theLinearTolerance: float, theAngularTolerance: float) -> bool: ...
    def Direct(self) -> bool: ...
    @overload
    def Distance(self, theP: gp_Pnt) -> float: ...
    @overload
    def Distance(self, theL: gp_Lin) -> float: ...
    @overload
    def Distance(self, theOther: gp_Pln) -> float: ...
    def Location(self) -> gp_Pnt: ...
    @overload
    def Mirror(self, theP: gp_Pnt) -> None: ...
    @overload
    def Mirror(self, theA1: gp_Ax1) -> None: ...
    @overload
    def Mirror(self, theA2: gp_Ax2) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt) -> gp_Pln: ...
    @overload
    def Mirrored(self, theA1: gp_Ax1) -> gp_Pln: ...
    @overload
    def Mirrored(self, theA2: gp_Ax2) -> gp_Pln: ...
    def Position(self) -> gp_Ax3: ...
    def Rotate(self, theA1: gp_Ax1, theAng: float) -> None: ...
    def Rotated(self, theA1: gp_Ax1, theAng: float) -> gp_Pln: ...
    def Scale(self, theP: gp_Pnt, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt, theS: float) -> gp_Pln: ...
    def SetAxis(self, theA1: gp_Ax1) -> None: ...
    def SetLocation(self, theLoc: gp_Pnt) -> None: ...
    def SetPosition(self, theA3: gp_Ax3) -> None: ...
    @overload
    def SquareDistance(self, theP: gp_Pnt) -> float: ...
    @overload
    def SquareDistance(self, theL: gp_Lin) -> float: ...
    @overload
    def SquareDistance(self, theOther: gp_Pln) -> float: ...
    def Transform(self, theT: gp_Trsf) -> None: ...
    def Transformed(self, theT: gp_Trsf) -> gp_Pln: ...
    @overload
    def Translate(self, theV: gp_Vec) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt, theP2: gp_Pnt) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec) -> gp_Pln: ...
    @overload
    def Translated(self, theP1: gp_Pnt, theP2: gp_Pnt) -> gp_Pln: ...
    def UReverse(self) -> None: ...
    def VReverse(self) -> None: ...
    def XAxis(self) -> gp_Ax1: ...
    def YAxis(self) -> gp_Ax1: ...

class gp_Pnt:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theCoord: gp_XYZ) -> None: ...
    @overload
    def __init__(self, theXp: float, theYp: float, theZp: float) -> None: ...
    def BaryCenter(self, theAlpha: float, theP: gp_Pnt, theBeta: float) -> None: ...
    def ChangeCoord(self) -> gp_XYZ: ...
    @overload
    def Coord(self, theIndex: int) -> float: ...
    @overload
    def Coord(self) -> Tuple[float, float, float]: ...
    @overload
    def Coord(self) -> gp_XYZ: ...
    def Distance(self, theOther: gp_Pnt) -> float: ...
    def InitFromJson(self, theSStream: Standard_SStream) -> Tuple[bool, int]: ...
    def IsEqual(self, theOther: gp_Pnt, theLinearTolerance: float) -> bool: ...
    @overload
    def Mirror(self, theP: gp_Pnt) -> None: ...
    @overload
    def Mirror(self, theA1: gp_Ax1) -> None: ...
    @overload
    def Mirror(self, theA2: gp_Ax2) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt) -> gp_Pnt: ...
    @overload
    def Mirrored(self, theA1: gp_Ax1) -> gp_Pnt: ...
    @overload
    def Mirrored(self, theA2: gp_Ax2) -> gp_Pnt: ...
    def Rotate(self, theA1: gp_Ax1, theAng: float) -> None: ...
    def Rotated(self, theA1: gp_Ax1, theAng: float) -> gp_Pnt: ...
    def Scale(self, theP: gp_Pnt, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt, theS: float) -> gp_Pnt: ...
    @overload
    def SetCoord(self, theIndex: int, theXi: float) -> None: ...
    @overload
    def SetCoord(self, theXp: float, theYp: float, theZp: float) -> None: ...
    def SetX(self, theX: float) -> None: ...
    def SetXYZ(self, theCoord: gp_XYZ) -> None: ...
    def SetY(self, theY: float) -> None: ...
    def SetZ(self, theZ: float) -> None: ...
    def SquareDistance(self, theOther: gp_Pnt) -> float: ...
    def Transform(self, theT: gp_Trsf) -> None: ...
    def Transformed(self, theT: gp_Trsf) -> gp_Pnt: ...
    @overload
    def Translate(self, theV: gp_Vec) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt, theP2: gp_Pnt) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec) -> gp_Pnt: ...
    @overload
    def Translated(self, theP1: gp_Pnt, theP2: gp_Pnt) -> gp_Pnt: ...
    def X(self) -> float: ...
    def XYZ(self) -> gp_XYZ: ...
    def Y(self) -> float: ...
    def Z(self) -> float: ...

class gp_Pnt2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theCoord: gp_XY) -> None: ...
    @overload
    def __init__(self, theXp: float, theYp: float) -> None: ...
    def ChangeCoord(self) -> gp_XY: ...
    @overload
    def Coord(self, theIndex: int) -> float: ...
    @overload
    def Coord(self) -> Tuple[float, float]: ...
    @overload
    def Coord(self) -> gp_XY: ...
    def Distance(self, theOther: gp_Pnt2d) -> float: ...
    def IsEqual(self, theOther: gp_Pnt2d, theLinearTolerance: float) -> bool: ...
    @overload
    def Mirror(self, theP: gp_Pnt2d) -> None: ...
    @overload
    def Mirror(self, theA: gp_Ax2d) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt2d) -> gp_Pnt2d: ...
    @overload
    def Mirrored(self, theA: gp_Ax2d) -> gp_Pnt2d: ...
    def Rotate(self, theP: gp_Pnt2d, theAng: float) -> None: ...
    def Rotated(self, theP: gp_Pnt2d, theAng: float) -> gp_Pnt2d: ...
    def Scale(self, theP: gp_Pnt2d, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt2d, theS: float) -> gp_Pnt2d: ...
    @overload
    def SetCoord(self, theIndex: int, theXi: float) -> None: ...
    @overload
    def SetCoord(self, theXp: float, theYp: float) -> None: ...
    def SetX(self, theX: float) -> None: ...
    def SetXY(self, theCoord: gp_XY) -> None: ...
    def SetY(self, theY: float) -> None: ...
    def SquareDistance(self, theOther: gp_Pnt2d) -> float: ...
    def Transform(self, theT: gp_Trsf2d) -> None: ...
    def Transformed(self, theT: gp_Trsf2d) -> gp_Pnt2d: ...
    @overload
    def Translate(self, theV: gp_Vec2d) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec2d) -> gp_Pnt2d: ...
    @overload
    def Translated(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> gp_Pnt2d: ...
    def X(self) -> float: ...
    def XY(self) -> gp_XY: ...
    def Y(self) -> float: ...

class gp_Quaternion:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theX: float, theY: float, theZ: float, theW: float) -> None: ...
    @overload
    def __init__(self, theVecFrom: gp_Vec, theVecTo: gp_Vec) -> None: ...
    @overload
    def __init__(self, theVecFrom: gp_Vec, theVecTo: gp_Vec, theHelpCrossVec: gp_Vec) -> None: ...
    @overload
    def __init__(self, theAxis: gp_Vec, theAngle: float) -> None: ...
    @overload
    def __init__(self, theMat: gp_Mat) -> None: ...
    def Add(self, theOther: gp_Quaternion) -> None: ...
    def Added(self, theOther: gp_Quaternion) -> gp_Quaternion: ...
    def Dot(self, theOther: gp_Quaternion) -> float: ...
    def GetEulerAngles(self, theOrder: gp_EulerSequence) -> Tuple[float, float, float]: ...
    def GetMatrix(self) -> gp_Mat: ...
    def GetRotationAngle(self) -> float: ...
    def GetVectorAndAngle(self, theAxis: gp_Vec) -> float: ...
    def Invert(self) -> None: ...
    def Inverted(self) -> gp_Quaternion: ...
    def IsEqual(self, theOther: gp_Quaternion) -> bool: ...
    def Multiplied(self, theOther: gp_Quaternion) -> gp_Quaternion: ...
    @overload
    def Multiply(self, theOther: gp_Quaternion) -> None: ...
    @overload
    def Multiply(self, theVec: gp_Vec) -> gp_Vec: ...
    def Negated(self) -> gp_Quaternion: ...
    def Norm(self) -> float: ...
    def Normalize(self) -> None: ...
    def Normalized(self) -> gp_Quaternion: ...
    def Reverse(self) -> None: ...
    def Reversed(self) -> gp_Quaternion: ...
    def Scale(self, theScale: float) -> None: ...
    def Scaled(self, theScale: float) -> gp_Quaternion: ...
    @overload
    def Set(self, theX: float, theY: float, theZ: float, theW: float) -> None: ...
    @overload
    def Set(self, theQuaternion: gp_Quaternion) -> None: ...
    def SetEulerAngles(self, theOrder: gp_EulerSequence, theAlpha: float, theBeta: float, theGamma: float) -> None: ...
    def SetIdent(self) -> None: ...
    def SetMatrix(self, theMat: gp_Mat) -> None: ...
    @overload
    def SetRotation(self, theVecFrom: gp_Vec, theVecTo: gp_Vec) -> None: ...
    @overload
    def SetRotation(self, theVecFrom: gp_Vec, theVecTo: gp_Vec, theHelpCrossVec: gp_Vec) -> None: ...
    def SetVectorAndAngle(self, theAxis: gp_Vec, theAngle: float) -> None: ...
    def SquareNorm(self) -> float: ...
    def StabilizeLength(self) -> None: ...
    def Subtract(self, theOther: gp_Quaternion) -> None: ...
    def Subtracted(self, theOther: gp_Quaternion) -> gp_Quaternion: ...
    def W(self) -> float: ...
    def X(self) -> float: ...
    def Y(self) -> float: ...
    def Z(self) -> float: ...

class gp_QuaternionNLerp:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theQStart: gp_Quaternion, theQEnd: gp_Quaternion) -> None: ...
    def Init(self, theQStart: gp_Quaternion, theQEnd: gp_Quaternion) -> None: ...
    def InitFromUnit(self, theQStart: gp_Quaternion, theQEnd: gp_Quaternion) -> None: ...
    @overload
    @staticmethod
    def Interpolate(theQStart: gp_Quaternion, theQEnd: gp_Quaternion, theT: float) -> gp_Quaternion: ...
    @overload
    def Interpolate(self, theT: float, theResultQ: gp_Quaternion) -> None: ...

class gp_QuaternionSLerp:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theQStart: gp_Quaternion, theQEnd: gp_Quaternion) -> None: ...
    def Init(self, theQStart: gp_Quaternion, theQEnd: gp_Quaternion) -> None: ...
    def InitFromUnit(self, theQStart: gp_Quaternion, theQEnd: gp_Quaternion) -> None: ...
    @overload
    @staticmethod
    def Interpolate(theQStart: gp_Quaternion, theQEnd: gp_Quaternion, theT: float) -> gp_Quaternion: ...
    @overload
    def Interpolate(self, theT: float, theResultQ: gp_Quaternion) -> None: ...

class gp_Sphere:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theA3: gp_Ax3, theRadius: float) -> None: ...
    def Area(self) -> float: ...
    def Coefficients(self) -> Tuple[float, float, float, float, float, float, float, float, float, float]: ...
    def Direct(self) -> bool: ...
    def Location(self) -> gp_Pnt: ...
    @overload
    def Mirror(self, theP: gp_Pnt) -> None: ...
    @overload
    def Mirror(self, theA1: gp_Ax1) -> None: ...
    @overload
    def Mirror(self, theA2: gp_Ax2) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt) -> gp_Sphere: ...
    @overload
    def Mirrored(self, theA1: gp_Ax1) -> gp_Sphere: ...
    @overload
    def Mirrored(self, theA2: gp_Ax2) -> gp_Sphere: ...
    def Position(self) -> gp_Ax3: ...
    def Radius(self) -> float: ...
    def Rotate(self, theA1: gp_Ax1, theAng: float) -> None: ...
    def Rotated(self, theA1: gp_Ax1, theAng: float) -> gp_Sphere: ...
    def Scale(self, theP: gp_Pnt, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt, theS: float) -> gp_Sphere: ...
    def SetLocation(self, theLoc: gp_Pnt) -> None: ...
    def SetPosition(self, theA3: gp_Ax3) -> None: ...
    def SetRadius(self, theR: float) -> None: ...
    def Transform(self, theT: gp_Trsf) -> None: ...
    def Transformed(self, theT: gp_Trsf) -> gp_Sphere: ...
    @overload
    def Translate(self, theV: gp_Vec) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt, theP2: gp_Pnt) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec) -> gp_Sphere: ...
    @overload
    def Translated(self, theP1: gp_Pnt, theP2: gp_Pnt) -> gp_Sphere: ...
    def UReverse(self) -> None: ...
    def VReverse(self) -> None: ...
    def Volume(self) -> float: ...
    def XAxis(self) -> gp_Ax1: ...
    def YAxis(self) -> gp_Ax1: ...

class gp_Torus:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theA3: gp_Ax3, theMajorRadius: float, theMinorRadius: float) -> None: ...
    def Area(self) -> float: ...
    def Axis(self) -> gp_Ax1: ...
    def Coefficients(self, theCoef: TColStd_Array1OfReal) -> None: ...
    def Direct(self) -> bool: ...
    def Location(self) -> gp_Pnt: ...
    def MajorRadius(self) -> float: ...
    def MinorRadius(self) -> float: ...
    @overload
    def Mirror(self, theP: gp_Pnt) -> None: ...
    @overload
    def Mirror(self, theA1: gp_Ax1) -> None: ...
    @overload
    def Mirror(self, theA2: gp_Ax2) -> None: ...
    @overload
    def Mirrored(self, theP: gp_Pnt) -> gp_Torus: ...
    @overload
    def Mirrored(self, theA1: gp_Ax1) -> gp_Torus: ...
    @overload
    def Mirrored(self, theA2: gp_Ax2) -> gp_Torus: ...
    def Position(self) -> gp_Ax3: ...
    def Rotate(self, theA1: gp_Ax1, theAng: float) -> None: ...
    def Rotated(self, theA1: gp_Ax1, theAng: float) -> gp_Torus: ...
    def Scale(self, theP: gp_Pnt, theS: float) -> None: ...
    def Scaled(self, theP: gp_Pnt, theS: float) -> gp_Torus: ...
    def SetAxis(self, theA1: gp_Ax1) -> None: ...
    def SetLocation(self, theLoc: gp_Pnt) -> None: ...
    def SetMajorRadius(self, theMajorRadius: float) -> None: ...
    def SetMinorRadius(self, theMinorRadius: float) -> None: ...
    def SetPosition(self, theA3: gp_Ax3) -> None: ...
    def Transform(self, theT: gp_Trsf) -> None: ...
    def Transformed(self, theT: gp_Trsf) -> gp_Torus: ...
    @overload
    def Translate(self, theV: gp_Vec) -> None: ...
    @overload
    def Translate(self, theP1: gp_Pnt, theP2: gp_Pnt) -> None: ...
    @overload
    def Translated(self, theV: gp_Vec) -> gp_Torus: ...
    @overload
    def Translated(self, theP1: gp_Pnt, theP2: gp_Pnt) -> gp_Torus: ...
    def UReverse(self) -> None: ...
    def VReverse(self) -> None: ...
    def Volume(self) -> float: ...
    def XAxis(self) -> gp_Ax1: ...
    def YAxis(self) -> gp_Ax1: ...

class gp_Trsf:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theT: gp_Trsf2d) -> None: ...
    def Form(self) -> gp_TrsfForm: ...
    @overload
    def GetRotation(self, theAxis: gp_XYZ) -> Tuple[bool, float]: ...
    @overload
    def GetRotation(self) -> gp_Quaternion: ...
    def HVectorialPart(self) -> gp_Mat: ...
    def InitFromJson(self, theSStream: Standard_SStream) -> Tuple[bool, int]: ...
    def Invert(self) -> None: ...
    def Inverted(self) -> gp_Trsf: ...
    def IsNegative(self) -> bool: ...
    def Multiplied(self, theT: gp_Trsf) -> gp_Trsf: ...
    def Multiply(self, theT: gp_Trsf) -> None: ...
    def Power(self, theN: int) -> None: ...
    def Powered(self, theN: int) -> gp_Trsf: ...
    def PreMultiply(self, theT: gp_Trsf) -> None: ...
    def ScaleFactor(self) -> float: ...
    def SetDisplacement(self, theFromSystem1: gp_Ax3, theToSystem2: gp_Ax3) -> None: ...
    def SetForm(self, theP: gp_TrsfForm) -> None: ...
    @overload
    def SetMirror(self, theP: gp_Pnt) -> None: ...
    @overload
    def SetMirror(self, theA1: gp_Ax1) -> None: ...
    @overload
    def SetMirror(self, theA2: gp_Ax2) -> None: ...
    @overload
    def SetRotation(self, theA1: gp_Ax1, theAng: float) -> None: ...
    @overload
    def SetRotation(self, theR: gp_Quaternion) -> None: ...
    def SetRotationPart(self, theR: gp_Quaternion) -> None: ...
    def SetScale(self, theP: gp_Pnt, theS: float) -> None: ...
    def SetScaleFactor(self, theS: float) -> None: ...
    @overload
    def SetTransformation(self, theFromSystem1: gp_Ax3, theToSystem2: gp_Ax3) -> None: ...
    @overload
    def SetTransformation(self, theToSystem: gp_Ax3) -> None: ...
    @overload
    def SetTransformation(self, R: gp_Quaternion, theT: gp_Vec) -> None: ...
    @overload
    def SetTranslation(self, theV: gp_Vec) -> None: ...
    @overload
    def SetTranslation(self, theP1: gp_Pnt, theP2: gp_Pnt) -> None: ...
    def SetTranslationPart(self, theV: gp_Vec) -> None: ...
    def SetValues(self, a11: float, a12: float, a13: float, a14: float, a21: float, a22: float, a23: float, a24: float, a31: float, a32: float, a33: float, a34: float) -> None: ...
    @overload
    def Transforms(self) -> Tuple[float, float, float]: ...
    @overload
    def Transforms(self, theCoord: gp_XYZ) -> None: ...
    def TranslationPart(self) -> gp_XYZ: ...
    def Value(self, theRow: int, theCol: int) -> float: ...
    def VectorialPart(self) -> gp_Mat: ...

class gp_Trsf2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theT: gp_Trsf) -> None: ...
    def Form(self) -> gp_TrsfForm: ...
    def HVectorialPart(self) -> gp_Mat2d: ...
    def Invert(self) -> None: ...
    def Inverted(self) -> gp_Trsf2d: ...
    def IsNegative(self) -> bool: ...
    def Multiplied(self, theT: gp_Trsf2d) -> gp_Trsf2d: ...
    def Multiply(self, theT: gp_Trsf2d) -> None: ...
    def Power(self, theN: int) -> None: ...
    def Powered(self, theN: int) -> gp_Trsf2d: ...
    def PreMultiply(self, theT: gp_Trsf2d) -> None: ...
    def RotationPart(self) -> float: ...
    def ScaleFactor(self) -> float: ...
    @overload
    def SetMirror(self, theP: gp_Pnt2d) -> None: ...
    @overload
    def SetMirror(self, theA: gp_Ax2d) -> None: ...
    def SetRotation(self, theP: gp_Pnt2d, theAng: float) -> None: ...
    def SetScale(self, theP: gp_Pnt2d, theS: float) -> None: ...
    def SetScaleFactor(self, theS: float) -> None: ...
    @overload
    def SetTransformation(self, theFromSystem1: gp_Ax2d, theToSystem2: gp_Ax2d) -> None: ...
    @overload
    def SetTransformation(self, theToSystem: gp_Ax2d) -> None: ...
    @overload
    def SetTranslation(self, theV: gp_Vec2d) -> None: ...
    @overload
    def SetTranslation(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> None: ...
    def SetTranslationPart(self, theV: gp_Vec2d) -> None: ...
    def SetValues(self, a11: float, a12: float, a13: float, a21: float, a22: float, a23: float) -> None: ...
    @overload
    def Transforms(self) -> Tuple[float, float]: ...
    @overload
    def Transforms(self, theCoord: gp_XY) -> None: ...
    def TranslationPart(self) -> gp_XY: ...
    def Value(self, theRow: int, theCol: int) -> float: ...
    def VectorialPart(self) -> gp_Mat2d: ...

class gp_Vec:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theV: gp_Dir) -> None: ...
    @overload
    def __init__(self, theCoord: gp_XYZ) -> None: ...
    @overload
    def __init__(self, theXv: float, theYv: float, theZv: float) -> None: ...
    @overload
    def __init__(self, theP1: gp_Pnt, theP2: gp_Pnt) -> None: ...
    def Add(self, theOther: gp_Vec) -> None: ...
    def Added(self, theOther: gp_Vec) -> gp_Vec: ...
    def Angle(self, theOther: gp_Vec) -> float: ...
    def AngleWithRef(self, theOther: gp_Vec, theVRef: gp_Vec) -> float: ...
    @overload
    def Coord(self, theIndex: int) -> float: ...
    @overload
    def Coord(self) -> Tuple[float, float, float]: ...
    def Cross(self, theRight: gp_Vec) -> None: ...
    def CrossCross(self, theV1: gp_Vec, theV2: gp_Vec) -> None: ...
    def CrossCrossed(self, theV1: gp_Vec, theV2: gp_Vec) -> gp_Vec: ...
    def CrossMagnitude(self, theRight: gp_Vec) -> float: ...
    def CrossSquareMagnitude(self, theRight: gp_Vec) -> float: ...
    def Crossed(self, theRight: gp_Vec) -> gp_Vec: ...
    def Divide(self, theScalar: float) -> None: ...
    def Divided(self, theScalar: float) -> gp_Vec: ...
    def Dot(self, theOther: gp_Vec) -> float: ...
    def DotCross(self, theV1: gp_Vec, theV2: gp_Vec) -> float: ...
    def IsEqual(self, theOther: gp_Vec, theLinearTolerance: float, theAngularTolerance: float) -> bool: ...
    def IsNormal(self, theOther: gp_Vec, theAngularTolerance: float) -> bool: ...
    def IsOpposite(self, theOther: gp_Vec, theAngularTolerance: float) -> bool: ...
    def IsParallel(self, theOther: gp_Vec, theAngularTolerance: float) -> bool: ...
    def Magnitude(self) -> float: ...
    @overload
    def Mirror(self, theV: gp_Vec) -> None: ...
    @overload
    def Mirror(self, theA1: gp_Ax1) -> None: ...
    @overload
    def Mirror(self, theA2: gp_Ax2) -> None: ...
    @overload
    def Mirrored(self, theV: gp_Vec) -> gp_Vec: ...
    @overload
    def Mirrored(self, theA1: gp_Ax1) -> gp_Vec: ...
    @overload
    def Mirrored(self, theA2: gp_Ax2) -> gp_Vec: ...
    def Multiplied(self, theScalar: float) -> gp_Vec: ...
    def Multiply(self, theScalar: float) -> None: ...
    def Normalize(self) -> None: ...
    def Normalized(self) -> gp_Vec: ...
    def Reverse(self) -> None: ...
    def Reversed(self) -> gp_Vec: ...
    def Rotate(self, theA1: gp_Ax1, theAng: float) -> None: ...
    def Rotated(self, theA1: gp_Ax1, theAng: float) -> gp_Vec: ...
    def Scale(self, theS: float) -> None: ...
    def Scaled(self, theS: float) -> gp_Vec: ...
    @overload
    def SetCoord(self, theIndex: int, theXi: float) -> None: ...
    @overload
    def SetCoord(self, theXv: float, theYv: float, theZv: float) -> None: ...
    @overload
    def SetLinearForm(self, theA1: float, theV1: gp_Vec, theA2: float, theV2: gp_Vec, theA3: float, theV3: gp_Vec, theV4: gp_Vec) -> None: ...
    @overload
    def SetLinearForm(self, theA1: float, theV1: gp_Vec, theA2: float, theV2: gp_Vec, theA3: float, theV3: gp_Vec) -> None: ...
    @overload
    def SetLinearForm(self, theA1: float, theV1: gp_Vec, theA2: float, theV2: gp_Vec, theV3: gp_Vec) -> None: ...
    @overload
    def SetLinearForm(self, theA1: float, theV1: gp_Vec, theA2: float, theV2: gp_Vec) -> None: ...
    @overload
    def SetLinearForm(self, theA1: float, theV1: gp_Vec, theV2: gp_Vec) -> None: ...
    @overload
    def SetLinearForm(self, theV1: gp_Vec, theV2: gp_Vec) -> None: ...
    def SetX(self, theX: float) -> None: ...
    def SetXYZ(self, theCoord: gp_XYZ) -> None: ...
    def SetY(self, theY: float) -> None: ...
    def SetZ(self, theZ: float) -> None: ...
    def SquareMagnitude(self) -> float: ...
    def Subtract(self, theRight: gp_Vec) -> None: ...
    def Subtracted(self, theRight: gp_Vec) -> gp_Vec: ...
    def Transform(self, theT: gp_Trsf) -> None: ...
    def Transformed(self, theT: gp_Trsf) -> gp_Vec: ...
    def X(self) -> float: ...
    def XYZ(self) -> gp_XYZ: ...
    def Y(self) -> float: ...
    def Z(self) -> float: ...

class gp_Vec2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theV: gp_Dir2d) -> None: ...
    @overload
    def __init__(self, theCoord: gp_XY) -> None: ...
    @overload
    def __init__(self, theXv: float, theYv: float) -> None: ...
    @overload
    def __init__(self, theP1: gp_Pnt2d, theP2: gp_Pnt2d) -> None: ...
    def Add(self, theOther: gp_Vec2d) -> None: ...
    def Added(self, theOther: gp_Vec2d) -> gp_Vec2d: ...
    def Angle(self, theOther: gp_Vec2d) -> float: ...
    @overload
    def Coord(self, theIndex: int) -> float: ...
    @overload
    def Coord(self) -> Tuple[float, float]: ...
    def CrossMagnitude(self, theRight: gp_Vec2d) -> float: ...
    def CrossSquareMagnitude(self, theRight: gp_Vec2d) -> float: ...
    def Crossed(self, theRight: gp_Vec2d) -> float: ...
    def Divide(self, theScalar: float) -> None: ...
    def Divided(self, theScalar: float) -> gp_Vec2d: ...
    def Dot(self, theOther: gp_Vec2d) -> float: ...
    def GetNormal(self) -> gp_Vec2d: ...
    def IsEqual(self, theOther: gp_Vec2d, theLinearTolerance: float, theAngularTolerance: float) -> bool: ...
    def IsNormal(self, theOther: gp_Vec2d, theAngularTolerance: float) -> bool: ...
    def IsOpposite(self, theOther: gp_Vec2d, theAngularTolerance: float) -> bool: ...
    def IsParallel(self, theOther: gp_Vec2d, theAngularTolerance: float) -> bool: ...
    def Magnitude(self) -> float: ...
    @overload
    def Mirror(self, theV: gp_Vec2d) -> None: ...
    @overload
    def Mirror(self, theA1: gp_Ax2d) -> None: ...
    @overload
    def Mirrored(self, theV: gp_Vec2d) -> gp_Vec2d: ...
    @overload
    def Mirrored(self, theA1: gp_Ax2d) -> gp_Vec2d: ...
    def Multiplied(self, theScalar: float) -> gp_Vec2d: ...
    def Multiply(self, theScalar: float) -> None: ...
    def Normalize(self) -> None: ...
    def Normalized(self) -> gp_Vec2d: ...
    def Reverse(self) -> None: ...
    def Reversed(self) -> gp_Vec2d: ...
    def Rotate(self, theAng: float) -> None: ...
    def Rotated(self, theAng: float) -> gp_Vec2d: ...
    def Scale(self, theS: float) -> None: ...
    def Scaled(self, theS: float) -> gp_Vec2d: ...
    @overload
    def SetCoord(self, theIndex: int, theXi: float) -> None: ...
    @overload
    def SetCoord(self, theXv: float, theYv: float) -> None: ...
    @overload
    def SetLinearForm(self, theA1: float, theV1: gp_Vec2d, theA2: float, theV2: gp_Vec2d, theV3: gp_Vec2d) -> None: ...
    @overload
    def SetLinearForm(self, theA1: float, theV1: gp_Vec2d, theA2: float, theV2: gp_Vec2d) -> None: ...
    @overload
    def SetLinearForm(self, theA1: float, theV1: gp_Vec2d, theV2: gp_Vec2d) -> None: ...
    @overload
    def SetLinearForm(self, theV1: gp_Vec2d, theV2: gp_Vec2d) -> None: ...
    def SetX(self, theX: float) -> None: ...
    def SetXY(self, theCoord: gp_XY) -> None: ...
    def SetY(self, theY: float) -> None: ...
    def SquareMagnitude(self) -> float: ...
    def Subtract(self, theRight: gp_Vec2d) -> None: ...
    def Subtracted(self, theRight: gp_Vec2d) -> gp_Vec2d: ...
    def Transform(self, theT: gp_Trsf2d) -> None: ...
    def Transformed(self, theT: gp_Trsf2d) -> gp_Vec2d: ...
    def X(self) -> float: ...
    def XY(self) -> gp_XY: ...
    def Y(self) -> float: ...

class gp_XY:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theX: float, theY: float) -> None: ...
    def Add(self, theOther: gp_XY) -> None: ...
    def Added(self, theOther: gp_XY) -> gp_XY: ...
    def GetChangeCoord(self, theIndex: int) -> float: ...
    def SetChangeCoord(self, theIndex: int, value: float) -> None: ...
    @overload
    def Coord(self, theIndex: int) -> float: ...
    @overload
    def Coord(self) -> Tuple[float, float]: ...
    def CrossMagnitude(self, theRight: gp_XY) -> float: ...
    def CrossSquareMagnitude(self, theRight: gp_XY) -> float: ...
    def Crossed(self, theOther: gp_XY) -> float: ...
    def Divide(self, theScalar: float) -> None: ...
    def Divided(self, theScalar: float) -> gp_XY: ...
    def Dot(self, theOther: gp_XY) -> float: ...
    def IsEqual(self, theOther: gp_XY, theTolerance: float) -> bool: ...
    def Modulus(self) -> float: ...
    @overload
    def Multiplied(self, theScalar: float) -> gp_XY: ...
    @overload
    def Multiplied(self, theOther: gp_XY) -> gp_XY: ...
    @overload
    def Multiplied(self, theMatrix: gp_Mat2d) -> gp_XY: ...
    @overload
    def Multiply(self, theScalar: float) -> None: ...
    @overload
    def Multiply(self, theOther: gp_XY) -> None: ...
    @overload
    def Multiply(self, theMatrix: gp_Mat2d) -> None: ...
    def Normalize(self) -> None: ...
    def Normalized(self) -> gp_XY: ...
    def Reverse(self) -> None: ...
    def Reversed(self) -> gp_XY: ...
    @overload
    def SetCoord(self, theIndex: int, theXi: float) -> None: ...
    @overload
    def SetCoord(self, theX: float, theY: float) -> None: ...
    @overload
    def SetLinearForm(self, theA1: float, theXY1: gp_XY, theA2: float, theXY2: gp_XY) -> None: ...
    @overload
    def SetLinearForm(self, theA1: float, theXY1: gp_XY, theA2: float, theXY2: gp_XY, theXY3: gp_XY) -> None: ...
    @overload
    def SetLinearForm(self, theA1: float, theXY1: gp_XY, theXY2: gp_XY) -> None: ...
    @overload
    def SetLinearForm(self, theXY1: gp_XY, theXY2: gp_XY) -> None: ...
    def SetX(self, theX: float) -> None: ...
    def SetY(self, theY: float) -> None: ...
    def SquareModulus(self) -> float: ...
    def Subtract(self, theOther: gp_XY) -> None: ...
    def Subtracted(self, theOther: gp_XY) -> gp_XY: ...
    def X(self) -> float: ...
    def Y(self) -> float: ...

class gp_XYZ:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theX: float, theY: float, theZ: float) -> None: ...
    def Add(self, theOther: gp_XYZ) -> None: ...
    def Added(self, theOther: gp_XYZ) -> gp_XYZ: ...
    def GetChangeCoord(self, theIndex: int) -> float: ...
    def SetChangeCoord(self, theIndex: int, value: float) -> None: ...
    def ChangeData(self) -> float: ...
    @overload
    def Coord(self, theIndex: int) -> float: ...
    @overload
    def Coord(self) -> Tuple[float, float, float]: ...
    def Cross(self, theOther: gp_XYZ) -> None: ...
    def CrossCross(self, theCoord1: gp_XYZ, theCoord2: gp_XYZ) -> None: ...
    def CrossCrossed(self, theCoord1: gp_XYZ, theCoord2: gp_XYZ) -> gp_XYZ: ...
    def CrossMagnitude(self, theRight: gp_XYZ) -> float: ...
    def CrossSquareMagnitude(self, theRight: gp_XYZ) -> float: ...
    def Crossed(self, theOther: gp_XYZ) -> gp_XYZ: ...
    def Divide(self, theScalar: float) -> None: ...
    def Divided(self, theScalar: float) -> gp_XYZ: ...
    def Dot(self, theOther: gp_XYZ) -> float: ...
    def DotCross(self, theCoord1: gp_XYZ, theCoord2: gp_XYZ) -> float: ...
    def GetData(self) -> float: ...
    def InitFromJson(self, theSStream: Standard_SStream) -> Tuple[bool, int]: ...
    def IsEqual(self, theOther: gp_XYZ, theTolerance: float) -> bool: ...
    def Modulus(self) -> float: ...
    @overload
    def Multiplied(self, theScalar: float) -> gp_XYZ: ...
    @overload
    def Multiplied(self, theOther: gp_XYZ) -> gp_XYZ: ...
    @overload
    def Multiplied(self, theMatrix: gp_Mat) -> gp_XYZ: ...
    @overload
    def Multiply(self, theScalar: float) -> None: ...
    @overload
    def Multiply(self, theOther: gp_XYZ) -> None: ...
    @overload
    def Multiply(self, theMatrix: gp_Mat) -> None: ...
    def Normalize(self) -> None: ...
    def Normalized(self) -> gp_XYZ: ...
    def Reverse(self) -> None: ...
    def Reversed(self) -> gp_XYZ: ...
    @overload
    def SetCoord(self, theX: float, theY: float, theZ: float) -> None: ...
    @overload
    def SetCoord(self, theIndex: int, theXi: float) -> None: ...
    @overload
    def SetLinearForm(self, theA1: float, theXYZ1: gp_XYZ, theA2: float, theXYZ2: gp_XYZ, theA3: float, theXYZ3: gp_XYZ, theXYZ4: gp_XYZ) -> None: ...
    @overload
    def SetLinearForm(self, theA1: float, theXYZ1: gp_XYZ, theA2: float, theXYZ2: gp_XYZ, theA3: float, theXYZ3: gp_XYZ) -> None: ...
    @overload
    def SetLinearForm(self, theA1: float, theXYZ1: gp_XYZ, theA2: float, theXYZ2: gp_XYZ, theXYZ3: gp_XYZ) -> None: ...
    @overload
    def SetLinearForm(self, theA1: float, theXYZ1: gp_XYZ, theA2: float, theXYZ2: gp_XYZ) -> None: ...
    @overload
    def SetLinearForm(self, theA1: float, theXYZ1: gp_XYZ, theXYZ2: gp_XYZ) -> None: ...
    @overload
    def SetLinearForm(self, theXYZ1: gp_XYZ, theXYZ2: gp_XYZ) -> None: ...
    def SetX(self, theX: float) -> None: ...
    def SetY(self, theY: float) -> None: ...
    def SetZ(self, theZ: float) -> None: ...
    def SquareModulus(self) -> float: ...
    def Subtract(self, theOther: gp_XYZ) -> None: ...
    def Subtracted(self, theOther: gp_XYZ) -> gp_XYZ: ...
    def X(self) -> float: ...
    def Y(self) -> float: ...
    def Z(self) -> float: ...

# harray1 classes
# harray2 classes
# hsequence classes

gp_DX = gp.DX
gp_DX2d = gp.DX2d
gp_DY = gp.DY
gp_DY2d = gp.DY2d
gp_DZ = gp.DZ
gp_OX = gp.OX
gp_OX2d = gp.OX2d
gp_OY = gp.OY
gp_OY2d = gp.OY2d
gp_OZ = gp.OZ
gp_Origin = gp.Origin
gp_Origin2d = gp.Origin2d
gp_Resolution = gp.Resolution
gp_XOY = gp.XOY
gp_YOZ = gp.YOZ
gp_ZOX = gp.ZOX
gp_QuaternionNLerp_Interpolate = gp_QuaternionNLerp.Interpolate
gp_QuaternionSLerp_Interpolate = gp_QuaternionSLerp.Interpolate
