import vscodeUri from 'vscode-uri';
import * as lsp from 'vscode-languageserver';
import { MarkdownString } from './MarkdownString.js';
import type { tsp } from '../ts-protocol.js';
export interface IFilePathToResourceConverter {
    /**
     * Convert a typescript filepath to an URI resource.
     */
    toResource(filepath: string): vscodeUri.URI;
}
export declare function plainWithLinks(parts: readonly tsp.SymbolDisplayPart[] | string, filePathConverter: IFilePathToResourceConverter): string;
export declare function tagsMarkdownPreview(tags: readonly tsp.JSDocTagInfo[], filePathConverter: IFilePathToResourceConverter): string;
export declare function markdownDocumentation(documentation: tsp.SymbolDisplayPart[] | string | undefined, tags: tsp.JSDocTagInfo[] | undefined, filePathConverter: IFilePathToResourceConverter): lsp.MarkupContent | undefined;
export declare function addMarkdownDocumentation(out: MarkdownString, documentation: string | tsp.SymbolDisplayPart[] | undefined, tags: tsp.JSDocTagInfo[] | undefined, converter: IFilePathToResourceConverter): MarkdownString;
//# sourceMappingURL=previewer.d.ts.map