/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import java.util.function.LongSupplier;
import org.opensearch.action.admin.indices.stats.CommonStatsFlags;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.ShardIndexingPressure;
import org.opensearch.index.shard.ShardId;
import org.opensearch.index.stats.IndexingPressureStats;
import org.opensearch.index.stats.ShardIndexingPressureStats;

public class IndexingPressureService {
    private final ShardIndexingPressure shardIndexingPressure;

    public IndexingPressureService(Settings settings, ClusterService clusterService) {
        this.shardIndexingPressure = new ShardIndexingPressure(settings, clusterService);
    }

    public Releasable markCoordinatingOperationStarted(LongSupplier bytes, boolean forceExecution) {
        if (!this.isShardIndexingPressureEnabled()) {
            return this.shardIndexingPressure.markCoordinatingOperationStarted(bytes.getAsLong(), forceExecution);
        }
        return () -> {};
    }

    public Releasable markCoordinatingOperationStarted(ShardId shardId, LongSupplier bytes, boolean forceExecution) {
        if (this.isShardIndexingPressureEnabled()) {
            return this.shardIndexingPressure.markCoordinatingOperationStarted(shardId, bytes.getAsLong(), forceExecution);
        }
        return () -> {};
    }

    public Releasable markPrimaryOperationStarted(ShardId shardId, long bytes, boolean forceExecution) {
        if (this.isShardIndexingPressureEnabled()) {
            return this.shardIndexingPressure.markPrimaryOperationStarted(shardId, bytes, forceExecution);
        }
        return this.shardIndexingPressure.markPrimaryOperationStarted(bytes, forceExecution);
    }

    public Releasable markPrimaryOperationLocalToCoordinatingNodeStarted(ShardId shardId, long bytes) {
        if (this.isShardIndexingPressureEnabled()) {
            return this.shardIndexingPressure.markPrimaryOperationLocalToCoordinatingNodeStarted(shardId, bytes);
        }
        return this.shardIndexingPressure.markPrimaryOperationLocalToCoordinatingNodeStarted(bytes);
    }

    public Releasable markReplicaOperationStarted(ShardId shardId, long bytes, boolean forceExecution) {
        if (this.isShardIndexingPressureEnabled()) {
            return this.shardIndexingPressure.markReplicaOperationStarted(shardId, bytes, forceExecution);
        }
        return this.shardIndexingPressure.markReplicaOperationStarted(bytes, forceExecution);
    }

    public IndexingPressureStats nodeStats() {
        return this.shardIndexingPressure.stats();
    }

    public ShardIndexingPressureStats shardStats(CommonStatsFlags statsFlags) {
        return this.shardIndexingPressure.shardStats(statsFlags);
    }

    private boolean isShardIndexingPressureEnabled() {
        return this.shardIndexingPressure.isShardIndexingPressureEnabled();
    }

    ShardIndexingPressure getShardIndexingPressure() {
        return this.shardIndexingPressure;
    }
}

