/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.persistent;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeOperationRequestBuilder;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.persistent.PersistentTaskResponse;
import org.opensearch.persistent.PersistentTasksClusterService;
import org.opensearch.persistent.PersistentTasksCustomMetadata;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class RemovePersistentTaskAction
extends ActionType<PersistentTaskResponse> {
    public static final RemovePersistentTaskAction INSTANCE = new RemovePersistentTaskAction();
    public static final String NAME = "cluster:admin/persistent/remove";

    private RemovePersistentTaskAction() {
        super(NAME, PersistentTaskResponse::new);
    }

    public static class TransportAction
    extends TransportClusterManagerNodeAction<Request, PersistentTaskResponse> {
        private final PersistentTasksClusterService persistentTasksClusterService;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PersistentTasksClusterService persistentTasksClusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(RemovePersistentTaskAction.NAME, transportService, clusterService, threadPool, actionFilters, Request::new, indexNameExpressionResolver);
            this.persistentTasksClusterService = persistentTasksClusterService;
        }

        @Override
        protected String executor() {
            return "management";
        }

        @Override
        protected PersistentTaskResponse read(StreamInput in) throws IOException {
            return new PersistentTaskResponse(in);
        }

        @Override
        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        @Override
        protected final void clusterManagerOperation(Request request, ClusterState state, ActionListener<PersistentTaskResponse> listener) {
            this.persistentTasksClusterService.removePersistentTask(request.taskId, ActionListener.delegateFailure(listener, (delegatedListener, task) -> delegatedListener.onResponse(new PersistentTaskResponse((PersistentTasksCustomMetadata.PersistentTask<?>)task))));
        }
    }

    public static class RequestBuilder
    extends ClusterManagerNodeOperationRequestBuilder<Request, PersistentTaskResponse, RequestBuilder> {
        protected RequestBuilder(OpenSearchClient client, RemovePersistentTaskAction action) {
            super(client, action, new Request());
        }

        public final RequestBuilder setTaskId(String taskId) {
            ((Request)this.request).setTaskId(taskId);
            return this;
        }
    }

    public static class Request
    extends ClusterManagerNodeRequest<Request> {
        private String taskId;

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.taskId = in.readString();
        }

        public Request(String taskId) {
            this.taskId = taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.taskId);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.taskId, request.taskId);
        }

        public int hashCode() {
            return Objects.hash(this.taskId);
        }
    }
}

