/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery.ec2;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.common.Strings;
import org.opensearch.common.util.LazyInitializable;
import org.opensearch.discovery.ec2.AmazonEc2Reference;
import org.opensearch.discovery.ec2.AwsEc2Service;
import org.opensearch.discovery.ec2.Ec2ClientSettings;
import org.opensearch.discovery.ec2.SocketAccess;

class AwsEc2ServiceImpl
implements AwsEc2Service {
    private static final Logger logger = LogManager.getLogger(AwsEc2ServiceImpl.class);
    private final AtomicReference<LazyInitializable<AmazonEc2Reference, OpenSearchException>> lazyClientReference = new AtomicReference();

    AwsEc2ServiceImpl() {
    }

    private AmazonEC2 buildClient(Ec2ClientSettings clientSettings) {
        AWSCredentialsProvider credentials = AwsEc2ServiceImpl.buildCredentials(logger, clientSettings);
        ClientConfiguration configuration = AwsEc2ServiceImpl.buildConfiguration(logger, clientSettings);
        return this.buildClient(credentials, configuration, clientSettings.endpoint);
    }

    AmazonEC2 buildClient(AWSCredentialsProvider credentials, ClientConfiguration configuration, String endpoint) {
        AmazonEC2ClientBuilder builder = (AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2ClientBuilder.standard().withCredentials(credentials)).withClientConfiguration(configuration);
        if (Strings.hasText((String)endpoint)) {
            logger.debug("using explicit ec2 endpoint [{}]", (Object)endpoint);
            builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, null));
        }
        return SocketAccess.doPrivileged(() -> ((AmazonEC2ClientBuilder)builder).build());
    }

    static ClientConfiguration buildConfiguration(Logger logger, Ec2ClientSettings clientSettings) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        clientConfiguration.setProtocol(clientSettings.protocol);
        if (Strings.hasText((String)clientSettings.proxyHost)) {
            clientConfiguration.setProxyHost(clientSettings.proxyHost);
            clientConfiguration.setProxyPort(clientSettings.proxyPort);
            clientConfiguration.setProxyUsername(clientSettings.proxyUsername);
            clientConfiguration.setProxyPassword(clientSettings.proxyPassword);
        }
        clientConfiguration.setMaxErrorRetry(10);
        clientConfiguration.setSocketTimeout(clientSettings.readTimeoutMillis);
        return clientConfiguration;
    }

    static AWSCredentialsProvider buildCredentials(Logger logger, Ec2ClientSettings clientSettings) {
        AWSCredentials credentials = clientSettings.credentials;
        if (credentials == null) {
            logger.debug("Using default provider chain");
            return DefaultAWSCredentialsProviderChain.getInstance();
        }
        logger.debug("Using basic key/secret credentials");
        return new AWSStaticCredentialsProvider(credentials);
    }

    @Override
    public AmazonEc2Reference client() {
        LazyInitializable<AmazonEc2Reference, OpenSearchException> clientReference = this.lazyClientReference.get();
        if (clientReference == null) {
            throw new IllegalStateException("Missing ec2 client configs");
        }
        return (AmazonEc2Reference)((Object)clientReference.getOrCompute());
    }

    @Override
    public void refreshAndClearCache(Ec2ClientSettings clientSettings) {
        LazyInitializable newClient = new LazyInitializable(() -> new AmazonEc2Reference(this.buildClient(clientSettings)), clientReference -> clientReference.incRef(), clientReference -> clientReference.decRef());
        LazyInitializable<AmazonEc2Reference, OpenSearchException> oldClient = this.lazyClientReference.getAndSet((LazyInitializable<AmazonEc2Reference, OpenSearchException>)newClient);
        if (oldClient != null) {
            oldClient.reset();
        }
    }

    @Override
    public void close() {
        LazyInitializable clientReference = this.lazyClientReference.getAndSet(null);
        if (clientReference != null) {
            clientReference.reset();
        }
        IdleConnectionReaper.shutdown();
    }
}

