/* WindowOverview.c generated by valac 0.56.3, the Vala compiler
 * generated from WindowOverview.vala, do not modify */

/*  */
/*  Copyright (C) 2012 Tom Beckmann, Rico Tzschichholz*/
/* */
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/* */
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/* */
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/* */

#include <glib-object.h>
#include <clutter/clutter.h>
#include <meta/boxes.h>
#include <glib.h>
#include "gala.h"
#include <meta/display.h>
#include <meta/workspace.h>
#include <stdlib.h>
#include <string.h>
#include <meta/window.h>
#include <meta/meta-workspace-manager.h>
#include <meta/meta-window-actor.h>
#include <meta/keybindings.h>
#include <float.h>
#include <math.h>
#include <meta/meta-plugin.h>
#include <meta/common.h>

#define GALA_WINDOW_OVERVIEW_BORDER 10
#define GALA_WINDOW_OVERVIEW_TOP_GAP 30
#define GALA_WINDOW_OVERVIEW_BOTTOM_GAP 100
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	GALA_WINDOW_OVERVIEW_TYPE_GRID = 0,
	GALA_WINDOW_OVERVIEW_TYPE_NATURAL
} GalaWindowOverviewType;

#define GALA_TYPE_WINDOW_OVERVIEW_TYPE (gala_window_overview_type_get_type ())
typedef void (*GalaWindowPlacer) (ClutterActor* window, MetaRectangle* rect, gpointer user_data);

#define GALA_TYPE_WINDOW_OVERVIEW (gala_window_overview_get_type ())
#define GALA_WINDOW_OVERVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview))
#define GALA_WINDOW_OVERVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverviewClass))
#define GALA_IS_WINDOW_OVERVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_OVERVIEW))
#define GALA_IS_WINDOW_OVERVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_OVERVIEW))
#define GALA_WINDOW_OVERVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverviewClass))

typedef struct _GalaWindowOverview GalaWindowOverview;
typedef struct _GalaWindowOverviewClass GalaWindowOverviewClass;
typedef struct _GalaWindowOverviewPrivate GalaWindowOverviewPrivate;
enum  {
	GALA_WINDOW_OVERVIEW_0_PROPERTY,
	GALA_WINDOW_OVERVIEW_WM_PROPERTY,
	GALA_WINDOW_OVERVIEW_NUM_PROPERTIES
};
static GParamSpec* gala_window_overview_properties[GALA_WINDOW_OVERVIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_WINDOW_CLONE_CONTAINER (gala_window_clone_container_get_type ())
#define GALA_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer))
#define GALA_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))
#define GALA_IS_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_IS_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_WINDOW_CLONE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))

typedef struct _GalaWindowCloneContainer GalaWindowCloneContainer;
typedef struct _GalaWindowCloneContainerClass GalaWindowCloneContainerClass;

#define GALA_TYPE_GESTURE_TRACKER (gala_gesture_tracker_get_type ())
#define GALA_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTracker))
#define GALA_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))
#define GALA_IS_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TRACKER))
#define GALA_IS_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_TRACKER))
#define GALA_GESTURE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))

typedef struct _GalaGestureTracker GalaGestureTracker;
typedef struct _GalaGestureTrackerClass GalaGestureTrackerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block69Data Block69Data;

struct _GalaWindowOverview {
	ClutterActor parent_instance;
	GalaWindowOverviewPrivate * priv;
};

struct _GalaWindowOverviewClass {
	ClutterActorClass parent_class;
};

struct _GalaWindowOverviewPrivate {
	GalaWindowManager* _wm;
	MetaDisplay* display;
	GalaModalProxy* modal_proxy;
	gboolean ready;
	GList* workspaces;
};

struct _Block69Data {
	int _ref_count_;
	GalaWindowOverview* self;
	MetaWindow* window;
};

static gint GalaWindowOverview_private_offset;
static gpointer gala_window_overview_parent_class = NULL;
static GalaActivatableComponentIface * gala_window_overview_gala_activatable_component_parent_iface = NULL;

VALA_EXTERN GType gala_window_overview_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_window_overview_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowOverview, g_object_unref)
static void gala_window_overview_restack_windows (GalaWindowOverview* self,
                                           MetaDisplay* display);
static void _gala_window_overview_restack_windows_meta_display_restacked (MetaDisplay* _sender,
                                                                   gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN GalaWindowOverview* gala_window_overview_new (GalaWindowManager* wm);
VALA_EXTERN GalaWindowOverview* gala_window_overview_construct (GType object_type,
                                                    GalaWindowManager* wm);
static gboolean gala_window_overview_real_key_press_event (ClutterActor* base,
                                                    ClutterKeyEvent* event);
static void gala_window_overview_real_key_focus_out (ClutterActor* base);
static gboolean gala_window_overview_real_button_press_event (ClutterActor* base,
                                                       ClutterButtonEvent* event);
static gboolean gala_window_overview_real_is_opened (GalaActivatableComponent* base);
static void gala_window_overview_real_open (GalaActivatableComponent* base,
                                     GHashTable* hints);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static void gala_window_overview_add_window (GalaWindowOverview* self,
                                      MetaWindow* window);
static void _gala_window_overview_add_window_meta_workspace_window_added (MetaWorkspace* _sender,
                                                                   MetaWindow* object,
                                                                   gpointer self);
static void gala_window_overview_remove_window (GalaWindowOverview* self,
                                         MetaWindow* window);
static void _gala_window_overview_remove_window_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                        MetaWindow* object,
                                                                        gpointer self);
static void gala_window_overview_window_left_monitor (GalaWindowOverview* self,
                                               gint num,
                                               MetaWindow* window);
static void _gala_window_overview_window_left_monitor_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                                 gint object,
                                                                                 MetaWindow* p0,
                                                                                 gpointer self);
VALA_EXTERN GalaWindowManager* gala_window_overview_get_wm (GalaWindowOverview* self);
static gboolean gala_window_overview_keybinding_filter (GalaWindowOverview* self,
                                                 MetaKeyBinding* binding);
static gboolean _gala_window_overview_keybinding_filter_gala_keybinding_filter (MetaKeyBinding* binding,
                                                                         gpointer self);
VALA_EXTERN GType gala_window_clone_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneContainer, g_object_unref)
VALA_EXTERN GType gala_gesture_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTracker, g_object_unref)
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_new (GalaGestureTracker* gesture_tracker,
                                                           gboolean overview_mode);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_construct (GType object_type,
                                                                 GalaGestureTracker* gesture_tracker,
                                                                 gboolean overview_mode);
VALA_EXTERN void gala_window_clone_container_set_padding_top (GalaWindowCloneContainer* self,
                                                  gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_left (GalaWindowCloneContainer* self,
                                                   gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_right (GalaWindowCloneContainer* self,
                                                    gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_bottom (GalaWindowCloneContainer* self,
                                                     gint value);
static void gala_window_overview_thumb_selected (GalaWindowOverview* self,
                                          MetaWindow* window);
static void _gala_window_overview_thumb_selected_gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                       MetaWindow* window,
                                                                                       gpointer self);
VALA_EXTERN void gala_window_clone_container_add_window (GalaWindowCloneContainer* self,
                                             MetaWindow* window);
VALA_EXTERN void gala_window_clone_container_open (GalaWindowCloneContainer* self,
                                       MetaWindow* selected_window,
                                       gboolean with_gesture,
                                       gboolean is_cancel_animation);
VALA_EXTERN void gala_window_clone_container_restack_windows (GalaWindowCloneContainer* self,
                                                  MetaDisplay* display);
VALA_EXTERN void gala_window_clone_container_remove_window (GalaWindowCloneContainer* self,
                                                MetaWindow* window);
static Block69Data* block69_data_ref (Block69Data* _data69_);
static void block69_data_unref (void * _userdata_);
static gboolean ___lambda133_ (Block69Data* _data69_);
static gboolean ____lambda133__gsource_func (gpointer self);
static void gala_window_overview_real_close (GalaActivatableComponent* base,
                                      GHashTable* hints);
VALA_EXTERN void gala_window_clone_container_close (GalaWindowCloneContainer* self,
                                        gboolean with_gesture,
                                        gboolean is_cancel_animation);
static gboolean __lambda132_ (GalaWindowOverview* self);
static void gala_window_overview_cleanup (GalaWindowOverview* self);
static gboolean ___lambda132__gsource_func (gpointer self);
static void gala_window_overview_set_wm (GalaWindowOverview* self,
                                  GalaWindowManager* value);
static GObject * gala_window_overview_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _gala_window_overview___lambda134_ (GalaWindowOverview* self);
static void __gala_window_overview___lambda134__meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                                                    gint object,
                                                                                    gint p0,
                                                                                    MetaMotionDirection p1,
                                                                                    gpointer self);
static void gala_window_overview_finalize (GObject * obj);
static GType gala_window_overview_get_type_once (void);
static void _vala_gala_window_overview_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gala_window_overview_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
gala_window_overview_type_get_type_once (void)
{
	static const GEnumValue values[] = {{GALA_WINDOW_OVERVIEW_TYPE_GRID, "GALA_WINDOW_OVERVIEW_TYPE_GRID", "grid"}, {GALA_WINDOW_OVERVIEW_TYPE_NATURAL, "GALA_WINDOW_OVERVIEW_TYPE_NATURAL", "natural"}, {0, NULL, NULL}};
	GType gala_window_overview_type_type_id;
	gala_window_overview_type_type_id = g_enum_register_static ("GalaWindowOverviewType", values);
	return gala_window_overview_type_type_id;
}

GType
gala_window_overview_type_get_type (void)
{
	static volatile gsize gala_window_overview_type_type_id__once = 0;
	if (g_once_init_enter (&gala_window_overview_type_type_id__once)) {
		GType gala_window_overview_type_type_id;
		gala_window_overview_type_type_id = gala_window_overview_type_get_type_once ();
		g_once_init_leave (&gala_window_overview_type_type_id__once, gala_window_overview_type_type_id);
	}
	return gala_window_overview_type_type_id__once;
}

static inline gpointer
gala_window_overview_get_instance_private (GalaWindowOverview* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowOverview_private_offset);
}

static void
_gala_window_overview_restack_windows_meta_display_restacked (MetaDisplay* _sender,
                                                              gpointer self)
{
	gala_window_overview_restack_windows ((GalaWindowOverview*) self, _sender);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GalaWindowOverview*
gala_window_overview_construct (GType object_type,
                                GalaWindowManager* wm)
{
	GalaWindowOverview * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaWindowOverview*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

GalaWindowOverview*
gala_window_overview_new (GalaWindowManager* wm)
{
	return gala_window_overview_construct (GALA_TYPE_WINDOW_OVERVIEW, wm);
}

static gboolean
gala_window_overview_real_key_press_event (ClutterActor* base,
                                           ClutterKeyEvent* event)
{
	GalaWindowOverview * self;
	gboolean result;
	self = (GalaWindowOverview*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->keyval == CLUTTER_KEY_Escape) {
		gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
gala_window_overview_real_key_focus_out (ClutterActor* base)
{
	GalaWindowOverview * self;
	ClutterStage* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	self = (GalaWindowOverview*) base;
	_tmp0_ = clutter_actor_get_stage ((ClutterActor*) self);
	_tmp1_ = clutter_stage_get_key_focus (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!clutter_actor_contains ((ClutterActor*) self, _tmp2_)) {
		gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
	}
}

static gboolean
gala_window_overview_real_button_press_event (ClutterActor* base,
                                              ClutterButtonEvent* event)
{
	GalaWindowOverview * self;
	gboolean result;
	self = (GalaWindowOverview*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint32) 1)) {
		gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
	}
	result = TRUE;
	return result;
}

/**
         * {@inheritDoc}
         */
static gboolean
gala_window_overview_real_is_opened (GalaActivatableComponent* base)
{
	GalaWindowOverview * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	self = (GalaWindowOverview*) base;
	g_object_get ((ClutterActor*) self, "visible", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}

/**
         * {@inheritDoc}
         * You may specify 'all-windows' in hints to expose all windows
         */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_gala_window_overview_add_window_meta_workspace_window_added (MetaWorkspace* _sender,
                                                              MetaWindow* object,
                                                              gpointer self)
{
	gala_window_overview_add_window ((GalaWindowOverview*) self, object);
}

static void
_gala_window_overview_remove_window_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                   MetaWindow* object,
                                                                   gpointer self)
{
	gala_window_overview_remove_window ((GalaWindowOverview*) self, object);
}

static void
_gala_window_overview_window_left_monitor_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                            gint object,
                                                                            MetaWindow* p0,
                                                                            gpointer self)
{
	gala_window_overview_window_left_monitor ((GalaWindowOverview*) self, object, p0);
}

static gboolean
_gala_window_overview_keybinding_filter_gala_keybinding_filter (MetaKeyBinding* binding,
                                                                gpointer self)
{
	gboolean result;
	result = gala_window_overview_keybinding_filter ((GalaWindowOverview*) self, binding);
	return result;
}

static void
_gala_window_overview_thumb_selected_gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                  MetaWindow* window,
                                                                                  gpointer self)
{
	gala_window_overview_thumb_selected ((GalaWindowOverview*) self, window);
}

static void
gala_window_overview_real_open (GalaActivatableComponent* base,
                                GHashTable* hints)
{
	GalaWindowOverview * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean all_windows = FALSE;
	GSList* used_windows = NULL;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp3_;
	MetaWorkspaceManager* _tmp4_;
	GList* _tmp14_;
	guint n_windows = 0U;
	GSList* _tmp46_;
	GList* _tmp47_;
	MetaDisplay* _tmp51_;
	GSList* windows = NULL;
	MetaDisplay* _tmp52_;
	GSList* _tmp53_;
	GSList* _tmp54_;
	GalaWindowManager* _tmp55_;
	GalaModalProxy* _tmp56_;
	GalaModalProxy* _tmp57_;
	GSList* _tmp72_;
	GList* _tmp82_;
	self = (GalaWindowOverview*) base;
	if (!self->priv->ready) {
		return;
	}
	g_object_get ((ClutterActor*) self, "visible", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
		return;
	}
	if (hints != NULL) {
		_tmp2_ = g_hash_table_contains (hints, "all-windows");
	} else {
		_tmp2_ = FALSE;
	}
	all_windows = _tmp2_;
	used_windows = NULL;
	(self->priv->workspaces == NULL) ? NULL : (self->priv->workspaces = (_g_list_free__g_object_unref0_ (self->priv->workspaces), NULL));
	self->priv->workspaces = NULL;
	_tmp3_ = self->priv->display;
	_tmp4_ = meta_display_get_workspace_manager (_tmp3_);
	manager = _tmp4_;
	if (all_windows) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					MetaWorkspaceManager* _tmp7_;
					MetaWorkspaceManager* _tmp8_;
					MetaWorkspace* _tmp9_;
					MetaWorkspace* _tmp10_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = manager;
					if (!(i < meta_workspace_manager_get_n_workspaces (_tmp7_))) {
						break;
					}
					_tmp8_ = manager;
					_tmp9_ = meta_workspace_manager_get_workspace_by_index (_tmp8_, i);
					_tmp10_ = _g_object_ref0 (_tmp9_);
					self->priv->workspaces = g_list_append (self->priv->workspaces, _tmp10_);
				}
			}
		}
	} else {
		MetaWorkspaceManager* _tmp11_;
		MetaWorkspace* _tmp12_;
		MetaWorkspace* _tmp13_;
		_tmp11_ = manager;
		_tmp12_ = meta_workspace_manager_get_active_workspace (_tmp11_);
		_tmp13_ = _g_object_ref0 (_tmp12_);
		self->priv->workspaces = g_list_append (self->priv->workspaces, _tmp13_);
	}
	_tmp14_ = self->priv->workspaces;
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp14_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp15_;
			MetaWorkspace* workspace = NULL;
			_tmp15_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp15_;
			{
				MetaWorkspace* _tmp16_;
				GList* _tmp17_;
				_tmp16_ = workspace;
				_tmp17_ = meta_workspace_list_windows (_tmp16_);
				{
					GList* window_collection = NULL;
					GList* window_it = NULL;
					window_collection = _tmp17_;
					for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
						MetaWindow* window = NULL;
						window = (MetaWindow*) window_it->data;
						{
							gboolean _tmp18_ = FALSE;
							gboolean _tmp19_ = FALSE;
							gboolean _tmp20_ = FALSE;
							MetaWindow* _tmp21_;
							MetaWindowType _tmp22_;
							MetaWindowType _tmp23_;
							MetaWindow* _tmp36_;
							MetaWindowType _tmp37_;
							MetaWindowType _tmp38_;
							gboolean _tmp39_ = FALSE;
							MetaWindow* _tmp40_;
							MetaWindow* _tmp44_;
							MetaWindow* _tmp45_;
							_tmp21_ = window;
							_tmp22_ = meta_window_get_window_type (_tmp21_);
							_tmp23_ = _tmp22_;
							if (_tmp23_ != META_WINDOW_NORMAL) {
								MetaWindow* _tmp24_;
								MetaWindowType _tmp25_;
								MetaWindowType _tmp26_;
								_tmp24_ = window;
								_tmp25_ = meta_window_get_window_type (_tmp24_);
								_tmp26_ = _tmp25_;
								_tmp20_ = _tmp26_ != META_WINDOW_DOCK;
							} else {
								_tmp20_ = FALSE;
							}
							if (_tmp20_) {
								MetaWindow* _tmp27_;
								MetaWindowType _tmp28_;
								MetaWindowType _tmp29_;
								_tmp27_ = window;
								_tmp28_ = meta_window_get_window_type (_tmp27_);
								_tmp29_ = _tmp28_;
								_tmp19_ = _tmp29_ != META_WINDOW_DIALOG;
							} else {
								_tmp19_ = FALSE;
							}
							if (_tmp19_) {
								_tmp18_ = TRUE;
							} else {
								MetaWindow* _tmp30_;
								_tmp30_ = window;
								_tmp18_ = meta_window_is_attached_dialog (_tmp30_);
							}
							if (_tmp18_) {
								MetaWindowActor* actor = NULL;
								MetaWindow* _tmp31_;
								GObject* _tmp32_;
								MetaWindowActor* _tmp33_;
								MetaWindowActor* _tmp34_;
								_tmp31_ = window;
								_tmp32_ = meta_window_get_compositor_private (_tmp31_);
								_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, meta_window_actor_get_type ()) ? ((MetaWindowActor*) _tmp32_) : NULL);
								actor = _tmp33_;
								_tmp34_ = actor;
								if (_tmp34_ != NULL) {
									MetaWindowActor* _tmp35_;
									_tmp35_ = actor;
									clutter_actor_hide ((ClutterActor*) _tmp35_);
								}
								_g_object_unref0 (actor);
								continue;
							}
							_tmp36_ = window;
							_tmp37_ = meta_window_get_window_type (_tmp36_);
							_tmp38_ = _tmp37_;
							if (_tmp38_ == META_WINDOW_DOCK) {
								continue;
							}
							_tmp40_ = window;
							if (meta_window_is_on_all_workspaces (_tmp40_)) {
								MetaWindow* _tmp41_;
								MetaWorkspace* _tmp42_;
								MetaWorkspace* _tmp43_;
								_tmp41_ = window;
								_tmp42_ = meta_window_get_workspace (_tmp41_);
								_tmp43_ = workspace;
								_tmp39_ = _tmp42_ != _tmp43_;
							} else {
								_tmp39_ = FALSE;
							}
							if (_tmp39_) {
								continue;
							}
							_tmp44_ = window;
							_tmp45_ = _g_object_ref0 (_tmp44_);
							used_windows = g_slist_append (used_windows, _tmp45_);
						}
					}
					(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
				}
				_g_object_unref0 (workspace);
			}
		}
	}
	_tmp46_ = used_windows;
	n_windows = g_slist_length (_tmp46_);
	if (n_windows == ((guint) 0)) {
		(used_windows == NULL) ? NULL : (used_windows = (_g_slist_free__g_object_unref0_ (used_windows), NULL));
		return;
	}
	self->priv->ready = FALSE;
	_tmp47_ = self->priv->workspaces;
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp47_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp48_;
			MetaWorkspace* workspace = NULL;
			_tmp48_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp48_;
			{
				MetaWorkspace* _tmp49_;
				MetaWorkspace* _tmp50_;
				_tmp49_ = workspace;
				g_signal_connect_object (_tmp49_, "window-added", (GCallback) _gala_window_overview_add_window_meta_workspace_window_added, self, 0);
				_tmp50_ = workspace;
				g_signal_connect_object (_tmp50_, "window-removed", (GCallback) _gala_window_overview_remove_window_meta_workspace_window_removed, self, 0);
				_g_object_unref0 (workspace);
			}
		}
	}
	_tmp51_ = self->priv->display;
	g_signal_connect_object (_tmp51_, "window-left-monitor", (GCallback) _gala_window_overview_window_left_monitor_meta_display_window_left_monitor, self, 0);
	_tmp52_ = self->priv->display;
	_tmp53_ = used_windows;
	_tmp54_ = meta_display_sort_windows_by_stacking (_tmp52_, _tmp53_);
	windows = _tmp54_;
	clutter_actor_grab_key_focus ((ClutterActor*) self);
	_tmp55_ = self->priv->_wm;
	_tmp56_ = gala_window_manager_push_modal (_tmp55_, (ClutterActor*) self);
	_g_object_unref0 (self->priv->modal_proxy);
	self->priv->modal_proxy = _tmp56_;
	_tmp57_ = self->priv->modal_proxy;
	gala_modal_proxy_set_keybinding_filter (_tmp57_, _gala_window_overview_keybinding_filter_gala_keybinding_filter, self);
	g_object_set ((ClutterActor*) self, "visible", TRUE, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp58_ = FALSE;
			_tmp58_ = TRUE;
			while (TRUE) {
				MetaDisplay* _tmp60_;
				MetaRectangle geometry = {0};
				MetaDisplay* _tmp61_;
				MetaRectangle _tmp62_ = {0};
				GalaWindowCloneContainer* container = NULL;
				GalaWindowCloneContainer* _tmp63_ = NULL;
				GalaWindowCloneContainer* _tmp64_;
				MetaRectangle _tmp65_;
				MetaRectangle _tmp66_;
				GalaWindowCloneContainer* _tmp67_;
				MetaRectangle _tmp68_;
				MetaRectangle _tmp69_;
				GalaWindowCloneContainer* _tmp70_;
				GalaWindowCloneContainer* _tmp71_;
				if (!_tmp58_) {
					gint _tmp59_;
					_tmp59_ = i;
					i = _tmp59_ + 1;
				}
				_tmp58_ = FALSE;
				_tmp60_ = self->priv->display;
				if (!(i < meta_display_get_n_monitors (_tmp60_))) {
					break;
				}
				_tmp61_ = self->priv->display;
				meta_display_get_monitor_geometry (_tmp61_, i, &_tmp62_);
				geometry = _tmp62_;
				_tmp63_ = gala_window_clone_container_new (NULL, TRUE);
				gala_window_clone_container_set_padding_top (_tmp63_, GALA_WINDOW_OVERVIEW_TOP_GAP);
				gala_window_clone_container_set_padding_left (_tmp63_, GALA_WINDOW_OVERVIEW_BORDER);
				gala_window_clone_container_set_padding_right (_tmp63_, GALA_WINDOW_OVERVIEW_BORDER);
				gala_window_clone_container_set_padding_bottom (_tmp63_, GALA_WINDOW_OVERVIEW_BOTTOM_GAP);
				g_object_ref_sink (_tmp63_);
				container = _tmp63_;
				_tmp64_ = container;
				_tmp65_ = geometry;
				_tmp66_ = geometry;
				clutter_actor_set_position ((ClutterActor*) _tmp64_, (gfloat) _tmp65_.x, (gfloat) _tmp66_.y);
				_tmp67_ = container;
				_tmp68_ = geometry;
				_tmp69_ = geometry;
				clutter_actor_set_size ((ClutterActor*) _tmp67_, (gfloat) _tmp68_.width, (gfloat) _tmp69_.height);
				_tmp70_ = container;
				g_signal_connect_object (_tmp70_, "window-selected", (GCallback) _gala_window_overview_thumb_selected_gala_window_clone_container_window_selected, self, 0);
				_tmp71_ = container;
				clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp71_);
				_g_object_unref0 (container);
			}
		}
	}
	_tmp72_ = windows;
	{
		GSList* window_collection = NULL;
		GSList* window_it = NULL;
		window_collection = _tmp72_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindowActor* actor = NULL;
				MetaWindow* _tmp73_;
				GObject* _tmp74_;
				MetaWindowActor* _tmp75_;
				GalaWindowCloneContainer* container = NULL;
				MetaWindow* _tmp77_;
				ClutterActor* _tmp78_;
				GalaWindowCloneContainer* _tmp79_;
				GalaWindowCloneContainer* _tmp80_;
				MetaWindow* _tmp81_;
				_tmp73_ = window;
				_tmp74_ = meta_window_get_compositor_private (_tmp73_);
				actor = G_TYPE_CHECK_INSTANCE_TYPE (_tmp74_, meta_window_actor_get_type ()) ? ((MetaWindowActor*) _tmp74_) : NULL;
				_tmp75_ = actor;
				if (_tmp75_ != NULL) {
					MetaWindowActor* _tmp76_;
					_tmp76_ = actor;
					clutter_actor_hide ((ClutterActor*) _tmp76_);
				}
				_tmp77_ = window;
				_tmp78_ = clutter_actor_get_child_at_index ((ClutterActor*) self, meta_window_get_monitor (_tmp77_));
				container = GALA_IS_WINDOW_CLONE_CONTAINER (_tmp78_) ? ((GalaWindowCloneContainer*) _tmp78_) : NULL;
				_tmp79_ = container;
				if (_tmp79_ == NULL) {
					continue;
				}
				_tmp80_ = container;
				_tmp81_ = window;
				gala_window_clone_container_add_window (_tmp80_, _tmp81_);
			}
		}
	}
	_tmp82_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp82_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				ClutterActor* _tmp83_;
				_tmp83_ = child;
				gala_window_clone_container_open (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer), NULL, FALSE, FALSE);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	self->priv->ready = TRUE;
	(windows == NULL) ? NULL : (windows = (g_slist_free (windows), NULL));
	(used_windows == NULL) ? NULL : (used_windows = (_g_slist_free__g_object_unref0_ (used_windows), NULL));
}

static gboolean
gala_window_overview_keybinding_filter (GalaWindowOverview* self,
                                        MetaKeyBinding* binding)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (binding != NULL, FALSE);
	_tmp0_ = meta_key_binding_get_name (binding);
	_tmp1_ = g_strdup (_tmp0_);
	name = _tmp1_;
	_tmp3_ = name;
	if (g_strcmp0 (_tmp3_, "expose-windows") != 0) {
		const gchar* _tmp4_;
		_tmp4_ = name;
		_tmp2_ = g_strcmp0 (_tmp4_, "expose-all-windows") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_g_free0 (name);
	return result;
}

static void
gala_window_overview_restack_windows (GalaWindowOverview* self,
                                      MetaDisplay* display)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	_tmp0_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				ClutterActor* _tmp1_;
				_tmp1_ = child;
				gala_window_clone_container_restack_windows (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer), display);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

static void
gala_window_overview_window_left_monitor (GalaWindowOverview* self,
                                          gint num,
                                          MetaWindow* window)
{
	GalaWindowCloneContainer* container = NULL;
	ClutterActor* _tmp0_;
	GalaWindowCloneContainer* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = clutter_actor_get_child_at_index ((ClutterActor*) self, num);
	container = GALA_IS_WINDOW_CLONE_CONTAINER (_tmp0_) ? ((GalaWindowCloneContainer*) _tmp0_) : NULL;
	_tmp1_ = container;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->workspaces;
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp2_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp3_;
			MetaWorkspace* workspace = NULL;
			_tmp3_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp3_;
			{
				MetaWorkspace* _tmp4_;
				_tmp4_ = workspace;
				if (meta_window_located_on_workspace (window, _tmp4_)) {
					GalaWindowCloneContainer* _tmp5_;
					_tmp5_ = container;
					gala_window_clone_container_remove_window (_tmp5_, window);
					_g_object_unref0 (workspace);
					break;
				}
				_g_object_unref0 (workspace);
			}
		}
	}
}

static void
gala_window_overview_add_window (GalaWindowOverview* self,
                                 MetaWindow* window)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GalaWindowCloneContainer* container = NULL;
	ClutterActor* _tmp8_;
	GalaWindowCloneContainer* _tmp9_;
	GList* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_object_get ((ClutterActor*) self, "visible", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		MetaWindowType _tmp4_;
		MetaWindowType _tmp5_;
		_tmp4_ = meta_window_get_window_type (window);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != META_WINDOW_NORMAL) {
			MetaWindowType _tmp6_;
			MetaWindowType _tmp7_;
			_tmp6_ = meta_window_get_window_type (window);
			_tmp7_ = _tmp6_;
			_tmp3_ = _tmp7_ != META_WINDOW_DIALOG;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp8_ = clutter_actor_get_child_at_index ((ClutterActor*) self, meta_window_get_monitor (window));
	container = GALA_IS_WINDOW_CLONE_CONTAINER (_tmp8_) ? ((GalaWindowCloneContainer*) _tmp8_) : NULL;
	_tmp9_ = container;
	if (_tmp9_ == NULL) {
		return;
	}
	_tmp10_ = self->priv->workspaces;
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp10_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp11_;
			MetaWorkspace* workspace = NULL;
			_tmp11_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp11_;
			{
				MetaWorkspace* _tmp12_;
				_tmp12_ = workspace;
				if (meta_window_located_on_workspace (window, _tmp12_)) {
					GalaWindowCloneContainer* _tmp13_;
					_tmp13_ = container;
					gala_window_clone_container_add_window (_tmp13_, window);
					_g_object_unref0 (workspace);
					break;
				}
				_g_object_unref0 (workspace);
			}
		}
	}
}

static void
gala_window_overview_remove_window (GalaWindowOverview* self,
                                    MetaWindow* window)
{
	GalaWindowCloneContainer* container = NULL;
	ClutterActor* _tmp0_;
	GalaWindowCloneContainer* _tmp1_;
	GalaWindowCloneContainer* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = clutter_actor_get_child_at_index ((ClutterActor*) self, meta_window_get_monitor (window));
	container = GALA_IS_WINDOW_CLONE_CONTAINER (_tmp0_) ? ((GalaWindowCloneContainer*) _tmp0_) : NULL;
	_tmp1_ = container;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = container;
	gala_window_clone_container_remove_window (_tmp2_, window);
}

static Block69Data*
block69_data_ref (Block69Data* _data69_)
{
	g_atomic_int_inc (&_data69_->_ref_count_);
	return _data69_;
}

static void
block69_data_unref (void * _userdata_)
{
	Block69Data* _data69_;
	_data69_ = (Block69Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data69_->_ref_count_)) {
		GalaWindowOverview* self;
		self = _data69_->self;
		_g_object_unref0 (_data69_->window);
		_g_object_unref0 (self);
		g_slice_free (Block69Data, _data69_);
	}
}

static gboolean
___lambda133_ (Block69Data* _data69_)
{
	GalaWindowOverview* self;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	gboolean result;
	self = _data69_->self;
	_tmp0_ = meta_window_get_workspace (_data69_->window);
	_tmp1_ = self->priv->display;
	meta_workspace_activate_with_focus (_tmp0_, _data69_->window, meta_display_get_current_time (_tmp1_));
	result = FALSE;
	return result;
}

static gboolean
____lambda133__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda133_ (self);
	return result;
}

static void
gala_window_overview_thumb_selected (GalaWindowOverview* self,
                                     MetaWindow* window)
{
	Block69Data* _data69_;
	MetaWindow* _tmp0_;
	MetaWorkspace* _tmp1_;
	MetaDisplay* _tmp2_;
	MetaWorkspaceManager* _tmp3_;
	MetaWorkspace* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_data69_ = g_slice_new0 (Block69Data);
	_data69_->_ref_count_ = 1;
	_data69_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data69_->window);
	_data69_->window = _tmp0_;
	_tmp1_ = meta_window_get_workspace (_data69_->window);
	_tmp2_ = self->priv->display;
	_tmp3_ = meta_display_get_workspace_manager (_tmp2_);
	_tmp4_ = meta_workspace_manager_get_active_workspace (_tmp3_);
	if (_tmp1_ == _tmp4_) {
		MetaDisplay* _tmp5_;
		_tmp5_ = self->priv->display;
		meta_window_activate (_data69_->window, meta_display_get_current_time (_tmp5_));
		gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
	} else {
		gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 400, ____lambda133__gsource_func, block69_data_ref (_data69_), block69_data_unref);
	}
	block69_data_unref (_data69_);
	_data69_ = NULL;
}

/**
         * {@inheritDoc}
         */
static gboolean
__lambda132_ (GalaWindowOverview* self)
{
	gboolean result;
	gala_window_overview_cleanup (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda132__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda132_ ((GalaWindowOverview*) self);
	return result;
}

static void
gala_window_overview_real_close (GalaActivatableComponent* base,
                                 GHashTable* hints)
{
	GalaWindowOverview * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GList* _tmp3_;
	MetaDisplay* _tmp9_;
	guint _tmp10_;
	GalaWindowManager* _tmp11_;
	GalaModalProxy* _tmp12_;
	GList* _tmp13_;
	self = (GalaWindowOverview*) base;
	g_object_get ((ClutterActor*) self, "visible", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !self->priv->ready;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->workspaces;
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp3_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp4_;
			MetaWorkspace* workspace = NULL;
			_tmp4_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp4_;
			{
				MetaWorkspace* _tmp5_;
				guint _tmp6_;
				MetaWorkspace* _tmp7_;
				guint _tmp8_;
				_tmp5_ = workspace;
				g_signal_parse_name ("window-added", meta_workspace_get_type (), &_tmp6_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _gala_window_overview_add_window_meta_workspace_window_added, self);
				_tmp7_ = workspace;
				g_signal_parse_name ("window-removed", meta_workspace_get_type (), &_tmp8_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _gala_window_overview_remove_window_meta_workspace_window_removed, self);
				_g_object_unref0 (workspace);
			}
		}
	}
	_tmp9_ = self->priv->display;
	g_signal_parse_name ("window-left-monitor", meta_display_get_type (), &_tmp10_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _gala_window_overview_window_left_monitor_meta_display_window_left_monitor, self);
	self->priv->ready = FALSE;
	_tmp11_ = self->priv->_wm;
	_tmp12_ = self->priv->modal_proxy;
	gala_window_manager_pop_modal (_tmp11_, _tmp12_);
	_tmp13_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp13_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				ClutterActor* _tmp14_;
				_tmp14_ = child;
				gala_window_clone_container_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer), FALSE, FALSE);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	clutter_threads_add_timeout ((guint) 300, ___lambda132__gsource_func, self);
}

static void
gala_window_overview_cleanup (GalaWindowOverview* self)
{
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	MetaWorkspace* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->ready = TRUE;
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	_tmp0_ = self->priv->display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	_tmp2_ = meta_workspace_manager_get_active_workspace (_tmp1_);
	_tmp3_ = meta_workspace_list_windows (_tmp2_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp3_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindow* _tmp4_;
				_tmp4_ = window;
				if (meta_window_showing_on_its_workspace (_tmp4_)) {
					MetaWindow* _tmp5_;
					GObject* _tmp6_;
					_tmp5_ = window;
					_tmp6_ = meta_window_get_compositor_private (_tmp5_);
					clutter_actor_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, clutter_actor_get_type (), ClutterActor));
				}
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	clutter_actor_destroy_all_children ((ClutterActor*) self);
}

GalaWindowManager*
gala_window_overview_get_wm (GalaWindowOverview* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_window_overview_set_wm (GalaWindowOverview* self,
                             GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_overview_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_overview_properties[GALA_WINDOW_OVERVIEW_WM_PROPERTY]);
	}
}

static void
_gala_window_overview___lambda134_ (GalaWindowOverview* self)
{
	gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
}

static void
__gala_window_overview___lambda134__meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                                               gint object,
                                                                               gint p0,
                                                                               MetaMotionDirection p1,
                                                                               gpointer self)
{
	_gala_window_overview___lambda134_ ((GalaWindowOverview*) self);
}

static GObject *
gala_window_overview_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowOverview * self;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaWorkspaceManager* _tmp4_;
	MetaDisplay* _tmp5_;
	parent_class = G_OBJECT_CLASS (gala_window_overview_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->display);
	self->priv->display = _tmp2_;
	_tmp3_ = self->priv->display;
	_tmp4_ = meta_display_get_workspace_manager (_tmp3_);
	g_signal_connect_object (_tmp4_, "workspace-switched", (GCallback) __gala_window_overview___lambda134__meta_workspace_manager_workspace_switched, self, 0);
	_tmp5_ = self->priv->display;
	g_signal_connect_object (_tmp5_, "restacked", (GCallback) _gala_window_overview_restack_windows_meta_display_restacked, self, 0);
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	self->priv->ready = TRUE;
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	return obj;
}

static void
gala_window_overview_class_init (GalaWindowOverviewClass * klass,
                                 gpointer klass_data)
{
	gala_window_overview_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowOverview_private_offset);
	((ClutterActorClass *) klass)->key_press_event = (gboolean (*) (ClutterActor*, ClutterKeyEvent*)) gala_window_overview_real_key_press_event;
	((ClutterActorClass *) klass)->key_focus_out = (void (*) (ClutterActor*)) gala_window_overview_real_key_focus_out;
	((ClutterActorClass *) klass)->button_press_event = (gboolean (*) (ClutterActor*, ClutterButtonEvent*)) gala_window_overview_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_overview_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_overview_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_window_overview_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_overview_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_OVERVIEW_WM_PROPERTY, gala_window_overview_properties[GALA_WINDOW_OVERVIEW_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_window_overview_gala_activatable_component_interface_init (GalaActivatableComponentIface * iface,
                                                                gpointer iface_data)
{
	gala_window_overview_gala_activatable_component_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_opened = (gboolean (*) (GalaActivatableComponent*)) gala_window_overview_real_is_opened;
	iface->open = (void (*) (GalaActivatableComponent*, GHashTable*)) gala_window_overview_real_open;
	iface->close = (void (*) (GalaActivatableComponent*, GHashTable*)) gala_window_overview_real_close;
}

static void
gala_window_overview_instance_init (GalaWindowOverview * self,
                                    gpointer klass)
{
	self->priv = gala_window_overview_get_instance_private (self);
}

static void
gala_window_overview_finalize (GObject * obj)
{
	GalaWindowOverview * self;
	MetaDisplay* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview);
	_tmp0_ = self->priv->display;
	g_signal_parse_name ("restacked", meta_display_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gala_window_overview_restack_windows_meta_display_restacked, self);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->display);
	_g_object_unref0 (self->priv->modal_proxy);
	(self->priv->workspaces == NULL) ? NULL : (self->priv->workspaces = (_g_list_free__g_object_unref0_ (self->priv->workspaces), NULL));
	G_OBJECT_CLASS (gala_window_overview_parent_class)->finalize (obj);
}

static GType
gala_window_overview_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowOverviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_overview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowOverview), 0, (GInstanceInitFunc) gala_window_overview_instance_init, NULL };
	static const GInterfaceInfo gala_activatable_component_info = { (GInterfaceInitFunc) gala_window_overview_gala_activatable_component_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_window_overview_type_id;
	gala_window_overview_type_id = g_type_register_static (clutter_actor_get_type (), "GalaWindowOverview", &g_define_type_info, 0);
	g_type_add_interface_static (gala_window_overview_type_id, GALA_TYPE_ACTIVATABLE_COMPONENT, &gala_activatable_component_info);
	GalaWindowOverview_private_offset = g_type_add_instance_private (gala_window_overview_type_id, sizeof (GalaWindowOverviewPrivate));
	return gala_window_overview_type_id;
}

GType
gala_window_overview_get_type (void)
{
	static volatile gsize gala_window_overview_type_id__once = 0;
	if (g_once_init_enter (&gala_window_overview_type_id__once)) {
		GType gala_window_overview_type_id;
		gala_window_overview_type_id = gala_window_overview_get_type_once ();
		g_once_init_leave (&gala_window_overview_type_id__once, gala_window_overview_type_id);
	}
	return gala_window_overview_type_id__once;
}

static void
_vala_gala_window_overview_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GalaWindowOverview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview);
	switch (property_id) {
		case GALA_WINDOW_OVERVIEW_WM_PROPERTY:
		g_value_set_object (value, gala_window_overview_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_overview_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GalaWindowOverview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview);
	switch (property_id) {
		case GALA_WINDOW_OVERVIEW_WM_PROPERTY:
		gala_window_overview_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

