/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.imagery.street_level.IImageEntry;
import org.openstreetmap.josm.data.imagery.street_level.Projections;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.DoubleProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.viewers.projections.IImageViewer;
import org.openstreetmap.josm.gui.layer.geoimage.viewers.projections.ImageProjectionRegistry;
import org.openstreetmap.josm.gui.layer.imagery.ImageryFilterSettings;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.imagery.Vector3D;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProcessor;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class ImageDisplay
extends JComponent
implements Destroyable,
PreferenceChangedListener,
ImageryFilterSettings.FilterChangeListener {
    private IImageViewer iImageViewer;
    private IImageEntry<?> entry;
    private IImageEntry<?> oldEntry;
    private transient BufferedImage image;
    private transient BufferedImage processedImage;
    private final ImageProcessor imageProcessor;
    private boolean errorLoading;
    private VisRect visibleRect;
    private VisRect selectedRect;
    private final ImgDisplayMouseListener imgMouseListener = new ImgDisplayMouseListener();
    private String emptyText;
    private String osdText;
    private static final BooleanProperty AGPIFO_STYLE = new BooleanProperty("geoimage.agpifo-style-drag-and-zoom", false);
    private static int dragButton;
    private static int zoomButton;
    private static final BooleanProperty ZOOM_ON_CLICK;
    private static final DoubleProperty ZOOM_STEP;
    private static final DoubleProperty MAX_ZOOM;
    private static final IntegerProperty MAX_WIDTH;
    private static final BooleanProperty ERROR_MESSAGE_BACKGROUND;
    private UpdateImageThread updateImageThreadInstance;

    @Override
    public void preferenceChanged(PreferenceChangeEvent e) {
        if (e == null || e.getKey().equals(AGPIFO_STYLE.getKey())) {
            dragButton = AGPIFO_STYLE.get() != false ? 1 : 3;
            zoomButton = dragButton == 1 ? 3 : 1;
        }
    }

    public ImageDisplay() {
        this(imageObject -> imageObject);
    }

    public ImageDisplay(ImageProcessor imageProcessor) {
        this.addMouseListener(this.imgMouseListener);
        this.addMouseWheelListener(this.imgMouseListener);
        this.addMouseMotionListener(this.imgMouseListener);
        Config.getPref().addPreferenceChangeListener(this);
        this.preferenceChanged(null);
        this.imageProcessor = imageProcessor;
        if (imageProcessor instanceof ImageryFilterSettings) {
            ((ImageryFilterSettings)imageProcessor).addFilterChangeListener(this);
        }
    }

    @Override
    public void destroy() {
        this.removeMouseListener(this.imgMouseListener);
        this.removeMouseWheelListener(this.imgMouseListener);
        this.removeMouseMotionListener(this.imgMouseListener);
        Config.getPref().removePreferenceChangeListener(this);
        if (this.imageProcessor instanceof ImageryFilterSettings) {
            ((ImageryFilterSettings)this.imageProcessor).removeFilterChangeListener(this);
        }
    }

    public Future<?> setImage(IImageEntry<?> entry) {
        LoadImageRunnable runnable = this.setImage0(entry);
        return runnable != null ? MainApplication.worker.submit(runnable) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LoadImageRunnable setImage0(IImageEntry<?> entry) {
        ImageDisplay imageDisplay = this;
        synchronized (imageDisplay) {
            this.oldEntry = this.entry;
            this.entry = entry;
            if (entry == null) {
                this.image = null;
                this.updateProcessedImage();
                this.oldEntry = null;
            }
            this.errorLoading = false;
        }
        this.repaint();
        return entry != null ? new LoadImageRunnable(entry) : null;
    }

    public void setEmptyText(String emptyText) {
        this.emptyText = emptyText;
    }

    public void setOsdText(String text) {
        if (!text.equals(this.osdText)) {
            this.osdText = text;
            this.repaint();
        }
    }

    @Override
    public void filterChanged() {
        if (this.updateImageThreadInstance != null) {
            this.updateImageThreadInstance.restart();
        } else {
            this.updateImageThreadInstance = new UpdateImageThread();
            this.updateImageThreadInstance.start();
        }
    }

    private void updateProcessedImage() {
        this.processedImage = this.image == null ? null : this.imageProcessor.process(this.image);
        GuiHelper.runInEDT(this::repaint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        boolean currentErrorLoading;
        VisRect currentVisibleRect;
        IImageEntry<?> currentOldEntry;
        IImageEntry<?> currentEntry;
        BufferedImage currentImage;
        super.paintComponent(g);
        ImageDisplay imageDisplay = this;
        synchronized (imageDisplay) {
            currentImage = this.processedImage;
            currentEntry = this.entry;
            currentOldEntry = this.oldEntry;
            currentVisibleRect = this.visibleRect;
            currentErrorLoading = this.errorLoading;
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Dimension size = this.getSize();
        if (currentImage != null && (currentEntry != null || currentOldEntry != null)) {
            IImageViewer currentImageViewer = this.getIImageViewer(currentEntry);
            Rectangle r = new Rectangle(currentVisibleRect);
            VisRect target = ImageDisplay.calculateDrawImageRectangle(currentVisibleRect, size);
            currentImageViewer.paintImage(g, currentImage, target, r);
            this.paintSelectedRect(g, target, currentVisibleRect, size);
            if (currentErrorLoading && currentEntry != null) {
                String loadingStr = I18n.tr("Error on file {0}", currentEntry.getDisplayName());
                Rectangle2D noImageSize = g.getFontMetrics(g.getFont()).getStringBounds(loadingStr, g);
                g.drawString(loadingStr, (int)(((double)size.width - noImageSize.getWidth()) / 2.0), (int)(((double)size.height - noImageSize.getHeight()) / 2.0));
            }
            this.paintOsdText(g);
        }
        this.paintErrorMessage(g, currentEntry, currentOldEntry, currentImage, currentErrorLoading, size);
    }

    private void paintErrorMessage(Graphics g, IImageEntry<?> imageEntry, IImageEntry<?> oldImageEntry, BufferedImage bufferedImage, boolean currentErrorLoading, Dimension size) {
        String errorMessage;
        if (imageEntry == null) {
            if (this.emptyText == null) {
                this.emptyText = I18n.tr("No image", new Object[0]);
            }
            errorMessage = this.emptyText;
        } else {
            errorMessage = bufferedImage == null || !Objects.equals(imageEntry, oldImageEntry) ? (!currentErrorLoading ? I18n.tr("Loading {0}", imageEntry.getDisplayName()) : I18n.tr("Error on file {0}", imageEntry.getDisplayName())) : null;
        }
        if (!Utils.isBlank(errorMessage)) {
            Rectangle2D errorStringSize = g.getFontMetrics(g.getFont()).getStringBounds(errorMessage, g);
            if (Boolean.TRUE.equals(ERROR_MESSAGE_BACKGROUND.get())) {
                int height = g.getFontMetrics().getHeight();
                int descender = g.getFontMetrics().getDescent();
                g.setColor(this.getBackground());
                int width = (int)(errorStringSize.getWidth() * 1.0);
                int tlx = (int)((size.getWidth() - errorStringSize.getWidth()) / 2.0);
                int tly = (int)((size.getHeight() - 3.0 * errorStringSize.getHeight()) / 2.0 + (double)descender);
                g.fillRect(tlx, tly, width, height);
            }
            int llx = (int)(((double)size.width - errorStringSize.getWidth()) / 2.0);
            int lly = (int)(((double)size.height - errorStringSize.getHeight()) / 2.0);
            g.setColor(this.getForeground());
            g.drawString(errorMessage, llx, lly);
        }
    }

    private void paintOsdText(Graphics g) {
        if (this.osdText != null) {
            Rectangle2D lineSize;
            String line;
            FontMetrics metrics = g.getFontMetrics(g.getFont());
            int ascent = metrics.getAscent();
            Color bkground = new Color(255, 255, 255, 128);
            int lastPos = 0;
            int pos = this.osdText.indexOf(10);
            int x = 3;
            int y = 3;
            while (pos > 0) {
                line = this.osdText.substring(lastPos, pos);
                lineSize = metrics.getStringBounds(line, g);
                g.setColor(bkground);
                g.fillRect(x, y, (int)lineSize.getWidth(), (int)lineSize.getHeight());
                g.setColor(Color.black);
                g.drawString(line, x, y + ascent);
                y += (int)lineSize.getHeight();
                lastPos = pos + 1;
                pos = this.osdText.indexOf(10, lastPos);
            }
            line = this.osdText.substring(lastPos);
            lineSize = g.getFontMetrics(g.getFont()).getStringBounds(line, g);
            g.setColor(bkground);
            g.fillRect(x, y, (int)lineSize.getWidth(), (int)lineSize.getHeight());
            g.setColor(Color.black);
            g.drawString(line, x, y + ascent);
        }
    }

    private void paintSelectedRect(Graphics g, Rectangle target, VisRect visibleRectTemp, Dimension size) {
        if (this.selectedRect != null) {
            Point topLeft = ImageDisplay.img2compCoord(visibleRectTemp, this.selectedRect.x, this.selectedRect.y, size);
            Point bottomRight = ImageDisplay.img2compCoord(visibleRectTemp, this.selectedRect.x + this.selectedRect.width, this.selectedRect.y + this.selectedRect.height, size);
            g.setColor(new Color(128, 128, 128, 180));
            g.fillRect(target.x, target.y, target.width, topLeft.y - target.y);
            g.fillRect(target.x, target.y, topLeft.x - target.x, target.height);
            g.fillRect(bottomRight.x, target.y, target.x + target.width - bottomRight.x, target.height);
            g.fillRect(target.x, bottomRight.y, target.width, target.y + target.height - bottomRight.y);
            g.setColor(Color.black);
            g.drawRect(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
        }
    }

    static Point img2compCoord(VisRect visibleRect, int xImg, int yImg, Dimension compSize) {
        VisRect drawRect = ImageDisplay.calculateDrawImageRectangle(visibleRect, compSize);
        return new Point(drawRect.x + (xImg - visibleRect.x) * drawRect.width / visibleRect.width, drawRect.y + (yImg - visibleRect.y) * drawRect.height / visibleRect.height);
    }

    static Point comp2imgCoord(VisRect visibleRect, int xComp, int yComp, Dimension compSize) {
        VisRect drawRect = ImageDisplay.calculateDrawImageRectangle(visibleRect, compSize);
        Point p = new Point((xComp - drawRect.x) * visibleRect.width, (yComp - drawRect.y) * visibleRect.height);
        p.x = p.x + (p.x % drawRect.width << 1 >= drawRect.width ? drawRect.width : 0);
        p.y = p.y + (p.y % drawRect.height << 1 >= drawRect.height ? drawRect.height : 0);
        p.x = visibleRect.x + p.x / drawRect.width;
        p.y = visibleRect.y + p.y / drawRect.height;
        return p;
    }

    static Point getCenterImgCoord(Rectangle visibleRect) {
        return new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
    }

    static VisRect calculateDrawImageRectangle(VisRect visibleRect, Dimension compSize) {
        return ImageDisplay.calculateDrawImageRectangle(visibleRect, new Rectangle(0, 0, compSize.width, compSize.height));
    }

    static VisRect calculateDrawImageRectangle(VisRect imgRect, Rectangle compRect) {
        int x = 0;
        int y = 0;
        int w = compRect.width;
        int wFact = w * imgRect.height;
        int h = compRect.height;
        int hFact = h * imgRect.width;
        if (wFact != hFact) {
            if (wFact > hFact) {
                w = hFact / imgRect.height;
                x = (compRect.width - w) / 2;
            } else {
                h = wFact / imgRect.width;
                y = (compRect.height - h) / 2;
            }
        }
        if (w > imgRect.width && h > imgRect.height && !imgRect.isFullView1D() && wFact != hFact) {
            if (wFact > hFact) {
                w = compRect.width;
                x = 0;
                h = wFact / imgRect.width;
                y = (compRect.height - h) / 2;
            } else {
                h = compRect.height;
                y = 0;
                w = hFact / imgRect.height;
                x = (compRect.width - w) / 2;
            }
        }
        return new VisRect(x + compRect.x, y + compRect.y, w, h, imgRect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoomBestFitOrOne() {
        VisRect currentVisibleRect;
        BufferedImage currentImage;
        IImageEntry<?> currentEntry;
        ImageDisplay imageDisplay = this;
        synchronized (imageDisplay) {
            currentEntry = this.entry;
            currentImage = this.image;
            currentVisibleRect = this.visibleRect;
        }
        if (currentImage == null) {
            return;
        }
        if (currentVisibleRect.width != ((Image)currentImage).getWidth(null) || currentVisibleRect.height != ((Image)currentImage).getHeight(null)) {
            currentVisibleRect.reset();
        } else {
            Point center = ImageDisplay.getCenterImgCoord(currentVisibleRect);
            currentVisibleRect.setBounds(center.x - this.getWidth() / 2, center.y - this.getHeight() / 2, this.getWidth(), this.getHeight());
            currentVisibleRect.checkRectSize();
            currentVisibleRect.checkRectPos();
        }
        imageDisplay = this;
        synchronized (imageDisplay) {
            if (this.entry == currentEntry) {
                this.visibleRect = currentVisibleRect;
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImageViewer getIImageViewer(IImageEntry<?> entry) {
        IImageEntry<?> imageEntry;
        IImageViewer imageViewer;
        ImageDisplay imageDisplay = this;
        synchronized (imageDisplay) {
            imageViewer = this.iImageViewer;
            imageEntry = entry == null ? this.entry : entry;
        }
        if (imageEntry == null || imageViewer != null && imageViewer.getSupportedProjections().contains((Object)imageEntry.getProjectionType())) {
            return imageViewer;
        }
        try {
            imageViewer = ImageProjectionRegistry.getViewer(imageEntry.getProjectionType()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new JosmRuntimeException(e);
        }
        imageDisplay = this;
        synchronized (imageDisplay) {
            if (imageEntry.equals(this.entry)) {
                this.removeComponentListener(this.iImageViewer);
                this.iImageViewer = imageViewer;
                imageViewer.componentResized(new ComponentEvent(this, 101));
                this.addComponentListener(this.iImageViewer);
            }
        }
        return imageViewer;
    }

    public Vector3D getRotation(IImageEntry<?> entry) {
        return entry != null ? this.getIImageViewer(entry).getRotation() : null;
    }

    private void ensureMaxZoom(Rectangle rectangle) {
        int wFact;
        int hFact;
        if ((double)rectangle.width < (double)this.getSize().width / MAX_ZOOM.get()) {
            rectangle.width = (int)((double)this.getSize().width / MAX_ZOOM.get());
        }
        if ((double)rectangle.height < (double)this.getSize().height / MAX_ZOOM.get()) {
            rectangle.height = (int)((double)this.getSize().height / MAX_ZOOM.get());
        }
        if ((hFact = rectangle.height * this.getSize().width) > (wFact = rectangle.width * this.getSize().height)) {
            rectangle.width = hFact / this.getSize().height;
        } else {
            rectangle.height = wFact / this.getSize().width;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVisibleRectangle() {
        IImageViewer iImageViewer;
        BufferedImage mouseImage;
        VisRect currentVisibleRect;
        ImageDisplay imageDisplay = this;
        synchronized (imageDisplay) {
            currentVisibleRect = this.visibleRect;
            mouseImage = this.image;
            iImageViewer = this.getIImageViewer(this.entry);
        }
        if (mouseImage != null && currentVisibleRect != null && iImageViewer != null) {
            Image maxImageSize = iImageViewer.getMaxImageSize(this, mouseImage);
            VisRect maxVisibleRect = new VisRect(0, 0, maxImageSize.getWidth(null), maxImageSize.getHeight(null));
            maxVisibleRect.setRect(currentVisibleRect);
            this.ensureMaxZoom(maxVisibleRect);
            maxVisibleRect.checkRectSize();
            ImageDisplay imageDisplay2 = this;
            synchronized (imageDisplay2) {
                this.visibleRect = maxVisibleRect;
            }
        }
    }

    static {
        ZOOM_ON_CLICK = new BooleanProperty("geoimage.use-mouse-clicks-to-zoom", true);
        ZOOM_STEP = new DoubleProperty("geoimage.zoom-step-factor", 1.5);
        MAX_ZOOM = new DoubleProperty("geoimage.maximum-zoom-scale", 2.0);
        MAX_WIDTH = new IntegerProperty("geoimage.maximum-width", 6000);
        ERROR_MESSAGE_BACKGROUND = new BooleanProperty("geoimage.message.error.background", false);
    }

    private class ImgDisplayMouseListener
    extends MouseAdapter {
        private MouseEvent lastMouseEvent;
        private Point mousePointInImg;

        private ImgDisplayMouseListener() {
        }

        private boolean mouseIsDragging(MouseEvent e) {
            return dragButton == 1 && SwingUtilities.isLeftMouseButton(e) || dragButton == 2 && SwingUtilities.isMiddleMouseButton(e) || dragButton == 3 && SwingUtilities.isRightMouseButton(e);
        }

        private boolean mouseIsZoomSelecting(MouseEvent e) {
            return zoomButton == 1 && SwingUtilities.isLeftMouseButton(e) || zoomButton == 2 && SwingUtilities.isMiddleMouseButton(e) || zoomButton == 3 && SwingUtilities.isRightMouseButton(e);
        }

        private boolean isAtMaxZoom(Rectangle visibleRect) {
            return visibleRect.width == (int)((double)ImageDisplay.this.getSize().width / MAX_ZOOM.get()) || visibleRect.height == (int)((double)ImageDisplay.this.getSize().height / MAX_ZOOM.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mouseWheelMovedImpl(int x, int y, int rotation, boolean refreshMousePointInImg) {
            IImageViewer imageViewer;
            VisRect currentVisibleRect;
            BufferedImage currentImage;
            IImageEntry currentEntry;
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                currentEntry = ImageDisplay.this.entry;
                currentImage = ImageDisplay.this.image;
                currentVisibleRect = ImageDisplay.this.visibleRect;
                imageViewer = ImageDisplay.this.iImageViewer;
            }
            ImageDisplay.this.selectedRect = null;
            if (currentImage == null) {
                return;
            }
            if (refreshMousePointInImg) {
                this.mousePointInImg = ImageDisplay.comp2imgCoord(currentVisibleRect, x, y, ImageDisplay.this.getSize());
            }
            if (rotation > 0) {
                currentVisibleRect.width = (int)((double)currentVisibleRect.width * ZOOM_STEP.get());
                currentVisibleRect.height = (int)((double)currentVisibleRect.height * ZOOM_STEP.get());
            } else {
                currentVisibleRect.width = (int)((double)currentVisibleRect.width / ZOOM_STEP.get());
                currentVisibleRect.height = (int)((double)currentVisibleRect.height / ZOOM_STEP.get());
            }
            ImageDisplay.this.ensureMaxZoom(currentVisibleRect);
            if (imageViewer != null) {
                imageViewer.checkAndModifyVisibleRectSize(currentImage, currentVisibleRect);
            } else {
                currentVisibleRect.checkRectSize();
            }
            VisRect drawRect = ImageDisplay.calculateDrawImageRectangle(currentVisibleRect, ImageDisplay.this.getSize());
            currentVisibleRect.x = this.mousePointInImg.x + (drawRect.x - x) * currentVisibleRect.width / drawRect.width;
            currentVisibleRect.y = this.mousePointInImg.y + (drawRect.y - y) * currentVisibleRect.height / drawRect.height;
            currentVisibleRect.checkRectPos();
            ImageDisplay imageDisplay2 = ImageDisplay.this;
            synchronized (imageDisplay2) {
                if (ImageDisplay.this.entry == currentEntry) {
                    ImageDisplay.this.visibleRect = currentVisibleRect;
                }
            }
            ImageDisplay.this.repaint();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            boolean refreshMousePointInImg = false;
            if (this.lastMouseEvent == null || this.mousePointInImg == null || (this.lastMouseEvent.getX() - e.getX()) * (this.lastMouseEvent.getX() - e.getX()) + (this.lastMouseEvent.getY() - e.getY()) * (this.lastMouseEvent.getY() - e.getY()) > 16) {
                this.lastMouseEvent = e;
                refreshMousePointInImg = true;
            }
            this.mouseWheelMovedImpl(e.getX(), e.getY(), e.getWheelRotation(), refreshMousePointInImg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent e) {
            VisRect currentVisibleRect;
            BufferedImage currentImage;
            IImageEntry currentEntry;
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                currentEntry = ImageDisplay.this.entry;
                currentImage = ImageDisplay.this.image;
                currentVisibleRect = ImageDisplay.this.visibleRect;
            }
            if (currentImage == null) {
                return;
            }
            if (ZOOM_ON_CLICK.get().booleanValue()) {
                this.lastMouseEvent = null;
                if (this.mouseIsZoomSelecting(e) && !this.isAtMaxZoom(currentVisibleRect)) {
                    this.mouseWheelMovedImpl(e.getX(), e.getY(), -1, true);
                    return;
                }
                if (this.mouseIsDragging(e)) {
                    this.mouseWheelMovedImpl(e.getX(), e.getY(), 1, true);
                    return;
                }
            }
            Point click = ImageDisplay.comp2imgCoord(currentVisibleRect, e.getX(), e.getY(), ImageDisplay.this.getSize());
            Point center = ImageDisplay.getCenterImgCoord(currentVisibleRect);
            currentVisibleRect.x += click.x - center.x;
            currentVisibleRect.y += click.y - center.y;
            currentVisibleRect.checkRectPos();
            ImageDisplay imageDisplay2 = ImageDisplay.this;
            synchronized (imageDisplay2) {
                if (ImageDisplay.this.entry == currentEntry) {
                    ImageDisplay.this.visibleRect = currentVisibleRect;
                }
            }
            ImageDisplay.this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent e) {
            VisRect currentVisibleRect;
            BufferedImage currentImage;
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                currentImage = ImageDisplay.this.image;
                currentVisibleRect = ImageDisplay.this.visibleRect;
            }
            if (currentImage == null) {
                return;
            }
            ImageDisplay.this.selectedRect = null;
            if (this.mouseIsDragging(e) || this.mouseIsZoomSelecting(e)) {
                this.mousePointInImg = ImageDisplay.comp2imgCoord(currentVisibleRect, e.getX(), e.getY(), ImageDisplay.this.getSize());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDragged(MouseEvent e) {
            Point p;
            VisRect currentVisibleRect;
            BufferedImage currentImage;
            IImageEntry imageEntry;
            if (!this.mouseIsDragging(e) && !this.mouseIsZoomSelecting(e)) {
                return;
            }
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                imageEntry = ImageDisplay.this.entry;
                currentImage = ImageDisplay.this.image;
                currentVisibleRect = ImageDisplay.this.visibleRect;
            }
            if (currentImage == null) {
                return;
            }
            if (this.mouseIsDragging(e) && this.mousePointInImg != null) {
                boolean is360panning;
                p = ImageDisplay.comp2imgCoord(currentVisibleRect, e.getX(), e.getY(), ImageDisplay.this.getSize());
                ImageDisplay.this.getIImageViewer(ImageDisplay.this.entry).mouseDragged(this.mousePointInImg, p, currentVisibleRect);
                currentVisibleRect.checkRectPos();
                ImageDisplay imageDisplay2 = ImageDisplay.this;
                synchronized (imageDisplay2) {
                    if (ImageDisplay.this.entry == imageEntry) {
                        ImageDisplay.this.visibleRect = currentVisibleRect;
                    }
                }
                boolean bl = is360panning = ImageDisplay.this.entry != null && Projections.EQUIRECTANGULAR == ImageDisplay.this.entry.getProjectionType();
                if (is360panning) {
                    this.mousePointInImg = p;
                }
                ImageDisplay.this.repaint();
                if (is360panning) {
                    MainApplication.getLayerManager().getLayersOfType(GeoImageLayer.class).forEach(AbstractMapViewPaintable::invalidate);
                }
            }
            if (this.mouseIsZoomSelecting(e) && this.mousePointInImg != null) {
                p = ImageDisplay.comp2imgCoord(currentVisibleRect, e.getX(), e.getY(), ImageDisplay.this.getSize());
                currentVisibleRect.checkPointInside(p);
                VisRect selectedRectTemp = new VisRect(Math.min(p.x, this.mousePointInImg.x), Math.min(p.y, this.mousePointInImg.y), p.x < this.mousePointInImg.x ? this.mousePointInImg.x - p.x : p.x - this.mousePointInImg.x, p.y < this.mousePointInImg.y ? this.mousePointInImg.y - p.y : p.y - this.mousePointInImg.y, currentVisibleRect);
                selectedRectTemp.checkRectSize();
                selectedRectTemp.checkRectPos();
                ImageDisplay.this.selectedRect = selectedRectTemp;
                ImageDisplay.this.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent e) {
            VisRect currentVisibleRect;
            BufferedImage currentImage;
            IImageEntry currentEntry;
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                currentEntry = ImageDisplay.this.entry;
                currentImage = ImageDisplay.this.image;
                currentVisibleRect = ImageDisplay.this.visibleRect;
            }
            if (currentImage == null) {
                return;
            }
            if (this.mouseIsDragging(e)) {
                currentVisibleRect.isDragUpdate = false;
            }
            if (this.mouseIsZoomSelecting(e) && ImageDisplay.this.selectedRect != null) {
                int oldWidth = ((ImageDisplay)ImageDisplay.this).selectedRect.width;
                int oldHeight = ((ImageDisplay)ImageDisplay.this).selectedRect.height;
                ImageDisplay.this.ensureMaxZoom(ImageDisplay.this.selectedRect);
                if (((ImageDisplay)ImageDisplay.this).selectedRect.width != oldWidth) {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.x -= (((ImageDisplay)ImageDisplay.this).selectedRect.width - oldWidth) / 2;
                }
                if (((ImageDisplay)ImageDisplay.this).selectedRect.height != oldHeight) {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.y -= (((ImageDisplay)ImageDisplay.this).selectedRect.height - oldHeight) / 2;
                }
                ImageDisplay.this.selectedRect.checkRectSize();
                ImageDisplay.this.selectedRect.checkRectPos();
            }
            ImageDisplay imageDisplay2 = ImageDisplay.this;
            synchronized (imageDisplay2) {
                if (currentEntry == ImageDisplay.this.entry) {
                    if (ImageDisplay.this.selectedRect == null) {
                        ImageDisplay.this.visibleRect = currentVisibleRect;
                    } else {
                        ImageDisplay.this.visibleRect.setBounds(ImageDisplay.this.selectedRect);
                        ImageDisplay.this.selectedRect = null;
                    }
                }
            }
            ImageDisplay.this.repaint();
        }
    }

    protected class LoadImageRunnable
    implements Runnable {
        private final IImageEntry<?> entry;

        LoadImageRunnable(IImageEntry<?> entry) {
            this.entry = entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Dimension target = new Dimension(MAX_WIDTH.get(), MAX_WIDTH.get());
                BufferedImage img = this.entry.read(target);
                if (img == null) {
                    ImageDisplay imageDisplay = ImageDisplay.this;
                    synchronized (imageDisplay) {
                        ImageDisplay.this.errorLoading = true;
                        ImageDisplay.this.repaint();
                        return;
                    }
                }
                int width = img.getWidth();
                int height = img.getHeight();
                this.entry.setWidth(width);
                this.entry.setHeight(height);
                ImageDisplay imageDisplay = ImageDisplay.this;
                synchronized (imageDisplay) {
                    if (this.entry != ImageDisplay.this.entry) {
                        return;
                    }
                    ImageDisplay.this.image = img;
                    ImageDisplay.this.updateProcessedImage();
                    ImageDisplay.this.oldEntry = ImageDisplay.this.entry;
                    ImageDisplay.this.visibleRect = ImageDisplay.this.getIImageViewer(this.entry).getDefaultVisibleRectangle(ImageDisplay.this, ImageDisplay.this.image);
                    ImageDisplay.this.selectedRect = null;
                    ImageDisplay.this.errorLoading = false;
                }
                ImageDisplay.this.repaint();
            }
            catch (IOException ex) {
                Logging.error(ex);
            }
        }
    }

    public static class VisRect
    extends Rectangle {
        private final Rectangle init;
        public boolean isDragUpdate;

        public VisRect(int x, int y, int width, int height) {
            super(x, y, width, height);
            this.init = new Rectangle(this);
        }

        public VisRect(int x, int y, int width, int height, VisRect peer) {
            super(x, y, width, height);
            this.init = peer.init;
        }

        public VisRect(VisRect v) {
            super(v);
            this.init = v.init;
        }

        public VisRect() {
            this(0, 0, 0, 0);
        }

        public boolean isFullView() {
            return this.init.equals(this);
        }

        public boolean isFullView1D() {
            return this.init.x == this.x && this.init.width == this.width || this.init.y == this.y && this.init.height == this.height;
        }

        public void reset() {
            this.setBounds(this.init);
        }

        public void checkRectPos() {
            if (this.x < 0) {
                this.x = 0;
            }
            if (this.y < 0) {
                this.y = 0;
            }
            if (this.x + this.width > this.init.width) {
                this.x = this.init.width - this.width;
            }
            if (this.y + this.height > this.init.height) {
                this.y = this.init.height - this.height;
            }
        }

        public void checkRectSize() {
            if (this.width > this.init.width) {
                this.width = this.init.width;
            }
            if (this.height > this.init.height) {
                this.height = this.init.height;
            }
        }

        public void checkPointInside(Point p) {
            if (p.x < this.x) {
                p.x = this.x;
            }
            if (p.x > this.x + this.width) {
                p.x = this.x + this.width;
            }
            if (p.y < this.y) {
                p.y = this.y;
            }
            if (p.y > this.y + this.height) {
                p.y = this.y + this.height;
            }
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + Objects.hash(this.init);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj) || this.getClass() != obj.getClass()) {
                return false;
            }
            VisRect other = (VisRect)obj;
            return Objects.equals(this.init, other.init);
        }
    }

    private class UpdateImageThread
    extends Thread {
        private boolean restart;

        private UpdateImageThread() {
        }

        @Override
        public void run() {
            ImageDisplay.this.updateProcessedImage();
            if (this.restart) {
                this.restart = false;
                this.run();
            }
        }

        public void restart() {
            this.restart = true;
            if (!this.isAlive()) {
                this.restart = false;
                ImageDisplay.this.updateImageThreadInstance = new UpdateImageThread();
                ImageDisplay.this.updateImageThreadInstance.start();
            }
        }
    }
}

