/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JPopupMenu;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.dialogs.properties.HelpTagAction;
import org.openstreetmap.josm.gui.dialogs.properties.TaginfoAction;
import org.openstreetmap.josm.gui.tagging.presets.items.TextItem;
import org.openstreetmap.josm.tools.I18n;

public abstract class KeyedItem
extends TextItem {
    protected static final String DIFFERENT = "<different>";
    protected static final String DIFFERENT_I18N = I18n.tr("<different>", new Object[0]);
    protected static final BooleanProperty PROP_FILL_DEFAULT = new BooleanProperty("taggingpreset.fill-default-for-tagged-primitives", false);
    static final Map<String, String> LAST_VALUES = new HashMap<String, String>();
    public String key;
    public String match = this.getDefaultMatch().getValue();

    public static Usage determineTextUsage(Collection<OsmPrimitive> sel, String key) {
        Usage returnValue = new Usage();
        returnValue.selectedCount = sel.size();
        for (OsmPrimitive s : sel) {
            String v = s.get(key);
            if (v != null) {
                returnValue.map.merge(v, 1, Integer::sum);
            } else {
                returnValue.hadEmpty = true;
            }
            if (!s.hasKeys()) continue;
            returnValue.hadKeys = true;
        }
        return returnValue;
    }

    protected static Usage determineBooleanUsage(Collection<OsmPrimitive> sel, String key) {
        Usage returnValue = new Usage();
        returnValue.selectedCount = sel.size();
        for (OsmPrimitive s : sel) {
            String booleanValue = OsmUtils.getNamedOsmBoolean(s.get(key));
            if (booleanValue == null) continue;
            returnValue.map.merge(booleanValue, 1, Integer::sum);
        }
        return returnValue;
    }

    public boolean isKeyRequired() {
        MatchType type = MatchType.ofString(this.match);
        return MatchType.KEY_REQUIRED == type || MatchType.KEY_VALUE_REQUIRED == type;
    }

    public abstract MatchType getDefaultMatch();

    public abstract Collection<String> getValues();

    protected String getKeyTooltipText() {
        return I18n.tr("This corresponds to the key ''{0}''", this.key);
    }

    @Override
    public Boolean matches(Map<String, String> tags) {
        switch (MatchType.ofString(this.match)) {
            case NONE: {
                return null;
            }
            case KEY: {
                return tags.containsKey(this.key) ? Boolean.TRUE : null;
            }
            case KEY_REQUIRED: {
                return tags.containsKey(this.key);
            }
            case KEY_VALUE: {
                return tags.containsKey(this.key) && this.getValues().contains(tags.get(this.key)) ? Boolean.TRUE : null;
            }
            case KEY_VALUE_REQUIRED: {
                return tags.containsKey(this.key) && this.getValues().contains(tags.get(this.key));
            }
        }
        throw new IllegalStateException();
    }

    protected JPopupMenu getPopupMenu() {
        Tag tag = new Tag(this.key, null);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(I18n.tr("Key: {0}", this.key)).setEnabled(false);
        popupMenu.add(new HelpTagAction(() -> tag));
        TaginfoAction taginfoAction = new TaginfoAction(() -> tag, () -> null);
        popupMenu.add(taginfoAction.toTagHistoryAction());
        popupMenu.add(taginfoAction);
        return popupMenu;
    }

    @Override
    public String toString() {
        return "KeyedItem [key=" + this.key + ", text=" + this.text + ", text_context=" + this.text_context + ", match=" + this.match + ']';
    }

    public static class Usage {
        public final SortedMap<String, Integer> map = new TreeMap<String, Integer>();
        private boolean hadKeys;
        private boolean hadEmpty;
        private int selectedCount;

        public boolean hasUniqueValue() {
            return this.map.size() == 1 && !this.hadEmpty;
        }

        public boolean unused() {
            return this.map.isEmpty();
        }

        public String getFirst() {
            return this.map.firstKey();
        }

        public boolean hadKeys() {
            return this.hadKeys;
        }

        public int getSelectedCount() {
            return this.selectedCount;
        }

        public Usage splitValues(String delimiter) {
            Usage usage = new Usage();
            usage.hadEmpty = this.hadEmpty;
            usage.hadKeys = this.hadKeys;
            usage.selectedCount = this.selectedCount;
            this.map.forEach((value, count) -> {
                for (String v : value.split(String.valueOf(delimiter), -1)) {
                    usage.map.merge(v, (Integer)count, Integer::sum);
                }
            });
            return usage;
        }
    }

    protected static enum MatchType {
        NONE("none"),
        KEY("key"),
        KEY_REQUIRED("key!"),
        KEY_VALUE("keyvalue"),
        KEY_VALUE_REQUIRED("keyvalue!");

        private final String value;

        private MatchType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static MatchType ofString(String type) {
            for (MatchType i : EnumSet.allOf(MatchType.class)) {
                if (!i.getValue().equals(type)) continue;
                return i;
            }
            throw new IllegalArgumentException(type + " is not allowed");
        }
    }
}

