/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.strscan;

import org.jcodings.Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyMatchData;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;

@JRubyClass(name={"StringScanner"})
public class RubyStringScanner
extends RubyObject {
    private RubyString str;
    private int curr = 0;
    private int prev = -1;
    private Region regs;
    private Regex pattern;
    private int scannerFlags;
    private boolean fixedAnchor;
    private static final int MATCHED_STR_SCN_F = 2048;
    final ThreadLocal<Matcher> currentMatcher = new ThreadLocal();
    final RubyThread.Task<RubyStringScanner, Integer> task = new RubyThread.Task<RubyStringScanner, Integer>(){

        public Integer run(ThreadContext threadContext, RubyStringScanner rubyStringScanner) throws InterruptedException {
            ByteList byteList = RubyStringScanner.this.str.getByteList();
            return RubyStringScanner.this.currentMatcher.get().matchInterruptible(byteList.begin() + RubyStringScanner.this.curr, byteList.begin() + byteList.realSize(), 0);
        }

        public void wakeup(RubyThread rubyThread, RubyStringScanner rubyStringScanner) {
            rubyThread.getNativeThread().interrupt();
        }
    };
    private static final int INSPECT_LENGTH = 5;
    private static final byte[] DOT_BYTES = "...".getBytes();

    public static RubyClass createScannerClass(Ruby ruby) {
        RubyClass rubyClass = ruby.getObject();
        RubyClass rubyClass2 = ruby.defineClass("StringScanner", rubyClass, RubyStringScanner::new);
        RubyClass rubyClass3 = ruby.getStandardError();
        RubyClass rubyClass4 = rubyClass2.defineClassUnder("Error", rubyClass3, rubyClass3.getAllocator());
        if (!rubyClass.isConstantDefined("ScanError")) {
            rubyClass.defineConstant("ScanError", (IRubyObject)rubyClass4);
        }
        RubyString rubyString = ruby.newString("3.0.2");
        rubyString.setFrozen(true);
        rubyClass2.setConstant("Version", (IRubyObject)rubyString);
        RubyString rubyString2 = ruby.newString("$Id$");
        rubyString2.setFrozen(true);
        rubyClass2.setConstant("Id", (IRubyObject)rubyString2);
        rubyClass2.defineAnnotatedMethods(RubyStringScanner.class);
        return rubyClass2;
    }

    private void clearMatched() {
        this.scannerFlags &= 0xFFFFF7FF;
    }

    private void setMatched() {
        this.scannerFlags |= 0x800;
    }

    private boolean isMatched() {
        return (this.scannerFlags & 0x800) != 0;
    }

    private void check(ThreadContext threadContext) {
        if (this.str == null) {
            throw threadContext.runtime.newArgumentError("uninitialized StringScanner object");
        }
    }

    protected RubyStringScanner(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.initialize(threadContext, iRubyObject, threadContext.nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.str = iRubyObject.convertToString();
        this.fixedAnchor = ArgsUtil.extractKeywordArg((ThreadContext)threadContext, (String)"fixed_anchor", (IRubyObject)iRubyObject2).isTrue();
        this.regs = new Region(0, 0);
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return this.initialize(threadContext, iRubyObject, iRubyObject3);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this;
        }
        if (!(iRubyObject instanceof RubyStringScanner)) {
            throw threadContext.runtime.newTypeError("wrong argument type " + iRubyObject.getMetaClass() + " (expected StringScanner)");
        }
        RubyStringScanner rubyStringScanner = (RubyStringScanner)iRubyObject;
        this.str = rubyStringScanner.str;
        this.curr = rubyStringScanner.curr;
        this.prev = rubyStringScanner.prev;
        this.scannerFlags = rubyStringScanner.scannerFlags;
        this.regs = rubyStringScanner.regs.clone();
        this.pattern = rubyStringScanner.pattern;
        this.fixedAnchor = rubyStringScanner.fixedAnchor;
        return this;
    }

    @JRubyMethod(name={"reset"})
    public IRubyObject reset(ThreadContext threadContext) {
        this.check(threadContext);
        this.curr = 0;
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"terminate"})
    public IRubyObject terminate(ThreadContext threadContext) {
        this.check(threadContext);
        this.curr = this.str.getByteList().getRealSize();
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject clear(ThreadContext threadContext) {
        this.check(threadContext);
        Ruby ruby = threadContext.runtime;
        if (ruby.isVerbose()) {
            ruby.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#clear is obsolete; use #terminate instead");
        }
        return this.terminate(threadContext);
    }

    @JRubyMethod(name={"string"})
    public RubyString string() {
        return this.str;
    }

    @JRubyMethod(name={"string="})
    public IRubyObject set_string(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.str = RubyString.stringValue((IRubyObject)iRubyObject);
        this.curr = 0;
        this.clearMatched();
        return iRubyObject;
    }

    @JRubyMethod(name={"concat", "<<"})
    public IRubyObject concat(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.check(threadContext);
        this.str.append(iRubyObject.convertToString());
        return this;
    }

    @JRubyMethod(name={"pos", "pointer"})
    public RubyFixnum pos(ThreadContext threadContext) {
        this.check(threadContext);
        return RubyFixnum.newFixnum((Ruby)threadContext.runtime, (long)this.curr);
    }

    @JRubyMethod(name={"pos=", "pointer="})
    public IRubyObject set_pos(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.check(threadContext);
        Ruby ruby = threadContext.runtime;
        int n = RubyNumeric.num2int((IRubyObject)iRubyObject);
        int n2 = this.str.getByteList().getRealSize();
        if (n < 0) {
            n += n2;
        }
        if (n < 0 || n > n2) {
            throw ruby.newRangeError("index out of range.");
        }
        this.curr = n;
        return RubyFixnum.newFixnum((Ruby)ruby, (long)n);
    }

    @JRubyMethod(name={"charpos"})
    public IRubyObject charpos(ThreadContext threadContext) {
        Ruby ruby = threadContext.runtime;
        ByteList byteList = this.str.getByteList();
        int n = byteList.begin();
        return ruby.newFixnum(StringSupport.strLength((Encoding)byteList.getEncoding(), (byte[])byteList.unsafeBytes(), (int)n, (int)(n + this.curr)));
    }

    private IRubyObject extractRange(Ruby ruby, int n, int n2) {
        int n3 = this.str.getByteList().getRealSize();
        if (n > n3) {
            return ruby.getNil();
        }
        if (n2 > n3) {
            n2 = n3;
        }
        return this.str.makeSharedString(ruby, n, n2 - n);
    }

    private IRubyObject extractBegLen(Ruby ruby, int n, int n2) {
        assert (n2 >= 0);
        int n3 = this.str.getByteList().getRealSize();
        if (n > n3) {
            return ruby.getNil();
        }
        n2 = Math.min(n2, n3 - n);
        return this.str.makeSharedString(ruby, n, n2);
    }

    private IRubyObject scan(ThreadContext threadContext, IRubyObject iRubyObject, boolean bl, boolean bl2, boolean bl3) {
        int n;
        Ruby ruby = threadContext.runtime;
        if (bl3) {
            if (!(iRubyObject instanceof RubyRegexp)) {
                iRubyObject = iRubyObject.convertToString();
            }
        } else if (!(iRubyObject instanceof RubyRegexp)) {
            throw ruby.newTypeError("wrong argument type " + iRubyObject.getMetaClass() + " (expected Regexp)");
        }
        this.check(threadContext);
        ByteList byteList = this.str.getByteList();
        int n2 = byteList.getBegin();
        this.clearMatched();
        if (this.restLen() < 0) {
            return threadContext.nil;
        }
        if (iRubyObject instanceof RubyRegexp) {
            this.pattern = ((RubyRegexp)iRubyObject).preparePattern(this.str);
            n = this.currPtr();
            int n3 = n + this.restLen();
            Matcher matcher = this.pattern.matcher(byteList.getUnsafeBytes(), this.matchTarget(), n3);
            int n4 = bl3 ? RubyRegexp.matcherMatch((ThreadContext)threadContext, (Matcher)matcher, (int)n, (int)n3, (int)0) : RubyRegexp.matcherSearch((ThreadContext)threadContext, (Matcher)matcher, (int)n, (int)n3, (int)0);
            Region region = matcher.getRegion();
            this.regs = region == null ? new Region(matcher.getBegin(), matcher.getEnd()) : region;
            if (n4 == -2) {
                throw ruby.newRaiseException((RubyClass)this.getMetaClass().getConstant("ScanError"), "regexp buffer overflow");
            }
            if (n4 < 0) {
                return threadContext.nil;
            }
        } else {
            RubyString rubyString = (RubyString)iRubyObject;
            this.str.checkEncoding(rubyString);
            if (this.restLen() < rubyString.size()) {
                return threadContext.nil;
            }
            ByteList byteList2 = rubyString.getByteList();
            int n5 = byteList2.realSize();
            if (ByteList.memcmp((byte[])byteList.unsafeBytes(), (int)(n2 + this.curr), (byte[])byteList2.unsafeBytes(), (int)byteList2.begin(), (int)n5) != 0) {
                return threadContext.nil;
            }
            this.setRegisters(n5);
        }
        this.setMatched();
        this.prev = this.curr;
        if (bl) {
            this.succ();
        }
        n = this.lastMatchLength();
        if (bl2) {
            return this.extractBegLen(ruby, this.prev, n);
        }
        return RubyFixnum.newFixnum((Ruby)ruby, (long)n);
    }

    private int lastMatchLength() {
        if (this.fixedAnchor) {
            return this.regs.end[0] - this.prev;
        }
        return this.regs.end[0];
    }

    private void succ() {
        this.curr = this.fixedAnchor ? this.regs.end[0] : (this.curr += this.regs.end[0]);
    }

    private int currPtr() {
        return this.str.getByteList().getBegin() + this.curr;
    }

    private int matchTarget() {
        if (this.fixedAnchor) {
            return this.str.getByteList().getBegin();
        }
        return this.str.getByteList().getBegin() + this.curr;
    }

    private int restLen() {
        return this.str.size() - this.curr;
    }

    private void setRegisters(int n) {
        this.regs = this.fixedAnchor ? new Region(this.curr, this.curr + n) : new Region(0, n);
    }

    @JRubyMethod(name={"scan"})
    public IRubyObject scan(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.scan(threadContext, iRubyObject, true, true, true);
    }

    @JRubyMethod(name={"match?"})
    public IRubyObject match_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.scan(threadContext, iRubyObject, false, false, true);
    }

    @JRubyMethod(name={"skip"})
    public IRubyObject skip(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.scan(threadContext, iRubyObject, true, false, true);
    }

    @JRubyMethod(name={"check"})
    public IRubyObject check(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.scan(threadContext, iRubyObject, false, true, true);
    }

    @JRubyMethod(name={"scan_full"})
    public IRubyObject scan_full(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return this.scan(threadContext, iRubyObject, iRubyObject2.isTrue(), iRubyObject3.isTrue(), true);
    }

    @JRubyMethod(name={"scan_until"})
    public IRubyObject scan_until(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.scan(threadContext, iRubyObject, true, true, false);
    }

    @JRubyMethod(name={"exist?"})
    public IRubyObject exist_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.scan(threadContext, iRubyObject, false, false, false);
    }

    @JRubyMethod(name={"skip_until"})
    public IRubyObject skip_until(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.scan(threadContext, iRubyObject, true, false, false);
    }

    @JRubyMethod(name={"check_until"})
    public IRubyObject check_until(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.scan(threadContext, iRubyObject, false, true, false);
    }

    @JRubyMethod(name={"search_full"})
    public IRubyObject search_full(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return this.scan(threadContext, iRubyObject, iRubyObject2.isTrue(), iRubyObject3.isTrue(), false);
    }

    private void adjustRegisters() {
        this.regs = this.fixedAnchor ? new Region(this.prev, this.curr) : new Region(0, this.curr - this.prev);
    }

    @JRubyMethod(name={"getch"})
    public IRubyObject getch(ThreadContext threadContext) {
        return this.getchCommon(threadContext);
    }

    public IRubyObject getchCommon(ThreadContext threadContext) {
        this.check(threadContext);
        this.clearMatched();
        ByteList byteList = this.str.getByteList();
        int n = byteList.getRealSize();
        if (this.curr >= n) {
            return threadContext.nil;
        }
        Ruby ruby = threadContext.runtime;
        Encoding encoding = byteList.getEncoding();
        int n2 = byteList.getBegin();
        int n3 = encoding.isSingleByte() ? 1 : StringSupport.length((Encoding)encoding, (byte[])byteList.getUnsafeBytes(), (int)(n2 + this.curr), (int)(n2 + n));
        n3 = Math.min(n3, this.restLen());
        this.prev = this.curr;
        this.curr += n3;
        this.setMatched();
        this.adjustRegisters();
        return this.extractRange(ruby, this.prev + this.regs.beg[0], this.prev + this.regs.end[0]);
    }

    @JRubyMethod(name={"get_byte"})
    public IRubyObject get_byte(ThreadContext threadContext) {
        this.check(threadContext);
        this.clearMatched();
        if (this.curr >= this.str.getByteList().getRealSize()) {
            return threadContext.nil;
        }
        this.prev = this.curr++;
        this.setMatched();
        this.adjustRegisters();
        return this.extractRange(threadContext.runtime, this.prev + this.regs.beg[0], this.prev + this.regs.end[0]);
    }

    @JRubyMethod(name={"getbyte"})
    public IRubyObject getbyte(ThreadContext threadContext) {
        Ruby ruby = threadContext.runtime;
        if (ruby.isVerbose()) {
            ruby.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#getbyte is obsolete; use #get_byte instead");
        }
        return this.get_byte(threadContext);
    }

    @JRubyMethod(name={"peek"})
    public IRubyObject peek(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.check(threadContext);
        int n = RubyNumeric.num2int((IRubyObject)iRubyObject);
        if (n < 0) {
            throw threadContext.runtime.newArgumentError("negative string size (or size too big)");
        }
        ByteList byteList = this.str.getByteList();
        if (this.curr >= byteList.getRealSize()) {
            return RubyString.newEmptyString((Ruby)threadContext.runtime);
        }
        if (this.curr + n > byteList.getRealSize()) {
            n = byteList.getRealSize() - this.curr;
        }
        return this.extractBegLen(threadContext.runtime, this.curr, n);
    }

    @JRubyMethod(name={"peep"})
    public IRubyObject peep(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        if (ruby.isVerbose()) {
            ruby.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#peep is obsolete; use #peek instead");
        }
        return this.peek(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"unscan"})
    public IRubyObject unscan(ThreadContext threadContext) {
        this.check(threadContext);
        if (!this.isMatched()) {
            Ruby ruby = threadContext.runtime;
            RubyClass rubyClass = ruby.getClass("StringScanner").getClass("Error");
            throw RaiseException.from((Ruby)ruby, (RubyClass)rubyClass, (String)"unscan failed: previous match had failed");
        }
        this.curr = this.prev;
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"beginning_of_line?"}, alias={"bol?"})
    public IRubyObject bol_p(ThreadContext threadContext) {
        this.check(threadContext);
        ByteList byteList = this.str.getByteList();
        if (this.curr > byteList.getRealSize()) {
            return threadContext.nil;
        }
        if (this.curr == 0) {
            return threadContext.tru;
        }
        return byteList.getUnsafeBytes()[byteList.getBegin() + this.curr - 1] == 10 ? threadContext.tru : threadContext.fals;
    }

    @JRubyMethod(name={"eos?"})
    public RubyBoolean eos_p(ThreadContext threadContext) {
        this.check(threadContext);
        return this.curr >= this.str.getByteList().getRealSize() ? threadContext.tru : threadContext.fals;
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext threadContext) {
        Ruby ruby = threadContext.runtime;
        if (ruby.isVerbose()) {
            ruby.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#empty? is obsolete; use #eos? instead");
        }
        return this.eos_p(threadContext);
    }

    @JRubyMethod(name={"rest?"})
    public RubyBoolean rest_p(ThreadContext threadContext) {
        this.check(threadContext);
        return this.curr >= this.str.getByteList().getRealSize() ? threadContext.fals : threadContext.tru;
    }

    @JRubyMethod(name={"matched?"})
    public RubyBoolean matched_p(ThreadContext threadContext) {
        this.check(threadContext);
        return this.isMatched() ? threadContext.tru : threadContext.fals;
    }

    @JRubyMethod(name={"matched"})
    public IRubyObject matched(ThreadContext threadContext) {
        this.check(threadContext);
        if (!this.isMatched()) {
            return threadContext.nil;
        }
        return this.extractRange(threadContext.runtime, this.prev + this.regs.beg[0], this.prev + this.regs.end[0]);
    }

    @JRubyMethod(name={"matched_size"})
    public IRubyObject matched_size(ThreadContext threadContext) {
        this.check(threadContext);
        if (!this.isMatched()) {
            return threadContext.nil;
        }
        return RubyFixnum.newFixnum((Ruby)threadContext.runtime, (long)(this.regs.end[0] - this.regs.beg[0]));
    }

    @JRubyMethod(name={"matchedsize"})
    public IRubyObject matchedsize(ThreadContext threadContext) {
        Ruby ruby = threadContext.runtime;
        if (ruby.isVerbose()) {
            ruby.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#matchedsize is obsolete; use #matched_size instead");
        }
        return this.matched_size();
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.check(threadContext);
        if (!this.isMatched()) {
            return threadContext.nil;
        }
        if ((iRubyObject instanceof RubySymbol || iRubyObject instanceof RubyString) && this.pattern == null) {
            return threadContext.nil;
        }
        Ruby ruby = threadContext.runtime;
        int n = RubyMatchData.backrefNumber((Ruby)ruby, (Regex)this.pattern, (Region)this.regs, (IRubyObject)iRubyObject);
        int n2 = this.regs.numRegs;
        if (n < 0) {
            n += n2;
        }
        if (n < 0 || n >= n2 || this.regs.beg[n] == -1) {
            return threadContext.nil;
        }
        return this.extractRange(threadContext.runtime, this.prev + this.regs.beg[n], this.prev + this.regs.end[n]);
    }

    @JRubyMethod(name={"pre_match"})
    public IRubyObject pre_match(ThreadContext threadContext) {
        this.check(threadContext);
        if (!this.isMatched()) {
            return threadContext.nil;
        }
        return this.extractRange(threadContext.runtime, 0, this.prev + this.regs.beg[0]);
    }

    @JRubyMethod(name={"post_match"})
    public IRubyObject post_match(ThreadContext threadContext) {
        this.check(threadContext);
        if (!this.isMatched()) {
            return threadContext.nil;
        }
        return this.extractRange(threadContext.runtime, this.prev + this.regs.end[0], this.str.getByteList().getRealSize());
    }

    @JRubyMethod(name={"rest"})
    public IRubyObject rest(ThreadContext threadContext) {
        this.check(threadContext);
        Ruby ruby = threadContext.runtime;
        ByteList byteList = this.str.getByteList();
        if (this.curr >= byteList.getRealSize()) {
            return RubyString.newEmptyString((Ruby)ruby);
        }
        return this.extractRange(ruby, this.curr, byteList.getRealSize());
    }

    @JRubyMethod(name={"rest_size"})
    public RubyFixnum rest_size(ThreadContext threadContext) {
        this.check(threadContext);
        Ruby ruby = threadContext.runtime;
        ByteList byteList = this.str.getByteList();
        if (this.curr >= byteList.getRealSize()) {
            return RubyFixnum.zero((Ruby)ruby);
        }
        return RubyFixnum.newFixnum((Ruby)ruby, (long)(byteList.getRealSize() - this.curr));
    }

    @JRubyMethod(name={"restsize"})
    public RubyFixnum restsize(ThreadContext threadContext) {
        Ruby ruby = threadContext.runtime;
        if (ruby.isVerbose()) {
            ruby.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#restsize is obsolete; use #rest_size instead");
        }
        return this.rest_size(threadContext);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        if (this.str == null) {
            return this.inspect("(uninitialized)");
        }
        if (this.curr >= this.str.getByteList().getRealSize()) {
            return this.inspect("fin");
        }
        if (this.curr == 0) {
            return this.inspect(this.curr + "/" + this.str.getByteList().getRealSize() + " @ " + this.inspect2());
        }
        return this.inspect(this.curr + "/" + this.str.getByteList().getRealSize() + " " + this.inspect1() + " @ " + this.inspect2());
    }

    @JRubyMethod(name={"fixed_anchor?"})
    public IRubyObject fixed_anchor_p(ThreadContext threadContext) {
        return RubyBoolean.newBoolean((ThreadContext)threadContext, (boolean)this.fixedAnchor);
    }

    private IRubyObject inspect(String string) {
        RubyString rubyString = this.getRuntime().newString("#<" + this.getMetaClass() + " " + string + ">");
        return rubyString;
    }

    private IRubyObject inspect1() {
        Ruby ruby = this.getRuntime();
        if (this.curr == 0) {
            return RubyString.newEmptyString((Ruby)ruby);
        }
        if (this.curr > 5) {
            return RubyString.newStringNoCopy((Ruby)ruby, (byte[])DOT_BYTES).append(this.str.substr(ruby, this.curr - 5, 5)).inspect();
        }
        return this.str.substr(ruby, 0, this.curr).inspect();
    }

    private IRubyObject inspect2() {
        Ruby ruby = this.getRuntime();
        if (this.curr >= this.str.getByteList().getRealSize()) {
            return RubyString.newEmptyString((Ruby)ruby);
        }
        int n = this.str.getByteList().getRealSize() - this.curr;
        if (n > 5) {
            return ((RubyString)this.str.substr(ruby, this.curr, 5)).cat(DOT_BYTES).inspect();
        }
        return this.str.substr(ruby, this.curr, n).inspect();
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size(ThreadContext threadContext) {
        if (!this.isMatched()) {
            return threadContext.nil;
        }
        return threadContext.runtime.newFixnum(this.regs.numRegs);
    }

    @JRubyMethod(name={"captures"})
    public IRubyObject captures(ThreadContext threadContext) {
        if (!this.isMatched()) {
            return threadContext.nil;
        }
        Ruby ruby = threadContext.runtime;
        int n = this.regs.numRegs;
        RubyArray rubyArray = RubyArray.newArray((Ruby)ruby, (int)n);
        for (int i = 1; i < n; ++i) {
            IRubyObject iRubyObject = this.extractRange(ruby, this.prev + this.regs.beg[i], this.prev + this.regs.end[i]);
            rubyArray.push(iRubyObject);
        }
        return rubyArray;
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public IRubyObject values_at(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (!this.isMatched()) {
            return threadContext.nil;
        }
        Ruby ruby = threadContext.runtime;
        RubyArray rubyArray = RubyArray.newArray((Ruby)ruby, (int)iRubyObjectArray.length);
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            rubyArray.push(this.op_aref(threadContext, iRubyObjectArray[i]));
        }
        return rubyArray;
    }

    @Deprecated
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        this.str = iRubyObjectArray[0].convertToString();
        return this;
    }

    @Deprecated
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        return this.initialize_copy(this.getRuntime().getCurrentContext(), iRubyObject);
    }

    @Deprecated
    public IRubyObject concat(IRubyObject iRubyObject) {
        return this.concat(this.getRuntime().getCurrentContext(), iRubyObject);
    }

    @Deprecated
    public RubyFixnum pos() {
        return this.pos(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject set_pos(IRubyObject iRubyObject) {
        return this.set_pos(this.getRuntime().getCurrentContext(), iRubyObject);
    }

    @Deprecated
    public IRubyObject getch19(ThreadContext threadContext) {
        return this.getch(threadContext);
    }

    @Deprecated
    public IRubyObject reset() {
        return this.reset(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject unscan() {
        return this.unscan(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject matched_size() {
        return this.matched_size(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject bol_p() {
        return this.bol_p(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public RubyFixnum rest_size() {
        return this.rest_size(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject getchCommon(ThreadContext threadContext, boolean bl) {
        return this.getchCommon(threadContext);
    }

    @Deprecated
    @JRubyMethod(name={"must_C_version"}, meta=true)
    public static IRubyObject mustCversion(IRubyObject iRubyObject) {
        return iRubyObject;
    }
}

