"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.globalTenantName = exports.SAML_AUTH_LOGOUT = exports.SAML_AUTH_LOGIN_WITH_FRAGMENT = exports.SAML_AUTH_LOGIN = exports.PRIVATE_TENANT_SYMBOL = exports.PRIVATE_TENANT_RENDERING_TEXT = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.OPENID_AUTH_LOGOUT = exports.OPENID_AUTH_LOGIN = exports.OPENDISTRO_SECURITY_ANONYMOUS = exports.LOGIN_PAGE_URI = exports.GLOBAL_TENANT_SYMBOL = exports.GLOBAL_TENANT_RENDERING_TEXT = exports.ERROR_MISSING_ROLE_PATH = exports.DEFAULT_TENANT = exports.CUSTOM_ERROR_PAGE_URI = exports.CONFIGURATION_API_PREFIX = exports.AuthType = exports.AUTH_RESPONSE_TYPE = exports.AUTH_HEADER_NAME = exports.AUTH_GRANT_TYPE = exports.APP_ID_LOGIN = exports.APP_ID_CUSTOMERROR = exports.API_PREFIX = exports.API_ENDPOINT_AUTHTYPE = exports.API_ENDPOINT_AUTHINFO = exports.API_AUTH_LOGOUT = exports.API_AUTH_LOGIN = exports.ANONYMOUS_AUTH_LOGOUT = exports.ANONYMOUS_AUTH_LOGIN = void 0;
exports.isGlobalTenant = isGlobalTenant;
exports.isPrivateTenant = isPrivateTenant;
exports.isRenderingPrivateTenant = isRenderingPrivateTenant;
exports.isValidResourceName = isValidResourceName;

/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */
const PLUGIN_ID = 'opensearchDashboardsSecurity';
exports.PLUGIN_ID = PLUGIN_ID;
const PLUGIN_NAME = 'security-dashboards-plugin';
exports.PLUGIN_NAME = PLUGIN_NAME;
const APP_ID_LOGIN = 'login';
exports.APP_ID_LOGIN = APP_ID_LOGIN;
const APP_ID_CUSTOMERROR = 'customerror';
exports.APP_ID_CUSTOMERROR = APP_ID_CUSTOMERROR;
const OPENDISTRO_SECURITY_ANONYMOUS = 'opendistro_security_anonymous';
exports.OPENDISTRO_SECURITY_ANONYMOUS = OPENDISTRO_SECURITY_ANONYMOUS;
const API_PREFIX = '/api/v1';
exports.API_PREFIX = API_PREFIX;
const CONFIGURATION_API_PREFIX = 'configuration';
exports.CONFIGURATION_API_PREFIX = CONFIGURATION_API_PREFIX;
const API_ENDPOINT_AUTHINFO = API_PREFIX + '/auth/authinfo';
exports.API_ENDPOINT_AUTHINFO = API_ENDPOINT_AUTHINFO;
const API_ENDPOINT_AUTHTYPE = API_PREFIX + '/auth/type';
exports.API_ENDPOINT_AUTHTYPE = API_ENDPOINT_AUTHTYPE;
const LOGIN_PAGE_URI = '/app/' + APP_ID_LOGIN;
exports.LOGIN_PAGE_URI = LOGIN_PAGE_URI;
const CUSTOM_ERROR_PAGE_URI = '/app/' + APP_ID_CUSTOMERROR;
exports.CUSTOM_ERROR_PAGE_URI = CUSTOM_ERROR_PAGE_URI;
const API_AUTH_LOGIN = '/auth/login';
exports.API_AUTH_LOGIN = API_AUTH_LOGIN;
const API_AUTH_LOGOUT = '/auth/logout';
exports.API_AUTH_LOGOUT = API_AUTH_LOGOUT;
const OPENID_AUTH_LOGIN = '/auth/openid/login';
exports.OPENID_AUTH_LOGIN = OPENID_AUTH_LOGIN;
const SAML_AUTH_LOGIN = '/auth/saml/login';
exports.SAML_AUTH_LOGIN = SAML_AUTH_LOGIN;
const ANONYMOUS_AUTH_LOGIN = '/auth/anonymous';
exports.ANONYMOUS_AUTH_LOGIN = ANONYMOUS_AUTH_LOGIN;
const SAML_AUTH_LOGIN_WITH_FRAGMENT = '/auth/saml/captureUrlFragment?nextUrl=%2F';
exports.SAML_AUTH_LOGIN_WITH_FRAGMENT = SAML_AUTH_LOGIN_WITH_FRAGMENT;
const OPENID_AUTH_LOGOUT = '/auth/openid/logout';
exports.OPENID_AUTH_LOGOUT = OPENID_AUTH_LOGOUT;
const SAML_AUTH_LOGOUT = '/auth/saml/logout';
exports.SAML_AUTH_LOGOUT = SAML_AUTH_LOGOUT;
const ANONYMOUS_AUTH_LOGOUT = '/auth/anonymous/logout';
exports.ANONYMOUS_AUTH_LOGOUT = ANONYMOUS_AUTH_LOGOUT;
const ERROR_MISSING_ROLE_PATH = '/missing-role';
exports.ERROR_MISSING_ROLE_PATH = ERROR_MISSING_ROLE_PATH;
const AUTH_HEADER_NAME = 'authorization';
exports.AUTH_HEADER_NAME = AUTH_HEADER_NAME;
const AUTH_GRANT_TYPE = 'authorization_code';
exports.AUTH_GRANT_TYPE = AUTH_GRANT_TYPE;
const AUTH_RESPONSE_TYPE = 'code';
exports.AUTH_RESPONSE_TYPE = AUTH_RESPONSE_TYPE;
const GLOBAL_TENANT_SYMBOL = '';
exports.GLOBAL_TENANT_SYMBOL = GLOBAL_TENANT_SYMBOL;
const PRIVATE_TENANT_SYMBOL = '__user__';
exports.PRIVATE_TENANT_SYMBOL = PRIVATE_TENANT_SYMBOL;
const DEFAULT_TENANT = 'default';
exports.DEFAULT_TENANT = DEFAULT_TENANT;
const GLOBAL_TENANT_RENDERING_TEXT = 'Global';
exports.GLOBAL_TENANT_RENDERING_TEXT = GLOBAL_TENANT_RENDERING_TEXT;
const PRIVATE_TENANT_RENDERING_TEXT = 'Private';
exports.PRIVATE_TENANT_RENDERING_TEXT = PRIVATE_TENANT_RENDERING_TEXT;
const globalTenantName = 'global_tenant';
exports.globalTenantName = globalTenantName;
let AuthType;
/**
 * A valid resource name should not containing percent sign (%) as they raise url injection issue.
 * And also should not be empty.
 * @param resourceName resource name to be validated
 */

exports.AuthType = AuthType;

(function (AuthType) {
  AuthType["BASIC"] = "basicauth";
  AuthType["OPEN_ID"] = "openid";
  AuthType["JWT"] = "jwt";
  AuthType["SAML"] = "saml";
  AuthType["PROXY"] = "proxy";
  AuthType["ANONYMOUS"] = "anonymous";
})(AuthType || (exports.AuthType = AuthType = {}));

function isValidResourceName(resourceName) {
  // see: https://javascript.info/regexp-unicode
  const exp = new RegExp('[\\p{C}%]', 'u');
  return !exp.test(resourceName) && resourceName.length > 0;
}

function isPrivateTenant(selectedTenant) {
  return selectedTenant !== null && selectedTenant === PRIVATE_TENANT_SYMBOL;
}

function isRenderingPrivateTenant(selectedTenant) {
  return selectedTenant !== null && (selectedTenant === null || selectedTenant === void 0 ? void 0 : selectedTenant.startsWith(PRIVATE_TENANT_SYMBOL));
}

function isGlobalTenant(selectedTenant) {
  return selectedTenant !== null && selectedTenant === GLOBAL_TENANT_SYMBOL;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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