/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.expression.function.RelevanceFunctionResolver;

public final class OpenSearchFunctions {
    public static void register(BuiltinFunctionRepository repository) {
        repository.register(OpenSearchFunctions.match_bool_prefix());
        repository.register(OpenSearchFunctions.match());
        repository.register(OpenSearchFunctions.multi_match());
        repository.register(OpenSearchFunctions.simple_query_string());
        repository.register(OpenSearchFunctions.query_string());
        repository.register(OpenSearchFunctions.match_phrase(BuiltinFunctionName.MATCH_PHRASE));
        repository.register(OpenSearchFunctions.match_phrase(BuiltinFunctionName.MATCHPHRASE));
        repository.register(OpenSearchFunctions.match_phrase_prefix());
    }

    private static FunctionResolver match_bool_prefix() {
        FunctionName name = BuiltinFunctionName.MATCH_BOOL_PREFIX.getName();
        return new RelevanceFunctionResolver(name, ExprCoreType.STRING);
    }

    private static FunctionResolver match() {
        FunctionName funcName = BuiltinFunctionName.MATCH.getName();
        return new RelevanceFunctionResolver(funcName, ExprCoreType.STRING);
    }

    private static FunctionResolver match_phrase_prefix() {
        FunctionName funcName = BuiltinFunctionName.MATCH_PHRASE_PREFIX.getName();
        return new RelevanceFunctionResolver(funcName, ExprCoreType.STRING);
    }

    private static FunctionResolver match_phrase(BuiltinFunctionName matchPhrase) {
        FunctionName funcName = matchPhrase.getName();
        return new RelevanceFunctionResolver(funcName, ExprCoreType.STRING);
    }

    private static FunctionResolver multi_match() {
        FunctionName funcName = BuiltinFunctionName.MULTI_MATCH.getName();
        return new RelevanceFunctionResolver(funcName, ExprCoreType.STRUCT);
    }

    private static FunctionResolver simple_query_string() {
        FunctionName funcName = BuiltinFunctionName.SIMPLE_QUERY_STRING.getName();
        return new RelevanceFunctionResolver(funcName, ExprCoreType.STRUCT);
    }

    private static FunctionResolver query_string() {
        FunctionName funcName = BuiltinFunctionName.QUERY_STRING.getName();
        return new RelevanceFunctionResolver(funcName, ExprCoreType.STRUCT);
    }

    @Generated
    private OpenSearchFunctions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class OpenSearchFunction
    extends FunctionExpression {
        private final FunctionName functionName;
        private final List<Expression> arguments;

        public OpenSearchFunction(FunctionName functionName, List<Expression> arguments) {
            super(functionName, arguments);
            this.functionName = functionName;
            this.arguments = arguments;
        }

        @Override
        public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
            throw new UnsupportedOperationException(String.format("OpenSearch defined function [%s] is only supported in WHERE and HAVING clause.", this.functionName));
        }

        @Override
        public ExprType type() {
            return ExprCoreType.BOOLEAN;
        }

        @Override
        public String toString() {
            List args = this.arguments.stream().map(arg -> String.format("%s=%s", ((NamedArgumentExpression)arg).getArgName(), ((NamedArgumentExpression)arg).getValue().toString())).collect(Collectors.toList());
            return String.format("%s(%s)", this.functionName, String.join((CharSequence)", ", args));
        }
    }
}

