/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical.collector;

import com.google.common.collect.ImmutableList;
import java.util.List;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.aggregation.NamedAggregator;
import org.opensearch.sql.planner.physical.collector.BucketCollector;
import org.opensearch.sql.planner.physical.collector.MetricCollector;
import org.opensearch.sql.planner.physical.collector.SpanCollector;
import org.opensearch.sql.storage.bindingtuple.BindingTuple;

public interface Collector {
    public void collect(BindingTuple var1);

    public List<ExprValue> results();

    public static final class Builder {
        public static Collector build(NamedExpression span, List<NamedExpression> buckets, List<NamedAggregator> aggregators) {
            if (span == null && buckets.isEmpty()) {
                return new MetricCollector(aggregators);
            }
            if (span != null) {
                return new SpanCollector(span, () -> Builder.build(null, buckets, aggregators));
            }
            return new BucketCollector(buckets.get(0), () -> Builder.build(null, (List<NamedExpression>)ImmutableList.copyOf(buckets.subList(1, buckets.size())), aggregators));
        }

        @Generated
        private Builder() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

