# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2011 Kristian Høgsberg
# Copyright © 2010-2011 Intel Corporation
# Copyright © 2012-2013 Collabora, Ltd.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice (including the
# next paragraph) shall be included in all copies or substantial
# portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from .wl_shell_surface import WlShellSurface
from .wl_surface import WlSurface


class WlShell(Interface):
    """Create desktop-style surfaces

    This interface is implemented by servers that provide desktop-style user
    interfaces.

    It allows clients to associate a
    :class:`~pywayland.protocol.wayland.WlShellSurface` with a basic surface.

    Note! This protocol is deprecated and not intended for production use. For
    desktop-style user interfaces, use
    :class:`~pywayland.protocol.xdg_shell_unstable_v5.XdgShell`. Compositors
    and clients should not implement this interface.
    """

    name = "wl_shell"
    version = 1

    class error(enum.IntEnum):
        role = 0


class WlShellProxy(Proxy[WlShell]):
    interface = WlShell

    @WlShell.request(
        Argument(ArgumentType.NewId, interface=WlShellSurface),
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def get_shell_surface(self, surface: WlSurface) -> Proxy[WlShellSurface]:
        """Create a shell surface from a surface

        Create a shell surface for an existing surface. This gives the
        :class:`~pywayland.protocol.wayland.WlSurface` the role of a shell
        surface. If the :class:`~pywayland.protocol.wayland.WlSurface` already
        has another role, it raises a protocol error.

        Only one shell surface can be associated with a given surface.

        :param surface:
            surface to be given the shell surface role
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :returns:
            :class:`~pywayland.protocol.wayland.WlShellSurface` -- shell
            surface to create
        """
        id = self._marshal_constructor(0, WlShellSurface, surface)
        return id


class WlShellResource(Resource):
    interface = WlShell


class WlShellGlobal(Global):
    interface = WlShell


WlShell._gen_c()
WlShell.proxy_class = WlShellProxy
WlShell.resource_class = WlShellResource
WlShell.global_class = WlShellGlobal
