# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2013 Kristian Høgsberg
# Copyright © 2013      Rafael Antognolli
# Copyright © 2013      Jasper St. Pierre
# Copyright © 2010-2013 Intel Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from ..wayland import WlOutput
from ..wayland import WlSeat


class XdgSurface(Interface):
    """A desktop window

    An interface that may be implemented by a
    :class:`~pywayland.protocol.wayland.WlSurface`, for implementations that
    provide a desktop-style user interface.

    It provides requests to treat surfaces like windows, allowing to set
    properties like maximized, fullscreen, minimized, and to move and resize
    them, and associate metadata like title and app id.

    The client must call :func:`WlSurface.commit()
    <pywayland.protocol.wayland.WlSurface.commit>` on the corresponding
    :class:`~pywayland.protocol.wayland.WlSurface` for the :class:`XdgSurface`
    state to take effect. Prior to committing the new state, it can set up
    initial configuration, such as maximizing or setting a window geometry.

    Even without attaching a buffer the compositor must respond to initial
    committed configuration, for instance sending a configure event with
    expected window geometry if the client maximized its surface during
    initialization.

    For a surface to be mapped by the compositor the client must have committed
    both an :class:`XdgSurface` state and a buffer.
    """

    name = "xdg_surface"
    version = 1

    class resize_edge(enum.IntEnum):
        none = 0
        top = 1
        bottom = 2
        left = 4
        top_left = 5
        bottom_left = 6
        right = 8
        top_right = 9
        bottom_right = 10

    class state(enum.IntEnum):
        maximized = 1
        fullscreen = 2
        resizing = 3
        activated = 4


class XdgSurfaceProxy(Proxy[XdgSurface]):
    interface = XdgSurface

    @XdgSurface.request()
    def destroy(self) -> None:
        """Destroy the :class:`XdgSurface`

        Unmap and destroy the window. The window will be effectively hidden
        from the user's point of view, and all state like maximization,
        fullscreen, and so on, will be lost.
        """
        self._marshal(0)
        self._destroy()

    @XdgSurface.request(
        Argument(ArgumentType.Object, interface=XdgSurface, nullable=True),
    )
    def set_parent(self, parent: XdgSurface | None) -> None:
        """Set the parent of this surface

        Set the "parent" of this surface. This window should be stacked above a
        parent. The parent surface must be mapped as long as this surface is
        mapped.

        Parent windows should be set on dialogs, toolboxes, or other
        "auxiliary" surfaces, so that the parent is raised when the dialog is
        raised.

        :param parent:
        :type parent:
            :class:`XdgSurface` or `None`
        """
        self._marshal(1, parent)

    @XdgSurface.request(
        Argument(ArgumentType.String),
    )
    def set_title(self, title: str) -> None:
        """Set surface title

        Set a short title for the surface.

        This string may be used to identify the surface in a task bar, window
        list, or other user interface elements provided by the compositor.

        The string must be encoded in UTF-8.

        :param title:
        :type title:
            `ArgumentType.String`
        """
        self._marshal(2, title)

    @XdgSurface.request(
        Argument(ArgumentType.String),
    )
    def set_app_id(self, app_id: str) -> None:
        """Set application id

        Set an application identifier for the surface.

        The app ID identifies the general class of applications to which the
        surface belongs. The compositor can use this to group multiple surfaces
        together, or to determine how to launch a new application.

        For D-Bus activatable applications, the app ID is used as the D-Bus
        service name.

        The compositor shell will try to group application surfaces together by
        their app ID.  As a best practice, it is suggested to select app ID's
        that match the basename of the application's .desktop file. For
        example, "org.freedesktop.FooViewer" where the .desktop file is
        "org.freedesktop.FooViewer.desktop".

        See the desktop-entry specification [0] for more details on application
        identifiers and how they relate to well-known D-Bus names and .desktop
        files.

        [0] http://standards.freedesktop.org/desktop-entry-spec/

        :param app_id:
        :type app_id:
            `ArgumentType.String`
        """
        self._marshal(3, app_id)

    @XdgSurface.request(
        Argument(ArgumentType.Object, interface=WlSeat),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def show_window_menu(self, seat: WlSeat, serial: int, x: int, y: int) -> None:
        """Show the window menu

        Clients implementing client-side decorations might want to show a
        context menu when right-clicking on the decorations, giving the user a
        menu that they can use to maximize or minimize the window.

        This request asks the compositor to pop up such a window menu at the
        given position, relative to the local surface coordinates of the parent
        surface. There are no guarantees as to what menu items the window menu
        contains.

        This request must be used in response to some sort of user action like
        a button press, key press, or touch down event.

        :param seat:
            the :class:`~pywayland.protocol.wayland.WlSeat` of the user event
        :type seat:
            :class:`~pywayland.protocol.wayland.WlSeat`
        :param serial:
            the serial of the user event
        :type serial:
            `ArgumentType.Uint`
        :param x:
            the x position to pop up the window menu at
        :type x:
            `ArgumentType.Int`
        :param y:
            the y position to pop up the window menu at
        :type y:
            `ArgumentType.Int`
        """
        self._marshal(4, seat, serial, x, y)

    @XdgSurface.request(
        Argument(ArgumentType.Object, interface=WlSeat),
        Argument(ArgumentType.Uint),
    )
    def move(self, seat: WlSeat, serial: int) -> None:
        """Start an interactive move

        Start an interactive, user-driven move of the surface.

        This request must be used in response to some sort of user action like
        a button press, key press, or touch down event. The passed serial is
        used to determine the type of interactive move (touch, pointer, etc).

        The server may ignore move requests depending on the state of the
        surface (e.g. fullscreen or maximized), or if the passed serial is no
        longer valid.

        If triggered, the surface will lose the focus of the device
        (:class:`~pywayland.protocol.wayland.WlPointer`,
        :class:`~pywayland.protocol.wayland.WlTouch`, etc) used for the move.
        It is up to the compositor to visually indicate that the move is taking
        place, such as updating a pointer cursor, during the move. There is no
        guarantee that the device focus will return when the move is completed.

        :param seat:
            the :class:`~pywayland.protocol.wayland.WlSeat` of the user event
        :type seat:
            :class:`~pywayland.protocol.wayland.WlSeat`
        :param serial:
            the serial of the user event
        :type serial:
            `ArgumentType.Uint`
        """
        self._marshal(5, seat, serial)

    @XdgSurface.request(
        Argument(ArgumentType.Object, interface=WlSeat),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def resize(self, seat: WlSeat, serial: int, edges: int) -> None:
        """Start an interactive resize

        Start a user-driven, interactive resize of the surface.

        This request must be used in response to some sort of user action like
        a button press, key press, or touch down event. The passed serial is
        used to determine the type of interactive resize (touch, pointer, etc).

        The server may ignore resize requests depending on the state of the
        surface (e.g. fullscreen or maximized).

        If triggered, the client will receive configure events with the
        "resize" state enum value and the expected sizes. See the "resize" enum
        value for more details about what is required. The client must also
        acknowledge configure events using "ack_configure". After the resize is
        completed, the client will receive another "configure" event without
        the resize state.

        If triggered, the surface also will lose the focus of the device
        (:class:`~pywayland.protocol.wayland.WlPointer`,
        :class:`~pywayland.protocol.wayland.WlTouch`, etc) used for the resize.
        It is up to the compositor to visually indicate that the resize is
        taking place, such as updating a pointer cursor, during the resize.
        There is no guarantee that the device focus will return when the resize
        is completed.

        The edges parameter specifies how the surface should be resized, and is
        one of the values of the resize_edge enum. The compositor may use this
        information to update the surface position for example when dragging
        the top left corner. The compositor may also use this information to
        adapt its behavior, e.g. choose an appropriate cursor image.

        :param seat:
            the :class:`~pywayland.protocol.wayland.WlSeat` of the user event
        :type seat:
            :class:`~pywayland.protocol.wayland.WlSeat`
        :param serial:
            the serial of the user event
        :type serial:
            `ArgumentType.Uint`
        :param edges:
            which edge or corner is being dragged
        :type edges:
            `ArgumentType.Uint`
        """
        self._marshal(6, seat, serial, edges)

    @XdgSurface.request(
        Argument(ArgumentType.Uint),
    )
    def ack_configure(self, serial: int) -> None:
        """Ack a configure event

        When a configure event is received, if a client commits the surface in
        response to the configure event, then the client must make an
        ack_configure request sometime before the commit request, passing along
        the serial of the configure event.

        For instance, the compositor might use this information to move a
        surface to the top left only when the client has drawn itself for the
        maximized or fullscreen state.

        If the client receives multiple configure events before it can respond
        to one, it only has to ack the last configure event.

        A client is not required to commit immediately after sending an
        ack_configure request - it may even ack_configure several times before
        its next surface commit.

        The compositor expects that the most recently received ack_configure
        request at the time of a commit indicates which configure event the
        client is responding to.

        :param serial:
            the serial from the configure event
        :type serial:
            `ArgumentType.Uint`
        """
        self._marshal(7, serial)

    @XdgSurface.request(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def set_window_geometry(self, x: int, y: int, width: int, height: int) -> None:
        """Set the new window geometry

        The window geometry of a window is its "visible bounds" from the user's
        perspective. Client-side decorations often have invisible portions like
        drop-shadows which should be ignored for the purposes of aligning,
        placing and constraining windows.

        The window geometry is double buffered, and will be applied at the time
        :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` of the corresponding
        :class:`~pywayland.protocol.wayland.WlSurface` is called.

        Once the window geometry of the surface is set once, it is not possible
        to unset it, and it will remain the same until set_window_geometry is
        called again, even if a new subsurface or buffer is attached.

        If never set, the value is the full bounds of the surface, including
        any subsurfaces. This updates dynamically on every commit. This unset
        mode is meant for extremely simple clients.

        If responding to a configure event, the window geometry in here must
        respect the sizing negotiations specified by the states in the
        configure event.

        The arguments are given in the surface local coordinate space of the
        :class:`~pywayland.protocol.wayland.WlSurface` associated with this
        :class:`XdgSurface`.

        The width and height must be greater than zero.

        :param x:
        :type x:
            `ArgumentType.Int`
        :param y:
        :type y:
            `ArgumentType.Int`
        :param width:
        :type width:
            `ArgumentType.Int`
        :param height:
        :type height:
            `ArgumentType.Int`
        """
        self._marshal(8, x, y, width, height)

    @XdgSurface.request()
    def set_maximized(self) -> None:
        """Maximize the window

        Maximize the surface.

        After requesting that the surface should be maximized, the compositor
        will respond by emitting a configure event with the "maximized" state
        and the required window geometry. The client should then update its
        content, drawing it in a maximized state, i.e. without shadow or other
        decoration outside of the window geometry. The client must also
        acknowledge the configure when committing the new content (see
        ack_configure).

        It is up to the compositor to decide how and where to maximize the
        surface, for example which output and what region of the screen should
        be used.

        If the surface was already maximized, the compositor will still emit a
        configure event with the "maximized" state.
        """
        self._marshal(9)

    @XdgSurface.request()
    def unset_maximized(self) -> None:
        """Unmaximize the window

        Unmaximize the surface.

        After requesting that the surface should be unmaximized, the compositor
        will respond by emitting a configure event without the "maximized"
        state. If available, the compositor will include the window geometry
        dimensions the window had prior to being maximized in the configure
        request. The client must then update its content, drawing it in a
        regular state, i.e. potentially with shadow, etc. The client must also
        acknowledge the configure when committing the new content (see
        ack_configure).

        It is up to the compositor to position the surface after it was
        unmaximized; usually the position the surface had before maximizing, if
        applicable.

        If the surface was already not maximized, the compositor will still
        emit a configure event without the "maximized" state.
        """
        self._marshal(10)

    @XdgSurface.request(
        Argument(ArgumentType.Object, interface=WlOutput, nullable=True),
    )
    def set_fullscreen(self, output: WlOutput | None) -> None:
        """Set the window as fullscreen on a monitor

        Make the surface fullscreen.

        You can specify an output that you would prefer to be fullscreen. If
        this value is NULL, it's up to the compositor to choose which display
        will be used to map this surface.

        If the surface doesn't cover the whole output, the compositor will
        position the surface in the center of the output and compensate with
        black borders filling the rest of the output.

        :param output:
        :type output:
            :class:`~pywayland.protocol.wayland.WlOutput` or `None`
        """
        self._marshal(11, output)

    @XdgSurface.request()
    def unset_fullscreen(self) -> None:
        """unset_fullscreen
        """
        self._marshal(12)

    @XdgSurface.request()
    def set_minimized(self) -> None:
        """Set the window as minimized

        Request that the compositor minimize your surface. There is no way to
        know if the surface is currently minimized, nor is there any way to
        unset minimization on this surface.

        If you are looking to throttle redrawing when minimized, please instead
        use the :func:`WlSurface.frame()
        <pywayland.protocol.wayland.WlSurface.frame>` event for this, as this
        will also work with live previews on windows in Alt-Tab, Expose or
        similar compositor features.
        """
        self._marshal(13)


class XdgSurfaceResource(Resource):
    interface = XdgSurface

    @XdgSurface.event(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Array),
        Argument(ArgumentType.Uint),
    )
    def configure(self, width: int, height: int, states: list, serial: int) -> None:
        """Suggest a surface change

        The configure event asks the client to resize its surface or to change
        its state.

        The width and height arguments specify a hint to the window about how
        its surface should be resized in window geometry coordinates. See
        set_window_geometry.

        If the width or height arguments are zero, it means the client should
        decide its own window dimension. This may happen when the compositor
        need to configure the state of the surface but doesn't have any
        information about any previous or expected dimension.

        The states listed in the event specify how the width/height arguments
        should be interpreted, and possibly how it should be drawn.

        Clients should arrange their surface for the new size and states, and
        then send a ack_configure request with the serial sent in this
        configure event at some point before committing the new surface.

        If the client receives multiple configure events before it can respond
        to one, it is free to discard all but the last event it received.

        :param width:
        :type width:
            `ArgumentType.Int`
        :param height:
        :type height:
            `ArgumentType.Int`
        :param states:
        :type states:
            `ArgumentType.Array`
        :param serial:
        :type serial:
            `ArgumentType.Uint`
        """
        self._post_event(0, width, height, states, serial)

    @XdgSurface.event()
    def close(self) -> None:
        """Surface wants to be closed

        The close event is sent by the compositor when the user wants the
        surface to be closed. This should be equivalent to the user clicking
        the close button in client-side decorations, if your application has
        any...

        This is only a request that the user intends to close your window. The
        client may choose to ignore this request, or show a dialog to ask the
        user to save their data...
        """
        self._post_event(1)


class XdgSurfaceGlobal(Global):
    interface = XdgSurface


XdgSurface._gen_c()
XdgSurface.proxy_class = XdgSurfaceProxy
XdgSurface.resource_class = XdgSurfaceResource
XdgSurface.global_class = XdgSurfaceGlobal
