//! @file a68g-math.h
//! @author J. Marcel van der Veer
//
//! @section Copyright
//
// This file is part of Algol68G - an Algol 68 compiler-interpreter.
// Copyright 2001-2022 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section License
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the 
// Free Software Foundation; either version 3 of the License, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details. You should have received a copy of the GNU General Public 
// License along with this program. If not, see <http://www.gnu.org/licenses/>.

static const REAL_T factable[A68_MAX_FAC + 1] = {
  /* 0   */ 1.000000000000000000000e0,
  /* 1   */ 1.000000000000000000000e0,
  /* 2   */ 2.000000000000000000000e0,
  /* 3   */ 6.000000000000000000000e0,
  /* 4   */ 2.400000000000000000000e1,
  /* 5   */ 1.200000000000000000000e2,
  /* 6   */ 7.200000000000000000000e2,
  /* 7   */ 5.040000000000000000000e3,
  /* 8   */ 4.032000000000000000000e4,
  /* 9   */ 3.628800000000000000000e5,
  /* 10  */ 3.628800000000000000000e6,
  /* 11  */ 3.991680000000000000000e7,
  /* 12  */ 4.790016000000000000000e8,
  /* 13  */ 6.227020800000000000000e9,
  /* 14  */ 8.717829120000000000000e10,
  /* 15  */ 1.307674368000000000000e12,
  /* 16  */ 2.092278988800000000000e13,
  /* 17  */ 3.556874280960000000000e14,
  /* 18  */ 6.402373705728000000000e15,
  /* 19  */ 1.216451004088320000000e17,
  /* 20  */ 2.432902008176640000000e18,
  /* 21  */ 5.109094217170944000000e19,
  /* 22  */ 1.124000727777607680000e21,
  /* 23  */ 2.585201673888497664000e22,
  /* 24  */ 6.204484017332394393600e23,
  /* 25  */ 1.551121004333098598400e25,
  /* 26  */ 4.032914611266056355840e26,
  /* 27  */ 1.088886945041835216077e28,
  /* 28  */ 3.048883446117138605015e29,
  /* 29  */ 8.841761993739701954544e30,
  /* 30  */ 2.652528598121910586363e32,
  /* 31  */ 8.222838654177922817726e33,
  /* 32  */ 2.631308369336935301672e35,
  /* 33  */ 8.683317618811886495518e36,
  /* 34  */ 2.952327990396041408476e38,
  /* 35  */ 1.033314796638614492967e40,
  /* 36  */ 3.719933267899012174680e41,
  /* 37  */ 1.376375309122634504632e43,
  /* 38  */ 5.230226174666011117600e44,
  /* 39  */ 2.039788208119744335864e46,
  /* 40  */ 8.159152832478977343456e47,
  /* 41  */ 3.345252661316380710817e49,
  /* 42  */ 1.405006117752879898543e51,
  /* 43  */ 6.041526306337383563736e52,
  /* 44  */ 2.658271574788448768044e54,
  /* 45  */ 1.196222208654801945620e56,
  /* 46  */ 5.502622159812088949850e57,
  /* 47  */ 2.586232415111681806430e59,
  /* 48  */ 1.241391559253607267086e61,
  /* 49  */ 6.082818640342675608723e62,
  /* 50  */ 3.041409320171337804361e64,
  /* 51  */ 1.551118753287382280224e66,
  /* 52  */ 8.065817517094387857166e67,
  /* 53  */ 4.274883284060025564298e69,
  /* 54  */ 2.308436973392413804721e71,
  /* 55  */ 1.269640335365827592597e73,
  /* 56  */ 7.109985878048634518540e74,
  /* 57  */ 4.052691950487721675568e76,
  /* 58  */ 2.350561331282878571829e78,
  /* 59  */ 1.386831185456898357379e80,
  /* 60  */ 8.320987112741390144276e81,
  /* 61  */ 5.075802138772247988009e83,
  /* 62  */ 3.146997326038793752565e85,
  /* 63  */ 1.982608315404440064116e87,
  /* 64  */ 1.268869321858841641034e89,
  /* 65  */ 8.247650592082470666723e90,
  /* 66  */ 5.443449390774430640037e92,
  /* 67  */ 3.647111091818868528825e94,
  /* 68  */ 2.480035542436830599601e96,
  /* 69  */ 1.711224524281413113725e98,
  /* 70  */ 1.197857166996989179607e100,
  /* 71  */ 8.504785885678623175212e101,
  /* 72  */ 6.123445837688608686152e103,
  /* 73  */ 4.470115461512684340891e105,
  /* 74  */ 3.307885441519386412260e107,
  /* 75  */ 2.480914081139539809195e109,
  /* 76  */ 1.885494701666050254988e111,
  /* 77  */ 1.451830920282858696341e113,
  /* 78  */ 1.132428117820629783146e115,
  /* 79  */ 8.946182130782975286851e116,
  /* 80  */ 7.156945704626380229481e118,
  /* 81  */ 5.797126020747367985880e120,
  /* 82  */ 4.753643337012841748421e122,
  /* 83  */ 3.945523969720658651190e124,
  /* 84  */ 3.314240134565353266999e126,
  /* 85  */ 2.817104114380550276949e128,
  /* 86  */ 2.422709538367273238177e130,
  /* 87  */ 2.107757298379527717214e132,
  /* 88  */ 1.854826422573984391148e134,
  /* 89  */ 1.650795516090846108122e136,
  /* 90  */ 1.485715964481761497310e138,
  /* 91  */ 1.352001527678402962552e140,
  /* 92  */ 1.243841405464130725548e142,
  /* 93  */ 1.156772507081641574759e144,
  /* 94  */ 1.087366156656743080274e146,
  /* 95  */ 1.032997848823905926260e148,
  /* 96  */ 9.916779348709496892096e149,
  /* 97  */ 9.619275968248211985333e151,
  /* 98  */ 9.426890448883247745626e153,
  /* 99  */ 9.332621544394415268170e155,
  /* 100 */ 9.332621544394415268170e157,
  /* 101 */ 9.425947759838359420852e159,
  /* 102 */ 9.614466715035126609269e161,
  /* 103 */ 9.902900716486180407547e163,
  /* 104 */ 1.029901674514562762385e166,
  /* 105 */ 1.081396758240290900504e168,
  /* 106 */ 1.146280563734708354534e170,
  /* 107 */ 1.226520203196137939352e172,
  /* 108 */ 1.324641819451828974500e174,
  /* 109 */ 1.443859583202493582205e176,
  /* 110 */ 1.588245541522742940425e178,
  /* 111 */ 1.762952551090244663872e180,
  /* 112 */ 1.974506857221074023537e182,
  /* 113 */ 2.231192748659813646597e184,
  /* 114 */ 2.543559733472187557120e186,
  /* 115 */ 2.925093693493015690688e188,
  /* 116 */ 3.393108684451898201198e190,
  /* 117 */ 3.969937160808720895402e192,
  /* 118 */ 4.684525849754290656574e194,
  /* 119 */ 5.574585761207605881323e196,
  /* 120 */ 6.689502913449127057588e198,
  /* 121 */ 8.094298525273443739682e200,
  /* 122 */ 9.875044200833601362412e202,
  /* 123 */ 1.214630436702532967577e205,
  /* 124 */ 1.506141741511140879795e207,
  /* 125 */ 1.882677176888926099744e209,
  /* 126 */ 2.372173242880046885677e211,
  /* 127 */ 3.012660018457659544810e213,
  /* 128 */ 3.856204823625804217357e215,
  /* 129 */ 4.974504222477287440390e217,
  /* 130 */ 6.466855489220473672507e219,
  /* 131 */ 8.471580690878820510985e221,
  /* 132 */ 1.118248651196004307450e224,
  /* 133 */ 1.487270706090685728908e226,
  /* 134 */ 1.992942746161518876737e228,
  /* 135 */ 2.690472707318050483595e230,
  /* 136 */ 3.659042881952548657690e232,
  /* 137 */ 5.012888748274991661035e234,
  /* 138 */ 6.917786472619488492228e236,
  /* 139 */ 9.615723196941089004197e238,
  /* 140 */ 1.346201247571752460588e241,
  /* 141 */ 1.898143759076170969429e243,
  /* 142 */ 2.695364137888162776589e245,
  /* 143 */ 3.854370717180072770522e247,
  /* 144 */ 5.550293832739304789551e249,
  /* 145 */ 8.047926057471991944849e251,
  /* 146 */ 1.174997204390910823948e254,
  /* 147 */ 1.727245890454638911203e256,
  /* 148 */ 2.556323917872865588581e258,
  /* 149 */ 3.808922637630569726986e260,
  /* 150 */ 5.713383956445854590479e262,
  /* 151 */ 8.627209774233240431623e264,
  /* 152 */ 1.311335885683452545607e267,
  /* 153 */ 2.006343905095682394778e269,
  /* 154 */ 3.089769613847350887959e271,
  /* 155 */ 4.789142901463393876336e273,
  /* 156 */ 7.471062926282894447084e275,
  /* 157 */ 1.172956879426414428192e278,
  /* 158 */ 1.853271869493734796544e280,
  /* 159 */ 2.946702272495038326504e282,
  /* 160 */ 4.714723635992061322407e284,
  /* 161 */ 7.590705053947218729075e286,
  /* 162 */ 1.229694218739449434110e289,
  /* 163 */ 2.004401576545302577600e291,
  /* 164 */ 3.287218585534296227263e293,
  /* 165 */ 5.423910666131588774984e295,
  /* 166 */ 9.003691705778437366474e297,
  /* 167 */ 1.503616514864999040201e300,
  /* 168 */ 2.526075744973198387538e302,
  /* 169 */ 4.269068009004705274939e304,
  /* 170 */ 7.257415615307998967397e306
};

static const REAL_T ln_factable[A68_MAX_FAC + 1] = {
  /* 0   */ 0.000000000000000000000e0,
  /* 1   */ 0.000000000000000000000e0,
  /* 2   */ 6.931471805599453094172e-1,
  /* 3   */ 1.791759469228055000812e0,
  /* 4   */ 3.178053830347945619647e0,
  /* 5   */ 4.787491742782045994248e0,
  /* 6   */ 6.579251212010100995060e0,
  /* 7   */ 8.525161361065414300166e0,
  /* 8   */ 1.060460290274525022842e1,
  /* 9   */ 1.280182748008146961121e1,
  /* 10  */ 1.510441257307551529523e1,
  /* 11  */ 1.750230784587388583929e1,
  /* 12  */ 1.998721449566188614952e1,
  /* 13  */ 2.255216385312342288557e1,
  /* 14  */ 2.519122118273868150009e1,
  /* 15  */ 2.789927138384089156609e1,
  /* 16  */ 3.067186010608067280376e1,
  /* 17  */ 3.350507345013688888401e1,
  /* 18  */ 3.639544520803305357622e1,
  /* 19  */ 3.933988418719949403622e1,
  /* 20  */ 4.233561646075348502966e1,
  /* 21  */ 4.538013889847690802616e1,
  /* 22  */ 4.847118135183522387964e1,
  /* 23  */ 5.160667556776437357045e1,
  /* 24  */ 5.478472939811231919009e1,
  /* 25  */ 5.800360522298051993929e1,
  /* 26  */ 6.126170176100200198477e1,
  /* 27  */ 6.455753862700633105895e1,
  /* 28  */ 6.788974313718153498289e1,
  /* 29  */ 7.125703896716800901007e1,
  /* 30  */ 7.465823634883016438549e1,
  /* 31  */ 7.809222355331531063142e1,
  /* 32  */ 8.155795945611503717850e1,
  /* 33  */ 8.505446701758151741396e1,
  /* 34  */ 8.858082754219767880363e1,
  /* 35  */ 9.213617560368709248333e1,
  /* 36  */ 9.571969454214320248496e1,
  /* 37  */ 9.933061245478742692933e1,
  /* 38  */ 1.029681986145138126988e2,
  /* 39  */ 1.066317602606434591262e2,
  /* 40  */ 1.103206397147573954291e2,
  /* 41  */ 1.140342117814617032329e2,
  /* 42  */ 1.177718813997450715388e2,
  /* 43  */ 1.215330815154386339623e2,
  /* 44  */ 1.253172711493568951252e2,
  /* 45  */ 1.291239336391272148826e2,
  /* 46  */ 1.329525750356163098828e2,
  /* 47  */ 1.368027226373263684696e2,
  /* 48  */ 1.406739236482342593987e2,
  /* 49  */ 1.445657439463448860089e2,
  /* 50  */ 1.484777669517730320675e2,
  /* 51  */ 1.524095925844973578392e2,
  /* 52  */ 1.563608363030787851941e2,
  /* 53  */ 1.603311282166309070282e2,
  /* 54  */ 1.643201122631951814118e2,
  /* 55  */ 1.683274454484276523305e2,
  /* 56  */ 1.723527971391628015638e2,
  /* 57  */ 1.763958484069973517152e2,
  /* 58  */ 1.804562914175437710518e2,
  /* 59  */ 1.845338288614494905025e2,
  /* 60  */ 1.886281734236715911873e2,
  /* 61  */ 1.927390472878449024360e2,
  /* 62  */ 1.968661816728899939914e2,
  /* 63  */ 2.010093163992815266793e2,
  /* 64  */ 2.051681994826411985358e2,
  /* 65  */ 2.093425867525368356464e2,
  /* 66  */ 2.135322414945632611913e2,
  /* 67  */ 2.177369341139542272510e2,
  /* 68  */ 2.219564418191303339501e2,
  /* 69  */ 2.261905483237275933323e2,
  /* 70  */ 2.304390435657769523214e2,
  /* 71  */ 2.347017234428182677427e2,
  /* 72  */ 2.389783895618343230538e2,
  /* 73  */ 2.432688490029827141829e2,
  /* 74  */ 2.475729140961868839366e2,
  /* 75  */ 2.518904022097231943772e2,
  /* 76  */ 2.562211355500095254561e2,
  /* 77  */ 2.605649409718632093053e2,
  /* 78  */ 2.649216497985528010421e2,
  /* 79  */ 2.692910976510198225363e2,
  /* 80  */ 2.736731242856937041486e2,
  /* 81  */ 2.780675734403661429141e2,
  /* 82  */ 2.824742926876303960274e2,
  /* 83  */ 2.868931332954269939509e2,
  /* 84  */ 2.913239500942703075662e2,
  /* 85  */ 2.957666013507606240211e2,
  /* 86  */ 3.002209486470141317540e2,
  /* 87  */ 3.046868567656687154726e2,
  /* 88  */ 3.091641935801469219449e2,
  /* 89  */ 3.136528299498790617832e2,
  /* 90  */ 3.181526396202093268500e2,
  /* 91  */ 3.226634991267261768912e2,
  /* 92  */ 3.271852877037752172008e2,
  /* 93  */ 3.317178871969284731381e2,
  /* 94  */ 3.362611819791984770344e2,
  /* 95  */ 3.408150588707990178690e2,
  /* 96  */ 3.453794070622668541074e2,
  /* 97  */ 3.499541180407702369296e2,
  /* 98  */ 3.545390855194408088492e2,
  /* 99  */ 3.591342053695753987760e2,
  /* 100 */ 3.637393755555634901441e2,
  /* 101 */ 3.683544960724047495950e2,
  /* 102 */ 3.729794688856890206760e2,
  /* 103 */ 3.776141978739186564468e2,
  /* 104 */ 3.822585887730600291111e2,
  /* 105 */ 3.869125491232175524822e2,
  /* 106 */ 3.915759882173296196258e2,
  /* 107 */ 3.962488170517915257991e2,
  /* 108 */ 4.009309482789157454921e2,
  /* 109 */ 4.056222961611448891925e2,
  /* 110 */ 4.103227765269373054205e2,
  /* 111 */ 4.150323067282496395563e2,
  /* 112 */ 4.197508055995447340991e2,
  /* 113 */ 4.244781934182570746677e2,
  /* 114 */ 4.292143918666515701285e2,
  /* 115 */ 4.339593239950148201939e2,
  /* 116 */ 4.387129141861211848399e2,
  /* 117 */ 4.434750881209189409588e2,
  /* 118 */ 4.482457727453846057188e2,
  /* 119 */ 4.530248962384961351041e2,
  /* 120 */ 4.578123879812781810984e2,
  /* 121 */ 4.626081785268749221865e2,
  /* 122 */ 4.674121995716081787447e2,
  /* 123 */ 4.722243839269805962399e2,
  /* 124 */ 4.770446654925856331047e2,
  /* 125 */ 4.818729792298879342285e2,
  /* 126 */ 4.867092611368394122258e2,
  /* 127 */ 4.915534482232980034989e2,
  /* 128 */ 4.964054784872176206648e2,
  /* 129 */ 5.012652908915792927797e2,
  /* 130 */ 5.061328253420348751997e2,
  /* 131 */ 5.110080226652360267439e2,
  /* 132 */ 5.158908245878223975982e2,
  /* 133 */ 5.207811737160441513633e2,
  /* 134 */ 5.256790135159950627324e2,
  /* 135 */ 5.305842882944334921812e2,
  /* 136 */ 5.354969431801695441897e2,
  /* 137 */ 5.404169241059976691050e2,
  /* 138 */ 5.453441777911548737966e2,
  /* 139 */ 5.502786517242855655538e2,
  /* 140 */ 5.552202941468948698523e2,
  /* 141 */ 5.601690540372730381305e2,
  /* 142 */ 5.651248810948742988613e2,
  /* 143 */ 5.700877257251342061414e2,
  /* 144 */ 5.750575390247102067619e2,
  /* 145 */ 5.800342727671307811636e2,
  /* 146 */ 5.850178793888391176022e2,
  /* 147 */ 5.900083119756178539038e2,
  /* 148 */ 5.950055242493819689670e2,
  /* 149 */ 6.000094705553274281080e2,
  /* 150 */ 6.050201058494236838580e2,
  /* 151 */ 6.100373856862386081868e2,
  /* 152 */ 6.150612662070848845750e2,
  /* 153 */ 6.200917041284773200381e2,
  /* 154 */ 6.251286567308909491967e2,
  /* 155 */ 6.301720818478101958172e2,
  /* 156 */ 6.352219378550597328635e2,
  /* 157 */ 6.402781836604080409209e2,
  /* 158 */ 6.453407786934350077245e2,
  /* 159 */ 6.504096828956552392500e2,
  /* 160 */ 6.554848567108890661717e2,
  /* 161 */ 6.605662610758735291676e2,
  /* 162 */ 6.656538574111059132426e2,
  /* 163 */ 6.707476076119126755767e2,
  /* 164 */ 6.758474740397368739994e2,
  /* 165 */ 6.809534195136374546094e2,
  /* 166 */ 6.860654073019939978423e2,
  /* 167 */ 6.911834011144107529496e2,
  /* 168 */ 6.963073650938140118743e2,
  /* 169 */ 7.014372638087370853465e2,
  /* 170 */ 7.065730622457873471107e2
};

#define N_c_inverfc 34

static const REAL_T c_inverfc[N_c_inverfc] = 
{
  0.91646139826896400000,
  0.48882664027310800000,
  0.23172920032340500000,
  0.12461045461371200000,
 -0.07288467655856750000, 
  0.26999930867002900000, 
  0.15068904736022300000, 
  0.11606502534161400000, 
  0.49999930343979000000,
  3.97886080735226000000, 
  0.00112648096188977922,
  1.05739299623423047e-4,
  0.00351287146129100025,
  7.71708358954120939e-4,
  0.00685649426074558612,
  0.00339721910367775861,
  0.01127491693325048700,
  0.01185981170477711040,
  0.01429619886978980180,
  0.03464942077890999220,
  0.00220995927012179067,
  0.07434243572417848610,
  0.10587217794159548800,
  0.01472979383314851210,
  0.31684763852013594400,
  0.71365763586873036400,
  1.05375024970847138000,
  1.21448730779995237000,
  1.16374581931560831000,
  0.95646497474479900600,
  0.68626594827409781600,
  0.43439749233143011500,
  0.24404451059319093500,
  0.12078223763524522200
};

#define N_ln1p 21

static const REAL_T c_ln1p[N_ln1p + 1] = 
{
  N_ln1p,
  1.8657327910677296608121390705e-18,
 -1.3492637457521938883731579510e-17,
  9.7089758328248469219003866867e-17,
 -7.0722150011433276578323272272e-16,
  5.1107345870861673561462339876e-15,
 -3.7581977830387938294437434651e-14,
  2.7291231220549214896095654769e-13,
 -2.0328515972462118942821556033e-12,
  1.4844576692270934446023686322e-11,
 -1.1260499376492049411710290413e-10,
  8.2751976628812389601561347296e-10,
 -6.4501969776090319441714445454e-09,
  4.7743678729400456026672697926e-08,
 -3.8873813517057343800270917900e-07,
  2.9004512660400621301999384544e-06,
 -0.00002553258886105542567601400,
  0.00019211375164056698287947962,
 -0.00200215904941415466274422081,
  0.01517767255690553732382488171,
 -0.28565398551049742084877469679,
  2.16647910664395270521272590407
};

