/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.bridge;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout2;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.filter.ExclusionArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.repository.Proxy;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Repository;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;

@Component(role=MavenRepositorySystem.class, hint="default")
public class MavenRepositorySystem {
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;
    @Requirement(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> layouts;
    private static final String WILDCARD = "*";
    private static final String EXTERNAL_WILDCARD = "external:*";
    private static final String EXTERNAL_HTTP_WILDCARD = "external:http:*";

    public Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type2) {
        return this.createArtifactX(groupId, artifactId, version, scope, type2);
    }

    public Artifact createProjectArtifact(String groupId, String artifactId, String metaVersionId) {
        return this.createProjectArtifactX(groupId, artifactId, metaVersionId);
    }

    public Artifact createDependencyArtifact(Dependency d) {
        VersionRange versionRange;
        if (d.getVersion() == null) {
            return null;
        }
        try {
            versionRange = VersionRange.createFromVersionSpec(d.getVersion());
        }
        catch (InvalidVersionSpecificationException e2) {
            return null;
        }
        Artifact artifact = this.createDependencyArtifactX(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
        if ("system".equals(d.getScope()) && d.getSystemPath() != null) {
            artifact.setFile(new File(d.getSystemPath()));
        }
        if (!d.getExclusions().isEmpty()) {
            artifact.setDependencyFilter(new ExclusionArtifactFilter(d.getExclusions()));
        }
        return artifact;
    }

    public Artifact createExtensionArtifact(String groupId, String artifactId, String version) {
        VersionRange versionRange;
        try {
            versionRange = VersionRange.createFromVersionSpec(version);
        }
        catch (InvalidVersionSpecificationException e2) {
            return null;
        }
        return this.createExtensionArtifactX(groupId, artifactId, versionRange);
    }

    public Artifact createParentArtifact(String groupId, String artifactId, String version) {
        return this.createParentArtifactX(groupId, artifactId, version);
    }

    public Artifact createPluginArtifact(Plugin plugin) {
        VersionRange versionRange;
        try {
            String version = plugin.getVersion();
            if (StringUtils.isEmpty(version)) {
                version = "RELEASE";
            }
            versionRange = VersionRange.createFromVersionSpec(version);
        }
        catch (InvalidVersionSpecificationException e2) {
            return null;
        }
        return this.createPluginArtifactX(plugin.getGroupId(), plugin.getArtifactId(), versionRange);
    }

    public void injectMirror(List<ArtifactRepository> repositories, List<Mirror> mirrors) {
        if (repositories != null && mirrors != null) {
            for (ArtifactRepository repository : repositories) {
                Mirror mirror = MavenRepositorySystem.getMirror(repository, mirrors);
                this.injectMirror(repository, mirror);
            }
        }
    }

    private Mirror getMirror(RepositorySystemSession session2, ArtifactRepository repository) {
        RemoteRepository repo;
        MirrorSelector selector;
        if (session2 != null && (selector = session2.getMirrorSelector()) != null && (repo = selector.getMirror(RepositoryUtils.toRepo(repository))) != null) {
            Mirror mirror = new Mirror();
            mirror.setId(repo.getId());
            mirror.setUrl(repo.getUrl());
            mirror.setLayout(repo.getContentType());
            mirror.setBlocked(repo.isBlocked());
            return mirror;
        }
        return null;
    }

    public void injectMirror(RepositorySystemSession session2, List<ArtifactRepository> repositories) {
        if (repositories != null && session2 != null) {
            for (ArtifactRepository repository : repositories) {
                Mirror mirror = this.getMirror(session2, repository);
                this.injectMirror(repository, mirror);
            }
        }
    }

    private void injectMirror(ArtifactRepository repository, Mirror mirror) {
        if (mirror != null) {
            ArtifactRepository original = MavenRepositorySystem.createArtifactRepository(repository.getId(), repository.getUrl(), repository.getLayout(), repository.getSnapshots(), repository.getReleases());
            repository.setMirroredRepositories(Collections.singletonList(original));
            repository.setId(mirror.getId());
            repository.setUrl(mirror.getUrl());
            if (StringUtils.isNotEmpty(mirror.getLayout())) {
                repository.setLayout(this.getLayout(mirror.getLayout()));
            }
            repository.setBlocked(mirror.isBlocked());
        }
    }

    private org.apache.maven.artifact.repository.Authentication getAuthentication(RepositorySystemSession session2, ArtifactRepository repository) {
        RemoteRepository repo;
        Authentication auth;
        AuthenticationSelector selector;
        if (session2 != null && (selector = session2.getAuthenticationSelector()) != null && (auth = selector.getAuthentication(repo = RepositoryUtils.toRepo(repository))) != null) {
            repo = new RemoteRepository.Builder(repo).setAuthentication(auth).build();
            AuthenticationContext authCtx = AuthenticationContext.forRepository(session2, repo);
            org.apache.maven.artifact.repository.Authentication result = new org.apache.maven.artifact.repository.Authentication(authCtx.get("username"), authCtx.get("password"));
            result.setPrivateKey(authCtx.get("privateKey.path"));
            result.setPassphrase(authCtx.get("privateKey.passphrase"));
            authCtx.close();
            return result;
        }
        return null;
    }

    public void injectAuthentication(RepositorySystemSession session2, List<ArtifactRepository> repositories) {
        if (repositories != null && session2 != null) {
            for (ArtifactRepository repository : repositories) {
                repository.setAuthentication(this.getAuthentication(session2, repository));
            }
        }
    }

    private Proxy getProxy(RepositorySystemSession session2, ArtifactRepository repository) {
        RemoteRepository repo;
        org.eclipse.aether.repository.Proxy proxy2;
        ProxySelector selector;
        if (session2 != null && (selector = session2.getProxySelector()) != null && (proxy2 = selector.getProxy(repo = RepositoryUtils.toRepo(repository))) != null) {
            Proxy p = new Proxy();
            p.setHost(proxy2.getHost());
            p.setProtocol(proxy2.getType());
            p.setPort(proxy2.getPort());
            if (proxy2.getAuthentication() != null) {
                repo = new RemoteRepository.Builder(repo).setProxy(proxy2).build();
                AuthenticationContext authCtx = AuthenticationContext.forProxy(session2, repo);
                p.setUserName(authCtx.get("username"));
                p.setPassword(authCtx.get("password"));
                p.setNtlmDomain(authCtx.get("ntlm.domain"));
                p.setNtlmHost(authCtx.get("ntlm.workstation"));
                authCtx.close();
            }
            return p;
        }
        return null;
    }

    public void injectProxy(RepositorySystemSession session2, List<ArtifactRepository> repositories) {
        if (repositories != null && session2 != null) {
            for (ArtifactRepository repository : repositories) {
                repository.setProxy(this.getProxy(session2, repository));
            }
        }
    }

    private ArtifactRepositoryLayout getLayout(String id) {
        ArtifactRepositoryLayout layout = this.layouts.get(id);
        return layout;
    }

    public static org.apache.maven.model.Repository fromSettingsRepository(Repository settingsRepository) {
        org.apache.maven.model.Repository modelRepository = new org.apache.maven.model.Repository();
        modelRepository.setId(settingsRepository.getId());
        modelRepository.setLayout(settingsRepository.getLayout());
        modelRepository.setName(settingsRepository.getName());
        modelRepository.setUrl(settingsRepository.getUrl());
        modelRepository.setReleases(MavenRepositorySystem.fromSettingsRepositoryPolicy(settingsRepository.getReleases()));
        modelRepository.setSnapshots(MavenRepositorySystem.fromSettingsRepositoryPolicy(settingsRepository.getSnapshots()));
        return modelRepository;
    }

    public static RepositoryPolicy fromSettingsRepositoryPolicy(org.apache.maven.settings.RepositoryPolicy settingsRepositoryPolicy) {
        RepositoryPolicy modelRepositoryPolicy = new RepositoryPolicy();
        if (settingsRepositoryPolicy != null) {
            modelRepositoryPolicy.setEnabled(settingsRepositoryPolicy.isEnabled());
            modelRepositoryPolicy.setUpdatePolicy(settingsRepositoryPolicy.getUpdatePolicy());
            modelRepositoryPolicy.setChecksumPolicy(settingsRepositoryPolicy.getChecksumPolicy());
        }
        return modelRepositoryPolicy;
    }

    public static ArtifactRepository buildArtifactRepository(Repository repo) throws InvalidRepositoryException {
        return MavenRepositorySystem.buildArtifactRepository(MavenRepositorySystem.fromSettingsRepository(repo));
    }

    public static ArtifactRepository buildArtifactRepository(org.apache.maven.model.Repository repo) throws InvalidRepositoryException {
        if (repo != null) {
            String id = repo.getId();
            if (StringUtils.isEmpty(id)) {
                throw new InvalidRepositoryException("Repository identifier missing", "");
            }
            String url = repo.getUrl();
            if (StringUtils.isEmpty(url)) {
                throw new InvalidRepositoryException("URL missing for repository " + id, id);
            }
            ArtifactRepositoryPolicy snapshots = MavenRepositorySystem.buildArtifactRepositoryPolicy(repo.getSnapshots());
            ArtifactRepositoryPolicy releases = MavenRepositorySystem.buildArtifactRepositoryPolicy(repo.getReleases());
            DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
            return MavenRepositorySystem.createArtifactRepository(id, url, layout, snapshots, releases);
        }
        return null;
    }

    public static ArtifactRepositoryPolicy buildArtifactRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String updatePolicy = null;
        String checksumPolicy = null;
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updatePolicy = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksumPolicy = policy.getChecksumPolicy();
            }
        }
        return new ArtifactRepositoryPolicy(enabled, updatePolicy, checksumPolicy);
    }

    public ArtifactRepository createArtifactRepository(String id, String url, String layoutId, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) throws Exception {
        ArtifactRepositoryLayout layout = this.layouts.get(layoutId);
        this.checkLayout(id, layoutId, layout);
        return MavenRepositorySystem.createArtifactRepository(id, url, layout, snapshots, releases);
    }

    private void checkLayout(String repositoryId, String layoutId, ArtifactRepositoryLayout layout) throws Exception {
        if (layout == null) {
            throw new Exception(String.format("Cannot find ArtifactRepositoryLayout instance for: %s %s", layoutId, repositoryId));
        }
    }

    public static ArtifactRepository createArtifactRepository(String id, String url, ArtifactRepositoryLayout repositoryLayout, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) {
        if (snapshots == null) {
            snapshots = new ArtifactRepositoryPolicy();
        }
        if (releases == null) {
            releases = new ArtifactRepositoryPolicy();
        }
        ArtifactRepository repository = repositoryLayout instanceof ArtifactRepositoryLayout2 ? ((ArtifactRepositoryLayout2)repositoryLayout).newMavenArtifactRepository(id, url, snapshots, releases) : new MavenArtifactRepository(id, url, repositoryLayout, snapshots, releases);
        return repository;
    }

    private Artifact createArtifactX(String groupId, String artifactId, String version, String scope, String type2) {
        return this.createArtifactX(groupId, artifactId, version, scope, type2, null, null);
    }

    private Artifact createDependencyArtifactX(String groupId, String artifactId, VersionRange versionRange, String type2, String classifier, String scope, boolean optional) {
        return this.createArtifactX(groupId, artifactId, versionRange, type2, classifier, scope, null, optional);
    }

    private Artifact createProjectArtifactX(String groupId, String artifactId, String version) {
        return this.createProjectArtifactX(groupId, artifactId, version, null);
    }

    private Artifact createParentArtifactX(String groupId, String artifactId, String version) {
        return this.createProjectArtifactX(groupId, artifactId, version);
    }

    private Artifact createPluginArtifactX(String groupId, String artifactId, VersionRange versionRange) {
        return this.createArtifactX(groupId, artifactId, versionRange, "maven-plugin", null, "runtime", null);
    }

    private Artifact createProjectArtifactX(String groupId, String artifactId, String version, String scope) {
        return this.createArtifactX(groupId, artifactId, version, scope, "pom");
    }

    private Artifact createExtensionArtifactX(String groupId, String artifactId, VersionRange versionRange) {
        return this.createArtifactX(groupId, artifactId, versionRange, "jar", null, "runtime", null);
    }

    private Artifact createArtifactX(String groupId, String artifactId, String version, String scope, String type2, String classifier, String inheritedScope) {
        VersionRange versionRange = null;
        if (version != null) {
            versionRange = VersionRange.createFromVersion(version);
        }
        return this.createArtifactX(groupId, artifactId, versionRange, type2, classifier, scope, inheritedScope);
    }

    private Artifact createArtifactX(String groupId, String artifactId, VersionRange versionRange, String type2, String classifier, String scope, String inheritedScope) {
        return this.createArtifactX(groupId, artifactId, versionRange, type2, classifier, scope, inheritedScope, false);
    }

    private Artifact createArtifactX(String groupId, String artifactId, VersionRange versionRange, String type2, String classifier, String scope, String inheritedScope, boolean optional) {
        String desiredScope = "runtime";
        if (inheritedScope == null) {
            desiredScope = scope;
        } else {
            if ("test".equals(scope) || "provided".equals(scope)) {
                return null;
            }
            if ("compile".equals(scope) && "compile".equals(inheritedScope)) {
                desiredScope = "compile";
            }
        }
        if ("test".equals(inheritedScope)) {
            desiredScope = "test";
        }
        if ("provided".equals(inheritedScope)) {
            desiredScope = "provided";
        }
        if ("system".equals(scope)) {
            desiredScope = "system";
        }
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(type2);
        return new DefaultArtifact(groupId, artifactId, versionRange, desiredScope, type2, classifier, handler, optional);
    }

    public ArtifactRepository createDefaultRemoteRepository(MavenExecutionRequest request) throws Exception {
        return this.createRepository("https://repo.maven.apache.org/maven2", "central", true, "daily", false, "daily", "warn");
    }

    public ArtifactRepository createRepository(String url, String repositoryId, boolean releases, String releaseUpdates, boolean snapshots, String snapshotUpdates, String checksumPolicy) throws Exception {
        ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(snapshots, snapshotUpdates, checksumPolicy);
        ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(releases, releaseUpdates, checksumPolicy);
        return this.createArtifactRepository(repositoryId, url, "default", snapshotsPolicy, releasesPolicy);
    }

    public Set<String> getRepoIds(List<ArtifactRepository> repositories) {
        HashSet<String> repoIds = new HashSet<String>();
        if (repositories != null) {
            for (ArtifactRepository repository : repositories) {
                repoIds.add(repository.getId());
            }
        }
        return repoIds;
    }

    public List<ArtifactRepository> getEffectiveRepositories(List<ArtifactRepository> repositories) {
        if (repositories == null) {
            return null;
        }
        LinkedHashMap<String, ArrayList<ArtifactRepository>> reposByKey = new LinkedHashMap<String, ArrayList<ArtifactRepository>>();
        for (ArtifactRepository repository : repositories) {
            String key2 = repository.getId();
            ArrayList<ArtifactRepository> aliasedRepos = (ArrayList<ArtifactRepository>)reposByKey.get(key2);
            if (aliasedRepos == null) {
                aliasedRepos = new ArrayList<ArtifactRepository>();
                reposByKey.put(key2, aliasedRepos);
            }
            aliasedRepos.add(repository);
        }
        ArrayList<ArtifactRepository> effectiveRepositories = new ArrayList<ArtifactRepository>();
        for (List aliasedRepos : reposByKey.values()) {
            ArtifactRepository aliasedRepo3;
            ArrayList<ArtifactRepository> mirroredRepos = new ArrayList<ArtifactRepository>();
            ArrayList<ArtifactRepositoryPolicy> releasePolicies = new ArrayList<ArtifactRepositoryPolicy>(aliasedRepos.size());
            for (ArtifactRepository aliasedRepo2 : aliasedRepos) {
                releasePolicies.add(aliasedRepo2.getReleases());
                mirroredRepos.addAll(aliasedRepo2.getMirroredRepositories());
            }
            ArtifactRepositoryPolicy releasePolicy = this.getEffectivePolicy(releasePolicies);
            ArrayList<ArtifactRepositoryPolicy> snapshotPolicies = new ArrayList<ArtifactRepositoryPolicy>(aliasedRepos.size());
            for (ArtifactRepository aliasedRepo3 : aliasedRepos) {
                snapshotPolicies.add(aliasedRepo3.getSnapshots());
            }
            ArtifactRepositoryPolicy snapshotPolicy = this.getEffectivePolicy(snapshotPolicies);
            aliasedRepo3 = (ArtifactRepository)aliasedRepos.get(0);
            ArtifactRepository effectiveRepository = MavenRepositorySystem.createArtifactRepository(aliasedRepo3.getId(), aliasedRepo3.getUrl(), aliasedRepo3.getLayout(), snapshotPolicy, releasePolicy);
            effectiveRepository.setAuthentication(aliasedRepo3.getAuthentication());
            effectiveRepository.setProxy(aliasedRepo3.getProxy());
            effectiveRepository.setMirroredRepositories(mirroredRepos);
            effectiveRepository.setBlocked(aliasedRepo3.isBlocked());
            effectiveRepositories.add(effectiveRepository);
        }
        return effectiveRepositories;
    }

    private ArtifactRepositoryPolicy getEffectivePolicy(Collection<ArtifactRepositoryPolicy> policies) {
        ArtifactRepositoryPolicy effectivePolicy = null;
        for (ArtifactRepositoryPolicy policy : policies) {
            if (effectivePolicy == null) {
                effectivePolicy = new ArtifactRepositoryPolicy(policy);
                continue;
            }
            effectivePolicy.merge(policy);
        }
        return effectivePolicy;
    }

    public ArtifactRepository createLocalRepository(MavenExecutionRequest request, File localRepository) throws Exception {
        return this.createRepository("file://" + localRepository.toURI().getRawPath(), "local", true, "always", true, "always", "ignore");
    }

    public static Mirror getMirror(ArtifactRepository repository, List<Mirror> mirrors) {
        String repoId = repository.getId();
        if (repoId != null && mirrors != null) {
            for (Mirror mirror : mirrors) {
                if (!repoId.equals(mirror.getMirrorOf()) || !MavenRepositorySystem.matchesLayout(repository, mirror)) continue;
                return mirror;
            }
            for (Mirror mirror : mirrors) {
                if (!MavenRepositorySystem.matchPattern(repository, mirror.getMirrorOf()) || !MavenRepositorySystem.matchesLayout(repository, mirror)) continue;
                return mirror;
            }
        }
        return null;
    }

    static boolean matchPattern(ArtifactRepository originalRepository, String pattern) {
        boolean result = false;
        String originalId = originalRepository.getId();
        if (WILDCARD.equals(pattern) || pattern.equals(originalId)) {
            result = true;
        } else {
            String[] repos;
            for (String repo : repos = pattern.split(",")) {
                if (repo.length() > 1 && repo.startsWith("!")) {
                    if (!repo.substring(1).equals(originalId)) continue;
                    result = false;
                    break;
                }
                if (repo.equals(originalId)) {
                    result = true;
                    break;
                }
                if (EXTERNAL_WILDCARD.equals(repo) && MavenRepositorySystem.isExternalRepo(originalRepository)) {
                    result = true;
                    continue;
                }
                if (EXTERNAL_HTTP_WILDCARD.equals(repo) && MavenRepositorySystem.isExternalHttpRepo(originalRepository)) {
                    result = true;
                    continue;
                }
                if (!WILDCARD.equals(repo)) continue;
                result = true;
            }
        }
        return result;
    }

    static boolean isExternalRepo(ArtifactRepository originalRepository) {
        try {
            URL url = new URL(originalRepository.getUrl());
            return !MavenRepositorySystem.isLocal(url.getHost()) && !url.getProtocol().equals("file");
        }
        catch (MalformedURLException e2) {
            return false;
        }
    }

    private static boolean isLocal(String host) {
        return "localhost".equals(host) || "127.0.0.1".equals(host);
    }

    static boolean isExternalHttpRepo(ArtifactRepository originalRepository) {
        try {
            URL url = new URL(originalRepository.getUrl());
            return ("http".equalsIgnoreCase(url.getProtocol()) || "dav".equalsIgnoreCase(url.getProtocol()) || "dav:http".equalsIgnoreCase(url.getProtocol()) || "dav+http".equalsIgnoreCase(url.getProtocol())) && !MavenRepositorySystem.isLocal(url.getHost());
        }
        catch (MalformedURLException e2) {
            return false;
        }
    }

    static boolean matchesLayout(ArtifactRepository repository, Mirror mirror) {
        return MavenRepositorySystem.matchesLayout(RepositoryUtils.getLayout(repository), mirror.getMirrorOfLayouts());
    }

    static boolean matchesLayout(String repoLayout, String mirrorLayout) {
        boolean result = false;
        if (StringUtils.isEmpty(mirrorLayout) || WILDCARD.equals(mirrorLayout)) {
            result = true;
        } else if (mirrorLayout.equals(repoLayout)) {
            result = true;
        } else {
            String[] layouts;
            for (String layout : layouts = mirrorLayout.split(",")) {
                if (layout.length() > 1 && layout.startsWith("!")) {
                    if (!layout.substring(1).equals(repoLayout)) continue;
                    result = false;
                    break;
                }
                if (layout.equals(repoLayout)) {
                    result = true;
                    break;
                }
                if (!WILDCARD.equals(layout)) continue;
                result = true;
            }
        }
        return result;
    }
}

