/* IconGroup.c generated by valac 0.56.3, the Vala compiler
 * generated from IconGroup.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <clutter/clutter.h>
#include <glib-object.h>
#include <glib.h>
#include "gala.h"
#include <meta/workspace.h>
#include <meta/prefs.h>
#include <float.h>
#include <math.h>
#include <cogl/cogl.h>
#include <meta/window.h>
#include <meta/display.h>
#include <cairo-gobject.h>
#include <meta/meta-workspace-manager.h>
#include <string.h>

#define GALA_ICON_GROUP_SIZE 64
#define GALA_ICON_GROUP_PLUS_SIZE 8
#define GALA_ICON_GROUP_PLUS_WIDTH 24
#define GALA_ICON_GROUP_CLOSE_BUTTON_SIZE 36
#define GALA_ICON_GROUP_SHOW_CLOSE_BUTTON_DELAY 200
#define GALA_WORKSPACE_CLONE_BOTTOM_OFFSET 100
#define GALA_WORKSPACE_INSERT_THUMB_EXPAND_DELAY 300
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_ICON_GROUP (gala_icon_group_get_type ())
#define GALA_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroup))
#define GALA_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))
#define GALA_IS_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP))
#define GALA_IS_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP))
#define GALA_ICON_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))

typedef struct _GalaIconGroup GalaIconGroup;
typedef struct _GalaIconGroupClass GalaIconGroupClass;
typedef struct _GalaIconGroupPrivate GalaIconGroupPrivate;
enum  {
	GALA_ICON_GROUP_0_PROPERTY,
	GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY,
	GALA_ICON_GROUP_ACTIVE_PROPERTY,
	GALA_ICON_GROUP_WORKSPACE_PROPERTY,
	GALA_ICON_GROUP_NUM_PROPERTIES
};
static GParamSpec* gala_icon_group_properties[GALA_ICON_GROUP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cogl_object_unref0(var) ((var == NULL) ? NULL : (var = (cogl_object_unref (var), NULL)))

#define GALA_TYPE_WINDOW_ICON_ACTOR (gala_window_icon_actor_get_type ())
#define GALA_WINDOW_ICON_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActor))
#define GALA_WINDOW_ICON_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActorClass))
#define GALA_IS_WINDOW_ICON_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_ICON_ACTOR))
#define GALA_IS_WINDOW_ICON_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_ICON_ACTOR))
#define GALA_WINDOW_ICON_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActorClass))

typedef struct _GalaWindowIconActor GalaWindowIconActor;
typedef struct _GalaWindowIconActorClass GalaWindowIconActorClass;
typedef struct _Block57Data Block57Data;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))

#define GALA_TYPE_ICON_GROUP_CONTAINER (gala_icon_group_container_get_type ())
#define GALA_ICON_GROUP_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainer))
#define GALA_ICON_GROUP_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainerClass))
#define GALA_IS_ICON_GROUP_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP_CONTAINER))
#define GALA_IS_ICON_GROUP_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP_CONTAINER))
#define GALA_ICON_GROUP_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainerClass))

typedef struct _GalaIconGroupContainer GalaIconGroupContainer;
typedef struct _GalaIconGroupContainerClass GalaIconGroupContainerClass;

#define GALA_TYPE_WORKSPACE_INSERT_THUMB (gala_workspace_insert_thumb_get_type ())
#define GALA_WORKSPACE_INSERT_THUMB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb))
#define GALA_WORKSPACE_INSERT_THUMB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumbClass))
#define GALA_IS_WORKSPACE_INSERT_THUMB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB))
#define GALA_IS_WORKSPACE_INSERT_THUMB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_INSERT_THUMB))
#define GALA_WORKSPACE_INSERT_THUMB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumbClass))

typedef struct _GalaWorkspaceInsertThumb GalaWorkspaceInsertThumb;
typedef struct _GalaWorkspaceInsertThumbClass GalaWorkspaceInsertThumbClass;
enum  {
	GALA_ICON_GROUP_SELECTED_SIGNAL,
	GALA_ICON_GROUP_NUM_SIGNALS
};
static guint gala_icon_group_signals[GALA_ICON_GROUP_NUM_SIGNALS] = {0};

struct _GalaIconGroup {
	ClutterActor parent_instance;
	GalaIconGroupPrivate * priv;
};

struct _GalaIconGroupClass {
	ClutterActorClass parent_class;
};

struct _GalaIconGroupPrivate {
	guint8 _backdrop_opacity;
	gboolean _active;
	GalaDragDropAction* drag_action;
	MetaWorkspace* _workspace;
	ClutterActor* prev_parent;
	ClutterActor* close_button;
	ClutterActor* icon_container;
	guint show_close_button_timeout;
};

struct _Block57Data {
	int _ref_count_;
	GalaIconGroup* self;
	GalaWindowIconActor* w;
};

static gint GalaIconGroup_private_offset;
static gpointer gala_icon_group_parent_class = NULL;

VALA_EXTERN GType gala_icon_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroup, g_object_unref)
VALA_EXTERN void gala_icon_group_redraw (GalaIconGroup* self);
static void _gala_icon_group_redraw_clutter_container_actor_removed (ClutterContainer* _sender,
                                                              ClutterActor* actor,
                                                              gpointer self);
VALA_EXTERN GalaIconGroup* gala_icon_group_new (MetaWorkspace* workspace);
VALA_EXTERN GalaIconGroup* gala_icon_group_construct (GType object_type,
                                          MetaWorkspace* workspace);
static gboolean gala_icon_group_real_enter_event (ClutterActor* base,
                                           ClutterCrossingEvent* event);
static void gala_icon_group_toggle_close_button (GalaIconGroup* self,
                                          gboolean show);
static gboolean gala_icon_group_real_leave_event (ClutterActor* base,
                                           ClutterCrossingEvent* event);
static gboolean ___lambda87_ (GalaIconGroup* self);
static void gala_icon_group_place_close_button (GalaIconGroup* self);
static gboolean ____lambda87__gsource_func (gpointer self);
static void ___lambda88_ (GalaIconGroup* self);
static void ____lambda88__clutter_timeline_completed (ClutterTimeline* _sender,
                                               gpointer self);
static gboolean gala_icon_group_resize_canvas (GalaIconGroup* self);
VALA_EXTERN gint gala_internal_utils_get_ui_scaling_factor (void);
static void gala_icon_group_real_paint (ClutterActor* base,
                                 ClutterPaintContext* context);
VALA_EXTERN guint8 gala_icon_group_get_backdrop_opacity (GalaIconGroup* self);
VALA_EXTERN void gala_icon_group_clear (GalaIconGroup* self);
VALA_EXTERN void gala_icon_group_add_window (GalaIconGroup* self,
                                 MetaWindow* window,
                                 gboolean no_redraw,
                                 gboolean temporary);
VALA_EXTERN GType gala_window_icon_actor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowIconActor, g_object_unref)
VALA_EXTERN GalaWindowIconActor* gala_window_icon_actor_new (MetaWindow* window);
VALA_EXTERN GalaWindowIconActor* gala_window_icon_actor_construct (GType object_type,
                                                       MetaWindow* window);
VALA_EXTERN void gala_window_icon_actor_set_temporary (GalaWindowIconActor* self,
                                           gboolean value);
VALA_EXTERN void gala_icon_group_remove_window (GalaIconGroup* self,
                                    MetaWindow* window,
                                    gboolean animate);
static Block57Data* block57_data_ref (Block57Data* _data57_);
static void block57_data_unref (void * _userdata_);
VALA_EXTERN MetaWindow* gala_window_icon_actor_get_window (GalaWindowIconActor* self);
static void _______lambda93_ (Block57Data* _data57_);
static void ________lambda93__clutter_timeline_completed (ClutterTimeline* _sender,
                                                   gpointer self);
VALA_EXTERN void gala_icon_group_set_hovered_actor (GalaIconGroup* self,
                                        ClutterActor* actor);
static void gala_icon_group_close (GalaIconGroup* self);
VALA_EXTERN MetaWorkspace* gala_icon_group_get_workspace (GalaIconGroup* self);
static gboolean gala_icon_group_draw (GalaIconGroup* self,
                               cairo_t* cr);
VALA_EXTERN void gala_window_icon_actor_place (GalaWindowIconActor* self,
                                   gfloat x,
                                   gfloat y,
                                   gint size);
static ClutterActor* gala_icon_group_drag_begin (GalaIconGroup* self,
                                          gfloat click_x,
                                          gfloat click_y);
VALA_EXTERN GType gala_icon_group_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroupContainer, g_object_unref)
VALA_EXTERN void gala_icon_group_container_remove_group_in_place (GalaIconGroupContainer* self,
                                                      GalaIconGroup* group);
VALA_EXTERN void gala_icon_group_container_reset_thumbs (GalaIconGroupContainer* self,
                                             gint delay);
static void gala_icon_group_drag_end (GalaIconGroup* self,
                               ClutterActor* destination);
VALA_EXTERN GType gala_workspace_insert_thumb_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceInsertThumb, g_object_unref)
VALA_EXTERN gint gala_workspace_insert_thumb_get_workspace_index (GalaWorkspaceInsertThumb* self);
static void gala_icon_group_restore_group (GalaIconGroup* self);
static void gala_icon_group_drag_canceled (GalaIconGroup* self);
VALA_EXTERN void gala_icon_group_container_add_group (GalaIconGroupContainer* self,
                                          GalaIconGroup* group);
VALA_EXTERN void gala_icon_group_set_backdrop_opacity (GalaIconGroup* self,
                                           guint8 value);
VALA_EXTERN gboolean gala_icon_group_get_active (GalaIconGroup* self);
VALA_EXTERN void gala_icon_group_set_active (GalaIconGroup* self,
                                 gboolean value);
static void gala_icon_group_set_workspace (GalaIconGroup* self,
                                    MetaWorkspace* value);
static GObject * gala_icon_group_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static gboolean _gala_icon_group_draw_clutter_canvas_draw (ClutterCanvas* _sender,
                                                    cairo_t* cr,
                                                    gint width,
                                                    gint height,
                                                    gpointer self);
static void _gala_icon_group___lambda105_ (GalaIconGroup* self);
static void __gala_icon_group___lambda105__gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                         guint32 button,
                                                                         gpointer self);
static ClutterActor* _gala_icon_group_drag_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                                            gfloat x,
                                                                            gfloat y,
                                                                            gpointer self);
static void _gala_icon_group_drag_end_gala_drag_drop_action_drag_end (GalaDragDropAction* _sender,
                                                               ClutterActor* actor,
                                                               gpointer self);
static void _gala_icon_group_drag_canceled_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                         gpointer self);
static void _gala_icon_group_redraw_g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self);
static gboolean _gala_icon_group___lambda106_ (GalaIconGroup* self);
static gboolean __gala_icon_group___lambda106__clutter_actor_button_press_event (ClutterActor* _sender,
                                                                          ClutterButtonEvent* event,
                                                                          gpointer self);
static void _gala_icon_group_close_clutter_click_action_clicked (ClutterClickAction* _sender,
                                                          ClutterActor* actor,
                                                          gpointer self);
static void gala_icon_group_finalize (GObject * obj);
static GType gala_icon_group_get_type_once (void);
static void _vala_gala_icon_group_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_gala_icon_group_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_icon_group_get_instance_private (GalaIconGroup* self)
{
	return G_STRUCT_MEMBER_P (self, GalaIconGroup_private_offset);
}

static void
_gala_icon_group_redraw_clutter_container_actor_removed (ClutterContainer* _sender,
                                                         ClutterActor* actor,
                                                         gpointer self)
{
	gala_icon_group_redraw ((GalaIconGroup*) self);
}

GalaIconGroup*
gala_icon_group_construct (GType object_type,
                           MetaWorkspace* workspace)
{
	GalaIconGroup * self = NULL;
	g_return_val_if_fail (workspace != NULL, NULL);
	self = (GalaIconGroup*) g_object_new (object_type, "workspace", workspace, NULL);
	return self;
}

GalaIconGroup*
gala_icon_group_new (MetaWorkspace* workspace)
{
	return gala_icon_group_construct (GALA_TYPE_ICON_GROUP, workspace);
}

static gboolean
gala_icon_group_real_enter_event (ClutterActor* base,
                                  ClutterCrossingEvent* event)
{
	GalaIconGroup * self;
	gboolean result;
	self = (GalaIconGroup*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	gala_icon_group_toggle_close_button (self, TRUE);
	result = FALSE;
	return result;
}

static gboolean
gala_icon_group_real_leave_event (ClutterActor* base,
                                  ClutterCrossingEvent* event)
{
	GalaIconGroup * self;
	ClutterActor* _tmp0_;
	gboolean result;
	self = (GalaIconGroup*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->related;
	if (!clutter_actor_contains ((ClutterActor*) self, _tmp0_)) {
		gala_icon_group_toggle_close_button (self, FALSE);
	}
	result = FALSE;
	return result;
}

/**
         * Requests toggling the close button. If show is true, a timeout will be set after which
         * the close button is shown, if false, the close button is hidden and the timeout is removed,
         * if it exists. The close button may not be shown even though requested if the workspace has
         * no windows or workspaces aren't set to be dynamic.
         *
         * @param show Whether to show the close button
         */
static gboolean
___lambda87_ (GalaIconGroup* self)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	gboolean result;
	gala_icon_group_place_close_button (self);
	_tmp0_ = self->priv->close_button;
	g_object_set (_tmp0_, "visible", TRUE, NULL);
	_tmp1_ = self->priv->close_button;
	clutter_actor_set_opacity (_tmp1_, (guint) 255);
	self->priv->show_close_button_timeout = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
____lambda87__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda87_ ((GalaIconGroup*) self);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda88_ (GalaIconGroup* self)
{
	ClutterActor* _tmp0_;
	_tmp0_ = self->priv->close_button;
	g_object_set (_tmp0_, "visible", FALSE, NULL);
}

static void
____lambda88__clutter_timeline_completed (ClutterTimeline* _sender,
                                          gpointer self)
{
	___lambda88_ ((GalaIconGroup*) self);
}

static void
gala_icon_group_toggle_close_button (GalaIconGroup* self,
                                     gboolean show)
{
	gboolean _tmp0_ = FALSE;
	ClutterActor* _tmp2_;
	ClutterTransition* transition = NULL;
	ClutterTransition* _tmp3_;
	ClutterTransition* _tmp4_;
	ClutterTransition* _tmp5_;
	g_return_if_fail (self != NULL);
	if (!meta_prefs_get_dynamic_workspaces ()) {
		_tmp0_ = TRUE;
	} else {
		ClutterActor* _tmp1_;
		_tmp1_ = self->priv->icon_container;
		_tmp0_ = clutter_actor_get_n_children (_tmp1_) < 1;
	}
	if (_tmp0_) {
		return;
	}
	if (self->priv->show_close_button_timeout != ((guint) 0)) {
		g_source_remove (self->priv->show_close_button_timeout);
		self->priv->show_close_button_timeout = (guint) 0;
	}
	if (show) {
		self->priv->show_close_button_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GALA_ICON_GROUP_SHOW_CLOSE_BUTTON_DELAY, ____lambda87__gsource_func, g_object_ref (self), g_object_unref);
		return;
	}
	_tmp2_ = self->priv->close_button;
	clutter_actor_set_opacity (_tmp2_, (guint) 0);
	_tmp3_ = clutter_actor_get_transition ((ClutterActor*) self, "opacity");
	_tmp4_ = _g_object_ref0 (_tmp3_);
	transition = _tmp4_;
	_tmp5_ = transition;
	if (_tmp5_ != NULL) {
		ClutterTransition* _tmp6_;
		_tmp6_ = transition;
		g_signal_connect_object ((ClutterTimeline*) _tmp6_, "completed", (GCallback) ____lambda88__clutter_timeline_completed, self, 0);
	} else {
		ClutterActor* _tmp7_;
		_tmp7_ = self->priv->close_button;
		g_object_set (_tmp7_, "visible", FALSE, NULL);
	}
	_g_object_unref0 (transition);
}

static gboolean
gala_icon_group_resize_canvas (GalaIconGroup* self)
{
	gint scale = 0;
	gint size = 0;
	ClutterContent* _tmp0_;
	ClutterContent* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	scale = gala_internal_utils_get_ui_scaling_factor ();
	size = GALA_ICON_GROUP_SIZE * scale;
	clutter_actor_set_width ((ClutterActor*) self, (gfloat) size);
	clutter_actor_set_height ((ClutterActor*) self, (gfloat) size);
	_tmp0_ = clutter_actor_get_content ((ClutterActor*) self);
	_tmp1_ = _tmp0_;
	result = clutter_canvas_set_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, clutter_canvas_get_type (), ClutterCanvas), size, size);
	return result;
}

static void
gala_icon_group_place_close_button (GalaIconGroup* self)
{
	gint size = 0;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	gfloat _tmp3_;
	gfloat _tmp4_;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	gfloat _tmp7_;
	gfloat _tmp8_;
	g_return_if_fail (self != NULL);
	size = GALA_ICON_GROUP_CLOSE_BUTTON_SIZE * gala_internal_utils_get_ui_scaling_factor ();
	_tmp0_ = self->priv->close_button;
	clutter_actor_set_size (_tmp0_, (gfloat) size, (gfloat) size);
	_tmp1_ = self->priv->close_button;
	_tmp2_ = self->priv->close_button;
	_tmp3_ = clutter_actor_get_width (_tmp2_);
	_tmp4_ = _tmp3_;
	clutter_actor_set_x (_tmp1_, -floorf (_tmp4_ * 0.4f));
	_tmp5_ = self->priv->close_button;
	_tmp6_ = self->priv->close_button;
	_tmp7_ = clutter_actor_get_height (_tmp6_);
	_tmp8_ = _tmp7_;
	clutter_actor_set_y (_tmp5_, -floorf (_tmp8_ * 0.4f));
}

/**
         * Override the paint handler to draw our backdrop if necessary
         */
static void
gala_icon_group_real_paint (ClutterActor* base,
                            ClutterPaintContext* context)
{
	GalaIconGroup * self;
	gboolean _tmp0_ = FALSE;
	guint8 _tmp1_;
	guint8 _tmp2_;
	gint scale = 0;
	gint width = 0;
	gint x = 0;
	gint y = 0;
	gint height = 0;
	CoglVertexP2T2C4 vertices[4] = {0};
	guint8 _tmp6_;
	guint8 _tmp7_;
	guint8 _tmp8_;
	guint8 _tmp9_;
	guint8 _tmp10_;
	guint8 _tmp11_;
	guint8 _tmp12_;
	guint8 _tmp13_;
	CoglVertexP2T2C4 _tmp14_ = {0};
	CoglVertexP2T2C4 _tmp15_ = {0};
	guint8 _tmp16_;
	guint8 _tmp17_;
	guint8 _tmp18_;
	guint8 _tmp19_;
	guint8 _tmp20_;
	guint8 _tmp21_;
	guint8 _tmp22_;
	guint8 _tmp23_;
	CoglVertexP2T2C4 _tmp24_ = {0};
	CoglVertexP2T2C4 _tmp25_ = {0};
	CoglPrimitive* primitive = NULL;
	CoglFramebuffer* _tmp26_;
	CoglContext* _tmp27_;
	CoglPrimitive* _tmp28_;
	CoglPipeline* pipeline = NULL;
	CoglFramebuffer* _tmp29_;
	CoglContext* _tmp30_;
	CoglPipeline* _tmp31_;
	CoglPrimitive* _tmp32_;
	CoglFramebuffer* _tmp33_;
	CoglPipeline* _tmp34_;
	self = (GalaIconGroup*) base;
	g_return_if_fail (context != NULL);
	_tmp1_ = gala_icon_group_get_backdrop_opacity (self);
	_tmp2_ = _tmp1_;
	if (((gint) _tmp2_) < 1) {
		_tmp0_ = TRUE;
	} else {
		GalaDragDropAction* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->drag_action;
		_tmp4_ = gala_drag_drop_action_get_dragging (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	}
	if (_tmp0_) {
		CLUTTER_ACTOR_CLASS (gala_icon_group_parent_class)->paint (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor), context);
		return;
	}
	scale = gala_internal_utils_get_ui_scaling_factor ();
	width = 100 * scale;
	x = ((GALA_ICON_GROUP_SIZE * scale) - width) / 2;
	y = -10;
	height = GALA_WORKSPACE_CLONE_BOTTOM_OFFSET * scale;
	_tmp6_ = gala_icon_group_get_backdrop_opacity (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = gala_icon_group_get_backdrop_opacity (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = gala_icon_group_get_backdrop_opacity (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = gala_icon_group_get_backdrop_opacity (self);
	_tmp13_ = _tmp12_;
	_tmp14_.x = (gfloat) x;
	_tmp14_.y = (gfloat) (y + height);
	_tmp14_.s = (gfloat) 0;
	_tmp14_.t = (gfloat) 1;
	_tmp14_.r = _tmp7_;
	_tmp14_.g = _tmp9_;
	_tmp14_.b = _tmp11_;
	_tmp14_.a = _tmp13_;
	vertices[0] = _tmp14_;
	_tmp15_.x = (gfloat) x;
	_tmp15_.y = (gfloat) y;
	_tmp15_.s = (gfloat) 0;
	_tmp15_.t = (gfloat) 0;
	_tmp15_.r = (guint8) 0;
	_tmp15_.g = (guint8) 0;
	_tmp15_.b = (guint8) 0;
	_tmp15_.a = (guint8) 0;
	vertices[1] = _tmp15_;
	_tmp16_ = gala_icon_group_get_backdrop_opacity (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = gala_icon_group_get_backdrop_opacity (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = gala_icon_group_get_backdrop_opacity (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = gala_icon_group_get_backdrop_opacity (self);
	_tmp23_ = _tmp22_;
	_tmp24_.x = (gfloat) (x + width);
	_tmp24_.y = (gfloat) (y + height);
	_tmp24_.s = (gfloat) 1;
	_tmp24_.t = (gfloat) 1;
	_tmp24_.r = _tmp17_;
	_tmp24_.g = _tmp19_;
	_tmp24_.b = _tmp21_;
	_tmp24_.a = _tmp23_;
	vertices[2] = _tmp24_;
	_tmp25_.x = (gfloat) (x + width);
	_tmp25_.y = (gfloat) y;
	_tmp25_.s = (gfloat) 1;
	_tmp25_.t = (gfloat) 0;
	_tmp25_.r = (guint8) 0;
	_tmp25_.g = (guint8) 0;
	_tmp25_.b = (guint8) 0;
	_tmp25_.a = (guint8) 0;
	vertices[3] = _tmp25_;
	_tmp26_ = clutter_paint_context_get_framebuffer (context);
	_tmp27_ = cogl_framebuffer_get_context (_tmp26_);
	_tmp28_ = cogl_primitive_new_p2t2c4 (_tmp27_, COGL_VERTICES_MODE_TRIANGLE_STRIP, 4, vertices);
	primitive = _tmp28_;
	_tmp29_ = clutter_paint_context_get_framebuffer (context);
	_tmp30_ = cogl_framebuffer_get_context (_tmp29_);
	_tmp31_ = cogl_pipeline_new (_tmp30_);
	pipeline = _tmp31_;
	_tmp32_ = primitive;
	_tmp33_ = clutter_paint_context_get_framebuffer (context);
	_tmp34_ = pipeline;
	cogl_primitive_draw (_tmp32_, _tmp33_, _tmp34_);
	CLUTTER_ACTOR_CLASS (gala_icon_group_parent_class)->paint (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor), context);
	_cogl_object_unref0 (pipeline);
	_cogl_object_unref0 (primitive);
}

/**
         * Remove all currently added WindowIconActors
         */
void
gala_icon_group_clear (GalaIconGroup* self)
{
	ClutterActor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->icon_container;
	clutter_actor_destroy_all_children (_tmp0_);
}

/**
         * Creates a WindowIconActor for the given window and adds it to the group
         *
         * @param window    The MetaWindow for which to create the WindowIconActor
         * @param no_redraw If you add multiple windows at once you may want to consider
         *                  settings this to true and when done calling redraw() manually
         * @param temporary Mark the WindowIconActor as temporary. Used for windows dragged over
         *                  the group.
         */
void
gala_icon_group_add_window (GalaIconGroup* self,
                            MetaWindow* window,
                            gboolean no_redraw,
                            gboolean temporary)
{
	GalaWindowIconActor* new_window = NULL;
	GalaWindowIconActor* _tmp0_;
	GalaWindowIconActor* _tmp1_;
	GalaWindowIconActor* _tmp2_;
	GalaWindowIconActor* _tmp3_;
	GalaWindowIconActor* _tmp4_;
	GalaWindowIconActor* _tmp5_;
	ClutterActor* _tmp6_;
	GalaWindowIconActor* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = gala_window_icon_actor_new (window);
	g_object_ref_sink (_tmp0_);
	new_window = _tmp0_;
	_tmp1_ = new_window;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp1_);
	_tmp2_ = new_window;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp2_, (guint) 0);
	_tmp3_ = new_window;
	clutter_actor_set_position ((ClutterActor*) _tmp3_, (gfloat) 32, (gfloat) 32);
	_tmp4_ = new_window;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp4_);
	_tmp5_ = new_window;
	gala_window_icon_actor_set_temporary (_tmp5_, temporary);
	_tmp6_ = self->priv->icon_container;
	_tmp7_ = new_window;
	clutter_actor_add_child (_tmp6_, (ClutterActor*) _tmp7_);
	if (!no_redraw) {
		gala_icon_group_redraw (self);
	}
	_g_object_unref0 (new_window);
}

/**
         * Remove the WindowIconActor for a MetaWindow from the group
         *
         * @param animate Whether to fade the icon out before removing it
         */
static Block57Data*
block57_data_ref (Block57Data* _data57_)
{
	g_atomic_int_inc (&_data57_->_ref_count_);
	return _data57_;
}

static void
block57_data_unref (void * _userdata_)
{
	Block57Data* _data57_;
	_data57_ = (Block57Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data57_->_ref_count_)) {
		GalaIconGroup* self;
		self = _data57_->self;
		_g_object_unref0 (self);
		g_slice_free (Block57Data, _data57_);
	}
}

static void
_______lambda93_ (Block57Data* _data57_)
{
	GalaIconGroup* self;
	GalaWindowIconActor* _tmp0_;
	self = _data57_->self;
	_tmp0_ = _data57_->w;
	clutter_actor_destroy ((ClutterActor*) _tmp0_);
}

static void
________lambda93__clutter_timeline_completed (ClutterTimeline* _sender,
                                              gpointer self)
{
	_______lambda93_ (self);
}

void
gala_icon_group_remove_window (GalaIconGroup* self,
                               MetaWindow* window,
                               gboolean animate)
{
	ClutterActor* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->icon_container;
	_tmp1_ = clutter_actor_get_children (_tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				Block57Data* _data57_;
				ClutterActor* _tmp2_;
				GalaWindowIconActor* _tmp3_;
				MetaWindow* _tmp4_;
				MetaWindow* _tmp5_;
				_data57_ = g_slice_new0 (Block57Data);
				_data57_->_ref_count_ = 1;
				_data57_->self = g_object_ref (self);
				_tmp2_ = child;
				_data57_->w = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActor);
				_tmp3_ = _data57_->w;
				_tmp4_ = gala_window_icon_actor_get_window (_tmp3_);
				_tmp5_ = _tmp4_;
				if (_tmp5_ == window) {
					if (animate) {
						GalaWindowIconActor* _tmp6_;
						GalaWindowIconActor* _tmp7_;
						GalaWindowIconActor* _tmp8_;
						ClutterTransition* transition = NULL;
						GalaWindowIconActor* _tmp9_;
						ClutterTransition* _tmp10_;
						ClutterTransition* _tmp11_;
						ClutterTransition* _tmp12_;
						_tmp6_ = _data57_->w;
						clutter_actor_set_easing_mode ((ClutterActor*) _tmp6_, CLUTTER_LINEAR);
						_tmp7_ = _data57_->w;
						clutter_actor_set_easing_duration ((ClutterActor*) _tmp7_, (guint) 200);
						_tmp8_ = _data57_->w;
						clutter_actor_set_opacity ((ClutterActor*) _tmp8_, (guint) 0);
						_tmp9_ = _data57_->w;
						_tmp10_ = clutter_actor_get_transition ((ClutterActor*) _tmp9_, "opacity");
						_tmp11_ = _g_object_ref0 (_tmp10_);
						transition = _tmp11_;
						_tmp12_ = transition;
						if (_tmp12_ != NULL) {
							ClutterTransition* _tmp13_;
							_tmp13_ = transition;
							g_signal_connect_data ((ClutterTimeline*) _tmp13_, "completed", (GCallback) ________lambda93__clutter_timeline_completed, block57_data_ref (_data57_), (GClosureNotify) block57_data_unref, 0);
						} else {
							GalaWindowIconActor* _tmp14_;
							_tmp14_ = _data57_->w;
							clutter_actor_destroy ((ClutterActor*) _tmp14_);
						}
						_g_object_unref0 (transition);
					} else {
						GalaWindowIconActor* _tmp15_;
						_tmp15_ = _data57_->w;
						clutter_actor_destroy ((ClutterActor*) _tmp15_);
					}
				}
				block57_data_unref (_data57_);
				_data57_ = NULL;
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

/**
         * Sets a hovered actor for the drag action.
         */
void
gala_icon_group_set_hovered_actor (GalaIconGroup* self,
                                   ClutterActor* actor)
{
	GalaDragDropAction* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	_tmp0_ = self->priv->drag_action;
	gala_drag_drop_action_set_hovered (_tmp0_, actor);
}

/**
         * Trigger a redraw
         */
void
gala_icon_group_redraw (GalaIconGroup* self)
{
	g_return_if_fail (self != NULL);
	if (!gala_icon_group_resize_canvas (self)) {
		ClutterContent* _tmp0_;
		ClutterContent* _tmp1_;
		_tmp0_ = clutter_actor_get_content ((ClutterActor*) self);
		_tmp1_ = _tmp0_;
		clutter_content_invalidate (_tmp1_);
	}
}

/**
         * Close handler. We close the workspace by deleting all the windows on it.
         * That way the workspace won't be deleted if windows decide to ignore the
         * delete signal
         */
static void
gala_icon_group_close (GalaIconGroup* self)
{
	guint32 time = 0U;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspace* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = meta_workspace_get_display (_tmp0_);
	time = meta_display_get_current_time (_tmp1_);
	_tmp2_ = self->priv->_workspace;
	_tmp3_ = meta_workspace_list_windows (_tmp2_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp3_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindowType type = 0;
				MetaWindow* _tmp4_;
				MetaWindowType _tmp5_;
				MetaWindowType _tmp6_;
				gboolean _tmp7_ = FALSE;
				MetaWindow* _tmp8_;
				_tmp4_ = window;
				_tmp5_ = meta_window_get_window_type (_tmp4_);
				_tmp6_ = _tmp5_;
				type = _tmp6_;
				_tmp8_ = window;
				if (!meta_window_is_on_all_workspaces (_tmp8_)) {
					gboolean _tmp9_ = FALSE;
					gboolean _tmp10_ = FALSE;
					if (type == META_WINDOW_NORMAL) {
						_tmp10_ = TRUE;
					} else {
						_tmp10_ = type == META_WINDOW_DIALOG;
					}
					if (_tmp10_) {
						_tmp9_ = TRUE;
					} else {
						_tmp9_ = type == META_WINDOW_MODAL_DIALOG;
					}
					_tmp7_ = _tmp9_;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					MetaWindow* _tmp11_;
					_tmp11_ = window;
					meta_window_delete (_tmp11_, time);
				}
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
}

/**
         * Draw the background or plus sign and do layouting. We won't lose performance here
         * by relayouting in the same function, as it's only ever called when we invalidate it.
         */
static gboolean
gala_icon_group_draw (GalaIconGroup* self,
                      cairo_t* cr)
{
	gint scale = 0;
	gint n_windows = 0;
	ClutterActor* _tmp0_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	gfloat _tmp7_;
	gfloat _tmp8_;
	GalaDragDropAction* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	cairo_pattern_t* grad = NULL;
	gfloat _tmp12_;
	gfloat _tmp13_;
	cairo_pattern_t* _tmp14_;
	cairo_pattern_t* _tmp15_;
	cairo_pattern_t* _tmp16_;
	cairo_pattern_t* _tmp17_;
	gfloat _tmp18_;
	gfloat _tmp19_;
	gfloat _tmp20_;
	gfloat _tmp21_;
	MetaWorkspaceManager* manager = NULL;
	MetaWorkspace* _tmp22_;
	MetaDisplay* _tmp23_;
	MetaWorkspaceManager* _tmp24_;
	gint workspace_index = 0;
	gint size = 0;
	guint n_tiled_windows = 0U;
	gint columns = 0;
	gint rows = 0;
	gint spacing = 0;
	gint width = 0;
	gint height = 0;
	gint x_offset = 0;
	gint y_offset = 0;
	gboolean show_ellipsis = FALSE;
	gint n_shown_windows = 0;
	gint x = 0;
	gint y = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	scale = gala_internal_utils_get_ui_scaling_factor ();
	cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
	cairo_paint (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	_tmp0_ = self->priv->icon_container;
	n_windows = clutter_actor_get_n_children (_tmp0_);
	if (n_windows == 1) {
		GalaWindowIconActor* icon = NULL;
		ClutterActor* _tmp1_;
		ClutterActor* _tmp2_;
		GalaWindowIconActor* _tmp3_;
		GalaWindowIconActor* _tmp4_;
		_tmp1_ = self->priv->icon_container;
		_tmp2_ = clutter_actor_get_child_at_index (_tmp1_, 0);
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActor));
		icon = _tmp3_;
		_tmp4_ = icon;
		gala_window_icon_actor_place (_tmp4_, (gfloat) 0, (gfloat) 0, 64);
		result = FALSE;
		_g_object_unref0 (icon);
		return result;
	}
	_tmp5_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp8_ = _tmp7_;
	gala_drawing_utilities_cairo_rounded_rectangle (cr, 0.5 * scale, 0.5 * scale, (gdouble) (((gint) _tmp6_) - (1 * scale)), (gdouble) (((gint) _tmp8_) - (1 * scale)), (gdouble) (5 * scale));
	_tmp9_ = self->priv->drag_action;
	_tmp10_ = gala_drag_drop_action_get_dragging (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		static const gdouble BG_COLOR = 53.0 / 255.0;
		cairo_set_source_rgba (cr, BG_COLOR, BG_COLOR, BG_COLOR, 0.7);
	} else {
		cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.1);
	}
	cairo_fill_preserve (cr);
	cairo_set_line_width (cr, (gdouble) (1 * scale));
	_tmp12_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) _tmp13_);
	grad = _tmp14_;
	_tmp15_ = grad;
	cairo_pattern_add_color_stop_rgba (_tmp15_, 0.8, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp16_ = grad;
	cairo_pattern_add_color_stop_rgba (_tmp16_, 1.0, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.1);
	_tmp17_ = grad;
	cairo_set_source (cr, _tmp17_);
	cairo_stroke (cr);
	_tmp18_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp19_ = _tmp18_;
	_tmp20_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp21_ = _tmp20_;
	gala_drawing_utilities_cairo_rounded_rectangle (cr, 1.5 * scale, 1.5 * scale, (gdouble) (((gint) _tmp19_) - (3 * scale)), (gdouble) (((gint) _tmp21_) - (3 * scale)), (gdouble) (5 * scale));
	cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.3);
	cairo_stroke (cr);
	_tmp22_ = self->priv->_workspace;
	_tmp23_ = meta_workspace_get_display (_tmp22_);
	_tmp24_ = meta_display_get_workspace_manager (_tmp23_);
	manager = _tmp24_;
	workspace_index = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp25_ = FALSE;
			_tmp25_ = TRUE;
			while (TRUE) {
				MetaWorkspaceManager* _tmp27_;
				MetaWorkspaceManager* _tmp28_;
				MetaWorkspace* _tmp29_;
				MetaWorkspace* _tmp30_;
				if (!_tmp25_) {
					gint _tmp26_;
					_tmp26_ = i;
					i = _tmp26_ + 1;
				}
				_tmp25_ = FALSE;
				_tmp27_ = manager;
				if (!(i < meta_workspace_manager_get_n_workspaces (_tmp27_))) {
					break;
				}
				_tmp28_ = manager;
				_tmp29_ = meta_workspace_manager_get_workspace_by_index (_tmp28_, i);
				_tmp30_ = self->priv->_workspace;
				if (_tmp29_ == _tmp30_) {
					workspace_index = i;
					break;
				}
			}
		}
	}
	if (n_windows < 1) {
		gboolean _tmp31_ = FALSE;
		GalaDrawingBufferSurface* buffer = NULL;
		GalaDrawingBufferSurface* _tmp33_;
		gint offset = 0;
		GalaDrawingBufferSurface* _tmp34_;
		cairo_t* _tmp35_;
		cairo_t* _tmp36_;
		GalaDrawingBufferSurface* _tmp37_;
		cairo_t* _tmp38_;
		cairo_t* _tmp39_;
		GalaDrawingBufferSurface* _tmp40_;
		cairo_t* _tmp41_;
		cairo_t* _tmp42_;
		GalaDrawingBufferSurface* _tmp43_;
		cairo_t* _tmp44_;
		cairo_t* _tmp45_;
		GalaDrawingBufferSurface* _tmp46_;
		GalaDrawingBufferSurface* _tmp47_;
		cairo_t* _tmp48_;
		cairo_t* _tmp49_;
		GalaDrawingBufferSurface* _tmp50_;
		cairo_t* _tmp51_;
		cairo_t* _tmp52_;
		GalaDrawingBufferSurface* _tmp53_;
		cairo_t* _tmp54_;
		cairo_t* _tmp55_;
		GalaDrawingBufferSurface* _tmp56_;
		cairo_t* _tmp57_;
		cairo_t* _tmp58_;
		GalaDrawingBufferSurface* _tmp59_;
		cairo_t* _tmp60_;
		cairo_t* _tmp61_;
		GalaDrawingBufferSurface* _tmp62_;
		cairo_surface_t* _tmp63_;
		cairo_surface_t* _tmp64_;
		if (!meta_prefs_get_dynamic_workspaces ()) {
			_tmp31_ = TRUE;
		} else {
			MetaWorkspaceManager* _tmp32_;
			_tmp32_ = manager;
			_tmp31_ = workspace_index != (meta_workspace_manager_get_n_workspaces (_tmp32_) - 1);
		}
		if (_tmp31_) {
			result = FALSE;
			_cairo_pattern_destroy0 (grad);
			return result;
		}
		_tmp33_ = gala_drawing_buffer_surface_new (GALA_ICON_GROUP_SIZE * scale, GALA_ICON_GROUP_SIZE * scale);
		buffer = _tmp33_;
		offset = ((GALA_ICON_GROUP_SIZE * scale) / 2) - ((GALA_ICON_GROUP_PLUS_WIDTH * scale) / 2);
		_tmp34_ = buffer;
		_tmp35_ = gala_drawing_buffer_surface_get_context (_tmp34_);
		_tmp36_ = _tmp35_;
		cairo_rectangle (_tmp36_, ((((GALA_ICON_GROUP_PLUS_WIDTH / 2) * scale) - ((GALA_ICON_GROUP_PLUS_SIZE / 2) * scale)) + 0.5) + offset, 0.5 + offset, (gdouble) ((GALA_ICON_GROUP_PLUS_SIZE * scale) - 1), (gdouble) ((GALA_ICON_GROUP_PLUS_WIDTH * scale) - 1));
		_tmp37_ = buffer;
		_tmp38_ = gala_drawing_buffer_surface_get_context (_tmp37_);
		_tmp39_ = _tmp38_;
		cairo_rectangle (_tmp39_, 0.5 + offset, ((((GALA_ICON_GROUP_PLUS_WIDTH / 2) * scale) - ((GALA_ICON_GROUP_PLUS_SIZE / 2) * scale)) + 0.5) + offset, (gdouble) ((GALA_ICON_GROUP_PLUS_WIDTH * scale) - 1), (gdouble) ((GALA_ICON_GROUP_PLUS_SIZE * scale) - 1));
		_tmp40_ = buffer;
		_tmp41_ = gala_drawing_buffer_surface_get_context (_tmp40_);
		_tmp42_ = _tmp41_;
		cairo_set_source_rgb (_tmp42_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
		_tmp43_ = buffer;
		_tmp44_ = gala_drawing_buffer_surface_get_context (_tmp43_);
		_tmp45_ = _tmp44_;
		cairo_fill_preserve (_tmp45_);
		_tmp46_ = buffer;
		gala_drawing_buffer_surface_exponential_blur (_tmp46_, 5);
		_tmp47_ = buffer;
		_tmp48_ = gala_drawing_buffer_surface_get_context (_tmp47_);
		_tmp49_ = _tmp48_;
		cairo_set_source_rgb (_tmp49_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp50_ = buffer;
		_tmp51_ = gala_drawing_buffer_surface_get_context (_tmp50_);
		_tmp52_ = _tmp51_;
		cairo_set_line_width (_tmp52_, (gdouble) 1);
		_tmp53_ = buffer;
		_tmp54_ = gala_drawing_buffer_surface_get_context (_tmp53_);
		_tmp55_ = _tmp54_;
		cairo_stroke_preserve (_tmp55_);
		_tmp56_ = buffer;
		_tmp57_ = gala_drawing_buffer_surface_get_context (_tmp56_);
		_tmp58_ = _tmp57_;
		cairo_set_source_rgb (_tmp58_, 0.8, 0.8, 0.8);
		_tmp59_ = buffer;
		_tmp60_ = gala_drawing_buffer_surface_get_context (_tmp59_);
		_tmp61_ = _tmp60_;
		cairo_fill (_tmp61_);
		_tmp62_ = buffer;
		_tmp63_ = gala_drawing_buffer_surface_get_surface (_tmp62_);
		_tmp64_ = _tmp63_;
		cairo_set_source_surface (cr, _tmp64_, (gdouble) 0, (gdouble) 0);
		cairo_paint (cr);
		result = FALSE;
		_g_object_unref0 (buffer);
		_cairo_pattern_destroy0 (grad);
		return result;
	}
	if (n_windows < 5) {
		size = 24;
	} else {
		size = 16;
	}
	n_tiled_windows = MIN ((guint) n_windows, (guint) 9);
	columns = (gint) ceil (sqrt ((gdouble) n_tiled_windows));
	rows = (gint) ceil (n_tiled_windows / ((gdouble) columns));
	spacing = 6 * scale;
	width = (columns * (size * scale)) + ((columns - 1) * spacing);
	height = (rows * (size * scale)) + ((rows - 1) * spacing);
	x_offset = ((GALA_ICON_GROUP_SIZE * scale) / 2) - (width / 2);
	y_offset = ((GALA_ICON_GROUP_SIZE * scale) / 2) - (height / 2);
	show_ellipsis = FALSE;
	n_shown_windows = n_windows;
	if (n_shown_windows > 9) {
		n_shown_windows = 8;
		show_ellipsis = TRUE;
	}
	x = x_offset;
	y = y_offset;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp65_ = FALSE;
			_tmp65_ = TRUE;
			while (TRUE) {
				GalaWindowIconActor* window = NULL;
				ClutterActor* _tmp67_;
				ClutterActor* _tmp68_;
				GalaWindowIconActor* _tmp69_;
				gboolean _tmp70_ = FALSE;
				GalaWindowIconActor* _tmp72_;
				if (!_tmp65_) {
					gint _tmp66_;
					_tmp66_ = i;
					i = _tmp66_ + 1;
				}
				_tmp65_ = FALSE;
				if (!(i < n_windows)) {
					break;
				}
				_tmp67_ = self->priv->icon_container;
				_tmp68_ = clutter_actor_get_child_at_index (_tmp67_, i);
				_tmp69_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActor));
				window = _tmp69_;
				if (show_ellipsis) {
					_tmp70_ = i == 8;
				} else {
					_tmp70_ = FALSE;
				}
				if (_tmp70_) {
					gint top_offset = 0;
					gint left_offset = 0;
					gint radius = 0;
					gint dot_spacing = 0;
					top_offset = 10 * scale;
					left_offset = 2 * scale;
					radius = 2 * scale;
					dot_spacing = 3 * scale;
					cairo_arc (cr, (gdouble) (left_offset + x), (gdouble) (y + top_offset), (gdouble) radius, (gdouble) 0, 2 * G_PI);
					cairo_arc (cr, (gdouble) (((left_offset + x) + radius) + dot_spacing), (gdouble) (y + top_offset), (gdouble) radius, (gdouble) 0, 2 * G_PI);
					cairo_arc (cr, (gdouble) (((left_offset + x) + (radius * 2)) + (dot_spacing * 2)), (gdouble) (y + top_offset), (gdouble) radius, (gdouble) 0, 2 * G_PI);
					cairo_set_source_rgb (cr, 0.3, 0.3, 0.3);
					cairo_fill (cr);
				}
				if (i >= n_shown_windows) {
					GalaWindowIconActor* _tmp71_;
					_tmp71_ = window;
					g_object_set ((ClutterActor*) _tmp71_, "visible", FALSE, NULL);
					_g_object_unref0 (window);
					continue;
				}
				_tmp72_ = window;
				gala_window_icon_actor_place (_tmp72_, (gfloat) x, (gfloat) y, size);
				x += (size * scale) + spacing;
				if ((x + (size * scale)) >= (GALA_ICON_GROUP_SIZE * scale)) {
					x = x_offset;
					y += (size * scale) + spacing;
				}
				_g_object_unref0 (window);
			}
		}
	}
	result = FALSE;
	_cairo_pattern_destroy0 (grad);
	return result;
}

static ClutterActor*
gala_icon_group_drag_begin (GalaIconGroup* self,
                            gfloat click_x,
                            gfloat click_y)
{
	MetaWorkspaceManager* manager = NULL;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	ClutterActor* _tmp5_;
	gfloat abs_x = 0.0F;
	gfloat abs_y = 0.0F;
	gfloat prev_parent_x = 0.0F;
	gfloat prev_parent_y = 0.0F;
	ClutterActor* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterActor* _tmp10_;
	gfloat _tmp11_ = 0.0F;
	gfloat _tmp12_ = 0.0F;
	ClutterStage* stage = NULL;
	ClutterStage* _tmp13_;
	ClutterStage* _tmp14_;
	GalaIconGroupContainer* container = NULL;
	ClutterActor* _tmp15_;
	GalaIconGroupContainer* _tmp16_;
	GalaIconGroupContainer* _tmp17_;
	ClutterStage* _tmp21_;
	gfloat _tmp22_ = 0.0F;
	gfloat _tmp23_ = 0.0F;
	ClutterActor* _tmp24_;
	ClutterActor* _tmp25_;
	ClutterActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = meta_workspace_get_display (_tmp0_);
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	manager = _tmp2_;
	_tmp5_ = self->priv->icon_container;
	if (clutter_actor_get_n_children (_tmp5_) < 1) {
		_tmp4_ = meta_prefs_get_dynamic_workspaces ();
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		MetaWorkspace* _tmp6_;
		MetaWorkspaceManager* _tmp7_;
		_tmp6_ = self->priv->_workspace;
		_tmp7_ = manager;
		_tmp3_ = meta_workspace_index (_tmp6_) == (meta_workspace_manager_get_n_workspaces (_tmp7_) - 1);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = NULL;
		return result;
	}
	_tmp8_ = clutter_actor_get_parent ((ClutterActor*) self);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->prev_parent);
	self->priv->prev_parent = _tmp9_;
	_tmp10_ = self->priv->prev_parent;
	clutter_actor_get_transformed_position (_tmp10_, &_tmp11_, &_tmp12_);
	prev_parent_x = _tmp11_;
	prev_parent_y = _tmp12_;
	_tmp13_ = clutter_actor_get_stage ((ClutterActor*) self);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	stage = _tmp14_;
	_tmp15_ = self->priv->prev_parent;
	_tmp16_ = _g_object_ref0 (GALA_IS_ICON_GROUP_CONTAINER (_tmp15_) ? ((GalaIconGroupContainer*) _tmp15_) : NULL);
	container = _tmp16_;
	_tmp17_ = container;
	if (_tmp17_ != NULL) {
		GalaIconGroupContainer* _tmp18_;
		GalaIconGroupContainer* _tmp19_;
		_tmp18_ = container;
		gala_icon_group_container_remove_group_in_place (_tmp18_, self);
		_tmp19_ = container;
		gala_icon_group_container_reset_thumbs (_tmp19_, 0);
	} else {
		ClutterActor* _tmp20_;
		_tmp20_ = self->priv->prev_parent;
		clutter_actor_remove_child (_tmp20_, (ClutterActor*) self);
	}
	_tmp21_ = stage;
	clutter_actor_add_child ((ClutterActor*) _tmp21_, (ClutterActor*) self);
	clutter_actor_get_transformed_position ((ClutterActor*) self, &_tmp22_, &_tmp23_);
	abs_x = _tmp22_;
	abs_y = _tmp23_;
	clutter_actor_set_position ((ClutterActor*) self, abs_x + prev_parent_x, abs_y + prev_parent_y);
	_tmp24_ = self->priv->close_button;
	clutter_actor_set_opacity (_tmp24_, (guint) 0);
	_tmp25_ = _g_object_ref0 ((ClutterActor*) self);
	result = _tmp25_;
	_g_object_unref0 (container);
	_g_object_unref0 (stage);
	return result;
}

static void
gala_icon_group_drag_end (GalaIconGroup* self,
                          ClutterActor* destination)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	if (GALA_IS_WORKSPACE_INSERT_THUMB (destination)) {
		ClutterActor* _tmp0_;
		GalaWorkspaceInsertThumb* inserter = NULL;
		MetaWorkspaceManager* manager = NULL;
		MetaWorkspace* _tmp1_;
		MetaDisplay* _tmp2_;
		MetaWorkspaceManager* _tmp3_;
		MetaWorkspaceManager* _tmp4_;
		MetaWorkspace* _tmp5_;
		GalaWorkspaceInsertThumb* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp0_ = clutter_actor_get_parent ((ClutterActor*) self);
		clutter_actor_remove_child (_tmp0_, (ClutterActor*) self);
		inserter = G_TYPE_CHECK_INSTANCE_CAST (destination, GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb);
		_tmp1_ = self->priv->_workspace;
		_tmp2_ = meta_workspace_get_display (_tmp1_);
		_tmp3_ = meta_display_get_workspace_manager (_tmp2_);
		manager = _tmp3_;
		_tmp4_ = manager;
		_tmp5_ = self->priv->_workspace;
		_tmp6_ = inserter;
		_tmp7_ = gala_workspace_insert_thumb_get_workspace_index (_tmp6_);
		_tmp8_ = _tmp7_;
		meta_workspace_manager_reorder_workspace (_tmp4_, _tmp5_, _tmp8_);
		gala_icon_group_restore_group (self);
	} else {
		gala_icon_group_drag_canceled (self);
	}
}

static void
gala_icon_group_drag_canceled (GalaIconGroup* self)
{
	ClutterActor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_parent ((ClutterActor*) self);
	clutter_actor_remove_child (_tmp0_, (ClutterActor*) self);
	gala_icon_group_restore_group (self);
}

static void
gala_icon_group_restore_group (GalaIconGroup* self)
{
	GalaIconGroupContainer* container = NULL;
	ClutterActor* _tmp0_;
	GalaIconGroupContainer* _tmp1_;
	GalaIconGroupContainer* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->prev_parent;
	_tmp1_ = _g_object_ref0 (GALA_IS_ICON_GROUP_CONTAINER (_tmp0_) ? ((GalaIconGroupContainer*) _tmp0_) : NULL);
	container = _tmp1_;
	_tmp2_ = container;
	if (_tmp2_ != NULL) {
		GalaIconGroupContainer* _tmp3_;
		GalaIconGroupContainer* _tmp4_;
		GalaIconGroupContainer* _tmp5_;
		_tmp3_ = container;
		gala_icon_group_container_add_group (_tmp3_, self);
		_tmp4_ = container;
		g_signal_emit_by_name (_tmp4_, "request-reposition", FALSE);
		_tmp5_ = container;
		gala_icon_group_container_reset_thumbs (_tmp5_, GALA_WORKSPACE_INSERT_THUMB_EXPAND_DELAY);
	}
	_g_object_unref0 (container);
}

guint8
gala_icon_group_get_backdrop_opacity (GalaIconGroup* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_backdrop_opacity;
	return result;
}

void
gala_icon_group_set_backdrop_opacity (GalaIconGroup* self,
                                      guint8 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_backdrop_opacity = value;
	clutter_actor_queue_redraw ((ClutterActor*) self);
	g_object_notify_by_pspec ((GObject *) self, gala_icon_group_properties[GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY]);
}

gboolean
gala_icon_group_get_active (GalaIconGroup* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}

void
gala_icon_group_set_active (GalaIconGroup* self,
                            gboolean value)
{
	ClutterTransition* _tmp0_;
	ClutterPropertyTransition* transition = NULL;
	ClutterPropertyTransition* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	ClutterPropertyTransition* _tmp3_;
	GValue _tmp4_ = {0};
	gint _tmp5_ = 0;
	ClutterPropertyTransition* _tmp6_;
	GValue _tmp7_ = {0};
	ClutterPropertyTransition* _tmp8_;
	g_return_if_fail (self != NULL);
	if (self->priv->_active == value) {
		return;
	}
	_tmp0_ = clutter_actor_get_transition ((ClutterActor*) self, "backdrop-opacity");
	if (_tmp0_ != NULL) {
		clutter_actor_remove_transition ((ClutterActor*) self, "backdrop-opacity");
	}
	self->priv->_active = value;
	_tmp1_ = (ClutterPropertyTransition*) clutter_property_transition_new ("backdrop-opacity");
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp1_, (guint) 300);
	clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp1_, TRUE);
	transition = _tmp1_;
	if (self->priv->_active) {
		_tmp2_ = 0;
	} else {
		_tmp2_ = 40;
	}
	_tmp3_ = transition;
	g_value_init (&_tmp4_, G_TYPE_INT);
	g_value_set_int (&_tmp4_, _tmp2_);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp3_, &_tmp4_);
	G_IS_VALUE (&_tmp4_) ? (g_value_unset (&_tmp4_), NULL) : NULL;
	if (self->priv->_active) {
		_tmp5_ = 40;
	} else {
		_tmp5_ = 0;
	}
	_tmp6_ = transition;
	g_value_init (&_tmp7_, G_TYPE_INT);
	g_value_set_int (&_tmp7_, _tmp5_);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp6_, &_tmp7_);
	G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
	_tmp8_ = transition;
	clutter_actor_add_transition ((ClutterActor*) self, "backdrop-opacity", (ClutterTransition*) _tmp8_);
	_g_object_unref0 (transition);
	g_object_notify_by_pspec ((GObject *) self, gala_icon_group_properties[GALA_ICON_GROUP_ACTIVE_PROPERTY]);
}

MetaWorkspace*
gala_icon_group_get_workspace (GalaIconGroup* self)
{
	MetaWorkspace* result;
	MetaWorkspace* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_workspace;
	result = _tmp0_;
	return result;
}

static void
gala_icon_group_set_workspace (GalaIconGroup* self,
                               MetaWorkspace* value)
{
	MetaWorkspace* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_icon_group_get_workspace (self);
	if (old_value != value) {
		MetaWorkspace* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_workspace);
		self->priv->_workspace = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_icon_group_properties[GALA_ICON_GROUP_WORKSPACE_PROPERTY]);
	}
}

static gboolean
_gala_icon_group_draw_clutter_canvas_draw (ClutterCanvas* _sender,
                                           cairo_t* cr,
                                           gint width,
                                           gint height,
                                           gpointer self)
{
	gboolean result;
	result = gala_icon_group_draw ((GalaIconGroup*) self, cr);
	return result;
}

static void
_gala_icon_group___lambda105_ (GalaIconGroup* self)
{
	g_signal_emit (self, gala_icon_group_signals[GALA_ICON_GROUP_SELECTED_SIGNAL], 0);
}

static void
__gala_icon_group___lambda105__gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                    guint32 button,
                                                                    gpointer self)
{
	_gala_icon_group___lambda105_ ((GalaIconGroup*) self);
}

static ClutterActor*
_gala_icon_group_drag_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                              gfloat x,
                                                              gfloat y,
                                                              gpointer self)
{
	ClutterActor* result;
	result = gala_icon_group_drag_begin ((GalaIconGroup*) self, x, y);
	return result;
}

static void
_gala_icon_group_drag_end_gala_drag_drop_action_drag_end (GalaDragDropAction* _sender,
                                                          ClutterActor* actor,
                                                          gpointer self)
{
	gala_icon_group_drag_end ((GalaIconGroup*) self, actor);
}

static void
_gala_icon_group_drag_canceled_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                    gpointer self)
{
	gala_icon_group_drag_canceled ((GalaIconGroup*) self);
}

static void
_gala_icon_group_redraw_g_object_notify (GObject* _sender,
                                         GParamSpec* pspec,
                                         gpointer self)
{
	gala_icon_group_redraw ((GalaIconGroup*) self);
}

static gboolean
_gala_icon_group___lambda106_ (GalaIconGroup* self)
{
	gboolean result;
	result = TRUE;
	return result;
}

static gboolean
__gala_icon_group___lambda106__clutter_actor_button_press_event (ClutterActor* _sender,
                                                                 ClutterButtonEvent* event,
                                                                 gpointer self)
{
	gboolean result;
	result = _gala_icon_group___lambda106_ ((GalaIconGroup*) self);
	return result;
}

static void
_gala_icon_group_close_clutter_click_action_clicked (ClutterClickAction* _sender,
                                                     ClutterActor* actor,
                                                     gpointer self)
{
	gala_icon_group_close ((GalaIconGroup*) self);
}

static GObject *
gala_icon_group_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaIconGroup * self;
	ClutterCanvas* canvas = NULL;
	ClutterCanvas* _tmp0_;
	ClutterCanvas* _tmp1_;
	ClutterCanvas* _tmp2_;
	GalaDragDropAction* _tmp3_;
	GalaDragDropAction* _tmp4_;
	GalaDragDropAction* _tmp5_;
	GalaDragDropAction* _tmp6_;
	GalaDragDropAction* _tmp7_;
	GalaDragDropAction* _tmp8_;
	GalaDragDropAction* _tmp9_;
	ClutterActor* _tmp10_;
	ClutterActor* _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	ClutterActor* _tmp14_;
	gfloat _tmp15_;
	gfloat _tmp16_;
	ClutterActor* _tmp17_;
	ClutterActor* _tmp18_;
	ClutterActor* _tmp19_;
	ClutterActor* _tmp20_;
	ClutterActor* _tmp21_;
	ClutterActor* _tmp22_;
	ClutterActor* _tmp23_;
	ClutterActor* _tmp24_;
	ClutterClickAction* close_click = NULL;
	ClutterClickAction* _tmp25_;
	ClutterClickAction* _tmp26_;
	ClutterActor* _tmp27_;
	ClutterClickAction* _tmp28_;
	ClutterActor* _tmp29_;
	parent_class = G_OBJECT_CLASS (gala_icon_group_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_ICON_GROUP, GalaIconGroup);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	_tmp0_ = (ClutterCanvas*) clutter_canvas_new ();
	canvas = _tmp0_;
	_tmp1_ = canvas;
	g_signal_connect_object (_tmp1_, "draw", (GCallback) _gala_icon_group_draw_clutter_canvas_draw, self, 0);
	_tmp2_ = canvas;
	clutter_actor_set_content ((ClutterActor*) self, (ClutterContent*) _tmp2_);
	_tmp3_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_SOURCE | GALA_DRAG_DROP_ACTION_TYPE_DESTINATION, "multitaskingview-window");
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->drag_action);
	self->priv->drag_action = _tmp3_;
	_tmp4_ = self->priv->drag_action;
	g_signal_connect_object (_tmp4_, "actor-clicked", (GCallback) __gala_icon_group___lambda105__gala_drag_drop_action_actor_clicked, self, 0);
	_tmp5_ = self->priv->drag_action;
	g_signal_connect_object (_tmp5_, "drag-begin", (GCallback) _gala_icon_group_drag_begin_gala_drag_drop_action_drag_begin, self, 0);
	_tmp6_ = self->priv->drag_action;
	g_signal_connect_object (_tmp6_, "drag-end", (GCallback) _gala_icon_group_drag_end_gala_drag_drop_action_drag_end, self, 0);
	_tmp7_ = self->priv->drag_action;
	g_signal_connect_object (_tmp7_, "drag-canceled", (GCallback) _gala_icon_group_drag_canceled_gala_drag_drop_action_drag_canceled, self, 0);
	_tmp8_ = self->priv->drag_action;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::dragging", (GCallback) _gala_icon_group_redraw_g_object_notify, self, 0);
	_tmp9_ = self->priv->drag_action;
	clutter_actor_add_action ((ClutterActor*) self, (ClutterAction*) _tmp9_);
	_tmp10_ = clutter_actor_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->icon_container);
	self->priv->icon_container = _tmp10_;
	_tmp11_ = self->priv->icon_container;
	_tmp12_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp13_ = _tmp12_;
	clutter_actor_set_width (_tmp11_, _tmp13_);
	_tmp14_ = self->priv->icon_container;
	_tmp15_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp16_ = _tmp15_;
	clutter_actor_set_height (_tmp14_, _tmp16_);
	_tmp17_ = self->priv->icon_container;
	clutter_actor_add_child ((ClutterActor*) self, _tmp17_);
	gala_icon_group_resize_canvas (self);
	_tmp18_ = gala_utils_create_close_button ();
	_g_object_unref0 (self->priv->close_button);
	self->priv->close_button = _tmp18_;
	gala_icon_group_place_close_button (self);
	_tmp19_ = self->priv->close_button;
	clutter_actor_set_opacity (_tmp19_, (guint) 0);
	_tmp20_ = self->priv->close_button;
	clutter_actor_set_reactive (_tmp20_, TRUE);
	_tmp21_ = self->priv->close_button;
	g_object_set (_tmp21_, "visible", FALSE, NULL);
	_tmp22_ = self->priv->close_button;
	clutter_actor_set_easing_duration (_tmp22_, (guint) 200);
	_tmp23_ = self->priv->close_button;
	g_signal_connect_object (_tmp23_, "button-press-event", (GCallback) __gala_icon_group___lambda106__clutter_actor_button_press_event, self, 0);
	_tmp24_ = self->priv->close_button;
	clutter_actor_add_child ((ClutterActor*) self, _tmp24_);
	_tmp25_ = (ClutterClickAction*) clutter_click_action_new ();
	g_object_ref_sink (_tmp25_);
	close_click = _tmp25_;
	_tmp26_ = close_click;
	g_signal_connect_object (_tmp26_, "clicked", (GCallback) _gala_icon_group_close_clutter_click_action_clicked, self, 0);
	_tmp27_ = self->priv->close_button;
	_tmp28_ = close_click;
	clutter_actor_add_action (_tmp27_, (ClutterAction*) _tmp28_);
	_tmp29_ = self->priv->icon_container;
	g_signal_connect_object ((ClutterContainer*) _tmp29_, "actor-removed", (GCallback) _gala_icon_group_redraw_clutter_container_actor_removed, self, G_CONNECT_AFTER);
	_g_object_unref0 (close_click);
	_g_object_unref0 (canvas);
	return obj;
}

static void
gala_icon_group_class_init (GalaIconGroupClass * klass,
                            gpointer klass_data)
{
	gala_icon_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaIconGroup_private_offset);
	((ClutterActorClass *) klass)->enter_event = (gboolean (*) (ClutterActor*, ClutterCrossingEvent*)) gala_icon_group_real_enter_event;
	((ClutterActorClass *) klass)->leave_event = (gboolean (*) (ClutterActor*, ClutterCrossingEvent*)) gala_icon_group_real_leave_event;
	((ClutterActorClass *) klass)->paint = (void (*) (ClutterActor*, ClutterPaintContext*)) gala_icon_group_real_paint;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_icon_group_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_icon_group_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_icon_group_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_icon_group_finalize;
	/**
	         * The opacity of the backdrop/highlight. Set by the active property setter.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY, gala_icon_group_properties[GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY] = g_param_spec_uchar ("backdrop-opacity", "backdrop-opacity", "backdrop-opacity", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Fades in/out the backdrop/highlight
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ICON_GROUP_ACTIVE_PROPERTY, gala_icon_group_properties[GALA_ICON_GROUP_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ICON_GROUP_WORKSPACE_PROPERTY, gala_icon_group_properties[GALA_ICON_GROUP_WORKSPACE_PROPERTY] = g_param_spec_object ("workspace", "workspace", "workspace", meta_workspace_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	         * The group has been clicked. The MultitaskingView should consider activating
	         * its workspace.
	         */
	gala_icon_group_signals[GALA_ICON_GROUP_SELECTED_SIGNAL] = g_signal_new ("selected", GALA_TYPE_ICON_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_icon_group_instance_init (GalaIconGroup * self,
                               gpointer klass)
{
	self->priv = gala_icon_group_get_instance_private (self);
	self->priv->_backdrop_opacity = (guint8) 0;
	self->priv->_active = FALSE;
	self->priv->prev_parent = NULL;
	self->priv->show_close_button_timeout = (guint) 0;
}

static void
gala_icon_group_finalize (GObject * obj)
{
	GalaIconGroup * self;
	ClutterActor* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_ICON_GROUP, GalaIconGroup);
	_tmp0_ = self->priv->icon_container;
	g_signal_parse_name ("actor-removed", clutter_container_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((ClutterContainer*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gala_icon_group_redraw_clutter_container_actor_removed, self);
	_g_object_unref0 (self->priv->drag_action);
	_g_object_unref0 (self->priv->_workspace);
	_g_object_unref0 (self->priv->prev_parent);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->icon_container);
	G_OBJECT_CLASS (gala_icon_group_parent_class)->finalize (obj);
}

/**
     * Container for WindowIconActors which takes care of the scaling and positioning.
     * It also decides whether to draw the container shape, a plus sign or an ellipsis.
     * Lastly it also includes the drawing code for the active highlight.
     */
static GType
gala_icon_group_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaIconGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_icon_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaIconGroup), 0, (GInstanceInitFunc) gala_icon_group_instance_init, NULL };
	GType gala_icon_group_type_id;
	gala_icon_group_type_id = g_type_register_static (clutter_actor_get_type (), "GalaIconGroup", &g_define_type_info, 0);
	GalaIconGroup_private_offset = g_type_add_instance_private (gala_icon_group_type_id, sizeof (GalaIconGroupPrivate));
	return gala_icon_group_type_id;
}

GType
gala_icon_group_get_type (void)
{
	static volatile gsize gala_icon_group_type_id__once = 0;
	if (g_once_init_enter (&gala_icon_group_type_id__once)) {
		GType gala_icon_group_type_id;
		gala_icon_group_type_id = gala_icon_group_get_type_once ();
		g_once_init_leave (&gala_icon_group_type_id__once, gala_icon_group_type_id);
	}
	return gala_icon_group_type_id__once;
}

static void
_vala_gala_icon_group_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GalaIconGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_ICON_GROUP, GalaIconGroup);
	switch (property_id) {
		case GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY:
		g_value_set_uchar (value, gala_icon_group_get_backdrop_opacity (self));
		break;
		case GALA_ICON_GROUP_ACTIVE_PROPERTY:
		g_value_set_boolean (value, gala_icon_group_get_active (self));
		break;
		case GALA_ICON_GROUP_WORKSPACE_PROPERTY:
		g_value_set_object (value, gala_icon_group_get_workspace (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_icon_group_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	GalaIconGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_ICON_GROUP, GalaIconGroup);
	switch (property_id) {
		case GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY:
		gala_icon_group_set_backdrop_opacity (self, g_value_get_uchar (value));
		break;
		case GALA_ICON_GROUP_ACTIVE_PROPERTY:
		gala_icon_group_set_active (self, g_value_get_boolean (value));
		break;
		case GALA_ICON_GROUP_WORKSPACE_PROPERTY:
		gala_icon_group_set_workspace (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

