/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl;

import java.awt.Component;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JOptionPane;
import org.osgi.framework.ServiceRegistration;
import org.protege.editor.core.BookMarkedURIManager;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.editorkit.AbstractEditorKit;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.editorkit.EditorKitDescriptor;
import org.protege.editor.core.editorkit.EditorKitFactory;
import org.protege.editor.core.editorkit.Initializers;
import org.protege.editor.core.editorkit.RecentEditorKitManager;
import org.protege.editor.core.log.LogBanner;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.protege.editor.core.util.StringAbbreviator;
import org.protege.editor.owl.OWLEditorKitFactory;
import org.protege.editor.owl.ProtegeOWL;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.OWLModelManagerImpl;
import org.protege.editor.owl.model.OWLWorkspace;
import org.protege.editor.owl.model.io.IOListenerPlugin;
import org.protege.editor.owl.model.io.IOListenerPluginInstance;
import org.protege.editor.owl.model.io.IOListenerPluginLoader;
import org.protege.editor.owl.model.search.SearchManager;
import org.protege.editor.owl.model.search.SearchManagerSelector;
import org.protege.editor.owl.ui.OntologyFormatPanel;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.error.OntologyLoadErrorHandlerUI;
import org.protege.editor.owl.ui.explanation.ExplanationManager;
import org.protege.editor.owl.ui.ontology.OntologyPreferences;
import org.protege.editor.owl.ui.ontology.imports.missing.MissingImportHandlerUI;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLEditorKit
extends AbstractEditorKit<OWLEditorKitFactory> {
    public static final String ID = "OWLEditorKit";
    public static final String URI_KEY = "URI";
    public static final String FILE_URI_SCHEME = "file";
    private static final Logger logger = LoggerFactory.getLogger(OWLEditorKit.class);
    private final OWLModelManager modelManager;
    private final OWLWorkspace workspace;
    private final Set<URI> newPhysicalURIs = new HashSet<URI>();
    private final OntologyLoadErrorHandlerUI loadErrorHandler;
    private final ServiceRegistration<?> registration;
    private final OWLOntologyChangeListener ontologyChangeListener = changes -> {
        this.modifiedDocument = true;
    };
    private final SearchManagerSelector searchManagerSelector;
    private boolean modifiedDocument = false;

    public OWLEditorKit(@Nonnull OWLEditorKitFactory editorKitFactory) {
        super((EditorKitFactory)editorKitFactory);
        logger.info("OWL API Version: {}", (Object)VersionInfo.getVersionInfo().getVersion());
        this.modelManager = new OWLModelManagerImpl();
        this.workspace = new OWLWorkspace();
        this.workspace.setup((EditorKit)this);
        Initializers.loadEditorKitHooks((EditorKit)this);
        this.searchManagerSelector = new SearchManagerSelector(this);
        this.modelManager.addOntologyChangeListener(this.ontologyChangeListener);
        this.modelManager.setExplanationManager(new ExplanationManager(this));
        this.modelManager.setMissingImportHandler(new MissingImportHandlerUI(this));
        this.loadErrorHandler = new OntologyLoadErrorHandlerUI(this);
        this.modelManager.setLoadErrorHandler(this.loadErrorHandler);
        this.loadIOListenerPlugins();
        this.registration = ProtegeOWL.getBundleContext().registerService(EditorKit.class.getCanonicalName(), (Object)this, new Hashtable());
        this.workspace.initialise();
    }

    public boolean hasModifiedDocument() {
        return this.modifiedDocument;
    }

    @Nonnull
    public String getId() {
        return ID;
    }

    @Nonnull
    public OWLWorkspace getWorkspace() {
        if (this.workspace == null) {
            throw new RuntimeException("Workspace has not been initialised");
        }
        return this.workspace;
    }

    @Nonnull
    public OWLWorkspace getOWLWorkspace() {
        return this.getWorkspace();
    }

    @Nonnull
    public OWLModelManager getModelManager() {
        return this.modelManager;
    }

    @Nonnull
    public OWLModelManager getOWLModelManager() {
        return this.getModelManager();
    }

    @Nonnull
    public SearchManager getSearchManager() {
        return this.searchManagerSelector.getCurrentSearchManager();
    }

    public boolean handleLoadRecentRequest(@Nonnull EditorKitDescriptor descriptor) throws Exception {
        URI uri = descriptor.getURI(URI_KEY);
        return uri != null && this.handleLoadFrom(uri);
    }

    public boolean handleLoadRequest() throws Exception {
        File f = new UIHelper(this).chooseOWLFile("Select an OWL file");
        return f != null && this.handleLoadFrom(f.toURI());
    }

    public boolean handleLoadFrom(@Nonnull URI uri) throws Exception {
        this.loadErrorHandler.setReloadFlag(false);
        boolean success = ((OWLModelManagerImpl)this.getModelManager()).loadOntologyFromPhysicalURI(uri);
        if (success) {
            this.addRecent(uri);
        } else if (this.loadErrorHandler.getReloadFlag()) {
            success = this.handleLoadFrom(uri);
        }
        this.modifiedDocument = true;
        return success;
    }

    @Nonnull
    private OWLOntologyID createDefaultOntologyId() {
        return new OWLOntologyID(com.google.common.base.Optional.of((Object)this.createFreshOntologyIRI()), com.google.common.base.Optional.absent());
    }

    @Nonnull
    private IRI createFreshOntologyIRI() {
        OntologyPreferences ontologyPreferences = OntologyPreferences.getInstance();
        return IRI.create((URI)ontologyPreferences.generateNextURI());
    }

    public boolean handleNewRequest() throws Exception {
        OWLOntologyID id = this.createDefaultOntologyId();
        OWLOntology ont = this.getModelManager().createNewOntology(id, URI.create(((IRI)id.getDefaultDocumentIRI().get()).toString()));
        OWLOntologyManager owlOntologyManager = this.getModelManager().getOWLOntologyManager();
        owlOntologyManager.setOntologyFormat(ont, (OWLDocumentFormat)new RDFXMLDocumentFormat());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSave() {
        logger.info(LogBanner.start((String)"Saving Workspace and Ontologies"));
        try {
            OWLOntologyManager ontologyManager = this.getOWLModelManager().getOWLOntologyManager();
            HashSet<OWLOntology> ontologiesToSave = new HashSet<OWLOntology>();
            HashSet<OWLOntology> ontologiesToSaveAs = new HashSet<OWLOntology>();
            OWLOntology activeOntology = this.modelManager.getActiveOntology();
            IRI activeOntologyDocumentIRI = ontologyManager.getOntologyDocumentIRI(activeOntology);
            if (!FILE_URI_SCHEME.equalsIgnoreCase(activeOntologyDocumentIRI.getScheme())) {
                logger.info("Will prompt 'Save As' for the active ontology because it was not loaded from a local file");
                ontologiesToSaveAs.add(activeOntology);
            }
            for (OWLOntology dirtyOntology : this.getOWLModelManager().getDirtyOntologies()) {
                String ontologyRendering = this.getModelManager().getRendering((OWLObject)dirtyOntology);
                if (!FILE_URI_SCHEME.equals(ontologyManager.getOntologyDocumentIRI(dirtyOntology).getScheme())) {
                    logger.info("Will prompt 'Save As' for the {} ontology because it was not loaded from a local file but has been modified", (Object)ontologyRendering);
                    ontologiesToSaveAs.add(dirtyOntology);
                    continue;
                }
                logger.info("Will save the {} ontology because it has been modified", (Object)ontologyRendering);
                ontologiesToSave.add(dirtyOntology);
            }
            LinkedHashMap<OWLOntology, OWLOntologyStorageException> saveErrors = new LinkedHashMap<OWLOntology, OWLOntologyStorageException>();
            for (OWLOntology ontology : ontologiesToSaveAs) {
                try {
                    if (this.handleSaveAs(ontology)) continue;
                    return;
                }
                catch (OWLOntologyStorageException e) {
                    saveErrors.put(ontology, e);
                }
            }
            for (OWLOntology ontology : ontologiesToSave) {
                try {
                    this.getOWLModelManager().save(ontology);
                }
                catch (OWLOntologyStorageException e) {
                    saveErrors.put(ontology, e);
                }
            }
            this.getWorkspace().save();
            this.newPhysicalURIs.forEach(this::addRecent);
            this.newPhysicalURIs.clear();
            this.handleSaveErrors(saveErrors);
        }
        finally {
            logger.info(LogBanner.end());
        }
    }

    private void handleSaveErrors(Map<OWLOntology, OWLOntologyStorageException> saveErrors) {
        if (saveErrors.isEmpty()) {
            return;
        }
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("<html><body><b>Some errors where encountered during the save operation.</b><br><br>The following ontologies were not saved:<br><br>");
        for (OWLOntology erroredOntology : saveErrors.keySet()) {
            OWLOntologyStorageException error = saveErrors.get(erroredOntology);
            logger.error("An error occurred whilst saving the {} ontology: {}", (Object)error.getMessage(), (Object)error);
            String rendering = this.getModelManager().getRendering((OWLObject)erroredOntology);
            errorMessage.append("<b>").append(rendering).append("</b><br><span style=\"color:gray;\">Reason: ").append(StringAbbreviator.abbreviateString((String)error.getMessage().trim(), (int)100).replace("\n", "<br>")).append("</span><br><br>");
        }
        JOptionPane.showMessageDialog((Component)((Object)this.getWorkspace()), errorMessage.toString(), "Save Errors", 0);
    }

    public void handleSaveAs() {
        OWLOntology ont = this.getModelManager().getActiveOntology();
        try {
            this.handleSaveAs(ont);
        }
        catch (OWLOntologyStorageException e) {
            HashMap<OWLOntology, OWLOntologyStorageException> saveErrorMap = new HashMap<OWLOntology, OWLOntologyStorageException>();
            saveErrorMap.put(ont, e);
            this.handleSaveErrors(saveErrorMap);
        }
    }

    private boolean handleSaveAs(@Nonnull OWLOntology ont) throws OWLOntologyStorageException {
        File file;
        OWLOntologyManager man = this.getModelManager().getOWLOntologyManager();
        OWLDocumentFormat oldFormat = man.getOntologyFormat(ont);
        Optional<OWLDocumentFormat> format = OntologyFormatPanel.showDialog(this, oldFormat, String.format("<html><body><div>Choose a format to use when saving the <span style='font-weight: bold;'>'%s'</span> ontology.</div><div style='padding-top: 20px; color: gray'; width: 150px;>(If you are unsure as to what format to choose, we recommend that you use the standard RDF/XML format, or a widely supported format such as Turtle)</div></body></html>", this.getModelManager().getRendering((OWLObject)ont)));
        if (!format.isPresent()) {
            logger.info("No ontology document format has been selected.  Aborting saveAs.");
            return false;
        }
        if (oldFormat instanceof PrefixDocumentFormat && format.get() instanceof PrefixDocumentFormat) {
            PrefixDocumentFormat oldPrefixes = (PrefixDocumentFormat)oldFormat;
            for (String name : oldPrefixes.getPrefixNames()) {
                String prefix = oldPrefixes.getPrefix(name);
                if (prefix == null) continue;
                ((PrefixDocumentFormat)format.get()).setPrefix(name, prefix);
            }
        }
        if ((file = this.getSaveAsOWLFile(ont)) != null) {
            man.setOntologyFormat(ont, format.get());
            man.setOntologyDocumentIRI(ont, IRI.create((File)file));
            this.getModelManager().save(ont);
            this.addRecent(file.toURI());
            return true;
        }
        return false;
    }

    private File getSaveAsOWLFile(@Nonnull OWLOntology ont) {
        UIHelper helper = new UIHelper(this);
        File file = helper.saveOWLFile(String.format("Please select a location in which to save: %s", this.getModelManager().getRendering((OWLObject)ont)));
        if (file != null) {
            int extensionIndex = file.toString().lastIndexOf(46);
            if (extensionIndex == -1) {
                file = new File(file.toString() + ".owl");
            } else if (extensionIndex != file.toString().length() - 4) {
                file = new File(file.toString() + ".owl");
            }
        }
        return file;
    }

    public void addRecent(@Nonnull URI physicalURI) {
        String label = physicalURI.toString();
        if (FILE_URI_SCHEME.equals(physicalURI.getScheme())) {
            label = new File(physicalURI).getPath();
        } else {
            BookMarkedURIManager.getInstance().add(physicalURI);
        }
        EditorKitDescriptor descriptor = new EditorKitDescriptor(label, this.getEditorKitFactory());
        descriptor.setURI(URI_KEY, physicalURI);
        RecentEditorKitManager.getInstance().add(descriptor);
    }

    private void loadIOListenerPlugins() {
        IOListenerPluginLoader loader = new IOListenerPluginLoader(this);
        for (IOListenerPlugin pl : loader.getPlugins()) {
            try {
                IOListenerPluginInstance instance = (IOListenerPluginInstance)pl.newInstance();
                this.getModelManager().addIOListener(instance);
            }
            catch (Throwable e) {
                logger.warn("An IOListenerPlugin threw an error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public Disposable get(@Nullable Object key) {
        return this.getOWLModelManager().get(key);
    }

    public void put(@Nullable Object key, @Nullable Disposable value) {
        this.getOWLModelManager().put(key, value);
    }

    public void dispose() {
        logger.info(LogBanner.start((String)"Disposing of Workspace"));
        this.getModelManager().removeOntologyChangeListener(this.ontologyChangeListener);
        super.dispose();
        this.searchManagerSelector.getCurrentSearchManager().dispose();
        this.workspace.dispose();
        try {
            this.modelManager.getExplanationManager().dispose();
            this.modelManager.dispose();
        }
        catch (Exception e) {
            ErrorLogPanel.showErrorDialog((Throwable)e);
        }
        try {
            this.registration.unregister();
        }
        catch (Exception e) {
            logger.warn("Error whilst unregistering service: {}", (Object)e.getMessage());
        }
        logger.info(LogBanner.end());
    }

    @Nonnull
    public SearchManagerSelector getSearchManagerSelector() {
        return this.searchManagerSelector;
    }
}

