/* LocaleManager.c generated by valac 0.56.3, the Vala compiler
 * generated from LocaleManager.vala, do not modify */

/* Copyright 2011-2019 elementary, Inc. (https://elementary.io)
*
* This program is free software: you can redistribute it
* and/or modify it under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program. If not, see http://www.gnu.org/licenses/.
*/

#include "locale-plug.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <libgnome-desktop/gnome-xkb-info.h>
#include <gee.h>
#include <glib-object.h>
#include <locale.h>
#include <polkit/polkit.h>
#include <unistd.h>

#define SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_GNOME_DESKTOP_INPUT_SOURCES "org.gnome.desktop.input-sources"
#define SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_GNOME_LOCALE_KEY "org.gnome.system.locale"
#define SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_KEY_INPUT_SOURCES "sources"
#define SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_KEY_INPUT_SELETION "input-selections"

typedef GDBusProxy AccountProxyProxy;
typedef GDBusProxyClass AccountProxyProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef GDBusProxy Locale1ProxyProxy;
typedef GDBusProxyClass Locale1ProxyProxyClass;
enum  {
	SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_0_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_IS_CONNECTED_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_locale_locale_manager_properties[SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _SwitchboardPlugLocaleLocaleManagerPrivate {
	gboolean _is_connected;
	Locale1Proxy* locale1_proxy;
	AccountProxy* account_proxy;
	GSettings* input_settings;
	GSettings* locale_settings;
	GSettings* settings;
	GnomeXkbInfo* xkbinfo;
};

static gint SwitchboardPlugLocaleLocaleManager_private_offset;
static gpointer switchboard_plug_locale_locale_manager_parent_class = NULL;
static SwitchboardPlugLocaleLocaleManager* switchboard_plug_locale_locale_manager_instance;
static SwitchboardPlugLocaleLocaleManager* switchboard_plug_locale_locale_manager_instance = NULL;

static GType account_proxy_get_type_once (void);
static void account_proxy_proxy_g_signal (GDBusProxy* proxy,
                                   const gchar* sender_name,
                                   const gchar* signal_name,
                                   GVariant* parameters);
static void account_proxy_proxy_set_formats_locale (AccountProxy* self,
                                             const gchar* formats_locale,
                                             GError** error);
static void account_proxy_proxy_set_language (AccountProxy* self,
                                       const gchar* language,
                                       GError** error);
static gchar* account_proxy_dbus_proxy_get_formats_locale (AccountProxy* self);
static gchar* account_proxy_dbus_proxy_get_language (AccountProxy* self);
static void account_proxy_proxy_account_proxy_interface_init (AccountProxyIface* iface);
static void _dbus_account_proxy_set_formats_locale (AccountProxy* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_account_proxy_set_language (AccountProxy* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation);
static void account_proxy_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data);
static GVariant* account_proxy_dbus_interface_get_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GError** error,
                                                     gpointer user_data);
static GVariant* _dbus_account_proxy_get_formats_locale (AccountProxy* self);
static GVariant* _dbus_account_proxy_get_language (AccountProxy* self);
static gboolean account_proxy_dbus_interface_set_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GVariant* value,
                                                    GError** error,
                                                    gpointer user_data);
static void _account_proxy_unregister_object (gpointer user_data);
static GType locale1_proxy_get_type_once (void);
static void locale1_proxy_proxy_g_signal (GDBusProxy* proxy,
                                   const gchar* sender_name,
                                   const gchar* signal_name,
                                   GVariant* parameters);
static void locale1_proxy_proxy_set_locale (Locale1Proxy* self,
                                     gchar** arg_0,
                                     gint arg_0_length1,
                                     gboolean arg_1,
                                     GError** error);
static void locale1_proxy_proxy_set_x11_keyboard (Locale1Proxy* self,
                                           const gchar* arg_0,
                                           const gchar* arg_1,
                                           const gchar* arg_2,
                                           const gchar* arg_3,
                                           gboolean arg_4,
                                           gboolean arg_5,
                                           GError** error);
static gchar** locale1_proxy_dbus_proxy_get_locale (Locale1Proxy* self,
                                             gint* result_length1);
static void locale1_proxy_proxy_locale1_proxy_interface_init (Locale1ProxyIface* iface);
static void _dbus_locale1_proxy_set_locale (Locale1Proxy* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation);
static void _dbus_locale1_proxy_set_x11_keyboard (Locale1Proxy* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void locale1_proxy_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data);
static GVariant* locale1_proxy_dbus_interface_get_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GError** error,
                                                     gpointer user_data);
static GVariant* _dbus_locale1_proxy_get_locale (Locale1Proxy* self);
static gboolean locale1_proxy_dbus_interface_set_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GVariant* value,
                                                    GError** error,
                                                    gpointer user_data);
static void _locale1_proxy_unregister_object (gpointer user_data);
static void switchboard_plug_locale_locale_manager_on_settings_changed (SwitchboardPlugLocaleLocaleManager* self,
                                                                 const gchar* key);
static void switchboard_plug_locale_locale_manager_localectl_set_locale (SwitchboardPlugLocaleLocaleManager* self,
                                                                  const gchar* locale,
                                                                  const gchar* format,
                                                                  GError** error);
static void switchboard_plug_locale_locale_manager_localectl_set_x11_keymap (SwitchboardPlugLocaleLocaleManager* self,
                                                                      const gchar* layouts,
                                                                      const gchar* variants,
                                                                      GError** error);
static void switchboard_plug_locale_locale_manager_set_is_connected (SwitchboardPlugLocaleLocaleManager* self,
                                                              gboolean value);
static GObject * switchboard_plug_locale_locale_manager_constructor (GType type,
                                                              guint n_construct_properties,
                                                              GObjectConstructParam * construct_properties);
static void _switchboard_plug_locale_locale_manager_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                                     const gchar* key,
                                                                                     gpointer self);
static void switchboard_plug_locale_locale_manager_finalize (GObject * obj);
static GType switchboard_plug_locale_locale_manager_get_type_once (void);
static void _vala_switchboard_plug_locale_locale_manager_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_switchboard_plug_locale_locale_manager_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusArgInfo _account_proxy_dbus_arg_info_set_formats_locale_formats_locale = {-1, "formats_locale", "s", NULL};
static const GDBusArgInfo * const _account_proxy_dbus_arg_info_set_formats_locale_in[] = {&_account_proxy_dbus_arg_info_set_formats_locale_formats_locale, NULL};
static const GDBusArgInfo * const _account_proxy_dbus_arg_info_set_formats_locale_out[] = {NULL};
static const GDBusMethodInfo _account_proxy_dbus_method_info_set_formats_locale = {-1, "SetFormatsLocale", (GDBusArgInfo **) (&_account_proxy_dbus_arg_info_set_formats_locale_in), (GDBusArgInfo **) (&_account_proxy_dbus_arg_info_set_formats_locale_out), NULL};
static const GDBusArgInfo _account_proxy_dbus_arg_info_set_language_language = {-1, "language", "s", NULL};
static const GDBusArgInfo * const _account_proxy_dbus_arg_info_set_language_in[] = {&_account_proxy_dbus_arg_info_set_language_language, NULL};
static const GDBusArgInfo * const _account_proxy_dbus_arg_info_set_language_out[] = {NULL};
static const GDBusMethodInfo _account_proxy_dbus_method_info_set_language = {-1, "SetLanguage", (GDBusArgInfo **) (&_account_proxy_dbus_arg_info_set_language_in), (GDBusArgInfo **) (&_account_proxy_dbus_arg_info_set_language_out), NULL};
static const GDBusMethodInfo * const _account_proxy_dbus_method_info[] = {&_account_proxy_dbus_method_info_set_formats_locale, &_account_proxy_dbus_method_info_set_language, NULL};
static const GDBusSignalInfo * const _account_proxy_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _account_proxy_dbus_property_info_formats_locale = {-1, "FormatsLocale", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _account_proxy_dbus_property_info_language = {-1, "Language", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _account_proxy_dbus_property_info[] = {&_account_proxy_dbus_property_info_formats_locale, &_account_proxy_dbus_property_info_language, NULL};
static const GDBusInterfaceInfo _account_proxy_dbus_interface_info = {-1, "org.freedesktop.Accounts.User", (GDBusMethodInfo **) (&_account_proxy_dbus_method_info), (GDBusSignalInfo **) (&_account_proxy_dbus_signal_info), (GDBusPropertyInfo **) (&_account_proxy_dbus_property_info), NULL};
static const GDBusInterfaceVTable _account_proxy_dbus_interface_vtable = {account_proxy_dbus_interface_method_call, account_proxy_dbus_interface_get_property, account_proxy_dbus_interface_set_property};
static const GDBusArgInfo _locale1_proxy_dbus_arg_info_set_locale_arg_0 = {-1, "arg_0", "as", NULL};
static const GDBusArgInfo _locale1_proxy_dbus_arg_info_set_locale_arg_1 = {-1, "arg_1", "b", NULL};
static const GDBusArgInfo * const _locale1_proxy_dbus_arg_info_set_locale_in[] = {&_locale1_proxy_dbus_arg_info_set_locale_arg_0, &_locale1_proxy_dbus_arg_info_set_locale_arg_1, NULL};
static const GDBusArgInfo * const _locale1_proxy_dbus_arg_info_set_locale_out[] = {NULL};
static const GDBusMethodInfo _locale1_proxy_dbus_method_info_set_locale = {-1, "SetLocale", (GDBusArgInfo **) (&_locale1_proxy_dbus_arg_info_set_locale_in), (GDBusArgInfo **) (&_locale1_proxy_dbus_arg_info_set_locale_out), NULL};
static const GDBusArgInfo _locale1_proxy_dbus_arg_info_set_x11_keyboard_arg_0 = {-1, "arg_0", "s", NULL};
static const GDBusArgInfo _locale1_proxy_dbus_arg_info_set_x11_keyboard_arg_1 = {-1, "arg_1", "s", NULL};
static const GDBusArgInfo _locale1_proxy_dbus_arg_info_set_x11_keyboard_arg_2 = {-1, "arg_2", "s", NULL};
static const GDBusArgInfo _locale1_proxy_dbus_arg_info_set_x11_keyboard_arg_3 = {-1, "arg_3", "s", NULL};
static const GDBusArgInfo _locale1_proxy_dbus_arg_info_set_x11_keyboard_arg_4 = {-1, "arg_4", "b", NULL};
static const GDBusArgInfo _locale1_proxy_dbus_arg_info_set_x11_keyboard_arg_5 = {-1, "arg_5", "b", NULL};
static const GDBusArgInfo * const _locale1_proxy_dbus_arg_info_set_x11_keyboard_in[] = {&_locale1_proxy_dbus_arg_info_set_x11_keyboard_arg_0, &_locale1_proxy_dbus_arg_info_set_x11_keyboard_arg_1, &_locale1_proxy_dbus_arg_info_set_x11_keyboard_arg_2, &_locale1_proxy_dbus_arg_info_set_x11_keyboard_arg_3, &_locale1_proxy_dbus_arg_info_set_x11_keyboard_arg_4, &_locale1_proxy_dbus_arg_info_set_x11_keyboard_arg_5, NULL};
static const GDBusArgInfo * const _locale1_proxy_dbus_arg_info_set_x11_keyboard_out[] = {NULL};
static const GDBusMethodInfo _locale1_proxy_dbus_method_info_set_x11_keyboard = {-1, "SetX11Keyboard", (GDBusArgInfo **) (&_locale1_proxy_dbus_arg_info_set_x11_keyboard_in), (GDBusArgInfo **) (&_locale1_proxy_dbus_arg_info_set_x11_keyboard_out), NULL};
static const GDBusMethodInfo * const _locale1_proxy_dbus_method_info[] = {&_locale1_proxy_dbus_method_info_set_locale, &_locale1_proxy_dbus_method_info_set_x11_keyboard, NULL};
static const GDBusSignalInfo * const _locale1_proxy_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _locale1_proxy_dbus_property_info_locale = {-1, "Locale", "as", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _locale1_proxy_dbus_property_info[] = {&_locale1_proxy_dbus_property_info_locale, NULL};
static const GDBusInterfaceInfo _locale1_proxy_dbus_interface_info = {-1, "org.freedesktop.locale1", (GDBusMethodInfo **) (&_locale1_proxy_dbus_method_info), (GDBusSignalInfo **) (&_locale1_proxy_dbus_signal_info), (GDBusPropertyInfo **) (&_locale1_proxy_dbus_property_info), NULL};
static const GDBusInterfaceVTable _locale1_proxy_dbus_interface_vtable = {locale1_proxy_dbus_interface_method_call, locale1_proxy_dbus_interface_get_property, locale1_proxy_dbus_interface_set_property};

void
account_proxy_set_formats_locale (AccountProxy* self,
                                  const gchar* formats_locale,
                                  GError** error)
{
	AccountProxyIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ACCOUNT_PROXY_GET_INTERFACE (self);
	if (_iface_->set_formats_locale) {
		_iface_->set_formats_locale (self, formats_locale, error);
	}
}

void
account_proxy_set_language (AccountProxy* self,
                            const gchar* language,
                            GError** error)
{
	AccountProxyIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ACCOUNT_PROXY_GET_INTERFACE (self);
	if (_iface_->set_language) {
		_iface_->set_language (self, language, error);
	}
}

gchar*
account_proxy_get_formats_locale (AccountProxy* self)
{
	AccountProxyIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ACCOUNT_PROXY_GET_INTERFACE (self);
	if (_iface_->get_formats_locale) {
		return _iface_->get_formats_locale (self);
	}
	return NULL;
}

gchar*
account_proxy_get_language (AccountProxy* self)
{
	AccountProxyIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ACCOUNT_PROXY_GET_INTERFACE (self);
	if (_iface_->get_language) {
		return _iface_->get_language (self);
	}
	return NULL;
}

static void
account_proxy_default_init (AccountProxyIface * iface,
                            gpointer iface_data)
{
}

static GType
account_proxy_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountProxyIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) account_proxy_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType account_proxy_type_id;
	account_proxy_type_id = g_type_register_static (G_TYPE_INTERFACE, "AccountProxy", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (account_proxy_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (account_proxy_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) account_proxy_proxy_get_type);
	g_type_set_qdata (account_proxy_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Accounts.User");
	g_type_set_qdata (account_proxy_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_account_proxy_dbus_interface_info));
	g_type_set_qdata (account_proxy_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) account_proxy_register_object);
	return account_proxy_type_id;
}

GType
account_proxy_get_type (void)
{
	static volatile gsize account_proxy_type_id__once = 0;
	if (g_once_init_enter (&account_proxy_type_id__once)) {
		GType account_proxy_type_id;
		account_proxy_type_id = account_proxy_get_type_once ();
		g_once_init_leave (&account_proxy_type_id__once, account_proxy_type_id);
	}
	return account_proxy_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (AccountProxyProxy, account_proxy_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_ACCOUNT_PROXY, account_proxy_proxy_account_proxy_interface_init) )
static void
account_proxy_proxy_class_init (AccountProxyProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = account_proxy_proxy_g_signal;
}

static void
account_proxy_proxy_g_signal (GDBusProxy* proxy,
                              const gchar* sender_name,
                              const gchar* signal_name,
                              GVariant* parameters)
{
}

static void
account_proxy_proxy_init (AccountProxyProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_account_proxy_dbus_interface_info));
}

static void
account_proxy_proxy_set_formats_locale (AccountProxy* self,
                                        const gchar* formats_locale,
                                        GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Accounts.User", "SetFormatsLocale");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (formats_locale));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
account_proxy_proxy_set_language (AccountProxy* self,
                                  const gchar* language,
                                  GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Accounts.User", "SetLanguage");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (language));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gchar*
account_proxy_dbus_proxy_get_formats_locale (AccountProxy* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "FormatsLocale");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.Accounts.User"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("FormatsLocale"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
account_proxy_dbus_proxy_get_language (AccountProxy* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Language");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.Accounts.User"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Language"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
account_proxy_proxy_account_proxy_interface_init (AccountProxyIface* iface)
{
	iface->set_formats_locale = account_proxy_proxy_set_formats_locale;
	iface->set_language = account_proxy_proxy_set_language;
	iface->get_formats_locale = account_proxy_dbus_proxy_get_formats_locale;
	iface->get_language = account_proxy_dbus_proxy_get_language;
}

static void
_dbus_account_proxy_set_formats_locale (AccountProxy* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* formats_locale = NULL;
	GVariant* _tmp0_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	formats_locale = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	account_proxy_set_formats_locale (self, formats_locale, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (formats_locale);
	;
}

static void
_dbus_account_proxy_set_language (AccountProxy* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* language = NULL;
	GVariant* _tmp1_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	language = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	account_proxy_set_language (self, language, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (language);
	;
}

static void
account_proxy_dbus_interface_method_call (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* method_name,
                                          GVariant* parameters,
                                          GDBusMethodInvocation* invocation,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SetFormatsLocale") == 0) {
		_dbus_account_proxy_set_formats_locale (object, parameters, invocation);
	} else if (strcmp (method_name, "SetLanguage") == 0) {
		_dbus_account_proxy_set_language (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_account_proxy_get_formats_locale (AccountProxy* self)
{
	gchar* result;
	GVariant* _reply;
	result = account_proxy_get_formats_locale (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_account_proxy_get_language (AccountProxy* self)
{
	gchar* result;
	GVariant* _reply;
	result = account_proxy_get_language (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
account_proxy_dbus_interface_get_property (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* property_name,
                                           GError** error,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "FormatsLocale") == 0) {
		return _dbus_account_proxy_get_formats_locale (object);
	} else if (strcmp (property_name, "Language") == 0) {
		return _dbus_account_proxy_get_language (object);
	}
	return NULL;
}

static gboolean
account_proxy_dbus_interface_set_property (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* property_name,
                                           GVariant* value,
                                           GError** error,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
account_proxy_register_object (gpointer object,
                               GDBusConnection* connection,
                               const gchar* path,
                               GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_account_proxy_dbus_interface_info), &_account_proxy_dbus_interface_vtable, data, _account_proxy_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_account_proxy_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
locale1_proxy_set_locale (Locale1Proxy* self,
                          gchar** arg_0,
                          gint arg_0_length1,
                          gboolean arg_1,
                          GError** error)
{
	Locale1ProxyIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = LOCALE1_PROXY_GET_INTERFACE (self);
	if (_iface_->set_locale) {
		_iface_->set_locale (self, arg_0, arg_0_length1, arg_1, error);
	}
}

void
locale1_proxy_set_x11_keyboard (Locale1Proxy* self,
                                const gchar* arg_0,
                                const gchar* arg_1,
                                const gchar* arg_2,
                                const gchar* arg_3,
                                gboolean arg_4,
                                gboolean arg_5,
                                GError** error)
{
	Locale1ProxyIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = LOCALE1_PROXY_GET_INTERFACE (self);
	if (_iface_->set_x11_keyboard) {
		_iface_->set_x11_keyboard (self, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, error);
	}
}

gchar**
locale1_proxy_get_locale (Locale1Proxy* self,
                          gint* result_length1)
{
	Locale1ProxyIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = LOCALE1_PROXY_GET_INTERFACE (self);
	if (_iface_->get_locale) {
		return _iface_->get_locale (self, result_length1);
	}
	return NULL;
}

static void
locale1_proxy_default_init (Locale1ProxyIface * iface,
                            gpointer iface_data)
{
}

static GType
locale1_proxy_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (Locale1ProxyIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) locale1_proxy_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType locale1_proxy_type_id;
	locale1_proxy_type_id = g_type_register_static (G_TYPE_INTERFACE, "Locale1Proxy", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (locale1_proxy_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (locale1_proxy_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) locale1_proxy_proxy_get_type);
	g_type_set_qdata (locale1_proxy_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.locale1");
	g_type_set_qdata (locale1_proxy_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_locale1_proxy_dbus_interface_info));
	g_type_set_qdata (locale1_proxy_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) locale1_proxy_register_object);
	return locale1_proxy_type_id;
}

GType
locale1_proxy_get_type (void)
{
	static volatile gsize locale1_proxy_type_id__once = 0;
	if (g_once_init_enter (&locale1_proxy_type_id__once)) {
		GType locale1_proxy_type_id;
		locale1_proxy_type_id = locale1_proxy_get_type_once ();
		g_once_init_leave (&locale1_proxy_type_id__once, locale1_proxy_type_id);
	}
	return locale1_proxy_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (Locale1ProxyProxy, locale1_proxy_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_LOCALE1_PROXY, locale1_proxy_proxy_locale1_proxy_interface_init) )
static void
locale1_proxy_proxy_class_init (Locale1ProxyProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = locale1_proxy_proxy_g_signal;
}

static void
locale1_proxy_proxy_g_signal (GDBusProxy* proxy,
                              const gchar* sender_name,
                              const gchar* signal_name,
                              GVariant* parameters)
{
}

static void
locale1_proxy_proxy_init (Locale1ProxyProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_locale1_proxy_dbus_interface_info));
}

static void
locale1_proxy_proxy_set_locale (Locale1Proxy* self,
                                gchar** arg_0,
                                gint arg_0_length1,
                                gboolean arg_1,
                                GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp2_;
	GVariantBuilder _tmp3_;
	gint _tmp4_;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.locale1", "SetLocale");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp2_ = arg_0;
	g_variant_builder_init (&_tmp3_, G_VARIANT_TYPE ("as"));
	for (_tmp4_ = 0; _tmp4_ < arg_0_length1; _tmp4_++) {
		g_variant_builder_add_value (&_tmp3_, g_variant_new_string (*_tmp2_));
		_tmp2_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp3_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (arg_1));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
locale1_proxy_proxy_set_x11_keyboard (Locale1Proxy* self,
                                      const gchar* arg_0,
                                      const gchar* arg_1,
                                      const gchar* arg_2,
                                      const gchar* arg_3,
                                      gboolean arg_4,
                                      gboolean arg_5,
                                      GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.locale1", "SetX11Keyboard");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (arg_0));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (arg_1));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (arg_2));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (arg_3));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (arg_4));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (arg_5));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gchar**
locale1_proxy_dbus_proxy_get_locale (Locale1Proxy* self,
                                     gint* result_length1)
{
	GVariant *_inner_reply;
	gchar** _result;
	gint _result_length1;
	gchar** _tmp5_;
	gint _tmp5__length;
	gint _tmp5__size;
	gint _tmp5__length1;
	GVariantIter _tmp6_;
	GVariant* _tmp7_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Locale");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.locale1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Locale"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp5_ = g_new (gchar*, 5);
	_tmp5__length = 0;
	_tmp5__size = 4;
	_tmp5__length1 = 0;
	g_variant_iter_init (&_tmp6_, _inner_reply);
	for (; (_tmp7_ = g_variant_iter_next_value (&_tmp6_)) != NULL; _tmp5__length1++) {
		if (_tmp5__size == _tmp5__length) {
			_tmp5__size = 2 * _tmp5__size;
			_tmp5_ = g_renew (gchar*, _tmp5_, _tmp5__size + 1);
		}
		_tmp5_[_tmp5__length++] = g_variant_dup_string (_tmp7_, NULL);
		g_variant_unref (_tmp7_);
	}
	_result_length1 = _tmp5__length1;
	_tmp5_[_tmp5__length] = NULL;
	_result = _tmp5_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}

static void
locale1_proxy_proxy_locale1_proxy_interface_init (Locale1ProxyIface* iface)
{
	iface->set_locale = locale1_proxy_proxy_set_locale;
	iface->set_x11_keyboard = locale1_proxy_proxy_set_x11_keyboard;
	iface->get_locale = locale1_proxy_dbus_proxy_get_locale;
}

static void
_dbus_locale1_proxy_set_locale (Locale1Proxy* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** arg_0 = NULL;
	gint arg_0_length1 = 0;
	GVariant* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length;
	gint _tmp9__size;
	gint _tmp9__length1;
	GVariantIter _tmp10_;
	GVariant* _tmp11_;
	gboolean arg_1 = FALSE;
	GVariant* _tmp12_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp9_ = g_new (gchar*, 5);
	_tmp9__length = 0;
	_tmp9__size = 4;
	_tmp9__length1 = 0;
	g_variant_iter_init (&_tmp10_, _tmp8_);
	for (; (_tmp11_ = g_variant_iter_next_value (&_tmp10_)) != NULL; _tmp9__length1++) {
		if (_tmp9__size == _tmp9__length) {
			_tmp9__size = 2 * _tmp9__size;
			_tmp9_ = g_renew (gchar*, _tmp9_, _tmp9__size + 1);
		}
		_tmp9_[_tmp9__length++] = g_variant_dup_string (_tmp11_, NULL);
		g_variant_unref (_tmp11_);
	}
	arg_0_length1 = _tmp9__length1;
	_tmp9_[_tmp9__length] = NULL;
	arg_0 = _tmp9_;
	g_variant_unref (_tmp8_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	arg_1 = g_variant_get_boolean (_tmp12_);
	g_variant_unref (_tmp12_);
	locale1_proxy_set_locale (self, arg_0, arg_0_length1, arg_1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	arg_0 = (_vala_array_free (arg_0, arg_0_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_locale1_proxy_set_x11_keyboard (Locale1Proxy* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* arg_0 = NULL;
	GVariant* _tmp13_;
	gchar* arg_1 = NULL;
	GVariant* _tmp14_;
	gchar* arg_2 = NULL;
	GVariant* _tmp15_;
	gchar* arg_3 = NULL;
	GVariant* _tmp16_;
	gboolean arg_4 = FALSE;
	GVariant* _tmp17_;
	gboolean arg_5 = FALSE;
	GVariant* _tmp18_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	arg_0 = g_variant_dup_string (_tmp13_, NULL);
	g_variant_unref (_tmp13_);
	_tmp14_ = g_variant_iter_next_value (&_arguments_iter);
	arg_1 = g_variant_dup_string (_tmp14_, NULL);
	g_variant_unref (_tmp14_);
	_tmp15_ = g_variant_iter_next_value (&_arguments_iter);
	arg_2 = g_variant_dup_string (_tmp15_, NULL);
	g_variant_unref (_tmp15_);
	_tmp16_ = g_variant_iter_next_value (&_arguments_iter);
	arg_3 = g_variant_dup_string (_tmp16_, NULL);
	g_variant_unref (_tmp16_);
	_tmp17_ = g_variant_iter_next_value (&_arguments_iter);
	arg_4 = g_variant_get_boolean (_tmp17_);
	g_variant_unref (_tmp17_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	arg_5 = g_variant_get_boolean (_tmp18_);
	g_variant_unref (_tmp18_);
	locale1_proxy_set_x11_keyboard (self, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (arg_0);
	_g_free0 (arg_1);
	_g_free0 (arg_2);
	_g_free0 (arg_3);
	;
}

static void
locale1_proxy_dbus_interface_method_call (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* method_name,
                                          GVariant* parameters,
                                          GDBusMethodInvocation* invocation,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SetLocale") == 0) {
		_dbus_locale1_proxy_set_locale (object, parameters, invocation);
	} else if (strcmp (method_name, "SetX11Keyboard") == 0) {
		_dbus_locale1_proxy_set_x11_keyboard (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_locale1_proxy_get_locale (Locale1Proxy* self)
{
	gchar** result;
	gint result_length1 = 0;
	GVariant* _reply;
	gchar** _tmp19_;
	GVariantBuilder _tmp20_;
	gint _tmp21_;
	result = locale1_proxy_get_locale (self, &result_length1);
	_tmp19_ = result;
	g_variant_builder_init (&_tmp20_, G_VARIANT_TYPE ("as"));
	for (_tmp21_ = 0; _tmp21_ < result_length1; _tmp21_++) {
		g_variant_builder_add_value (&_tmp20_, g_variant_new_string (*_tmp19_));
		_tmp19_++;
	}
	_reply = g_variant_builder_end (&_tmp20_);
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	return _reply;
}

static GVariant*
locale1_proxy_dbus_interface_get_property (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* property_name,
                                           GError** error,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Locale") == 0) {
		return _dbus_locale1_proxy_get_locale (object);
	}
	return NULL;
}

static gboolean
locale1_proxy_dbus_interface_set_property (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* property_name,
                                           GVariant* value,
                                           GError** error,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
locale1_proxy_register_object (gpointer object,
                               GDBusConnection* connection,
                               const gchar* path,
                               GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_locale1_proxy_dbus_interface_info), &_locale1_proxy_dbus_interface_vtable, data, _locale1_proxy_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_locale1_proxy_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
switchboard_plug_locale_locale_manager_get_instance_private (SwitchboardPlugLocaleLocaleManager* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugLocaleLocaleManager_private_offset);
}

static void
switchboard_plug_locale_locale_manager_on_settings_changed (SwitchboardPlugLocaleLocaleManager* self,
                                                            const gchar* key)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_KEY_INPUT_SELETION) == 0) {
		GVariant* map_array = NULL;
		GSettings* _tmp0_;
		GVariant* _tmp1_;
		GVariantIter* iter = NULL;
		GVariant* _tmp2_;
		GVariantIter* _tmp3_;
		gchar* k = NULL;
		gchar* value = NULL;
		GeeHashMap* map = NULL;
		GeeHashMap* _tmp4_;
		_tmp0_ = self->priv->settings;
		_tmp1_ = g_settings_get_value (_tmp0_, SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_KEY_INPUT_SELETION);
		map_array = _tmp1_;
		_tmp2_ = map_array;
		_tmp3_ = g_variant_iter_new (_tmp2_);
		iter = _tmp3_;
		k = NULL;
		value = NULL;
		_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		map = _tmp4_;
		while (TRUE) {
			GVariantIter* _tmp5_;
			GeeHashMap* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp5_ = iter;
			if (!g_variant_iter_next (_tmp5_, "(ss)", &k, &value, NULL)) {
				break;
			}
			_tmp6_ = map;
			_tmp7_ = k;
			_tmp8_ = value;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _tmp7_, _tmp8_);
		}
		_g_object_unref0 (map);
		_g_free0 (value);
		_g_free0 (k);
		_g_variant_iter_free0 (iter);
		_g_variant_unref0 (map_array);
	}
}

void
switchboard_plug_locale_locale_manager_set_user_language (SwitchboardPlugLocaleLocaleManager* self,
                                                          const gchar* language)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (language != NULL);
	g_debug ("LocaleManager.vala:108: Setting user language to %s", language);
	{
		AccountProxy* _tmp0_;
		_tmp0_ = self->priv->account_proxy;
		account_proxy_set_language (_tmp0_, language, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("LocaleManager.vala:113: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gchar*
switchboard_plug_locale_locale_manager_get_user_language (SwitchboardPlugLocaleLocaleManager* self)
{
	gchar* lang = NULL;
	AccountProxy* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->account_proxy;
	_tmp1_ = account_proxy_get_language (_tmp0_);
	_tmp2_ = _tmp1_;
	lang = _tmp2_;
	_tmp3_ = lang;
	if (!string_contains (_tmp3_, ".UTF-8")) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = lang;
		_tmp5_ = g_strconcat (_tmp4_, ".UTF-8", NULL);
		_g_free0 (lang);
		lang = _tmp5_;
	}
	result = lang;
	return result;
}

void
switchboard_plug_locale_locale_manager_set_user_format (SwitchboardPlugLocaleLocaleManager* self,
                                                        const gchar* language)
{
	GSettings* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (language != NULL);
	g_debug ("LocaleManager.vala:129: Setting user format to %s", language);
	{
		AccountProxy* _tmp0_;
		_tmp0_ = self->priv->account_proxy;
		account_proxy_set_formats_locale (_tmp0_, language, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("LocaleManager.vala:134: Error setting formats on AccountsService: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = self->priv->locale_settings;
	g_settings_set_string (_tmp3_, "region", language);
}

gchar*
switchboard_plug_locale_locale_manager_get_user_format (SwitchboardPlugLocaleLocaleManager* self)
{
	gboolean _tmp0_ = FALSE;
	AccountProxy* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gchar* user_format = NULL;
	GSettings* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* monetary = NULL;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar* _tmp22_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->account_proxy;
	_tmp2_ = account_proxy_get_formats_locale (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ != NULL;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		AccountProxy* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = self->priv->account_proxy;
		_tmp7_ = account_proxy_get_formats_locale (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp0_ = g_strcmp0 (_tmp9_, "") != 0;
		_g_free0 (_tmp9_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		AccountProxy* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = self->priv->account_proxy;
		_tmp11_ = account_proxy_get_formats_locale (_tmp10_);
		_tmp12_ = _tmp11_;
		result = _tmp12_;
		return result;
	}
	_tmp13_ = self->priv->locale_settings;
	_tmp14_ = g_settings_get_string (_tmp13_, "region");
	user_format = _tmp14_;
	_tmp15_ = user_format;
	if (g_strcmp0 (_tmp15_, "") != 0) {
		result = user_format;
		return result;
	}
	_tmp16_ = setlocale (LC_MONETARY, NULL);
	_tmp17_ = g_strdup (_tmp16_);
	monetary = _tmp17_;
	_tmp18_ = monetary;
	if (_tmp18_ != NULL) {
		result = monetary;
		_g_free0 (user_format);
		return result;
	}
	_tmp20_ = switchboard_plug_locale_locale_manager_get_system_locale (self);
	_tmp19_ = _tmp20_;
	if (_tmp19_ == NULL) {
		gchar* _tmp21_;
		_tmp21_ = g_strdup ("en_US.UTF-8");
		_g_free0 (_tmp19_);
		_tmp19_ = _tmp21_;
	}
	_tmp22_ = _tmp19_;
	_tmp19_ = NULL;
	result = _tmp22_;
	_g_free0 (_tmp19_);
	_g_free0 (monetary);
	_g_free0 (user_format);
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
switchboard_plug_locale_locale_manager_localectl_set_locale (SwitchboardPlugLocaleLocaleManager* self,
                                                             const gchar* locale,
                                                             const gchar* format,
                                                             GError** error)
{
	PolkitPermission* _tmp0_;
	PolkitPermission* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (locale != NULL);
	g_debug ("LocaleManager.vala:171: setting system-wide locale via localectl");
	_tmp0_ = switchboard_plug_locale_utils_get_permission ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_permission_get_allowed ((GPermission*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		gchar* output = NULL;
		gint status = 0;
		gchar* cli = NULL;
		gchar* _tmp5_;
		gchar* command = NULL;
		gchar* _tmp6_;
		_tmp5_ = g_strdup ("/usr/bin/localectl");
		cli = _tmp5_;
		_tmp6_ = g_strdup ("set-locale");
		command = _tmp6_;
		{
			if (format == NULL) {
				gchar* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar** _tmp13_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				gchar** _tmp15_;
				gchar** _tmp16_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				gchar* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				const gchar* _tmp20_;
				_tmp7_ = g_strdup ("pkexec");
				_tmp8_ = cli;
				_tmp9_ = g_strdup (_tmp8_);
				_tmp10_ = command;
				_tmp11_ = g_strdup (_tmp10_);
				_tmp12_ = g_strdup (locale);
				_tmp13_ = g_new0 (gchar*, 4 + 1);
				_tmp13_[0] = _tmp7_;
				_tmp13_[1] = _tmp9_;
				_tmp13_[2] = _tmp11_;
				_tmp13_[3] = _tmp12_;
				_tmp14_ = _tmp13_;
				_tmp14__length1 = 4;
				_tmp16_ = _tmp15_ = g_get_environ ();
				_tmp17_ = _tmp16_;
				_tmp17__length1 = _vala_array_length (_tmp15_);
				g_spawn_sync (NULL, _tmp14_, _tmp17_, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp18_, NULL, &_tmp19_, &_inner_error0_);
				_g_free0 (output);
				output = _tmp18_;
				status = _tmp19_;
				_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
				_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp20_ = output;
				if (g_strcmp0 (_tmp20_, "") != 0) {
					g_critical ("LocaleManager.vala:187: localectl failed to set locale");
				}
			} else {
				gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar** _tmp31_;
				gchar** _tmp32_;
				gint _tmp32__length1;
				gchar** _tmp33_;
				gchar** _tmp34_;
				gchar** _tmp35_;
				gint _tmp35__length1;
				gchar* _tmp36_ = NULL;
				gint _tmp37_ = 0;
				const gchar* _tmp38_;
				_tmp21_ = g_strdup ("pkexec");
				_tmp22_ = cli;
				_tmp23_ = g_strdup (_tmp22_);
				_tmp24_ = command;
				_tmp25_ = g_strdup (_tmp24_);
				_tmp26_ = g_strdup (locale);
				_tmp27_ = g_strdup_printf ("LC_TIME=%s", format);
				_tmp28_ = g_strdup_printf ("LC_NUMERIC=%s", format);
				_tmp29_ = g_strdup_printf ("LC_MONETARY=%s", format);
				_tmp30_ = g_strdup_printf ("LC_MEASUREMENT=%s", format);
				_tmp31_ = g_new0 (gchar*, 8 + 1);
				_tmp31_[0] = _tmp21_;
				_tmp31_[1] = _tmp23_;
				_tmp31_[2] = _tmp25_;
				_tmp31_[3] = _tmp26_;
				_tmp31_[4] = _tmp27_;
				_tmp31_[5] = _tmp28_;
				_tmp31_[6] = _tmp29_;
				_tmp31_[7] = _tmp30_;
				_tmp32_ = _tmp31_;
				_tmp32__length1 = 8;
				_tmp34_ = _tmp33_ = g_get_environ ();
				_tmp35_ = _tmp34_;
				_tmp35__length1 = _vala_array_length (_tmp33_);
				g_spawn_sync (NULL, _tmp32_, _tmp35_, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp36_, NULL, &_tmp37_, &_inner_error0_);
				_g_free0 (output);
				output = _tmp36_;
				status = _tmp37_;
				_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_free), NULL);
				_tmp32_ = (_vala_array_free (_tmp32_, _tmp32__length1, (GDestroyNotify) g_free), NULL);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp38_ = output;
				if (g_strcmp0 (_tmp38_, "") != 0) {
					g_critical ("LocaleManager.vala:199: localectl failed to set locale");
				}
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp39_;
			GError* _tmp40_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			g_critical ("LocaleManager.vala:203: localectl failed to set locale");
			_tmp39_ = e;
			_tmp40_ = _g_error_copy0 (_tmp39_);
			_inner_error0_ = _tmp40_;
			_g_error_free0 (e);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (command);
			_g_free0 (cli);
			_g_free0 (output);
			return;
		}
		_g_free0 (command);
		_g_free0 (cli);
		_g_free0 (output);
	}
}

static void
switchboard_plug_locale_locale_manager_localectl_set_x11_keymap (SwitchboardPlugLocaleLocaleManager* self,
                                                                 const gchar* layouts,
                                                                 const gchar* variants,
                                                                 GError** error)
{
	PolkitPermission* _tmp0_;
	PolkitPermission* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layouts != NULL);
	g_return_if_fail (variants != NULL);
	_tmp0_ = switchboard_plug_locale_utils_get_permission ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_permission_get_allowed ((GPermission*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		gchar* output = NULL;
		gint status = 0;
		gchar* cli = NULL;
		gchar* _tmp5_;
		gchar* command = NULL;
		gchar* _tmp6_;
		_tmp5_ = g_strdup ("/usr/bin/localectl");
		cli = _tmp5_;
		_tmp6_ = g_strdup ("set-x11-keymap");
		command = _tmp6_;
		{
			gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar** _tmp15_;
			gchar** _tmp16_;
			gint _tmp16__length1;
			gchar** _tmp17_;
			gchar** _tmp18_;
			gchar** _tmp19_;
			gint _tmp19__length1;
			gchar* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			const gchar* _tmp22_;
			_tmp7_ = g_strdup ("pkexec");
			_tmp8_ = cli;
			_tmp9_ = g_strdup (_tmp8_);
			_tmp10_ = command;
			_tmp11_ = g_strdup (_tmp10_);
			_tmp12_ = g_strdup (layouts);
			_tmp13_ = g_strdup ("");
			_tmp14_ = g_strdup (variants);
			_tmp15_ = g_new0 (gchar*, 6 + 1);
			_tmp15_[0] = _tmp7_;
			_tmp15_[1] = _tmp9_;
			_tmp15_[2] = _tmp11_;
			_tmp15_[3] = _tmp12_;
			_tmp15_[4] = _tmp13_;
			_tmp15_[5] = _tmp14_;
			_tmp16_ = _tmp15_;
			_tmp16__length1 = 6;
			_tmp18_ = _tmp17_ = g_get_environ ();
			_tmp19_ = _tmp18_;
			_tmp19__length1 = _vala_array_length (_tmp17_);
			g_spawn_sync (NULL, _tmp16_, _tmp19_, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp20_, NULL, &_tmp21_, &_inner_error0_);
			_g_free0 (output);
			output = _tmp20_;
			status = _tmp21_;
			_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
			_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp22_ = output;
			if (g_strcmp0 (_tmp22_, "") != 0) {
				g_critical ("LocaleManager.vala:225: localectl failed to set x11 keymap");
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp23_;
			GError* _tmp24_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			g_critical ("LocaleManager.vala:228: localectl failed to set x11 keymap");
			_tmp23_ = e;
			_tmp24_ = _g_error_copy0 (_tmp23_);
			_inner_error0_ = _tmp24_;
			_g_error_free0 (e);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (command);
			_g_free0 (cli);
			_g_free0 (output);
			return;
		}
		_g_free0 (command);
		_g_free0 (cli);
		_g_free0 (output);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
switchboard_plug_locale_locale_manager_get_system_locale (SwitchboardPlugLocaleLocaleManager* self)
{
	Locale1Proxy* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->locale1_proxy;
	_tmp1_ = locale1_proxy_get_locale (_tmp0_, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	{
		gchar** locale_collection = NULL;
		gint locale_collection_length1 = 0;
		gint _locale_collection_size_ = 0;
		gint locale_it = 0;
		locale_collection = _tmp3_;
		locale_collection_length1 = _tmp3__length1;
		for (locale_it = 0; locale_it < locale_collection_length1; locale_it = locale_it + 1) {
			const gchar* locale = NULL;
			locale = locale_collection[locale_it];
			{
				const gchar* _tmp4_;
				_tmp4_ = locale;
				if (g_str_has_prefix (_tmp4_, "LANG=")) {
					const gchar* _tmp5_;
					gchar* _tmp6_;
					_tmp5_ = locale;
					_tmp6_ = string_replace (_tmp5_, "LANG=", "");
					result = _tmp6_;
					locale_collection = (_vala_array_free (locale_collection, locale_collection_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
		locale_collection = (_vala_array_free (locale_collection, locale_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = NULL;
	return result;
}

void
switchboard_plug_locale_locale_manager_apply_to_system (SwitchboardPlugLocaleLocaleManager* self,
                                                        const gchar* language,
                                                        const gchar* format)
{
	gchar* layouts = NULL;
	gchar* _tmp4_;
	gchar* variants = NULL;
	gchar* _tmp5_;
	gchar* l = NULL;
	gchar* v = NULL;
	GVariant* variant = NULL;
	GSettings* _tmp6_;
	GVariant* _tmp7_;
	gint nr_keymaps = 0;
	GVariant* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (language != NULL);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_strdup_printf ("LANG=%s", language);
		_tmp1_ = _tmp0_;
		switchboard_plug_locale_locale_manager_localectl_set_locale (self, _tmp1_, format, &_inner_error0_);
		_g_free0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("LocaleManager.vala:256: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = g_strdup ("");
	layouts = _tmp4_;
	_tmp5_ = g_strdup ("");
	variants = _tmp5_;
	_tmp6_ = self->priv->input_settings;
	_tmp7_ = g_settings_get_value (_tmp6_, SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_KEY_INPUT_SOURCES);
	variant = _tmp7_;
	_tmp8_ = variant;
	nr_keymaps = (gint) g_variant_n_children (_tmp8_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				GVariant* entry = NULL;
				GVariant* _tmp11_;
				GVariant* _tmp12_;
				gchar* code = NULL;
				GVariant* _tmp13_;
				GVariant* _tmp14_;
				GVariant* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				GnomeXkbInfo* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				gchar* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				if (!(i < nr_keymaps)) {
					break;
				}
				_tmp11_ = variant;
				_tmp12_ = g_variant_get_child_value (_tmp11_, (gsize) i);
				entry = _tmp12_;
				_tmp13_ = entry;
				_tmp14_ = g_variant_get_child_value (_tmp13_, (gsize) 1);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_variant_get_string (_tmp15_, NULL);
				_tmp17_ = g_strdup (_tmp16_);
				_tmp18_ = _tmp17_;
				_g_variant_unref0 (_tmp15_);
				code = _tmp18_;
				_tmp19_ = self->priv->xkbinfo;
				_tmp20_ = code;
				gnome_xkb_info_get_layout_info (_tmp19_, _tmp20_, NULL, NULL, &_tmp21_, &_tmp22_);
				_g_free0 (l);
				_tmp23_ = g_strdup (_tmp21_);
				l = _tmp23_;
				_g_free0 (v);
				_tmp24_ = g_strdup (_tmp22_);
				v = _tmp24_;
				_tmp25_ = layouts;
				_tmp26_ = l;
				_tmp27_ = g_strconcat (_tmp25_, _tmp26_, NULL);
				_g_free0 (layouts);
				layouts = _tmp27_;
				_tmp28_ = variants;
				_tmp29_ = v;
				_tmp30_ = g_strconcat (_tmp28_, _tmp29_, NULL);
				_g_free0 (variants);
				variants = _tmp30_;
				if (i < (nr_keymaps - 1)) {
					const gchar* _tmp31_;
					gchar* _tmp32_;
					const gchar* _tmp33_;
					gchar* _tmp34_;
					_tmp31_ = layouts;
					_tmp32_ = g_strconcat (_tmp31_, ",", NULL);
					_g_free0 (layouts);
					layouts = _tmp32_;
					_tmp33_ = variants;
					_tmp34_ = g_strconcat (_tmp33_, ",", NULL);
					_g_free0 (variants);
					variants = _tmp34_;
				}
				_g_free0 (code);
				_g_variant_unref0 (entry);
			}
		}
	}
	{
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		_tmp35_ = layouts;
		_tmp36_ = variants;
		switchboard_plug_locale_locale_manager_localectl_set_x11_keymap (self, _tmp35_, _tmp36_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp37_;
		const gchar* _tmp38_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp37_ = e;
		_tmp38_ = _tmp37_->message;
		g_warning ("LocaleManager.vala:288: %s", _tmp38_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_variant_unref0 (variant);
		_g_free0 (v);
		_g_free0 (l);
		_g_free0 (variants);
		_g_free0 (layouts);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_variant_unref0 (variant);
	_g_free0 (v);
	_g_free0 (l);
	_g_free0 (variants);
	_g_free0 (layouts);
}

SwitchboardPlugLocaleLocaleManager*
switchboard_plug_locale_locale_manager_get_default (void)
{
	SwitchboardPlugLocaleLocaleManager* _tmp0_;
	SwitchboardPlugLocaleLocaleManager* _tmp2_;
	SwitchboardPlugLocaleLocaleManager* result;
	_tmp0_ = switchboard_plug_locale_locale_manager_instance;
	if (_tmp0_ == NULL) {
		SwitchboardPlugLocaleLocaleManager* _tmp1_;
		_tmp1_ = switchboard_plug_locale_locale_manager_new ();
		_g_object_unref0 (switchboard_plug_locale_locale_manager_instance);
		switchboard_plug_locale_locale_manager_instance = _tmp1_;
	}
	_tmp2_ = switchboard_plug_locale_locale_manager_instance;
	result = _tmp2_;
	return result;
}

SwitchboardPlugLocaleLocaleManager*
switchboard_plug_locale_locale_manager_construct (GType object_type)
{
	SwitchboardPlugLocaleLocaleManager * self = NULL;
	self = (SwitchboardPlugLocaleLocaleManager*) g_object_new (object_type, NULL);
	return self;
}

SwitchboardPlugLocaleLocaleManager*
switchboard_plug_locale_locale_manager_new (void)
{
	return switchboard_plug_locale_locale_manager_construct (SWITCHBOARD_PLUG_LOCALE_TYPE_LOCALE_MANAGER);
}

gboolean
switchboard_plug_locale_locale_manager_get_is_connected (SwitchboardPlugLocaleLocaleManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_connected;
	return result;
}

static void
switchboard_plug_locale_locale_manager_set_is_connected (SwitchboardPlugLocaleLocaleManager* self,
                                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_locale_locale_manager_get_is_connected (self);
	if (old_value != value) {
		self->priv->_is_connected = value;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_locale_manager_properties[SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_IS_CONNECTED_PROPERTY]);
	}
}

static void
_switchboard_plug_locale_locale_manager_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                                const gchar* key,
                                                                                gpointer self)
{
	switchboard_plug_locale_locale_manager_on_settings_changed ((SwitchboardPlugLocaleLocaleManager*) self, key);
}

static GObject *
switchboard_plug_locale_locale_manager_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardPlugLocaleLocaleManager * self;
	GnomeXkbInfo* _tmp0_;
	guint uid = 0U;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp17_;
	GSettings* _tmp18_;
	gboolean _tmp19_ = FALSE;
	AccountProxy* _tmp20_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (switchboard_plug_locale_locale_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_TYPE_LOCALE_MANAGER, SwitchboardPlugLocaleLocaleManager);
	_tmp0_ = gnome_xkb_info_new ();
	_g_object_unref0 (self->priv->xkbinfo);
	self->priv->xkbinfo = _tmp0_;
	uid = (guint) getuid ();
	_tmp1_ = g_settings_new (SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_GNOME_DESKTOP_INPUT_SOURCES);
	_g_object_unref0 (self->priv->input_settings);
	self->priv->input_settings = _tmp1_;
	_tmp2_ = g_settings_new (SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_GNOME_LOCALE_KEY);
	_g_object_unref0 (self->priv->locale_settings);
	self->priv->locale_settings = _tmp2_;
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp3_;
		Locale1Proxy* _tmp4_ = NULL;
		GDBusConnection* _tmp5_;
		Locale1Proxy* _tmp6_;
		Locale1Proxy* _tmp7_;
		AccountProxy* _tmp8_ = NULL;
		GDBusConnection* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		AccountProxy* _tmp12_;
		AccountProxy* _tmp13_;
		AccountProxy* _tmp14_;
		_tmp3_ = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &_inner_error0_);
		connection = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp5_ = connection;
		_tmp6_ = (Locale1Proxy*) g_initable_new (TYPE_LOCALE1_PROXY_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", "org.freedesktop.locale1", "g-connection", _tmp5_, "g-object-path", "/org/freedesktop/locale1", "g-interface-name", "org.freedesktop.locale1", NULL);
		_tmp4_ = (Locale1Proxy*) _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (connection);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (self->priv->locale1_proxy);
		self->priv->locale1_proxy = _tmp7_;
		_tmp9_ = connection;
		_tmp10_ = g_strdup_printf ("/org/freedesktop/Accounts/User%u", uid);
		_tmp11_ = _tmp10_;
		_tmp12_ = (AccountProxy*) g_initable_new (TYPE_ACCOUNT_PROXY_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", "org.freedesktop.Accounts", "g-connection", _tmp9_, "g-object-path", _tmp11_, "g-interface-name", "org.freedesktop.Accounts.User", NULL);
		_tmp13_ = (AccountProxy*) _tmp12_;
		_g_free0 (_tmp11_);
		_tmp8_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp4_);
			_g_object_unref0 (connection);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp14_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (self->priv->account_proxy);
		self->priv->account_proxy = _tmp14_;
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (connection);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_critical ("LocaleManager.vala:79: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp17_ = g_settings_new ("io.elementary.switchboard.locale");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp17_;
	_tmp18_ = self->priv->settings;
	g_signal_connect_object (_tmp18_, "changed", (GCallback) _switchboard_plug_locale_locale_manager_on_settings_changed_g_settings_changed, self, 0);
	_tmp20_ = self->priv->account_proxy;
	if (_tmp20_ != NULL) {
		Locale1Proxy* _tmp21_;
		_tmp21_ = self->priv->locale1_proxy;
		_tmp19_ = _tmp21_ != NULL;
	} else {
		_tmp19_ = FALSE;
	}
	switchboard_plug_locale_locale_manager_set_is_connected (self, _tmp19_);
	return obj;
}

static void
switchboard_plug_locale_locale_manager_class_init (SwitchboardPlugLocaleLocaleManagerClass * klass,
                                                   gpointer klass_data)
{
	switchboard_plug_locale_locale_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugLocaleLocaleManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_plug_locale_locale_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_plug_locale_locale_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = switchboard_plug_locale_locale_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_locale_locale_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_IS_CONNECTED_PROPERTY, switchboard_plug_locale_locale_manager_properties[SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_IS_CONNECTED_PROPERTY] = g_param_spec_boolean ("is-connected", "is-connected", "is-connected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
switchboard_plug_locale_locale_manager_instance_init (SwitchboardPlugLocaleLocaleManager * self,
                                                      gpointer klass)
{
	self->priv = switchboard_plug_locale_locale_manager_get_instance_private (self);
	self->priv->_is_connected = FALSE;
}

static void
switchboard_plug_locale_locale_manager_finalize (GObject * obj)
{
	SwitchboardPlugLocaleLocaleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_TYPE_LOCALE_MANAGER, SwitchboardPlugLocaleLocaleManager);
	_g_object_unref0 (self->priv->locale1_proxy);
	_g_object_unref0 (self->priv->account_proxy);
	_g_object_unref0 (self->priv->input_settings);
	_g_object_unref0 (self->priv->locale_settings);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->xkbinfo);
	G_OBJECT_CLASS (switchboard_plug_locale_locale_manager_parent_class)->finalize (obj);
}

static GType
switchboard_plug_locale_locale_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugLocaleLocaleManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_locale_locale_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugLocaleLocaleManager), 0, (GInstanceInitFunc) switchboard_plug_locale_locale_manager_instance_init, NULL };
	GType switchboard_plug_locale_locale_manager_type_id;
	switchboard_plug_locale_locale_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "SwitchboardPlugLocaleLocaleManager", &g_define_type_info, 0);
	SwitchboardPlugLocaleLocaleManager_private_offset = g_type_add_instance_private (switchboard_plug_locale_locale_manager_type_id, sizeof (SwitchboardPlugLocaleLocaleManagerPrivate));
	return switchboard_plug_locale_locale_manager_type_id;
}

GType
switchboard_plug_locale_locale_manager_get_type (void)
{
	static volatile gsize switchboard_plug_locale_locale_manager_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_locale_locale_manager_type_id__once)) {
		GType switchboard_plug_locale_locale_manager_type_id;
		switchboard_plug_locale_locale_manager_type_id = switchboard_plug_locale_locale_manager_get_type_once ();
		g_once_init_leave (&switchboard_plug_locale_locale_manager_type_id__once, switchboard_plug_locale_locale_manager_type_id);
	}
	return switchboard_plug_locale_locale_manager_type_id__once;
}

static void
_vala_switchboard_plug_locale_locale_manager_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	SwitchboardPlugLocaleLocaleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_LOCALE_TYPE_LOCALE_MANAGER, SwitchboardPlugLocaleLocaleManager);
	switch (property_id) {
		case SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_IS_CONNECTED_PROPERTY:
		g_value_set_boolean (value, switchboard_plug_locale_locale_manager_get_is_connected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_plug_locale_locale_manager_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	SwitchboardPlugLocaleLocaleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_LOCALE_TYPE_LOCALE_MANAGER, SwitchboardPlugLocaleLocaleManager);
	switch (property_id) {
		case SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_IS_CONNECTED_PROPERTY:
		switchboard_plug_locale_locale_manager_set_is_connected (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

