/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.env;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.AccessRule;

public class AccessRuleSet {
    private AccessRule[] accessRules;
    public byte classpathEntryType;
    public String classpathEntryName;

    public AccessRuleSet(AccessRule[] accessRuleArray, byte by, String string) {
        this.accessRules = accessRuleArray;
        this.classpathEntryType = by;
        this.classpathEntryName = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccessRuleSet)) {
            return false;
        }
        AccessRuleSet accessRuleSet = (AccessRuleSet)object;
        if (this.classpathEntryType != accessRuleSet.classpathEntryType || this.classpathEntryName == null && accessRuleSet.classpathEntryName != null || !this.classpathEntryName.equals(accessRuleSet.classpathEntryName)) {
            return false;
        }
        int n = this.accessRules.length;
        if (n != accessRuleSet.accessRules.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.accessRules[i].equals(accessRuleSet.accessRules[i])) continue;
            return false;
        }
        return true;
    }

    public AccessRule[] getAccessRules() {
        return this.accessRules;
    }

    public AccessRestriction getViolatedRestriction(char[] cArray) {
        for (AccessRule accessRule : this.accessRules) {
            if (!CharOperation.pathMatch(accessRule.pattern, cArray, true, '/')) continue;
            switch (accessRule.getProblemId()) {
                case 0x1000118: 
                case 0x1000133: {
                    return new AccessRestriction(accessRule, this.classpathEntryType, this.classpathEntryName);
                }
            }
            return null;
        }
        return null;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.hashCode(this.accessRules);
        n = 31 * n + (this.classpathEntryName == null ? 0 : this.classpathEntryName.hashCode());
        n = 31 * n + this.classpathEntryType;
        return n;
    }

    private int hashCode(AccessRule[] accessRuleArray) {
        if (accessRuleArray == null) {
            return 0;
        }
        int n = 1;
        int n2 = accessRuleArray.length;
        for (int i = 0; i < n2; ++i) {
            n = 31 * n + (accessRuleArray[i] == null ? 0 : accessRuleArray[i].hashCode());
        }
        return n;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("AccessRuleSet {");
        if (bl) {
            stringBuilder.append('\n');
        }
        int n = this.accessRules.length;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                stringBuilder.append('\t');
            }
            AccessRule accessRule = this.accessRules[i];
            stringBuilder.append(accessRule);
            if (bl) {
                stringBuilder.append('\n');
                continue;
            }
            if (i >= n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("} [classpath entry: ");
        stringBuilder.append(this.classpathEntryName);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

