/* deleter.c generated by valac 0.56.3, the Vala compiler
 * generated from deleter.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2016 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Author: Stef Walter <stefw@collabora.co.uk>
 */

#include "seahorse-ssh.h"
#include <glib.h>
#include "seahorse-common.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>

enum  {
	SEAHORSE_SSH_DELETER_0_PROPERTY,
	SEAHORSE_SSH_DELETER_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_deleter_properties[SEAHORSE_SSH_DELETER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SeahorseSshDeleterDeleteData SeahorseSshDeleterDeleteData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SeahorseSshDeleterPrivate {
	gboolean have_private;
	GList* keys;
};

struct _SeahorseSshDeleterDeleteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSshDeleter* self;
	GCancellable* cancellable;
	gboolean result;
	GList* _tmp0_;
	GList* key_collection;
	GList* key_it;
	SeahorseSshKey* _tmp1_;
	SeahorseSshKey* key;
	SeahorseSshKey* _tmp2_;
	GError* _inner_error0_;
};

static gint SeahorseSshDeleter_private_offset;
static gpointer seahorse_ssh_deleter_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GtkDialog* seahorse_ssh_deleter_real_create_confirm (SeahorseDeleter* base,
                                                     GtkWindow* parent);
static GList* seahorse_ssh_deleter_real_get_objects (SeahorseDeleter* base);
static gboolean seahorse_ssh_deleter_real_add_object (SeahorseDeleter* base,
                                               GObject* object);
static void seahorse_ssh_deleter_real_delete_data_free (gpointer _data);
static void seahorse_ssh_deleter_real_delete (SeahorseDeleter* base,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static gboolean seahorse_ssh_deleter_real_delete_co (SeahorseSshDeleterDeleteData* _data_);
static void seahorse_ssh_deleter_finalize (GObject * obj);
static GType seahorse_ssh_deleter_get_type_once (void);

static inline gpointer
seahorse_ssh_deleter_get_instance_private (SeahorseSshDeleter* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseSshDeleter_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

SeahorseSshDeleter*
seahorse_ssh_deleter_construct (GType object_type,
                                SeahorseSshKey* key)
{
	SeahorseSshDeleter * self = NULL;
	g_return_val_if_fail (key != NULL, NULL);
	self = (SeahorseSshDeleter*) seahorse_deleter_construct (object_type);
	if (!seahorse_deleter_add_object ((SeahorseDeleter*) self, (GObject*) key)) {
		g_assert_not_reached ();
	}
	return self;
}

SeahorseSshDeleter*
seahorse_ssh_deleter_new (SeahorseSshKey* key)
{
	return seahorse_ssh_deleter_construct (SEAHORSE_SSH_TYPE_DELETER, key);
}

static GtkDialog*
seahorse_ssh_deleter_real_create_confirm (SeahorseDeleter* base,
                                          GtkWindow* parent)
{
	SeahorseSshDeleter * self;
	guint num = 0U;
	GList* _tmp0_;
	gchar* confirm = NULL;
	gchar* prompt = NULL;
	SeahorseDeleteDialog* dialog = NULL;
	const gchar* _tmp13_;
	SeahorseDeleteDialog* _tmp14_;
	const gchar* _tmp15_;
	GtkDialog* result;
	self = (SeahorseSshDeleter*) base;
	_tmp0_ = self->priv->keys;
	num = g_list_length (_tmp0_);
	if (self->priv->have_private) {
		GList* _tmp1_;
		gconstpointer _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_vala_assert (num == ((guint) 1), "num == 1");
		_tmp1_ = self->priv->keys;
		_tmp2_ = _tmp1_->data;
		_tmp3_ = seahorse_object_get_label ((SeahorseObject*) ((SeahorseSshKey*) _tmp2_));
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf (_ ("Are you sure you want to delete the secure shell key “%s”?"), _tmp4_);
		_g_free0 (prompt);
		prompt = _tmp5_;
		_tmp6_ = g_strdup (_ ("I understand that this secret key will be permanently deleted."));
		_g_free0 (confirm);
		confirm = _tmp6_;
	} else {
		if (num == ((guint) 1)) {
			GList* _tmp7_;
			gconstpointer _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp7_ = self->priv->keys;
			_tmp8_ = _tmp7_->data;
			_tmp9_ = seahorse_object_get_label ((SeahorseObject*) ((SeahorseSshKey*) _tmp8_));
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strdup_printf (_ ("Are you sure you want to delete the secure shell key “%s”?"), _tmp10_);
			_g_free0 (prompt);
			prompt = _tmp11_;
			_g_free0 (confirm);
			confirm = NULL;
		} else {
			gchar* _tmp12_;
			_tmp12_ = g_strdup_printf (ngettext ("Are you sure you want to delete %u secure shell key?", "Are you sure you want to delete %u secure shell keys?", (gulong) num), num);
			_g_free0 (prompt);
			prompt = _tmp12_;
			_g_free0 (confirm);
			confirm = NULL;
		}
	}
	_tmp13_ = prompt;
	_tmp14_ = (SeahorseDeleteDialog*) seahorse_delete_dialog_new (parent, "%s", _tmp13_, NULL);
	g_object_ref_sink (_tmp14_);
	dialog = _tmp14_;
	_tmp15_ = confirm;
	if (_tmp15_ != NULL) {
		SeahorseDeleteDialog* _tmp16_;
		const gchar* _tmp17_;
		SeahorseDeleteDialog* _tmp18_;
		_tmp16_ = dialog;
		_tmp17_ = confirm;
		seahorse_delete_dialog_set_check_label (_tmp16_, _tmp17_);
		_tmp18_ = dialog;
		seahorse_delete_dialog_set_check_require (_tmp18_, TRUE);
	}
	result = (GtkDialog*) dialog;
	_g_free0 (prompt);
	_g_free0 (confirm);
	return result;
}

static GList*
seahorse_ssh_deleter_real_get_objects (SeahorseDeleter* base)
{
	SeahorseSshDeleter * self;
	GList* _tmp0_;
	GList* result;
	self = (SeahorseSshDeleter*) base;
	_tmp0_ = self->priv->keys;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
seahorse_ssh_deleter_real_add_object (SeahorseDeleter* base,
                                      GObject* object)
{
	SeahorseSshDeleter * self;
	SeahorseSshKey* key = NULL;
	SeahorseSshKey* _tmp0_;
	gboolean _tmp1_ = FALSE;
	SeahorseSshKey* _tmp3_;
	SeahorseUsage _tmp4_;
	SeahorseUsage _tmp5_;
	SeahorseSshKey* _tmp7_;
	SeahorseSshKey* _tmp8_;
	gboolean result;
	self = (SeahorseSshDeleter*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (SEAHORSE_SSH_IS_KEY (object) ? ((SeahorseSshKey*) object) : NULL);
	key = _tmp0_;
	if (self->priv->have_private) {
		_tmp1_ = TRUE;
	} else {
		SeahorseSshKey* _tmp2_;
		_tmp2_ = key;
		_tmp1_ = _tmp2_ == NULL;
	}
	if (_tmp1_) {
		result = FALSE;
		_g_object_unref0 (key);
		return result;
	}
	_tmp3_ = key;
	_tmp4_ = seahorse_object_get_usage ((SeahorseObject*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == SEAHORSE_USAGE_PRIVATE_KEY) {
		GList* _tmp6_;
		_tmp6_ = self->priv->keys;
		if (_tmp6_ != NULL) {
			result = FALSE;
			_g_object_unref0 (key);
			return result;
		}
		self->priv->have_private = TRUE;
	}
	_tmp7_ = key;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	self->priv->keys = g_list_append (self->priv->keys, _tmp8_);
	result = TRUE;
	_g_object_unref0 (key);
	return result;
}

static void
seahorse_ssh_deleter_real_delete_data_free (gpointer _data)
{
	SeahorseSshDeleterDeleteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseSshDeleterDeleteData, _data_);
}

static void
seahorse_ssh_deleter_real_delete (SeahorseDeleter* base,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	SeahorseSshDeleter * self;
	SeahorseSshDeleterDeleteData* _data_;
	SeahorseSshDeleter* _tmp0_;
	GCancellable* _tmp1_;
	self = (SeahorseSshDeleter*) base;
	_data_ = g_slice_new0 (SeahorseSshDeleterDeleteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_ssh_deleter_real_delete_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	seahorse_ssh_deleter_real_delete_co (_data_);
}

static gboolean
seahorse_ssh_deleter_delete_finish (SeahorseDeleter* base,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	gboolean result;
	SeahorseSshDeleterDeleteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static gboolean
seahorse_ssh_deleter_real_delete_co (SeahorseSshDeleterDeleteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->keys;
	{
		_data_->key_collection = _data_->_tmp0_;
		for (_data_->key_it = _data_->key_collection; _data_->key_it != NULL; _data_->key_it = _data_->key_it->next) {
			_data_->_tmp1_ = _g_object_ref0 ((SeahorseSshKey*) _data_->key_it->data);
			_data_->key = _data_->_tmp1_;
			{
				_data_->_tmp2_ = _data_->key;
				seahorse_ssh_deleter_delete_key (_data_->self, _data_->_tmp2_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->key);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_object_unref0 (_data_->key);
			}
		}
	}
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Deletes a given key.
     *
     * @param key The key that should be deleted.
     */
void
seahorse_ssh_deleter_delete_key (SeahorseSshDeleter* self,
                                 SeahorseSshKey* key,
                                 GError** error)
{
	SeahorseSshKeyData* keydata = NULL;
	SeahorseSshKeyData* _tmp0_;
	SeahorseSshKeyData* _tmp1_;
	SeahorseSshKeyData* _tmp2_;
	SeahorseSshKeyData* _tmp3_;
	SeahorseSshKeyData* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	SeahorseSshSource* source = NULL;
	SeahorsePlace* _tmp41_;
	SeahorsePlace* _tmp42_;
	SeahorseSshSource* _tmp43_;
	SeahorseSshSource* _tmp44_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = seahorse_ssh_key_get_key_data (key);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	keydata = _tmp2_;
	_tmp3_ = keydata;
	if (_tmp3_ == NULL) {
		GError* _tmp4_;
		_tmp4_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, "Can't delete key with empty KeyData.");
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (keydata);
		return;
	}
	_tmp5_ = keydata;
	_tmp6_ = seahorse_ssh_key_data_get_partial (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		SeahorseSshKeyData* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp8_ = keydata;
		_tmp9_ = seahorse_ssh_key_data_get_pubfile (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ != NULL) {
			SeahorseSshKeyData* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			SeahorseSshKeyData* _tmp14_;
			_tmp11_ = keydata;
			_tmp12_ = seahorse_ssh_key_data_get_pubfile (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = keydata;
			seahorse_ssh_key_data_filter_file (_tmp13_, NULL, _tmp14_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (keydata);
				return;
			}
		}
	} else {
		SeahorseSshKeyData* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		SeahorseSshKeyData* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		_tmp15_ = keydata;
		_tmp16_ = seahorse_ssh_key_data_get_pubfile (_tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			SeahorseSshKeyData* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = keydata;
			_tmp19_ = seahorse_ssh_key_data_get_pubfile (_tmp18_);
			_tmp20_ = _tmp19_;
			if (g_unlink (_tmp20_) == -1) {
				SeahorseSshKeyData* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				GError* _tmp26_;
				GError* _tmp27_;
				_tmp21_ = keydata;
				_tmp22_ = seahorse_ssh_key_data_get_pubfile (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strdup_printf ("Couldn't delete public key file '%s'", _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, _tmp25_);
				_tmp27_ = _tmp26_;
				_g_free0 (_tmp25_);
				_inner_error0_ = _tmp27_;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (keydata);
				return;
			}
		}
		_tmp28_ = keydata;
		_tmp29_ = seahorse_ssh_key_data_get_privfile (_tmp28_);
		_tmp30_ = _tmp29_;
		if (_tmp30_ != NULL) {
			SeahorseSshKeyData* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			_tmp31_ = keydata;
			_tmp32_ = seahorse_ssh_key_data_get_privfile (_tmp31_);
			_tmp33_ = _tmp32_;
			if (g_unlink (_tmp33_) == -1) {
				SeahorseSshKeyData* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				GError* _tmp39_;
				GError* _tmp40_;
				_tmp34_ = keydata;
				_tmp35_ = seahorse_ssh_key_data_get_privfile (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = g_strdup_printf ("Couldn't delete private key file '%s'", _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, _tmp38_);
				_tmp40_ = _tmp39_;
				_g_free0 (_tmp38_);
				_inner_error0_ = _tmp40_;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (keydata);
				return;
			}
		}
	}
	_tmp41_ = seahorse_object_get_place ((SeahorseObject*) key);
	_tmp42_ = _tmp41_;
	_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, SEAHORSE_SSH_TYPE_SOURCE, SeahorseSshSource));
	source = _tmp43_;
	_tmp44_ = source;
	seahorse_ssh_source_remove_object (_tmp44_, (GObject*) key);
	_g_object_unref0 (source);
	_g_object_unref0 (keydata);
}

static void
seahorse_ssh_deleter_class_init (SeahorseSshDeleterClass * klass,
                                 gpointer klass_data)
{
	seahorse_ssh_deleter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseSshDeleter_private_offset);
	((SeahorseDeleterClass *) klass)->create_confirm = (GtkDialog* (*) (SeahorseDeleter*, GtkWindow*)) seahorse_ssh_deleter_real_create_confirm;
	((SeahorseDeleterClass *) klass)->get_objects = (GList* (*) (SeahorseDeleter*)) seahorse_ssh_deleter_real_get_objects;
	((SeahorseDeleterClass *) klass)->add_object = (gboolean (*) (SeahorseDeleter*, GObject*)) seahorse_ssh_deleter_real_add_object;
	((SeahorseDeleterClass *) klass)->delete = (void (*) (SeahorseDeleter*, GCancellable*, GAsyncReadyCallback, gpointer)) seahorse_ssh_deleter_real_delete;
	((SeahorseDeleterClass *) klass)->delete_finish = (gboolean (*) (SeahorseDeleter*, GAsyncResult*, GError**)) seahorse_ssh_deleter_delete_finish;
	G_OBJECT_CLASS (klass)->finalize = seahorse_ssh_deleter_finalize;
}

static void
seahorse_ssh_deleter_instance_init (SeahorseSshDeleter * self,
                                    gpointer klass)
{
	self->priv = seahorse_ssh_deleter_get_instance_private (self);
}

static void
seahorse_ssh_deleter_finalize (GObject * obj)
{
	SeahorseSshDeleter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_SSH_TYPE_DELETER, SeahorseSshDeleter);
	(self->priv->keys == NULL) ? NULL : (self->priv->keys = (_g_list_free__g_object_unref0_ (self->priv->keys), NULL));
	G_OBJECT_CLASS (seahorse_ssh_deleter_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_ssh_deleter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshDeleterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_deleter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshDeleter), 0, (GInstanceInitFunc) seahorse_ssh_deleter_instance_init, NULL };
	GType seahorse_ssh_deleter_type_id;
	seahorse_ssh_deleter_type_id = g_type_register_static (SEAHORSE_TYPE_DELETER, "SeahorseSshDeleter", &g_define_type_info, 0);
	SeahorseSshDeleter_private_offset = g_type_add_instance_private (seahorse_ssh_deleter_type_id, sizeof (SeahorseSshDeleterPrivate));
	return seahorse_ssh_deleter_type_id;
}

GType
seahorse_ssh_deleter_get_type (void)
{
	static volatile gsize seahorse_ssh_deleter_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_deleter_type_id__once)) {
		GType seahorse_ssh_deleter_type_id;
		seahorse_ssh_deleter_type_id = seahorse_ssh_deleter_get_type_once ();
		g_once_init_leave (&seahorse_ssh_deleter_type_id__once, seahorse_ssh_deleter_type_id);
	}
	return seahorse_ssh_deleter_type_id__once;
}

