/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.OutputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.SignerOutputStream;

public class BcPGPContentVerifierBuilderProvider
implements PGPContentVerifierBuilderProvider {
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    public PGPContentVerifierBuilder get(int n, int n2) throws PGPException {
        return new BcPGPContentVerifierBuilder(n, n2);
    }

    private class BcPGPContentVerifierBuilder
    implements PGPContentVerifierBuilder {
        private int hashAlgorithm;
        private int keyAlgorithm;

        public BcPGPContentVerifierBuilder(int n, int n2) {
            this.keyAlgorithm = n;
            this.hashAlgorithm = n2;
        }

        public PGPContentVerifier build(final PGPPublicKey pGPPublicKey) throws PGPException {
            final Signer signer = BcImplProvider.createSigner(this.keyAlgorithm, this.hashAlgorithm);
            signer.init(false, (CipherParameters)BcPGPContentVerifierBuilderProvider.this.keyConverter.getPublicKey(pGPPublicKey));
            return new PGPContentVerifier(){

                public int getHashAlgorithm() {
                    return BcPGPContentVerifierBuilder.this.hashAlgorithm;
                }

                public int getKeyAlgorithm() {
                    return BcPGPContentVerifierBuilder.this.keyAlgorithm;
                }

                public long getKeyID() {
                    return pGPPublicKey.getKeyID();
                }

                public boolean verify(byte[] byArray) {
                    return signer.verifySignature(byArray);
                }

                public OutputStream getOutputStream() {
                    return new SignerOutputStream(signer);
                }
            };
        }
    }
}

