from typing import ClassVar

from .drawing import DeviceGray, DeviceRGB

class GraphicsStateMixin:
    DEFAULT_DRAW_COLOR: ClassVar[DeviceGray]
    DEFAULT_FILL_COLOR: ClassVar[DeviceGray]
    DEFAULT_TEXT_COLOR: ClassVar[DeviceGray]
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def draw_color(self) -> DeviceGray | DeviceRGB: ...
    @draw_color.setter
    def draw_color(self, v: DeviceGray | DeviceRGB) -> None: ...
    @property
    def fill_color(self) -> DeviceGray | DeviceRGB: ...
    @fill_color.setter
    def fill_color(self, v: DeviceGray | DeviceRGB) -> None: ...
    @property
    def text_color(self) -> DeviceGray | DeviceRGB: ...
    @text_color.setter
    def text_color(self, v: DeviceGray | DeviceRGB) -> None: ...
    @property
    def underline(self) -> bool: ...
    @underline.setter
    def underline(self, v: bool) -> None: ...
    @property
    def font_style(self) -> str: ...
    @font_style.setter
    def font_style(self, v: str) -> None: ...
    @property
    def font_stretching(self) -> float: ...
    @font_stretching.setter
    def font_stretching(self, v: float) -> None: ...
    @property
    def char_spacing(self): ...
    @char_spacing.setter
    def char_spacing(self, v) -> None: ...
    @property
    def font_family(self): ...
    @font_family.setter
    def font_family(self, v) -> None: ...
    @property
    def font_size_pt(self): ...
    @font_size_pt.setter
    def font_size_pt(self, v) -> None: ...
    @property
    def font_size(self): ...
    @font_size.setter
    def font_size(self, v) -> None: ...
    @property
    def current_font(self): ...
    @current_font.setter
    def current_font(self, v) -> None: ...
    @property
    def dash_pattern(self): ...
    @dash_pattern.setter
    def dash_pattern(self, v) -> None: ...
    @property
    def line_width(self): ...
    @line_width.setter
    def line_width(self, v) -> None: ...
    @property
    def text_mode(self): ...
    @text_mode.setter
    def text_mode(self, v) -> None: ...
    @property
    def char_vpos(self): ...
    @char_vpos.setter
    def char_vpos(self, v) -> None: ...
    @property
    def sub_scale(self): ...
    @sub_scale.setter
    def sub_scale(self, v) -> None: ...
    @property
    def sup_scale(self): ...
    @sup_scale.setter
    def sup_scale(self, v) -> None: ...
    @property
    def nom_scale(self): ...
    @nom_scale.setter
    def nom_scale(self, v) -> None: ...
    @property
    def denom_scale(self): ...
    @denom_scale.setter
    def denom_scale(self, v) -> None: ...
    @property
    def sub_lift(self): ...
    @sub_lift.setter
    def sub_lift(self, v) -> None: ...
    @property
    def sup_lift(self): ...
    @sup_lift.setter
    def sup_lift(self, v) -> None: ...
    @property
    def nom_lift(self): ...
    @nom_lift.setter
    def nom_lift(self, v) -> None: ...
    @property
    def denom_lift(self): ...
    @denom_lift.setter
    def denom_lift(self, v) -> None: ...
