from Xlib._typing import Unused
from Xlib.display import Display
from Xlib.protocol import rq
from Xlib.xobject import resource

extname: str

def query_target_count(self: Display | resource.Resource, target: Target) -> int: ...
def query_int_attribute(self: Display | resource.Resource, target: Target, display_mask: int, attr: int) -> int | None: ...
def set_int_attribute(self: Display | resource.Resource, target: Target, display_mask: int, attr: int, value: int) -> bool: ...
def query_string_attribute(self: Display | resource.Resource, target: Target, display_mask: int, attr: int) -> str | None: ...
def query_valid_attr_values(
    self: Display | resource.Resource, target: Target, display_mask: int, attr: int
) -> tuple[int, int] | None: ...
def query_binary_data(self: Display | resource.Resource, target: Target, display_mask: int, attr: int) -> bytes | None: ...
def get_coolers_used_by_gpu(self: Display | resource.Resource, target: Target) -> list[int] | None: ...
def get_gpu_count(self: Display | resource.Resource) -> int: ...
def get_name(self: Display | resource.Resource, target: Target) -> str | None: ...
def get_driver_version(self: Display | resource.Resource, target: Target) -> str | None: ...
def get_vbios_version(self: Display | resource.Resource, target: Target) -> str | None: ...
def get_gpu_uuid(self: Display | resource.Resource, target: Target) -> str | None: ...
def get_utilization_rates(self: Display | resource.Resource, target: Target) -> dict[str, str | int]: ...
def get_performance_modes(self: Display | resource.Resource, target: Target) -> list[dict[str, str | int]]: ...
def get_clock_info(self: Display | resource.Resource, target: Target) -> dict[str, str | int]: ...
def get_vram(self: Display | resource.Resource, target: Target) -> int | None: ...
def get_irq(self: Display | resource.Resource, target: Target) -> int | None: ...
def supports_framelock(self: Display | resource.Resource, target: Target) -> int | None: ...
def gvo_supported(self: Display | resource.Resource, screen: Target) -> int | None: ...
def get_core_temp(self: Display | resource.Resource, target: Target) -> int | None: ...
def get_core_threshold(self: Display | resource.Resource, target: Target) -> int | None: ...
def get_default_core_threshold(self: Display | resource.Resource, target: Target) -> int | None: ...
def get_max_core_threshold(self: Display | resource.Resource, target: Target) -> int | None: ...
def get_ambient_temp(self: Display | resource.Resource, target: Target) -> int | None: ...
def get_cuda_cores(self: Display | resource.Resource, target: Target) -> int | None: ...
def get_memory_bus_width(self: Display | resource.Resource, target: Target) -> int | None: ...
def get_total_dedicated_gpu_memory(self: Display | resource.Resource, target: Target) -> int | None: ...
def get_used_dedicated_gpu_memory(self: Display | resource.Resource, target: Target) -> int | None: ...
def get_curr_pcie_link_width(self: Display | resource.Resource, target: Target) -> int | None: ...
def get_max_pcie_link_width(self: Display | resource.Resource, target: Target) -> int | None: ...
def get_curr_pcie_link_generation(self: Display | resource.Resource, target: Target) -> int | None: ...
def get_encoder_utilization(self: Display | resource.Resource, target: Target) -> int | None: ...
def get_decoder_utilization(self: Display | resource.Resource, target: Target) -> int | None: ...
def get_current_performance_level(self: Display | resource.Resource, target: Target) -> int | None: ...
def get_gpu_nvclock_offset(self: Display | resource.Resource, target: Target, perf_level: int) -> int | None: ...
def set_gpu_nvclock_offset(self: Display | resource.Resource, target: Target, perf_level: int, offset: int) -> bool: ...
def set_gpu_nvclock_offset_all_levels(self: Display | resource.Resource, target: Target, offset: int) -> bool: ...
def get_gpu_nvclock_offset_range(
    self: Display | resource.Resource, target: Target, perf_level: int
) -> tuple[int, int] | None: ...
def get_mem_transfer_rate_offset(self: Display | resource.Resource, target: Target, perf_level: int) -> int | None: ...
def set_mem_transfer_rate_offset(self: Display | resource.Resource, target: Target, perf_level: int, offset: int) -> bool: ...
def set_mem_transfer_rate_offset_all_levels(self: Display | resource.Resource, target: Target, offset: int) -> bool: ...
def get_mem_transfer_rate_offset_range(
    self: Display | resource.Resource, target: Target, perf_level: int
) -> tuple[int, int] | None: ...
def get_cooler_manual_control_enabled(self: Display | resource.Resource, target: Target) -> int | None: ...
def set_cooler_manual_control_enabled(self: Display | resource.Resource, target: Target, enabled: bool) -> bool: ...
def get_fan_duty(self: Display | resource.Resource, target: Target) -> int | None: ...
def set_fan_duty(self: Display | resource.Resource, cooler: Target, speed: int) -> bool: ...
def get_fan_rpm(self: Display | resource.Resource, target: Target) -> int | None: ...
def get_max_displays(self: Display | resource.Resource, target: Target) -> int | None: ...
def init(disp: Display, info: Unused) -> None: ...

NV_CTRL_FLATPANEL_SCALING: int
NV_CTRL_FLATPANEL_SCALING_DEFAULT: int
NV_CTRL_FLATPANEL_SCALING_NATIVE: int
NV_CTRL_FLATPANEL_SCALING_SCALED: int
NV_CTRL_FLATPANEL_SCALING_CENTERED: int
NV_CTRL_FLATPANEL_SCALING_ASPECT_SCALED: int
NV_CTRL_FLATPANEL_DITHERING: int
NV_CTRL_FLATPANEL_DITHERING_DEFAULT: int
NV_CTRL_FLATPANEL_DITHERING_ENABLED: int
NV_CTRL_FLATPANEL_DITHERING_DISABLED: int
NV_CTRL_DITHERING: int
NV_CTRL_DITHERING_AUTO: int
NV_CTRL_DITHERING_ENABLED: int
NV_CTRL_DITHERING_DISABLED: int
NV_CTRL_DIGITAL_VIBRANCE: int
NV_CTRL_BUS_TYPE: int
NV_CTRL_BUS_TYPE_AGP: int
NV_CTRL_BUS_TYPE_PCI: int
NV_CTRL_BUS_TYPE_PCI_EXPRESS: int
NV_CTRL_BUS_TYPE_INTEGRATED: int
NV_CTRL_TOTAL_GPU_MEMORY: int
NV_CTRL_VIDEO_RAM: int
NV_CTRL_IRQ: int
NV_CTRL_OPERATING_SYSTEM: int
NV_CTRL_OPERATING_SYSTEM_LINUX: int
NV_CTRL_OPERATING_SYSTEM_FREEBSD: int
NV_CTRL_OPERATING_SYSTEM_SUNOS: int
NV_CTRL_SYNC_TO_VBLANK: int
NV_CTRL_SYNC_TO_VBLANK_OFF: int
NV_CTRL_SYNC_TO_VBLANK_ON: int
NV_CTRL_LOG_ANISO: int
NV_CTRL_FSAA_MODE: int
NV_CTRL_FSAA_MODE_NONE: int
NV_CTRL_FSAA_MODE_2x: int
NV_CTRL_FSAA_MODE_2x_5t: int
NV_CTRL_FSAA_MODE_15x15: int
NV_CTRL_FSAA_MODE_2x2: int
NV_CTRL_FSAA_MODE_4x: int
NV_CTRL_FSAA_MODE_4x_9t: int
NV_CTRL_FSAA_MODE_8x: int
NV_CTRL_FSAA_MODE_16x: int
NV_CTRL_FSAA_MODE_8xS: int
NV_CTRL_FSAA_MODE_8xQ: int
NV_CTRL_FSAA_MODE_16xS: int
NV_CTRL_FSAA_MODE_16xQ: int
NV_CTRL_FSAA_MODE_32xS: int
NV_CTRL_FSAA_MODE_32x: int
NV_CTRL_FSAA_MODE_64xS: int
NV_CTRL_FSAA_MODE_MAX: int
NV_CTRL_UBB: int
NV_CTRL_UBB_OFF: int
NV_CTRL_UBB_ON: int
NV_CTRL_OVERLAY: int
NV_CTRL_OVERLAY_OFF: int
NV_CTRL_OVERLAY_ON: int
NV_CTRL_STEREO: int
NV_CTRL_STEREO_OFF: int
NV_CTRL_STEREO_DDC: int
NV_CTRL_STEREO_BLUELINE: int
NV_CTRL_STEREO_DIN: int
NV_CTRL_STEREO_PASSIVE_EYE_PER_DPY: int
NV_CTRL_STEREO_VERTICAL_INTERLACED: int
NV_CTRL_STEREO_COLOR_INTERLACED: int
NV_CTRL_STEREO_HORIZONTAL_INTERLACED: int
NV_CTRL_STEREO_CHECKERBOARD_PATTERN: int
NV_CTRL_STEREO_INVERSE_CHECKERBOARD_PATTERN: int
NV_CTRL_STEREO_3D_VISION: int
NV_CTRL_STEREO_3D_VISION_PRO: int
NV_CTRL_STEREO_HDMI_3D: int
NV_CTRL_STEREO_TRIDELITY_SL: int
NV_CTRL_STEREO_INBAND_STEREO_SIGNALING: int
NV_CTRL_STEREO_MAX: int
NV_CTRL_EMULATE: int
NV_CTRL_EMULATE_NONE: int
NV_CTRL_TWINVIEW: int
NV_CTRL_TWINVIEW_NOT_ENABLED: int
NV_CTRL_TWINVIEW_ENABLED: int
NV_CTRL_CONNECTED_DISPLAYS: int
NV_CTRL_ENABLED_DISPLAYS: int
NV_CTRL_FRAMELOCK: int
NV_CTRL_FRAMELOCK_NOT_SUPPORTED: int
NV_CTRL_FRAMELOCK_SUPPORTED: int
NV_CTRL_FRAMELOCK_MASTER: int
NV_CTRL_FRAMELOCK_MASTER_FALSE: int
NV_CTRL_FRAMELOCK_MASTER_TRUE: int
NV_CTRL_FRAMELOCK_POLARITY: int
NV_CTRL_FRAMELOCK_POLARITY_RISING_EDGE: int
NV_CTRL_FRAMELOCK_POLARITY_FALLING_EDGE: int
NV_CTRL_FRAMELOCK_POLARITY_BOTH_EDGES: int
NV_CTRL_FRAMELOCK_SYNC_DELAY: int
NV_CTRL_FRAMELOCK_SYNC_DELAY_MAX: int
NV_CTRL_FRAMELOCK_SYNC_DELAY_FACTOR: float
NV_CTRL_FRAMELOCK_SYNC_INTERVAL: int
NV_CTRL_FRAMELOCK_PORT0_STATUS: int
NV_CTRL_FRAMELOCK_PORT0_STATUS_INPUT: int
NV_CTRL_FRAMELOCK_PORT0_STATUS_OUTPUT: int
NV_CTRL_FRAMELOCK_PORT1_STATUS: int
NV_CTRL_FRAMELOCK_PORT1_STATUS_INPUT: int
NV_CTRL_FRAMELOCK_PORT1_STATUS_OUTPUT: int
NV_CTRL_FRAMELOCK_HOUSE_STATUS: int
NV_CTRL_FRAMELOCK_HOUSE_STATUS_NOT_DETECTED: int
NV_CTRL_FRAMELOCK_HOUSE_STATUS_DETECTED: int
NV_CTRL_FRAMELOCK_SYNC: int
NV_CTRL_FRAMELOCK_SYNC_DISABLE: int
NV_CTRL_FRAMELOCK_SYNC_ENABLE: int
NV_CTRL_FRAMELOCK_SYNC_READY: int
NV_CTRL_FRAMELOCK_SYNC_READY_FALSE: int
NV_CTRL_FRAMELOCK_SYNC_READY_TRUE: int
NV_CTRL_FRAMELOCK_STEREO_SYNC: int
NV_CTRL_FRAMELOCK_STEREO_SYNC_FALSE: int
NV_CTRL_FRAMELOCK_STEREO_SYNC_TRUE: int
NV_CTRL_FRAMELOCK_TEST_SIGNAL: int
NV_CTRL_FRAMELOCK_TEST_SIGNAL_DISABLE: int
NV_CTRL_FRAMELOCK_TEST_SIGNAL_ENABLE: int
NV_CTRL_FRAMELOCK_ETHERNET_DETECTED: int
NV_CTRL_FRAMELOCK_ETHERNET_DETECTED_NONE: int
NV_CTRL_FRAMELOCK_ETHERNET_DETECTED_PORT0: int
NV_CTRL_FRAMELOCK_ETHERNET_DETECTED_PORT1: int
NV_CTRL_FRAMELOCK_VIDEO_MODE: int
NV_CTRL_FRAMELOCK_VIDEO_MODE_NONE: int
NV_CTRL_FRAMELOCK_VIDEO_MODE_TTL: int
NV_CTRL_FRAMELOCK_VIDEO_MODE_NTSCPALSECAM: int
NV_CTRL_FRAMELOCK_VIDEO_MODE_HDTV: int
NV_CTRL_FRAMELOCK_VIDEO_MODE_COMPOSITE_AUTO: int
NV_CTRL_FRAMELOCK_VIDEO_MODE_COMPOSITE_BI_LEVEL: int
NV_CTRL_FRAMELOCK_VIDEO_MODE_COMPOSITE_TRI_LEVEL: int
NV_CTRL_FRAMELOCK_SYNC_RATE: int
NV_CTRL_FORCE_GENERIC_CPU: int
NV_CTRL_FORCE_GENERIC_CPU_DISABLE: int
NV_CTRL_FORCE_GENERIC_CPU_ENABLE: int
NV_CTRL_OPENGL_AA_LINE_GAMMA: int
NV_CTRL_OPENGL_AA_LINE_GAMMA_DISABLE: int
NV_CTRL_OPENGL_AA_LINE_GAMMA_ENABLE: int
NV_CTRL_FRAMELOCK_TIMING: int
NV_CTRL_FRAMELOCK_TIMING_FALSE: int
NV_CTRL_FRAMELOCK_TIMING_TRUE: int
NV_CTRL_FLIPPING_ALLOWED: int
NV_CTRL_FLIPPING_ALLOWED_FALSE: int
NV_CTRL_FLIPPING_ALLOWED_TRUE: int
NV_CTRL_ARCHITECTURE: int
NV_CTRL_ARCHITECTURE_X86: int
NV_CTRL_ARCHITECTURE_X86_64: int
NV_CTRL_ARCHITECTURE_IA64: int
NV_CTRL_ARCHITECTURE_ARM: int
NV_CTRL_ARCHITECTURE_AARCH64: int
NV_CTRL_ARCHITECTURE_PPC64LE: int
NV_CTRL_TEXTURE_CLAMPING: int
NV_CTRL_TEXTURE_CLAMPING_EDGE: int
NV_CTRL_TEXTURE_CLAMPING_SPEC: int
NV_CTRL_CURSOR_SHADOW: int
NV_CTRL_CURSOR_SHADOW_DISABLE: int
NV_CTRL_CURSOR_SHADOW_ENABLE: int
NV_CTRL_CURSOR_SHADOW_ALPHA: int
NV_CTRL_CURSOR_SHADOW_RED: int
NV_CTRL_CURSOR_SHADOW_GREEN: int
NV_CTRL_CURSOR_SHADOW_BLUE: int
NV_CTRL_CURSOR_SHADOW_X_OFFSET: int
NV_CTRL_CURSOR_SHADOW_Y_OFFSET: int
NV_CTRL_FSAA_APPLICATION_CONTROLLED: int
NV_CTRL_FSAA_APPLICATION_CONTROLLED_ENABLED: int
NV_CTRL_FSAA_APPLICATION_CONTROLLED_DISABLED: int
NV_CTRL_LOG_ANISO_APPLICATION_CONTROLLED: int
NV_CTRL_LOG_ANISO_APPLICATION_CONTROLLED_ENABLED: int
NV_CTRL_LOG_ANISO_APPLICATION_CONTROLLED_DISABLED: int
NV_CTRL_IMAGE_SHARPENING: int
NV_CTRL_TV_OVERSCAN: int
NV_CTRL_TV_FLICKER_FILTER: int
NV_CTRL_TV_BRIGHTNESS: int
NV_CTRL_TV_HUE: int
NV_CTRL_TV_CONTRAST: int
NV_CTRL_TV_SATURATION: int
NV_CTRL_TV_RESET_SETTINGS: int
NV_CTRL_GPU_CORE_TEMPERATURE: int
NV_CTRL_GPU_CORE_THRESHOLD: int
NV_CTRL_GPU_DEFAULT_CORE_THRESHOLD: int
NV_CTRL_GPU_MAX_CORE_THRESHOLD: int
NV_CTRL_AMBIENT_TEMPERATURE: int
NV_CTRL_PBUFFER_SCANOUT_SUPPORTED: int
NV_CTRL_PBUFFER_SCANOUT_FALSE: int
NV_CTRL_PBUFFER_SCANOUT_TRUE: int
NV_CTRL_PBUFFER_SCANOUT_XID: int
NV_CTRL_GVO_SUPPORTED: int
NV_CTRL_GVO_SUPPORTED_FALSE: int
NV_CTRL_GVO_SUPPORTED_TRUE: int
NV_CTRL_GVO_SYNC_MODE: int
NV_CTRL_GVO_SYNC_MODE_FREE_RUNNING: int
NV_CTRL_GVO_SYNC_MODE_GENLOCK: int
NV_CTRL_GVO_SYNC_MODE_FRAMELOCK: int
NV_CTRL_GVO_SYNC_SOURCE: int
NV_CTRL_GVO_SYNC_SOURCE_COMPOSITE: int
NV_CTRL_GVO_SYNC_SOURCE_SDI: int
NV_CTRL_GVIO_REQUESTED_VIDEO_FORMAT: int
NV_CTRL_GVIO_VIDEO_FORMAT_NONE: int
NV_CTRL_GVIO_VIDEO_FORMAT_487I_59_94_SMPTE259_NTSC: int
NV_CTRL_GVIO_VIDEO_FORMAT_576I_50_00_SMPTE259_PAL: int
NV_CTRL_GVIO_VIDEO_FORMAT_720P_59_94_SMPTE296: int
NV_CTRL_GVIO_VIDEO_FORMAT_720P_60_00_SMPTE296: int
NV_CTRL_GVIO_VIDEO_FORMAT_1035I_59_94_SMPTE260: int
NV_CTRL_GVIO_VIDEO_FORMAT_1035I_60_00_SMPTE260: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080I_50_00_SMPTE295: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080I_50_00_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080I_59_94_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080I_60_00_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080P_23_976_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080P_24_00_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080P_25_00_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080P_29_97_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080P_30_00_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_720P_50_00_SMPTE296: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080I_48_00_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080I_47_96_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_720P_30_00_SMPTE296: int
NV_CTRL_GVIO_VIDEO_FORMAT_720P_29_97_SMPTE296: int
NV_CTRL_GVIO_VIDEO_FORMAT_720P_25_00_SMPTE296: int
NV_CTRL_GVIO_VIDEO_FORMAT_720P_24_00_SMPTE296: int
NV_CTRL_GVIO_VIDEO_FORMAT_720P_23_98_SMPTE296: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080PSF_25_00_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080PSF_29_97_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080PSF_30_00_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080PSF_24_00_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080PSF_23_98_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048P_30_00_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048P_29_97_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048I_60_00_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048I_59_94_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048P_25_00_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048I_50_00_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048P_24_00_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048P_23_98_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048I_48_00_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048I_47_96_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080P_50_00_3G_LEVEL_A_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080P_59_94_3G_LEVEL_A_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080P_60_00_3G_LEVEL_A_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080P_60_00_3G_LEVEL_B_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080I_60_00_3G_LEVEL_B_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048I_60_00_3G_LEVEL_B_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080P_50_00_3G_LEVEL_B_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080I_50_00_3G_LEVEL_B_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048I_50_00_3G_LEVEL_B_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080P_30_00_3G_LEVEL_B_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048P_30_00_3G_LEVEL_B_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080P_25_00_3G_LEVEL_B_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048P_25_00_3G_LEVEL_B_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080P_24_00_3G_LEVEL_B_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048P_24_00_3G_LEVEL_B_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080I_48_00_3G_LEVEL_B_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048I_48_00_3G_LEVEL_B_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080P_59_94_3G_LEVEL_B_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080I_59_94_3G_LEVEL_B_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048I_59_94_3G_LEVEL_B_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080P_29_97_3G_LEVEL_B_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048P_29_97_3G_LEVEL_B_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080P_23_98_3G_LEVEL_B_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048P_23_98_3G_LEVEL_B_SMPTE372: int
NV_CTRL_GVIO_VIDEO_FORMAT_1080I_47_96_3G_LEVEL_B_SMPTE274: int
NV_CTRL_GVIO_VIDEO_FORMAT_2048I_47_96_3G_LEVEL_B_SMPTE372: int
NV_CTRL_GVO_OUTPUT_VIDEO_FORMAT: int
NV_CTRL_GVO_VIDEO_FORMAT_NONE: int
NV_CTRL_GVO_VIDEO_FORMAT_487I_59_94_SMPTE259_NTSC: int
NV_CTRL_GVO_VIDEO_FORMAT_576I_50_00_SMPTE259_PAL: int
NV_CTRL_GVO_VIDEO_FORMAT_720P_59_94_SMPTE296: int
NV_CTRL_GVO_VIDEO_FORMAT_720P_60_00_SMPTE296: int
NV_CTRL_GVO_VIDEO_FORMAT_1035I_59_94_SMPTE260: int
NV_CTRL_GVO_VIDEO_FORMAT_1035I_60_00_SMPTE260: int
NV_CTRL_GVO_VIDEO_FORMAT_1080I_50_00_SMPTE295: int
NV_CTRL_GVO_VIDEO_FORMAT_1080I_50_00_SMPTE274: int
NV_CTRL_GVO_VIDEO_FORMAT_1080I_59_94_SMPTE274: int
NV_CTRL_GVO_VIDEO_FORMAT_1080I_60_00_SMPTE274: int
NV_CTRL_GVO_VIDEO_FORMAT_1080P_23_976_SMPTE274: int
NV_CTRL_GVO_VIDEO_FORMAT_1080P_24_00_SMPTE274: int
NV_CTRL_GVO_VIDEO_FORMAT_1080P_25_00_SMPTE274: int
NV_CTRL_GVO_VIDEO_FORMAT_1080P_29_97_SMPTE274: int
NV_CTRL_GVO_VIDEO_FORMAT_1080P_30_00_SMPTE274: int
NV_CTRL_GVO_VIDEO_FORMAT_720P_50_00_SMPTE296: int
NV_CTRL_GVO_VIDEO_FORMAT_1080I_48_00_SMPTE274: int
NV_CTRL_GVO_VIDEO_FORMAT_1080I_47_96_SMPTE274: int
NV_CTRL_GVO_VIDEO_FORMAT_720P_30_00_SMPTE296: int
NV_CTRL_GVO_VIDEO_FORMAT_720P_29_97_SMPTE296: int
NV_CTRL_GVO_VIDEO_FORMAT_720P_25_00_SMPTE296: int
NV_CTRL_GVO_VIDEO_FORMAT_720P_24_00_SMPTE296: int
NV_CTRL_GVO_VIDEO_FORMAT_720P_23_98_SMPTE296: int
NV_CTRL_GVO_VIDEO_FORMAT_1080PSF_25_00_SMPTE274: int
NV_CTRL_GVO_VIDEO_FORMAT_1080PSF_29_97_SMPTE274: int
NV_CTRL_GVO_VIDEO_FORMAT_1080PSF_30_00_SMPTE274: int
NV_CTRL_GVO_VIDEO_FORMAT_1080PSF_24_00_SMPTE274: int
NV_CTRL_GVO_VIDEO_FORMAT_1080PSF_23_98_SMPTE274: int
NV_CTRL_GVO_VIDEO_FORMAT_2048P_30_00_SMPTE372: int
NV_CTRL_GVO_VIDEO_FORMAT_2048P_29_97_SMPTE372: int
NV_CTRL_GVO_VIDEO_FORMAT_2048I_60_00_SMPTE372: int
NV_CTRL_GVO_VIDEO_FORMAT_2048I_59_94_SMPTE372: int
NV_CTRL_GVO_VIDEO_FORMAT_2048P_25_00_SMPTE372: int
NV_CTRL_GVO_VIDEO_FORMAT_2048I_50_00_SMPTE372: int
NV_CTRL_GVO_VIDEO_FORMAT_2048P_24_00_SMPTE372: int
NV_CTRL_GVO_VIDEO_FORMAT_2048P_23_98_SMPTE372: int
NV_CTRL_GVO_VIDEO_FORMAT_2048I_48_00_SMPTE372: int
NV_CTRL_GVO_VIDEO_FORMAT_2048I_47_96_SMPTE372: int
NV_CTRL_GVIO_DETECTED_VIDEO_FORMAT: int
NV_CTRL_GVO_INPUT_VIDEO_FORMAT: int
NV_CTRL_GVO_DATA_FORMAT: int
NV_CTRL_GVO_DATA_FORMAT_R8G8B8_TO_YCRCB444: int
NV_CTRL_GVO_DATA_FORMAT_R8G8B8A8_TO_YCRCBA4444: int
NV_CTRL_GVO_DATA_FORMAT_R8G8B8Z10_TO_YCRCBZ4444: int
NV_CTRL_GVO_DATA_FORMAT_R8G8B8_TO_YCRCB422: int
NV_CTRL_GVO_DATA_FORMAT_R8G8B8A8_TO_YCRCBA4224: int
NV_CTRL_GVO_DATA_FORMAT_R8G8B8Z10_TO_YCRCBZ4224: int
NV_CTRL_GVO_DATA_FORMAT_R8G8B8_TO_RGB444: int
NV_CTRL_GVO_DATA_FORMAT_X8X8X8_444_PASSTHRU: int
NV_CTRL_GVO_DATA_FORMAT_R8G8B8A8_TO_RGBA4444: int
NV_CTRL_GVO_DATA_FORMAT_X8X8X8A8_4444_PASSTHRU: int
NV_CTRL_GVO_DATA_FORMAT_R8G8B8Z10_TO_RGBZ4444: int
NV_CTRL_GVO_DATA_FORMAT_X8X8X8Z8_4444_PASSTHRU: int
NV_CTRL_GVO_DATA_FORMAT_Y10CR10CB10_TO_YCRCB444: int
NV_CTRL_GVO_DATA_FORMAT_X10X10X10_444_PASSTHRU: int
NV_CTRL_GVO_DATA_FORMAT_Y10CR8CB8_TO_YCRCB444: int
NV_CTRL_GVO_DATA_FORMAT_X10X8X8_444_PASSTHRU: int
NV_CTRL_GVO_DATA_FORMAT_Y10CR8CB8A10_TO_YCRCBA4444: int
NV_CTRL_GVO_DATA_FORMAT_X10X8X8A10_4444_PASSTHRU: int
NV_CTRL_GVO_DATA_FORMAT_Y10CR8CB8Z10_TO_YCRCBZ4444: int
NV_CTRL_GVO_DATA_FORMAT_X10X8X8Z10_4444_PASSTHRU: int
NV_CTRL_GVO_DATA_FORMAT_DUAL_R8G8B8_TO_DUAL_YCRCB422: int
NV_CTRL_GVO_DATA_FORMAT_DUAL_Y8CR8CB8_TO_DUAL_YCRCB422: int
NV_CTRL_GVO_DATA_FORMAT_DUAL_X8X8X8_TO_DUAL_422_PASSTHRU: int
NV_CTRL_GVO_DATA_FORMAT_R10G10B10_TO_YCRCB422: int
NV_CTRL_GVO_DATA_FORMAT_R10G10B10_TO_YCRCB444: int
NV_CTRL_GVO_DATA_FORMAT_Y12CR12CB12_TO_YCRCB444: int
NV_CTRL_GVO_DATA_FORMAT_X12X12X12_444_PASSTHRU: int
NV_CTRL_GVO_DATA_FORMAT_R12G12B12_TO_YCRCB444: int
NV_CTRL_GVO_DATA_FORMAT_X8X8X8_422_PASSTHRU: int
NV_CTRL_GVO_DATA_FORMAT_X8X8X8A8_4224_PASSTHRU: int
NV_CTRL_GVO_DATA_FORMAT_X8X8X8Z8_4224_PASSTHRU: int
NV_CTRL_GVO_DATA_FORMAT_X10X10X10_422_PASSTHRU: int
NV_CTRL_GVO_DATA_FORMAT_X10X8X8_422_PASSTHRU: int
NV_CTRL_GVO_DATA_FORMAT_X10X8X8A10_4224_PASSTHRU: int
NV_CTRL_GVO_DATA_FORMAT_X10X8X8Z10_4224_PASSTHRU: int
NV_CTRL_GVO_DATA_FORMAT_X12X12X12_422_PASSTHRU: int
NV_CTRL_GVO_DATA_FORMAT_R12G12B12_TO_YCRCB422: int
NV_CTRL_GVO_DISPLAY_X_SCREEN: int
NV_CTRL_GVO_DISPLAY_X_SCREEN_ENABLE: int
NV_CTRL_GVO_DISPLAY_X_SCREEN_DISABLE: int
NV_CTRL_GVO_COMPOSITE_SYNC_INPUT_DETECTED: int
NV_CTRL_GVO_COMPOSITE_SYNC_INPUT_DETECTED_FALSE: int
NV_CTRL_GVO_COMPOSITE_SYNC_INPUT_DETECTED_TRUE: int
NV_CTRL_GVO_COMPOSITE_SYNC_INPUT_DETECT_MODE: int
NV_CTRL_GVO_COMPOSITE_SYNC_INPUT_DETECT_MODE_AUTO: int
NV_CTRL_GVO_COMPOSITE_SYNC_INPUT_DETECT_MODE_BI_LEVEL: int
NV_CTRL_GVO_COMPOSITE_SYNC_INPUT_DETECT_MODE_TRI_LEVEL: int
NV_CTRL_GVO_SDI_SYNC_INPUT_DETECTED: int
NV_CTRL_GVO_SDI_SYNC_INPUT_DETECTED_NONE: int
NV_CTRL_GVO_SDI_SYNC_INPUT_DETECTED_HD: int
NV_CTRL_GVO_SDI_SYNC_INPUT_DETECTED_SD: int
NV_CTRL_GVO_VIDEO_OUTPUTS: int
NV_CTRL_GVO_VIDEO_OUTPUTS_NONE: int
NV_CTRL_GVO_VIDEO_OUTPUTS_VIDEO1: int
NV_CTRL_GVO_VIDEO_OUTPUTS_VIDEO2: int
NV_CTRL_GVO_VIDEO_OUTPUTS_VIDEO_BOTH: int
NV_CTRL_GVO_FIRMWARE_VERSION: int
NV_CTRL_GVO_SYNC_DELAY_PIXELS: int
NV_CTRL_GVO_SYNC_DELAY_LINES: int
NV_CTRL_GVO_INPUT_VIDEO_FORMAT_REACQUIRE: int
NV_CTRL_GVO_INPUT_VIDEO_FORMAT_REACQUIRE_FALSE: int
NV_CTRL_GVO_INPUT_VIDEO_FORMAT_REACQUIRE_TRUE: int
NV_CTRL_GVO_GLX_LOCKED: int
NV_CTRL_GVO_GLX_LOCKED_FALSE: int
NV_CTRL_GVO_GLX_LOCKED_TRUE: int
NV_CTRL_GVIO_VIDEO_FORMAT_WIDTH: int
NV_CTRL_GVIO_VIDEO_FORMAT_HEIGHT: int
NV_CTRL_GVIO_VIDEO_FORMAT_REFRESH_RATE: int
NV_CTRL_GVO_VIDEO_FORMAT_WIDTH: int
NV_CTRL_GVO_VIDEO_FORMAT_HEIGHT: int
NV_CTRL_GVO_VIDEO_FORMAT_REFRESH_RATE: int
NV_CTRL_GVO_X_SCREEN_PAN_X: int
NV_CTRL_GVO_X_SCREEN_PAN_Y: int
NV_CTRL_GPU_OVERCLOCKING_STATE: int
NV_CTRL_GPU_OVERCLOCKING_STATE_NONE: int
NV_CTRL_GPU_OVERCLOCKING_STATE_MANUAL: int
NV_CTRL_GPU_2D_CLOCK_FREQS: int
NV_CTRL_GPU_3D_CLOCK_FREQS: int
NV_CTRL_GPU_DEFAULT_2D_CLOCK_FREQS: int
NV_CTRL_GPU_DEFAULT_3D_CLOCK_FREQS: int
NV_CTRL_GPU_CURRENT_CLOCK_FREQS: int
NV_CTRL_GPU_OPTIMAL_CLOCK_FREQS: int
NV_CTRL_GPU_OPTIMAL_CLOCK_FREQS_INVALID: int
NV_CTRL_GPU_OPTIMAL_CLOCK_FREQS_DETECTION: int
NV_CTRL_GPU_OPTIMAL_CLOCK_FREQS_DETECTION_START: int
NV_CTRL_GPU_OPTIMAL_CLOCK_FREQS_DETECTION_CANCEL: int
NV_CTRL_GPU_OPTIMAL_CLOCK_FREQS_DETECTION_STATE: int
NV_CTRL_GPU_OPTIMAL_CLOCK_FREQS_DETECTION_STATE_IDLE: int
NV_CTRL_GPU_OPTIMAL_CLOCK_FREQS_DETECTION_STATE_BUSY: int
NV_CTRL_FLATPANEL_CHIP_LOCATION: int
NV_CTRL_FLATPANEL_CHIP_LOCATION_INTERNAL: int
NV_CTRL_FLATPANEL_CHIP_LOCATION_EXTERNAL: int
NV_CTRL_FLATPANEL_LINK: int
NV_CTRL_FLATPANEL_LINK_SINGLE: int
NV_CTRL_FLATPANEL_LINK_DUAL: int
NV_CTRL_FLATPANEL_LINK_QUAD: int
NV_CTRL_FLATPANEL_SIGNAL: int
NV_CTRL_FLATPANEL_SIGNAL_LVDS: int
NV_CTRL_FLATPANEL_SIGNAL_TMDS: int
NV_CTRL_FLATPANEL_SIGNAL_DISPLAYPORT: int
NV_CTRL_USE_HOUSE_SYNC: int
NV_CTRL_USE_HOUSE_SYNC_DISABLED: int
NV_CTRL_USE_HOUSE_SYNC_INPUT: int
NV_CTRL_USE_HOUSE_SYNC_OUTPUT: int
NV_CTRL_USE_HOUSE_SYNC_FALSE: int
NV_CTRL_USE_HOUSE_SYNC_TRUE: int
NV_CTRL_EDID_AVAILABLE: int
NV_CTRL_EDID_AVAILABLE_FALSE: int
NV_CTRL_EDID_AVAILABLE_TRUE: int
NV_CTRL_FORCE_STEREO: int
NV_CTRL_FORCE_STEREO_FALSE: int
NV_CTRL_FORCE_STEREO_TRUE: int
NV_CTRL_IMAGE_SETTINGS: int
NV_CTRL_IMAGE_SETTINGS_HIGH_QUALITY: int
NV_CTRL_IMAGE_SETTINGS_QUALITY: int
NV_CTRL_IMAGE_SETTINGS_PERFORMANCE: int
NV_CTRL_IMAGE_SETTINGS_HIGH_PERFORMANCE: int
NV_CTRL_XINERAMA: int
NV_CTRL_XINERAMA_OFF: int
NV_CTRL_XINERAMA_ON: int
NV_CTRL_XINERAMA_STEREO: int
NV_CTRL_XINERAMA_STEREO_FALSE: int
NV_CTRL_XINERAMA_STEREO_TRUE: int
NV_CTRL_BUS_RATE: int
NV_CTRL_GPU_PCIE_MAX_LINK_WIDTH: int
NV_CTRL_SHOW_SLI_VISUAL_INDICATOR: int
NV_CTRL_SHOW_SLI_VISUAL_INDICATOR_FALSE: int
NV_CTRL_SHOW_SLI_VISUAL_INDICATOR_TRUE: int
NV_CTRL_SHOW_SLI_HUD: int
NV_CTRL_SHOW_SLI_HUD_FALSE: int
NV_CTRL_SHOW_SLI_HUD_TRUE: int
NV_CTRL_XV_SYNC_TO_DISPLAY: int
NV_CTRL_GVIO_REQUESTED_VIDEO_FORMAT2: int
NV_CTRL_GVO_OUTPUT_VIDEO_FORMAT2: int
NV_CTRL_GVO_OVERRIDE_HW_CSC: int
NV_CTRL_GVO_OVERRIDE_HW_CSC_FALSE: int
NV_CTRL_GVO_OVERRIDE_HW_CSC_TRUE: int
NV_CTRL_GVO_CAPABILITIES: int
NV_CTRL_GVO_CAPABILITIES_APPLY_CSC_IMMEDIATELY: int
NV_CTRL_GVO_CAPABILITIES_APPLY_CSC_TO_X_SCREEN: int
NV_CTRL_GVO_CAPABILITIES_COMPOSITE_TERMINATION: int
NV_CTRL_GVO_CAPABILITIES_SHARED_SYNC_BNC: int
NV_CTRL_GVO_CAPABILITIES_MULTIRATE_SYNC: int
NV_CTRL_GVO_CAPABILITIES_ADVANCE_SYNC_SKEW: int
NV_CTRL_GVO_COMPOSITE_TERMINATION: int
NV_CTRL_GVO_COMPOSITE_TERMINATION_ENABLE: int
NV_CTRL_GVO_COMPOSITE_TERMINATION_DISABLE: int
NV_CTRL_ASSOCIATED_DISPLAY_DEVICES: int
NV_CTRL_FRAMELOCK_SLAVES: int
NV_CTRL_FRAMELOCK_MASTERABLE: int
NV_CTRL_PROBE_DISPLAYS: int
NV_CTRL_REFRESH_RATE: int
NV_CTRL_GVO_FLIP_QUEUE_SIZE: int
NV_CTRL_CURRENT_SCANLINE: int
NV_CTRL_INITIAL_PIXMAP_PLACEMENT: int
NV_CTRL_INITIAL_PIXMAP_PLACEMENT_FORCE_SYSMEM: int
NV_CTRL_INITIAL_PIXMAP_PLACEMENT_SYSMEM: int
NV_CTRL_INITIAL_PIXMAP_PLACEMENT_VIDMEM: int
NV_CTRL_INITIAL_PIXMAP_PLACEMENT_RESERVED: int
NV_CTRL_INITIAL_PIXMAP_PLACEMENT_GPU_SYSMEM: int
NV_CTRL_PCI_BUS: int
NV_CTRL_PCI_DEVICE: int
NV_CTRL_PCI_FUNCTION: int
NV_CTRL_FRAMELOCK_FPGA_REVISION: int
NV_CTRL_MAX_SCREEN_WIDTH: int
NV_CTRL_MAX_SCREEN_HEIGHT: int
NV_CTRL_MAX_DISPLAYS: int
NV_CTRL_DYNAMIC_TWINVIEW: int
NV_CTRL_MULTIGPU_DISPLAY_OWNER: int
NV_CTRL_GPU_SCALING: int
NV_CTRL_GPU_SCALING_TARGET_INVALID: int
NV_CTRL_GPU_SCALING_TARGET_FLATPANEL_BEST_FIT: int
NV_CTRL_GPU_SCALING_TARGET_FLATPANEL_NATIVE: int
NV_CTRL_GPU_SCALING_METHOD_INVALID: int
NV_CTRL_GPU_SCALING_METHOD_STRETCHED: int
NV_CTRL_GPU_SCALING_METHOD_CENTERED: int
NV_CTRL_GPU_SCALING_METHOD_ASPECT_SCALED: int
NV_CTRL_FRONTEND_RESOLUTION: int
NV_CTRL_BACKEND_RESOLUTION: int
NV_CTRL_FLATPANEL_NATIVE_RESOLUTION: int
NV_CTRL_FLATPANEL_BEST_FIT_RESOLUTION: int
NV_CTRL_GPU_SCALING_ACTIVE: int
NV_CTRL_DFP_SCALING_ACTIVE: int
NV_CTRL_FSAA_APPLICATION_ENHANCED: int
NV_CTRL_FSAA_APPLICATION_ENHANCED_ENABLED: int
NV_CTRL_FSAA_APPLICATION_ENHANCED_DISABLED: int
NV_CTRL_FRAMELOCK_SYNC_RATE_4: int
NV_CTRL_GVO_LOCK_OWNER: int
NV_CTRL_GVO_LOCK_OWNER_NONE: int
NV_CTRL_GVO_LOCK_OWNER_GLX: int
NV_CTRL_GVO_LOCK_OWNER_CLONE: int
NV_CTRL_GVO_LOCK_OWNER_X_SCREEN: int
NV_CTRL_HWOVERLAY: int
NV_CTRL_HWOVERLAY_FALSE: int
NV_CTRL_HWOVERLAY_TRUE: int
NV_CTRL_NUM_GPU_ERRORS_RECOVERED: int
NV_CTRL_REFRESH_RATE_3: int
NV_CTRL_ONDEMAND_VBLANK_INTERRUPTS: int
NV_CTRL_ONDEMAND_VBLANK_INTERRUPTS_OFF: int
NV_CTRL_ONDEMAND_VBLANK_INTERRUPTS_ON: int
NV_CTRL_GPU_POWER_SOURCE: int
NV_CTRL_GPU_POWER_SOURCE_AC: int
NV_CTRL_GPU_POWER_SOURCE_BATTERY: int
NV_CTRL_GPU_CURRENT_PERFORMANCE_MODE: int
NV_CTRL_GPU_CURRENT_PERFORMANCE_MODE_DESKTOP: int
NV_CTRL_GPU_CURRENT_PERFORMANCE_MODE_MAXPERF: int
NV_CTRL_GLYPH_CACHE: int
NV_CTRL_GLYPH_CACHE_DISABLED: int
NV_CTRL_GLYPH_CACHE_ENABLED: int
NV_CTRL_GPU_CURRENT_PERFORMANCE_LEVEL: int
NV_CTRL_GPU_ADAPTIVE_CLOCK_STATE: int
NV_CTRL_GPU_ADAPTIVE_CLOCK_STATE_DISABLED: int
NV_CTRL_GPU_ADAPTIVE_CLOCK_STATE_ENABLED: int
NV_CTRL_GVO_OUTPUT_VIDEO_LOCKED: int
NV_CTRL_GVO_OUTPUT_VIDEO_LOCKED_FALSE: int
NV_CTRL_GVO_OUTPUT_VIDEO_LOCKED_TRUE: int
NV_CTRL_GVO_SYNC_LOCK_STATUS: int
NV_CTRL_GVO_SYNC_LOCK_STATUS_UNLOCKED: int
NV_CTRL_GVO_SYNC_LOCK_STATUS_LOCKED: int
NV_CTRL_GVO_ANC_TIME_CODE_GENERATION: int
NV_CTRL_GVO_ANC_TIME_CODE_GENERATION_DISABLE: int
NV_CTRL_GVO_ANC_TIME_CODE_GENERATION_ENABLE: int
NV_CTRL_GVO_COMPOSITE: int
NV_CTRL_GVO_COMPOSITE_DISABLE: int
NV_CTRL_GVO_COMPOSITE_ENABLE: int
NV_CTRL_GVO_COMPOSITE_ALPHA_KEY: int
NV_CTRL_GVO_COMPOSITE_ALPHA_KEY_DISABLE: int
NV_CTRL_GVO_COMPOSITE_ALPHA_KEY_ENABLE: int
NV_CTRL_GVO_COMPOSITE_LUMA_KEY_RANGE: int
NV_CTRL_GVO_COMPOSITE_CR_KEY_RANGE: int
NV_CTRL_GVO_COMPOSITE_CB_KEY_RANGE: int
NV_CTRL_GVO_COMPOSITE_NUM_KEY_RANGES: int
NV_CTRL_SWITCH_TO_DISPLAYS: int
NV_CTRL_NOTEBOOK_DISPLAY_CHANGE_LID_EVENT: int
NV_CTRL_NOTEBOOK_INTERNAL_LCD: int
NV_CTRL_DEPTH_30_ALLOWED: int
NV_CTRL_MODE_SET_EVENT: int
NV_CTRL_OPENGL_AA_LINE_GAMMA_VALUE: int
NV_CTRL_VCSC_HIGH_PERF_MODE: int
NV_CTRL_VCSC_HIGH_PERF_MODE_DISABLE: int
NV_CTRL_VCSC_HIGH_PERF_MODE_ENABLE: int
NV_CTRL_DISPLAYPORT_LINK_RATE: int
NV_CTRL_DISPLAYPORT_LINK_RATE_DISABLED: int
NV_CTRL_DISPLAYPORT_LINK_RATE_1_62GBPS: int
NV_CTRL_DISPLAYPORT_LINK_RATE_2_70GBPS: int
NV_CTRL_STEREO_EYES_EXCHANGE: int
NV_CTRL_STEREO_EYES_EXCHANGE_OFF: int
NV_CTRL_STEREO_EYES_EXCHANGE_ON: int
NV_CTRL_NO_SCANOUT: int
NV_CTRL_NO_SCANOUT_DISABLED: int
NV_CTRL_NO_SCANOUT_ENABLED: int
NV_CTRL_GVO_CSC_CHANGED_EVENT: int
NV_CTRL_FRAMELOCK_SLAVEABLE: int
NV_CTRL_GVO_SYNC_TO_DISPLAY: int
NV_CTRL_GVO_SYNC_TO_DISPLAY_DISABLE: int
NV_CTRL_GVO_SYNC_TO_DISPLAY_ENABLE: int
NV_CTRL_X_SERVER_UNIQUE_ID: int
NV_CTRL_PIXMAP_CACHE: int
NV_CTRL_PIXMAP_CACHE_DISABLE: int
NV_CTRL_PIXMAP_CACHE_ENABLE: int
NV_CTRL_PIXMAP_CACHE_ROUNDING_SIZE_KB: int
NV_CTRL_IS_GVO_DISPLAY: int
NV_CTRL_IS_GVO_DISPLAY_FALSE: int
NV_CTRL_IS_GVO_DISPLAY_TRUE: int
NV_CTRL_PCI_ID: int
NV_CTRL_GVO_FULL_RANGE_COLOR: int
NV_CTRL_GVO_FULL_RANGE_COLOR_DISABLED: int
NV_CTRL_GVO_FULL_RANGE_COLOR_ENABLED: int
NV_CTRL_SLI_MOSAIC_MODE_AVAILABLE: int
NV_CTRL_SLI_MOSAIC_MODE_AVAILABLE_FALSE: int
NV_CTRL_SLI_MOSAIC_MODE_AVAILABLE_TRUE: int
NV_CTRL_GVO_ENABLE_RGB_DATA: int
NV_CTRL_GVO_ENABLE_RGB_DATA_DISABLE: int
NV_CTRL_GVO_ENABLE_RGB_DATA_ENABLE: int
NV_CTRL_IMAGE_SHARPENING_DEFAULT: int
NV_CTRL_PCI_DOMAIN: int
NV_CTRL_GVI_NUM_JACKS: int
NV_CTRL_GVI_MAX_LINKS_PER_STREAM: int
NV_CTRL_GVI_DETECTED_CHANNEL_BITS_PER_COMPONENT: int
NV_CTRL_GVI_BITS_PER_COMPONENT_UNKNOWN: int
NV_CTRL_GVI_BITS_PER_COMPONENT_8: int
NV_CTRL_GVI_BITS_PER_COMPONENT_10: int
NV_CTRL_GVI_BITS_PER_COMPONENT_12: int
NV_CTRL_GVI_REQUESTED_STREAM_BITS_PER_COMPONENT: int
NV_CTRL_GVI_DETECTED_CHANNEL_COMPONENT_SAMPLING: int
NV_CTRL_GVI_COMPONENT_SAMPLING_UNKNOWN: int
NV_CTRL_GVI_COMPONENT_SAMPLING_4444: int
NV_CTRL_GVI_COMPONENT_SAMPLING_4224: int
NV_CTRL_GVI_COMPONENT_SAMPLING_444: int
NV_CTRL_GVI_COMPONENT_SAMPLING_422: int
NV_CTRL_GVI_COMPONENT_SAMPLING_420: int
NV_CTRL_GVI_REQUESTED_STREAM_COMPONENT_SAMPLING: int
NV_CTRL_GVI_REQUESTED_STREAM_CHROMA_EXPAND: int
NV_CTRL_GVI_CHROMA_EXPAND_FALSE: int
NV_CTRL_GVI_CHROMA_EXPAND_TRUE: int
NV_CTRL_GVI_DETECTED_CHANNEL_COLOR_SPACE: int
NV_CTRL_GVI_COLOR_SPACE_UNKNOWN: int
NV_CTRL_GVI_COLOR_SPACE_GBR: int
NV_CTRL_GVI_COLOR_SPACE_GBRA: int
NV_CTRL_GVI_COLOR_SPACE_GBRD: int
NV_CTRL_GVI_COLOR_SPACE_YCBCR: int
NV_CTRL_GVI_COLOR_SPACE_YCBCRA: int
NV_CTRL_GVI_COLOR_SPACE_YCBCRD: int
NV_CTRL_GVI_DETECTED_CHANNEL_LINK_ID: int
NV_CTRL_GVI_LINK_ID_UNKNOWN: int
NV_CTRL_GVI_DETECTED_CHANNEL_SMPTE352_IDENTIFIER: int
NV_CTRL_GVI_GLOBAL_IDENTIFIER: int
NV_CTRL_FRAMELOCK_SYNC_DELAY_RESOLUTION: int
NV_CTRL_GPU_COOLER_MANUAL_CONTROL: int
NV_CTRL_GPU_COOLER_MANUAL_CONTROL_FALSE: int
NV_CTRL_GPU_COOLER_MANUAL_CONTROL_TRUE: int
NV_CTRL_THERMAL_COOLER_LEVEL: int
NV_CTRL_THERMAL_COOLER_LEVEL_SET_DEFAULT: int
NV_CTRL_THERMAL_COOLER_CONTROL_TYPE: int
NV_CTRL_THERMAL_COOLER_CONTROL_TYPE_NONE: int
NV_CTRL_THERMAL_COOLER_CONTROL_TYPE_TOGGLE: int
NV_CTRL_THERMAL_COOLER_CONTROL_TYPE_VARIABLE: int
NV_CTRL_THERMAL_COOLER_TARGET: int
NV_CTRL_THERMAL_COOLER_TARGET_NONE: int
NV_CTRL_THERMAL_COOLER_TARGET_GPU: int
NV_CTRL_THERMAL_COOLER_TARGET_MEMORY: int
NV_CTRL_THERMAL_COOLER_TARGET_POWER_SUPPLY: int
NV_CTRL_THERMAL_COOLER_TARGET_GPU_RELATED: int
NV_CTRL_GPU_ECC_SUPPORTED: int
NV_CTRL_GPU_ECC_SUPPORTED_FALSE: int
NV_CTRL_GPU_ECC_SUPPORTED_TRUE: int
NV_CTRL_GPU_ECC_STATUS: int
NV_CTRL_GPU_ECC_STATUS_DISABLED: int
NV_CTRL_GPU_ECC_STATUS_ENABLED: int
NV_CTRL_GPU_ECC_CONFIGURATION_SUPPORTED: int
NV_CTRL_GPU_ECC_CONFIGURATION_SUPPORTED_FALSE: int
NV_CTRL_GPU_ECC_CONFIGURATION_SUPPORTED_TRUE: int
NV_CTRL_GPU_ECC_CONFIGURATION: int
NV_CTRL_GPU_ECC_CONFIGURATION_DISABLED: int
NV_CTRL_GPU_ECC_CONFIGURATION_ENABLED: int
NV_CTRL_GPU_ECC_DEFAULT_CONFIGURATION: int
NV_CTRL_GPU_ECC_DEFAULT_CONFIGURATION_DISABLED: int
NV_CTRL_GPU_ECC_DEFAULT_CONFIGURATION_ENABLED: int
NV_CTRL_GPU_ECC_SINGLE_BIT_ERRORS: int
NV_CTRL_GPU_ECC_DOUBLE_BIT_ERRORS: int
NV_CTRL_GPU_ECC_AGGREGATE_SINGLE_BIT_ERRORS: int
NV_CTRL_GPU_ECC_AGGREGATE_DOUBLE_BIT_ERRORS: int
NV_CTRL_GPU_ECC_RESET_ERROR_STATUS: int
NV_CTRL_GPU_ECC_RESET_ERROR_STATUS_VOLATILE: int
NV_CTRL_GPU_ECC_RESET_ERROR_STATUS_AGGREGATE: int
NV_CTRL_GPU_POWER_MIZER_MODE: int
NV_CTRL_GPU_POWER_MIZER_MODE_ADAPTIVE: int
NV_CTRL_GPU_POWER_MIZER_MODE_PREFER_MAXIMUM_PERFORMANCE: int
NV_CTRL_GPU_POWER_MIZER_MODE_AUTO: int
NV_CTRL_GPU_POWER_MIZER_MODE_PREFER_CONSISTENT_PERFORMANCE: int
NV_CTRL_GVI_SYNC_OUTPUT_FORMAT: int
NV_CTRL_GVI_MAX_CHANNELS_PER_JACK: int
NV_CTRL_GVI_MAX_STREAMS: int
NV_CTRL_GVI_NUM_CAPTURE_SURFACES: int
NV_CTRL_OVERSCAN_COMPENSATION: int
NV_CTRL_GPU_PCIE_GENERATION: int
NV_CTRL_GPU_PCIE_GENERATION1: int
NV_CTRL_GPU_PCIE_GENERATION2: int
NV_CTRL_GPU_PCIE_GENERATION3: int
NV_CTRL_GVI_BOUND_GPU: int
NV_CTRL_GVIO_REQUESTED_VIDEO_FORMAT3: int
NV_CTRL_ACCELERATE_TRAPEZOIDS: int
NV_CTRL_ACCELERATE_TRAPEZOIDS_DISABLE: int
NV_CTRL_ACCELERATE_TRAPEZOIDS_ENABLE: int
NV_CTRL_GPU_CORES: int
NV_CTRL_GPU_MEMORY_BUS_WIDTH: int
NV_CTRL_GVI_TEST_MODE: int
NV_CTRL_GVI_TEST_MODE_DISABLE: int
NV_CTRL_GVI_TEST_MODE_ENABLE: int
NV_CTRL_COLOR_SPACE: int
NV_CTRL_COLOR_SPACE_RGB: int
NV_CTRL_COLOR_SPACE_YCbCr422: int
NV_CTRL_COLOR_SPACE_YCbCr444: int
NV_CTRL_COLOR_RANGE: int
NV_CTRL_COLOR_RANGE_FULL: int
NV_CTRL_COLOR_RANGE_LIMITED: int
NV_CTRL_GPU_SCALING_DEFAULT_TARGET: int
NV_CTRL_GPU_SCALING_DEFAULT_METHOD: int
NV_CTRL_DITHERING_MODE: int
NV_CTRL_DITHERING_MODE_AUTO: int
NV_CTRL_DITHERING_MODE_DYNAMIC_2X2: int
NV_CTRL_DITHERING_MODE_STATIC_2X2: int
NV_CTRL_DITHERING_MODE_TEMPORAL: int
NV_CTRL_CURRENT_DITHERING: int
NV_CTRL_CURRENT_DITHERING_DISABLED: int
NV_CTRL_CURRENT_DITHERING_ENABLED: int
NV_CTRL_CURRENT_DITHERING_MODE: int
NV_CTRL_CURRENT_DITHERING_MODE_NONE: int
NV_CTRL_CURRENT_DITHERING_MODE_DYNAMIC_2X2: int
NV_CTRL_CURRENT_DITHERING_MODE_STATIC_2X2: int
NV_CTRL_CURRENT_DITHERING_MODE_TEMPORAL: int
NV_CTRL_THERMAL_SENSOR_READING: int
NV_CTRL_THERMAL_SENSOR_PROVIDER: int
NV_CTRL_THERMAL_SENSOR_PROVIDER_NONE: int
NV_CTRL_THERMAL_SENSOR_PROVIDER_GPU_INTERNAL: int
NV_CTRL_THERMAL_SENSOR_PROVIDER_ADM1032: int
NV_CTRL_THERMAL_SENSOR_PROVIDER_ADT7461: int
NV_CTRL_THERMAL_SENSOR_PROVIDER_MAX6649: int
NV_CTRL_THERMAL_SENSOR_PROVIDER_MAX1617: int
NV_CTRL_THERMAL_SENSOR_PROVIDER_LM99: int
NV_CTRL_THERMAL_SENSOR_PROVIDER_LM89: int
NV_CTRL_THERMAL_SENSOR_PROVIDER_LM64: int
NV_CTRL_THERMAL_SENSOR_PROVIDER_G781: int
NV_CTRL_THERMAL_SENSOR_PROVIDER_ADT7473: int
NV_CTRL_THERMAL_SENSOR_PROVIDER_SBMAX6649: int
NV_CTRL_THERMAL_SENSOR_PROVIDER_VBIOSEVT: int
NV_CTRL_THERMAL_SENSOR_PROVIDER_OS: int
NV_CTRL_THERMAL_SENSOR_PROVIDER_UNKNOWN: int
NV_CTRL_THERMAL_SENSOR_TARGET: int
NV_CTRL_THERMAL_SENSOR_TARGET_NONE: int
NV_CTRL_THERMAL_SENSOR_TARGET_GPU: int
NV_CTRL_THERMAL_SENSOR_TARGET_MEMORY: int
NV_CTRL_THERMAL_SENSOR_TARGET_POWER_SUPPLY: int
NV_CTRL_THERMAL_SENSOR_TARGET_BOARD: int
NV_CTRL_THERMAL_SENSOR_TARGET_UNKNOWN: int
NV_CTRL_SHOW_MULTIGPU_VISUAL_INDICATOR: int
NV_CTRL_SHOW_MULTIGPU_VISUAL_INDICATOR_FALSE: int
NV_CTRL_SHOW_MULTIGPU_VISUAL_INDICATOR_TRUE: int
NV_CTRL_GPU_CURRENT_PROCESSOR_CLOCK_FREQS: int
NV_CTRL_GVIO_VIDEO_FORMAT_FLAGS: int
NV_CTRL_GVIO_VIDEO_FORMAT_FLAGS_NONE: int
NV_CTRL_GVIO_VIDEO_FORMAT_FLAGS_INTERLACED: int
NV_CTRL_GVIO_VIDEO_FORMAT_FLAGS_PROGRESSIVE: int
NV_CTRL_GVIO_VIDEO_FORMAT_FLAGS_PSF: int
NV_CTRL_GVIO_VIDEO_FORMAT_FLAGS_3G_LEVEL_A: int
NV_CTRL_GVIO_VIDEO_FORMAT_FLAGS_3G_LEVEL_B: int
NV_CTRL_GVIO_VIDEO_FORMAT_FLAGS_3G: int
NV_CTRL_GVIO_VIDEO_FORMAT_FLAGS_3G_1080P_NO_12BPC: int
NV_CTRL_GPU_PCIE_MAX_LINK_SPEED: int
NV_CTRL_3D_VISION_PRO_RESET_TRANSCEIVER_TO_FACTORY_SETTINGS: int
NV_CTRL_3D_VISION_PRO_TRANSCEIVER_CHANNEL: int
NV_CTRL_3D_VISION_PRO_TRANSCEIVER_MODE: int
NV_CTRL_3D_VISION_PRO_TRANSCEIVER_MODE_INVALID: int
NV_CTRL_3D_VISION_PRO_TRANSCEIVER_MODE_LOW_RANGE: int
NV_CTRL_3D_VISION_PRO_TRANSCEIVER_MODE_MEDIUM_RANGE: int
NV_CTRL_3D_VISION_PRO_TRANSCEIVER_MODE_HIGH_RANGE: int
NV_CTRL_3D_VISION_PRO_TRANSCEIVER_MODE_COUNT: int
NV_CTRL_SYNCHRONOUS_PALETTE_UPDATES: int
NV_CTRL_SYNCHRONOUS_PALETTE_UPDATES_DISABLE: int
NV_CTRL_SYNCHRONOUS_PALETTE_UPDATES_ENABLE: int
NV_CTRL_DITHERING_DEPTH: int
NV_CTRL_DITHERING_DEPTH_AUTO: int
NV_CTRL_DITHERING_DEPTH_6_BITS: int
NV_CTRL_DITHERING_DEPTH_8_BITS: int
NV_CTRL_CURRENT_DITHERING_DEPTH: int
NV_CTRL_CURRENT_DITHERING_DEPTH_NONE: int
NV_CTRL_CURRENT_DITHERING_DEPTH_6_BITS: int
NV_CTRL_CURRENT_DITHERING_DEPTH_8_BITS: int
NV_CTRL_3D_VISION_PRO_TRANSCEIVER_CHANNEL_FREQUENCY: int
NV_CTRL_3D_VISION_PRO_TRANSCEIVER_CHANNEL_QUALITY: int
NV_CTRL_3D_VISION_PRO_TRANSCEIVER_CHANNEL_COUNT: int
NV_CTRL_3D_VISION_PRO_PAIR_GLASSES: int
NV_CTRL_3D_VISION_PRO_PAIR_GLASSES_STOP: int
NV_CTRL_3D_VISION_PRO_PAIR_GLASSES_BEACON: int
NV_CTRL_3D_VISION_PRO_UNPAIR_GLASSES: int
NV_CTRL_3D_VISION_PRO_DISCOVER_GLASSES: int
NV_CTRL_3D_VISION_PRO_IDENTIFY_GLASSES: int
NV_CTRL_3D_VISION_PRO_GLASSES_SYNC_CYCLE: int
NV_CTRL_3D_VISION_PRO_GLASSES_MISSED_SYNC_CYCLES: int
NV_CTRL_3D_VISION_PRO_GLASSES_BATTERY_LEVEL: int
NV_CTRL_GVO_ANC_PARITY_COMPUTATION: int
NV_CTRL_GVO_ANC_PARITY_COMPUTATION_AUTO: int
NV_CTRL_GVO_ANC_PARITY_COMPUTATION_ON: int
NV_CTRL_GVO_ANC_PARITY_COMPUTATION_OFF: int
NV_CTRL_3D_VISION_PRO_GLASSES_PAIR_EVENT: int
NV_CTRL_3D_VISION_PRO_GLASSES_UNPAIR_EVENT: int
NV_CTRL_GPU_PCIE_CURRENT_LINK_WIDTH: int
NV_CTRL_GPU_PCIE_CURRENT_LINK_SPEED: int
NV_CTRL_GVO_AUDIO_BLANKING: int
NV_CTRL_GVO_AUDIO_BLANKING_DISABLE: int
NV_CTRL_GVO_AUDIO_BLANKING_ENABLE: int
NV_CTRL_CURRENT_METAMODE_ID: int
NV_CTRL_DISPLAY_ENABLED: int
NV_CTRL_DISPLAY_ENABLED_TRUE: int
NV_CTRL_DISPLAY_ENABLED_FALSE: int
NV_CTRL_FRAMELOCK_INCOMING_HOUSE_SYNC_RATE: int
NV_CTRL_FXAA: int
NV_CTRL_FXAA_DISABLE: int
NV_CTRL_FXAA_ENABLE: int
NV_CTRL_DISPLAY_RANDR_OUTPUT_ID: int
NV_CTRL_FRAMELOCK_DISPLAY_CONFIG: int
NV_CTRL_FRAMELOCK_DISPLAY_CONFIG_DISABLED: int
NV_CTRL_FRAMELOCK_DISPLAY_CONFIG_CLIENT: int
NV_CTRL_FRAMELOCK_DISPLAY_CONFIG_SERVER: int
NV_CTRL_TOTAL_DEDICATED_GPU_MEMORY: int
NV_CTRL_USED_DEDICATED_GPU_MEMORY: int
NV_CTRL_GPU_DOUBLE_PRECISION_BOOST_IMMEDIATE: int
NV_CTRL_GPU_DOUBLE_PRECISION_BOOST_IMMEDIATE_DISABLED: int
NV_CTRL_GPU_DOUBLE_PRECISION_BOOST_IMMEDIATE_ENABLED: int
NV_CTRL_GPU_DOUBLE_PRECISION_BOOST_REBOOT: int
NV_CTRL_GPU_DOUBLE_PRECISION_BOOST_REBOOT_DISABLED: int
NV_CTRL_GPU_DOUBLE_PRECISION_BOOST_REBOOT_ENALED: int
NV_CTRL_DPY_HDMI_3D: int
NV_CTRL_DPY_HDMI_3D_DISABLED: int
NV_CTRL_DPY_HDMI_3D_ENABLED: int
NV_CTRL_BASE_MOSAIC: int
NV_CTRL_BASE_MOSAIC_DISABLED: int
NV_CTRL_BASE_MOSAIC_FULL: int
NV_CTRL_BASE_MOSAIC_LIMITED: int
NV_CTRL_MULTIGPU_MASTER_POSSIBLE: int
NV_CTRL_MULTIGPU_MASTER_POSSIBLE_FALSE: int
NV_CTRL_MULTIGPU_MASTER_POSSIBLE_TRUE: int
NV_CTRL_GPU_POWER_MIZER_DEFAULT_MODE: int
NV_CTRL_XV_SYNC_TO_DISPLAY_ID: int
NV_CTRL_XV_SYNC_TO_DISPLAY_ID_AUTO: int
NV_CTRL_BACKLIGHT_BRIGHTNESS: int
NV_CTRL_GPU_LOGO_BRIGHTNESS: int
NV_CTRL_GPU_SLI_LOGO_BRIGHTNESS: int
NV_CTRL_THERMAL_COOLER_SPEED: int
NV_CTRL_PALETTE_UPDATE_EVENT: int
NV_CTRL_VIDEO_ENCODER_UTILIZATION: int
NV_CTRL_GSYNC_ALLOWED: int
NV_CTRL_GSYNC_ALLOWED_FALSE: int
NV_CTRL_GSYNC_ALLOWED_TRUE: int
NV_CTRL_GPU_NVCLOCK_OFFSET: int
NV_CTRL_GPU_MEM_TRANSFER_RATE_OFFSET: int
NV_CTRL_VIDEO_DECODER_UTILIZATION: int
NV_CTRL_GPU_OVER_VOLTAGE_OFFSET: int
NV_CTRL_GPU_CURRENT_CORE_VOLTAGE: int
NV_CTRL_CURRENT_COLOR_SPACE: int
NV_CTRL_CURRENT_COLOR_SPACE_RGB: int
NV_CTRL_CURRENT_COLOR_SPACE_YCbCr422: int
NV_CTRL_CURRENT_COLOR_SPACE_YCbCr444: int
NV_CTRL_CURRENT_COLOR_SPACE_YCbCr420: int
NV_CTRL_CURRENT_COLOR_RANGE: int
NV_CTRL_CURRENT_COLOR_RANGE_FULL: int
NV_CTRL_CURRENT_COLOR_RANGE_LIMITED: int
NV_CTRL_SHOW_GSYNC_VISUAL_INDICATOR: int
NV_CTRL_SHOW_GSYNC_VISUAL_INDICATOR_FALSE: int
NV_CTRL_SHOW_GSYNC_VISUAL_INDICATOR_TRUE: int
NV_CTRL_THERMAL_COOLER_CURRENT_LEVEL: int
NV_CTRL_STEREO_SWAP_MODE: int
NV_CTRL_STEREO_SWAP_MODE_APPLICATION_CONTROL: int
NV_CTRL_STEREO_SWAP_MODE_PER_EYE: int
NV_CTRL_STEREO_SWAP_MODE_PER_EYE_PAIR: int
NV_CTRL_CURRENT_XV_SYNC_TO_DISPLAY_ID: int
NV_CTRL_GPU_FRAMELOCK_FIRMWARE_UNSUPPORTED: int
NV_CTRL_GPU_FRAMELOCK_FIRMWARE_UNSUPPORTED_FALSE: int
NV_CTRL_GPU_FRAMELOCK_FIRMWARE_UNSUPPORTED_TRUE: int
NV_CTRL_DISPLAYPORT_CONNECTOR_TYPE: int
NV_CTRL_DISPLAYPORT_CONNECTOR_TYPE_UNKNOWN: int
NV_CTRL_DISPLAYPORT_CONNECTOR_TYPE_DISPLAYPORT: int
NV_CTRL_DISPLAYPORT_CONNECTOR_TYPE_HDMI: int
NV_CTRL_DISPLAYPORT_CONNECTOR_TYPE_DVI: int
NV_CTRL_DISPLAYPORT_CONNECTOR_TYPE_VGA: int
NV_CTRL_DISPLAYPORT_IS_MULTISTREAM: int
NV_CTRL_DISPLAYPORT_SINK_IS_AUDIO_CAPABLE: int
NV_CTRL_GPU_NVCLOCK_OFFSET_ALL_PERFORMANCE_LEVELS: int
NV_CTRL_GPU_MEM_TRANSFER_RATE_OFFSET_ALL_PERFORMANCE_LEVELS: int
NV_CTRL_FRAMELOCK_FIRMWARE_VERSION: int
NV_CTRL_FRAMELOCK_FIRMWARE_MINOR_VERSION: int
NV_CTRL_SHOW_GRAPHICS_VISUAL_INDICATOR: int
NV_CTRL_SHOW_GRAPHICS_VISUAL_INDICATOR_FALSE: int
NV_CTRL_SHOW_GRAPHICS_VISUAL_INDICATOR_TRUE: int
NV_CTRL_LAST_ATTRIBUTE: int
NV_CTRL_STRING_PRODUCT_NAME: int
NV_CTRL_STRING_VBIOS_VERSION: int
NV_CTRL_STRING_NVIDIA_DRIVER_VERSION: int
NV_CTRL_STRING_DISPLAY_DEVICE_NAME: int
NV_CTRL_STRING_TV_ENCODER_NAME: int
NV_CTRL_STRING_GVIO_FIRMWARE_VERSION: int
NV_CTRL_STRING_GVO_FIRMWARE_VERSION: int
NV_CTRL_STRING_CURRENT_MODELINE: int
NV_CTRL_STRING_ADD_MODELINE: int
NV_CTRL_STRING_DELETE_MODELINE: int
NV_CTRL_STRING_CURRENT_METAMODE: int
NV_CTRL_STRING_CURRENT_METAMODE_VERSION_1: int
NV_CTRL_STRING_ADD_METAMODE: int
NV_CTRL_STRING_DELETE_METAMODE: int
NV_CTRL_STRING_VCSC_PRODUCT_NAME: int
NV_CTRL_STRING_VCSC_PRODUCT_ID: int
NV_CTRL_STRING_VCSC_SERIAL_NUMBER: int
NV_CTRL_STRING_VCSC_BUILD_DATE: int
NV_CTRL_STRING_VCSC_FIRMWARE_VERSION: int
NV_CTRL_STRING_VCSC_FIRMWARE_REVISION: int
NV_CTRL_STRING_VCSC_HARDWARE_VERSION: int
NV_CTRL_STRING_VCSC_HARDWARE_REVISION: int
NV_CTRL_STRING_MOVE_METAMODE: int
NV_CTRL_STRING_VALID_HORIZ_SYNC_RANGES: int
NV_CTRL_STRING_VALID_VERT_REFRESH_RANGES: int
NV_CTRL_STRING_SCREEN_RECTANGLE: int
NV_CTRL_STRING_XINERAMA_SCREEN_INFO: int
NV_CTRL_STRING_NVIDIA_XINERAMA_INFO_ORDER: int
NV_CTRL_STRING_TWINVIEW_XINERAMA_INFO_ORDER: int
NV_CTRL_STRING_SLI_MODE: int
NV_CTRL_STRING_PERFORMANCE_MODES: int
NV_CTRL_STRING_VCSC_FAN_STATUS: int
NV_CTRL_STRING_VCSC_TEMPERATURES: int
NV_CTRL_STRING_VCSC_PSU_INFO: int
NV_CTRL_STRING_GVIO_VIDEO_FORMAT_NAME: int
NV_CTRL_STRING_GVO_VIDEO_FORMAT_NAME: int
NV_CTRL_STRING_GPU_CURRENT_CLOCK_FREQS: int
NV_CTRL_STRING_3D_VISION_PRO_TRANSCEIVER_HARDWARE_REVISION: int
NV_CTRL_STRING_3D_VISION_PRO_TRANSCEIVER_FIRMWARE_VERSION_A: int
NV_CTRL_STRING_3D_VISION_PRO_TRANSCEIVER_FIRMWARE_DATE_A: int
NV_CTRL_STRING_3D_VISION_PRO_TRANSCEIVER_FIRMWARE_VERSION_B: int
NV_CTRL_STRING_3D_VISION_PRO_TRANSCEIVER_FIRMWARE_DATE_B: int
NV_CTRL_STRING_3D_VISION_PRO_TRANSCEIVER_ADDRESS: int
NV_CTRL_STRING_3D_VISION_PRO_GLASSES_FIRMWARE_VERSION_A: int
NV_CTRL_STRING_3D_VISION_PRO_GLASSES_FIRMWARE_DATE_A: int
NV_CTRL_STRING_3D_VISION_PRO_GLASSES_ADDRESS: int
NV_CTRL_STRING_3D_VISION_PRO_GLASSES_NAME: int
NV_CTRL_STRING_CURRENT_METAMODE_VERSION_2: int
NV_CTRL_STRING_DISPLAY_NAME_TYPE_BASENAME: int
NV_CTRL_STRING_DISPLAY_NAME_TYPE_ID: int
NV_CTRL_STRING_DISPLAY_NAME_DP_GUID: int
NV_CTRL_STRING_DISPLAY_NAME_EDID_HASH: int
NV_CTRL_STRING_DISPLAY_NAME_TARGET_INDEX: int
NV_CTRL_STRING_DISPLAY_NAME_RANDR: int
NV_CTRL_STRING_GPU_UUID: int
NV_CTRL_STRING_GPU_UTILIZATION: int
NV_CTRL_STRING_MULTIGPU_MODE: int
NV_CTRL_STRING_PRIME_OUTPUTS_DATA: int
NV_CTRL_STRING_LAST_ATTRIBUTE: int
NV_CTRL_BINARY_DATA_EDID: int
NV_CTRL_BINARY_DATA_MODELINES: int
NV_CTRL_BINARY_DATA_METAMODES: int
NV_CTRL_BINARY_DATA_METAMODES_VERSION_1: int
NV_CTRL_BINARY_DATA_XSCREENS_USING_GPU: int
NV_CTRL_BINARY_DATA_GPUS_USED_BY_XSCREEN: int
NV_CTRL_BINARY_DATA_GPUS_USING_FRAMELOCK: int
NV_CTRL_BINARY_DATA_DISPLAY_VIEWPORT: int
NV_CTRL_BINARY_DATA_FRAMELOCKS_USED_BY_GPU: int
NV_CTRL_BINARY_DATA_GPUS_USING_VCSC: int
NV_CTRL_BINARY_DATA_VCSCS_USED_BY_GPU: int
NV_CTRL_BINARY_DATA_COOLERS_USED_BY_GPU: int
NV_CTRL_BINARY_DATA_GPUS_USED_BY_LOGICAL_XSCREEN: int
NV_CTRL_BINARY_DATA_THERMAL_SENSORS_USED_BY_GPU: int
NV_CTRL_BINARY_DATA_GLASSES_PAIRED_TO_3D_VISION_PRO_TRANSCEIVER: int
NV_CTRL_BINARY_DATA_DISPLAY_TARGETS: int
NV_CTRL_BINARY_DATA_DISPLAYS_CONNECTED_TO_GPU: int
NV_CTRL_BINARY_DATA_METAMODES_VERSION_2: int
NV_CTRL_BINARY_DATA_DISPLAYS_ENABLED_ON_XSCREEN: int
NV_CTRL_BINARY_DATA_DISPLAYS_ASSIGNED_TO_XSCREEN: int
NV_CTRL_BINARY_DATA_GPU_FLAGS: int
NV_CTRL_BINARY_DATA_GPU_FLAGS_STEREO_DISPLAY_TRANSFORM_EXCLUSIVE: int
NV_CTRL_BINARY_DATA_GPU_FLAGS_OVERLAY_DISPLAY_TRANSFORM_EXCLUSIVE: int
NV_CTRL_BINARY_DATA_GPU_FLAGS_DEPTH_8_DISPLAY_TRANSFORM_EXCLUSIVE: int
NV_CTRL_BINARY_DATA_DISPLAYS_ON_GPU: int
NV_CTRL_BINARY_DATA_LAST_ATTRIBUTE: int
NV_CTRL_STRING_OPERATION_ADD_METAMODE: int
NV_CTRL_STRING_OPERATION_GTF_MODELINE: int
NV_CTRL_STRING_OPERATION_CVT_MODELINE: int
NV_CTRL_STRING_OPERATION_BUILD_MODEPOOL: int
NV_CTRL_STRING_OPERATION_GVI_CONFIGURE_STREAMS: int
NV_CTRL_STRING_OPERATION_PARSE_METAMODE: int
NV_CTRL_STRING_OPERATION_LAST_ATTRIBUTE: int
X_nvCtrlQueryExtension: int
X_nvCtrlQueryAttribute: int
X_nvCtrlQueryStringAttribute: int
X_nvCtrlQueryValidAttributeValues: int
X_nvCtrlSetStringAttribute: int
X_nvCtrlSetAttributeAndGetStatus: int
X_nvCtrlQueryBinaryData: int
X_nvCtrlQueryTargetCount: int
X_nvCtrlStringOperation: int
ATTRIBUTE_TYPE_UNKNOWN: int
ATTRIBUTE_TYPE_INTEGER: int
ATTRIBUTE_TYPE_BITMASK: int
ATTRIBUTE_TYPE_BOOL: int
ATTRIBUTE_TYPE_RANGE: int
ATTRIBUTE_TYPE_INT_BITS: int
ATTRIBUTE_TYPE_READ: int
ATTRIBUTE_TYPE_WRITE: int
ATTRIBUTE_TYPE_DISPLAY: int
ATTRIBUTE_TYPE_GPU: int
ATTRIBUTE_TYPE_FRAMELOCK: int
ATTRIBUTE_TYPE_X_SCREEN: int
ATTRIBUTE_TYPE_XINERAMA: int
ATTRIBUTE_TYPE_VCSC: int
NV_CTRL_TARGET_TYPE_X_SCREEN: int
NV_CTRL_TARGET_TYPE_GPU: int
NV_CTRL_TARGET_TYPE_FRAMELOCK: int
NV_CTRL_TARGET_TYPE_VCSC: int
NV_CTRL_TARGET_TYPE_GVI: int
NV_CTRL_TARGET_TYPE_COOLER: int
NV_CTRL_TARGET_TYPE_THERMAL_SENSOR: int
NV_CTRL_TARGET_TYPE_3D_VISION_PRO_TRANSCEIVER: int
NV_CTRL_TARGET_TYPE_DISPLAY: int

class Target:
    def id(self) -> int: ...
    def type(self) -> int: ...

class Gpu(Target):
    def __init__(self, ngpu: int = ...) -> None: ...

class Screen(Target):
    def __init__(self, nscr: int = ...) -> None: ...

class Cooler(Target):
    def __init__(self, nfan: int = ...) -> None: ...

class NVCtrlQueryTargetCountReplyRequest(rq.ReplyRequest): ...
class NVCtrlQueryAttributeReplyRequest(rq.ReplyRequest): ...
class NVCtrlSetAttributeAndGetStatusReplyRequest(rq.ReplyRequest): ...
class NVCtrlQueryStringAttributeReplyRequest(rq.ReplyRequest): ...
class NVCtrlQueryValidAttributeValuesReplyRequest(rq.ReplyRequest): ...
class NVCtrlQueryBinaryDataReplyRequest(rq.ReplyRequest): ...
class NVCtrlQueryListCard32ReplyRequest(rq.ReplyRequest): ...
