/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SingleSelectionModel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.openide.windows.TopComponent;

public abstract class TabDisplayerUI
extends ComponentUI {
    protected SingleSelectionModel selectionModel = null;
    protected final TabDisplayer displayer;
    private static Map<Integer, String[]> buttonIconPaths;

    protected TabDisplayerUI(TabDisplayer tabDisplayer) {
        this.displayer = tabDisplayer;
    }

    @Override
    public void installUI(JComponent jComponent) {
        assert (jComponent == this.displayer);
        this.selectionModel = this.displayer.getSelectionModel();
        if (this.selectionModel == null) {
            this.selectionModel = this.createSelectionModel();
        }
        this.installSelectionModel();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        assert (jComponent == this.displayer);
    }

    protected Font getTxtFont() {
        Font font = UIManager.getFont("TabbedPane.font");
        if (font != null) {
            return font;
        }
        font = UIManager.getFont("controlFont");
        return font;
    }

    public abstract Polygon getExactTabIndication(int var1);

    public abstract Polygon getInsertTabIndication(int var1);

    public abstract int tabForCoordinate(Point var1);

    public abstract Rectangle getTabRect(int var1, Rectangle var2);

    public Image createImageOfTab(int n) {
        return null;
    }

    protected abstract SingleSelectionModel createSelectionModel();

    protected final boolean shouldPerformAction(String string, int n, MouseEvent mouseEvent) {
        TabActionEvent tabActionEvent = new TabActionEvent((Object)this.displayer, string, n, mouseEvent);
        this.displayer.postActionEvent(tabActionEvent);
        return !tabActionEvent.isConsumed();
    }

    protected final boolean shouldPerformAction(TabActionEvent tabActionEvent) {
        TabActionEvent tabActionEvent2 = new TabActionEvent((Object)this.displayer, tabActionEvent.getActionCommand(), tabActionEvent.getTabIndex(), tabActionEvent.getMouseEvent());
        tabActionEvent2.setGroupName(tabActionEvent.getGroupName());
        this.displayer.postActionEvent(tabActionEvent2);
        return !tabActionEvent2.isConsumed();
    }

    public void makeTabVisible(int n) {
    }

    public final boolean isTabBusy(int n) {
        WinsysInfoForTabbedContainer winsysInfoForTabbedContainer = this.displayer.getContainerWinsysInfo();
        if (null == winsysInfoForTabbedContainer) {
            return false;
        }
        TabDataModel tabDataModel = this.displayer.getModel();
        if (n < 0 || n >= tabDataModel.size()) {
            return false;
        }
        TabData tabData = tabDataModel.getTab(n);
        if (tabData.getComponent() instanceof TopComponent) {
            return winsysInfoForTabbedContainer.isTopComponentBusy((TopComponent)tabData.getComponent());
        }
        return false;
    }

    private void installSelectionModel() {
        this.displayer.setSelectionModel(this.selectionModel);
    }

    public abstract int dropIndexOfPoint(Point var1);

    public abstract void registerShortcuts(JComponent var1);

    public abstract void unregisterShortcuts(JComponent var1);

    protected abstract void requestAttention(int var1);

    protected abstract void cancelRequestAttention(int var1);

    protected void setAttentionHighlight(int n, boolean bl) {
    }

    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        TabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }

    public void postTabAction(TabActionEvent tabActionEvent) {
        if (this.shouldPerformAction(tabActionEvent)) {
            // empty if block
        }
    }

    public Insets getAutoscrollInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void autoscroll(Point point) {
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            String[] stringArray;
            buttonIconPaths = new HashMap<Integer, String[]>(10);
            stringArray = new String[]{"org/openide/awt/resources/metal_bigclose_enabled.png", "org/openide/awt/resources/metal_bigclose_pressed.png", stringArray[0], "org/openide/awt/resources/metal_bigclose_rollover.png"};
            buttonIconPaths.put(1, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/metal_slideright_enabled.png", "org/netbeans/swing/tabcontrol/resources/metal_slideright_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/metal_slideright_rollover.png"};
            buttonIconPaths.put(6, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/metal_slideleft_enabled.png", "org/netbeans/swing/tabcontrol/resources/metal_slideleft_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/metal_slideleft_rollover.png"};
            buttonIconPaths.put(5, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/metal_slidebottom_enabled.png", "org/netbeans/swing/tabcontrol/resources/metal_slidebottom_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/metal_slidebottom_rollover.png"};
            buttonIconPaths.put(7, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/metal_pin_enabled.png", "org/netbeans/swing/tabcontrol/resources/metal_pin_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/metal_pin_rollover.png"};
            buttonIconPaths.put(2, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/metal_scrollleft_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/metal_scrollleft_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/metal_scrollleft_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/metal_scrollleft_pressed.png";
            buttonIconPaths.put(9, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/metal_scrollright_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/metal_scrollright_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/metal_scrollright_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/metal_scrollright_pressed.png";
            buttonIconPaths.put(10, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/metal_popup_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/metal_popup_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/metal_popup_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/metal_popup_pressed.png";
            buttonIconPaths.put(8, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/metal_maximize_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/metal_maximize_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/metal_maximize_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/metal_maximize_pressed.png";
            buttonIconPaths.put(3, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/metal_restore_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/metal_restore_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/metal_restore_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/metal_restore_pressed.png";
            buttonIconPaths.put(4, stringArray);
        }
    }
}

