/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.table.model;

import com.sun.javafx.scene.control.ReadOnlyUnbackedObservableList;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.controlsfx.control.table.model.JavaFXTableModel;
import org.controlsfx.control.table.model.TableModelRow;
import org.controlsfx.control.table.model.TableModelValueFactory;

class TableModelTableView<S>
extends TableView<TableModelRow<S>> {
    public TableModelTableView(final JavaFXTableModel<S> tableModel) {
        this.setItems((ObservableList)new ReadOnlyUnbackedObservableList<TableModelRow<S>>(){

            public TableModelRow<S> get(int row) {
                if (row < 0 || row >= tableModel.getRowCount()) {
                    return null;
                }
                TableModelRow backingRow = new TableModelRow(tableModel, row);
                return backingRow;
            }

            public int size() {
                return tableModel.getRowCount();
            }
        });
        this.setSortPolicy(table -> {
            tableModel.sort((TableView)table);
            return true;
        });
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            TableColumn column = new TableColumn(tableModel.getColumnName(i));
            column.setCellValueFactory(new TableModelValueFactory(tableModel, i));
            this.getColumns().add((Object)column);
        }
    }
}

