/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.opensearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.opensearch.action.admin.cluster.settings.ClusterGetSettingsResponse;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.cluster.stats.ClusterStatsRequest;
import org.opensearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.opensearch.action.admin.cluster.tasks.PendingClusterTasksRequest;
import org.opensearch.action.admin.cluster.tasks.PendingClusterTasksResponse;
import org.opensearch.action.admin.indices.recovery.RecoveryRequest;
import org.opensearch.action.admin.indices.recovery.RecoveryResponse;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.SupportedClusterMetricsSettings;
import org.opensearch.client.Client;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.commons.alerting.model.ClusterMetricsInput;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001aJ\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\"\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b0\fj\b\u0012\u0004\u0012\u00020\b`\r0\u0007\u001a\u0016\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007*\u00020\u0001\u00a8\u0006\u000f"}, d2={"executeTransportAction", "Lorg/opensearch/action/ActionResponse;", "clusterMetricsInput", "Lorg/opensearch/commons/alerting/model/ClusterMetricsInput;", "client", "Lorg/opensearch/client/Client;", "redactFieldsFromResponse", "", "", "", "mappedActionResponse", "supportedJsonPayload", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "toMap", "opensearch-alerting"})
public final class SupportedClusterMetricsSettingsExtensionsKt {
    @NotNull
    public static final ActionResponse executeTransportAction(@NotNull ClusterMetricsInput clusterMetricsInput, @NotNull Client client) {
        ActionResponse actionResponse;
        Intrinsics.checkNotNullParameter((Object)clusterMetricsInput, (String)"clusterMetricsInput");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        ActionRequest request = SupportedClusterMetricsSettings.Companion.resolveToActionRequest(clusterMetricsInput);
        switch (WhenMappings.$EnumSwitchMapping$0[clusterMetricsInput.getClusterMetricType().ordinal()]) {
            case 1: {
                Object object = client.admin().cluster().pendingClusterTasks((PendingClusterTasksRequest)request).get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"client.admin().cluster()\u2026lusterTasksRequest).get()");
                actionResponse = (ActionResponse)object;
                break;
            }
            case 2: {
                Object object = client.admin().indices().recoveries((RecoveryRequest)request).get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"client.admin().indices()\u2026as RecoveryRequest).get()");
                actionResponse = (ActionResponse)object;
                break;
            }
            case 3: {
                Object object = client.admin().cluster().getSnapshots((GetSnapshotsRequest)request).get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"client.admin().cluster()\u2026etSnapshotsRequest).get()");
                actionResponse = (ActionResponse)object;
                break;
            }
            case 4: {
                Object object = client.admin().cluster().listTasks((ListTasksRequest)request).get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"client.admin().cluster()\u2026s ListTasksRequest).get()");
                actionResponse = (ActionResponse)object;
                break;
            }
            case 5: {
                Object object = client.admin().cluster().health((ClusterHealthRequest)request).get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"client.admin().cluster()\u2026usterHealthRequest).get()");
                actionResponse = (ActionResponse)object;
                break;
            }
            case 6: {
                org.opensearch.cluster.metadata.Metadata metadata = ((ClusterStateResponse)client.admin().cluster().state((ClusterStateRequest)request).get()).getState().getMetadata();
                return (ActionResponse)new ClusterGetSettingsResponse(metadata.persistentSettings(), metadata.transientSettings(), Settings.EMPTY);
            }
            case 7: {
                Object object = client.admin().cluster().clusterStats((ClusterStatsRequest)request).get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"client.admin().cluster()\u2026lusterStatsRequest).get()");
                actionResponse = (ActionResponse)object;
                break;
            }
            case 8: {
                Object object = client.admin().cluster().nodesStats((NodesStatsRequest)request).get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"client.admin().cluster()\u2026 NodesStatsRequest).get()");
                actionResponse = (ActionResponse)object;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported API request type: " + request.getClass().getName());
            }
        }
        return actionResponse;
    }

    @NotNull
    public static final Map<String, Object> toMap(@NotNull ActionResponse $this$toMap) {
        Map<String, Object> map;
        Intrinsics.checkNotNullParameter((Object)$this$toMap, (String)"<this>");
        ActionResponse actionResponse = $this$toMap;
        if (actionResponse instanceof ClusterHealthResponse) {
            map = SupportedClusterMetricsSettingsExtensionsKt.redactFieldsFromResponse(OpenSearchExtensionsKt.convertToMap((ToXContent)((ToXContent)$this$toMap)), SupportedClusterMetricsSettings.Companion.getSupportedJsonPayload(ClusterMetricsInput.ClusterMetricType.CLUSTER_HEALTH.getDefaultPath()));
        } else if (actionResponse instanceof ClusterStatsResponse) {
            map = SupportedClusterMetricsSettingsExtensionsKt.redactFieldsFromResponse(OpenSearchExtensionsKt.convertToMap((ToXContent)((ToXContent)$this$toMap)), SupportedClusterMetricsSettings.Companion.getSupportedJsonPayload(ClusterMetricsInput.ClusterMetricType.CLUSTER_STATS.getDefaultPath()));
        } else if (actionResponse instanceof ClusterGetSettingsResponse) {
            map = SupportedClusterMetricsSettingsExtensionsKt.redactFieldsFromResponse(OpenSearchExtensionsKt.convertToMap((ToXContent)((ToXContent)$this$toMap)), SupportedClusterMetricsSettings.Companion.getSupportedJsonPayload(ClusterMetricsInput.ClusterMetricType.CLUSTER_SETTINGS.getDefaultPath()));
        } else if (actionResponse instanceof NodesStatsResponse) {
            map = SupportedClusterMetricsSettingsExtensionsKt.redactFieldsFromResponse(OpenSearchExtensionsKt.convertToMap((ToXContent)((ToXContent)$this$toMap)), SupportedClusterMetricsSettings.Companion.getSupportedJsonPayload(ClusterMetricsInput.ClusterMetricType.NODES_STATS.getDefaultPath()));
        } else if (actionResponse instanceof PendingClusterTasksResponse) {
            map = SupportedClusterMetricsSettingsExtensionsKt.redactFieldsFromResponse(OpenSearchExtensionsKt.convertToMap((ToXContent)((ToXContent)$this$toMap)), SupportedClusterMetricsSettings.Companion.getSupportedJsonPayload(ClusterMetricsInput.ClusterMetricType.CAT_PENDING_TASKS.getDefaultPath()));
        } else if (actionResponse instanceof RecoveryResponse) {
            map = SupportedClusterMetricsSettingsExtensionsKt.redactFieldsFromResponse(OpenSearchExtensionsKt.convertToMap((ToXContent)((ToXContent)$this$toMap)), SupportedClusterMetricsSettings.Companion.getSupportedJsonPayload(ClusterMetricsInput.ClusterMetricType.CAT_RECOVERY.getDefaultPath()));
        } else if (actionResponse instanceof GetSnapshotsResponse) {
            map = SupportedClusterMetricsSettingsExtensionsKt.redactFieldsFromResponse(OpenSearchExtensionsKt.convertToMap((ToXContent)((ToXContent)$this$toMap)), SupportedClusterMetricsSettings.Companion.getSupportedJsonPayload(ClusterMetricsInput.ClusterMetricType.CAT_SNAPSHOTS.getDefaultPath()));
        } else if (actionResponse instanceof ListTasksResponse) {
            map = SupportedClusterMetricsSettingsExtensionsKt.redactFieldsFromResponse(OpenSearchExtensionsKt.convertToMap((ToXContent)((ToXContent)$this$toMap)), SupportedClusterMetricsSettings.Companion.getSupportedJsonPayload(ClusterMetricsInput.ClusterMetricType.CAT_TASKS.getDefaultPath()));
        } else {
            throw new IllegalArgumentException("Unsupported ActionResponse type: " + $this$toMap.getClass().getName());
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Object> redactFieldsFromResponse(@NotNull Map<String, ? extends Object> mappedActionResponse, @NotNull Map<String, ? extends ArrayList<String>> supportedJsonPayload) {
        Map map;
        Intrinsics.checkNotNullParameter(mappedActionResponse, (String)"mappedActionResponse");
        Intrinsics.checkNotNullParameter(supportedJsonPayload, (String)"supportedJsonPayload");
        if (supportedJsonPayload.isEmpty()) {
            map = mappedActionResponse;
        } else {
            void var2_2;
            HashMap output = new HashMap();
            for (Map.Entry<String, ? extends ArrayList<String>> entry : supportedJsonPayload.entrySet()) {
                Object object;
                Map map2;
                String key = entry.getKey();
                ArrayList<String> value = entry.getValue();
                Object mappedValue = mappedActionResponse.get(key);
                if (mappedValue instanceof Map) {
                    map2 = output;
                    Collection $this$toTypedArray$iv = value;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    object = XContentMapValues.filter((Map)TypeIntrinsics.asMutableMap(mappedActionResponse.get(key)), (String[])stringArray, (String[])new String[0]);
                    Intrinsics.checkNotNullExpressionValue(object, (String)"filter(\n                \u2026f()\n                    )");
                    map2.put(key, object);
                    continue;
                }
                map2 = output;
                object = mappedValue == null ? new HashMap() : mappedValue;
                map2.put(key, object);
            }
            map = (Map)var2_2;
        }
        return map;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClusterMetricsInput.ClusterMetricType.values().length];
            nArray[ClusterMetricsInput.ClusterMetricType.CAT_PENDING_TASKS.ordinal()] = 1;
            nArray[ClusterMetricsInput.ClusterMetricType.CAT_RECOVERY.ordinal()] = 2;
            nArray[ClusterMetricsInput.ClusterMetricType.CAT_SNAPSHOTS.ordinal()] = 3;
            nArray[ClusterMetricsInput.ClusterMetricType.CAT_TASKS.ordinal()] = 4;
            nArray[ClusterMetricsInput.ClusterMetricType.CLUSTER_HEALTH.ordinal()] = 5;
            nArray[ClusterMetricsInput.ClusterMetricType.CLUSTER_SETTINGS.ordinal()] = 6;
            nArray[ClusterMetricsInput.ClusterMetricType.CLUSTER_STATS.ordinal()] = 7;
            nArray[ClusterMetricsInput.ClusterMetricType.NODES_STATS.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

