/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical.catalog;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.catalog.CatalogService;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.planner.DefaultImplementor;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.catalog.CatalogTableScan;
import org.opensearch.sql.planner.physical.catalog.CatalogTableSchema;
import org.opensearch.sql.storage.Table;

public class CatalogTable
implements Table {
    private final CatalogService catalogService;

    @Override
    public Map<String, ExprType> getFieldTypes() {
        return CatalogTableSchema.CATALOG_TABLE_SCHEMA.getMapping();
    }

    @Override
    public PhysicalPlan implement(LogicalPlan plan) {
        return plan.accept(new CatalogTableDefaultImplementor(this.catalogService), null);
    }

    @Generated
    public CatalogTable(CatalogService catalogService) {
        this.catalogService = catalogService;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CatalogTable)) {
            return false;
        }
        CatalogTable other = (CatalogTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CatalogService this$catalogService = this.catalogService;
        CatalogService other$catalogService = other.catalogService;
        return !(this$catalogService == null ? other$catalogService != null : !this$catalogService.equals(other$catalogService));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CatalogTable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CatalogService $catalogService = this.catalogService;
        result = result * 59 + ($catalogService == null ? 43 : $catalogService.hashCode());
        return result;
    }

    @VisibleForTesting
    public static class CatalogTableDefaultImplementor
    extends DefaultImplementor<Object> {
        private final CatalogService catalogService;

        @Override
        public PhysicalPlan visitRelation(LogicalRelation node, Object context) {
            return new CatalogTableScan(this.catalogService);
        }

        @Generated
        public CatalogTableDefaultImplementor(CatalogService catalogService) {
            this.catalogService = catalogService;
        }
    }
}

