/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.action;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.notifications.action.BaseResponse;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/opensearch/commons/alerting/action/AcknowledgeAlertResponse;", "Lorg/opensearch/commons/notifications/action/BaseResponse;", "acknowledged", "", "Lorg/opensearch/commons/alerting/model/Alert;", "failed", "missing", "", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "getAcknowledged", "()Ljava/util/List;", "getFailed", "getMissing", "buildFailedAlertAcknowledgeObject", "", "builder", "Lorg/opensearch/common/xcontent/XContentBuilder;", "failedAlert", "buildMissingAlertAcknowledgeObject", "alertID", "toXContent", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "writeTo", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "common-utils"})
public final class AcknowledgeAlertResponse
extends BaseResponse {
    @NotNull
    private final List<Alert> acknowledged;
    @NotNull
    private final List<Alert> failed;
    @NotNull
    private final List<String> missing;

    @NotNull
    public final List<Alert> getAcknowledged() {
        return this.acknowledged;
    }

    @NotNull
    public final List<Alert> getFailed() {
        return this.failed;
    }

    @NotNull
    public final List<String> getMissing() {
        return this.missing;
    }

    public AcknowledgeAlertResponse(@NotNull List<Alert> acknowledged, @NotNull List<Alert> failed, @NotNull List<String> missing) {
        Intrinsics.checkNotNullParameter(acknowledged, (String)"acknowledged");
        Intrinsics.checkNotNullParameter(failed, (String)"failed");
        Intrinsics.checkNotNullParameter(missing, (String)"missing");
        this.acknowledged = acknowledged;
        this.failed = failed;
        this.missing = missing;
    }

    public AcknowledgeAlertResponse(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        List<Alert> list = Collections.unmodifiableList(sin.readList(Alert::new));
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(sin.readList(::Alert))");
        List<Alert> list2 = list;
        list = Collections.unmodifiableList(sin.readList(Alert::new));
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(sin.readList(::Alert))");
        List<Alert> list3 = list;
        list = Collections.unmodifiableList(sin.readStringList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(sin.readStringList())");
        this(list2, list3, list);
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeCollection((Collection)this.acknowledged);
        out.writeCollection((Collection)this.failed);
        out.writeStringCollection((Collection)this.missing);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) throws IOException {
        Object it;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject().startArray("success");
        Iterable $this$forEach$iv = this.acknowledged;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Alert)element$iv;
            boolean bl = false;
            builder.value(((Alert)it).getId());
        }
        builder.endArray().startArray("failed");
        $this$forEach$iv = this.failed;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Alert)element$iv;
            boolean bl = false;
            this.buildFailedAlertAcknowledgeObject(builder, (Alert)it);
        }
        $this$forEach$iv = this.missing;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            this.buildMissingAlertAcknowledgeObject(builder, (String)it);
        }
        XContentBuilder xContentBuilder = builder.endArray().endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.endArray().endObject()");
        return xContentBuilder;
    }

    private final void buildFailedAlertAcknowledgeObject(XContentBuilder builder, Alert failedAlert) {
        String string;
        builder.startObject().startObject(failedAlert.getId());
        switch (WhenMappings.$EnumSwitchMapping$0[failedAlert.getState().ordinal()]) {
            case 1: {
                string = "Alert is in an error state and can not be acknowledged.";
                break;
            }
            case 2: {
                string = "Alert has already completed and can not be acknowledged.";
                break;
            }
            case 3: {
                string = "Alert has already been acknowledged.";
                break;
            }
            default: {
                string = "Alert state unknown and can not be acknowledged";
            }
        }
        String reason = string;
        builder.field("failed_reason", reason).endObject().endObject();
    }

    private final void buildMissingAlertAcknowledgeObject(XContentBuilder builder, String alertID) {
        builder.startObject().startObject(alertID).field("failed_reason", "Alert: " + alertID + " does not exist (it may have already completed).").endObject().endObject();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Alert.State.values().length];
            nArray[Alert.State.ERROR.ordinal()] = 1;
            nArray[Alert.State.COMPLETED.ordinal()] = 2;
            nArray[Alert.State.ACKNOWLEDGED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

