/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.plugin.rest;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.exception.QueryEngineException;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.legacy.metrics.MetricName;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.sql.opensearch.executor.Scheduler;
import org.opensearch.sql.opensearch.response.error.ErrorMessageFactory;
import org.opensearch.sql.plugin.request.PPLQueryRequestFactory;
import org.opensearch.sql.plugin.transport.PPLQueryAction;
import org.opensearch.sql.plugin.transport.TransportPPLQueryRequest;
import org.opensearch.sql.plugin.transport.TransportPPLQueryResponse;

public class RestPPLQueryAction
extends BaseRestHandler {
    public static final String QUERY_API_ENDPOINT = "/_plugins/_ppl";
    public static final String EXPLAIN_API_ENDPOINT = "/_plugins/_ppl/_explain";
    public static final String LEGACY_QUERY_API_ENDPOINT = "/_opendistro/_ppl";
    public static final String LEGACY_EXPLAIN_API_ENDPOINT = "/_opendistro/_ppl/_explain";
    private static final Logger LOG = LogManager.getLogger();
    private final Supplier<Boolean> pplEnabled = () -> (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(clusterSettings) != false && (Boolean)pluginSettings.getSettingValue(Settings.Key.PPL_ENABLED) != false;

    public RestPPLQueryAction(org.opensearch.sql.common.setting.Settings pluginSettings, Settings clusterSettings) {
    }

    private static boolean isClientError(Exception e) {
        return e instanceof NullPointerException || e instanceof IllegalArgumentException || e instanceof IndexNotFoundException || e instanceof SemanticCheckException || e instanceof ExpressionEvaluationException || e instanceof QueryEngineException || e instanceof SyntaxCheckException;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Arrays.asList(new RestHandler.ReplacedRoute(RestRequest.Method.POST, QUERY_API_ENDPOINT, RestRequest.Method.POST, LEGACY_QUERY_API_ENDPOINT), new RestHandler.ReplacedRoute(RestRequest.Method.POST, EXPLAIN_API_ENDPOINT, RestRequest.Method.POST, LEGACY_EXPLAIN_API_ENDPOINT));
    }

    public String getName() {
        return "ppl_query_action";
    }

    protected Set<String> responseParams() {
        HashSet<String> responseParams = new HashSet<String>(super.responseParams());
        responseParams.addAll(Arrays.asList("format", "sanitize"));
        return responseParams;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) {
        if (!this.pplEnabled.get().booleanValue()) {
            return channel -> this.reportError((RestChannel)channel, new IllegalAccessException("Either plugins.ppl.enabled or rest.action.multi.allow_explicit_index setting is false"), RestStatus.BAD_REQUEST);
        }
        final TransportPPLQueryRequest transportPPLQueryRequest = new TransportPPLQueryRequest(PPLQueryRequestFactory.getPPLRequest(request));
        return channel -> Scheduler.schedule((NodeClient)nodeClient, () -> nodeClient.execute((ActionType)PPLQueryAction.INSTANCE, (ActionRequest)transportPPLQueryRequest, (ActionListener)new ActionListener<TransportPPLQueryResponse>(){

            public void onResponse(TransportPPLQueryResponse response) {
                RestPPLQueryAction.this.sendResponse(channel, RestStatus.OK, response.getResult());
            }

            public void onFailure(Exception e) {
                if (transportPPLQueryRequest.isExplainRequest()) {
                    LOG.error("Error happened during explain", (Throwable)e);
                    RestPPLQueryAction.this.sendResponse(channel, RestStatus.INTERNAL_SERVER_ERROR, "Failed to explain the query due to error: " + e.getMessage());
                } else if (e instanceof IllegalAccessException) {
                    RestPPLQueryAction.this.reportError(channel, e, RestStatus.BAD_REQUEST);
                } else {
                    LOG.error("Error happened during query handling", (Throwable)e);
                    if (RestPPLQueryAction.isClientError(e)) {
                        Metrics.getInstance().getNumericalMetric(MetricName.PPL_FAILED_REQ_COUNT_CUS).increment();
                        RestPPLQueryAction.this.reportError(channel, e, RestStatus.BAD_REQUEST);
                    } else {
                        Metrics.getInstance().getNumericalMetric(MetricName.PPL_FAILED_REQ_COUNT_SYS).increment();
                        RestPPLQueryAction.this.reportError(channel, e, RestStatus.SERVICE_UNAVAILABLE);
                    }
                }
            }
        }));
    }

    private void sendResponse(RestChannel channel, RestStatus status, String content) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, "application/json; charset=UTF-8", content));
    }

    private void reportError(RestChannel channel, Exception e, RestStatus status) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, ErrorMessageFactory.createErrorMessage((Throwable)e, (int)status.getStatus()).toString()));
    }
}

