/* Wallpaper.c generated by valac 0.56.3, the Vala compiler
 * generated from Wallpaper.vala, do not modify */

/*-
 * Copyright (c) 2015-2016 elementary LLC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "pantheon-desktop.h"
#include <switchboard.h>
#include <gtk/gtk.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <unistd.h>

#define PANTHEON_SHELL_TYPE_ACCOUNTS_SERVICE_USER (pantheon_shell_accounts_service_user_get_type ())
#define PANTHEON_SHELL_ACCOUNTS_SERVICE_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_SHELL_TYPE_ACCOUNTS_SERVICE_USER, PantheonShellAccountsServiceUser))
#define PANTHEON_SHELL_IS_ACCOUNTS_SERVICE_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_SHELL_TYPE_ACCOUNTS_SERVICE_USER))
#define PANTHEON_SHELL_ACCOUNTS_SERVICE_USER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PANTHEON_SHELL_TYPE_ACCOUNTS_SERVICE_USER, PantheonShellAccountsServiceUserIface))

typedef struct _PantheonShellAccountsServiceUser PantheonShellAccountsServiceUser;
typedef struct _PantheonShellAccountsServiceUserIface PantheonShellAccountsServiceUserIface;

#define PANTHEON_SHELL_TYPE_ACCOUNTS_SERVICE_USER_PROXY (pantheon_shell_accounts_service_user_proxy_get_type ())
typedef GDBusProxy PantheonShellAccountsServiceUserProxy;
typedef GDBusProxyClass PantheonShellAccountsServiceUserProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	PANTHEON_SHELL_WALLPAPER_0_PROPERTY,
	PANTHEON_SHELL_WALLPAPER_PLUG_PROPERTY,
	PANTHEON_SHELL_WALLPAPER_NUM_PROPERTIES
};
static GParamSpec* pantheon_shell_wallpaper_properties[PANTHEON_SHELL_WALLPAPER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _pantheon_shell_thumbnail_generator_unref0(var) ((var == NULL) ? NULL : (var = (pantheon_shell_thumbnail_generator_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PantheonShellWallpaperLoadWallpapersData PantheonShellWallpaperLoadWallpapersData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;

struct _PantheonShellAccountsServiceUserIface {
	GTypeInterface parent_iface;
	gchar* (*get_background_file) (PantheonShellAccountsServiceUser* self);
	void (*set_background_file) (PantheonShellAccountsServiceUser* self, const gchar* value);
};

struct _PantheonShellWallpaperPrivate {
	SwitchboardPlug* _plug;
	GSettings* settings;
	PantheonShellAccountsServiceUser* accountsservice;
	GtkScrolledWindow* wallpaper_scrolled_window;
	GtkFlowBox* wallpaper_view;
	GtkOverlay* view_overlay;
	GtkComboBoxText* combo;
	GtkColorButton* color_button;
	PantheonShellWallpaperContainer* active_wallpaper;
	PantheonShellSolidColorContainer* solid_color;
	PantheonShellWallpaperContainer* wallpaper_for_removal;
	GCancellable* last_cancellable;
	gchar* current_wallpaper_path;
	gboolean prevent_update_mode;
	gboolean finished;
};

struct _Block5Data {
	int _ref_count_;
	PantheonShellWallpaper* self;
	GraniteAsyncImage* preview_area;
	GtkFileChooserNative* chooser;
};

struct _PantheonShellWallpaperLoadWallpapersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PantheonShellWallpaper* self;
	gchar* basefolder;
	GCancellable* cancellable;
	gboolean toplevel_folder;
	GFile* directory;
	GFile* _tmp0_;
	gchar* attrs;
	gchar* _tmp1_;
	GFileEnumerator* e;
	GFile* _tmp2_;
	const gchar* _tmp3_;
	GFileEnumerator* _tmp4_;
	GFileInfo* file_info;
	GFileInfo* _tmp5_;
	GFileEnumerator* _tmp6_;
	GFileInfo* _tmp7_;
	GFileInfo* _tmp8_;
	GFileInfo* _tmp9_;
	PantheonShellThumbnailGenerator* _tmp10_;
	PantheonShellThumbnailGenerator* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GFileInfo* _tmp14_;
	GFileInfo* _tmp15_;
	GFileInfo* _tmp16_;
	GFileInfo* _tmp17_;
	GFile* subdir;
	GFile* _tmp18_;
	GFileInfo* _tmp19_;
	const gchar* _tmp20_;
	GFile* _tmp21_;
	GFile* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GFileInfo* _tmp25_;
	GFile* file;
	GFile* _tmp26_;
	GFileInfo* _tmp27_;
	const gchar* _tmp28_;
	GFile* _tmp29_;
	gchar* uri;
	GFile* _tmp30_;
	gchar* _tmp31_;
	GFile* _tmp32_;
	const gchar* _tmp33_;
	GtkColorButton* _tmp34_;
	GdkRGBA _tmp35_;
	GdkRGBA _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GtkFlowBox* _tmp39_;
	PantheonShellSolidColorContainer* _tmp40_;
	GSettings* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gboolean _tmp44_;
	GtkFlowBox* _tmp45_;
	PantheonShellSolidColorContainer* _tmp46_;
	PantheonShellSolidColorContainer* _tmp47_;
	PantheonShellSolidColorContainer* _tmp48_;
	PantheonShellWallpaperContainer* _tmp49_;
	PantheonShellWallpaperContainer* _tmp50_;
	GtkAllocation alloc;
	PantheonShellWallpaperContainer* _tmp51_;
	GtkAllocation _tmp52_;
	GtkScrolledWindow* _tmp53_;
	GtkAdjustment* _tmp54_;
	GtkAllocation _tmp55_;
	GError* err;
	GError* _tmp56_;
	GError* _tmp57_;
	const gchar* _tmp58_;
	GError* _inner_error0_;
};

struct _Block6Data {
	int _ref_count_;
	PantheonShellWallpaper* self;
	PantheonShellWallpaperContainer* wallpaper;
};

struct _Block7Data {
	int _ref_count_;
	PantheonShellWallpaper* self;
	GraniteWidgetsToast* toast;
};

static gint PantheonShellWallpaper_private_offset;
static gpointer pantheon_shell_wallpaper_parent_class = NULL;

VALA_EXTERN GType pantheon_shell_accounts_service_user_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pantheon_shell_accounts_service_user_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pantheon_shell_accounts_service_user_register_object (void* object,
                                                            GDBusConnection* connection,
                                                            const gchar* path,
                                                            GError** error);
VALA_EXTERN gchar* pantheon_shell_accounts_service_user_get_background_file (PantheonShellAccountsServiceUser* self);
VALA_EXTERN void pantheon_shell_accounts_service_user_set_background_file (PantheonShellAccountsServiceUser* self,
                                                               const gchar* value);
static GType pantheon_shell_accounts_service_user_get_type_once (void);
static void pantheon_shell_accounts_service_user_proxy_g_signal (GDBusProxy* proxy,
                                                          const gchar* sender_name,
                                                          const gchar* signal_name,
                                                          GVariant* parameters);
static gchar* pantheon_shell_accounts_service_user_dbus_proxy_get_background_file (PantheonShellAccountsServiceUser* self);
static void pantheon_shell_accounts_service_user_dbus_proxy_set_background_file (PantheonShellAccountsServiceUser* self,
                                                                          const gchar* value);
static void pantheon_shell_accounts_service_user_proxy_pantheon_shell_accounts_service_user_interface_init (PantheonShellAccountsServiceUserIface* iface);
static void pantheon_shell_accounts_service_user_dbus_interface_method_call (GDBusConnection* connection,
                                                                      const gchar* sender,
                                                                      const gchar* object_path,
                                                                      const gchar* interface_name,
                                                                      const gchar* method_name,
                                                                      GVariant* parameters,
                                                                      GDBusMethodInvocation* invocation,
                                                                      gpointer user_data);
static GVariant* pantheon_shell_accounts_service_user_dbus_interface_get_property (GDBusConnection* connection,
                                                                            const gchar* sender,
                                                                            const gchar* object_path,
                                                                            const gchar* interface_name,
                                                                            const gchar* property_name,
                                                                            GError** error,
                                                                            gpointer user_data);
static GVariant* _dbus_pantheon_shell_accounts_service_user_get_background_file (PantheonShellAccountsServiceUser* self);
static gboolean pantheon_shell_accounts_service_user_dbus_interface_set_property (GDBusConnection* connection,
                                                                           const gchar* sender,
                                                                           const gchar* object_path,
                                                                           const gchar* interface_name,
                                                                           const gchar* property_name,
                                                                           GVariant* value,
                                                                           GError** error,
                                                                           gpointer user_data);
static void _dbus_pantheon_shell_accounts_service_user_set_background_file (PantheonShellAccountsServiceUser* self,
                                                                     GVariant* _value);
static void _pantheon_shell_accounts_service_user_unregister_object (gpointer user_data);
static void pantheon_shell_wallpaper_show_wallpaper_chooser (PantheonShellWallpaper* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda9_ (Block5Data* _data5_);
static void ___lambda9__gtk_file_chooser_update_preview (GtkFileChooser* _sender,
                                                  gpointer self);
static GFile* pantheon_shell_wallpaper_copy_for_library (GFile* source);
static void pantheon_shell_wallpaper_add_wallpaper_from_file (PantheonShellWallpaper* self,
                                                       GFile* file,
                                                       const gchar* uri);
static void _g_free0_ (gpointer var);
static inline void _g_slist_free__g_free0_ (GSList* self);
static void pantheon_shell_wallpaper_load_settings (PantheonShellWallpaper* self);
static void pantheon_shell_wallpaper_update_accountsservice (PantheonShellWallpaper* self);
static gchar** pantheon_shell_wallpaper_get_bg_directories (PantheonShellWallpaper* self,
                                                     gint* result_length1);
static GFile* pantheon_shell_wallpaper_copy_for_greeter (GFile* source);
static void pantheon_shell_wallpaper_update_checked_wallpaper (PantheonShellWallpaper* self,
                                                        GtkFlowBox* box,
                                                        GtkFlowBoxChild* child);
static void pantheon_shell_wallpaper_set_combo_disabled_if_necessary (PantheonShellWallpaper* self);
static void pantheon_shell_wallpaper_update_color (PantheonShellWallpaper* self);
static void pantheon_shell_wallpaper_create_solid_color_container (PantheonShellWallpaper* self,
                                                            const gchar* color);
static void pantheon_shell_wallpaper_update_mode (PantheonShellWallpaper* self);
static void pantheon_shell_wallpaper_clean_wallpapers (PantheonShellWallpaper* self);
static void pantheon_shell_wallpaper_load_wallpapers (PantheonShellWallpaper* self,
                                               const gchar* basefolder,
                                               GCancellable* cancellable,
                                               gboolean toplevel_folder,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void pantheon_shell_wallpaper_load_wallpapers_finish (PantheonShellWallpaper* self,
                                                      GAsyncResult* _res_);
static void pantheon_shell_wallpaper_load_wallpapers_data_free (gpointer _data);
static gboolean pantheon_shell_wallpaper_load_wallpapers_co (PantheonShellWallpaperLoadWallpapersData* _data_);
static void pantheon_shell_wallpaper_load_wallpapers_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static gchar* pantheon_shell_wallpaper_get_local_bg_directory (void);
static gchar** pantheon_shell_wallpaper_get_system_bg_directories (gint* result_length1);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void pantheon_shell_wallpaper_on_drag_data_received (PantheonShellWallpaper* self,
                                                     GtkWidget* widget,
                                                     GdkDragContext* ctx,
                                                     gint x,
                                                     gint y,
                                                     GtkSelectionData* sel,
                                                     guint information,
                                                     guint timestamp);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ___lambda10_ (Block6Data* _data6_);
static void pantheon_shell_wallpaper_send_undo_toast (PantheonShellWallpaper* self);
static void pantheon_shell_wallpaper_mark_for_removal (PantheonShellWallpaper* self,
                                                PantheonShellWallpaperContainer* wallpaper);
static void ____lambda10__pantheon_shell_wallpaper_container_trash (PantheonShellWallpaperContainer* _sender,
                                                             gpointer self);
static gint pantheon_shell_wallpaper_wallpapers_sort_function (PantheonShellWallpaper* self,
                                                        GtkFlowBoxChild* _child1,
                                                        GtkFlowBoxChild* _child2);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void pantheon_shell_wallpaper_confirm_removal (PantheonShellWallpaper* self);
static void __lambda11_ (PantheonShellWallpaper* self);
static void pantheon_shell_wallpaper_undo_removal (PantheonShellWallpaper* self);
static void ___lambda11__granite_widgets_toast_default_action (GraniteWidgetsToast* _sender,
                                                        gpointer self);
static void __lambda12_ (Block7Data* _data7_);
static void ___lambda12__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static GObject * pantheon_shell_wallpaper_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _pantheon_shell_wallpaper_update_checked_wallpaper_gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                                      GtkFlowBoxChild* child,
                                                                                      gpointer self);
static gint _pantheon_shell_wallpaper_wallpapers_sort_function_gtk_flow_box_sort_func (GtkFlowBoxChild* child1,
                                                                                GtkFlowBoxChild* child2,
                                                                                gpointer self);
static void _pantheon_shell_wallpaper_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                                    GdkDragContext* context,
                                                                                    gint x,
                                                                                    gint y,
                                                                                    GtkSelectionData* selection_data,
                                                                                    guint info,
                                                                                    guint time_,
                                                                                    gpointer self);
static void _pantheon_shell_wallpaper_update_mode_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                  gpointer self);
static void _pantheon_shell_wallpaper_update_color_gtk_color_button_color_set (GtkColorButton* _sender,
                                                                        gpointer self);
static void _pantheon_shell_wallpaper_show_wallpaper_chooser_gtk_button_clicked (GtkButton* _sender,
                                                                          gpointer self);
static void pantheon_shell_wallpaper_finalize (GObject * obj);
static GType pantheon_shell_wallpaper_get_type_once (void);
static void _vala_pantheon_shell_wallpaper_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_pantheon_shell_wallpaper_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusMethodInfo * const _pantheon_shell_accounts_service_user_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _pantheon_shell_accounts_service_user_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _pantheon_shell_accounts_service_user_dbus_property_info_background_file = {-1, "BackgroundFile", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _pantheon_shell_accounts_service_user_dbus_property_info[] = {&_pantheon_shell_accounts_service_user_dbus_property_info_background_file, NULL};
static const GDBusInterfaceInfo _pantheon_shell_accounts_service_user_dbus_interface_info = {-1, "org.freedesktop.DisplayManager.AccountsService", (GDBusMethodInfo **) (&_pantheon_shell_accounts_service_user_dbus_method_info), (GDBusSignalInfo **) (&_pantheon_shell_accounts_service_user_dbus_signal_info), (GDBusPropertyInfo **) (&_pantheon_shell_accounts_service_user_dbus_property_info), NULL};
static const GDBusInterfaceVTable _pantheon_shell_accounts_service_user_dbus_interface_vtable = {pantheon_shell_accounts_service_user_dbus_interface_method_call, pantheon_shell_accounts_service_user_dbus_interface_get_property, pantheon_shell_accounts_service_user_dbus_interface_set_property};
static const gchar* PANTHEON_SHELL_WALLPAPER_REQUIRED_FILE_ATTRS[8] = {G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP, G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK, G_FILE_ATTRIBUTE_THUMBNAIL_PATH, G_FILE_ATTRIBUTE_THUMBNAIL_IS_VALID};

gchar*
pantheon_shell_accounts_service_user_get_background_file (PantheonShellAccountsServiceUser* self)
{
	PantheonShellAccountsServiceUserIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = PANTHEON_SHELL_ACCOUNTS_SERVICE_USER_GET_INTERFACE (self);
	if (_iface_->get_background_file) {
		return _iface_->get_background_file (self);
	}
	return NULL;
}

void
pantheon_shell_accounts_service_user_set_background_file (PantheonShellAccountsServiceUser* self,
                                                          const gchar* value)
{
	PantheonShellAccountsServiceUserIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PANTHEON_SHELL_ACCOUNTS_SERVICE_USER_GET_INTERFACE (self);
	if (_iface_->set_background_file) {
		_iface_->set_background_file (self, value);
	}
}

static void
pantheon_shell_accounts_service_user_default_init (PantheonShellAccountsServiceUserIface * iface,
                                                   gpointer iface_data)
{
}

static GType
pantheon_shell_accounts_service_user_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellAccountsServiceUserIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_accounts_service_user_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType pantheon_shell_accounts_service_user_type_id;
	pantheon_shell_accounts_service_user_type_id = g_type_register_static (G_TYPE_INTERFACE, "PantheonShellAccountsServiceUser", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (pantheon_shell_accounts_service_user_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (pantheon_shell_accounts_service_user_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) pantheon_shell_accounts_service_user_proxy_get_type);
	g_type_set_qdata (pantheon_shell_accounts_service_user_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DisplayManager.AccountsService");
	g_type_set_qdata (pantheon_shell_accounts_service_user_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_pantheon_shell_accounts_service_user_dbus_interface_info));
	g_type_set_qdata (pantheon_shell_accounts_service_user_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) pantheon_shell_accounts_service_user_register_object);
	return pantheon_shell_accounts_service_user_type_id;
}

GType
pantheon_shell_accounts_service_user_get_type (void)
{
	static volatile gsize pantheon_shell_accounts_service_user_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_accounts_service_user_type_id__once)) {
		GType pantheon_shell_accounts_service_user_type_id;
		pantheon_shell_accounts_service_user_type_id = pantheon_shell_accounts_service_user_get_type_once ();
		g_once_init_leave (&pantheon_shell_accounts_service_user_type_id__once, pantheon_shell_accounts_service_user_type_id);
	}
	return pantheon_shell_accounts_service_user_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (PantheonShellAccountsServiceUserProxy, pantheon_shell_accounts_service_user_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (PANTHEON_SHELL_TYPE_ACCOUNTS_SERVICE_USER, pantheon_shell_accounts_service_user_proxy_pantheon_shell_accounts_service_user_interface_init) )
static void
pantheon_shell_accounts_service_user_proxy_class_init (PantheonShellAccountsServiceUserProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = pantheon_shell_accounts_service_user_proxy_g_signal;
}

static void
pantheon_shell_accounts_service_user_proxy_g_signal (GDBusProxy* proxy,
                                                     const gchar* sender_name,
                                                     const gchar* signal_name,
                                                     GVariant* parameters)
{
}

static void
pantheon_shell_accounts_service_user_proxy_init (PantheonShellAccountsServiceUserProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_pantheon_shell_accounts_service_user_dbus_interface_info));
}

static gchar*
pantheon_shell_accounts_service_user_dbus_proxy_get_background_file (PantheonShellAccountsServiceUser* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "BackgroundFile");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.DisplayManager.AccountsService"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("BackgroundFile"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
pantheon_shell_accounts_service_user_dbus_proxy_set_background_file (PantheonShellAccountsServiceUser* self,
                                                                     const gchar* value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.DisplayManager.AccountsService"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("BackgroundFile"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
pantheon_shell_accounts_service_user_proxy_pantheon_shell_accounts_service_user_interface_init (PantheonShellAccountsServiceUserIface* iface)
{
	iface->get_background_file = pantheon_shell_accounts_service_user_dbus_proxy_get_background_file;
	iface->set_background_file = pantheon_shell_accounts_service_user_dbus_proxy_set_background_file;
}

static void
pantheon_shell_accounts_service_user_dbus_interface_method_call (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* method_name,
                                                                 GVariant* parameters,
                                                                 GDBusMethodInvocation* invocation,
                                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_pantheon_shell_accounts_service_user_get_background_file (PantheonShellAccountsServiceUser* self)
{
	gchar* result;
	GVariant* _reply;
	result = pantheon_shell_accounts_service_user_get_background_file (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
pantheon_shell_accounts_service_user_dbus_interface_get_property (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* property_name,
                                                                  GError** error,
                                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "BackgroundFile") == 0) {
		return _dbus_pantheon_shell_accounts_service_user_get_background_file (object);
	}
	return NULL;
}

static void
_dbus_pantheon_shell_accounts_service_user_set_background_file (PantheonShellAccountsServiceUser* self,
                                                                GVariant* _value)
{
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	pantheon_shell_accounts_service_user_set_background_file (self, value);
	_g_free0 (value);
}

static gboolean
pantheon_shell_accounts_service_user_dbus_interface_set_property (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* property_name,
                                                                  GVariant* value,
                                                                  GError** error,
                                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "BackgroundFile") == 0) {
		_dbus_pantheon_shell_accounts_service_user_set_background_file (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
pantheon_shell_accounts_service_user_register_object (gpointer object,
                                                      GDBusConnection* connection,
                                                      const gchar* path,
                                                      GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_pantheon_shell_accounts_service_user_dbus_interface_info), &_pantheon_shell_accounts_service_user_dbus_interface_vtable, data, _pantheon_shell_accounts_service_user_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_pantheon_shell_accounts_service_user_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
pantheon_shell_wallpaper_get_instance_private (PantheonShellWallpaper* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonShellWallpaper_private_offset);
}

static GType
pantheon_shell_wallpaper_column_type_get_type_once (void)
{
	static const GEnumValue values[] = {{PANTHEON_SHELL_WALLPAPER_COLUMN_TYPE_ICON, "PANTHEON_SHELL_WALLPAPER_COLUMN_TYPE_ICON", "icon"}, {PANTHEON_SHELL_WALLPAPER_COLUMN_TYPE_NAME, "PANTHEON_SHELL_WALLPAPER_COLUMN_TYPE_NAME", "name"}, {0, NULL, NULL}};
	GType pantheon_shell_wallpaper_column_type_type_id;
	pantheon_shell_wallpaper_column_type_type_id = g_enum_register_static ("PantheonShellWallpaperColumnType", values);
	return pantheon_shell_wallpaper_column_type_type_id;
}

GType
pantheon_shell_wallpaper_column_type_get_type (void)
{
	static volatile gsize pantheon_shell_wallpaper_column_type_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_wallpaper_column_type_type_id__once)) {
		GType pantheon_shell_wallpaper_column_type_type_id;
		pantheon_shell_wallpaper_column_type_type_id = pantheon_shell_wallpaper_column_type_get_type_once ();
		g_once_init_leave (&pantheon_shell_wallpaper_column_type_type_id__once, pantheon_shell_wallpaper_column_type_type_id);
	}
	return pantheon_shell_wallpaper_column_type_type_id__once;
}

PantheonShellWallpaper*
pantheon_shell_wallpaper_construct (GType object_type,
                                    SwitchboardPlug* _plug)
{
	PantheonShellWallpaper * self = NULL;
	g_return_val_if_fail (_plug != NULL, NULL);
	self = (PantheonShellWallpaper*) g_object_new (object_type, "plug", _plug, NULL);
	return self;
}

PantheonShellWallpaper*
pantheon_shell_wallpaper_new (SwitchboardPlug* _plug)
{
	return pantheon_shell_wallpaper_construct (PANTHEON_SHELL_TYPE_WALLPAPER, _plug);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		PantheonShellWallpaper* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->chooser);
		_g_object_unref0 (_data5_->preview_area);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda9_ (Block5Data* _data5_)
{
	PantheonShellWallpaper* self;
	gchar* uri = NULL;
	GtkFileChooserNative* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	self = _data5_->self;
	_tmp0_ = _data5_->chooser;
	_tmp1_ = gtk_file_chooser_get_preview_uri ((GtkFileChooser*) _tmp0_);
	uri = _tmp1_;
	_tmp3_ = uri;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = uri;
		_tmp2_ = g_str_has_prefix (_tmp4_, "file://") == TRUE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GFile* file = NULL;
		const gchar* _tmp5_;
		GFile* _tmp6_;
		GraniteAsyncImage* _tmp7_;
		GFile* _tmp8_;
		GFileIcon* _tmp9_;
		GFileIcon* _tmp10_;
		GraniteAsyncImage* _tmp11_;
		_tmp5_ = uri;
		_tmp6_ = g_file_new_for_uri (_tmp5_);
		file = _tmp6_;
		_tmp7_ = _data5_->preview_area;
		_tmp8_ = file;
		_tmp9_ = (GFileIcon*) g_file_icon_new (_tmp8_);
		_tmp10_ = _tmp9_;
		granite_async_image_set_from_gicon_async (_tmp7_, (GIcon*) _tmp10_, 256, NULL, NULL, NULL);
		_g_object_unref0 (_tmp10_);
		_tmp11_ = _data5_->preview_area;
		gtk_widget_show ((GtkWidget*) _tmp11_);
		_g_object_unref0 (file);
	} else {
		GraniteAsyncImage* _tmp12_;
		_tmp12_ = _data5_->preview_area;
		gtk_widget_hide ((GtkWidget*) _tmp12_);
	}
	_g_free0 (uri);
}

static void
___lambda9__gtk_file_chooser_update_preview (GtkFileChooser* _sender,
                                             gpointer self)
{
	__lambda9_ (self);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
pantheon_shell_wallpaper_show_wallpaper_chooser (PantheonShellWallpaper* self)
{
	Block5Data* _data5_;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp0_;
	GtkFileFilter* _tmp1_;
	GraniteAsyncImage* _tmp2_;
	GraniteAsyncImage* _tmp3_;
	GraniteAsyncImage* _tmp4_;
	GtkFileChooserNative* _tmp5_;
	GtkFileChooserNative* _tmp6_;
	GtkFileFilter* _tmp7_;
	GtkFileChooserNative* _tmp8_;
	GtkFileChooserNative* _tmp9_;
	GraniteAsyncImage* _tmp10_;
	GtkFileChooserNative* _tmp11_;
	GtkFileChooserNative* _tmp12_;
	GtkFileChooserNative* _tmp27_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp0_);
	filter = _tmp0_;
	_tmp1_ = filter;
	gtk_file_filter_add_mime_type (_tmp1_, "image/*");
	_tmp2_ = granite_async_image_new (FALSE, TRUE);
	g_object_ref_sink (_tmp2_);
	_data5_->preview_area = _tmp2_;
	_tmp3_ = _data5_->preview_area;
	gtk_image_set_pixel_size ((GtkImage*) _tmp3_, 256);
	_tmp4_ = _data5_->preview_area;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp4_, 12);
	_tmp5_ = gtk_file_chooser_native_new (_ ("Import Photo"), NULL, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("Import"), _ ("Cancel"));
	_data5_->chooser = _tmp5_;
	_tmp6_ = _data5_->chooser;
	_tmp7_ = filter;
	gtk_file_chooser_set_filter ((GtkFileChooser*) _tmp6_, _tmp7_);
	_tmp8_ = _data5_->chooser;
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _tmp8_, TRUE);
	_tmp9_ = _data5_->chooser;
	_tmp10_ = _data5_->preview_area;
	gtk_file_chooser_set_preview_widget ((GtkFileChooser*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = _data5_->chooser;
	g_signal_connect_data ((GtkFileChooser*) _tmp11_, "update-preview", (GCallback) ___lambda9__gtk_file_chooser_update_preview, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp12_ = _data5_->chooser;
	if (gtk_native_dialog_run ((GtkNativeDialog*) _tmp12_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GSList* uris = NULL;
		GtkFileChooserNative* _tmp13_;
		GSList* _tmp14_;
		GSList* _tmp15_;
		_tmp13_ = _data5_->chooser;
		_tmp14_ = gtk_file_chooser_get_uris ((GtkFileChooser*) _tmp13_);
		uris = _tmp14_;
		_tmp15_ = uris;
		{
			GSList* uri_collection = NULL;
			GSList* uri_it = NULL;
			uri_collection = _tmp15_;
			for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
				const gchar* uri = NULL;
				uri = (const gchar*) uri_it->data;
				{
					GFile* file = NULL;
					const gchar* _tmp16_;
					GFile* _tmp17_;
					gchar* local_uri = NULL;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					GFile* dest = NULL;
					GFile* _tmp20_;
					GFile* _tmp21_;
					GFile* _tmp22_;
					GFile* _tmp25_;
					const gchar* _tmp26_;
					_tmp16_ = uri;
					_tmp17_ = g_file_new_for_uri (_tmp16_);
					file = _tmp17_;
					_tmp18_ = uri;
					_tmp19_ = g_strdup (_tmp18_);
					local_uri = _tmp19_;
					_tmp20_ = file;
					_tmp21_ = pantheon_shell_wallpaper_copy_for_library (_tmp20_);
					dest = _tmp21_;
					_tmp22_ = dest;
					if (_tmp22_ != NULL) {
						GFile* _tmp23_;
						gchar* _tmp24_;
						_tmp23_ = dest;
						_tmp24_ = g_file_get_uri (_tmp23_);
						_g_free0 (local_uri);
						local_uri = _tmp24_;
					}
					_tmp25_ = file;
					_tmp26_ = local_uri;
					pantheon_shell_wallpaper_add_wallpaper_from_file (self, _tmp25_, _tmp26_);
					_g_object_unref0 (dest);
					_g_free0 (local_uri);
					_g_object_unref0 (file);
				}
			}
		}
		(uris == NULL) ? NULL : (uris = (_g_slist_free__g_free0_ (uris), NULL));
	}
	_tmp27_ = _data5_->chooser;
	gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp27_);
	_g_object_unref0 (filter);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
pantheon_shell_wallpaper_load_settings (PantheonShellWallpaper* self)
{
	gchar* picture_options = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkComboBoxText* _tmp5_;
	const gchar* _tmp6_;
	GSettings* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "picture-options");
	picture_options = _tmp1_;
	_tmp2_ = picture_options;
	if (g_strcmp0 (_tmp2_, "none") == 0) {
		GtkComboBoxText* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
		_tmp4_ = g_strdup ("zoom");
		_g_free0 (picture_options);
		picture_options = _tmp4_;
	}
	self->priv->prevent_update_mode = TRUE;
	_tmp5_ = self->priv->combo;
	_tmp6_ = picture_options;
	gtk_combo_box_set_active_id ((GtkComboBox*) _tmp5_, _tmp6_);
	_tmp7_ = self->priv->settings;
	_tmp8_ = g_settings_get_string (_tmp7_, "picture-uri");
	_g_free0 (self->priv->current_wallpaper_path);
	self->priv->current_wallpaper_path = _tmp8_;
	_g_free0 (picture_options);
}

static void
pantheon_shell_wallpaper_update_accountsservice (PantheonShellWallpaper* self)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gchar* uri = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* path = NULL;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gboolean path_has_prefix_bg_dir = FALSE;
	gint _tmp6_ = 0;
	gchar** _tmp7_;
	GFile* greeter_file = NULL;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	GSettings* _tmp20_;
	const gchar* _tmp21_;
	PantheonShellAccountsServiceUser* _tmp22_;
	const gchar* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_wallpaper_path;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_get_uri (_tmp2_);
	uri = _tmp3_;
	_tmp4_ = file;
	_tmp5_ = g_file_get_path (_tmp4_);
	path = _tmp5_;
	path_has_prefix_bg_dir = FALSE;
	_tmp7_ = pantheon_shell_wallpaper_get_bg_directories (self, &_tmp6_);
	{
		gchar** directory_collection = NULL;
		gint directory_collection_length1 = 0;
		gint _directory_collection_size_ = 0;
		gint directory_it = 0;
		directory_collection = _tmp7_;
		directory_collection_length1 = _tmp6_;
		for (directory_it = 0; directory_it < directory_collection_length1; directory_it = directory_it + 1) {
			const gchar* directory = NULL;
			directory = directory_collection[directory_it];
			{
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = path;
				_tmp9_ = directory;
				if (g_str_has_prefix (_tmp8_, _tmp9_)) {
					path_has_prefix_bg_dir = TRUE;
					break;
				}
			}
		}
		directory_collection = (_vala_array_free (directory_collection, directory_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	if (!path_has_prefix_bg_dir) {
		GFile* local_file = NULL;
		GFile* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		_tmp10_ = file;
		_tmp11_ = pantheon_shell_wallpaper_copy_for_library (_tmp10_);
		local_file = _tmp11_;
		_tmp12_ = local_file;
		if (_tmp12_ != NULL) {
			GFile* _tmp13_;
			gchar* _tmp14_;
			_tmp13_ = local_file;
			_tmp14_ = g_file_get_uri (_tmp13_);
			_g_free0 (uri);
			uri = _tmp14_;
		}
		_g_object_unref0 (local_file);
	}
	_tmp15_ = file;
	_tmp16_ = pantheon_shell_wallpaper_copy_for_greeter (_tmp15_);
	greeter_file = _tmp16_;
	_tmp17_ = greeter_file;
	if (_tmp17_ != NULL) {
		GFile* _tmp18_;
		gchar* _tmp19_;
		_tmp18_ = greeter_file;
		_tmp19_ = g_file_get_path (_tmp18_);
		_g_free0 (path);
		path = _tmp19_;
	}
	_tmp20_ = self->priv->settings;
	_tmp21_ = uri;
	g_settings_set_string (_tmp20_, "picture-uri", _tmp21_);
	_tmp22_ = self->priv->accountsservice;
	_tmp23_ = path;
	pantheon_shell_accounts_service_user_set_background_file (_tmp22_, _tmp23_);
	_g_object_unref0 (greeter_file);
	_g_free0 (path);
	_g_free0 (uri);
	_g_object_unref0 (file);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pantheon_shell_wallpaper_update_checked_wallpaper (PantheonShellWallpaper* self,
                                                   GtkFlowBox* box,
                                                   GtkFlowBoxChild* child)
{
	PantheonShellWallpaperContainer* children = NULL;
	GtkFlowBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	PantheonShellWallpaperContainer* _tmp4_;
	PantheonShellWallpaperContainer* _tmp5_;
	PantheonShellWallpaperContainer* _tmp6_;
	GSettings* _tmp21_;
	PantheonShellWallpaperContainer* _tmp22_;
	gboolean _tmp23_ = FALSE;
	PantheonShellWallpaperContainer* _tmp24_;
	PantheonShellWallpaperContainer* _tmp28_;
	PantheonShellWallpaperContainer* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = self->priv->wallpaper_view;
	_tmp1_ = gtk_flow_box_get_selected_children (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->data;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GtkFlowBoxChild*) _tmp3_, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer));
	_tmp5_ = _tmp4_;
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
	children = _tmp5_;
	_tmp6_ = children;
	if (!PANTHEON_SHELL_IS_SOLID_COLOR_CONTAINER (_tmp6_)) {
		PantheonShellWallpaperContainer* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		PantheonShellWallpaperContainer* _tmp11_;
		PantheonShellSolidColorContainer* _tmp12_;
		_tmp7_ = children;
		_tmp8_ = pantheon_shell_wallpaper_container_get_uri (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (self->priv->current_wallpaper_path);
		self->priv->current_wallpaper_path = _tmp10_;
		pantheon_shell_wallpaper_update_accountsservice (self);
		_tmp11_ = self->priv->active_wallpaper;
		_tmp12_ = self->priv->solid_color;
		if (_tmp11_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer)) {
			GtkComboBoxText* _tmp13_;
			GSettings* _tmp14_;
			GtkComboBoxText* _tmp15_;
			const gchar* _tmp16_;
			_tmp13_ = self->priv->combo;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, TRUE);
			_tmp14_ = self->priv->settings;
			_tmp15_ = self->priv->combo;
			_tmp16_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp15_);
			g_settings_set_string (_tmp14_, "picture-options", _tmp16_);
		}
	} else {
		GSettings* _tmp17_;
		PantheonShellSolidColorContainer* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		pantheon_shell_wallpaper_set_combo_disabled_if_necessary (self);
		_tmp17_ = self->priv->settings;
		_tmp18_ = self->priv->solid_color;
		_tmp19_ = pantheon_shell_solid_color_container_get_color (_tmp18_);
		_tmp20_ = _tmp19_;
		g_settings_set_string (_tmp17_, "primary-color", _tmp20_);
	}
	_tmp21_ = self->priv->settings;
	g_settings_reset (_tmp21_, "color-shading-type");
	_tmp22_ = children;
	pantheon_shell_wallpaper_container_set_checked (_tmp22_, TRUE);
	_tmp24_ = self->priv->active_wallpaper;
	if (_tmp24_ != NULL) {
		PantheonShellWallpaperContainer* _tmp25_;
		PantheonShellWallpaperContainer* _tmp26_;
		_tmp25_ = self->priv->active_wallpaper;
		_tmp26_ = children;
		_tmp23_ = _tmp25_ != _tmp26_;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		PantheonShellWallpaperContainer* _tmp27_;
		_tmp27_ = self->priv->active_wallpaper;
		pantheon_shell_wallpaper_container_set_checked (_tmp27_, FALSE);
	}
	_tmp28_ = children;
	_tmp29_ = _g_object_ref0 (_tmp28_);
	_g_object_unref0 (self->priv->active_wallpaper);
	self->priv->active_wallpaper = _tmp29_;
	_g_object_unref0 (children);
}

static void
pantheon_shell_wallpaper_update_color (PantheonShellWallpaper* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->finished) {
		GtkColorButton* _tmp0_;
		GdkRGBA _tmp1_ = {0};
		GdkRGBA _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GtkFlowBox* _tmp5_;
		PantheonShellSolidColorContainer* _tmp6_;
		GtkFlowBox* _tmp7_;
		PantheonShellSolidColorContainer* _tmp8_;
		PantheonShellWallpaperContainer* _tmp9_;
		PantheonShellSolidColorContainer* _tmp11_;
		PantheonShellWallpaperContainer* _tmp12_;
		PantheonShellWallpaperContainer* _tmp13_;
		GSettings* _tmp14_;
		PantheonShellSolidColorContainer* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		pantheon_shell_wallpaper_set_combo_disabled_if_necessary (self);
		_tmp0_ = self->priv->color_button;
		gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp0_, &_tmp1_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gdk_rgba_to_string (&_tmp2_);
		_tmp4_ = _tmp3_;
		pantheon_shell_wallpaper_create_solid_color_container (self, _tmp4_);
		_g_free0 (_tmp4_);
		_tmp5_ = self->priv->wallpaper_view;
		_tmp6_ = self->priv->solid_color;
		gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
		_tmp7_ = self->priv->wallpaper_view;
		_tmp8_ = self->priv->solid_color;
		gtk_flow_box_select_child (_tmp7_, (GtkFlowBoxChild*) _tmp8_);
		_tmp9_ = self->priv->active_wallpaper;
		if (_tmp9_ != NULL) {
			PantheonShellWallpaperContainer* _tmp10_;
			_tmp10_ = self->priv->active_wallpaper;
			pantheon_shell_wallpaper_container_set_checked (_tmp10_, FALSE);
		}
		_tmp11_ = self->priv->solid_color;
		_tmp12_ = _g_object_ref0 ((PantheonShellWallpaperContainer*) _tmp11_);
		_g_object_unref0 (self->priv->active_wallpaper);
		self->priv->active_wallpaper = _tmp12_;
		_tmp13_ = self->priv->active_wallpaper;
		pantheon_shell_wallpaper_container_set_checked (_tmp13_, TRUE);
		_tmp14_ = self->priv->settings;
		_tmp15_ = self->priv->solid_color;
		_tmp16_ = pantheon_shell_solid_color_container_get_color (_tmp15_);
		_tmp17_ = _tmp16_;
		g_settings_set_string (_tmp14_, "primary-color", _tmp17_);
	}
}

static void
pantheon_shell_wallpaper_update_mode (PantheonShellWallpaper* self)
{
	g_return_if_fail (self != NULL);
	if (!self->priv->prevent_update_mode) {
		GSettings* _tmp0_;
		GtkComboBoxText* _tmp1_;
		const gchar* _tmp2_;
		PantheonShellWallpaperContainer* _tmp3_;
		PantheonShellSolidColorContainer* _tmp4_;
		_tmp0_ = self->priv->settings;
		_tmp1_ = self->priv->combo;
		_tmp2_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp1_);
		g_settings_set_string (_tmp0_, "picture-options", _tmp2_);
		_tmp3_ = self->priv->active_wallpaper;
		_tmp4_ = self->priv->solid_color;
		if (_tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer)) {
			PantheonShellWallpaperContainer* _tmp5_;
			GtkFlowBox* _tmp6_;
			GList* _tmp7_;
			_tmp5_ = self->priv->active_wallpaper;
			pantheon_shell_wallpaper_container_set_checked (_tmp5_, FALSE);
			_tmp6_ = self->priv->wallpaper_view;
			_tmp7_ = gtk_container_get_children ((GtkContainer*) _tmp6_);
			{
				GList* child_collection = NULL;
				GList* child_it = NULL;
				child_collection = _tmp7_;
				for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
					GtkWidget* child = NULL;
					child = (GtkWidget*) child_it->data;
					{
						PantheonShellWallpaperContainer* container = NULL;
						GtkWidget* _tmp8_;
						PantheonShellWallpaperContainer* _tmp9_;
						PantheonShellWallpaperContainer* _tmp10_;
						const gchar* _tmp11_;
						const gchar* _tmp12_;
						const gchar* _tmp13_;
						_tmp8_ = child;
						_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer));
						container = _tmp9_;
						_tmp10_ = container;
						_tmp11_ = pantheon_shell_wallpaper_container_get_uri (_tmp10_);
						_tmp12_ = _tmp11_;
						_tmp13_ = self->priv->current_wallpaper_path;
						if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
							PantheonShellWallpaperContainer* _tmp14_;
							GtkFlowBox* _tmp15_;
							PantheonShellWallpaperContainer* _tmp16_;
							PantheonShellWallpaperContainer* _tmp17_;
							PantheonShellWallpaperContainer* _tmp18_;
							_tmp14_ = container;
							pantheon_shell_wallpaper_container_set_checked (_tmp14_, TRUE);
							_tmp15_ = self->priv->wallpaper_view;
							_tmp16_ = container;
							gtk_flow_box_select_child (_tmp15_, (GtkFlowBoxChild*) _tmp16_);
							_tmp17_ = container;
							_tmp18_ = _g_object_ref0 (_tmp17_);
							_g_object_unref0 (self->priv->active_wallpaper);
							self->priv->active_wallpaper = _tmp18_;
							_g_object_unref0 (container);
							break;
						}
						_g_object_unref0 (container);
					}
				}
				(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
			}
		}
	} else {
		self->priv->prevent_update_mode = FALSE;
	}
}

static void
pantheon_shell_wallpaper_set_combo_disabled_if_necessary (PantheonShellWallpaper* self)
{
	PantheonShellWallpaperContainer* _tmp0_;
	PantheonShellSolidColorContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->active_wallpaper;
	_tmp1_ = self->priv->solid_color;
	if (_tmp0_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer)) {
		GtkComboBoxText* _tmp2_;
		GSettings* _tmp3_;
		_tmp2_ = self->priv->combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
		_tmp3_ = self->priv->settings;
		g_settings_set_string (_tmp3_, "picture-options", "none");
	}
}

void
pantheon_shell_wallpaper_update_wallpaper_folder (PantheonShellWallpaper* self)
{
	GCancellable* _tmp0_;
	GCancellable* cancellable = NULL;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	gint _tmp5_ = 0;
	gchar** _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->last_cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->last_cancellable;
		g_cancellable_cancel (_tmp1_);
	}
	_tmp2_ = g_cancellable_new ();
	cancellable = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->last_cancellable);
	self->priv->last_cancellable = _tmp4_;
	pantheon_shell_wallpaper_clean_wallpapers (self);
	_tmp6_ = pantheon_shell_wallpaper_get_bg_directories (self, &_tmp5_);
	{
		gchar** directory_collection = NULL;
		gint directory_collection_length1 = 0;
		gint _directory_collection_size_ = 0;
		gint directory_it = 0;
		directory_collection = _tmp6_;
		directory_collection_length1 = _tmp5_;
		for (directory_it = 0; directory_it < directory_collection_length1; directory_it = directory_it + 1) {
			const gchar* directory = NULL;
			directory = directory_collection[directory_it];
			{
				const gchar* _tmp7_;
				GCancellable* _tmp8_;
				_tmp7_ = directory;
				_tmp8_ = cancellable;
				pantheon_shell_wallpaper_load_wallpapers (self, _tmp7_, _tmp8_, TRUE, NULL, NULL);
			}
		}
		directory_collection = (_vala_array_free (directory_collection, directory_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_object_unref0 (cancellable);
}

static void
pantheon_shell_wallpaper_load_wallpapers_data_free (gpointer _data)
{
	PantheonShellWallpaperLoadWallpapersData* _data_;
	_data_ = _data;
	_g_free0 (_data_->basefolder);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (PantheonShellWallpaperLoadWallpapersData, _data_);
}

static void
pantheon_shell_wallpaper_load_wallpapers (PantheonShellWallpaper* self,
                                          const gchar* basefolder,
                                          GCancellable* cancellable,
                                          gboolean toplevel_folder,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	PantheonShellWallpaperLoadWallpapersData* _data_;
	PantheonShellWallpaper* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (basefolder != NULL);
	g_return_if_fail (cancellable != NULL);
	_data_ = g_slice_new0 (PantheonShellWallpaperLoadWallpapersData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pantheon_shell_wallpaper_load_wallpapers_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (basefolder);
	_g_free0 (_data_->basefolder);
	_data_->basefolder = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	_data_->toplevel_folder = toplevel_folder;
	pantheon_shell_wallpaper_load_wallpapers_co (_data_);
}

static void
pantheon_shell_wallpaper_load_wallpapers_finish (PantheonShellWallpaper* self,
                                                 GAsyncResult* _res_)
{
	PantheonShellWallpaperLoadWallpapersData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
pantheon_shell_wallpaper_load_wallpapers_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	PantheonShellWallpaperLoadWallpapersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pantheon_shell_wallpaper_load_wallpapers_co (_data_);
}

static gboolean
pantheon_shell_wallpaper_load_wallpapers_co (PantheonShellWallpaperLoadWallpapersData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (g_cancellable_is_cancelled (_data_->cancellable)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = g_file_new_for_path (_data_->basefolder);
	_data_->directory = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _vala_g_strjoinv (",", PANTHEON_SHELL_WALLPAPER_REQUIRED_FILE_ATTRS, (gint) G_N_ELEMENTS (PANTHEON_SHELL_WALLPAPER_REQUIRED_FILE_ATTRS));
		_data_->attrs = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->directory;
		_data_->_tmp3_ = _data_->attrs;
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->_tmp2_, _data_->_tmp3_, 0, G_PRIORITY_DEFAULT, NULL, pantheon_shell_wallpaper_load_wallpapers_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = g_file_enumerate_children_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		_data_->e = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->attrs);
			goto __catch0_g_error;
		}
		while (TRUE) {
			_data_->_tmp6_ = _data_->e;
			_data_->_tmp7_ = g_file_enumerator_next_file (_data_->_tmp6_, NULL, &_data_->_inner_error0_);
			_data_->_tmp5_ = _data_->_tmp7_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->file_info);
				_g_object_unref0 (_data_->e);
				_g_free0 (_data_->attrs);
				goto __catch0_g_error;
			}
			_data_->_tmp8_ = _data_->_tmp5_;
			_data_->_tmp5_ = NULL;
			_g_object_unref0 (_data_->file_info);
			_data_->file_info = _data_->_tmp8_;
			_data_->_tmp9_ = _data_->file_info;
			if (!(_data_->_tmp9_ != NULL)) {
				_g_object_unref0 (_data_->_tmp5_);
				break;
			}
			if (g_cancellable_is_cancelled (_data_->cancellable)) {
				_data_->_tmp10_ = pantheon_shell_thumbnail_generator_get_default ();
				_data_->_tmp11_ = _data_->_tmp10_;
				pantheon_shell_thumbnail_generator_dequeue_all (_data_->_tmp11_);
				_pantheon_shell_thumbnail_generator_unref0 (_data_->_tmp11_);
				_g_object_unref0 (_data_->_tmp5_);
				_g_object_unref0 (_data_->file_info);
				_g_object_unref0 (_data_->e);
				_g_free0 (_data_->attrs);
				_g_object_unref0 (_data_->directory);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp14_ = _data_->file_info;
			if (g_file_info_get_is_hidden (_data_->_tmp14_)) {
				_data_->_tmp13_ = TRUE;
			} else {
				_data_->_tmp15_ = _data_->file_info;
				_data_->_tmp13_ = g_file_info_get_is_backup (_data_->_tmp15_);
			}
			if (_data_->_tmp13_) {
				_data_->_tmp12_ = TRUE;
			} else {
				_data_->_tmp16_ = _data_->file_info;
				_data_->_tmp12_ = g_file_info_get_is_symlink (_data_->_tmp16_);
			}
			if (_data_->_tmp12_) {
				_g_object_unref0 (_data_->_tmp5_);
				continue;
			}
			_data_->_tmp17_ = _data_->file_info;
			if (g_file_info_get_file_type (_data_->_tmp17_) == G_FILE_TYPE_DIRECTORY) {
				_data_->_tmp18_ = _data_->directory;
				_data_->_tmp19_ = _data_->file_info;
				_data_->_tmp20_ = g_file_info_get_name (_data_->_tmp19_);
				_data_->_tmp21_ = g_file_resolve_relative_path (_data_->_tmp18_, _data_->_tmp20_);
				_data_->subdir = _data_->_tmp21_;
				_data_->_tmp22_ = _data_->subdir;
				_data_->_tmp23_ = g_file_get_path (_data_->_tmp22_);
				_data_->_tmp24_ = _data_->_tmp23_;
				_data_->_state_ = 2;
				pantheon_shell_wallpaper_load_wallpapers (_data_->self, _data_->_tmp24_, _data_->cancellable, FALSE, pantheon_shell_wallpaper_load_wallpapers_ready, _data_);
				return FALSE;
				_state_2:
				pantheon_shell_wallpaper_load_wallpapers_finish (_data_->self, _data_->_res_);
				_g_free0 (_data_->_tmp24_);
				_g_object_unref0 (_data_->subdir);
				_g_object_unref0 (_data_->_tmp5_);
				continue;
			} else {
				_data_->_tmp25_ = _data_->file_info;
				if (!pantheon_shell_io_helper_is_valid_file_type (_data_->_tmp25_)) {
					_g_object_unref0 (_data_->_tmp5_);
					continue;
				}
			}
			_data_->_tmp26_ = _data_->directory;
			_data_->_tmp27_ = _data_->file_info;
			_data_->_tmp28_ = g_file_info_get_name (_data_->_tmp27_);
			_data_->_tmp29_ = g_file_resolve_relative_path (_data_->_tmp26_, _data_->_tmp28_);
			_data_->file = _data_->_tmp29_;
			_data_->_tmp30_ = _data_->file;
			_data_->_tmp31_ = g_file_get_uri (_data_->_tmp30_);
			_data_->uri = _data_->_tmp31_;
			_data_->_tmp32_ = _data_->file;
			_data_->_tmp33_ = _data_->uri;
			pantheon_shell_wallpaper_add_wallpaper_from_file (_data_->self, _data_->_tmp32_, _data_->_tmp33_);
			_g_free0 (_data_->uri);
			_g_object_unref0 (_data_->file);
			_g_object_unref0 (_data_->_tmp5_);
		}
		if (_data_->toplevel_folder) {
			_data_->_tmp34_ = _data_->self->priv->color_button;
			memset (&_data_->_tmp35_, 0, sizeof (GdkRGBA));
			gtk_color_chooser_get_rgba ((GtkColorChooser*) _data_->_tmp34_, &_data_->_tmp35_);
			_data_->_tmp36_ = _data_->_tmp35_;
			_data_->_tmp37_ = gdk_rgba_to_string (&_data_->_tmp36_);
			_data_->_tmp38_ = _data_->_tmp37_;
			pantheon_shell_wallpaper_create_solid_color_container (_data_->self, _data_->_tmp38_);
			_g_free0 (_data_->_tmp38_);
			_data_->_tmp39_ = _data_->self->priv->wallpaper_view;
			_data_->_tmp40_ = _data_->self->priv->solid_color;
			gtk_container_add ((GtkContainer*) _data_->_tmp39_, (GtkWidget*) _data_->_tmp40_);
			_data_->self->priv->finished = TRUE;
			_data_->_tmp41_ = _data_->self->priv->settings;
			_data_->_tmp42_ = g_settings_get_string (_data_->_tmp41_, "picture-options");
			_data_->_tmp43_ = _data_->_tmp42_;
			_data_->_tmp44_ = g_strcmp0 (_data_->_tmp43_, "none") == 0;
			_g_free0 (_data_->_tmp43_);
			if (_data_->_tmp44_) {
				_data_->_tmp45_ = _data_->self->priv->wallpaper_view;
				_data_->_tmp46_ = _data_->self->priv->solid_color;
				gtk_flow_box_select_child (_data_->_tmp45_, (GtkFlowBoxChild*) _data_->_tmp46_);
				_data_->_tmp47_ = _data_->self->priv->solid_color;
				pantheon_shell_wallpaper_container_set_checked ((PantheonShellWallpaperContainer*) _data_->_tmp47_, TRUE);
				_data_->_tmp48_ = _data_->self->priv->solid_color;
				_data_->_tmp49_ = _g_object_ref0 ((PantheonShellWallpaperContainer*) _data_->_tmp48_);
				_g_object_unref0 (_data_->self->priv->active_wallpaper);
				_data_->self->priv->active_wallpaper = _data_->_tmp49_;
			}
			_data_->_tmp50_ = _data_->self->priv->active_wallpaper;
			if (_data_->_tmp50_ != NULL) {
				_data_->_tmp51_ = _data_->self->priv->active_wallpaper;
				memset (&_data_->_tmp52_, 0, sizeof (GtkAllocation));
				gtk_widget_get_allocation ((GtkWidget*) _data_->_tmp51_, &_data_->_tmp52_);
				_data_->alloc = _data_->_tmp52_;
				_data_->_tmp53_ = _data_->self->priv->wallpaper_scrolled_window;
				_data_->_tmp54_ = gtk_scrolled_window_get_vadjustment (_data_->_tmp53_);
				_data_->_tmp55_ = _data_->alloc;
				gtk_adjustment_set_value (_data_->_tmp54_, (gdouble) _data_->_tmp55_.y);
			}
		}
		_g_object_unref0 (_data_->file_info);
		_g_object_unref0 (_data_->e);
		_g_free0 (_data_->attrs);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp56_ = _data_->err;
		if (!g_error_matches (_data_->_tmp56_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			_data_->_tmp57_ = _data_->err;
			_data_->_tmp58_ = _data_->_tmp57_->message;
			g_warning ("Wallpaper.vala:392: %s", _data_->_tmp58_);
		}
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->directory);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pantheon_shell_wallpaper_create_solid_color_container (PantheonShellWallpaper* self,
                                                       const gchar* color)
{
	PantheonShellSolidColorContainer* _tmp0_;
	PantheonShellSolidColorContainer* _tmp6_;
	PantheonShellSolidColorContainer* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = self->priv->solid_color;
	if (_tmp0_ != NULL) {
		GtkFlowBox* _tmp1_;
		PantheonShellSolidColorContainer* _tmp2_;
		GtkFlowBox* _tmp3_;
		PantheonShellSolidColorContainer* _tmp4_;
		PantheonShellSolidColorContainer* _tmp5_;
		_tmp1_ = self->priv->wallpaper_view;
		_tmp2_ = self->priv->solid_color;
		gtk_flow_box_unselect_child (_tmp1_, (GtkFlowBoxChild*) _tmp2_);
		_tmp3_ = self->priv->wallpaper_view;
		_tmp4_ = self->priv->solid_color;
		gtk_container_remove ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
		_tmp5_ = self->priv->solid_color;
		gtk_widget_destroy ((GtkWidget*) _tmp5_);
	}
	_tmp6_ = pantheon_shell_solid_color_container_new (color);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->solid_color);
	self->priv->solid_color = _tmp6_;
	_tmp7_ = self->priv->solid_color;
	gtk_widget_show_all ((GtkWidget*) _tmp7_);
}

static void
pantheon_shell_wallpaper_clean_wallpapers (PantheonShellWallpaper* self)
{
	GtkFlowBox* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wallpaper_view;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = child;
				gtk_widget_destroy (_tmp2_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_g_object_unref0 (self->priv->solid_color);
	self->priv->solid_color = NULL;
}

static gchar*
pantheon_shell_wallpaper_get_local_bg_directory (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "backgrounds", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
pantheon_shell_wallpaper_get_system_bg_directories (gint* result_length1)
{
	gchar** directories = NULL;
	gchar** _tmp0_;
	gint directories_length1;
	gint _directories_size_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** result;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	directories = _tmp0_;
	directories_length1 = 0;
	_directories_size_ = directories_length1;
	_tmp2_ = _tmp1_ = g_get_system_data_dirs ();
	{
		gchar** data_dir_collection = NULL;
		gint data_dir_collection_length1 = 0;
		gint _data_dir_collection_size_ = 0;
		gint data_dir_it = 0;
		data_dir_collection = _tmp2_;
		data_dir_collection_length1 = _vala_array_length (_tmp1_);
		for (data_dir_it = 0; data_dir_it < data_dir_collection_length1; data_dir_it = data_dir_it + 1) {
			const gchar* data_dir = NULL;
			data_dir = data_dir_collection[data_dir_it];
			{
				gchar* system_background_dir = NULL;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				const gchar* _tmp8_;
				_tmp3_ = data_dir;
				_tmp4_ = g_build_filename (_tmp3_, "backgrounds", NULL);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strconcat (_tmp5_, "/", NULL);
				_tmp7_ = _tmp6_;
				_g_free0 (_tmp5_);
				system_background_dir = _tmp7_;
				_tmp8_ = system_background_dir;
				if (g_file_test (_tmp8_, G_FILE_TEST_EXISTS)) {
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp9_ = system_background_dir;
					g_debug ("Wallpaper.vala:425: Found system background directory: %s", _tmp9_);
					_tmp10_ = system_background_dir;
					_tmp11_ = g_strdup (_tmp10_);
					_vala_array_add2 (&directories, &directories_length1, &_directories_size_, _tmp11_);
				}
				_g_free0 (system_background_dir);
			}
		}
	}
	_tmp12_ = directories;
	_tmp12__length1 = directories_length1;
	if (result_length1) {
		*result_length1 = _tmp12__length1;
	}
	result = _tmp12_;
	return result;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
pantheon_shell_wallpaper_get_bg_directories (PantheonShellWallpaper* self,
                                             gint* result_length1)
{
	gchar** background_directories = NULL;
	gchar** _tmp0_;
	gint background_directories_length1;
	gint _background_directories_size_;
	gchar* _tmp1_;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	background_directories = _tmp0_;
	background_directories_length1 = 0;
	_background_directories_size_ = background_directories_length1;
	_tmp1_ = pantheon_shell_wallpaper_get_local_bg_directory ();
	_vala_array_add3 (&background_directories, &background_directories_length1, &_background_directories_size_, _tmp1_);
	_tmp3_ = pantheon_shell_wallpaper_get_system_bg_directories (&_tmp2_);
	{
		gchar** bg_dir_collection = NULL;
		gint bg_dir_collection_length1 = 0;
		gint _bg_dir_collection_size_ = 0;
		gint bg_dir_it = 0;
		bg_dir_collection = _tmp3_;
		bg_dir_collection_length1 = _tmp2_;
		for (bg_dir_it = 0; bg_dir_it < bg_dir_collection_length1; bg_dir_it = bg_dir_it + 1) {
			gchar* _tmp4_;
			gchar* bg_dir = NULL;
			_tmp4_ = g_strdup (bg_dir_collection[bg_dir_it]);
			bg_dir = _tmp4_;
			{
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = bg_dir;
				_tmp6_ = g_strdup (_tmp5_);
				_vala_array_add4 (&background_directories, &background_directories_length1, &_background_directories_size_, _tmp6_);
				_g_free0 (bg_dir);
			}
		}
		bg_dir_collection = (_vala_array_free (bg_dir_collection, bg_dir_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp7_ = background_directories;
	_tmp7__length1 = background_directories_length1;
	if (_tmp7__length1 == 0) {
		g_warning ("Wallpaper.vala:444: No background directories found");
	}
	_tmp8_ = background_directories;
	_tmp8__length1 = background_directories_length1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}

static GFile*
pantheon_shell_wallpaper_copy_for_library (GFile* source)
{
	GFile* dest = NULL;
	gchar* local_bg_directory = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (source != NULL, NULL);
	dest = NULL;
	_tmp0_ = pantheon_shell_wallpaper_get_local_bg_directory ();
	local_bg_directory = _tmp0_;
	{
		GFile* folder = NULL;
		GFile* _tmp1_;
		_tmp1_ = g_file_new_for_path (local_bg_directory);
		folder = _tmp1_;
		g_file_make_directory_with_parents (folder, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (folder);
			goto __catch0_g_error;
		}
		_g_object_unref0 (folder);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		if (g_error_matches (_tmp2_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			g_debug ("Wallpaper.vala:459: Local background directory already exists");
		} else {
			GError* _tmp3_;
			const gchar* _tmp4_;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_warning ("Wallpaper.vala:461: %s", _tmp4_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (local_bg_directory);
		_g_object_unref0 (dest);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		gchar* timestamp = NULL;
		GDateTime* _tmp5_;
		GDateTime* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* filename = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* path = NULL;
		gchar* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
		_tmp5_ = g_date_time_new_now_local ();
		_tmp6_ = _tmp5_;
		_tmp7_ = g_date_time_format (_tmp6_, "%Y-%m-%d-%H-%M-%S");
		_tmp8_ = _tmp7_;
		_g_date_time_unref0 (_tmp6_);
		timestamp = _tmp8_;
		_tmp9_ = g_file_get_basename (source);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("%s-%s", timestamp, _tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		filename = _tmp12_;
		_tmp13_ = g_build_filename (local_bg_directory, filename, NULL);
		path = _tmp13_;
		_tmp14_ = g_file_new_for_path (path);
		_g_object_unref0 (dest);
		dest = _tmp14_;
		_tmp15_ = dest;
		g_file_copy (source, _tmp15_, G_FILE_COPY_OVERWRITE | G_FILE_COPY_ALL_METADATA, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (path);
			_g_free0 (filename);
			_g_free0 (timestamp);
			goto __catch1_g_error;
		}
		_g_free0 (path);
		_g_free0 (filename);
		_g_free0 (timestamp);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("Wallpaper.vala:472: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (local_bg_directory);
		_g_object_unref0 (dest);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = dest;
	_g_free0 (local_bg_directory);
	return result;
}

static GFile*
pantheon_shell_wallpaper_copy_for_greeter (GFile* source)
{
	GFile* dest = NULL;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (source != NULL, NULL);
	dest = NULL;
	{
		gchar* greeter_data_dir = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		GFile* folder = NULL;
		const gchar* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GFile* _tmp25_;
		GFile* _tmp26_;
		GFile* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp0_ = g_getenv ("XDG_GREETER_DATA_DIR");
		_tmp1_ = g_build_filename (_tmp0_, "wallpaper", NULL);
		greeter_data_dir = _tmp1_;
		_tmp2_ = greeter_data_dir;
		if (g_strcmp0 (_tmp2_, "") == 0) {
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = g_get_user_name ();
			_tmp4_ = g_build_filename ("/var/lib/lightdm-data/", _tmp3_, "wallpaper", NULL);
			_g_free0 (greeter_data_dir);
			greeter_data_dir = _tmp4_;
		}
		_tmp5_ = greeter_data_dir;
		_tmp6_ = g_file_new_for_path (_tmp5_);
		folder = _tmp6_;
		_tmp7_ = folder;
		if (g_file_query_exists (_tmp7_, NULL)) {
			GFileEnumerator* enumerator = NULL;
			GFile* _tmp8_;
			GFileEnumerator* _tmp9_;
			GFileInfo* info = NULL;
			_tmp8_ = folder;
			_tmp9_ = g_file_enumerate_children (_tmp8_, "standard::*", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
			enumerator = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (folder);
				_g_free0 (greeter_data_dir);
				goto __catch0_g_error;
			}
			info = NULL;
			while (TRUE) {
				GFileInfo* _tmp10_ = NULL;
				GFileEnumerator* _tmp11_;
				GFileInfo* _tmp12_;
				GFileInfo* _tmp13_;
				GFileInfo* _tmp14_;
				GFileEnumerator* _tmp15_;
				GFileInfo* _tmp16_;
				GFile* _tmp17_;
				GFile* _tmp18_;
				_tmp11_ = enumerator;
				_tmp12_ = g_file_enumerator_next_file (_tmp11_, NULL, &_inner_error0_);
				_tmp10_ = _tmp12_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (info);
					_g_object_unref0 (enumerator);
					_g_object_unref0 (folder);
					_g_free0 (greeter_data_dir);
					goto __catch0_g_error;
				}
				_tmp13_ = _tmp10_;
				_tmp10_ = NULL;
				_g_object_unref0 (info);
				info = _tmp13_;
				_tmp14_ = info;
				if (!(_tmp14_ != NULL)) {
					_g_object_unref0 (_tmp10_);
					break;
				}
				_tmp15_ = enumerator;
				_tmp16_ = info;
				_tmp17_ = g_file_enumerator_get_child (_tmp15_, _tmp16_);
				_tmp18_ = _tmp17_;
				g_file_delete (_tmp18_, NULL, &_inner_error0_);
				_g_object_unref0 (_tmp18_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (_tmp10_);
					_g_object_unref0 (info);
					_g_object_unref0 (enumerator);
					_g_object_unref0 (folder);
					_g_free0 (greeter_data_dir);
					goto __catch0_g_error;
				}
				_g_object_unref0 (_tmp10_);
			}
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
		} else {
			GFile* _tmp19_;
			_tmp19_ = folder;
			g_file_make_directory_with_parents (_tmp19_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (folder);
				_g_free0 (greeter_data_dir);
				goto __catch0_g_error;
			}
		}
		_tmp20_ = greeter_data_dir;
		_tmp21_ = g_file_get_basename (source);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_build_filename (_tmp20_, _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_file_new_for_path (_tmp24_);
		_g_object_unref0 (dest);
		dest = _tmp25_;
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_tmp26_ = dest;
		g_file_copy (source, _tmp26_, G_FILE_COPY_OVERWRITE | G_FILE_COPY_ALL_METADATA, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (folder);
			_g_free0 (greeter_data_dir);
			goto __catch0_g_error;
		}
		_tmp27_ = dest;
		_tmp28_ = g_file_get_path (_tmp27_);
		_tmp29_ = _tmp28_;
		g_chmod (_tmp29_, 0604);
		_g_free0 (_tmp29_);
		_g_object_unref0 (folder);
		_g_free0 (greeter_data_dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		g_warning ("Wallpaper.vala:502: %s", _tmp31_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (dest);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (dest);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = dest;
	return result;
}

static void
pantheon_shell_wallpaper_on_drag_data_received (PantheonShellWallpaper* self,
                                                GtkWidget* widget,
                                                GdkDragContext* ctx,
                                                gint x,
                                                gint y,
                                                GtkSelectionData* sel,
                                                guint information,
                                                guint timestamp)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (sel != NULL);
	if (gtk_selection_data_get_length (sel) > 0) {
		{
			GFile* file = NULL;
			gchar** _tmp0_;
			gchar** _tmp1_;
			gchar** _tmp2_;
			gint _tmp2__length1;
			const gchar* _tmp3_;
			GFile* _tmp4_;
			GFile* _tmp5_;
			GFileInfo* info = NULL;
			GFile* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			GFileInfo* _tmp9_;
			GFileInfo* _tmp10_;
			GFileInfo* _tmp11_;
			gchar* local_uri = NULL;
			GFile* _tmp12_;
			gchar* _tmp13_;
			GFile* dest = NULL;
			GFile* _tmp14_;
			GFile* _tmp15_;
			GFile* _tmp16_;
			GFile* _tmp19_;
			const gchar* _tmp20_;
			_tmp1_ = _tmp0_ = gtk_selection_data_get_uris (sel);
			_tmp2_ = _tmp1_;
			_tmp2__length1 = _vala_array_length (_tmp0_);
			_tmp3_ = _tmp2_[0];
			_tmp4_ = g_file_new_for_uri (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
			file = _tmp5_;
			_tmp6_ = file;
			_tmp7_ = _vala_g_strjoinv (",", PANTHEON_SHELL_WALLPAPER_REQUIRED_FILE_ATTRS, (gint) G_N_ELEMENTS (PANTHEON_SHELL_WALLPAPER_REQUIRED_FILE_ATTRS));
			_tmp8_ = _tmp7_;
			_tmp9_ = g_file_query_info (_tmp6_, _tmp8_, 0, NULL, &_inner_error0_);
			_tmp10_ = _tmp9_;
			_g_free0 (_tmp8_);
			info = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				goto __catch0_g_error;
			}
			_tmp11_ = info;
			if (!pantheon_shell_io_helper_is_valid_file_type (_tmp11_)) {
				gtk_drag_finish (ctx, FALSE, FALSE, (guint32) timestamp);
				_g_object_unref0 (info);
				_g_object_unref0 (file);
				return;
			}
			_tmp12_ = file;
			_tmp13_ = g_file_get_uri (_tmp12_);
			local_uri = _tmp13_;
			_tmp14_ = file;
			_tmp15_ = pantheon_shell_wallpaper_copy_for_library (_tmp14_);
			dest = _tmp15_;
			_tmp16_ = dest;
			if (_tmp16_ != NULL) {
				GFile* _tmp17_;
				gchar* _tmp18_;
				_tmp17_ = dest;
				_tmp18_ = g_file_get_uri (_tmp17_);
				_g_free0 (local_uri);
				local_uri = _tmp18_;
			}
			_tmp19_ = file;
			_tmp20_ = local_uri;
			pantheon_shell_wallpaper_add_wallpaper_from_file (self, _tmp19_, _tmp20_);
			gtk_drag_finish (ctx, TRUE, FALSE, (guint32) timestamp);
			_g_object_unref0 (dest);
			_g_free0 (local_uri);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp21_;
			const gchar* _tmp22_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp21_ = e;
			_tmp22_ = _tmp21_->message;
			g_warning ("Wallpaper.vala:530: %s", _tmp22_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	gtk_drag_finish (ctx, FALSE, FALSE, (guint32) timestamp);
	return;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		PantheonShellWallpaper* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->wallpaper);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
___lambda10_ (Block6Data* _data6_)
{
	PantheonShellWallpaper* self;
	PantheonShellWallpaperContainer* _tmp0_;
	self = _data6_->self;
	pantheon_shell_wallpaper_send_undo_toast (self);
	_tmp0_ = _data6_->wallpaper;
	pantheon_shell_wallpaper_mark_for_removal (self, _tmp0_);
}

static void
____lambda10__pantheon_shell_wallpaper_container_trash (PantheonShellWallpaperContainer* _sender,
                                                        gpointer self)
{
	___lambda10_ (self);
}

static void
pantheon_shell_wallpaper_add_wallpaper_from_file (PantheonShellWallpaper* self,
                                                  GFile* file,
                                                  const gchar* uri)
{
	gboolean _tmp0_ = FALSE;
	PantheonShellWallpaperContainer* _tmp1_;
	GtkFlowBox* _tmp30_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (uri != NULL);
	_tmp1_ = self->priv->wallpaper_for_removal;
	if (_tmp1_ != NULL) {
		PantheonShellWallpaperContainer* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->wallpaper_for_removal;
		_tmp3_ = pantheon_shell_wallpaper_container_get_uri (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, uri) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	{
		Block6Data* _data6_;
		GFileInfo* info = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GFileInfo* _tmp7_;
		GFileInfo* _tmp8_;
		gchar* thumb_path = NULL;
		GFileInfo* _tmp9_;
		gchar* _tmp10_;
		gboolean thumb_valid = FALSE;
		GFileInfo* _tmp11_;
		const gchar* _tmp12_;
		PantheonShellWallpaperContainer* _tmp13_;
		GtkFlowBox* _tmp14_;
		PantheonShellWallpaperContainer* _tmp15_;
		PantheonShellWallpaperContainer* _tmp16_;
		PantheonShellWallpaperContainer* _tmp17_;
		gboolean _tmp18_ = FALSE;
		const gchar* _tmp19_;
		_data6_ = g_slice_new0 (Block6Data);
		_data6_->_ref_count_ = 1;
		_data6_->self = g_object_ref (self);
		_tmp5_ = _vala_g_strjoinv (",", PANTHEON_SHELL_WALLPAPER_REQUIRED_FILE_ATTRS, (gint) G_N_ELEMENTS (PANTHEON_SHELL_WALLPAPER_REQUIRED_FILE_ATTRS));
		_tmp6_ = _tmp5_;
		_tmp7_ = g_file_query_info (file, _tmp6_, 0, NULL, &_inner_error0_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		info = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_tmp9_ = info;
		_tmp10_ = g_file_info_get_attribute_as_string (_tmp9_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
		thumb_path = _tmp10_;
		_tmp11_ = info;
		thumb_valid = g_file_info_get_attribute_boolean (_tmp11_, G_FILE_ATTRIBUTE_THUMBNAIL_IS_VALID);
		_tmp12_ = thumb_path;
		_tmp13_ = pantheon_shell_wallpaper_container_new (uri, _tmp12_, thumb_valid);
		g_object_ref_sink (_tmp13_);
		_data6_->wallpaper = _tmp13_;
		_tmp14_ = self->priv->wallpaper_view;
		_tmp15_ = _data6_->wallpaper;
		gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
		_tmp16_ = _data6_->wallpaper;
		gtk_widget_show_all ((GtkWidget*) _tmp16_);
		_tmp17_ = _data6_->wallpaper;
		g_signal_connect_data (_tmp17_, "trash", (GCallback) ____lambda10__pantheon_shell_wallpaper_container_trash, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
		_tmp19_ = self->priv->current_wallpaper_path;
		if (g_str_has_suffix (_tmp19_, uri)) {
			GSettings* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp20_ = self->priv->settings;
			_tmp21_ = g_settings_get_string (_tmp20_, "picture-options");
			_tmp22_ = _tmp21_;
			_tmp18_ = g_strcmp0 (_tmp22_, "none") != 0;
			_g_free0 (_tmp22_);
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			GtkFlowBox* _tmp23_;
			PantheonShellWallpaperContainer* _tmp24_;
			PantheonShellWallpaperContainer* _tmp25_;
			PantheonShellWallpaperContainer* _tmp26_;
			PantheonShellWallpaperContainer* _tmp27_;
			_tmp23_ = self->priv->wallpaper_view;
			_tmp24_ = _data6_->wallpaper;
			gtk_flow_box_select_child (_tmp23_, (GtkFlowBoxChild*) _tmp24_);
			_tmp25_ = _data6_->wallpaper;
			pantheon_shell_wallpaper_container_set_checked (_tmp25_, TRUE);
			_tmp26_ = _data6_->wallpaper;
			_tmp27_ = _g_object_ref0 (_tmp26_);
			_g_object_unref0 (self->priv->active_wallpaper);
			self->priv->active_wallpaper = _tmp27_;
		}
		_g_free0 (thumb_path);
		_g_object_unref0 (info);
		block6_data_unref (_data6_);
		_data6_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp28_;
		const gchar* _tmp29_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->message;
		g_critical ("Wallpaper.vala:566: Unable to add wallpaper: %s", _tmp29_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp30_ = self->priv->wallpaper_view;
	gtk_flow_box_invalidate_sort (_tmp30_);
}

void
pantheon_shell_wallpaper_cancel_thumbnail_generation (PantheonShellWallpaper* self)
{
	GCancellable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->last_cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->last_cancellable;
		g_cancellable_cancel (_tmp1_);
	}
}

static gint
pantheon_shell_wallpaper_wallpapers_sort_function (PantheonShellWallpaper* self,
                                                   GtkFlowBoxChild* _child1,
                                                   GtkFlowBoxChild* _child2)
{
	PantheonShellWallpaperContainer* child1 = NULL;
	PantheonShellWallpaperContainer* _tmp0_;
	PantheonShellWallpaperContainer* child2 = NULL;
	PantheonShellWallpaperContainer* _tmp1_;
	gchar* uri1 = NULL;
	PantheonShellWallpaperContainer* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* uri2 = NULL;
	PantheonShellWallpaperContainer* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	gboolean uri1_is_system = FALSE;
	gboolean uri2_is_system = FALSE;
	gint _tmp13_ = 0;
	gchar** _tmp14_;
	gboolean _tmp24_ = FALSE;
	guint64 child1_date = 0ULL;
	PantheonShellWallpaperContainer* _tmp26_;
	guint64 child2_date = 0ULL;
	PantheonShellWallpaperContainer* _tmp27_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (_child1 != NULL, 0);
	g_return_val_if_fail (_child2 != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_child1, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer));
	child1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_child2, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer));
	child2 = _tmp1_;
	_tmp2_ = child1;
	_tmp3_ = pantheon_shell_wallpaper_container_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	uri1 = _tmp5_;
	_tmp6_ = child2;
	_tmp7_ = pantheon_shell_wallpaper_container_get_uri (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup (_tmp8_);
	uri2 = _tmp9_;
	_tmp11_ = uri1;
	if (_tmp11_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		const gchar* _tmp12_;
		_tmp12_ = uri2;
		_tmp10_ = _tmp12_ == NULL;
	}
	if (_tmp10_) {
		result = 0;
		_g_free0 (uri2);
		_g_free0 (uri1);
		_g_object_unref0 (child2);
		_g_object_unref0 (child1);
		return result;
	}
	uri1_is_system = FALSE;
	uri2_is_system = FALSE;
	_tmp14_ = pantheon_shell_wallpaper_get_system_bg_directories (&_tmp13_);
	{
		gchar** bg_dir_collection = NULL;
		gint bg_dir_collection_length1 = 0;
		gint _bg_dir_collection_size_ = 0;
		gint bg_dir_it = 0;
		bg_dir_collection = _tmp14_;
		bg_dir_collection_length1 = _tmp13_;
		for (bg_dir_it = 0; bg_dir_it < bg_dir_collection_length1; bg_dir_it = bg_dir_it + 1) {
			gchar* _tmp15_;
			gchar* bg_dir = NULL;
			_tmp15_ = g_strdup (bg_dir_collection[bg_dir_it]);
			bg_dir = _tmp15_;
			{
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gboolean _tmp18_ = FALSE;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				gboolean _tmp21_ = FALSE;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				_tmp16_ = bg_dir;
				_tmp17_ = g_strconcat ("file://", _tmp16_, NULL);
				_g_free0 (bg_dir);
				bg_dir = _tmp17_;
				_tmp19_ = uri1;
				_tmp20_ = bg_dir;
				if (g_str_has_prefix (_tmp19_, _tmp20_)) {
					_tmp18_ = TRUE;
				} else {
					_tmp18_ = uri1_is_system;
				}
				uri1_is_system = _tmp18_;
				_tmp22_ = uri2;
				_tmp23_ = bg_dir;
				if (g_str_has_prefix (_tmp22_, _tmp23_)) {
					_tmp21_ = TRUE;
				} else {
					_tmp21_ = uri2_is_system;
				}
				uri2_is_system = _tmp21_;
				_g_free0 (bg_dir);
			}
		}
		bg_dir_collection = (_vala_array_free (bg_dir_collection, bg_dir_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	if (uri1_is_system) {
		_tmp24_ = !uri2_is_system;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		result = 1;
		_g_free0 (uri2);
		_g_free0 (uri1);
		_g_object_unref0 (child2);
		_g_object_unref0 (child1);
		return result;
	} else {
		gboolean _tmp25_ = FALSE;
		if (!uri1_is_system) {
			_tmp25_ = uri2_is_system;
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			result = -1;
			_g_free0 (uri2);
			_g_free0 (uri1);
			_g_object_unref0 (child2);
			_g_object_unref0 (child1);
			return result;
		}
	}
	_tmp26_ = child1;
	child1_date = _tmp26_->creation_date;
	_tmp27_ = child2;
	child2_date = _tmp27_->creation_date;
	if (child1_date == child2_date) {
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp28_ = uri1;
		_tmp29_ = uri2;
		result = g_utf8_collate (_tmp28_, _tmp29_);
		_g_free0 (uri2);
		_g_free0 (uri1);
		_g_object_unref0 (child2);
		_g_object_unref0 (child1);
		return result;
	}
	if (child1_date >= child2_date) {
		result = -1;
		_g_free0 (uri2);
		_g_free0 (uri1);
		_g_object_unref0 (child2);
		_g_object_unref0 (child1);
		return result;
	} else {
		result = 1;
		_g_free0 (uri2);
		_g_free0 (uri1);
		_g_object_unref0 (child2);
		_g_object_unref0 (child1);
		return result;
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		PantheonShellWallpaper* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->toast);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda11_ (PantheonShellWallpaper* self)
{
	pantheon_shell_wallpaper_undo_removal (self);
}

static void
___lambda11__granite_widgets_toast_default_action (GraniteWidgetsToast* _sender,
                                                   gpointer self)
{
	__lambda11_ ((PantheonShellWallpaper*) self);
}

static void
__lambda12_ (Block7Data* _data7_)
{
	PantheonShellWallpaper* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data7_->self;
	_tmp1_ = gtk_revealer_get_child_revealed ((GtkRevealer*) _data7_->toast);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		PantheonShellWallpaperContainer* _tmp3_;
		_tmp3_ = self->priv->wallpaper_for_removal;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		pantheon_shell_wallpaper_confirm_removal (self);
	}
}

static void
___lambda12__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda12_ (self);
}

static void
pantheon_shell_wallpaper_send_undo_toast (PantheonShellWallpaper* self)
{
	Block7Data* _data7_;
	GtkOverlay* _tmp0_;
	GList* _tmp1_;
	PantheonShellWallpaperContainer* _tmp4_;
	GraniteWidgetsToast* _tmp5_;
	GtkOverlay* _tmp6_;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = self->priv->view_overlay;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = child;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GRANITE_WIDGETS_TYPE_TOAST)) {
					GtkWidget* _tmp3_;
					_tmp3_ = child;
					gtk_widget_destroy (_tmp3_);
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp4_ = self->priv->wallpaper_for_removal;
	if (_tmp4_ != NULL) {
		pantheon_shell_wallpaper_confirm_removal (self);
	}
	_tmp5_ = granite_widgets_toast_new (_ ("Wallpaper Deleted"));
	g_object_ref_sink (_tmp5_);
	_data7_->toast = _tmp5_;
	granite_widgets_toast_set_default_action (_data7_->toast, _ ("Undo"));
	gtk_widget_show_all ((GtkWidget*) _data7_->toast);
	g_signal_connect_object (_data7_->toast, "default-action", (GCallback) ___lambda11__granite_widgets_toast_default_action, self, 0);
	g_signal_connect_data ((GObject*) _data7_->toast, "notify::child-revealed", (GCallback) ___lambda12__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp6_ = self->priv->view_overlay;
	gtk_overlay_add_overlay (_tmp6_, (GtkWidget*) _data7_->toast);
	granite_widgets_toast_send_notification (_data7_->toast);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
pantheon_shell_wallpaper_mark_for_removal (PantheonShellWallpaper* self,
                                           PantheonShellWallpaperContainer* wallpaper)
{
	GtkFlowBox* _tmp0_;
	PantheonShellWallpaperContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (wallpaper != NULL);
	_tmp0_ = self->priv->wallpaper_view;
	gtk_container_remove ((GtkContainer*) _tmp0_, (GtkWidget*) wallpaper);
	_tmp1_ = _g_object_ref0 (wallpaper);
	_g_object_unref0 (self->priv->wallpaper_for_removal);
	self->priv->wallpaper_for_removal = _tmp1_;
}

static void
pantheon_shell_wallpaper_confirm_removal (PantheonShellWallpaper* self)
{
	GFile* wallpaper_file = NULL;
	PantheonShellWallpaperContainer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	PantheonShellWallpaperContainer* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wallpaper_for_removal;
	_tmp1_ = pantheon_shell_wallpaper_container_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_new_for_uri (_tmp2_);
	wallpaper_file = _tmp3_;
	g_file_trash_async (wallpaper_file, G_PRIORITY_DEFAULT, NULL, NULL, NULL);
	_tmp4_ = self->priv->wallpaper_for_removal;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	_g_object_unref0 (self->priv->wallpaper_for_removal);
	self->priv->wallpaper_for_removal = NULL;
	_g_object_unref0 (wallpaper_file);
}

static void
pantheon_shell_wallpaper_undo_removal (PantheonShellWallpaper* self)
{
	GtkFlowBox* _tmp0_;
	PantheonShellWallpaperContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wallpaper_view;
	_tmp1_ = self->priv->wallpaper_for_removal;
	gtk_container_add ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp1_);
	_g_object_unref0 (self->priv->wallpaper_for_removal);
	self->priv->wallpaper_for_removal = NULL;
}

SwitchboardPlug*
pantheon_shell_wallpaper_get_plug (PantheonShellWallpaper* self)
{
	SwitchboardPlug* result;
	SwitchboardPlug* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_plug;
	result = _tmp0_;
	return result;
}

void
pantheon_shell_wallpaper_set_plug (PantheonShellWallpaper* self,
                                   SwitchboardPlug* value)
{
	SwitchboardPlug* old_value;
	g_return_if_fail (self != NULL);
	old_value = pantheon_shell_wallpaper_get_plug (self);
	if (old_value != value) {
		SwitchboardPlug* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_plug);
		self->priv->_plug = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pantheon_shell_wallpaper_properties[PANTHEON_SHELL_WALLPAPER_PLUG_PROPERTY]);
	}
}

static void
_pantheon_shell_wallpaper_update_checked_wallpaper_gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                                 GtkFlowBoxChild* child,
                                                                                 gpointer self)
{
	pantheon_shell_wallpaper_update_checked_wallpaper ((PantheonShellWallpaper*) self, _sender, child);
}

static gint
_pantheon_shell_wallpaper_wallpapers_sort_function_gtk_flow_box_sort_func (GtkFlowBoxChild* child1,
                                                                           GtkFlowBoxChild* child2,
                                                                           gpointer self)
{
	gint result;
	result = pantheon_shell_wallpaper_wallpapers_sort_function ((PantheonShellWallpaper*) self, child1, child2);
	return result;
}

static void
_pantheon_shell_wallpaper_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                               GdkDragContext* context,
                                                                               gint x,
                                                                               gint y,
                                                                               GtkSelectionData* selection_data,
                                                                               guint info,
                                                                               guint time_,
                                                                               gpointer self)
{
	pantheon_shell_wallpaper_on_drag_data_received ((PantheonShellWallpaper*) self, _sender, context, x, y, selection_data, info, time_);
}

static void
_pantheon_shell_wallpaper_update_mode_gtk_combo_box_changed (GtkComboBox* _sender,
                                                             gpointer self)
{
	pantheon_shell_wallpaper_update_mode ((PantheonShellWallpaper*) self);
}

static void
_pantheon_shell_wallpaper_update_color_gtk_color_button_color_set (GtkColorButton* _sender,
                                                                   gpointer self)
{
	pantheon_shell_wallpaper_update_color ((PantheonShellWallpaper*) self);
}

static void
_pantheon_shell_wallpaper_show_wallpaper_chooser_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self)
{
	pantheon_shell_wallpaper_show_wallpaper_chooser ((PantheonShellWallpaper*) self);
}

static GObject *
pantheon_shell_wallpaper_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PantheonShellWallpaper * self;
	GSettings* _tmp0_;
	GtkSeparator* separator = NULL;
	GtkSeparator* _tmp9_;
	GtkFlowBox* _tmp10_;
	GtkFlowBox* _tmp11_;
	GtkFlowBox* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkFlowBox* _tmp14_;
	GtkFlowBox* _tmp15_;
	GtkFlowBox* _tmp16_;
	GtkFlowBox* _tmp17_;
	gchar* color = NULL;
	GSettings* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	GtkTargetEntry e = {0};
	GtkTargetEntry _tmp21_ = {0};
	GtkFlowBox* _tmp22_;
	GtkFlowBox* _tmp23_;
	GtkTargetEntry _tmp24_;
	GtkTargetEntry* _tmp25_;
	GtkTargetEntry* _tmp26_;
	gint _tmp26__length1;
	GtkScrolledWindow* _tmp27_;
	GtkScrolledWindow* _tmp28_;
	GtkScrolledWindow* _tmp29_;
	GtkFlowBox* _tmp30_;
	GtkOverlay* _tmp31_;
	GtkOverlay* _tmp32_;
	GtkScrolledWindow* _tmp33_;
	GtkButton* add_wallpaper_button = NULL;
	GtkButton* _tmp34_;
	GtkButton* _tmp35_;
	GtkComboBoxText* _tmp36_;
	GtkComboBoxText* _tmp37_;
	GtkComboBoxText* _tmp38_;
	GtkComboBoxText* _tmp39_;
	GtkComboBoxText* _tmp40_;
	GtkComboBoxText* _tmp41_;
	GdkRGBA rgba_color = {0};
	GdkRGBA _tmp42_ = {0};
	const gchar* _tmp43_;
	GtkColorButton* _tmp45_;
	GtkColorButton* _tmp46_;
	GtkColorButton* _tmp47_;
	GtkColorButton* _tmp48_;
	GdkRGBA _tmp49_;
	GtkColorButton* _tmp50_;
	GtkSizeGroup* size_group = NULL;
	GtkSizeGroup* _tmp51_;
	GtkSizeGroup* _tmp52_;
	GtkButton* _tmp53_;
	GtkSizeGroup* _tmp54_;
	GtkComboBoxText* _tmp55_;
	GtkSizeGroup* _tmp56_;
	GtkColorButton* _tmp57_;
	GtkActionBar* actionbar = NULL;
	GtkActionBar* _tmp58_;
	GtkActionBar* _tmp59_;
	GtkStyleContext* _tmp60_;
	GtkActionBar* _tmp61_;
	GtkButton* _tmp62_;
	GtkActionBar* _tmp63_;
	GtkColorButton* _tmp64_;
	GtkActionBar* _tmp65_;
	GtkComboBoxText* _tmp66_;
	GtkSeparator* _tmp67_;
	GtkOverlay* _tmp68_;
	GtkActionBar* _tmp69_;
	GtkButton* _tmp70_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (pantheon_shell_wallpaper_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_WALLPAPER, PantheonShellWallpaper);
	_tmp0_ = g_settings_new ("org.gnome.desktop.background");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	{
		gint uid = 0;
		PantheonShellAccountsServiceUser* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		PantheonShellAccountsServiceUser* _tmp4_;
		PantheonShellAccountsServiceUser* _tmp5_;
		PantheonShellAccountsServiceUser* _tmp6_;
		uid = (gint) getuid ();
		_tmp2_ = g_strdup_printf ("/org/freedesktop/Accounts/User%i", uid);
		_tmp3_ = _tmp2_;
		_tmp4_ = (PantheonShellAccountsServiceUser*) g_initable_new (PANTHEON_SHELL_TYPE_ACCOUNTS_SERVICE_USER_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp3_, "g-interface-name", "org.freedesktop.DisplayManager.AccountsService", NULL);
		_tmp5_ = (PantheonShellAccountsServiceUser*) _tmp4_;
		_g_free0 (_tmp3_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->accountsservice);
		self->priv->accountsservice = _tmp6_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("Wallpaper.vala:79: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp9_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp9_);
	separator = _tmp9_;
	_tmp10_ = (GtkFlowBox*) gtk_flow_box_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->wallpaper_view);
	self->priv->wallpaper_view = _tmp10_;
	_tmp11_ = self->priv->wallpaper_view;
	gtk_flow_box_set_activate_on_single_click (_tmp11_, TRUE);
	_tmp12_ = self->priv->wallpaper_view;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	gtk_style_context_add_class (_tmp13_, GTK_STYLE_CLASS_VIEW);
	_tmp14_ = self->priv->wallpaper_view;
	gtk_flow_box_set_homogeneous (_tmp14_, TRUE);
	_tmp15_ = self->priv->wallpaper_view;
	gtk_flow_box_set_selection_mode (_tmp15_, GTK_SELECTION_SINGLE);
	_tmp16_ = self->priv->wallpaper_view;
	g_signal_connect_object (_tmp16_, "child-activated", (GCallback) _pantheon_shell_wallpaper_update_checked_wallpaper_gtk_flow_box_child_activated, self, 0);
	_tmp17_ = self->priv->wallpaper_view;
	gtk_flow_box_set_sort_func (_tmp17_, _pantheon_shell_wallpaper_wallpapers_sort_function_gtk_flow_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp18_ = self->priv->settings;
	_tmp19_ = g_settings_get_string (_tmp18_, "primary-color");
	color = _tmp19_;
	_tmp20_ = color;
	pantheon_shell_wallpaper_create_solid_color_container (self, _tmp20_);
	_tmp21_.target = "text/uri-list";
	_tmp21_.flags = (guint) 0;
	_tmp21_.info = (guint) 0;
	e = _tmp21_;
	_tmp22_ = self->priv->wallpaper_view;
	g_signal_connect_object ((GtkWidget*) _tmp22_, "drag-data-received", (GCallback) _pantheon_shell_wallpaper_on_drag_data_received_gtk_widget_drag_data_received, self, 0);
	_tmp23_ = self->priv->wallpaper_view;
	_tmp24_ = e;
	_tmp25_ = g_new0 (GtkTargetEntry, 1);
	_tmp25_[0] = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp26__length1 = 1;
	gtk_drag_dest_set ((GtkWidget*) _tmp23_, GTK_DEST_DEFAULT_ALL, _tmp26_, (gint) 1, GDK_ACTION_COPY);
	_tmp26_ = (g_free (_tmp26_), NULL);
	_tmp27_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->wallpaper_scrolled_window);
	self->priv->wallpaper_scrolled_window = _tmp27_;
	_tmp28_ = self->priv->wallpaper_scrolled_window;
	g_object_set ((GtkWidget*) _tmp28_, "expand", TRUE, NULL);
	_tmp29_ = self->priv->wallpaper_scrolled_window;
	_tmp30_ = self->priv->wallpaper_view;
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->view_overlay);
	self->priv->view_overlay = _tmp31_;
	_tmp32_ = self->priv->view_overlay;
	_tmp33_ = self->priv->wallpaper_scrolled_window;
	gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = (GtkButton*) gtk_button_new_with_label (_ ("Import Photo…"));
	g_object_ref_sink (_tmp34_);
	add_wallpaper_button = _tmp34_;
	_tmp35_ = add_wallpaper_button;
	g_object_set ((GtkWidget*) _tmp35_, "margin", 12, NULL);
	_tmp36_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->combo);
	self->priv->combo = _tmp36_;
	_tmp37_ = self->priv->combo;
	gtk_widget_set_valign ((GtkWidget*) _tmp37_, GTK_ALIGN_CENTER);
	_tmp38_ = self->priv->combo;
	gtk_combo_box_text_append (_tmp38_, "centered", _ ("Centered"));
	_tmp39_ = self->priv->combo;
	gtk_combo_box_text_append (_tmp39_, "zoom", _ ("Zoom"));
	_tmp40_ = self->priv->combo;
	gtk_combo_box_text_append (_tmp40_, "spanned", _ ("Spanned"));
	_tmp41_ = self->priv->combo;
	g_signal_connect_object ((GtkComboBox*) _tmp41_, "changed", (GCallback) _pantheon_shell_wallpaper_update_mode_gtk_combo_box_changed, self, 0);
	rgba_color = _tmp42_;
	_tmp43_ = color;
	if (!gdk_rgba_parse (&rgba_color, _tmp43_)) {
		GdkRGBA _tmp44_ = {0};
		_tmp44_.red = (gdouble) 1;
		_tmp44_.green = (gdouble) 1;
		_tmp44_.blue = (gdouble) 1;
		_tmp44_.alpha = (gdouble) 1;
		rgba_color = _tmp44_;
	}
	_tmp45_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->color_button);
	self->priv->color_button = _tmp45_;
	_tmp46_ = self->priv->color_button;
	g_object_set ((GtkWidget*) _tmp46_, "margin", 12, NULL);
	_tmp47_ = self->priv->color_button;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp47_, 0);
	_tmp48_ = self->priv->color_button;
	_tmp49_ = rgba_color;
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp48_, &_tmp49_);
	_tmp50_ = self->priv->color_button;
	g_signal_connect_object (_tmp50_, "color-set", (GCallback) _pantheon_shell_wallpaper_update_color_gtk_color_button_color_set, self, 0);
	_tmp51_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	size_group = _tmp51_;
	_tmp52_ = size_group;
	_tmp53_ = add_wallpaper_button;
	gtk_size_group_add_widget (_tmp52_, (GtkWidget*) _tmp53_);
	_tmp54_ = size_group;
	_tmp55_ = self->priv->combo;
	gtk_size_group_add_widget (_tmp54_, (GtkWidget*) _tmp55_);
	_tmp56_ = size_group;
	_tmp57_ = self->priv->color_button;
	gtk_size_group_add_widget (_tmp56_, (GtkWidget*) _tmp57_);
	pantheon_shell_wallpaper_load_settings (self);
	_tmp58_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp58_);
	actionbar = _tmp58_;
	_tmp59_ = actionbar;
	_tmp60_ = gtk_widget_get_style_context ((GtkWidget*) _tmp59_);
	gtk_style_context_add_class (_tmp60_, GTK_STYLE_CLASS_INLINE_TOOLBAR);
	_tmp61_ = actionbar;
	_tmp62_ = add_wallpaper_button;
	gtk_action_bar_pack_start (_tmp61_, (GtkWidget*) _tmp62_);
	_tmp63_ = actionbar;
	_tmp64_ = self->priv->color_button;
	gtk_action_bar_pack_end (_tmp63_, (GtkWidget*) _tmp64_);
	_tmp65_ = actionbar;
	_tmp66_ = self->priv->combo;
	gtk_action_bar_pack_end (_tmp65_, (GtkWidget*) _tmp66_);
	_tmp67_ = separator;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp67_, 0, 0, 1, 1);
	_tmp68_ = self->priv->view_overlay;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp68_, 0, 1, 1, 1);
	_tmp69_ = actionbar;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp69_, 0, 2, 1, 1);
	_tmp70_ = add_wallpaper_button;
	g_signal_connect_object (_tmp70_, "clicked", (GCallback) _pantheon_shell_wallpaper_show_wallpaper_chooser_gtk_button_clicked, self, 0);
	_g_object_unref0 (actionbar);
	_g_object_unref0 (size_group);
	_g_object_unref0 (add_wallpaper_button);
	_g_free0 (color);
	_g_object_unref0 (separator);
	return obj;
}

static void
pantheon_shell_wallpaper_class_init (PantheonShellWallpaperClass * klass,
                                     gpointer klass_data)
{
	pantheon_shell_wallpaper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantheonShellWallpaper_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pantheon_shell_wallpaper_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pantheon_shell_wallpaper_set_property;
	G_OBJECT_CLASS (klass)->constructor = pantheon_shell_wallpaper_constructor;
	G_OBJECT_CLASS (klass)->finalize = pantheon_shell_wallpaper_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_WALLPAPER_PLUG_PROPERTY, pantheon_shell_wallpaper_properties[PANTHEON_SHELL_WALLPAPER_PLUG_PROPERTY] = g_param_spec_object ("plug", "plug", "plug", SWITCHBOARD_TYPE_PLUG, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
pantheon_shell_wallpaper_instance_init (PantheonShellWallpaper * self,
                                        gpointer klass)
{
	self->priv = pantheon_shell_wallpaper_get_instance_private (self);
	self->priv->accountsservice = NULL;
	self->priv->active_wallpaper = NULL;
	self->priv->solid_color = NULL;
	self->priv->wallpaper_for_removal = NULL;
	self->priv->prevent_update_mode = FALSE;
}

static void
pantheon_shell_wallpaper_finalize (GObject * obj)
{
	PantheonShellWallpaper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_WALLPAPER, PantheonShellWallpaper);
	_g_object_unref0 (self->priv->_plug);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->accountsservice);
	_g_object_unref0 (self->priv->wallpaper_scrolled_window);
	_g_object_unref0 (self->priv->wallpaper_view);
	_g_object_unref0 (self->priv->view_overlay);
	_g_object_unref0 (self->priv->combo);
	_g_object_unref0 (self->priv->color_button);
	_g_object_unref0 (self->priv->active_wallpaper);
	_g_object_unref0 (self->priv->solid_color);
	_g_object_unref0 (self->priv->wallpaper_for_removal);
	_g_object_unref0 (self->priv->last_cancellable);
	_g_free0 (self->priv->current_wallpaper_path);
	G_OBJECT_CLASS (pantheon_shell_wallpaper_parent_class)->finalize (obj);
}

static GType
pantheon_shell_wallpaper_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellWallpaperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_wallpaper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellWallpaper), 0, (GInstanceInitFunc) pantheon_shell_wallpaper_instance_init, NULL };
	GType pantheon_shell_wallpaper_type_id;
	pantheon_shell_wallpaper_type_id = g_type_register_static (gtk_grid_get_type (), "PantheonShellWallpaper", &g_define_type_info, 0);
	PantheonShellWallpaper_private_offset = g_type_add_instance_private (pantheon_shell_wallpaper_type_id, sizeof (PantheonShellWallpaperPrivate));
	return pantheon_shell_wallpaper_type_id;
}

GType
pantheon_shell_wallpaper_get_type (void)
{
	static volatile gsize pantheon_shell_wallpaper_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_wallpaper_type_id__once)) {
		GType pantheon_shell_wallpaper_type_id;
		pantheon_shell_wallpaper_type_id = pantheon_shell_wallpaper_get_type_once ();
		g_once_init_leave (&pantheon_shell_wallpaper_type_id__once, pantheon_shell_wallpaper_type_id);
	}
	return pantheon_shell_wallpaper_type_id__once;
}

static void
_vala_pantheon_shell_wallpaper_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	PantheonShellWallpaper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHEON_SHELL_TYPE_WALLPAPER, PantheonShellWallpaper);
	switch (property_id) {
		case PANTHEON_SHELL_WALLPAPER_PLUG_PROPERTY:
		g_value_set_object (value, pantheon_shell_wallpaper_get_plug (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pantheon_shell_wallpaper_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	PantheonShellWallpaper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHEON_SHELL_TYPE_WALLPAPER, PantheonShellWallpaper);
	switch (property_id) {
		case PANTHEON_SHELL_WALLPAPER_PLUG_PROPERTY:
		pantheon_shell_wallpaper_set_plug (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

