import * as LSP from 'vscode-languageserver/node';
import { TextDocument } from 'vscode-languageserver-textdocument';
/**
 * The BashServer glues together the separate components to implement
 * the various parts of the Language Server Protocol.
 */
export default class BashServer {
    private analyzer;
    private clientCapabilities;
    private config;
    private connection;
    private documents;
    private executables;
    private linter?;
    private workspaceFolder;
    private uriToCodeActions;
    private constructor();
    /**
     * Initialize the server based on a connection to the client and the protocols
     * initialization parameters.
     */
    static initialize(connection: LSP.Connection, { rootPath, rootUri, capabilities }: LSP.InitializeParams): Promise<BashServer>;
    /**
     * Register handlers for the events from the Language Server Protocol that we
     * care about.
     */
    register(connection: LSP.Connection): void;
    private startBackgroundAnalysis;
    private updateConfiguration;
    /**
     * Analyze and lint the given document.
     */
    analyzeAndLintDocument(document: TextDocument): Promise<void>;
    /**
     * The parts of the Language Server Protocol that we are currently supporting.
     */
    capabilities(): LSP.ServerCapabilities;
    private getWordAtPoint;
    private getCommandNameAtPoint;
    private logRequest;
    private getDocumentationForSymbol;
    private getCompletionItemsForSymbols;
    private onHover;
    private onDefinition;
    private onDocumentSymbol;
    private onWorkspaceSymbol;
    private onDocumentHighlight;
    private onReferences;
    private onCompletion;
    private onCodeAction;
    private onCompletionResolve;
}
