import * as LSP from 'vscode-languageserver/node';
import { TextDocument } from 'vscode-languageserver-textdocument';
type LinterOptions = {
    executablePath: string;
    console: LSP.RemoteConsole;
    cwd?: string;
};
export declare class Linter {
    executablePath: string;
    private cwd;
    private console;
    private _canLint;
    constructor({ console, cwd, executablePath }: LinterOptions);
    get canLint(): boolean;
    lint(document: TextDocument, sourcePaths: string[], additionalShellCheckArguments?: string[]): Promise<{
        diagnostics: LSP.Diagnostic[];
        codeActions: LSP.CodeAction[];
    }>;
    private runShellCheck;
}
export {};
