# samples

In the context of Furnace, a sound sample (usually just referred to as a sample) is a string of numbers that hold sampled PCM audio.

In Furnace, these samples can be generated by importing a .wav (think of it as an higher quality MP3) file.

## supported chips

as of Furnace 0.6, the following sound chips have sample support:

- NES/Ricoh 2A03 (with DPCM support and only on channel 5)
- Sega Genesis/YM2612 (channel 6 only)
- PC Engine/TurboGrafx-16/HuC6280
- Amiga/Paula
- SegaPCM
- Neo Geo/Neo Geo CD/YM2610 (ADPCM channels only)
- Seta/Allumer X1-010
- Atari Lynx
- MSM6258 and MSM6295
- YMU759/MA-2 (last channel only)
- QSound
- ZX Spectrum 48k (1-bit)
- RF5C68
- WonderSwan
- tildearrow Sound Unit
- VERA (last channel only)
- Y8950 (last channel only)
- a few more that I've forgotten to mention

## compatible sample mode

effect `17xx` enables/disables compatible sample mode whether supported (e.g. on Sega Genesis or PC Engine).

in this mode, samples are mapped to notes in an octave from C to B, allowing you to use up to 12 samples.
if you need to use more samples, you may change the sample bank using effect `EBxx`.

use of this mode is discouraged in favor of Sample type instruments.

## notes

due to limitations in some of those sound chips, some restrictions exist:

- Amiga: sample lengths and loop will be set to an even number, and your sample can't be longer than 131070.
- NES: if on DPCM mode, only a limited selection of frequencies is available, and loop position isn't supported (only entire sample).
- SegaPCM: your sample can't be longer than 65535, and the maximum frequency is 31.25KHz.
- QSound: your sample can't be longer than 65535, and the loop length shall not be greater than 32767.
- Neo Geo (ADPCM-A): no looping supported. your samples will play at ~18.5KHz.
- Neo Geo (ADPCM-B): no loop position supported (only entire sample), and the maximum frequency is ~55KHz.
- YM2608: the maximum frequency is ~55KHz.
- MSM6258/MSM6295: no arbitrary frequency.
- ZX Spectrum Beeper: your sample can't be longer than 2048, and it always plays at ~55KHz.
- Seta/Allumer X1-010: frequency resolution is terrible in the lower end. your sample can't be longer than 131072.

furthermore, many of these chips have a limited amount of sample memory. check memory usage in window > statistics.

# the sample editor

You can actually tweak your samples in Furnace's sample editor, which can be accessed by clicking on `window` (at the top of the screen) then clicking on `sample editor`.

In there, you can modify certain data pertaining to your sample, such as the:
 - volume of the sample in percentage, where 100% is the current level of the sample (note that you can distort it if you put it too high)
 - the sample rate.
 - what frequencies to filter, along with filter level/sweep and resonance options (much like the C64)
 - and many more.

The changes you make will be applied as soon as you've committed them to your sample, but they can be undoed and redoed, just like text.
