/* AppSystem.c generated by valac 0.56.3, the Vala compiler
 * generated from AppSystem.vala, do not modify */

/*
 * Copyright 2021 elementary, Inc. <https://elementary.io>
 * Copyright 2021 Corentin Noël <tintou@noel.tf>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "gala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <glib-object.h>

enum  {
	GALA_APP_SYSTEM_0_PROPERTY,
	GALA_APP_SYSTEM_NUM_PROPERTIES
};
static GParamSpec* gala_app_system_properties[GALA_APP_SYSTEM_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GalaAppSystemPrivate {
	GHashTable* running_apps;
	GHashTable* id_to_app;
	GHashTable* startup_wm_class_to_id;
	GalaAppCache* app_cache;
};

static gint GalaAppSystem_private_offset;
static gpointer gala_app_system_parent_class = NULL;
static GOnce gala_app_system_instance;
static GOnce gala_app_system_instance = (GOnce) G_ONCE_INIT;

static GalaAppSystem* __lambda7_ (void);
static gpointer ___lambda7__gthread_func (gpointer self);
static GalaApp* gala_app_system_lookup_heuristic_basename (GalaAppSystem* self,
                                                    const gchar* name);
static GObject * gala_app_system_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
static void gala_app_system_finalize (GObject * obj);
static GType gala_app_system_get_type_once (void);

static inline gpointer
gala_app_system_get_instance_private (GalaAppSystem* self)
{
	return G_STRUCT_MEMBER_P (self, GalaAppSystem_private_offset);
}

static GalaAppSystem*
__lambda7_ (void)
{
	GalaAppSystem* _tmp0_;
	GalaAppSystem* result;
	_tmp0_ = gala_app_system_new ();
	result = _tmp0_;
	return result;
}

static gpointer
___lambda7__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda7_ ();
	return result;
}

GalaAppSystem*
gala_app_system_get_default (void)
{
	gconstpointer _tmp0_;
	GalaAppSystem* result;
	_tmp0_ = g_once (&gala_app_system_instance, ___lambda7__gthread_func, NULL);
	result = (GalaAppSystem*) _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GalaApp*
gala_app_system_lookup_app (GalaAppSystem* self,
                            const gchar* id)
{
	GalaApp* app = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GalaApp* _tmp2_;
	GDesktopAppInfo* info = NULL;
	GalaAppCache* _tmp4_;
	GDesktopAppInfo* _tmp5_;
	GDesktopAppInfo* _tmp6_;
	GDesktopAppInfo* _tmp7_;
	GalaApp* owned_app = NULL;
	GDesktopAppInfo* _tmp8_;
	GalaApp* _tmp9_;
	GalaApp* _tmp10_;
	GHashTable* _tmp11_;
	GalaApp* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GalaApp* _tmp15_;
	GalaApp* _tmp16_;
	GalaApp* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->priv->id_to_app;
	_tmp1_ = g_hash_table_lookup (_tmp0_, id);
	app = (GalaApp*) _tmp1_;
	_tmp2_ = app;
	if (_tmp2_ != NULL) {
		GalaApp* _tmp3_;
		_tmp3_ = app;
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->app_cache;
	_tmp5_ = gala_app_cache_lookup_id (_tmp4_, id);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	info = _tmp6_;
	_tmp7_ = info;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_object_unref0 (info);
		return result;
	}
	_tmp8_ = info;
	_tmp9_ = gala_app_new (_tmp8_);
	owned_app = _tmp9_;
	_tmp10_ = owned_app;
	app = _tmp10_;
	_tmp11_ = self->priv->id_to_app;
	_tmp12_ = owned_app;
	_tmp13_ = gala_app_get_id (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = owned_app;
	owned_app = NULL;
	g_hash_table_insert (_tmp11_, _tmp14_, _tmp15_);
	_tmp16_ = app;
	result = _tmp16_;
	_g_object_unref0 (owned_app);
	_g_object_unref0 (info);
	return result;
}

GalaApp*
gala_app_system_lookup_startup_wmclass (GalaAppSystem* self,
                                        const gchar* wmclass)
{
	GDesktopAppInfo* info = NULL;
	GalaAppCache* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	const gchar* _tmp4_;
	GalaApp* _tmp5_;
	GalaApp* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (wmclass == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->app_cache;
	_tmp1_ = gala_app_cache_lookup_startup_wmclass (_tmp0_, wmclass);
	info = _tmp1_;
	_tmp2_ = info;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (info);
		return result;
	}
	_tmp3_ = info;
	_tmp4_ = g_app_info_get_id ((GAppInfo*) _tmp3_);
	_tmp5_ = gala_app_system_lookup_app (self, _tmp4_);
	result = _tmp5_;
	_g_object_unref0 (info);
	return result;
}

static GalaApp*
gala_app_system_lookup_heuristic_basename (GalaAppSystem* self,
                                           const gchar* name)
{
	static const gchar* VENDOR_PREFIXES[4] = {"gnome-", "fedora-", "mozilla-", "debian-"};
	GalaApp* _result_ = NULL;
	GalaApp* _tmp0_;
	GalaApp* _tmp1_;
	GalaApp* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gala_app_system_lookup_app (self, name);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		GalaApp* _tmp2_;
		_tmp2_ = _result_;
		result = _tmp2_;
		return result;
	}
	{
		const gchar** prefix_collection = NULL;
		gint prefix_collection_length1 = 0;
		gint _prefix_collection_size_ = 0;
		gint prefix_it = 0;
		prefix_collection = VENDOR_PREFIXES;
		prefix_collection_length1 = G_N_ELEMENTS (VENDOR_PREFIXES);
		for (prefix_it = 0; prefix_it < prefix_collection_length1; prefix_it = prefix_it + 1) {
			const gchar* prefix = NULL;
			prefix = prefix_collection[prefix_it];
			{
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				GalaApp* _tmp6_;
				GalaApp* _tmp7_;
				_tmp3_ = prefix;
				_tmp4_ = g_strconcat (_tmp3_, name, NULL);
				_tmp5_ = _tmp4_;
				_tmp6_ = gala_app_system_lookup_app (self, _tmp5_);
				_result_ = _tmp6_;
				_g_free0 (_tmp5_);
				_tmp7_ = _result_;
				if (_tmp7_ != NULL) {
					GalaApp* _tmp8_;
					_tmp8_ = _result_;
					result = _tmp8_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

GalaApp*
gala_app_system_lookup_desktop_wmclass (GalaAppSystem* self,
                                        const gchar* wmclass)
{
	gchar* desktop_file = NULL;
	gchar* _tmp0_;
	GalaApp* app = NULL;
	const gchar* _tmp1_;
	GalaApp* _tmp2_;
	GalaApp* _tmp3_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	GalaApp* _tmp11_;
	GalaApp* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (wmclass == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = g_strconcat (wmclass, ".desktop", NULL);
	desktop_file = _tmp0_;
	_tmp1_ = desktop_file;
	_tmp2_ = gala_app_system_lookup_heuristic_basename (self, _tmp1_);
	app = _tmp2_;
	_tmp3_ = app;
	if (_tmp3_ != NULL) {
		GalaApp* _tmp4_;
		_tmp4_ = app;
		result = _tmp4_;
		_g_free0 (desktop_file);
		return result;
	}
	_tmp5_ = desktop_file;
	g_strdelimit (_tmp5_, " ", '-');
	_tmp6_ = desktop_file;
	_tmp7_ = g_ascii_strdown (_tmp6_, (gssize) -1);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, ".desktop", NULL);
	_g_free0 (desktop_file);
	desktop_file = _tmp9_;
	_g_free0 (_tmp8_);
	_tmp10_ = desktop_file;
	_tmp11_ = gala_app_system_lookup_heuristic_basename (self, _tmp10_);
	result = _tmp11_;
	_g_free0 (desktop_file);
	return result;
}

void
gala_app_system_notify_app_state_changed (GalaAppSystem* self,
                                          GalaApp* app)
{
	GalaAppState _tmp0_;
	GalaAppState _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	_tmp0_ = gala_app_get_state (app);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == GALA_APP_STATE_RUNNING) {
		GHashTable* _tmp2_;
		GalaApp* _tmp3_;
		_tmp2_ = self->priv->running_apps;
		_tmp3_ = _g_object_ref0 (app);
		g_hash_table_insert (_tmp2_, _tmp3_, app);
	} else {
		GalaAppState _tmp4_;
		GalaAppState _tmp5_;
		_tmp4_ = gala_app_get_state (app);
		_tmp5_ = _tmp4_;
		if (_tmp5_ == GALA_APP_STATE_STOPPED) {
			GHashTable* _tmp6_;
			_tmp6_ = self->priv->running_apps;
			g_hash_table_remove (_tmp6_, app);
		}
	}
}

GList*
gala_app_system_get_running_apps (GalaAppSystem* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->running_apps;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	result = _tmp1_;
	return result;
}

GalaAppSystem*
gala_app_system_construct (GType object_type)
{
	GalaAppSystem * self = NULL;
	self = (GalaAppSystem*) g_object_new (object_type, NULL);
	return self;
}

GalaAppSystem*
gala_app_system_new (void)
{
	return gala_app_system_construct (GALA_TYPE_APP_SYSTEM);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GObject *
gala_app_system_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaAppSystem * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	GalaAppCache* _tmp7_;
	parent_class = G_OBJECT_CLASS (gala_app_system_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_APP_SYSTEM, GalaAppSystem);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->id_to_app);
	self->priv->id_to_app = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->startup_wm_class_to_id);
	self->priv->startup_wm_class_to_id = _tmp5_;
	_tmp6_ = g_hash_table_new_full (NULL, NULL, _g_object_unref0_, NULL);
	_g_hash_table_unref0 (self->priv->running_apps);
	self->priv->running_apps = _tmp6_;
	_tmp7_ = gala_app_cache_new ();
	_g_object_unref0 (self->priv->app_cache);
	self->priv->app_cache = _tmp7_;
	return obj;
}

static void
gala_app_system_class_init (GalaAppSystemClass * klass,
                            gpointer klass_data)
{
	gala_app_system_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaAppSystem_private_offset);
	G_OBJECT_CLASS (klass)->constructor = gala_app_system_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_app_system_finalize;
}

static void
gala_app_system_instance_init (GalaAppSystem * self,
                               gpointer klass)
{
	self->priv = gala_app_system_get_instance_private (self);
}

static void
gala_app_system_finalize (GObject * obj)
{
	GalaAppSystem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_APP_SYSTEM, GalaAppSystem);
	_g_hash_table_unref0 (self->priv->running_apps);
	_g_hash_table_unref0 (self->priv->id_to_app);
	_g_hash_table_unref0 (self->priv->startup_wm_class_to_id);
	_g_object_unref0 (self->priv->app_cache);
	G_OBJECT_CLASS (gala_app_system_parent_class)->finalize (obj);
}

static GType
gala_app_system_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaAppSystemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_app_system_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaAppSystem), 0, (GInstanceInitFunc) gala_app_system_instance_init, NULL };
	GType gala_app_system_type_id;
	gala_app_system_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaAppSystem", &g_define_type_info, 0);
	GalaAppSystem_private_offset = g_type_add_instance_private (gala_app_system_type_id, sizeof (GalaAppSystemPrivate));
	return gala_app_system_type_id;
}

GType
gala_app_system_get_type (void)
{
	static volatile gsize gala_app_system_type_id__once = 0;
	if (g_once_init_enter (&gala_app_system_type_id__once)) {
		GType gala_app_system_type_id;
		gala_app_system_type_id = gala_app_system_get_type_once ();
		g_once_init_leave (&gala_app_system_type_id__once, gala_app_system_type_id);
	}
	return gala_app_system_type_id__once;
}

