/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;

public class Speed {
    private double _value = 0.0;
    private Unit _unit = null;
    private boolean _valid = false;

    public Speed(double d, Unit unit) {
        this._value = d;
        this._unit = unit;
        this._valid = Speed.isValidUnit(unit);
    }

    public Speed(String string, Unit unit) {
        try {
            this._value = Double.parseDouble(string);
            this._unit = unit;
            this._valid = Speed.isValidUnit(unit);
        }
        catch (Exception exception) {
            this._valid = false;
        }
    }

    private static boolean isValidUnit(Unit unit) {
        return unit != null && (unit == UnitSetLibrary.SPEED_UNITS_METRESPERSEC || unit == UnitSetLibrary.SPEED_UNITS_KMPERHOUR || unit == UnitSetLibrary.SPEED_UNITS_FEETPERSEC || unit == UnitSetLibrary.SPEED_UNITS_MILESPERHOUR || unit == UnitSetLibrary.SPEED_UNITS_KNOTS);
    }

    public void invert() {
        if (this._valid) {
            this._value = -this._value;
        }
    }

    public double getValue() {
        return this._value;
    }

    public Unit getUnit() {
        return this._unit;
    }

    public double getValueInMetresPerSec() {
        if (!this._valid) {
            return 0.0;
        }
        return this._value / this._unit.getMultFactorFromStd();
    }

    public double getValue(Unit unit) {
        if (!this._valid || !Speed.isValidUnit(unit)) {
            return 0.0;
        }
        return this.getValueInMetresPerSec() * unit.getMultFactorFromStd();
    }

    public boolean isValid() {
        return this._valid;
    }

    public void copyFrom(Speed speed) {
        this._value = speed._value;
        this._unit = speed._unit;
        this._valid = speed._valid;
    }
}

