/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.data.Photo;
import tim.prune.undo.UndoConnectMedia;

public class ConnectToPointFunction
extends GenericFunction {
    public ConnectToPointFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.connecttopoint";
    }

    @Override
    public void begin() {
        Photo photo = this._app.getTrackInfo().getCurrentPhoto();
        DataPoint dataPoint = this._app.getTrackInfo().getCurrentPoint();
        AudioClip audioClip = this._app.getTrackInfo().getCurrentAudio();
        boolean bl = dataPoint != null && photo != null && dataPoint.getPhoto() == null;
        boolean bl2 = dataPoint != null && audioClip != null && dataPoint.getAudio() == null;
        UndoConnectMedia undoConnectMedia = new UndoConnectMedia(dataPoint, bl ? photo.getName() : null, bl2 ? audioClip.getName() : null);
        if (bl) {
            photo.setDataPoint(dataPoint);
            dataPoint.setPhoto(photo);
        }
        if (bl2) {
            audioClip.setDataPoint(dataPoint);
            dataPoint.setAudio(audioClip);
        }
        UpdateMessageBroker.informSubscribers((byte)4);
        this._app.completeFunction(undoConnectMedia, I18nManager.getText("confirm.media.connect"));
    }
}

