/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.function.settings.WaypointTypeList;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.colour.WaypointColours;
import tim.prune.gui.map.WpIconLibrary;

public class SetWaypointSettings
extends GenericFunction {
    private JDialog _dialog = null;
    private JComboBox<Integer> _wpIconCombobox = null;
    private JRadioButton[] _sizeRadioButtons = null;
    private JCheckBox _coloursCheckbox = null;
    private JSlider _saltSlider = null;
    private JLabel _saltLabel = null;
    private JLabel _noTypesLabel = null;
    private final WaypointTypeList _typeList = new WaypointTypeList();
    private JList<String> _typeListBox = null;

    public SetWaypointSettings(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.setwaypointdisplay";
    }

    private Component makeContents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        jPanel3.setAlignmentX(0.0f);
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel4);
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.displaysettings.waypointicons"));
        jLabel.setAlignmentX(0.0f);
        guiGridLayout.add(jLabel);
        this._wpIconCombobox = new JComboBox<Integer>(new Integer[]{0, 1, 2, 3, 4});
        this._wpIconCombobox.setRenderer(new IconComboRenderer());
        guiGridLayout.add(this._wpIconCombobox);
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1));
        this._sizeRadioButtons = new JRadioButton[3];
        ButtonGroup buttonGroup = new ButtonGroup();
        String[] stringArray = new String[]{"small", "medium", "large"};
        int n = 0;
        while (n < 3) {
            this._sizeRadioButtons[n] = new JRadioButton(I18nManager.getText("dialog.displaysettings.size." + stringArray[n]));
            buttonGroup.add(this._sizeRadioButtons[n]);
            jPanel5.add(this._sizeRadioButtons[n]);
            ++n;
        }
        jPanel3.add(jPanel5);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createVerticalStrut(15));
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        jPanel6.setAlignmentX(0.0f);
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        this._coloursCheckbox = new JCheckBox(I18nManager.getText("dialog.waypointsettings.usecolours"));
        jPanel6.add(this._coloursCheckbox);
        jPanel6.add(Box.createVerticalStrut(10));
        this._saltSlider = new JSlider(0, WaypointColours.getMaxSalt());
        jPanel6.add(this._saltSlider);
        this._saltLabel = new JLabel("some label");
        jPanel6.add(this._saltLabel);
        this._noTypesLabel = new JLabel(I18nManager.getText("dialog.waypointsettings.notypesintrack"));
        jPanel6.add(this._noTypesLabel);
        this._typeListBox = new JList<String>(this._typeList);
        this._typeListBox.setVisibleRowCount(4);
        this._typeListBox.setLayoutOrientation(2);
        this._typeListBox.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent(jList, object, n, bl, bl2);
                this.setText(object.toString());
                this.setHorizontalTextPosition(2);
                this.setIconTextGap(7);
                this.setIcon(SetWaypointSettings.this.makeImageIcon(object.toString(), SetWaypointSettings.this._saltSlider.getValue()));
                return this;
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this._typeListBox);
        jPanel6.add(jScrollPane);
        jPanel2.add(jPanel6);
        this._saltSlider.addChangeListener(changeEvent -> this.showPreview(this._saltSlider.getValue()));
        this._coloursCheckbox.addChangeListener(changeEvent -> this.coloursSwitched());
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        jButton.addActionListener(actionEvent -> this.finish());
        jPanel7.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel7.add(jButton2);
        jPanel.add((Component)jPanel7, "South");
        return jPanel;
    }

    private void coloursSwitched() {
        boolean bl = this._coloursCheckbox.isSelected();
        this.showPreview(bl ? Math.max(this._saltSlider.getValue(), 0) : -1);
        this._saltSlider.setEnabled(bl);
        this._typeListBox.setEnabled(bl);
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog((Frame)this._parentFrame, I18nManager.getText(this.getNameKey()));
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeContents());
            this._dialog.pack();
        }
        this._wpIconCombobox.setSelectedIndex(Config.getConfigInt("prune.waypointicons"));
        this.selectIconSizeRadio(Config.getConfigInt("prune.waypointiconsize"));
        int n = Config.getConfigInt("prune.waypointsalt");
        this._coloursCheckbox.setSelected(n >= 0);
        this._saltSlider.setValue(Math.max(n, 0));
        this._saltSlider.setEnabled(n >= 0);
        this._typeList.compile(this._app.getTrackInfo().getTrack());
        this.showPreview(n);
        this._dialog.setVisible(true);
    }

    private void showPreview(int n) {
        String string = n < 0 ? "" : String.valueOf(I18nManager.getText("dialog.waypointsettings.saltvalue")) + " : " + n;
        this._saltLabel.setText(string);
        this._noTypesLabel.setVisible(this._typeList.getSize() == 0);
        this._typeListBox.repaint();
    }

    private void selectIconSizeRadio(int n) {
        if (n < 0 || n >= this._sizeRadioButtons.length) {
            n = 1;
        }
        if (this._sizeRadioButtons[n] != null) {
            this._sizeRadioButtons[n].setSelected(true);
        }
    }

    private int getSelectedIconSize() {
        int n = 0;
        while (n < this._sizeRadioButtons.length) {
            if (this._sizeRadioButtons[n] != null && this._sizeRadioButtons[n].isSelected()) {
                return n;
            }
            ++n;
        }
        return 1;
    }

    private Icon makeImageIcon(String string, int n) {
        Color color = WaypointColours.getColourForType(string, n);
        if (color == null) {
            return null;
        }
        int n2 = color.getRGB();
        BufferedImage bufferedImage = new BufferedImage(20, 20, 1);
        int n3 = 1;
        while (n3 < 19) {
            bufferedImage.setRGB(n3, 0, 0);
            bufferedImage.setRGB(0, n3, 0);
            int n4 = 1;
            while (n4 < 19) {
                bufferedImage.setRGB(n3, n4, n2);
                ++n4;
            }
            bufferedImage.setRGB(n3, 19, 0);
            bufferedImage.setRGB(19, n3, 0);
            ++n3;
        }
        return new ImageIcon(bufferedImage);
    }

    public void finish() {
        Config.setConfigInt("prune.waypointicons", this._wpIconCombobox.getSelectedIndex());
        Config.setConfigInt("prune.waypointiconsize", this.getSelectedIconSize());
        int n = this._coloursCheckbox.isSelected() ? this._saltSlider.getValue() : -1;
        Config.setConfigInt("prune.waypointsalt", n);
        UpdateMessageBroker.informSubscribers((byte)64);
        this._dialog.dispose();
    }

    static class IconComboRenderer
    extends JLabel
    implements ListCellRenderer<Integer> {
        private final ImageIcon[] _icons = new ImageIcon[5];

        IconComboRenderer() {
            this.setOpaque(true);
        }

        private String getLabel(int n) {
            return I18nManager.getText("dialog.displaysettings.wpicon." + WpIconLibrary.getIconName(n));
        }

        private ImageIcon getIcon(int n) {
            if (this._icons[n] == null) {
                this._icons[n] = WpIconLibrary.getIconDefinition(n, 1).getImageIcon();
            }
            return this._icons[n];
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Integer> jList, Integer n, int n2, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setIcon(this.getIcon(n));
            this.setText(this.getLabel(n));
            return this;
        }
    }
}

