/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.tools.Logging;

public class DatasetEventManager
implements MainLayerManager.ActiveLayerChangeListener,
DataSetListenerAdapter.Listener {
    private static final DatasetEventManager INSTANCE = new DatasetEventManager();
    private final Queue<AbstractDatasetChangedEvent> eventsInEDT = new LinkedBlockingQueue<AbstractDatasetChangedEvent>();
    private final CopyOnWriteArrayList<ListenerInfo> inEDTListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerInfo> normalListeners = new CopyOnWriteArrayList();
    private final DataSetListener myListener = new DataSetListenerAdapter(this);
    private final Runnable edtRunnable = new EdtRunnable();

    public static DatasetEventManager getInstance() {
        return INSTANCE;
    }

    public DatasetEventManager() {
        MainApplication.getLayerManager().addActiveLayerChangeListener(this);
    }

    public void addDatasetListener(DataSetListener listener, FireMode fireMode) {
        if (fireMode == FireMode.IN_EDT || fireMode == FireMode.IN_EDT_CONSOLIDATED) {
            this.inEDTListeners.addIfAbsent(new ListenerInfo(listener, fireMode == FireMode.IN_EDT_CONSOLIDATED));
        } else {
            this.normalListeners.addIfAbsent(new ListenerInfo(listener, false));
        }
    }

    public void removeDatasetListener(DataSetListener listener) {
        ListenerInfo searchListener = new ListenerInfo(listener, false);
        this.inEDTListeners.remove(searchListener);
        this.normalListeners.remove(searchListener);
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        DataSet newData;
        DataSet oldData = e.getPreviousDataSet();
        if (oldData != null) {
            oldData.removeDataSetListener(this.myListener);
        }
        if ((newData = e.getSource().getActiveDataSet()) != null) {
            newData.addDataSetListener(this.myListener);
        }
        this.processDatasetEvent(new DataChangedEvent(newData));
    }

    private static void fireEvents(List<ListenerInfo> listeners, AbstractDatasetChangedEvent event) {
        for (ListenerInfo listener : listeners) {
            if (listener.consolidate) continue;
            Logging.trace("Firing {0} to {1} (normal)", event, listener.listener);
            event.fire(listener.listener);
        }
    }

    private static void fireConsolidatedEvents(List<ListenerInfo> listeners, AbstractDatasetChangedEvent event) {
        for (ListenerInfo listener : listeners) {
            if (!listener.consolidate) continue;
            Logging.trace("Firing {0} to {1} (consolidated)", event, listener.listener);
            event.fire(listener.listener);
        }
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        DatasetEventManager.fireEvents(this.normalListeners, event);
        this.eventsInEDT.add(event);
        SwingUtilities.invokeLater(this.edtRunnable);
    }

    private static class ListenerInfo {
        private final DataSetListener listener;
        private final boolean consolidate;

        ListenerInfo(DataSetListener listener, boolean consolidate) {
            this.listener = listener;
            this.consolidate = consolidate;
        }

        public int hashCode() {
            return Objects.hash(this.listener);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListenerInfo that = (ListenerInfo)o;
            return Objects.equals(this.listener, that.listener);
        }
    }

    public static enum FireMode {
        IMMEDIATELY,
        IN_EDT,
        IN_EDT_CONSOLIDATED;

    }

    private final class EdtRunnable
    implements Runnable {
        private EdtRunnable() {
        }

        @Override
        public void run() {
            while (!DatasetEventManager.this.eventsInEDT.isEmpty()) {
                AbstractDatasetChangedEvent event;
                DataSet dataSet = null;
                AbstractDatasetChangedEvent consolidatedEvent = null;
                while ((event = (AbstractDatasetChangedEvent)DatasetEventManager.this.eventsInEDT.poll()) != null) {
                    DatasetEventManager.fireEvents(DatasetEventManager.this.inEDTListeners, event);
                    if (consolidatedEvent != null && dataSet != event.getDataset()) {
                        DatasetEventManager.fireConsolidatedEvents(DatasetEventManager.this.inEDTListeners, consolidatedEvent);
                        consolidatedEvent = null;
                    }
                    dataSet = event.getDataset();
                    if (event instanceof DataChangedEvent) {
                        DataChangedEvent dataEvent = (DataChangedEvent)event;
                        if (dataEvent.getEvents() == null) {
                            consolidatedEvent = dataEvent;
                            continue;
                        }
                        if (consolidatedEvent == null) {
                            consolidatedEvent = new DataChangedEvent(dataSet, dataEvent.getEvents());
                            continue;
                        }
                        if (consolidatedEvent instanceof DataChangedEvent) {
                            List<AbstractDatasetChangedEvent> evts = ((DataChangedEvent)consolidatedEvent).getEvents();
                            if (evts == null) continue;
                            evts.addAll(dataEvent.getEvents());
                            continue;
                        }
                        AbstractDatasetChangedEvent oldConsolidateEvent = consolidatedEvent;
                        consolidatedEvent = new DataChangedEvent(dataSet, dataEvent.getEvents());
                        ((DataChangedEvent)consolidatedEvent).getEvents().add(oldConsolidateEvent);
                        continue;
                    }
                    if (consolidatedEvent == null) {
                        consolidatedEvent = event;
                        continue;
                    }
                    if (consolidatedEvent instanceof DataChangedEvent) {
                        List<AbstractDatasetChangedEvent> evs = ((DataChangedEvent)consolidatedEvent).getEvents();
                        if (evs == null) continue;
                        evs.add(event);
                        continue;
                    }
                    consolidatedEvent = new DataChangedEvent(dataSet, new ArrayList<AbstractDatasetChangedEvent>(Arrays.asList(consolidatedEvent)));
                }
                if (consolidatedEvent == null) continue;
                DatasetEventManager.fireConsolidatedEvents(DatasetEventManager.this.inEDTListeners, consolidatedEvent);
            }
        }
    }
}

