/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.net.Authenticator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.data.UserIdentityManager;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmServerUserInfoReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.JosmPreferencesCredentialAgent;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class MessageNotifier {
    private static volatile NotifierCallback callback;
    public static final BooleanProperty PROP_NOTIFIER_ENABLED;
    public static final IntegerProperty PROP_INTERVAL;
    private static final ScheduledExecutorService EXECUTOR;
    private static final Runnable WORKER;
    private static volatile ScheduledFuture<?> task;

    private MessageNotifier() {
    }

    public static void setNotifierCallback(NotifierCallback notifierCallback) {
        callback = notifierCallback;
    }

    public static void start() {
        int interval = PROP_INTERVAL.get();
        if (NetworkManager.isOffline(OnlineResource.OSM_API)) {
            Logging.info(OfflineAccessException.forResource(I18n.tr("Message notifier", new Object[0])).getMessage());
        } else if (!MessageNotifier.isRunning() && interval > 0 && MessageNotifier.isUserEnoughIdentified()) {
            task = EXECUTOR.scheduleAtFixedRate(WORKER, 0L, interval, TimeUnit.MINUTES);
            Logging.info("Message notifier active (checks every " + interval + " minute" + (interval > 1 ? "s" : "") + ')');
        }
    }

    public static void stop() {
        if (MessageNotifier.isRunning()) {
            task.cancel(false);
            Logging.info("Message notifier inactive");
            task = null;
        }
    }

    public static boolean isRunning() {
        return task != null;
    }

    public static boolean isUserEnoughIdentified() {
        UserIdentityManager identManager = UserIdentityManager.getInstance();
        if (identManager.isFullyIdentified()) {
            return true;
        }
        CredentialsManager credManager = CredentialsManager.getInstance();
        try {
            if (JosmPreferencesCredentialAgent.class.equals(credManager.getCredentialsAgentClass())) {
                if (OsmApi.isUsingOAuth()) {
                    return credManager.lookupOAuthAccessToken() != null;
                }
                String username = Config.getPref().get("osm-server.username", null);
                String password = Config.getPref().get("osm-server.password", null);
                return !Utils.isEmpty(username) && !Utils.isEmpty(password);
            }
            CredentialsAgentResponse credentials = credManager.getCredentials(Authenticator.RequestorType.SERVER, OsmApi.getOsmApi().getHost(), false);
            if (credentials != null) {
                String username = credentials.getUsername();
                char[] password = credentials.getPassword();
                return !Utils.isEmpty(username) && password != null && password.length > 0;
            }
        }
        catch (CredentialsAgentException e) {
            Logging.log(Logging.LEVEL_WARN, "Unable to get credentials:", e);
        }
        return false;
    }

    static {
        PROP_NOTIFIER_ENABLED = new BooleanProperty("message.notifier.enabled", true);
        PROP_INTERVAL = new IntegerProperty("message.notifier.interval", 5);
        EXECUTOR = Executors.newSingleThreadScheduledExecutor(Utils.newThreadFactory("message-notifier-%d", 5));
        WORKER = new Worker();
    }

    private static class Worker
    implements Runnable {
        private int lastUnreadCount;
        private long lastTimeInMillis;

        private Worker() {
        }

        @Override
        public void run() {
            try {
                long currentTime = System.currentTimeMillis();
                if (currentTime >= this.lastTimeInMillis + TimeUnit.MINUTES.toMillis(PROP_INTERVAL.get().intValue())) {
                    this.lastTimeInMillis = currentTime;
                    UserInfo userInfo = new OsmServerUserInfoReader().fetchUserInfo(NullProgressMonitor.INSTANCE, I18n.tr("get number of unread messages", new Object[0]));
                    int unread = userInfo.getUnreadMessages();
                    if (unread > 0 && unread != this.lastUnreadCount) {
                        callback.notifyNewMessages(userInfo);
                        this.lastUnreadCount = unread;
                    }
                }
            }
            catch (OsmApiException e) {
                ExceptionDialogUtil.explainOsmTransferException(e);
            }
            catch (OsmTransferException e) {
                Logging.warn(e);
            }
        }
    }

    @FunctionalInterface
    public static interface NotifierCallback {
        public void notifyNewMessages(UserInfo var1);
    }
}

