/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.common.IRubyWarnings;
import org.jruby.ext.ripper.HeredocTerm;
import org.jruby.ext.ripper.RipperParserBase;
import org.jruby.ext.ripper.StrTerm;
import org.jruby.ext.ripper.StringTerm;
import org.jruby.lexer.LexerSource;
import org.jruby.lexer.LexingCommon;
import org.jruby.parser.RubyParserBase;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;
import org.jruby.util.SafeDoubleParser;
import org.jruby.util.StringSupport;
import org.jruby.util.cli.Options;

public class RubyLexer
extends LexingCommon {
    private static final HashMap<String, Keyword> map = new HashMap();
    String identValue;
    private RipperParserBase parser = null;
    private StrTerm lex_strterm;
    static final int STR_FUNC_INDENT = 32;
    protected ByteList delayed = null;
    private int delayed_line = 0;
    private int delayed_col = 0;
    private boolean cr_seen = false;
    private ByteList id = null;
    private ByteList numberBuffer = new ByteList(10);

    @Override
    protected void ambiguousOperator(String op, String syn) {
        this.parser.dispatch("on_operator_ambiguous", this.getRuntime().newSymbol(op), this.getRuntime().newString(syn));
    }

    @Override
    protected boolean onMagicComment(String name2, ByteList value2) {
        boolean found = super.onMagicComment(name2, value2);
        this.parser.dispatch("on_magic_comment", this.getRuntime().newString(name2), this.getRuntime().newString(value2));
        return found;
    }

    private int getFloatToken(String number, int suffix) {
        if ((suffix & 1) != 0) {
            BigDecimal bd = new BigDecimal(number);
            BigDecimal denominator2 = BigDecimal.ONE.scaleByPowerOfTen(bd.scale());
            BigDecimal numerator2 = bd.multiply(denominator2);
            try {
                numerator2.longValueExact();
                denominator2.longValueExact();
            }
            catch (ArithmeticException ae) {
                this.compile_error("Rational (" + numerator2 + "/" + denominator2 + ") out of range.");
            }
            return this.considerComplex(315, suffix);
        }
        try {
            double d = SafeDoubleParser.parseDouble(number);
        }
        catch (NumberFormatException e) {
            this.warn("Float " + number + " out of range.");
            double d = number.startsWith("-") ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        return this.considerComplex(314, suffix);
    }

    private int considerComplex(int token2, int suffix) {
        if ((suffix & 2) == 0) {
            return token2;
        }
        return 316;
    }

    protected int src_line() {
        return this.getRubySourceline();
    }

    public boolean isVerbose() {
        return this.parser.getRuntime().isVerbose();
    }

    public void warn(String message2) {
        this.parser.dispatch("warn", this.getRuntime().newString(message2));
    }

    public void warning(String fmt) {
        this.parser.dispatch("warning", this.getRuntime().newString(fmt));
    }

    public void warning(String fmt, String arg2) {
        this.parser.dispatch("warning", this.getRuntime().newString(fmt), this.getRuntime().newString(arg2));
    }

    public static Keyword getKeyword(String str) {
        return map.get(str);
    }

    public RubyLexer(RipperParserBase parser, LexerSource src) {
        this(parser, src, null);
    }

    public RubyLexer(RipperParserBase parser, LexerSource src, IRubyWarnings _warnings) {
        super(src);
        this.parser = parser;
        this.setState(0);
        this.lex_strterm = null;
        this.setCurrentEncoding(src.getEncoding());
        this.reset();
    }

    public boolean hasStarted() {
        return this.src != null;
    }

    protected void flush_string_content(Encoding encoding2) {
        if (this.delayed != null) {
            int len = this.lex_p - this.tokp;
            if (len > 0) {
                this.delayed.setEncoding(encoding2);
                this.delayed.append(this.lexb.makeShared(this.tokp, len));
            }
            this.dispatchDelayedToken(320);
            this.tokp = this.lex_p;
        }
    }

    public void addDelayedToken(int tok, int end2) {
        if (tok < end2) {
            if (this.delayed == null) {
                this.delayed = new ByteList();
                this.delayed.setEncoding(this.getEncoding());
                this.delayed_line = this.ruby_sourceline;
                this.delayed_col = tok - this.lex_pbeg;
            }
            this.delayed.append(this.lexb, tok, end2 - tok);
            this.tokp = end2;
        }
    }

    private boolean nextLine() {
        this.line_offset += this.lex_pend;
        ByteList v = this.lex_nextline;
        this.lex_nextline = null;
        if (v == null) {
            if (this.eofp) {
                return true;
            }
            if (this.src == null || (v = this.src.gets()) == null) {
                this.eofp = true;
                this.lex_goto_eol();
                return true;
            }
            this.cr_seen = false;
        }
        this.addDelayedToken(this.tokp, this.lex_pend);
        if (this.heredoc_end > 0) {
            this.ruby_sourceline = this.heredoc_end;
            this.heredoc_end = 0;
        }
        ++this.ruby_sourceline;
        ++this.line_count;
        this.lex_p = 0;
        this.lex_pbeg = 0;
        this.lex_pend = this.lex_p + v.length();
        this.lexb = v;
        this.flush();
        this.lex_lastline = v;
        return false;
    }

    private int cr(int c) {
        if (this.peek(10)) {
            ++this.lex_p;
            c = 10;
        } else if (!this.cr_seen) {
            this.cr_seen = true;
            this.warn("encountered \\\\r in middle of line, treated as a mere space");
        }
        return c;
    }

    @Override
    public int nextc() {
        if ((this.lex_p == this.lex_pend || this.eofp || this.lex_nextline != null) && this.nextLine()) {
            return -1;
        }
        int c = this.p(this.lex_p);
        ++this.lex_p;
        if (c == 13) {
            c = this.cr(c);
        }
        return c;
    }

    public void dispatchHeredocEnd() {
        if (this.delayed != null) {
            this.dispatchDelayedToken(320);
        }
        this.lex_goto_eol();
        this.dispatchIgnoredScanEvent(379);
    }

    @Override
    public void compile_error(String message2) {
        this.parser.error();
        this.parser.dispatch("compile_error", this.getRuntime().newString(message2));
    }

    @Override
    public void parse_error(String message2) {
        this.parser.error();
        this.parser.dispatch("on_parse_error", this.getRuntime().newString(message2));
    }

    @Override
    protected void set_yylval_id(ByteList id2) {
        this.id = id2;
    }

    @Override
    public ByteList id() {
        return this.id;
    }

    protected void set_yylval_noname() {
        this.id = null;
    }

    @Override
    protected void set_yylval_name(ByteList name2) {
        this.id = name2;
    }

    protected void set_yylval_val(ByteList name2) {
        this.id = name2;
    }

    @Override
    public int tokenize_ident(int result2) {
        String value2 = this.createTokenString();
        if (!RubyLexer.isLexState(this.last_state, 384) && this.parser.getCurrentScope().isDefined(value2) >= 0) {
            this.setState(2);
        }
        this.identValue = value2.intern();
        this.set_yylval_name(this.createTokenByteList());
        return result2;
    }

    public void heredoc_restore(HeredocTerm here) {
        ByteList line;
        this.lex_lastline = line = here.lastLine;
        this.lex_pbeg = 0;
        this.lex_pend = this.lex_pbeg + line.length();
        this.lex_p = this.lex_pbeg + here.nth;
        this.lexb = line;
        this.heredoc_end = this.ruby_sourceline;
        this.ruby_sourceline = here.line;
        this.flush();
    }

    public int nextToken() throws IOException {
        this.token = this.yylex();
        this.updateTokenPosition();
        if (this.delayed != null) {
            this.dispatchDelayedToken(this.token);
            return this.token == -1 ? 0 : this.token;
        }
        if (this.token != -1) {
            this.dispatchScanEvent(this.token);
        }
        return this.token == -1 ? 0 : this.token;
    }

    public String getIdent() {
        return this.identValue;
    }

    public Ruby getRuntime() {
        return this.parser.context.getRuntime();
    }

    public void setParser(RipperParserBase parserSupport) {
        this.parser = parserSupport;
    }

    @Override
    protected void setCompileOptionFlag(String name2, ByteList value2) {
        if (this.tokenSeen) {
            this.warning("`%s' is ignored after any tokens", name2);
            return;
        }
    }

    @Override
    protected RegexpOptions parseRegexpFlags() throws IOException {
        StringBuilder unknownFlags = new StringBuilder(10);
        RegexpOptions options2 = this.parseRegexpFlags(unknownFlags);
        if (unknownFlags.length() != 0) {
            this.compile_error("unknown regexp option" + (unknownFlags.length() > 1 ? "s" : "") + " - " + unknownFlags);
        }
        return options2;
    }

    @Override
    protected void mismatchedRegexpEncodingError(Encoding optionEncoding, Encoding encoding2) {
        this.compile_error("regexp encoding option '" + this.optionsEncodingChar(optionEncoding) + "' differs from source encoding '" + encoding2 + "'");
    }

    @Override
    protected void setTokenInfo(String name2, ByteList value2) {
    }

    @Override
    protected void setEncoding(ByteList name2) {
        Encoding newEncoding = this.parser.getRuntime().getEncodingService().loadEncoding(name2);
        if (newEncoding == null) {
            this.compile_error("unknown encoding name: " + name2.toString());
            return;
        }
        if (!newEncoding.isAsciiCompatible()) {
            this.compile_error(name2.toString() + " is not ASCII compatible");
            return;
        }
        this.setEncoding(newEncoding);
    }

    public StrTerm getStrTerm() {
        return this.lex_strterm;
    }

    public void setStrTerm(StrTerm strterm) {
        this.lex_strterm = strterm;
    }

    public IRubyObject createStr(ByteList buffer, int flags2) {
        Encoding bufferEncoding = buffer.getEncoding();
        int codeRange = StringSupport.codeRangeScan(bufferEncoding, buffer);
        if ((flags2 & 4) == 0 && bufferEncoding.isAsciiCompatible() && codeRange != 16 && this.getEncoding() == USASCII_ENCODING && bufferEncoding != UTF8_ENCODING) {
            codeRange = RubyParserBase.associateEncoding(buffer, ASCII8BIT_ENCODING, codeRange);
        }
        RubyString newString = this.getRuntime().newString(buffer);
        newString.setCodeRange(codeRange);
        return newString;
    }

    private int parseQuote(int c) {
        int end2;
        boolean shortHand;
        int begin2;
        if (c == -1) {
            this.compile_error("unterminated quoted string meets end of file");
            return -1;
        }
        if (!Character.isLetterOrDigit(c)) {
            begin2 = c;
            c = 81;
            shortHand = true;
        } else {
            shortHand = false;
            begin2 = this.nextc();
            if (Character.isLetterOrDigit(begin2) || !this.isASCII()) {
                this.compile_error("unknown type of %string");
                return -1;
            }
        }
        if (c == -1 || begin2 == -1) {
            this.compile_error("unterminated quoted string meets end of file");
            return -1;
        }
        switch (begin2) {
            case 40: {
                end2 = 41;
                break;
            }
            case 91: {
                end2 = 93;
                break;
            }
            case 123: {
                end2 = 125;
                break;
            }
            case 60: {
                end2 = 62;
                break;
            }
            default: {
                end2 = begin2;
                begin2 = 0;
            }
        }
        switch (c) {
            case 81: {
                this.lex_strterm = new StringTerm(2, begin2, end2, this.ruby_sourceline);
                this.yaccValue = "%" + (shortHand ? "" + end2 : "" + c + begin2);
                return 360;
            }
            case 113: {
                this.lex_strterm = new StringTerm(0, begin2, end2, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin2;
                return 360;
            }
            case 87: {
                this.lex_strterm = new StringTerm(16394, begin2, end2, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin2;
                return 363;
            }
            case 119: {
                this.lex_strterm = new StringTerm(16392, begin2, end2, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin2;
                return 364;
            }
            case 120: {
                this.lex_strterm = new StringTerm(2, begin2, end2, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin2;
                return 361;
            }
            case 114: {
                this.lex_strterm = new StringTerm(7, begin2, end2, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin2;
                return 362;
            }
            case 115: {
                this.lex_strterm = new StringTerm(16, begin2, end2, this.ruby_sourceline);
                this.setState(4224);
                this.yaccValue = "%" + c + begin2;
                return 359;
            }
            case 73: {
                this.lex_strterm = new StringTerm(16394, begin2, end2, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin2;
                return 366;
            }
            case 105: {
                this.lex_strterm = new StringTerm(16392, begin2, end2, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin2;
                return 367;
            }
        }
        this.compile_error("unknown type of %string");
        return -1;
    }

    private int hereDocumentIdentifier() {
        int c = this.nextc();
        int indent = 0;
        int func = 0;
        if (c == 45) {
            c = this.nextc();
            func = 32;
        } else if (c == 126) {
            c = this.nextc();
            func = 32;
            indent = Integer.MAX_VALUE;
        }
        int token2 = 360;
        ByteList markerValue = new ByteList();
        markerValue.setEncoding(this.getEncoding());
        if (c == 39 || c == 34 || c == 96) {
            if (c == 39) {
                this.yaccValue = Q;
                func |= 0;
            } else if (c == 34) {
                this.yaccValue = QQ;
                func |= 2;
            } else {
                this.yaccValue = BACKTICK;
                token2 = 361;
                func |= 2;
            }
            int term = c;
            while ((c = this.nextc()) != term) {
                if (c == -1 || c == 13 || c == 10) {
                    this.parse_error("unterminated here document identifier");
                    return -1;
                }
                this.tokadd_mbchar(c, markerValue);
            }
            this.pushback(term);
            this.nextc();
        } else {
            if (!RubyLexer.isIdentifierChar(c)) {
                this.pushback(c);
                if ((func & 0x20) != 0) {
                    this.pushback(this.heredoc_indent > 0 ? 126 : 45);
                }
                return 0;
            }
            func |= 2;
            do {
                if (this.tokadd_mbchar(c, markerValue)) continue;
                return -1;
            } while ((c = this.nextc()) != -1 && RubyLexer.isIdentifierChar(c));
            this.pushback(c);
        }
        this.dispatchScanEvent(378);
        int len = this.lex_p - this.lex_pbeg;
        this.lex_goto_eol();
        this.lex_strterm = new HeredocTerm(markerValue, func, len, this.ruby_sourceline, this.lex_lastline);
        this.heredoc_indent = indent;
        this.heredoc_line_indent = 0;
        this.flush();
        return token2;
    }

    public ByteList tokenByteList() {
        int pos2 = this.tokp - this.lex_pbeg;
        int len = this.lex_p - this.tokp;
        return this.lexb.makeShared(pos2, len);
    }

    private boolean arg_ambiguous() {
        this.parser.dispatch("on_arg_ambiguous");
        return true;
    }

    private void printToken(int token2) {
        switch (token2) {
            case 256: {
                System.err.print("yyErrorCode,");
                break;
            }
            case 306: {
                System.err.print("tIDENTIFIER[" + this.value() + "],");
                break;
            }
            case 307: {
                System.err.print("tFID[" + this.value() + "],");
                break;
            }
            case 308: {
                System.err.print("tGVAR[" + this.value() + "],");
                break;
            }
            case 309: {
                System.err.print("tIVAR[" + this.value() + "],");
                break;
            }
            case 310: {
                System.err.print("tCONSTANT[" + this.value() + "],");
                break;
            }
            case 311: {
                System.err.print("tCVAR,");
                break;
            }
            case 313: {
                System.err.print("tINTEGER,");
                break;
            }
            case 314: {
                System.err.print("tFLOAT,");
                break;
            }
            case 320: {
                System.err.print("tSTRING_CONTENT[" + this.value() + "],");
                break;
            }
            case 360: {
                System.err.print("tSTRING_BEG,");
                break;
            }
            case 365: {
                System.err.print("tSTRING_END,");
                break;
            }
            case 369: {
                System.err.print("tSTRING_DBEG,");
                break;
            }
            case 370: {
                System.err.print("tSTRING_DVAR,");
                break;
            }
            case 361: {
                System.err.print("tXSTRING_BEG,");
                break;
            }
            case 362: {
                System.err.print("tREGEXP_BEG,");
                break;
            }
            case 321: {
                System.err.print("tREGEXP_END,");
                break;
            }
            case 363: {
                System.err.print("tWORDS_BEG,");
                break;
            }
            case 364: {
                System.err.print("tQWORDS_BEG,");
                break;
            }
            case 319: {
                System.err.print("tBACK_REF,");
                break;
            }
            case 318: {
                System.err.print("tNTH_REF,");
                break;
            }
            case 324: {
                System.err.print("tUPLUS");
                break;
            }
            case 325: {
                System.err.print("tUMINUS,");
                break;
            }
            case 326: {
                System.err.print("tPOW,");
                break;
            }
            case 327: {
                System.err.print("tCMP,");
                break;
            }
            case 328: {
                System.err.print("tEQ,");
                break;
            }
            case 329: {
                System.err.print("tEQQ,");
                break;
            }
            case 330: {
                System.err.print("tNEQ,");
                break;
            }
            case 331: {
                System.err.print("tGEQ,");
                break;
            }
            case 332: {
                System.err.print("tLEQ,");
                break;
            }
            case 333: {
                System.err.print("tANDOP,");
                break;
            }
            case 334: {
                System.err.print("tOROP,");
                break;
            }
            case 335: {
                System.err.print("tMATCH,");
                break;
            }
            case 336: {
                System.err.print("tNMATCH,");
                break;
            }
            case 337: {
                System.err.print("tDOT2,");
                break;
            }
            case 338: {
                System.err.print("tDOT3,");
                break;
            }
            case 341: {
                System.err.print("tAREF,");
                break;
            }
            case 342: {
                System.err.print("tASET,");
                break;
            }
            case 343: {
                System.err.print("tLSHFT,");
                break;
            }
            case 344: {
                System.err.print("tRSHFT,");
                break;
            }
            case 346: {
                System.err.print("tCOLON2,");
                break;
            }
            case 347: {
                System.err.print("tCOLON3,");
                break;
            }
            case 348: {
                System.err.print("tOP_ASGN,");
                break;
            }
            case 349: {
                System.err.print("tASSOC,");
                break;
            }
            case 350: {
                System.err.print("tLPAREN,");
                break;
            }
            case 351: {
                System.err.print("tLPAREN_ARG,");
                break;
            }
            case 352: {
                System.err.print("tLBRACK,");
                break;
            }
            case 353: {
                System.err.print("tLBRACE,");
                break;
            }
            case 354: {
                System.err.print("tLBRACE_ARG,");
                break;
            }
            case 355: {
                System.err.print("tSTAR,");
                break;
            }
            case 357: {
                System.err.print("tAMPER,");
                break;
            }
            case 359: {
                System.err.print("tSYMBEG,");
                break;
            }
            case 358: {
                System.err.print("tLAMBDA,");
                break;
            }
            case 371: {
                System.err.print("tLAMBEG,");
                break;
            }
            case 312: {
                System.err.print("tLABEL(" + this.value() + ":),");
                break;
            }
            case 372: {
                System.err.print("tLABEL_END");
                break;
            }
            case 10: {
                System.err.println("NL");
                break;
            }
            case -1: {
                System.out.println("EOF");
                break;
            }
            case 356: {
                System.err.print("tDSTAR");
                break;
            }
            case 368: {
                System.err.print("tDSTRING_DEND,");
                break;
            }
            case 340: {
                System.err.print("tBDOT3,");
                break;
            }
            case 339: {
                System.err.print("tBDOT2,");
                break;
            }
            default: {
                System.err.print("'" + (char)token2 + "'[" + token2 + "]");
            }
        }
    }

    public boolean hasScanEvent() {
        if (this.lex_p < this.tokp) {
            throw this.parser.getRuntime().newRuntimeError("lex_p < tokp");
        }
        return this.lex_p > this.tokp;
    }

    public void dispatchDelayedToken(int token2) {
        int saved_line = this.ruby_sourceline;
        int saved_tokp = this.tokp;
        if (this.delayed == null) {
            return;
        }
        this.ruby_sourceline = this.delayed_line;
        this.tokp = this.lex_pbeg + this.delayed_col;
        String event2 = this.tokenToEventId(token2);
        IRubyObject value2 = this.delayed == null ? this.parser.context.nil : this.parser.getRuntime().newString(this.delayed.dup());
        this.yaccValue = this.parser.dispatch(event2, value2);
        this.delayed = null;
        this.ruby_sourceline = saved_line;
        this.tokp = saved_tokp;
    }

    public void dispatchIgnoredScanEvent(int token2) {
        if (!this.hasScanEvent()) {
            return;
        }
        this.scanEventValue(token2);
    }

    public void dispatchScanEvent(int token2) {
        if (!this.hasScanEvent()) {
            return;
        }
        this.yaccValue = this.scanEventValue(token2);
    }

    private IRubyObject scanEventValue(int token2) {
        RubyString value2 = this.parser.getRuntime().newString(this.lexb.makeShared(this.tokp, this.lex_p - this.tokp));
        String event2 = this.tokenToEventId(token2);
        this.identValue = value2.asJavaString();
        IRubyObject returnValue = this.parser.dispatch(event2, value2);
        this.flush();
        return returnValue;
    }

    private String tokenToEventId(int token2) {
        switch (token2) {
            case 32: {
                return "on_words_sep";
            }
            case 33: {
                return "on_op";
            }
            case 37: {
                return "on_op";
            }
            case 345: {
                return "on_op";
            }
            case 38: {
                return "on_op";
            }
            case 42: {
                return "on_op";
            }
            case 43: {
                return "on_op";
            }
            case 45: {
                return "on_op";
            }
            case 47: {
                return "on_op";
            }
            case 60: {
                return "on_op";
            }
            case 61: {
                return "on_op";
            }
            case 62: {
                return "on_op";
            }
            case 63: {
                return "on_op";
            }
            case 94: {
                return "on_op";
            }
            case 124: {
                return "on_op";
            }
            case 126: {
                return "on_op";
            }
            case 58: {
                return "on_op";
            }
            case 44: {
                return "on_comma";
            }
            case 46: {
                return "on_period";
            }
            case 59: {
                return "on_semicolon";
            }
            case 96: {
                return "on_backtick";
            }
            case 10: {
                return "on_nl";
            }
            case 299: {
                return "on_kw";
            }
            case 291: {
                return "on_kw";
            }
            case 261: {
                return "on_kw";
            }
            case 275: {
                return "on_kw";
            }
            case 270: {
                return "on_kw";
            }
            case 257: {
                return "on_kw";
            }
            case 259: {
                return "on_kw";
            }
            case 300: {
                return "on_kw";
            }
            case 280: {
                return "on_kw";
            }
            case 282: {
                return "on_kw";
            }
            case 281: {
                return "on_kw";
            }
            case 269: {
                return "on_kw";
            }
            case 268: {
                return "on_kw";
            }
            case 264: {
                return "on_kw";
            }
            case 263: {
                return "on_kw";
            }
            case 290: {
                return "on_kw";
            }
            case 274: {
                return "on_kw";
            }
            case 265: {
                return "on_kw";
            }
            case 294: {
                return "on_kw";
            }
            case 279: {
                return "on_kw";
            }
            case 258: {
                return "on_kw";
            }
            case 276: {
                return "on_kw";
            }
            case 288: {
                return "on_kw";
            }
            case 293: {
                return "on_kw";
            }
            case 292: {
                return "on_kw";
            }
            case 277: {
                return "on_kw";
            }
            case 262: {
                return "on_kw";
            }
            case 298: {
                return "on_kw";
            }
            case 278: {
                return "on_kw";
            }
            case 284: {
                return "on_kw";
            }
            case 287: {
                return "on_kw";
            }
            case 286: {
                return "on_kw";
            }
            case 267: {
                return "on_kw";
            }
            case 289: {
                return "on_kw";
            }
            case 260: {
                return "on_kw";
            }
            case 266: {
                return "on_kw";
            }
            case 295: {
                return "on_kw";
            }
            case 273: {
                return "on_kw";
            }
            case 297: {
                return "on_kw";
            }
            case 271: {
                return "on_kw";
            }
            case 272: {
                return "on_kw";
            }
            case 296: {
                return "on_kw";
            }
            case 285: {
                return "on_kw";
            }
            case 304: {
                return "on_kw";
            }
            case 303: {
                return "on_kw";
            }
            case 305: {
                return "on_kw";
            }
            case 301: {
                return "on_kw";
            }
            case 302: {
                return "on_kw";
            }
            case 283: {
                return "on_kw";
            }
            case 357: {
                return "on_op";
            }
            case 333: {
                return "on_op";
            }
            case 341: {
                return "on_op";
            }
            case 342: {
                return "on_op";
            }
            case 349: {
                return "on_op";
            }
            case 319: {
                return "on_backref";
            }
            case 339: {
                return "on_op";
            }
            case 340: {
                return "on_op";
            }
            case 317: {
                return "on_CHAR";
            }
            case 327: {
                return "on_op";
            }
            case 346: {
                return "on_op";
            }
            case 347: {
                return "on_op";
            }
            case 310: {
                return "on_const";
            }
            case 311: {
                return "on_cvar";
            }
            case 337: {
                return "on_op";
            }
            case 338: {
                return "on_op";
            }
            case 328: {
                return "on_op";
            }
            case 329: {
                return "on_op";
            }
            case 307: {
                return "on_ident";
            }
            case 314: {
                return "on_float";
            }
            case 331: {
                return "on_op";
            }
            case 308: {
                return "on_gvar";
            }
            case 306: {
                return "on_ident";
            }
            case 316: {
                return "on_imaginary";
            }
            case 313: {
                return "on_int";
            }
            case 309: {
                return "on_ivar";
            }
            case 353: {
                return "on_lbrace";
            }
            case 354: {
                return "on_lbrace";
            }
            case 123: {
                return "on_lbrace";
            }
            case 125: {
                return "on_rbrace";
            }
            case 352: {
                return "on_lbracket";
            }
            case 91: {
                return "on_lbracket";
            }
            case 93: {
                return "on_rbracket";
            }
            case 332: {
                return "on_op";
            }
            case 350: {
                return "on_lparen";
            }
            case 351: {
                return "on_lparen";
            }
            case 40: {
                return "on_lparen";
            }
            case 41: {
                return "on_rparen";
            }
            case 343: {
                return "on_op";
            }
            case 335: {
                return "on_op";
            }
            case 330: {
                return "on_op";
            }
            case 336: {
                return "on_op";
            }
            case 318: {
                return "on_backref";
            }
            case 348: {
                return "on_op";
            }
            case 334: {
                return "on_op";
            }
            case 326: {
                return "on_op";
            }
            case 367: {
                return "on_qsymbols_beg";
            }
            case 315: {
                return "on_rational";
            }
            case 366: {
                return "on_symbols_beg";
            }
            case 364: {
                return "on_qwords_beg";
            }
            case 362: {
                return "on_regexp_beg";
            }
            case 321: {
                return "on_regexp_end";
            }
            case 344: {
                return "on_op";
            }
            case 355: {
                return "on_op";
            }
            case 356: {
                return "on_op";
            }
            case 360: {
                return "on_tstring_beg";
            }
            case 320: {
                return "on_tstring_content";
            }
            case 369: {
                return "on_embexpr_beg";
            }
            case 368: {
                return "on_embexpr_end";
            }
            case 370: {
                return "on_embvar";
            }
            case 365: {
                return "on_tstring_end";
            }
            case 359: {
                return "on_symbeg";
            }
            case 325: {
                return "on_op";
            }
            case 322: {
                return "on_op";
            }
            case 324: {
                return "on_op";
            }
            case 363: {
                return "on_words_beg";
            }
            case 361: {
                return "on_backtick";
            }
            case 312: {
                return "on_label";
            }
            case 372: {
                return "on_label_end";
            }
            case 358: {
                return "on_tlambda";
            }
            case 371: {
                return "on_tlambeg";
            }
            case 373: {
                return "on_ignored_nl";
            }
            case 374: {
                return "on_comment";
            }
            case 375: {
                return "on_embdoc_beg";
            }
            case 376: {
                return "on_embdoc";
            }
            case 377: {
                return "on_embdoc_end";
            }
            case 323: {
                return "on_sp";
            }
            case 378: {
                return "on_heredoc_beg";
            }
            case 379: {
                return "on_heredoc_end";
            }
            case 380: {
                return "on___end__";
            }
        }
        return "on_CHAR";
    }

    private int yylex2() throws IOException {
        try {
            int currentToken = this.yylex2();
            this.printToken(currentToken);
            return currentToken;
        }
        catch (Exception e) {
            System.out.println("FFUFUFUFUFUFUFUF: " + e);
            return -1;
        }
    }

    private int yylex() throws IOException {
        int c;
        boolean spaceSeen = false;
        boolean tokenSeen = this.tokenSeen;
        if (this.lex_strterm != null) {
            return this.lex_strterm.parseString(this, this.src);
        }
        boolean commandState = this.commandStart;
        this.commandStart = false;
        this.tokenSeen = true;
        boolean fallthru = false;
        block47: while (true) {
            this.last_state = this.lex_state;
            c = this.nextc();
            switch (c) {
                case -1: 
                case 0: 
                case 4: 
                case 26: {
                    return -1;
                }
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    ByteList whitespaceBuf = new ByteList();
                    whitespaceBuf.append(c);
                    boolean looping = true;
                    spaceSeen = true;
                    block48: while (looping && (c = this.nextc()) != -1) {
                        switch (c) {
                            case 9: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 32: {
                                whitespaceBuf.append(c);
                                continue block48;
                            }
                        }
                        looping = false;
                    }
                    this.pushback(c);
                    this.dispatchScanEvent(323);
                    continue block47;
                }
                case 35: {
                    this.tokenSeen = tokenSeen;
                    if (!this.parser_magic_comment(this.lexb.makeShared(this.lex_p, this.lex_pend - this.lex_p)) && this.comment_at_top()) {
                        this.set_file_encoding(this.lex_p, this.lex_pend);
                    }
                    this.lex_goto_eol();
                    this.dispatchScanEvent(374);
                    fallthru = true;
                }
                case 10: {
                    boolean normalArg;
                    this.tokenSeen = tokenSeen;
                    boolean bl = normalArg = RubyLexer.isLexState(this.lex_state, 897) && !RubyLexer.isLexState(this.lex_state, 2048);
                    if (normalArg || this.isLexStateAll(this.lex_state, 2064)) {
                        if (!fallthru) {
                            this.dispatchScanEvent(373);
                        }
                        fallthru = false;
                        if (normalArg || !this.getLexContext().in_kwarg) continue block47;
                        this.commandStart = true;
                        this.setState(1);
                        return 10;
                    }
                    boolean done = false;
                    block49: while (!done) {
                        c = this.nextc();
                        switch (c) {
                            case 9: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 32: {
                                spaceSeen = true;
                                continue block49;
                            }
                            case 35: {
                                this.pushback(c);
                                if (!spaceSeen) continue block47;
                                this.dispatchScanEvent(323);
                                continue block47;
                            }
                            case 38: 
                            case 46: {
                                this.dispatchDelayedToken(373);
                                if (this.peek(46) == (c == 38)) {
                                    this.pushback(c);
                                    this.dispatchScanEvent(323);
                                    continue block47;
                                }
                            }
                            default: {
                                --this.ruby_sourceline;
                                this.lex_nextline = this.lex_lastline;
                            }
                            case -1: 
                        }
                        this.lex_goto_eol();
                        if (c != -1) {
                            this.tokp = this.lex_p;
                        }
                        done = true;
                    }
                    this.commandStart = true;
                    this.setState(1);
                    return 10;
                }
                case 42: {
                    return this.star(spaceSeen);
                }
                case 33: {
                    return this.bang();
                }
                case 61: {
                    if (this.was_bol() && this.strncmp(this.lexb.makeShared(this.lex_p, this.lex_pend - this.lex_p), BEGIN_DOC_MARKER, BEGIN_DOC_MARKER.length()) && Character.isWhitespace(this.p(this.lex_p + 5))) {
                        boolean first_p = true;
                        this.lex_goto_eol();
                        this.dispatchScanEvent(375);
                        do {
                            this.lex_goto_eol();
                            if (!first_p) {
                                this.dispatchScanEvent(376);
                            }
                            first_p = false;
                            c = this.nextc();
                            if (c != -1) continue;
                            this.compile_error("embedded document meets end of file");
                            return -1;
                        } while (c != 61 || !this.strncmp(this.lexb.makeShared(this.lex_p, this.lex_pend - this.lex_p), END_DOC_MARKER, END_DOC_MARKER.length()) || this.lex_p + 3 != this.lex_pend && !Character.isWhitespace(this.p(this.lex_p + 3)));
                        this.lex_goto_eol();
                        this.dispatchScanEvent(377);
                        continue block47;
                    }
                    this.setState(this.isAfterOperator() ? 16 : 1);
                    c = this.nextc();
                    if (c == 61) {
                        c = this.nextc();
                        if (c == 61) {
                            this.yaccValue = this.symbol(EQ_EQ_EQ);
                            return 329;
                        }
                        this.pushback(c);
                        this.yaccValue = this.symbol(EQ_EQ);
                        return 328;
                    }
                    if (c == 126) {
                        this.yaccValue = this.symbol(EQ_TILDE);
                        return 335;
                    }
                    if (c == 62) {
                        this.yaccValue = this.symbol(EQ_GT);
                        return 349;
                    }
                    this.pushback(c);
                    this.yaccValue = this.symbol(EQ);
                    return 61;
                }
                case 60: {
                    return this.lessThan(spaceSeen);
                }
                case 62: {
                    return this.greaterThan();
                }
                case 34: {
                    return this.doubleQuote(commandState);
                }
                case 96: {
                    return this.backtick(commandState);
                }
                case 39: {
                    return this.singleQuote(commandState);
                }
                case 63: {
                    return this.questionMark();
                }
                case 38: {
                    return this.ampersand(spaceSeen);
                }
                case 124: {
                    return this.pipe();
                }
                case 43: {
                    return this.plus(spaceSeen);
                }
                case 45: {
                    return this.minus(spaceSeen);
                }
                case 46: {
                    return this.dot();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.parseNumber(c);
                }
                case 41: {
                    return this.rightParen();
                }
                case 93: {
                    return this.rightBracket();
                }
                case 125: {
                    return this.rightCurly();
                }
                case 58: {
                    return this.colon(spaceSeen);
                }
                case 47: {
                    return this.slash(spaceSeen);
                }
                case 94: {
                    return this.caret();
                }
                case 59: {
                    this.commandStart = true;
                    this.setState(1);
                    return 59;
                }
                case 44: {
                    return this.comma(c);
                }
                case 126: {
                    return this.tilde();
                }
                case 40: {
                    return this.leftParen(spaceSeen);
                }
                case 91: {
                    return this.leftBracket(spaceSeen);
                }
                case 123: {
                    return this.leftCurly();
                }
                case 92: {
                    c = this.nextc();
                    if (c == 10) {
                        spaceSeen = true;
                        this.dispatchScanEvent(323);
                        continue block47;
                    }
                    if (c == 32) {
                        return 323;
                    }
                    if (Character.isWhitespace(c)) {
                        return c;
                    }
                    this.pushback(c);
                    return 92;
                }
                case 37: {
                    return this.percent(spaceSeen);
                }
                case 36: {
                    return this.dollar();
                }
                case 64: {
                    return this.at();
                }
                case 95: {
                    if (this.was_bol() && this.whole_match_p(END_MARKER, false)) {
                        this.__end__seen = true;
                        this.eofp = true;
                        this.lex_goto_eol();
                        this.dispatchScanEvent(380);
                        return -1;
                    }
                    return this.identifier(c, commandState);
                }
            }
            break;
        }
        return this.identifier(c, commandState);
    }

    private RubySymbol symbol(ByteList name2) {
        return this.getRuntime().newSymbol(name2);
    }

    private int identifierToken(int last_state, int result2, String value2) {
        if (result2 == 306 && !RubyLexer.isLexState(last_state, 384) && this.parser.getCurrentScope().isDefined(value2) >= 0) {
            this.setState(1026);
        }
        this.set_yylval_name(this.createTokenByteList());
        this.identValue = value2.intern();
        return result2;
    }

    private int ampersand(boolean spaceSeen) {
        int c = this.nextc();
        switch (c) {
            case 38: {
                this.setState(1);
                c = this.nextc();
                if (c == 61) {
                    this.yaccValue = AMPERSAND_AMPERSAND;
                    this.set_yylval_id(AMPERSAND_AMPERSAND);
                    this.setState(1);
                    return 348;
                }
                this.pushback(c);
                this.yaccValue = AMPERSAND_AMPERSAND;
                return 333;
            }
            case 61: {
                this.yaccValue = AMPERSAND;
                this.set_yylval_id(AMPERSAND);
                this.setState(1);
                return 348;
            }
            case 46: {
                this.setState(256);
                this.yaccValue = AMPERSAND_DOT;
                this.set_yylval_id(AMPERSAND_DOT);
                return 345;
            }
        }
        this.pushback(c);
        if (this.isSpaceArg(c, spaceSeen)) {
            if (this.isVerbose()) {
                this.warning("`&' interpreted as argument prefix");
            }
            c = 357;
        } else {
            c = this.isBEG() ? this.warn_balanced(c, spaceSeen, 357, "&", "argument prefix") : 38;
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        this.yaccValue = AMPERSAND;
        return c;
    }

    private int at() {
        int result2;
        this.newtok(true);
        int c = this.nextc();
        if (c == 64) {
            c = this.nextc();
            result2 = 311;
        } else {
            result2 = 309;
        }
        this.setState(RubyLexer.isLexState(this.last_state, 128) ? 8 : 2);
        if (c == -1 || !RubyLexer.isIdentifierChar(c)) {
            if (result2 == 309) {
                this.compile_error("`@' without identifiers is not allowed as an instance variable name");
            }
            this.compile_error("`@@' without identifiers is not allowed as a class variable name");
            this.set_yylval_noname();
            this.setState(2);
            return result2;
        }
        if (Character.isDigit(c)) {
            this.pushback(c);
            if (result2 == 309) {
                this.compile_error("`@" + (char)c + "' is not allowed as an instance variable name");
            }
            this.compile_error("`@@" + (char)c + "' is not allowed as a class variable name");
            this.set_yylval_noname();
            this.setState(2);
            return result2;
        }
        if (!this.tokadd_ident(c)) {
            return -1;
        }
        return this.tokenize_ident(result2);
    }

    private int backtick(boolean commandState) {
        this.yaccValue = BACKTICK;
        if (RubyLexer.isLexState(this.lex_state, 128)) {
            this.setState(8);
            return 96;
        }
        if (RubyLexer.isLexState(this.lex_state, 256)) {
            this.setState(commandState ? 32 : 16);
            return 96;
        }
        this.lex_strterm = new StringTerm(2, 0, 96, this.ruby_sourceline);
        return 361;
    }

    private int bang() {
        int c = this.nextc();
        if (this.isAfterOperator()) {
            this.setState(16);
            if (c == 64) {
                this.yaccValue = BANG;
                return 33;
            }
        } else {
            this.setState(1);
        }
        switch (c) {
            case 61: {
                this.yaccValue = BANG_EQ;
                return 330;
            }
            case 126: {
                this.yaccValue = BANG_TILDE;
                return 336;
            }
        }
        this.pushback(c);
        this.yaccValue = BANG;
        return 33;
    }

    private int caret() {
        this.yaccValue = CARET;
        int c = this.nextc();
        if (c == 61) {
            this.setState(1);
            this.set_yylval_id(CARET);
            return 348;
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        this.pushback(c);
        return 94;
    }

    private int colon(boolean spaceSeen) {
        int c = this.nextc();
        if (c == 58) {
            if (this.isBEG() || RubyLexer.isLexState(this.lex_state, 512) || this.isARG() && spaceSeen) {
                this.setState(1);
                this.yaccValue = COLON_COLON;
                return 347;
            }
            this.setState(256);
            this.yaccValue = COLON_COLON;
            this.set_yylval_id(COLON_COLON);
            return 346;
        }
        if (this.isEND() || Character.isWhitespace(c) || c == 35) {
            this.pushback(c);
            this.setState(1);
            this.yaccValue = COLON;
            return this.warn_balanced(c, spaceSeen, 58, ":", "symbol literal");
        }
        switch (c) {
            case 39: {
                this.lex_strterm = new StringTerm(16, 0, c, this.ruby_sourceline);
                break;
            }
            case 34: {
                this.lex_strterm = new StringTerm(18, 0, c, this.ruby_sourceline);
                break;
            }
            default: {
                this.pushback(c);
            }
        }
        this.setState(128);
        return 359;
    }

    private int comma(int c) {
        this.setState(1025);
        return c;
    }

    private int doKeyword(int state2) {
        if (this.isLambdaBeginning()) {
            this.setLeftParenBegin(-1);
            return 283;
        }
        if (this.conditionState.set_p()) {
            return 281;
        }
        if (this.cmdArgumentState.set_p() && !RubyLexer.isLexState(state2, 32)) {
            return 282;
        }
        return 280;
    }

    private int dollar() {
        this.setState(2);
        this.newtok(true);
        int c = this.nextc();
        switch (c) {
            case 95: {
                c = this.nextc();
                if (RubyLexer.isIdentifierChar(c)) {
                    if (!this.tokadd_ident(c)) {
                        return -1;
                    }
                    this.last_state = this.lex_state;
                    this.setState(2);
                    this.identValue = this.createTokenString().intern();
                    return 308;
                }
                this.pushback(c);
                c = 95;
            }
            case 33: 
            case 34: 
            case 36: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 126: {
                this.identValue = "$" + (char)c;
                this.set_yylval_name(new ByteList(new byte[]{36, (byte)c}));
                return 308;
            }
            case 45: {
                c = this.nextc();
                if (RubyLexer.isIdentifierChar(c)) {
                    if (!this.tokadd_mbchar(c)) {
                        return -1;
                    }
                } else {
                    this.pushback(c);
                    this.pushback(45);
                    return 36;
                }
                this.identValue = this.createTokenString().intern();
                return 308;
            }
            case 38: 
            case 39: 
            case 43: 
            case 96: {
                if (RubyLexer.isLexState(this.last_state, 128)) {
                    this.identValue = "$" + (char)c;
                    this.set_yylval_name(new ByteList(new byte[]{36, (byte)c}));
                    return 308;
                }
                this.identValue = "$" + (char)c;
                return 319;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                while (Character.isDigit(c = this.nextc())) {
                }
                this.pushback(c);
                if (RubyLexer.isLexState(this.last_state, 128)) {
                    this.identValue = this.createTokenString().intern();
                    this.set_yylval_name(new ByteList(new byte[]{36, (byte)c}));
                    return 308;
                }
                String refAsString = this.createTokenString();
                try {
                    Integer.parseInt(refAsString.substring(1).intern());
                }
                catch (NumberFormatException e) {
                    this.warn("`" + refAsString + "' is too big for a number variable, always nil");
                }
                this.identValue = this.createTokenString().intern();
                return 318;
            }
            case 48: {
                this.setState(2);
                return this.identifierToken(this.last_state, 308, ("$" + (char)c).intern());
            }
        }
        if (!RubyLexer.isIdentifierChar(c)) {
            if (c == -1 || RubyLexer.isSpace(c)) {
                this.compile_error("`$' without identifiers is not allowed as a global variable name");
            } else {
                this.pushback(c);
                this.compile_error("`$" + (char)c + "' is not allowed as a global variable name");
            }
            return -1;
        }
        this.last_state = this.lex_state;
        this.setState(2);
        this.tokadd_ident(c);
        return this.identifierToken(this.last_state, 308, this.createTokenString().intern());
    }

    private int dot() {
        boolean isBeg = this.isBEG();
        this.setState(1);
        int c = this.nextc();
        if (c == 46) {
            c = this.nextc();
            if (c == 46) {
                this.yaccValue = DOT_DOT_DOT;
                if (this.getLexContext().in_argdef) {
                    this.setState(4);
                    return 340;
                }
                if (this.parenNest == 0 && this.isLookingAtEOL()) {
                    this.warn("... at EOL, should be parenthesized?");
                } else if (this.getLeftParenBegin() >= 0 && this.getLeftParenBegin() + 1 == this.parenNest && RubyLexer.isLexState(this.last_state, 1024)) {
                    return 338;
                }
                return isBeg ? 340 : 338;
            }
            this.pushback(c);
            this.yaccValue = DOT_DOT;
            return isBeg ? 339 : 337;
        }
        this.pushback(c);
        if (Character.isDigit(c)) {
            this.compile_error("no .<digit> floating literal anymore; put 0 before dot");
        }
        this.setState(256);
        this.yaccValue = DOT;
        this.set_yylval_id(DOT);
        return 46;
    }

    private int doubleQuote(boolean commandState) {
        int label2 = this.isLabelPossible(commandState) ? 64 : 0;
        this.lex_strterm = new StringTerm(2 | label2, 0, 34, this.ruby_sourceline);
        this.yaccValue = QQ;
        return 360;
    }

    private int greaterThan() {
        this.setState(this.isAfterOperator() ? 16 : 1);
        int c = this.nextc();
        switch (c) {
            case 61: {
                this.yaccValue = GT_EQ;
                return 331;
            }
            case 62: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    this.yaccValue = GT_GT;
                    this.set_yylval_id(GT_GT);
                    return 348;
                }
                this.pushback(c);
                this.yaccValue = GT_GT;
                return 344;
            }
        }
        this.pushback(c);
        this.yaccValue = GT;
        return 62;
    }

    private int identifier(int c, boolean commandState) {
        Keyword keyword;
        String tempVal;
        if (!RubyLexer.isIdentifierChar(c)) {
            String badChar = "\\" + Integer.toOctalString(c & 0xFF);
            this.compile_error("Invalid char `" + badChar + "' ('" + (char)c + "') in expression");
        }
        int whereKeywordShouldStart = this.lex_p - 1;
        do {
            if (this.tokadd_mbchar(c)) continue;
            return -1;
        } while (RubyLexer.isIdentifierChar(c = this.nextc()));
        boolean lastBangOrPredicate = false;
        if (c == 33 || c == 63) {
            if (!this.peek(61)) {
                lastBangOrPredicate = true;
            } else {
                this.pushback(c);
            }
        } else {
            this.pushback(c);
        }
        int result2 = 0;
        this.last_state = this.lex_state;
        if (lastBangOrPredicate) {
            result2 = 307;
            tempVal = this.createTokenString();
        } else {
            if (RubyLexer.isLexState(this.lex_state, 128)) {
                c = this.nextc();
                if (c == 61) {
                    int c2 = this.nextc();
                    if (c2 != 126 && c2 != 62 && (c2 != 61 || this.peek(62))) {
                        result2 = 306;
                        this.pushback(c2);
                    } else {
                        this.pushback(c2);
                        this.pushback(c);
                    }
                } else {
                    this.pushback(c);
                }
            }
            tempVal = this.createTokenString();
            result2 = result2 == 0 && Character.isUpperCase(tempVal.charAt(0)) ? 310 : 306;
        }
        if (this.isLabelPossible(commandState) && this.isLabelSuffix()) {
            this.setState(2064);
            this.yaccValue = tempVal;
            this.identValue = tempVal.intern();
            this.set_yylval_name(this.createTokenByteList());
            this.nextc();
            return 312;
        }
        if (this.lex_state != 256 && (keyword = RubyLexer.getKeyword(this.createTokenString(whereKeywordShouldStart))) != null) {
            int state2 = this.lex_state;
            this.setState(keyword.state);
            this.set_yylval_name(this.createTokenByteList());
            if (RubyLexer.isLexState(state2, 128)) {
                this.setState(8);
                this.identValue = tempVal;
                return keyword.id0;
            }
            if (RubyLexer.isLexState(this.lex_state, 1)) {
                this.commandStart = true;
            }
            if (keyword.id0 == 280) {
                return this.doKeyword(state2);
            }
            if (RubyLexer.isLexState(state2, 2049)) {
                return keyword.id0;
            }
            if (keyword.id0 != keyword.id1) {
                this.setState(1025);
            }
            return keyword.id1;
        }
        if (RubyLexer.isLexState(this.lex_state, 881)) {
            this.setState(commandState ? 32 : 16);
        } else if (this.lex_state == 128) {
            this.setState(8);
        } else {
            this.setState(2);
        }
        return this.identifierToken(this.last_state, result2, tempVal.intern());
    }

    private int leftBracket(boolean spaceSeen) {
        ++this.parenNest;
        int c = 91;
        if (this.isAfterOperator()) {
            c = this.nextc();
            if (c == 93) {
                this.setState(16);
                if (this.peek(61)) {
                    this.nextc();
                    this.yaccValue = LBRACKET_RBRACKET_EQ;
                    return 342;
                }
                this.yaccValue = LBRACKET_RBRACKET;
                return 341;
            }
            this.pushback(c);
            this.setState(1040);
            this.yaccValue = LBRACKET;
            return 91;
        }
        if (this.isBEG() || this.isARG() && (spaceSeen || RubyLexer.isLexState(this.lex_state, 2048))) {
            c = 352;
        }
        this.setState(1025);
        this.conditionState.push0();
        this.cmdArgumentState.push0();
        this.yaccValue = LBRACKET;
        return c;
    }

    private int leftCurly() {
        ++this.braceNest;
        int c = this.isLambdaBeginning() ? 371 : (RubyLexer.isLexState(this.lex_state, 2048) ? 353 : (RubyLexer.isLexState(this.lex_state, 58) ? 123 : (RubyLexer.isLexState(this.lex_state, 4) ? 354 : 353)));
        if (c != 353) {
            this.commandStart = true;
            this.setState(1);
        } else {
            this.setState(1025);
        }
        ++this.parenNest;
        this.conditionState.push0();
        this.cmdArgumentState.push0();
        this.yaccValue = this.ruby_sourceline;
        return c;
    }

    private int leftParen(boolean spaceSeen) {
        int result2;
        if (this.isBEG()) {
            result2 = 350;
        } else if (!spaceSeen) {
            result2 = 40;
        } else if (this.isARG() || this.isLexStateAll(this.lex_state, 1026)) {
            result2 = 351;
        } else if (RubyLexer.isLexState(this.lex_state, 8) && !this.isLambdaBeginning()) {
            this.warn("parentheses after method name is interpreted as an argument list, not a decomposed argument");
            result2 = 40;
        } else {
            result2 = 40;
        }
        ++this.parenNest;
        this.conditionState.push0();
        this.cmdArgumentState.push0();
        this.setState(1025);
        return result2;
    }

    private int lessThan(boolean spaceSeen) {
        int tok;
        this.last_state = this.lex_state;
        int c = this.nextc();
        if (!(c != 60 || RubyLexer.isLexState(this.lex_state, 768) || this.isEND() || this.isARG() && !RubyLexer.isLexState(this.lex_state, 2048) && !spaceSeen || (tok = this.hereDocumentIdentifier()) == 0)) {
            return tok;
        }
        if (this.isAfterOperator()) {
            this.setState(16);
        } else {
            if (RubyLexer.isLexState(this.lex_state, 512)) {
                this.commandStart = true;
            }
            this.setState(1);
        }
        switch (c) {
            case 61: {
                c = this.nextc();
                if (c == 62) {
                    this.yaccValue = LT_EQ_RT;
                    return 327;
                }
                this.pushback(c);
                this.yaccValue = LT_EQ;
                return 332;
            }
            case 60: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    this.yaccValue = LT_LT;
                    return 348;
                }
                this.pushback(c);
                this.yaccValue = LT_LT;
                return this.warn_balanced(c, spaceSeen, 343, "<<", "here document");
            }
        }
        this.yaccValue = LT;
        this.pushback(c);
        return 60;
    }

    private int minus(boolean spaceSeen) {
        int c = this.nextc();
        if (this.isAfterOperator()) {
            this.setState(16);
            if (c == 64) {
                this.yaccValue = MINUS_AT;
                return 325;
            }
            this.pushback(c);
            this.yaccValue = MINUS;
            return 45;
        }
        if (c == 61) {
            this.setState(1);
            this.yaccValue = MINUS;
            this.set_yylval_id(MINUS);
            return 348;
        }
        if (c == 62) {
            this.setState(8);
            this.yaccValue = MINUS_GT;
            return 358;
        }
        if (this.isBEG() || this.isSpaceArg(c, spaceSeen) && this.arg_ambiguous()) {
            this.setState(1);
            this.pushback(c);
            this.yaccValue = MINUS_AT;
            if (Character.isDigit(c)) {
                return 322;
            }
            return 325;
        }
        this.setState(1);
        this.pushback(c);
        this.yaccValue = MINUS;
        return this.warn_balanced(c, spaceSeen, 45, "-", "unary operator");
    }

    private int percent(boolean spaceSeen) {
        if (this.isBEG()) {
            return this.parseQuote(this.nextc());
        }
        int c = this.nextc();
        if (c == 61) {
            this.setState(1);
            this.yaccValue = PERCENT;
            this.set_yylval_id(PERCENT);
            return 348;
        }
        if (this.isSpaceArg(c, spaceSeen) || RubyLexer.isLexState(this.lex_state, 4096) && c == 115) {
            return this.parseQuote(c);
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        this.pushback(c);
        this.yaccValue = PERCENT;
        return this.warn_balanced(c, spaceSeen, 37, "%", "string literal");
    }

    private int pipe() {
        int c = this.nextc();
        switch (c) {
            case 124: {
                this.setState(1);
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    this.yaccValue = OR_OR;
                    this.set_yylval_id(OR_OR);
                    return 348;
                }
                this.pushback(c);
                if (this.isLexStateAll(this.last_state, 1)) {
                    this.yaccValue = OR;
                    this.pushback(124);
                    return 124;
                }
                this.yaccValue = OR_OR;
                return 334;
            }
            case 61: {
                this.setState(1);
                this.yaccValue = OR;
                this.set_yylval_id(OR);
                return 348;
            }
        }
        this.setState(this.isAfterOperator() ? 16 : 1025);
        this.pushback(c);
        this.yaccValue = OR;
        return 124;
    }

    private int plus(boolean spaceSeen) {
        int c = this.nextc();
        if (this.isAfterOperator()) {
            this.setState(16);
            if (c == 64) {
                this.yaccValue = PLUS_AT;
                return 324;
            }
            this.pushback(c);
            this.yaccValue = PLUS;
            return 43;
        }
        if (c == 61) {
            this.setState(1);
            this.yaccValue = PLUS;
            this.set_yylval_id(PLUS);
            return 348;
        }
        if (this.isBEG() || this.isSpaceArg(c, spaceSeen) && this.arg_ambiguous()) {
            this.setState(1);
            this.pushback(c);
            if (Character.isDigit(c)) {
                c = 43;
                return this.parseNumber(c);
            }
            this.yaccValue = PLUS_AT;
            return 324;
        }
        this.setState(1);
        this.pushback(c);
        this.yaccValue = PLUS;
        return this.warn_balanced(c, spaceSeen, 43, "+", "unary operator");
    }

    private int questionMark() throws IOException {
        if (this.isEND()) {
            this.setState(1);
            this.yaccValue = QUESTION;
            return 63;
        }
        int c = this.nextc();
        if (c == -1) {
            this.compile_error("incomplete character syntax");
            return -1;
        }
        if (Character.isWhitespace(c)) {
            if (!this.isARG()) {
                int c2 = 0;
                switch (c) {
                    case 32: {
                        c2 = 115;
                        break;
                    }
                    case 10: {
                        c2 = 110;
                        break;
                    }
                    case 9: {
                        c2 = 116;
                        break;
                    }
                    case 13: {
                        c2 = 114;
                        break;
                    }
                    case 12: {
                        c2 = 102;
                    }
                }
                if (c2 != 0) {
                    this.warn("invalid character syntax; use ?\\" + c2);
                }
            }
            this.pushback(c);
            this.setState(1);
            this.yaccValue = QUESTION;
            return 63;
        }
        if (!this.isASCII()) {
            if (!this.tokadd_mbchar(c)) {
                return -1;
            }
            this.yaccValue = this.createTokenByteList(1);
            this.setState(2);
            return 317;
        }
        if (RubyLexer.isIdentifierChar(c) && !this.peek(10) && this.isNext_identchar()) {
            this.pushback(c);
            this.setState(1);
            this.yaccValue = QUESTION;
            return 63;
        }
        if (c == 92) {
            if (this.peek(117)) {
                this.nextc();
                ByteList oneCharBL = new ByteList(2);
                c = this.readUTFEscape(oneCharBL, false, new boolean[]{false});
                if (c >= 128) {
                    this.tokadd_mbchar(c, oneCharBL);
                } else {
                    oneCharBL.append(c);
                }
                this.setState(2);
                this.yaccValue = oneCharBL;
                return 313;
            }
            c = this.readEscape();
        }
        ByteList oneCharBL = new ByteList(1);
        oneCharBL.setEncoding(this.getEncoding());
        oneCharBL.append(c);
        this.yaccValue = oneCharBL;
        this.setState(2);
        return 317;
    }

    private int rightBracket() {
        --this.parenNest;
        this.conditionState.pop();
        this.cmdArgumentState.pop();
        this.setState(2);
        this.yaccValue = RBRACKET;
        return 93;
    }

    private int rightCurly() {
        this.yaccValue = RCURLY;
        --this.braceNest;
        if (this.braceNest < 0) {
            return 368;
        }
        this.conditionState.pop();
        this.cmdArgumentState.pop();
        this.setState(2);
        --this.parenNest;
        return 125;
    }

    private int rightParen() {
        --this.parenNest;
        this.conditionState.pop();
        this.cmdArgumentState.pop();
        this.setState(8);
        this.yaccValue = RPAREN;
        return 41;
    }

    private int singleQuote(boolean commandState) {
        int label2 = this.isLabelPossible(commandState) ? 64 : 0;
        this.lex_strterm = new StringTerm(0 | label2, 0, 39, this.ruby_sourceline);
        this.yaccValue = Q;
        return 360;
    }

    private int slash(boolean spaceSeen) {
        if (this.isBEG()) {
            this.lex_strterm = new StringTerm(7, 0, 47, this.ruby_sourceline);
            return 362;
        }
        int c = this.nextc();
        if (c == 61) {
            this.setState(1);
            this.set_yylval_id(SLASH);
            return 348;
        }
        this.pushback(c);
        if (this.isSpaceArg(c, spaceSeen)) {
            this.arg_ambiguous();
            this.lex_strterm = new StringTerm(7, 0, 47, this.ruby_sourceline);
            return 362;
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        return this.warn_balanced(c, spaceSeen, 47, "/", "regexp literal");
    }

    private int star(boolean spaceSeen) {
        int c = this.nextc();
        switch (c) {
            case 42: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    this.yaccValue = STAR_STAR;
                    this.set_yylval_id(STAR_STAR);
                    return 348;
                }
                this.pushback(c);
                this.yaccValue = STAR_STAR;
                if (this.isSpaceArg(c, spaceSeen)) {
                    if (this.isVerbose() && Options.PARSER_WARN_ARGUMENT_PREFIX.load().booleanValue()) {
                        this.warning("`**' interpreted as argument prefix");
                    }
                    c = 356;
                    break;
                }
                if (this.isBEG()) {
                    c = 356;
                    break;
                }
                c = this.warn_balanced(c, spaceSeen, 326, "**", "argument prefix");
                break;
            }
            case 61: {
                this.setState(1);
                this.yaccValue = STAR;
                this.set_yylval_id(STAR);
                return 348;
            }
            default: {
                this.pushback(c);
                if (this.isSpaceArg(c, spaceSeen)) {
                    if (this.isVerbose() && Options.PARSER_WARN_ARGUMENT_PREFIX.load().booleanValue()) {
                        this.warning("`*' interpreted as argument prefix");
                    }
                    c = 355;
                } else {
                    c = this.isBEG() ? 355 : this.warn_balanced(c, spaceSeen, 42, "*", "argument prefix");
                }
                this.yaccValue = STAR;
            }
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        return c;
    }

    private int tilde() {
        if (this.isAfterOperator()) {
            int c = this.nextc();
            if (c != 64) {
                this.pushback(c);
            }
            this.setState(16);
        } else {
            this.setState(1);
        }
        this.yaccValue = TILDE;
        return 126;
    }

    private int parseNumber(int c) {
        this.setState(2);
        this.newtok(true);
        this.numberBuffer.setRealSize(0);
        if (c == 45) {
            this.numberBuffer.append((char)c);
            c = this.nextc();
        } else if (c == 43) {
            c = this.nextc();
        }
        int nondigit = 0;
        if (c == 48) {
            int startLen = this.numberBuffer.length();
            c = this.nextc();
            switch (c) {
                case 88: 
                case 120: {
                    c = this.nextc();
                    if (RubyLexer.isHexChar(c)) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (!RubyLexer.isHexChar(c)) break;
                                nondigit = 0;
                                this.numberBuffer.append((char)c);
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.numberBuffer.length() == startLen) {
                        this.parse_error("Hexadecimal number without hex-digits.");
                    } else if (nondigit != 0) {
                        this.compile_error("Trailing '_' in number.");
                    }
                    return this.setIntegerLiteral(this.numberLiteralSuffix(3));
                }
                case 66: 
                case 98: {
                    c = this.nextc();
                    if (c == 48 || c == 49) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (c != 48 && c != 49) break;
                                nondigit = 0;
                                this.numberBuffer.append((char)c);
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.numberBuffer.length() == startLen) {
                        this.compile_error_pos("Binary number without digits.");
                    } else if (nondigit != 0) {
                        this.compile_error_pos("Trailing '_' in number.");
                    }
                    return this.setIntegerLiteral(this.numberLiteralSuffix(3));
                }
                case 68: 
                case 100: {
                    c = this.nextc();
                    if (Character.isDigit(c)) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (!Character.isDigit(c)) break;
                                nondigit = 0;
                                this.numberBuffer.append((char)c);
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.numberBuffer.length() == startLen) {
                        this.compile_error_pos("Binary number without digits.");
                    } else if (nondigit != 0) {
                        this.compile_error_pos("Trailing '_' in number.");
                    }
                    return this.setIntegerLiteral(this.numberLiteralSuffix(3));
                }
                case 79: 
                case 111: {
                    c = this.nextc();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 95: {
                    while (true) {
                        if (c == 95) {
                            if (nondigit != 0) break;
                            nondigit = c;
                        } else {
                            if (c < 48 || c > 55) break;
                            nondigit = 0;
                            this.numberBuffer.append((char)c);
                        }
                        c = this.nextc();
                    }
                    if (this.numberBuffer.length() > startLen) {
                        this.pushback(c);
                        if (nondigit != 0) {
                            this.compile_error_pos("Trailing '_' in number.");
                        }
                        return this.setIntegerLiteral(this.numberLiteralSuffix(3));
                    }
                }
                case 56: 
                case 57: {
                    this.parse_error("Illegal octal digit.");
                }
                case 46: 
                case 69: 
                case 101: {
                    this.numberBuffer.append(48);
                    break;
                }
                default: {
                    this.pushback(c);
                    this.numberBuffer.append(48);
                    return this.setIntegerLiteral(this.numberLiteralSuffix(3));
                }
            }
        }
        boolean seen_point = false;
        boolean seen_e = false;
        while (true) {
            switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    nondigit = 0;
                    this.numberBuffer.append((char)c);
                    break;
                }
                case 46: {
                    if (nondigit != 0) {
                        this.pushback(c);
                        this.compile_error("Trailing '_' in number.");
                        break;
                    }
                    if (seen_point || seen_e) {
                        this.pushback(c);
                        return this.getNumberLiteral(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                    }
                    int c2 = this.nextc();
                    if (!Character.isDigit(c2)) {
                        this.pushback(c2);
                        this.pushback(46);
                        if (c == 95) break;
                        return this.getNumberLiteral(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                    }
                    this.numberBuffer.append(46);
                    this.numberBuffer.append((char)c2);
                    seen_point = true;
                    nondigit = 0;
                    break;
                }
                case 69: 
                case 101: {
                    if (nondigit != 0) {
                        this.compile_error("Trailing '_' in number.");
                        break;
                    }
                    if (seen_e) {
                        this.pushback(c);
                        return this.getNumberLiteral(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                    }
                    this.numberBuffer.append((char)c);
                    seen_e = true;
                    nondigit = c;
                    c = this.nextc();
                    if (c == 45 || c == 43) {
                        this.numberBuffer.append((char)c);
                        nondigit = c;
                        break;
                    }
                    this.pushback(c);
                    break;
                }
                case 95: {
                    if (nondigit != 0) {
                        this.compile_error_pos("Trailing '_' in number.");
                    }
                    nondigit = c;
                    break;
                }
                default: {
                    this.pushback(c);
                    return this.getNumberLiteral(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                }
            }
            c = this.nextc();
        }
    }

    private int getNumberLiteral(String number, boolean seen_e, boolean seen_point, int nondigit) {
        boolean isFloat;
        if (nondigit != 0) {
            this.compile_error_pos("Trailing '_' in number.");
        }
        boolean bl = isFloat = seen_e || seen_point;
        if (isFloat) {
            int suffix = this.numberLiteralSuffix(seen_e ? 2 : 3);
            return this.setNumberLiteral(this.getFloatToken(number, suffix), suffix);
        }
        return this.setIntegerLiteral(this.numberLiteralSuffix(3));
    }

    private int setNumberLiteral(int type2, int suffix) {
        if ((suffix & 2) != 0) {
            type2 = 316;
        }
        this.setState(2);
        return type2;
    }

    private int setIntegerLiteral(int suffix) {
        int type2 = (suffix & 1) != 0 ? 315 : 313;
        return this.setNumberLiteral(type2, suffix);
    }

    static {
        map.put("end", Keyword.END);
        map.put("else", Keyword.ELSE);
        map.put("case", Keyword.CASE);
        map.put("ensure", Keyword.ENSURE);
        map.put("module", Keyword.MODULE);
        map.put("elsif", Keyword.ELSIF);
        map.put("def", Keyword.DEF);
        map.put("rescue", Keyword.RESCUE);
        map.put("not", Keyword.NOT);
        map.put("then", Keyword.THEN);
        map.put("yield", Keyword.YIELD);
        map.put("for", Keyword.FOR);
        map.put("self", Keyword.SELF);
        map.put("false", Keyword.FALSE);
        map.put("retry", Keyword.RETRY);
        map.put("return", Keyword.RETURN);
        map.put("true", Keyword.TRUE);
        map.put("if", Keyword.IF);
        map.put("defined?", Keyword.DEFINED_P);
        map.put("super", Keyword.SUPER);
        map.put("undef", Keyword.UNDEF);
        map.put("break", Keyword.BREAK);
        map.put("in", Keyword.IN);
        map.put("do", Keyword.DO);
        map.put("nil", Keyword.NIL);
        map.put("until", Keyword.UNTIL);
        map.put("unless", Keyword.UNLESS);
        map.put("or", Keyword.OR);
        map.put("next", Keyword.NEXT);
        map.put("when", Keyword.WHEN);
        map.put("redo", Keyword.REDO);
        map.put("and", Keyword.AND);
        map.put("begin", Keyword.BEGIN);
        map.put("__LINE__", Keyword.__LINE__);
        map.put("class", Keyword.CLASS);
        map.put("__FILE__", Keyword.__FILE__);
        map.put("END", Keyword.LEND);
        map.put("BEGIN", Keyword.LBEGIN);
        map.put("while", Keyword.WHILE);
        map.put("alias", Keyword.ALIAS);
        map.put("__ENCODING__", Keyword.__ENCODING__);
    }

    public static enum Keyword {
        END("end", 264, 264, 2),
        ELSE("else", 269, 269, 1),
        CASE("case", 270, 270, 1),
        ENSURE("ensure", 263, 263, 1),
        MODULE("module", 258, 258, 1),
        ELSIF("elsif", 268, 268, 1),
        DEF("def", 259, 259, 128),
        RESCUE("rescue", 262, 298, 64),
        NOT("not", 293, 293, 16),
        THEN("then", 267, 267, 1),
        YIELD("yield", 285, 285, 16),
        FOR("for", 274, 274, 1),
        SELF("self", 287, 287, 2),
        FALSE("false", 290, 290, 2),
        RETRY("retry", 278, 278, 2),
        RETURN("return", 284, 284, 64),
        TRUE("true", 289, 289, 2),
        IF("if", 265, 294, 1),
        DEFINED_P("defined?", 300, 300, 16),
        SUPER("super", 286, 286, 16),
        UNDEF("undef", 260, 260, 4224),
        BREAK("break", 275, 275, 64),
        IN("in", 279, 279, 1),
        DO("do", 280, 280, 1),
        NIL("nil", 288, 288, 2),
        UNTIL("until", 273, 297, 1),
        UNLESS("unless", 266, 295, 1),
        OR("or", 292, 292, 1),
        NEXT("next", 276, 276, 64),
        WHEN("when", 271, 271, 1),
        REDO("redo", 277, 277, 2),
        AND("and", 291, 291, 1),
        BEGIN("begin", 261, 261, 1),
        __LINE__("__LINE__", 303, 303, 2),
        CLASS("class", 257, 257, 512),
        __FILE__("__FILE__", 304, 304, 2),
        LEND("END", 302, 302, 2),
        LBEGIN("BEGIN", 301, 301, 2),
        WHILE("while", 272, 296, 1),
        ALIAS("alias", 299, 299, 4224),
        __ENCODING__("__ENCODING__", 305, 305, 2);

        public final String name;
        public final int id0;
        public final int id1;
        public final int state;

        private Keyword(String name2, int id0, int id1, int state2) {
            this.name = name2;
            this.id0 = id0;
            this.id1 = id1;
            this.state = state2;
        }
    }
}

