/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.chart.PixelMatrix;
import eu.hansolo.tilesfx.chart.PixelMatrixBuilder;
import eu.hansolo.tilesfx.events.ChartDataEventListener;
import eu.hansolo.tilesfx.events.PixelMatrixEventListener;
import eu.hansolo.tilesfx.events.TileEvt;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class MatrixTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private PixelMatrix matrix;
    private ListChangeListener<ChartData> chartDataListener;
    private ChartDataEventListener chartEventListener;
    private Tooltip selectionTooltip;
    private PixelMatrixEventListener matrixListener;
    private EventHandler<MouseEvent> mouseHandler;

    public MatrixTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.matrix = ((PixelMatrixBuilder)((PixelMatrixBuilder)((PixelMatrixBuilder)((PixelMatrixBuilder)((PixelMatrixBuilder)((PixelMatrixBuilder)PixelMatrixBuilder.create().pixelShape(PixelMatrix.PixelShape.SQUARE)).useSpacer(true)).squarePixels(false)).colsAndRows(this.tile.getMatrixSize())).pixelOnColor(this.tile.getBarColor())).pixelOffColor(Helper.isDark(this.tile.getBackgroundColor()) ? this.tile.getBackgroundColor().brighter() : this.tile.getBackgroundColor().darker())).build();
        if (!this.tile.getChartData().isEmpty() && this.tile.getChartData().size() > 2) {
            this.matrix.setColsAndRows(this.tile.getChartData().size(), this.matrix.getRows());
        }
        this.chartEventListener = e -> this.updateMatrixWithChartData();
        this.tile.getChartData().forEach(chartData -> chartData.addChartDataEventListener(this.chartEventListener));
        this.chartDataListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(addedItem -> addedItem.addChartDataEventListener(this.chartEventListener));
                    if (this.tile.getChartData().isEmpty() || this.tile.getChartData().size() <= 2) continue;
                    this.matrix.setColsAndRows(this.tile.getChartData().size(), this.matrix.getRows());
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(removedItem -> removedItem.removeChartDataEventListener(this.chartEventListener));
                if (this.tile.getChartData().isEmpty() || this.tile.getChartData().size() <= 2) continue;
                this.matrix.setColsAndRows(this.tile.getChartData().size(), this.matrix.getRows());
            }
            this.updateMatrixWithChartData();
        };
        this.matrixListener = e -> {
            if (this.tile.getChartData().isEmpty()) {
                return;
            }
            int column = e.getX();
            ChartData data = (ChartData)this.tile.getChartData().get(column);
            String tooltipText = data.getName() + "\n" + String.format(this.locale, this.formatString, data.getValue());
            Point2D popupLocation = new Point2D(e.getMouseScreenX() - this.selectionTooltip.getWidth() * 0.5, e.getMouseScreenY() - this.size * 0.025 - this.selectionTooltip.getHeight());
            this.selectionTooltip.setText(tooltipText);
            this.selectionTooltip.setX(popupLocation.getX());
            this.selectionTooltip.setY(popupLocation.getY());
            this.selectionTooltip.show(this.tile.getScene().getWindow());
            this.tile.fireTileEvt(new TileEvt((Object)this.tile, TileEvt.SELECTED_CHART_DATA, data));
        };
        this.mouseHandler = e -> {
            EventType TYPE = e.getEventType();
            if (MouseEvent.MOUSE_CLICKED.equals(TYPE)) {
                this.matrix.checkForClick((MouseEvent)e);
            } else if (MouseEvent.MOUSE_MOVED.equals(TYPE)) {
                this.selectionTooltip.hide();
            } else if (MouseEvent.MOUSE_EXITED.equals(TYPE)) {
                this.selectionTooltip.hide();
            }
        };
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.selectionTooltip = new Tooltip("");
        this.selectionTooltip.setWidth(60.0);
        this.selectionTooltip.setHeight(48.0);
        Tooltip.install((Node)this.matrix, (Tooltip)this.selectionTooltip);
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.matrix, this.text});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.getChartData().addListener(this.chartDataListener);
        this.matrix.addPixelMatrixEventListener(this.matrixListener);
        this.matrix.addEventHandler(MouseEvent.MOUSE_CLICKED, this.mouseHandler);
        this.matrix.addEventHandler(MouseEvent.MOUSE_MOVED, this.mouseHandler);
        this.matrix.addEventHandler(MouseEvent.MOUSE_EXITED, this.mouseHandler);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.matrix.setColsAndRows(this.tile.getMatrixSize());
            this.resize();
        }
    }

    @Override
    public void dispose() {
        this.matrix.removeAllPixelMatrixEventListeners();
        this.matrix.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.mouseHandler);
        this.matrix.removeEventHandler(MouseEvent.MOUSE_MOVED, this.mouseHandler);
        this.matrix.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseHandler);
        this.matrix.dispose();
        this.tile.getChartData().removeListener(this.chartDataListener);
        this.tile.getChartData().forEach(chartData -> chartData.removeChartDataEventListener(this.chartEventListener));
        super.dispose();
    }

    private void updateMatrixWithChartData() {
        ObservableList<ChartData> dataList = this.tile.getChartData();
        int cols = dataList.size();
        int rows = this.matrix.getRows();
        double factor = (double)rows / this.tile.getRange();
        Color offColor = this.matrix.getPixelOffColor();
        this.matrix.setAllPixelsOff();
        for (int y = rows; y >= 0; --y) {
            for (int x = 0; x < cols; ++x) {
                int noOfActivePixels = Helper.roundDoubleToInt((this.maxValue - ((ChartData)dataList.get(x)).getValue()) * factor);
                this.matrix.setPixel(x, y, noOfActivePixels <= y ? ((ChartData)dataList.get(x)).getFillColor() : offColor);
            }
        }
        this.matrix.drawMatrix();
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.width = this.tile.getWidth() - this.tile.getInsets().getLeft() - this.tile.getInsets().getRight();
        this.height = this.tile.getHeight() - this.tile.getInsets().getTop() - this.tile.getInsets().getBottom();
        this.size = this.width < this.height ? this.width : this.height;
        double chartWidth = this.contentBounds.getWidth();
        double chartHeight = this.contentBounds.getHeight();
        if (this.tile.isShowing() && this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.matrix.setPrefSize(chartWidth, chartHeight);
            this.matrix.relocate((this.width - chartWidth) * 0.5, this.contentBounds.getY() + (this.contentBounds.getHeight() - chartHeight) * 0.5);
            this.resizeStaticText();
        }
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.matrix.setPixelOnColor(this.tile.getBarColor());
        this.matrix.setPixelOffColor(Helper.isDark(this.tile.getBackgroundColor()) ? this.tile.getBackgroundColor().brighter() : this.tile.getBackgroundColor().darker());
        this.updateMatrixWithChartData();
    }
}

