# Configurations
<!-- *lspconfig-all* *lspconfig-server-configurations* -->

LSP configs provided by nvim-lspconfig are listed below. This documentation is
autogenerated from the Lua files. You can view this file in Nvim by running
`:help lspconfig-all`.

- [als](#als)
- [anakin_language_server](#anakin_language_server)
- [angularls](#angularls)
- [ansiblels](#ansiblels)
- [antlersls](#antlersls)
- [apex_ls](#apex_ls)
- [arduino_language_server](#arduino_language_server)
- [asm_lsp](#asm_lsp)
- [astro](#astro)
- [awk_ls](#awk_ls)
- [bashls](#bashls)
- [beancount](#beancount)
- [bicep](#bicep)
- [blueprint_ls](#blueprint_ls)
- [bsl_ls](#bsl_ls)
- [bufls](#bufls)
- [ccls](#ccls)
- [clangd](#clangd)
- [clarity_lsp](#clarity_lsp)
- [clojure_lsp](#clojure_lsp)
- [cmake](#cmake)
- [codeqlls](#codeqlls)
- [crystalline](#crystalline)
- [csharp_ls](#csharp_ls)
- [cssls](#cssls)
- [cssmodules_ls](#cssmodules_ls)
- [cucumber_language_server](#cucumber_language_server)
- [dafny](#dafny)
- [dagger](#dagger)
- [dartls](#dartls)
- [denols](#denols)
- [dhall_lsp_server](#dhall_lsp_server)
- [diagnosticls](#diagnosticls)
- [dockerls](#dockerls)
- [dolmenls](#dolmenls)
- [dotls](#dotls)
- [efm](#efm)
- [elixirls](#elixirls)
- [elmls](#elmls)
- [ember](#ember)
- [emmet_ls](#emmet_ls)
- [erg_language_server](#erg_language_server)
- [erlangls](#erlangls)
- [esbonio](#esbonio)
- [eslint](#eslint)
- [fennel-ls](#fennel-ls)
- [flow](#flow)
- [flux_lsp](#flux_lsp)
- [foam_ls](#foam_ls)
- [fortls](#fortls)
- [fsautocomplete](#fsautocomplete)
- [fsharp_language_server](#fsharp_language_server)
- [fstar](#fstar)
- [gdscript](#gdscript)
- [ghcide](#ghcide)
- [ghdl_ls](#ghdl_ls)
- [gleam](#gleam)
- [glint](#glint)
- [glslls](#glslls)
- [golangci_lint_ls](#golangci_lint_ls)
- [gopls](#gopls)
- [gradle_ls](#gradle_ls)
- [grammarly](#grammarly)
- [graphql](#graphql)
- [groovyls](#groovyls)
- [haxe_language_server](#haxe_language_server)
- [hdl_checker](#hdl_checker)
- [hhvm](#hhvm)
- [hie](#hie)
- [hls](#hls)
- [hoon_ls](#hoon_ls)
- [html](#html)
- [idris2_lsp](#idris2_lsp)
- [intelephense](#intelephense)
- [java_language_server](#java_language_server)
- [jdtls](#jdtls)
- [jedi_language_server](#jedi_language_server)
- [jsonls](#jsonls)
- [jsonnet_ls](#jsonnet_ls)
- [julials](#julials)
- [kotlin_language_server](#kotlin_language_server)
- [lean3ls](#lean3ls)
- [leanls](#leanls)
- [lelwel_ls](#lelwel_ls)
- [lemminx](#lemminx)
- [ltex](#ltex)
- [luau_lsp](#luau_lsp)
- [m68k](#m68k)
- [marksman](#marksman)
- [metals](#metals)
- [millet](#millet)
- [mint](#mint)
- [mlir_lsp_server](#mlir_lsp_server)
- [mlir_pdll_lsp_server](#mlir_pdll_lsp_server)
- [mm0_ls](#mm0_ls)
- [move_analyzer](#move_analyzer)
- [neocmake](#neocmake)
- [nickel_ls](#nickel_ls)
- [nil_ls](#nil_ls)
- [nimls](#nimls)
- [ntt](#ntt)
- [nxls](#nxls)
- [ocamlls](#ocamlls)
- [ocamllsp](#ocamllsp)
- [ols](#ols)
- [omnisharp](#omnisharp)
- [opencl_ls](#opencl_ls)
- [openscad_ls](#openscad_ls)
- [pasls](#pasls)
- [perlls](#perlls)
- [perlnavigator](#perlnavigator)
- [perlpls](#perlpls)
- [phan](#phan)
- [phpactor](#phpactor)
- [please](#please)
- [powershell_es](#powershell_es)
- [prismals](#prismals)
- [prolog_ls](#prolog_ls)
- [prosemd_lsp](#prosemd_lsp)
- [psalm](#psalm)
- [puppet](#puppet)
- [purescriptls](#purescriptls)
- [pylsp](#pylsp)
- [pyre](#pyre)
- [pyright](#pyright)
- [qml_lsp](#qml_lsp)
- [qmlls](#qmlls)
- [quick_lint_js](#quick_lint_js)
- [r_language_server](#r_language_server)
- [racket_langserver](#racket_langserver)
- [reason_ls](#reason_ls)
- [relay_lsp](#relay_lsp)
- [remark_ls](#remark_ls)
- [rescriptls](#rescriptls)
- [rls](#rls)
- [rnix](#rnix)
- [robotframework_ls](#robotframework_ls)
- [rome](#rome)
- [ruby_ls](#ruby_ls)
- [rust_analyzer](#rust_analyzer)
- [salt_ls](#salt_ls)
- [scheme_langserver](#scheme_langserver)
- [scry](#scry)
- [serve_d](#serve_d)
- [sixtyfps](#sixtyfps)
- [slint_lsp](#slint_lsp)
- [smarty_ls](#smarty_ls)
- [solang](#solang)
- [solargraph](#solargraph)
- [solc](#solc)
- [solidity](#solidity)
- [solidity_ls](#solidity_ls)
- [sorbet](#sorbet)
- [sourcekit](#sourcekit)
- [sourcery](#sourcery)
- [spectral](#spectral)
- [sqlls](#sqlls)
- [sqls](#sqls)
- [starlark-rust](#starlark-rust)
- [steep](#steep)
- [stylelint_lsp](#stylelint_lsp)
- [sumneko_lua](#sumneko_lua)
- [svelte](#svelte)
- [svlangserver](#svlangserver)
- [svls](#svls)
- [syntax_tree](#syntax_tree)
- [tailwindcss](#tailwindcss)
- [taplo](#taplo)
- [tblgen_lsp_server](#tblgen_lsp_server)
- [teal_ls](#teal_ls)
- [terraform_lsp](#terraform_lsp)
- [terraformls](#terraformls)
- [texlab](#texlab)
- [tflint](#tflint)
- [theme_check](#theme_check)
- [tilt_ls](#tilt_ls)
- [tsserver](#tsserver)
- [turtle_ls](#turtle_ls)
- [typeprof](#typeprof)
- [unison](#unison)
- [vala_ls](#vala_ls)
- [vdmj](#vdmj)
- [verible](#verible)
- [veridian](#veridian)
- [vimls](#vimls)
- [visualforce_ls](#visualforce_ls)
- [vls](#vls)
- [volar](#volar)
- [vuels](#vuels)
- [wgsl_analyzer](#wgsl_analyzer)
- [yamlls](#yamlls)
- [zk](#zk)
- [zls](#zls)

## als

https://github.com/AdaCore/ada_language_server

Installation instructions can be found [here](https://github.com/AdaCore/ada_language_server#Install).

Can be configured by passing a "settings" object to `als.setup{}`:

```lua
require('lspconfig').als.setup{
    settings = {
      ada = {
        projectFile = "project.gpr";
        scenarioVariables = { ... };
      }
    }
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.als.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ada_language_server" }
  ```
  - `filetypes` : 
  ```lua
  { "ada" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("Makefile", ".git", "*.gpr", "*.adc")
  ```


## anakin_language_server

https://pypi.org/project/anakin-language-server/

`anakin-language-server` is yet another Jedi Python language server.

Available options:

* Initialization: https://github.com/muffinmad/anakin-language-server#initialization-option
* Configuration: https://github.com/muffinmad/anakin-language-server#configuration-options
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.anakin_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "anakinls" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    anakinls = {
      pyflakes_errors = { "ImportStarNotPermitted", "UndefinedExport", "UndefinedLocal", "UndefinedName", "DuplicateArgument", "MultiValueRepeatedKeyLiteral", "MultiValueRepeatedKeyVariable", "FutureFeatureNotDefined", "LateFutureImport", "ReturnOutsideFunction", "YieldOutsideFunction", "ContinueOutsideLoop", "BreakOutsideLoop", "TwoStarredExpressions", "TooManyExpressionsInStarredAssignment", "ForwardAnnotationSyntaxError", "RaiseNotImplemented", "StringDotFormatExtraPositionalArguments", "StringDotFormatExtraNamedArguments", "StringDotFormatMissingArgument", "StringDotFormatMixingAutomatic", "StringDotFormatInvalidFormat", "PercentFormatInvalidFormat", "PercentFormatMixedPositionalAndNamed", "PercentFormatUnsupportedFormat", "PercentFormatPositionalCountMismatch", "PercentFormatExtraNamedArguments", "PercentFormatMissingArgument", "PercentFormatExpectedMapping", "PercentFormatExpectedSequence", "PercentFormatStarRequiresSequence" }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## angularls

https://github.com/angular/vscode-ng-language-service

`angular-language-server` can be installed via npm `npm install -g @angular/language-server`.

Note, that if you override the default `cmd`, you must also update `on_new_config` to set `new_config.cmd` during startup.

```lua
local project_library_path = "/path/to/project/lib"
local cmd = {"ngserver", "--stdio", "--tsProbeLocations", project_library_path , "--ngProbeLocations", project_library_path}

require'lspconfig'.angularls.setup{
  cmd = cmd,
  on_new_config = function(new_config,new_root_dir)
    new_config.cmd = cmd
  end,
}
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.angularls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ngserver", "--stdio", "--tsProbeLocations", "", "--ngProbeLocations", "" }
  ```
  - `filetypes` : 
  ```lua
  { "typescript", "html", "typescriptreact", "typescript.tsx" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("angular.json")
  ```


## ansiblels

https://github.com/ansible/ansible-language-server

Language server for the ansible configuration management tool.

`ansible-language-server` can be installed via `npm`:

```sh
npm install -g @ansible/ansible-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.ansiblels.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ansible-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "yaml.ansible" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    ansible = {
      ansible = {
        path = "ansible"
      },
      executionEnvironment = {
        enabled = false
      },
      python = {
        interpreterPath = "python"
      },
      validation = {
        enabled = true,
        lint = {
          enabled = true,
          path = "ansible-lint"
        }
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## antlersls

https://www.npmjs.com/package/antlers-language-server

`antlersls` can be installed via `npm`:
```sh
npm install -g antlers-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.antlersls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "antlersls", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "html", "antlers" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## apex_ls

https://github.com/forcedotcom/salesforcedx-vscode

Language server for Apex.

For manual installation, download the JAR file from the [VSCode
extension](https://github.com/forcedotcom/salesforcedx-vscode/tree/develop/packages/salesforcedx-vscode-apex).

```lua
require'lspconfig'.apex_ls.setup {
  apex_jar_path = '/path/to/apex-jorje-lsp.jar',
  apex_enable_semantic_errors = false, -- Whether to allow Apex Language Server to surface semantic errors
  apex_enable_completion_statistics = false, -- Whether to allow Apex Language Server to collect telemetry on code completion usage
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.apex_ls.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "apexcode" }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern('sfdx-project.json')
  ```


## arduino_language_server

https://github.com/arduino/arduino-language-server

Language server for Arduino

The `arduino-language-server` can be installed by running:

```
go install github.com/arduino/arduino-language-server@latest
```

The `arduino-cli` tool must also be installed. Follow [these
installation instructions](https://arduino.github.io/arduino-cli/latest/installation/) for
your platform.

After installing `arduino-cli`, follow [these
instructions](https://arduino.github.io/arduino-cli/latest/getting-started/#create-a-configuration-file)
for generating a configuration file if you haven't done so already, and make
sure you [install any relevant platforms
libraries](https://arduino.github.io/arduino-cli/latest/getting-started/#install-the-core-for-your-board).
Make sure to save the full path to the created `arduino-cli.yaml` file for later.

The language server also requires `clangd` to be installed. Follow [these
installation instructions](https://clangd.llvm.org/installation) for your
platform.

Next, you will need to decide which FQBN to use.
To identify the available FQBNs for boards you currently have connected, you may use the `arduino-cli` command, like so:

```sh
$ arduino-cli board list
Port         Protocol Type              Board Name  FQBN            Core
/dev/ttyACM0 serial   Serial Port (USB) Arduino Uno arduino:avr:uno arduino:avr
                                                    ^^^^^^^^^^^^^^^
```

After all dependencies are installed you'll need to set the command for the
language server in your setup:

```lua
require'lspconfig'.arduino_language_server.setup {
  cmd = {
    "arduino-language-server",
    "-cli-config", "/path/to/arduino-cli.yaml",
    "-fqbn", "arduino:avr:uno",
    "-cli", "arduino-cli",
    "-clangd", "clangd"
  }
}
```

For further instruction about configuration options, run `arduino-language-server --help`.



**Snippet to enable the language server:**
```lua
require'lspconfig'.arduino_language_server.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "arduino" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## asm_lsp

https://github.com/bergercookie/asm-lsp

Language Server for GAS/GO Assembly

`asm-lsp` can be installed via cargo:
cargo install asm-lsp



**Snippet to enable the language server:**
```lua
require'lspconfig'.asm_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "asm-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "asm", "vmasm" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## astro

https://github.com/withastro/language-tools/tree/main/packages/language-server

`astro-ls` can be installed via `npm`:
```sh
npm install -g @astrojs/language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.astro.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "astro-ls", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "astro" }
  ```
  - `init_options` : 
  ```lua
  {
    configuration = {},
    typescript = {
      serverPath = ""
    }
  }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json", "tsconfig.json", "jsconfig.json", ".git")
  ```


## awk_ls

https://github.com/Beaglefoot/awk-language-server/

`awk-language-server` can be installed via `npm`:
```sh
npm install -g awk-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.awk_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "awk-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "awk" }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## bashls

https://github.com/mads-hartmann/bash-language-server

`bash-language-server` can be installed via `npm`:
```sh
npm i -g bash-language-server
```

Language server for bash, written using tree sitter in typescript.



**Snippet to enable the language server:**
```lua
require'lspconfig'.bashls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "bash-language-server", "start" }
  ```
  - `cmd_env` : 
  ```lua
  {
    GLOB_PATTERN = "*@(.sh|.inc|.bash|.command)"
  }
  ```
  - `filetypes` : 
  ```lua
  { "sh" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## beancount

https://github.com/polarmutex/beancount-language-server#installation

See https://github.com/polarmutex/beancount-language-server#configuration for configuration options



**Snippet to enable the language server:**
```lua
require'lspconfig'.beancount.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "beancount-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "beancount", "bean" }
  ```
  - `init_options` : 
  ```lua
  {
    journalFile = ""
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## bicep

https://github.com/azure/bicep
Bicep language server

Bicep language server can be installed by downloading and extracting a release of bicep-langserver.zip from [Bicep GitHub releases](https://github.com/Azure/bicep/releases).

Bicep language server requires the [dotnet-sdk](https://dotnet.microsoft.com/download) to be installed.

Neovim does not have built-in support for the bicep filetype which is required for lspconfig to automatically launch the language server.

Filetype detection can be added via an autocmd:
```lua
vim.cmd [[ autocmd BufNewFile,BufRead *.bicep set filetype=bicep ]]
```

**By default, bicep language server does not have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path. You must add the following to your init.vim or init.lua to set `cmd` to the absolute path ($HOME and ~ are not expanded) of the unzipped run script or binary.

```lua
local bicep_lsp_bin = "/path/to/bicep-langserver/Bicep.LangServer.dll"
require'lspconfig'.bicep.setup{
    cmd = { "dotnet", bicep_lsp_bin };
    ...
}
```

To download the latest release and place in /usr/local/bin/bicep-langserver:
```bash
(cd $(mktemp -d) \
    && curl -fLO https://github.com/Azure/bicep/releases/latest/download/bicep-langserver.zip \
    && rm -rf /usr/local/bin/bicep-langserver \
    && unzip -d /usr/local/bin/bicep-langserver bicep-langserver.zip)
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.bicep.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "bicep" }
  ```
  - `init_options` : 
  ```lua
  {}
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## blueprint_ls

https://gitlab.gnome.org/jwestman/blueprint-compiler

`blueprint-compiler` can be installed via your system package manager.

Language server for the blurprint markup language, written in python and part
of the blueprint-compiler.



**Snippet to enable the language server:**
```lua
require'lspconfig'.blueprint_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "blueprint-compiler", "lsp" }
  ```
  - `cmd_env` : 
  ```lua
  {
    GLOB_PATTERN = "*@(.blp)"
  }
  ```
  - `filetypes` : 
  ```lua
  { "blueprint" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## bsl_ls

    https://github.com/1c-syntax/bsl-language-server

    Language Server Protocol implementation for 1C (BSL) - 1C:Enterprise 8 and OneScript languages.

    


**Snippet to enable the language server:**
```lua
require'lspconfig'.bsl_ls.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "bsl", "os" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```


## bufls

https://github.com/bufbuild/buf-language-server

`buf-language-server` can be installed via `go install`:
```sh
go install github.com/bufbuild/buf-language-server/cmd/bufls@latest
```

bufls is a Protobuf language server compatible with Buf modules and workspaces



**Snippet to enable the language server:**
```lua
require'lspconfig'.bufls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "bufls", "serve" }
  ```
  - `filetypes` : 
  ```lua
  { "proto" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("buf.work.yaml", ".git")
  ```


## ccls

https://github.com/MaskRay/ccls/wiki

ccls relies on a [JSON compilation database](https://clang.llvm.org/docs/JSONCompilationDatabase.html) specified
as compile_commands.json or, for simpler projects, a .ccls.
For details on how to automatically generate one using CMake look [here](https://cmake.org/cmake/help/latest/variable/CMAKE_EXPORT_COMPILE_COMMANDS.html). Alternatively, you can use [Bear](https://github.com/rizsotto/Bear).

Customization options are passed to ccls at initialization time via init_options, a list of available options can be found [here](https://github.com/MaskRay/ccls/wiki/Customization#initialization-options). For example:

```lua
local lspconfig = require'lspconfig'
lspconfig.ccls.setup {
  init_options = {
    compilationDatabaseDirectory = "build";
    index = {
      threads = 0;
    };
    clang = {
      excludeArgs = { "-frounding-math"} ;
    };
  }
}

```




**Snippet to enable the language server:**
```lua
require'lspconfig'.ccls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ccls" }
  ```
  - `filetypes` : 
  ```lua
  { "c", "cpp", "objc", "objcpp" }
  ```
  - `offset_encoding` : 
  ```lua
  "utf-32"
  ```
  - `root_dir` : 
  ```lua
  root_pattern('compile_commands.json', '.ccls', '.git')
  ```
  - `single_file_support` : 
  ```lua
  false
  ```


## clangd

https://clangd.llvm.org/installation.html

- **NOTE:** Clang >= 11 is recommended! See [#23](https://github.com/neovim/nvim-lsp/issues/23).
- If `compile_commands.json` lives in a build directory, you should
  symlink it to the root of your source tree.
  ```
  ln -s /path/to/myproject/build/compile_commands.json /path/to/myproject/
  ```
- clangd relies on a [JSON compilation database](https://clang.llvm.org/docs/JSONCompilationDatabase.html)
  specified as compile_commands.json, see https://clangd.llvm.org/installation#compile_commandsjson



**Snippet to enable the language server:**
```lua
require'lspconfig'.clangd.setup{}
```
**Commands:**
- ClangdSwitchSourceHeader: Switch between source/header

**Default values:**
  - `capabilities` : 
  ```lua
  default capabilities, with offsetEncoding utf-8
  ```
  - `cmd` : 
  ```lua
  { "clangd" }
  ```
  - `filetypes` : 
  ```lua
  { "c", "cpp", "objc", "objcpp", "cuda", "proto" }
  ```
  - `root_dir` : 
  ```lua
          root_pattern(
            '.clangd',
            '.clang-tidy',
            '.clang-format',
            'compile_commands.json',
            'compile_flags.txt',
            'configure.ac',
            '.git'
          )
        
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## clarity_lsp

`clarity-lsp` is a language server for the Clarity language. Clarity is a decidable smart contract language that optimizes for predictability and security. Smart contracts allow developers to encode essential business logic on a blockchain.

To learn how to configure the clarity language server, see the [clarity-lsp documentation](https://github.com/hirosystems/clarity-lsp).



**Snippet to enable the language server:**
```lua
require'lspconfig'.clarity_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "clarity-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "clar", "clarity" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```


## clojure_lsp

https://github.com/clojure-lsp/clojure-lsp

Clojure Language Server



**Snippet to enable the language server:**
```lua
require'lspconfig'.clojure_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "clojure-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "clojure", "edn" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("project.clj", "deps.edn", "build.boot", "shadow-cljs.edn", ".git")
  ```


## cmake

https://github.com/regen100/cmake-language-server

CMake LSP Implementation



**Snippet to enable the language server:**
```lua
require'lspconfig'.cmake.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "cmake-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "cmake" }
  ```
  - `init_options` : 
  ```lua
  {
    buildDirectory = "build"
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('CMakePresets.json', 'CTestConfig.cmake', '.git', 'build', 'cmake')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## codeqlls

Reference:
https://codeql.github.com/docs/codeql-cli/

Binaries:
https://github.com/github/codeql-cli-binaries
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.codeqlls.setup{}
```


**Default values:**
  - `before_init` : 
  ```lua
  see source file
  ```
  - `cmd` : 
  ```lua
  { "codeql", "execute", "language-server", "--check-errors", "ON_CHANGE", "-q" }
  ```
  - `filetypes` : 
  ```lua
  { "ql" }
  ```
  - `log_level` : 
  ```lua
  2
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    search_path = "list containing all search paths, eg: '~/codeql-home/codeql-repo'"
  }
  ```


## crystalline

https://github.com/elbywan/crystalline

Crystal language server.



**Snippet to enable the language server:**
```lua
require'lspconfig'.crystalline.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "crystalline" }
  ```
  - `filetypes` : 
  ```lua
  { "crystal" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('shard.yml', '.git')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## csharp_ls

https://github.com/razzmatazz/csharp-language-server

Language Server for C#.

csharp-ls requires the [dotnet-sdk](https://dotnet.microsoft.com/download) to be installed.

The preferred way to install csharp-ls is with `dotnet tool install --global csharp-ls`.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.csharp_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "csharp-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "cs" }
  ```
  - `init_options` : 
  ```lua
  {
    AutomaticWorkspaceInit = true
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## cssls


https://github.com/hrsh7th/vscode-langservers-extracted

`css-languageserver` can be installed via `npm`:

```sh
npm i -g vscode-langservers-extracted
```

Neovim does not currently include built-in snippets. `vscode-css-language-server` only provides completions when snippet support is enabled. To enable completion, install a snippet plugin and add the following override to your language client capabilities during setup.

```lua
--Enable (broadcasting) snippet capability for completion
local capabilities = vim.lsp.protocol.make_client_capabilities()
capabilities.textDocument.completion.completionItem.snippetSupport = true

require'lspconfig'.cssls.setup {
  capabilities = capabilities,
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.cssls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vscode-css-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "css", "scss", "less" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json", ".git") or bufdir
  ```
  - `settings` : 
  ```lua
  {
    css = {
      validate = true
    },
    less = {
      validate = true
    },
    scss = {
      validate = true
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## cssmodules_ls

https://github.com/antonk52/cssmodules-language-server

Language server for autocompletion and go-to-definition functionality for CSS modules.

You can install cssmodules-language-server via npm:
```sh
npm install -g cssmodules-language-server
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.cssmodules_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "cssmodules-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "typescript", "typescriptreact" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json")
  ```


## cucumber_language_server

https://cucumber.io
https://github.com/cucumber/common
https://www.npmjs.com/package/@cucumber/language-server

Language server for Cucumber.

`cucumber-language-server` can be installed via `npm`:
```sh
npm install -g @cucumber/language-server
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.cucumber_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "cucumber-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "cucumber" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## dafny

    NeoVim support for the Dafny language server.
    Please follow the instructions and compile the language server from source:
    https://github.com/dafny-lang/language-server-csharp

    Note that there is no default cmd set. You must set it yourself. The recommended way is to use `{"dotnet", "<Path to your language server>"}`.



**Snippet to enable the language server:**
```lua
require'lspconfig'.dafny.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "dfy", "dafny" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## dagger

https://github.com/dagger/cuelsp

Dagger's lsp server for cuelang.



**Snippet to enable the language server:**
```lua
require'lspconfig'.dagger.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "cuelsp" }
  ```
  - `filetypes` : 
  ```lua
  { "cue" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("cue.mod", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## dartls

https://github.com/dart-lang/sdk/tree/master/pkg/analysis_server/tool/lsp_spec

Language server for dart.



**Snippet to enable the language server:**
```lua
require'lspconfig'.dartls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "dart", "language-server", "--protocol=lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "dart" }
  ```
  - `init_options` : 
  ```lua
  {
    closingLabels = true,
    flutterOutline = true,
    onlyAnalyzeProjectsWithOpenFiles = true,
    outline = true,
    suggestFromUnimportedLibraries = true
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("pubspec.yaml")
  ```
  - `settings` : 
  ```lua
  {
    dart = {
      completeFunctionCalls = true,
      showTodos = true
    }
  }
  ```


## denols

https://github.com/denoland/deno

Deno's built-in language server

To appropriately highlight codefences returned from denols, you will need to augment vim.g.markdown_fenced languages
 in your init.lua. Example:

```lua
vim.g.markdown_fenced_languages = {
  "ts=typescript"
}
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.denols.setup{}
```
**Commands:**
- DenolsCache: Cache a module and all of its dependencies.

**Default values:**
  - `cmd` : 
  ```lua
  { "deno", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx", "typescript", "typescriptreact", "typescript.tsx" }
  ```
  - `handlers` : 
  ```lua
  {
    ["textDocument/definition"] = <function 1>,
    ["textDocument/references"] = <function 1>,
    ["workspace/executeCommand"] = <function 2>
  }
  ```
  - `init_options` : 
  ```lua
  {
    enable = true,
    unstable = false
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("deno.json", "deno.jsonc", ".git")
  ```


## dhall_lsp_server

https://github.com/dhall-lang/dhall-haskell/tree/master/dhall-lsp-server

language server for dhall

`dhall-lsp-server` can be installed via cabal:
```sh
cabal install dhall-lsp-server
```
prebuilt binaries can be found [here](https://github.com/dhall-lang/dhall-haskell/releases).



**Snippet to enable the language server:**
```lua
require'lspconfig'.dhall_lsp_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "dhall-lsp-server" }
  ```
  - `filetypes` : 
  ```lua
  { "dhall" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## diagnosticls

https://github.com/iamcco/diagnostic-languageserver

Diagnostic language server integrate with linters.



**Snippet to enable the language server:**
```lua
require'lspconfig'.diagnosticls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "diagnostic-languageserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  Empty by default, override to add filetypes
  ```
  - `root_dir` : 
  ```lua
  Vim's starting directory
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## dockerls

https://github.com/rcjsuen/dockerfile-language-server-nodejs

`docker-langserver` can be installed via `npm`:
```sh
npm install -g dockerfile-language-server-nodejs
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.dockerls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "docker-langserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "dockerfile" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Dockerfile")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## dolmenls

https://github.com/Gbury/dolmen/blob/master/doc/lsp.md

`dolmenls` can be installed via `opam`
```sh
opam install dolmen_lsp
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.dolmenls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "dolmenls" }
  ```
  - `filetypes` : 
  ```lua
  { "smt2", "tptp", "p", "cnf", "icnf", "zf" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## dotls

https://github.com/nikeee/dot-language-server

`dot-language-server` can be installed via `npm`:
```sh
npm install -g dot-language-server
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.dotls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "dot-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "dot" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## efm

https://github.com/mattn/efm-langserver

General purpose Language Server that can use specified error message format generated from specified command.

Requires at minimum EFM version [v0.0.38](https://github.com/mattn/efm-langserver/releases/tag/v0.0.38) to support
launching the language server on single files. If on an older version of EFM, disable single file support:

```lua
require('lspconfig')['efm'].setup{
  settings = ..., -- You must populate this according to the EFM readme
  filetypes = ..., -- Populate this according to the note below
  single_file_support = false, -- This is the important line for supporting older version of EFM
}
```

Note: In order for neovim's built-in language server client to send the appropriate `languageId` to EFM, **you must
specify `filetypes` in your call to `setup{}`**. Otherwise `lspconfig` will launch EFM on the `BufEnter` instead
of the `FileType` autocommand, and the `filetype` variable used to populate the `languageId` will not yet be set.

```lua
require('lspconfig')['efm'].setup{
  settings = ..., -- You must populate this according to the EFM readme
  filetypes = { 'python','cpp','lua' }
}
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.efm.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "efm-langserver" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern(".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## elixirls

https://github.com/elixir-lsp/elixir-ls

`elixir-ls` can be installed by following the instructions [here](https://github.com/elixir-lsp/elixir-ls#building-and-running).

```bash
curl -fLO https://github.com/elixir-lsp/elixir-ls/releases/latest/download/elixir-ls.zip
unzip elixir-ls.zip -d /path/to/elixir-ls
# Unix
chmod +x /path/to/elixir-ls/language_server.sh
```

**By default, elixir-ls doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path. You must add the following to your init.vim or init.lua to set `cmd` to the absolute path ($HOME and ~ are not expanded) of your unzipped elixir-ls.

```lua
require'lspconfig'.elixirls.setup{
    -- Unix
    cmd = { "/path/to/elixir-ls/language_server.sh" };
    -- Windows
    cmd = { "/path/to/elixir-ls/language_server.bat" };
    ...
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.elixirls.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "elixir", "eelixir", "heex", "surface" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("mix.exs", ".git") or vim.loop.os_homedir()
  ```


## elmls

https://github.com/elm-tooling/elm-language-server#installation

If you don't want to use Nvim to install it, then you can use:
```sh
npm install -g elm elm-test elm-format @elm-tooling/elm-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.elmls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "elm-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "elm" }
  ```
  - `init_options` : 
  ```lua
  {
    elmAnalyseTrigger = "change"
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("elm.json")
  ```


## ember

https://github.com/lifeart/ember-language-server

`ember-language-server` can be installed via `npm`:

```sh
npm install -g @lifeart/ember-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.ember.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ember-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "handlebars", "typescript", "javascript" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("ember-cli-build.js", ".git")
  ```


## emmet_ls

https://github.com/aca/emmet-ls

Package can be installed via `npm`:
```sh
npm install -g emmet-ls
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.emmet_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "emmet-ls", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "html", "typescriptreact", "javascriptreact", "css", "sass", "scss", "less", "eruby" }
  ```
  - `root_dir` : 
  ```lua
  git root
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## erg_language_server

https://github.com/erg-lang/erg-language-server

ELS (erg-language-server) is a language server for the Erg programming language.

`els` can be installed via `cargo`:
 ```sh
 cargo install els
 ```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.erg_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "els" }
  ```
  - `filetypes` : 
  ```lua
  { "erg" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.er") or find_git_ancestor
  ```


## erlangls

https://erlang-ls.github.io

Language Server for Erlang.

Clone [erlang_ls](https://github.com/erlang-ls/erlang_ls)
Compile the project with `make` and copy resulting binaries somewhere in your $PATH eg. `cp _build/*/bin/* ~/local/bin`

Installation instruction can be found [here](https://github.com/erlang-ls/erlang_ls).

Installation requirements:
    - [Erlang OTP 21+](https://github.com/erlang/otp)
    - [rebar3 3.9.1+](https://github.com/erlang/rebar3)



**Snippet to enable the language server:**
```lua
require'lspconfig'.erlangls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "erlang_ls" }
  ```
  - `filetypes` : 
  ```lua
  { "erlang" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('rebar.config', 'erlang.mk', '.git')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## esbonio

https://github.com/swyddfa/esbonio

Esbonio is a language server for [Sphinx](https://www.sphinx-doc.org/en/master/) documentation projects.
The language server can be installed via pip

```
pip install esbonio
```

Since Sphinx is highly extensible you will get best results if you install the language server in the same
Python environment as the one used to build your documentation. To ensure that the correct Python environment
is picked up, you can either launch `nvim` with the correct environment activated.

```
source env/bin/activate
nvim
```

Or you can modify the default `cmd` to include the full path to the Python interpreter.

```lua
require'lspconfig'.esbonio.setup {
  cmd = { '/path/to/virtualenv/bin/python', '-m', 'esbonio' }
}
```

Esbonio supports a number of config values passed as `init_options` on startup, for example.

```lua
require'lspconfig'.esbonio.setup {
  init_options = {
    server = {
      logLevel = "debug"
    },
    sphinx = {
      confDir = "/path/to/docs",
      srcDir = "${confDir}/../docs-src"
    }
}
```

A full list and explanation of the available options can be found [here](https://swyddfa.github.io/esbonio/docs/latest/en/lsp/getting-started.html#configuration)



**Snippet to enable the language server:**
```lua
require'lspconfig'.esbonio.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "python3", "-m", "esbonio" }
  ```
  - `filetypes` : 
  ```lua
  { "rst" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## eslint

https://github.com/hrsh7th/vscode-langservers-extracted

`vscode-eslint-language-server` is a linting engine for JavaScript / Typescript.
It can be installed via `npm`:

```sh
npm i -g vscode-langservers-extracted
```

`vscode-eslint-language-server` provides an `EslintFixAll` command that can be used to format a document on save:
```vim
autocmd BufWritePre *.tsx,*.ts,*.jsx,*.js EslintFixAll
```

See [vscode-eslint](https://github.com/microsoft/vscode-eslint/blob/55871979d7af184bf09af491b6ea35ebd56822cf/server/src/eslintServer.ts#L216-L229) for configuration options.

Messages handled in lspconfig: `eslint/openDoc`, `eslint/confirmESLintExecution`, `eslint/probeFailed`, `eslint/noLibrary`

Additional messages you can handle: `eslint/noConfig`



**Snippet to enable the language server:**
```lua
require'lspconfig'.eslint.setup{}
```
**Commands:**
- EslintFixAll: Fix all eslint problems for this buffer

**Default values:**
  - `cmd` : 
  ```lua
  { "vscode-eslint-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx", "typescript", "typescriptreact", "typescript.tsx", "vue", "svelte", "astro" }
  ```
  - `handlers` : 
  ```lua
  {
    ["eslint/confirmESLintExecution"] = <function 1>,
    ["eslint/noLibrary"] = <function 2>,
    ["eslint/openDoc"] = <function 3>,
    ["eslint/probeFailed"] = <function 4>
  }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    codeAction = {
      disableRuleComment = {
        enable = true,
        location = "separateLine"
      },
      showDocumentation = {
        enable = true
      }
    },
    codeActionOnSave = {
      enable = false,
      mode = "all"
    },
    experimental = {
      useFlatConfig = false
    },
    format = true,
    nodePath = "",
    onIgnoredFiles = "off",
    packageManager = "npm",
    problems = {
      shortenToSingleLine = false
    },
    quiet = false,
    rulesCustomizations = {},
    run = "onType",
    useESLintClass = false,
    validate = "on",
    workingDirectory = {
      mode = "location"
    }
  }
  ```


## fennel-ls

https://sr.ht/~xerool/fennel-ls/

A language server for fennel.



**Snippet to enable the language server:**
```lua
require'lspconfig'.fennel-ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "fennel-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "fennel" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## flow

https://flow.org/
https://github.com/facebook/flow

See below for how to setup Flow itself.
https://flow.org/en/docs/install/

See below for lsp command options.

```sh
npx flow lsp --help
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.flow.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "npx", "--no-install", "flow", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".flowconfig")
  ```


## flux_lsp

https://github.com/influxdata/flux-lsp
`flux-lsp` can be installed via `cargo`:
```sh
cargo install --git https://github.com/influxdata/flux-lsp
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.flux_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "flux-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "flux" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## foam_ls

https://github.com/FoamScience/foam-language-server

`foam-language-server` can be installed via `npm`
```sh
npm install -g foam-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.foam_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "foam-ls", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "foam", "OpenFOAM" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## fortls

https://github.com/gnikit/fortls

fortls is a Fortran Language Server, the server can be installed via pip

```sh
pip install fortls
```

Settings to the server can be passed either through the `cmd` option or through
a local configuration file e.g. `.fortls`. For more information
see the `fortls` [documentation](https://gnikit.github.io/fortls/options.html).
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.fortls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "fortls", "--notify_init", "--hover_signature", "--hover_language=fortran", "--use_signature_help" }
  ```
  - `filetypes` : 
  ```lua
  { "fortran" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".fortls")
  ```
  - `settings` : 
  ```lua
  {}
  ```


## fsautocomplete

https://github.com/fsharp/FsAutoComplete

Language Server for F# provided by FsAutoComplete (FSAC).

FsAutoComplete requires the [dotnet-sdk](https://dotnet.microsoft.com/download) to be installed.

The preferred way to install FsAutoComplete is with `dotnet tool install --global fsautocomplete`.

Instructions to compile from source are found on the main [repository](https://github.com/fsharp/FsAutoComplete).

You may also need to configure the filetype as Vim defaults to Forth for `*.fs` files:

`autocmd BufNewFile,BufRead *.fs,*.fsx,*.fsi set filetype=fsharp`

This is automatically done by plugins such as [PhilT/vim-fsharp](https://github.com/PhilT/vim-fsharp), [fsharp/vim-fsharp](https://github.com/fsharp/vim-fsharp), and [adelarsq/neofsharp.vim](https://github.com/adelarsq/neofsharp.vim).

    


**Snippet to enable the language server:**
```lua
require'lspconfig'.fsautocomplete.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "fsautocomplete", "--adaptive-lsp-server-enabled" }
  ```
  - `filetypes` : 
  ```lua
  { "fsharp" }
  ```
  - `init_options` : 
  ```lua
  {
    AutomaticWorkspaceInit = true
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## fsharp_language_server

F# Language Server
https://github.com/faldor20/fsharp-language-server

An implementation of the language server protocol using the F# Compiler Service.

Build the project from source and override the command path to location of DLL.

If filetype determination is not already performed by an available plugin ([PhilT/vim-fsharp](https://github.com/PhilT/vim-fsharp), [fsharp/vim-fsharp](https://github.com/fsharp/vim-fsharp), and [adelarsq/neofsharp.vim](https://github.com/adelarsq/neofsharp.vim).
), then the following must be added to initialization configuration:


`autocmd BufNewFile,BufRead *.fs,*.fsx,*.fsi set filetype=fsharp`



**Snippet to enable the language server:**
```lua
require'lspconfig'.fsharp_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "dotnet", "FSharpLanguageServer.dll" }
  ```
  - `filetypes` : 
  ```lua
  { "fsharp" }
  ```
  - `init_options` : 
  ```lua
  {
    AutomaticWorkspaceInit = true
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## fstar

https://github.com/FStarLang/FStar

LSP support is included in FStar. Make sure `fstar.exe` is in your PATH.



**Snippet to enable the language server:**
```lua
require'lspconfig'.fstar.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "fstar.exe", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "fstar" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## gdscript

https://github.com/godotengine/godot

Language server for GDScript, used by Godot Engine.



**Snippet to enable the language server:**
```lua
require'lspconfig'.gdscript.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  see source file
  ```
  - `filetypes` : 
  ```lua
  { "gd", "gdscript", "gdscript3" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("project.godot", ".git")
  ```


## ghcide

https://github.com/digital-asset/ghcide

A library for building Haskell IDE tooling.
"ghcide" isn't for end users now. Use "haskell-language-server" instead of "ghcide".



**Snippet to enable the language server:**
```lua
require'lspconfig'.ghcide.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ghcide", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "haskell", "lhaskell" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("stack.yaml", "hie-bios", "BUILD.bazel", "cabal.config", "package.yaml")
  ```


## ghdl_ls

https://github.com/ghdl/ghdl-language-server

A language server for VHDL, using ghdl as its backend.

`ghdl-ls` is part of pyghdl, for installation instructions see
[the upstream README](https://github.com/ghdl/ghdl/tree/master/pyGHDL/lsp).



**Snippet to enable the language server:**
```lua
require'lspconfig'.ghdl_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ghdl-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "vhdl" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## gleam

https://github.com/gleam-lang/gleam

A language server for Gleam Programming Language.
[Installation](https://gleam.run/getting-started/installing/)

It can be i



**Snippet to enable the language server:**
```lua
require'lspconfig'.gleam.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "gleam", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "gleam" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("gleam.toml", ".git")
  ```


## glint

  https://github.com/typed-ember/glint

  https://typed-ember.gitbook.io/glint/

  `glint-language-server` is installed when adding `@glint/core` to your project's devDependencies:

  ```sh
  npm install @glint/core --save-dev
  ```

  or

  ```sh
  yarn add -D @glint/core
  ```

  or

  ```sh
  pnpm add -D @glint/core
  ```



**Snippet to enable the language server:**
```lua
require'lspconfig'.glint.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "glint-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "html.handlebars", "handlebars", "typescript", "typescript.glimmer", "javascript", "javascript.glimmer" }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## glslls

https://github.com/svenstaro/glsl-language-server

Language server implementation for GLSL

`glslls` can be compiled and installed manually, or, if your distribution has access to the AUR,
via the `glsl-language-server` AUR package
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.glslls.setup{}
```


**Default values:**
  - `capabilities` : 
  ```lua
  {
    offsetEncoding = { "utf-8", "utf-16" },
    textDocument = {
      completion = {
        editsNearCursor = true
      }
    }
  }
  ```
  - `cmd` : 
  ```lua
  { "glslls", "--stdin" }
  ```
  - `filetypes` : 
  ```lua
  { "glsl" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## golangci_lint_ls

Combination of both lint server and client

https://github.com/nametake/golangci-lint-langserver
https://github.com/golangci/golangci-lint


Installation of binaries needed is done via

```
go install github.com/nametake/golangci-lint-langserver@latest
go install github.com/golangci/golangci-lint/cmd/golangci-lint@latest
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.golangci_lint_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "golangci-lint-langserver" }
  ```
  - `filetypes` : 
  ```lua
  { "go", "gomod" }
  ```
  - `init_options` : 
  ```lua
  {
    command = { "golangci-lint", "run", "--out-format", "json" }
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('go.work') or root_pattern('go.mod', '.golangci.yaml', '.git')
  ```


## gopls

https://github.com/golang/tools/tree/master/gopls

Google's lsp server for golang.



**Snippet to enable the language server:**
```lua
require'lspconfig'.gopls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "gopls" }
  ```
  - `filetypes` : 
  ```lua
  { "go", "gomod", "gowork", "gotmpl" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("go.mod", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## gradle_ls

https://github.com/microsoft/vscode-gradle

Microsoft's lsp server for gradle files

If you're setting this up manually, build vscode-gradle using `./gradlew installDist` and point `cmd` to the `gradle-language-server` generated in the build directory



**Snippet to enable the language server:**
```lua
require'lspconfig'.gradle_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "gradle-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "groovy" }
  ```
  - `init_options` : 
  ```lua
  {
    settings = {
      gradleWrapperEnabled = true
    }
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("settings.gradle")
  ```


## grammarly

https://github.com/znck/grammarly

`grammarly-languageserver` can be installed via `npm`:

```sh
npm i -g grammarly-languageserver
```

WARNING: Since this language server uses Grammarly's API, any document you open with it running is shared with them. Please evaluate their [privacy policy](https://www.grammarly.com/privacy-policy) before using this.



**Snippet to enable the language server:**
```lua
require'lspconfig'.grammarly.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "grammarly-languageserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "markdown" }
  ```
  - `handlers` : 
  ```lua
  {
    ["$/updateDocumentState"] = <function 1>
  }
  ```
  - `init_options` : 
  ```lua
  {
    clientId = "client_BaDkMgx4X19X9UxxYRCXZo"
  }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## graphql

https://github.com/graphql/graphiql/tree/main/packages/graphql-language-service-cli

`graphql-lsp` can be installed via `npm`:

```sh
npm install -g graphql-language-service-cli
```

Note that you must also have [the graphql package](https://github.com/graphql/graphql-js) installed and create a [GraphQL config file](https://www.graphql-config.com/docs/user/user-introduction).



**Snippet to enable the language server:**
```lua
require'lspconfig'.graphql.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "graphql-lsp", "server", "-m", "stream" }
  ```
  - `filetypes` : 
  ```lua
  { "graphql", "typescriptreact", "javascriptreact" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern('.git', '.graphqlrc*', '.graphql.config.*', 'graphql.config.*')
  ```


## groovyls

https://github.com/prominic/groovy-language-server.git

Requirements:
 - Linux/macOS (for now)
 - Java 11+

`groovyls` can be installed by following the instructions [here](https://github.com/prominic/groovy-language-server.git#build).

If you have installed groovy language server, you can set the `cmd` custom path as follow:

```lua
require'lspconfig'.groovyls.setup{
    -- Unix
    cmd = { "java", "-jar", "path/to/groovyls/groovy-language-server-all.jar" },
    ...
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.groovyls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "java", "-jar", "groovy-language-server-all.jar" }
  ```
  - `filetypes` : 
  ```lua
  { "groovy" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## haxe_language_server

https://github.com/vshaxe/haxe-language-server

The Haxe language server can be built by running the following commands from
the project's root directory:

    npm install
    npx lix run vshaxe-build -t language-server

This will create `bin/server.js`. Note that the server requires Haxe 3.4.0 or
higher.

After building the language server, set the `cmd` setting in your setup
function:

```lua
lspconfig.haxe_language_server.setup({
  cmd = {"node", "path/to/bin/server.js"},
})
```

By default, an HXML compiler arguments file named `build.hxml` is expected in
your project's root directory. If your file is named something different,
specify it using the `init_options.displayArguments` setting.



**Snippet to enable the language server:**
```lua
require'lspconfig'.haxe_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "haxe-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "haxe" }
  ```
  - `init_options` : 
  ```lua
  {
    displayArguments = { "build.hxml" }
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("*.hxml")
  ```
  - `settings` : 
  ```lua
  {
    haxe = {
      executable = "haxe"
    }
  }
  ```


## hdl_checker

https://github.com/suoto/hdl_checker
Language server for hdl-checker.
Install using: `pip install hdl-checker --upgrade`



**Snippet to enable the language server:**
```lua
require'lspconfig'.hdl_checker.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "hdl_checker", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "vhdl", "verilog", "systemverilog" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## hhvm

Language server for programs written in Hack
https://hhvm.com/
https://github.com/facebook/hhvm
See below for how to setup HHVM & typechecker:
https://docs.hhvm.com/hhvm/getting-started/getting-started
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.hhvm.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "hh_client", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "php", "hack" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".hhconfig")
  ```


## hie

https://github.com/haskell/haskell-ide-engine

the following init_options are supported (see https://github.com/haskell/haskell-ide-engine#configuration):
```lua
init_options = {
  languageServerHaskell = {
    hlintOn = bool;
    maxNumberOfProblems = number;
    diagnosticsDebounceDuration = number;
    liquidOn = bool (default false);
    completionSnippetsOn = bool (default true);
    formatOnImportOn = bool (default true);
    formattingProvider = string (default "brittany", alternate "floskell");
  }
}
```
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.hie.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "hie-wrapper", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "haskell" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("stack.yaml", "package.yaml", ".git")
  ```


## hls

https://github.com/haskell/haskell-language-server

Haskell Language Server
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.hls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "haskell-language-server-wrapper", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "haskell", "lhaskell" }
  ```
  - `lspinfo` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  function (filepath)
    return (
      util.root_pattern('hie.yaml', 'stack.yaml', 'cabal.project')(filepath)
      or util.root_pattern('*.cabal', 'package.yaml')(filepath)
    )
  end
        
  ```
  - `settings` : 
  ```lua
  {
    haskell = {
      formattingProvider = "ormolu"
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## hoon_ls

https://github.com/urbit/hoon-language-server

A language server for Hoon.

The language server can be installed via `npm install -g @hoon-language-server`

Start a fake ~zod with `urbit -F zod`.
Start the language server at the Urbit Dojo prompt with: `|start %language-server`



**Snippet to enable the language server:**
```lua
require'lspconfig'.hoon_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "hoon-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "hoon" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## html

https://github.com/hrsh7th/vscode-langservers-extracted

`vscode-html-language-server` can be installed via `npm`:
```sh
npm i -g vscode-langservers-extracted
```

Neovim does not currently include built-in snippets. `vscode-html-language-server` only provides completions when snippet support is enabled.
To enable completion, install a snippet plugin and add the following override to your language client capabilities during setup.

The code-formatting feature of the lsp can be controlled with the `provideFormatter` option.

```lua
--Enable (broadcasting) snippet capability for completion
local capabilities = vim.lsp.protocol.make_client_capabilities()
capabilities.textDocument.completion.completionItem.snippetSupport = true

require'lspconfig'.html.setup {
  capabilities = capabilities,
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.html.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vscode-html-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "html" }
  ```
  - `init_options` : 
  ```lua
  {
    configurationSection = { "html", "css", "javascript" },
    embeddedLanguages = {
      css = true,
      javascript = true
    },
    provideFormatter = true
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## idris2_lsp

https://github.com/idris-community/idris2-lsp

The Idris 2 language server.

Plugins for the Idris 2 filetype include
[Idris2-Vim](https://github.com/edwinb/idris2-vim) (fewer features, stable) and
[Nvim-Idris2](https://github.com/ShinKage/nvim-idris2) (cutting-edge,
experimental).

Idris2-Lsp requires a build of Idris 2 that includes the "Idris 2 API" package.
Package managers with known support for this build include the
[AUR](https://aur.archlinux.org/packages/idris2/) and
[Homebrew](https://formulae.brew.sh/formula/idris2#default).

If your package manager does not support the Idris 2 API, you will need to build
Idris 2 from source. Refer to the
[the Idris 2 installation instructions](https://github.com/idris-lang/Idris2/blob/main/INSTALL.md)
for details.  Steps 5 and 8 are listed as "optional" in that guide, but they are
necessary in order to make the Idris 2 API available.

You need to install a version of Idris2-Lsp that is compatible with your
version of Idris 2. There should be a branch corresponding to every released
Idris 2 version after v0.4.0. Use the latest commit on that branch. For example,
if you have Idris v0.5.1, you should use the v0.5.1 branch of Idris2-Lsp.

If your Idris 2 version is newer than the newest Idris2-Lsp branch, use the
latest commit on the `master` branch, and set a reminder to check the Idris2-Lsp
repo for the release of a compatible versioned branch.



**Snippet to enable the language server:**
```lua
require'lspconfig'.idris2_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "idris2-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "idris2" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## intelephense

https://intelephense.com/

`intelephense` can be installed via `npm`:
```sh
npm install -g intelephense
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.intelephense.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "intelephense", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "php" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("composer.json", ".git")
  ```


## java_language_server

https://github.com/georgewfraser/java-language-server

Java language server

Point `cmd` to `lang_server_linux.sh` or the equivalent script for macOS/Windows provided by java-language-server



**Snippet to enable the language server:**
```lua
require'lspconfig'.java_language_server.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "java" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## jdtls

https://projects.eclipse.org/projects/eclipse.jdt.ls

Language server for Java.

IMPORTANT: If you want all the features jdtls has to offer, [nvim-jdtls](https://github.com/mfussenegger/nvim-jdtls)
is highly recommended. If all you need is diagnostics, completion, imports, gotos and formatting and some code actions
you can keep reading here.

For manual installation you can download precompiled binaries from the
[official downloads site](http://download.eclipse.org/jdtls/snapshots/?d)
and ensure that the `PATH` variable contains the `bin` directory of the extracted archive.

```lua
  -- init.lua
  require'lspconfig'.jdtls.setup{}
```

You can also pass extra custom jvm arguments with the JDTLS_JVM_ARGS environment variable as a space separated list of arguments,
that will be converted to multiple --jvm-arg=<param> args when passed to the jdtls script. This will allow for example tweaking
the jvm arguments or integration with external tools like lombok:

```sh
export JDTLS_JVM_ARGS="-javaagent:$HOME/.local/share/java/lombok.jar"
```

For automatic installation you can use the following unofficial installers/launchers under your own risk:
  - [jdtls-launcher](https://github.com/eruizc-dev/jdtls-launcher) (Includes lombok support by default)
    ```lua
      -- init.lua
      require'lspconfig'.jdtls.setup{ cmd = { 'jdtls' } }
    ```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.jdtls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "jdtls", "-configuration", "/home/runner/.cache/jdtls/config", "-data", "/home/runner/.cache/jdtls/workspace" }
  ```
  - `filetypes` : 
  ```lua
  { "java" }
  ```
  - `handlers` : 
  ```lua
  {
    ["$/progress"] = <function 1>,
    ["language/status"] = <function 2>,
    ["textDocument/codeAction"] = <function 3>,
    ["textDocument/rename"] = <function 4>,
    ["workspace/applyEdit"] = <function 5>
  }
  ```
  - `init_options` : 
  ```lua
  {
    jvm_args = {},
    workspace = "/home/runner/.cache/jdtls/workspace"
  }
  ```
  - `root_dir` : 
  ```lua
  {
          -- Single-module projects
          {
            'build.xml', -- Ant
            'pom.xml', -- Maven
            'settings.gradle', -- Gradle
            'settings.gradle.kts', -- Gradle
          },
          -- Multi-module projects
          { 'build.gradle', 'build.gradle.kts' },
        } or vim.fn.getcwd()
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## jedi_language_server

https://github.com/pappasam/jedi-language-server

`jedi-language-server`, a language server for Python, built on top of jedi
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.jedi_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "jedi-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `root_dir` : 
  ```lua
  vim's starting directory
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## jsonls

https://github.com/hrsh7th/vscode-langservers-extracted

vscode-json-language-server, a language server for JSON and JSON schema

`vscode-json-language-server` can be installed via `npm`:
```sh
npm i -g vscode-langservers-extracted
```

Neovim does not currently include built-in snippets. `vscode-json-language-server` only provides completions when snippet support is enabled. To enable completion, install a snippet plugin and add the following override to your language client capabilities during setup.

```lua
--Enable (broadcasting) snippet capability for completion
local capabilities = vim.lsp.protocol.make_client_capabilities()
capabilities.textDocument.completion.completionItem.snippetSupport = true

require'lspconfig'.jsonls.setup {
  capabilities = capabilities,
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.jsonls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vscode-json-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "json", "jsonc" }
  ```
  - `init_options` : 
  ```lua
  {
    provideFormatter = true
  }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## jsonnet_ls

https://github.com/grafana/jsonnet-language-server

A Language Server Protocol (LSP) server for Jsonnet.

The language server can be installed with `go`:
```sh
go install github.com/grafana/jsonnet-language-server@latest
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.jsonnet_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "jsonnet-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "jsonnet", "libsonnet" }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern("jsonnetfile.json")
  ```


## julials

https://github.com/julia-vscode/julia-vscode

LanguageServer.jl can be installed with `julia` and `Pkg`:
```sh
julia --project=~/.julia/environments/nvim-lspconfig -e 'using Pkg; Pkg.add("LanguageServer")'
```
where `~/.julia/environments/nvim-lspconfig` is the location where
the default configuration expects LanguageServer.jl to be installed.

To update an existing install, use the following command:
```sh
julia --project=~/.julia/environments/nvim-lspconfig -e 'using Pkg; Pkg.update()'
```

Note: In order to have LanguageServer.jl pick up installed packages or dependencies in a
Julia project, you must make sure that the project is instantiated:
```sh
julia --project=/path/to/my/project -e 'using Pkg; Pkg.instantiate()'
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.julials.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "julia", "--startup-file=no", "--history-file=no", "-e", '    # Load LanguageServer.jl: attempt to load from ~/.julia/environments/nvim-lspconfig\n    # with the regular load path as a fallback\n    ls_install_path = joinpath(\n        get(DEPOT_PATH, 1, joinpath(homedir(), ".julia")),\n        "environments", "nvim-lspconfig"\n    )\n    pushfirst!(LOAD_PATH, ls_install_path)\n    using LanguageServer\n    popfirst!(LOAD_PATH)\n    depot_path = get(ENV, "JULIA_DEPOT_PATH", "")\n    project_path = let\n        dirname(something(\n            ## 1. Finds an explicitly set project (JULIA_PROJECT)\n            Base.load_path_expand((\n                p = get(ENV, "JULIA_PROJECT", nothing);\n                p === nothing ? nothing : isempty(p) ? nothing : p\n            )),\n            ## 2. Look for a Project.toml file in the current working directory,\n            ##    or parent directories, with $HOME as an upper boundary\n            Base.current_project(),\n            ## 3. First entry in the load path\n            get(Base.load_path(), 1, nothing),\n            ## 4. Fallback to default global environment,\n            ##    this is more or less unreachable\n            Base.load_path_expand("@v#.#"),\n        ))\n    end\n    @info "Running language server" VERSION pwd() project_path depot_path\n    server = LanguageServer.LanguageServerInstance(stdin, stdout, project_path, depot_path)\n    server.runlinter = true\n    run(server)\n  ' }
  ```
  - `filetypes` : 
  ```lua
  { "julia" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## kotlin_language_server

    A kotlin language server which was developed for internal usage and
    released afterwards. Maintaining is not done by the original author,
    but by fwcd.

    It is built via gradle and developed on github.
    Source and additional description:
    https://github.com/fwcd/kotlin-language-server

    This server requires vim to be aware of the kotlin-filetype.
    You could refer for this capability to:
    https://github.com/udalov/kotlin-vim (recommended)
    Note that there is no LICENSE specified yet.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.kotlin_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "kotlin-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "kotlin" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("settings.gradle")
  ```


## lean3ls

https://github.com/leanprover/lean-client-js/tree/master/lean-language-server

Lean installation instructions can be found
[here](https://leanprover-community.github.io/get_started.html#regular-install).

Once Lean is installed, you can install the Lean 3 language server by running
```sh
npm install -g lean-language-server
```

Note: that if you're using [lean.nvim](https://github.com/Julian/lean.nvim),
that plugin fully handles the setup of the Lean language server,
and you shouldn't set up `lean3ls` both with it and `lspconfig`.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.lean3ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "lean-language-server", "--stdio", "--", "-M", "4096", "-T", "100000" }
  ```
  - `filetypes` : 
  ```lua
  { "lean3" }
  ```
  - `offset_encoding` : 
  ```lua
  "utf-32"
  ```
  - `root_dir` : 
  ```lua
  root_pattern("leanpkg.toml") or root_pattern(".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## leanls

https://github.com/leanprover/lean4

Lean installation instructions can be found
[here](https://leanprover-community.github.io/get_started.html#regular-install).

The Lean 4 language server is built-in with a Lean 4 install
(and can be manually run with, e.g., `lean --server`).

Note: that if you're using [lean.nvim](https://github.com/Julian/lean.nvim),
that plugin fully handles the setup of the Lean language server,
and you shouldn't set up `leanls` both with it and `lspconfig`.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.leanls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "lake", "serve", "--" }
  ```
  - `filetypes` : 
  ```lua
  { "lean" }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `options` : 
  ```lua
  {
    no_lake_lsp_cmd = { "lean", "--server" }
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("lakefile.lean", "lean-toolchain", "leanpkg.toml", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## lelwel_ls

https://github.com/0x2a-42/lelwel

Language server for lelwel grammars.

You can install `lelwel-ls` via cargo:
```sh
cargo install --features="lsp" lelwel
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.lelwel_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "lelwel-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "llw" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## lemminx

https://github.com/eclipse/lemminx

The easiest way to install the server is to get a binary from https://github.com/redhat-developer/vscode-xml/releases and place it on your PATH.

NOTE to macOS users: Binaries from unidentified developers are blocked by default. If you trust the downloaded binary, run it once, cancel the prompt, then remove the binary from Gatekeeper quarantine with `xattr -d com.apple.quarantine lemminx`. It should now run without being blocked.




**Snippet to enable the language server:**
```lua
require'lspconfig'.lemminx.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "lemminx" }
  ```
  - `filetypes` : 
  ```lua
  { "xml", "xsd", "xsl", "xslt", "svg" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## ltex

https://github.com/valentjn/ltex-ls

LTeX Language Server: LSP language server for LanguageTool 🔍✔️ with support for LaTeX 🎓, Markdown 📝, and others

To install, download the latest [release](https://github.com/valentjn/ltex-ls/releases) and ensure `ltex-ls` is on your path.

To support org files or R sweave, users can define a custom filetype autocommand (or use a plugin which defines these filetypes):

```lua
vim.cmd [[ autocmd BufRead,BufNewFile *.org set filetype=org ]]
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.ltex.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ltex-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "bib", "gitcommit", "markdown", "org", "plaintex", "rst", "rnoweb", "tex" }
  ```
  - `get_language_id` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## luau_lsp



**Snippet to enable the language server:**
```lua
require'lspconfig'.luau_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "luau-lsp", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "luau" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```


## m68k

https://github.com/grahambates/m68k-lsp

Language server for Motorola 68000 family assembly

`m68k-lsp-server` can be installed via `npm`:

```sh
npm install -g m68k-lsp-server
```

Ensure you are using the 68k asm syntax variant in Neovim.

```lua
vim.g.asmsyntax = 'asm68k'
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.m68k.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "m68k-lsp-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "asm68k" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## marksman

https://github.com/artempyanykh/marksman

Marksman is a Markdown LSP server providing completion, cross-references, diagnostics, and more.

Marksman works on MacOS, Linux, and Windows and is distributed as a self-contained binary for each OS.

Pre-built binaries can be downloaded from https://github.com/artempyanykh/marksman/releases



**Snippet to enable the language server:**
```lua
require'lspconfig'.marksman.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "marksman", "server" }
  ```
  - `filetypes` : 
  ```lua
  { "markdown" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git", ".marksman.toml")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## metals

https://scalameta.org/metals/

Scala language server with rich IDE features.

See full instructions in the Metals documentation:

https://scalameta.org/metals/docs/editors/vim#using-an-alternative-lsp-client

Note: that if you're using [nvim-metals](https://github.com/scalameta/nvim-metals), that plugin fully handles the setup and installation of Metals, and you shouldn't set up Metals both with it and `lspconfig`.

To install Metals, make sure to have [coursier](https://get-coursier.io/docs/cli-installation) installed, and once you do you can install the latest Metals with `cs install metals`.



**Snippet to enable the language server:**
```lua
require'lspconfig'.metals.setup{}
```


**Default values:**
  - `capabilities` : 
  ```lua
  {
    workspace = {
      configuration = false
    }
  }
  ```
  - `cmd` : 
  ```lua
  { "metals" }
  ```
  - `filetypes` : 
  ```lua
  { "scala" }
  ```
  - `init_options` : 
  ```lua
  {
    compilerOptions = {
      snippetAutoIndent = false
    },
    isHttpEnabled = true,
    statusBarProvider = "show-message"
  }
  ```
  - `message_level` : 
  ```lua
  4
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("build.sbt", "build.sc", "build.gradle", "pom.xml")
  ```


## millet

https://github.com/azdavis/millet

Millet, a language server for Standard ML

To use with nvim:

1. Install a Rust toolchain: https://rustup.rs
2. Clone the repo
3. Run `cargo build --release --bin lang-srv`
4. Move `target/release/lang-srv` to somewhere on your $PATH as `millet`
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.millet.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "millet" }
  ```
  - `filetypes` : 
  ```lua
  { "sml" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## mint

https://www.mint-lang.com

Install Mint using the [instructions](https://www.mint-lang.com/install).
The language server is included since version 0.12.0.



**Snippet to enable the language server:**
```lua
require'lspconfig'.mint.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "mint", "ls" }
  ```
  - `filetypes` : 
  ```lua
  { "mint" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## mlir_lsp_server

https://mlir.llvm.org/docs/Tools/MLIRLSP/#mlir-lsp-language-server--mlir-lsp-server=

The Language Server for the LLVM MLIR language

`mlir-lsp-server` can be installed at the llvm-project repository (https://github.com/llvm/llvm-project)



**Snippet to enable the language server:**
```lua
require'lspconfig'.mlir_lsp_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "mlir-lsp-server" }
  ```
  - `filetypes` : 
  ```lua
  { "mlir" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## mlir_pdll_lsp_server

https://mlir.llvm.org/docs/Tools/MLIRLSP/#pdll-lsp-language-server--mlir-pdll-lsp-server

The Language Server for the LLVM PDLL language

`mlir-pdll-lsp-server` can be installed at the llvm-project repository (https://github.com/llvm/llvm-project)



**Snippet to enable the language server:**
```lua
require'lspconfig'.mlir_pdll_lsp_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "mlir-pdll-lsp-server" }
  ```
  - `filetypes` : 
  ```lua
  { "pdll" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## mm0_ls

https://github.com/digama0/mm0

Language Server for the metamath-zero theorem prover.

Requires [mm0-rs](https://github.com/digama0/mm0/tree/master/mm0-rs) to be installed
and available on the `PATH`.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.mm0_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "mm0-rs", "server" }
  ```
  - `filetypes` : 
  ```lua
  { "metamath-zero" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## move_analyzer

https://github.com/move-language/move/tree/main/language/move-analyzer

Language server for Move

The `move-analyzer` can be installed by running:

```
cargo install --git https://github.com/move-language/move move-analyzer
```

See [`move-analyzer`'s doc](https://github.com/move-language/move/blob/1b258a06e3c7d2bc9174578aac92cca3ac19de71/language/move-analyzer/editors/code/README.md#how-to-install) for details.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.move_analyzer.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "move-analyzer" }
  ```
  - `filetypes` : 
  ```lua
  { "move" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Move.toml")
  ```


## neocmake

https://github.com/Decodetalkers/neocmakelsp

CMake LSP Implementation



**Snippet to enable the language server:**
```lua
require'lspconfig'.neocmake.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "neocmakelsp", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "cmake" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('.git', 'cmake')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## nickel_ls

Nickel Language Server

https://github.com/tweag/nickel

`nls` can be installed with nix, or cargo, from the Nickel repository.
```sh
git clone https://github.com/tweag/nickel.git
```

Nix:
```sh
cd nickel
nix-env -f . -i
```

cargo:
```sh
cd nickel/lsp/nls
cargo install --path .
```

In order to have lspconfig detect Nickel filetypes (a prerequisite for autostarting a server),
install the [Nickel vim plugin](https://github.com/nickel-lang/vim-nickel).
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.nickel_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nls" }
  ```
  - `filetypes` : 
  ```lua
  { "ncl", "nickel" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## nil_ls

https://github.com/oxalica/nil

A new language server for Nix Expression Language.

If you are using Nix with Flakes support, run `nix profile install github:oxalica/nil` to install.
Check the repository README for more information.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.nil_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nil" }
  ```
  - `filetypes` : 
  ```lua
  { "nix" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("flake.nix", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## nimls

https://github.com/PMunch/nimlsp

`nimlsp` can be installed via the `nimble` package manager:

```sh
nimble install nimlsp
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.nimls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nimlsp" }
  ```
  - `filetypes` : 
  ```lua
  { "nim" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## ntt

https://github.com/nokia/ntt
Installation instructions can be found [here](https://github.com/nokia/ntt#Install).
Can be configured by passing a "settings" object to `ntt.setup{}`:
```lua
require('lspconfig').ntt.setup{
    settings = {
      ntt = {
      }
    }
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.ntt.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ntt", "langserver" }
  ```
  - `filetypes` : 
  ```lua
  { "ttcn" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern(".git")
  ```


## nxls

https://github.com/nrwl/nx-console/tree/master/apps/nxls

nxls, a language server for Nx Workspaces

`nxls` can be installed via `npm`:
```sh
npm i -g nxls
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.nxls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nxls", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "json", "jsonc" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern
  ```


## ocamlls

https://github.com/ocaml-lsp/ocaml-language-server

`ocaml-language-server` can be installed via `npm`
```sh
npm install -g ocaml-language-server
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.ocamlls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ocaml-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "ocaml", "reason" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("*.opam", "esy.json", "package.json")
  ```


## ocamllsp

https://github.com/ocaml/ocaml-lsp

`ocaml-lsp` can be installed as described in [installation guide](https://github.com/ocaml/ocaml-lsp#installation).

To install the lsp server in a particular opam switch:
```sh
opam install ocaml-lsp-server
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.ocamllsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ocamllsp" }
  ```
  - `filetypes` : 
  ```lua
  { "ocaml", "ocaml.menhir", "ocaml.interface", "ocaml.ocamllex", "reason", "dune" }
  ```
  - `get_language_id` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern("*.opam", "esy.json", "package.json", ".git", "dune-project", "dune-workspace")
  ```


## ols

           https://github.com/DanielGavin/ols

           `Odin Language Server`.
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.ols.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ols" }
  ```
  - `filetypes` : 
  ```lua
  { "odin" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("ols.json", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## omnisharp

https://github.com/omnisharp/omnisharp-roslyn
OmniSharp server based on Roslyn workspaces

`omnisharp-roslyn` can be installed by downloading and extracting a release from [here](https://github.com/OmniSharp/omnisharp-roslyn/releases).
OmniSharp can also be built from source by following the instructions [here](https://github.com/omnisharp/omnisharp-roslyn#downloading-omnisharp).

OmniSharp requires the [dotnet-sdk](https://dotnet.microsoft.com/download) to be installed.

**By default, omnisharp-roslyn doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path. You must add the following to your init.vim or init.lua to set `cmd` to the absolute path ($HOME and ~ are not expanded) of the unzipped run script or binary.

```lua
require'lspconfig'.omnisharp.setup {
    cmd = { "dotnet", "/path/to/omnisharp/OmniSharp.dll" },

    -- Enables support for reading code style, naming convention and analyzer
    -- settings from .editorconfig.
    enable_editorconfig_support = true,

    -- If true, MSBuild project system will only load projects for files that
    -- were opened in the editor. This setting is useful for big C# codebases
    -- and allows for faster initialization of code navigation features only
    -- for projects that are relevant to code that is being edited. With this
    -- setting enabled OmniSharp may load fewer projects and may thus display
    -- incomplete reference lists for symbols.
    enable_ms_build_load_projects_on_demand = false,

    -- Enables support for roslyn analyzers, code fixes and rulesets.
    enable_roslyn_analyzers = false,

    -- Specifies whether 'using' directives should be grouped and sorted during
    -- document formatting.
    organize_imports_on_format = false,

    -- Enables support for showing unimported types and unimported extension
    -- methods in completion lists. When committed, the appropriate using
    -- directive will be added at the top of the current file. This option can
    -- have a negative impact on initial completion responsiveness,
    -- particularly for the first few completion sessions after opening a
    -- solution.
    enable_import_completion = false,

    -- Specifies whether to include preview versions of the .NET SDK when
    -- determining which version to use for project loading.
    sdk_include_prereleases = true,

    -- Only run analyzers against open files when 'enableRoslynAnalyzers' is
    -- true
    analyze_open_documents_only = false,
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.omnisharp.setup{}
```


**Default values:**
  - `analyze_open_documents_only` : 
  ```lua
  false
  ```
  - `enable_editorconfig_support` : 
  ```lua
  true
  ```
  - `enable_import_completion` : 
  ```lua
  false
  ```
  - `enable_ms_build_load_projects_on_demand` : 
  ```lua
  false
  ```
  - `enable_roslyn_analyzers` : 
  ```lua
  false
  ```
  - `filetypes` : 
  ```lua
  { "cs", "vb" }
  ```
  - `init_options` : 
  ```lua
  {}
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `organize_imports_on_format` : 
  ```lua
  false
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".sln") or root_pattern(".csproj")
  ```
  - `sdk_include_prereleases` : 
  ```lua
  true
  ```


## opencl_ls

https://github.com/Galarius/opencl-language-server

Build instructions can be found [here](https://github.com/Galarius/opencl-language-server/blob/main/_dev/build.md).

Prebuilt binaries are available for Linux, macOS and Windows [here](https://github.com/Galarius/opencl-language-server/releases).



**Snippet to enable the language server:**
```lua
require'lspconfig'.opencl_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "opencl-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "opencl" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern(".git")
  ```


## openscad_ls

https://github.com/dzhu/openscad-language-server

A Language Server Protocol server for OpenSCAD

You can build and install `openscad-language-server` binary with `cargo`:
```sh
cargo install openscad-language-server
```

Vim does not have built-in syntax for the `openscad` filetype currently.

This can be added via an autocmd:

```lua
vim.cmd [[ autocmd BufRead,BufNewFile *.scad set filetype=openscad ]]
```

or by installing a filetype plugin such as https://github.com/sirtaj/vim-openscad



**Snippet to enable the language server:**
```lua
require'lspconfig'.openscad_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "openscad-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "openscad" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## pasls

https://github.com/genericptr/pascal-language-server

An LSP server implementation for Pascal variants that are supported by Free Pascal, including Object Pascal. It uses CodeTools from Lazarus as backend.

First set `cmd` to the Pascal lsp binary.

Customization options are passed to pasls as environment variables for example in your `.bashrc`:
```bash
export FPCDIR='/usr/lib/fpc/src'      # FPC source directory (This is the only required option for the server to work).
export PP='/usr/lib/fpc/3.2.2/ppcx64' # Path to the Free Pascal compiler executable.
export LAZARUSDIR='/usr/lib/lazarus'  # Path to the Lazarus sources.
export FPCTARGET=''                   # Target operating system for cross compiling.
export FPCTARGETCPU='x86_64'          # Target CPU for cross compiling.
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.pasls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "pasls" }
  ```
  - `filetypes` : 
  ```lua
  { "pascal" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## perlls

https://github.com/richterger/Perl-LanguageServer/tree/master/clients/vscode/perl

`Perl-LanguageServer`, a language server for Perl.

To use the language server, ensure that you have Perl::LanguageServer installed and perl command is on your path.



**Snippet to enable the language server:**
```lua
require'lspconfig'.perlls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "perl", "-MPerl::LanguageServer", "-e", "Perl::LanguageServer::run", "--", "--port 13603", "--nostdio 0", "--version 2.1.0" }
  ```
  - `filetypes` : 
  ```lua
  { "perl" }
  ```
  - `root_dir` : 
  ```lua
  vim's starting directory
  ```
  - `settings` : 
  ```lua
  {
    perl = {
      fileFilter = { ".pm", ".pl" },
      ignoreDirs = ".git",
      perlCmd = "perl",
      perlInc = " "
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## perlnavigator

https://github.com/bscan/PerlNavigator

A Perl language server

**By default, perlnavigator doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path.
You have to install the language server manually.

Clone the PerlNavigator repo, install based on the [instructions](https://github.com/bscan/PerlNavigator#installation-for-other-editors),
and point `cmd` to `server.js` inside the `server/out` directory:

```lua
cmd = {'node', '<path_to_repo>/server/out/server.js', '--stdio'}
```

At minimum, you will need `perl` in your path. If you want to use a non-standard `perl` you will need to set your configuration like so:
```lua
settings = {
  perlnavigator = {
    perlPath = '/some/odd/location/my-perl'
  }
}
```

The `contributes.configuration.properties` section of `perlnavigator`'s `package.json` has all available configuration settings. All
settings have a reasonable default, but, at minimum, you may want to point `perlnavigator` at your `perltidy` and `perlcritic` configurations.



**Snippet to enable the language server:**
```lua
require'lspconfig'.perlnavigator.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  {}
  ```
  - `filetypes` : 
  ```lua
  { "perl" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## perlpls

https://github.com/FractalBoy/perl-language-server
https://metacpan.org/pod/PLS

`PLS`, another language server for Perl.

To use the language server, ensure that you have PLS installed and that it is in your path



**Snippet to enable the language server:**
```lua
require'lspconfig'.perlpls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "pls" }
  ```
  - `filetypes` : 
  ```lua
  { "perl" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `settings` : 
  ```lua
  {
    perl = {
      perlcritic = {
        enabled = false
      },
      syntax = {
        enabled = true
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## phan

https://github.com/phan/phan

Installation: https://github.com/phan/phan#getting-started



**Snippet to enable the language server:**
```lua
require'lspconfig'.phan.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "phan", "-m", "json", "--no-color", "--no-progress-bar", "-x", "-u", "-S", "--language-server-on-stdin", "--allow-polyfill-parser" }
  ```
  - `filetypes` : 
  ```lua
  { "php" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("composer.json", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## phpactor

https://github.com/phpactor/phpactor

Installation: https://phpactor.readthedocs.io/en/master/usage/standalone.html#global-installation



**Snippet to enable the language server:**
```lua
require'lspconfig'.phpactor.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "phpactor", "language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "php" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("composer.json", ".git")
  ```


## please

https://github.com/thought-machine/please

High-performance extensible build system for reproducible multi-language builds.

The `plz` binary will automatically install the LSP for you on first run



**Snippet to enable the language server:**
```lua
require'lspconfig'.please.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "plz", "tool", "lps" }
  ```
  - `filetypes` : 
  ```lua
  { "bzl" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## powershell_es

https://github.com/PowerShell/PowerShellEditorServices

Language server for PowerShell.

To install, download and extract PowerShellEditorServices.zip
from the [releases](https://github.com/PowerShell/PowerShellEditorServices/releases).
To configure the language server, set the property `bundle_path` to the root
of the extracted PowerShellEditorServices.zip.

The default configuration doesn't set `cmd` unless `bundle_path` is specified.

```lua
require'lspconfig'.powershell_es.setup{
  bundle_path = 'c:/w/PowerShellEditorServices',
}
```

By default the languageserver is started in `pwsh` (PowerShell Core). This can be changed by specifying `shell`.

```lua
require'lspconfig'.powershell_es.setup{
  bundle_path = 'c:/w/PowerShellEditorServices',
  shell = 'powershell.exe',
}
```

Note that the execution policy needs to be set to `Unrestricted` for the languageserver run under PowerShell

If necessary, specific `cmd` can be defined instead of `bundle_path`.
See [PowerShellEditorServices](https://github.com/PowerShell/PowerShellEditorServices#stdio)
to learn more.

```lua
require'lspconfig'.powershell_es.setup{
  cmd = {'pwsh', '-NoLogo', '-NoProfile', '-Command', "c:/PSES/Start-EditorServices.ps1 ..."}
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.powershell_es.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "ps1" }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  git root or current directory
  ```
  - `shell` : 
  ```lua
  "pwsh"
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## prismals

Language Server for the Prisma JavaScript and TypeScript ORM

`@prisma/language-server` can be installed via npm
```sh
npm install -g @prisma/language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.prismals.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "prisma-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "prisma" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git", "package.json")
  ```
  - `settings` : 
  ```lua
  {
    prisma = {
      prismaFmtBinPath = ""
    }
  }
  ```


## prolog_ls

  https://github.com/jamesnvc/lsp_server

  Language Server Protocol server for SWI-Prolog
  


**Snippet to enable the language server:**
```lua
require'lspconfig'.prolog_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "swipl", "-g", "use_module(library(lsp_server)).", "-g", "lsp_server:main", "-t", "halt", "--", "stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "prolog" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## prosemd_lsp

https://github.com/kitten/prosemd-lsp

An experimental LSP for Markdown.

Please see the manual installation instructions: https://github.com/kitten/prosemd-lsp#manual-installation



**Snippet to enable the language server:**
```lua
require'lspconfig'.prosemd_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "prosemd-lsp", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "markdown" }
  ```
  - `root_dir` : 
  ```lua
  <function 1>
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## psalm

https://github.com/vimeo/psalm

Can be installed with composer.
```sh
composer global require vimeo/psalm
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.psalm.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "psalm-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "php" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("psalm.xml", "psalm.xml.dist")
  ```


## puppet

LSP server for Puppet.

Installation:

- Clone the editor-services repository:
    https://github.com/puppetlabs/puppet-editor-services

- Navigate into that directory and run: `bundle install`

- Install the 'puppet-lint' gem: `gem install puppet-lint`

- Add that repository to $PATH.

- Ensure you can run `puppet-languageserver` from outside the editor-services directory.



**Snippet to enable the language server:**
```lua
require'lspconfig'.puppet.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "puppet-languageserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "puppet" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("manifests", ".puppet-lint.rc", "hiera.yaml", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## purescriptls

https://github.com/nwolverson/purescript-language-server

The `purescript-language-server` can be added to your project and `$PATH` via

* JavaScript package manager such as npm, pnpm, Yarn, et al.
* Nix under the `nodePackages` and `nodePackages_latest` package sets



**Snippet to enable the language server:**
```lua
require'lspconfig'.purescriptls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "purescript-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "purescript" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('spago.dhall', 'psc-package.json', 'bower.json', 'flake.nix', 'shell.nix'),
  ```


## pylsp

https://github.com/python-lsp/python-lsp-server

A Python 3.6+ implementation of the Language Server Protocol.

See the [project's README](https://github.com/python-lsp/python-lsp-server) for installation instructions.

Configuration options are documented [here](https://github.com/python-lsp/python-lsp-server/blob/develop/CONFIGURATION.md).
In order to configure an option, it must be translated to a nested Lua table and included in the `settings` argument to the `setup{}` function.
For example, in order to set the `pylsp.plugins.pycodestyle.ignore` option:
```lua
require'lspconfig'.pylsp.setup{
  settings = {
    pylsp = {
      plugins = {
        pycodestyle = {
          ignore = {'W391'},
          maxLineLength = 100
        }
      }
    }
  }
}
```

Note: This is a community fork of `pyls`.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.pylsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "pylsp" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## pyre

https://pyre-check.org/

`pyre` a static type checker for Python 3.

`pyre` offers an extremely limited featureset. It currently only supports diagnostics,
which are triggered on save.

Do not report issues for missing features in `pyre` to `lspconfig`.




**Snippet to enable the language server:**
```lua
require'lspconfig'.pyre.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "pyre", "persistent" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## pyright

https://github.com/microsoft/pyright

`pyright`, a static type checker and language server for python



**Snippet to enable the language server:**
```lua
require'lspconfig'.pyright.setup{}
```
**Commands:**
- PyrightOrganizeImports: Organize Imports

**Default values:**
  - `cmd` : 
  ```lua
  { "pyright-langserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    python = {
      analysis = {
        autoSearchPaths = true,
        diagnosticMode = "workspace",
        useLibraryCodeForTypes = true
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## qml_lsp

https://invent.kde.org/sdk/qml-lsp

LSP implementation for QML (autocompletion, live linting, etc. in editors)
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.qml_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "qml-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "qmljs" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## qmlls

https://github.com/qt/qtdeclarative

LSP implementation for QML (autocompletion, live linting, etc. in editors),
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.qmlls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "qmlls" }
  ```
  - `filetypes` : 
  ```lua
  { "qmljs" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## quick_lint_js

https://quick-lint-js.com/

quick-lint-js finds bugs in JavaScript programs.

See installation [instructions](https://quick-lint-js.com/install/)



**Snippet to enable the language server:**
```lua
require'lspconfig'.quick_lint_js.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "quick-lint-js", "--lsp-server" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## r_language_server

[languageserver](https://github.com/REditorSupport/languageserver) is an
implementation of the Microsoft's Language Server Protocol for the R
language.

It is released on CRAN and can be easily installed by

```R
install.packages("languageserver")
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.r_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "R", "--slave", "-e", "languageserver::run()" }
  ```
  - `filetypes` : 
  ```lua
  { "r", "rmd" }
  ```
  - `log_level` : 
  ```lua
  2
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git") or os_homedir
  ```


## racket_langserver

[https://github.com/jeapostrophe/racket-langserver](https://github.com/jeapostrophe/racket-langserver)

The Racket language server. This project seeks to use
[DrRacket](https://github.com/racket/drracket)'s public API to provide
functionality that mimics DrRacket's code tools as closely as possible.

Install via `raco`: `raco pkg install racket-langserver`



**Snippet to enable the language server:**
```lua
require'lspconfig'.racket_langserver.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "racket", "--lib", "racket-langserver" }
  ```
  - `filetypes` : 
  ```lua
  { "racket", "scheme" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## reason_ls

Reason language server

You can install reason language server from [reason-language-server](https://github.com/jaredly/reason-language-server) repository.



**Snippet to enable the language server:**
```lua
require'lspconfig'.reason_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "reason-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "reason" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## relay_lsp

    https://github.com/facebook/relay
    `Relay` is a JavaScript framework for building data-driven React applications

    Setup:

    - Make sure you have a Relay config file somewhere in your project.
    - We support standard config file formats (`.yml`, `.js`, `.json`), and the the `relay` field in your `package.json`
    - Make sure you have the `relay-compiler` installed in your project. The bare minimum is v13.
    - Make sure you are able to run the `relay-compiler` command from the command line. If `yarn relay-compiler` works, it's very likely that the LSP will work.
    - Remove / disable any conflicting GraphQL LSPs you have installed.

    Relay LSP is a part of the Relay Compiler binary and available when adding `relay-compiler` to your project's devDependencies.

    ```lua
    require'lspconfig'.relay_lsp.setup {
      -- (default: false) Whether or not we should automatically start
      -- the Relay Compiler in watch mode when you open a project
      auto_start_compiler = false,


      -- (default: null) Path to a relay config relative to the
      -- `root_dir`. Without this, the compiler will search for your
      -- config. This is helpful if your relay project is in a nested
      -- directory.
      path_to_config = nil,
    }
    ```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.relay_lsp.setup{}
```


**Default values:**
  - `auto_start_compiler` : 
  ```lua
  false
  ```
  - `cmd` : 
  ```lua
  { "relay-compiler", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx", "typescript", "typescriptreact", "typescript.tsx" }
  ```
  - `handlers` : 
  ```lua
  {
    ["window/showStatus"] = <function 1>
  }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern("relay.config.*", "package.json")
  ```


## remark_ls

https://github.com/remarkjs/remark-language-server

`remark-language-server` can be installed via `npm`:
```sh
npm install -g remark-language-server
```

`remark-language-server` uses the same
[configuration files](https://github.com/remarkjs/remark/tree/main/packages/remark-cli#example-config-files-json-yaml-js)
as `remark-cli`.

This uses a plugin based system. Each plugin needs to be installed locally using `npm` or `yarn`.

For example, given the following `.remarkrc.json`:

```json
{
  "presets": [
    "remark-preset-lint-recommended"
  ]
}
```

`remark-preset-lint-recommended` needs to be installed in the local project:

```sh
npm install remark-preset-lint-recommended
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.remark_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "remark-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "markdown" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## rescriptls

https://github.com/rescript-lang/rescript-vscode

ReScript language server

**By default, rescriptls doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path.
You have to install the language server manually.

You can use the bundled language server inside the [vim-rescript](https://github.com/rescript-lang/vim-rescript) repo.

Clone the vim-rescript repo and point `cmd` to `server.js` inside `server/out` directory:

```lua
cmd = {'node', '<path_to_repo>/server/out/server.js', '--stdio'}

```

If you have vim-rescript installed you can also use that installation. for example if you're using packer.nvim you can set cmd to something like this:

```lua
cmd = {
  'node',
  '/home/username/.local/share/nvim/site/pack/packer/start/vim-rescript/server/out/server.js',
  '--stdio'
}
```

Another option is to use vscode extension [release](https://github.com/rescript-lang/rescript-vscode/releases).
Take a look at [here](https://github.com/rescript-lang/rescript-vscode#use-with-other-editors) for instructions.



**Snippet to enable the language server:**
```lua
require'lspconfig'.rescriptls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  {}
  ```
  - `filetypes` : 
  ```lua
  { "rescript" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## rls

https://github.com/rust-lang/rls

rls, a language server for Rust

See https://github.com/rust-lang/rls#setup to setup rls itself.
See https://github.com/rust-lang/rls#configuration for rls-specific settings.
All settings listed on the rls configuration section of the readme
must be set under settings.rust as follows:

```lua
nvim_lsp.rls.setup {
  settings = {
    rust = {
      unstable_features = true,
      build_on_save = false,
      all_features = true,
    },
  },
}
```

If you want to use rls for a particular build, eg nightly, set cmd as follows:

```lua
cmd = {"rustup", "run", "nightly", "rls"}
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.rls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "rls" }
  ```
  - `filetypes` : 
  ```lua
  { "rust" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Cargo.toml")
  ```


## rnix

https://github.com/nix-community/rnix-lsp

A language server for Nix providing basic completion and formatting via nixpkgs-fmt.

To install manually, run `cargo install rnix-lsp`. If you are using nix, rnix-lsp is in nixpkgs.

This server accepts configuration via the `settings` key.

    


**Snippet to enable the language server:**
```lua
require'lspconfig'.rnix.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "rnix-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "nix" }
  ```
  - `init_options` : 
  ```lua
  {}
  ```
  - `root_dir` : 
  ```lua
  vim's starting directory
  ```
  - `settings` : 
  ```lua
  {}
  ```


## robotframework_ls

https://github.com/robocorp/robotframework-lsp

Language Server Protocol implementation for Robot Framework.



**Snippet to enable the language server:**
```lua
require'lspconfig'.robotframework_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "robotframework_ls" }
  ```
  - `filetypes` : 
  ```lua
  { "robot" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern('robotidy.toml', 'pyproject.toml')(fname) or util.find_git_ancestor(fname)
  ```


## rome

https://rome.tools

Language server for the Rome Frontend Toolchain.

```sh
npm install [-g] rome
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.rome.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "rome", "lsp-proxy" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "json", "typescript", "typescript.tsx", "typescriptreact" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('package.json', 'node_modules', '.git')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## ruby_ls

https://shopify.github.io/ruby-lsp/

This gem is an implementation of the language server protocol specification for
Ruby, used to improve editor features.

Install the gem. There's no need to require it, since the server is used as a
standalone executable.

```sh
group :development do
  gem "ruby-lsp", require: false
end
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.ruby_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ruby-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby" }
  ```
  - `init_options` : 
  ```lua
  {
    enabledFeatures = { "codeActions", "diagnostics", "documentHighlights", "documentSymbols", "formatting", "inlayHint" }
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Gemfile", ".git")
  ```


## rust_analyzer

https://github.com/rust-analyzer/rust-analyzer

rust-analyzer (aka rls 2.0), a language server for Rust

See [docs](https://github.com/rust-analyzer/rust-analyzer/tree/master/docs/user#settings) for extra settings.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.rust_analyzer.setup{}
```
**Commands:**
- CargoReload: Reload current cargo workspace

**Default values:**
  - `cmd` : 
  ```lua
  { "rust-analyzer" }
  ```
  - `filetypes` : 
  ```lua
  { "rust" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Cargo.toml", "rust-project.json")
  ```
  - `settings` : 
  ```lua
  {
    ["rust-analyzer"] = {}
  }
  ```


## salt_ls

Language server for Salt configuration files.
https://github.com/dcermak/salt-lsp

The language server can be installed with `pip`:
```sh
pip install salt-lsp
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.salt_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "salt_lsp_server" }
  ```
  - `filetypes` : 
  ```lua
  { "sls" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('.git')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## scheme_langserver

https://github.com/ufo5260987423/scheme-langserver
`scheme-langserver`, a language server protocol implementation for scheme.
And for nvim user, please add .sls to scheme file extension list.



**Snippet to enable the language server:**
```lua
require'lspconfig'.scheme_langserver.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "scheme-langserver" }
  ```
  - `filetypes` : 
  ```lua
  { "scheme" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## scry

https://github.com/crystal-lang-tools/scry

Crystal language server.



**Snippet to enable the language server:**
```lua
require'lspconfig'.scry.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "scry" }
  ```
  - `filetypes` : 
  ```lua
  { "crystal" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('shard.yml', '.git')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## serve_d

           https://github.com/Pure-D/serve-d

           `Microsoft language server protocol implementation for D using workspace-d.`
           Download a binary from https://github.com/Pure-D/serve-d/releases and put it in your $PATH.
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.serve_d.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "serve-d" }
  ```
  - `filetypes` : 
  ```lua
  { "d" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("dub.json", "dub.sdl", ".git")
  ```


## sixtyfps

https://github.com/sixtyfpsui/sixtyfps
`SixtyFPS`'s language server

You can build and install `sixtyfps-lsp` binary with `cargo`:
```sh
cargo install sixtyfps-lsp
```

Vim does not have built-in syntax for the `sixtyfps` filetype currently.

This can be added via an autocmd:

```lua
vim.cmd [[ autocmd BufRead,BufNewFile *.60 set filetype=sixtyfps ]]
```

or by installing a filetype plugin such as https://github.com/RustemB/sixtyfps-vim



**Snippet to enable the language server:**
```lua
require'lspconfig'.sixtyfps.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "sixtyfps-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "sixtyfps" }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## slint_lsp

https://github.com/slint-ui/slint
`Slint`'s language server

You can build and install `slint-lsp` binary with `cargo`:
```sh
cargo install slint-lsp
```

Vim does not have built-in syntax for the `slint` filetype at this time.

This can be added via an autocmd:

```lua
vim.cmd [[ autocmd BufRead,BufNewFile *.slint set filetype=slint ]]
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.slint_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "slint-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "slint" }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## smarty_ls

https://github.com/landeaux/vscode-smarty-langserver-extracted

Language server for Smarty.

`smarty-language-server` can be installed via `npm`:

```sh
npm i -g vscode-smarty-langserver-extracted
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.smarty_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "smarty-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "smarty" }
  ```
  - `init_options` : 
  ```lua
  {}
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    css = {
      validate = true
    },
    smarty = {
      pluginDirs = {}
    }
  }
  ```


## solang

A language server for Solidity

See the [documentation](https://solang.readthedocs.io/en/latest/installing.html) for installation instructions.

The language server only provides the following capabilities:
* Syntax highlighting
* Diagnostics
* Hover

There is currently no support for completion, goto definition, references, or other functionality.




**Snippet to enable the language server:**
```lua
require'lspconfig'.solang.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "solang", "--language-server", "--target", "ewasm" }
  ```
  - `filetypes` : 
  ```lua
  { "solidity" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## solargraph

https://solargraph.org/

solargraph, a language server for Ruby

You can install solargraph via gem install.

```sh
gem install --user-install solargraph
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.solargraph.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "solargraph", "stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby" }
  ```
  - `init_options` : 
  ```lua
  {
    formatting = true
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Gemfile", ".git")
  ```
  - `settings` : 
  ```lua
  {
    solargraph = {
      diagnostics = true
    }
  }
  ```


## solc

https://docs.soliditylang.org/en/latest/installing-solidity.html

solc is the native language server for the Solidity language.



**Snippet to enable the language server:**
```lua
require'lspconfig'.solc.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "solc", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "solidity" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('hardhat.config.*', '.git')
  ```


## solidity

https://github.com/qiuxiang/solidity-ls

npm i solidity-ls -g

Make sure that solc is installed and it's the same version of the file.  solc-select is recommended.

Solidity language server is a LSP with autocomplete, go to definition and diagnostics.

If you use brownie, use this root_dir:
root_dir = util.root_pattern('brownie-config.yaml', '.git')

on includePath, you can add an extra path to search for external libs, on remapping you can remap lib <> path, like:

```lua
{ solidity = { includePath = '/Users/your_user/.brownie/packages/', remapping = { ["@OpenZeppelin/"] = 'OpenZeppelin/openzeppelin-contracts@4.6.0/' } } }
```

**For brownie users**
Change the root_dir to:

```lua
root_pattern("brownie-config.yaml", ".git")
```

The best way of using it is to have a package.json in your project folder with the packages that you will use.
After installing with package.json, just create a `remappings.txt` with:

```
@OpenZeppelin/=node_modules/OpenZeppelin/openzeppelin-contracts@4.6.0/
```

You can omit the node_modules as well.



**Snippet to enable the language server:**
```lua
require'lspconfig'.solidity.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "solidity-ls", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "solidity" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json", ".git")
  ```
  - `settings` : 
  ```lua
  {
    solidity = {
      includePath = "",
      remapping = {}
    }
  }
  ```


## solidity_ls

npm install -g solidity-language-server

solidity-language-server is a language server for the solidity language ported from the vscode solidity extension



**Snippet to enable the language server:**
```lua
require'lspconfig'.solidity_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "solidity-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "solidity" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git", "package.json")
  ```


## sorbet

https://sorbet.org

Sorbet is a fast, powerful type checker designed for Ruby.

You can install Sorbet via gem install. You might also be interested in how to set
Sorbet up for new projects: https://sorbet.org/docs/adopting.

```sh
gem install sorbet
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.sorbet.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "srb", "tc", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Gemfile", ".git")
  ```


## sourcekit

https://github.com/apple/sourcekit-lsp

Language server for Swift and C/C++/Objective-C.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.sourcekit.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "sourcekit-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "swift", "c", "cpp", "objective-c", "objective-cpp" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Package.swift", ".git")
  ```


## sourcery

https://github.com/sourcery-ai/sourcery

Refactor Python instantly using the power of AI.

It requires the init_options param to be populated as shown below and will respond with the list of ServerCapabilities that it supports:

```lua
require'lspconfig'.sourcery.setup {
    init_options = {
        --- The Sourcery token for authenticating the user.
        --- This is retrieved from the Sourcery website and must be
        --- provided by each user. The extension must provide a
        --- configuration option for the user to provide this value.
        token = <YOUR_TOKEN>,

        --- The extension's name and version as defined by the extension.
        extension_version = 'vim.lsp',

        --- The editor's name and version as defined by the editor.
        editor_version = 'vim',
    },
}
```

Alternatively, you can login to sourcery by running `sourcery login` with sourcery-cli.



**Snippet to enable the language server:**
```lua
require'lspconfig'.sourcery.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "sourcery", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `init_options` : 
  ```lua
  {
    editor_version = "vim",
    extension_version = "vim.lsp"
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## spectral

https://github.com/luizcorreia/spectral-language-server
 `A flexible JSON/YAML linter for creating automated style guides, with baked in support for OpenAPI v2 & v3.`

`spectral-language-server` can be installed via `npm`:
```sh
npm i -g spectral-language-server
```
See [vscode-spectral](https://github.com/stoplightio/vscode-spectral#extension-settings) for configuration options.



**Snippet to enable the language server:**
```lua
require'lspconfig'.spectral.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "spectral-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "yaml", "json", "yml" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    enable = true,
    run = "onType",
    validateLanguages = { "yaml", "json", "yml" }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## sqlls

https://github.com/joe-re/sql-language-server

This LSP can be installed via  `npm`. Find further instructions on manual installation of the sql-language-server at [joe-re/sql-language-server](https://github.com/joe-re/sql-language-server).
<br>
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.sqlls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "sql-language-server", "up", "--method", "stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "sql", "mysql" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## sqls

https://github.com/lighttiger2505/sqls

```lua
require'lspconfig'.sqls.setup{
  cmd = {"path/to/command", "-config", "path/to/config.yml"};
  ...
}
```
Sqls can be installed via `go get github.com/lighttiger2505/sqls`. Instructions for compiling Sqls from the source can be found at [lighttiger2505/sqls](https://github.com/lighttiger2505/sqls).

    


**Snippet to enable the language server:**
```lua
require'lspconfig'.sqls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "sqls" }
  ```
  - `filetypes` : 
  ```lua
  { "sql", "mysql" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## starlark-rust

https://github.com/facebookexperimental/starlark-rust/
The LSP part of `starlark-rust` is not currently documented,
 but the implementation works well for linting.
This gives valuable warnings for potential issues in the code,
but does not support refactorings.

It can be installed with cargo: https://crates.io/crates/starlark



**Snippet to enable the language server:**
```lua
require'lspconfig'.starlark-rust.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "starlark", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "star", "bzl", "BUILD.bazel" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## steep

https://github.com/soutaro/steep

`steep` is a static type checker for Ruby.

You need `Steepfile` to make it work. Generate it with `steep init`.



**Snippet to enable the language server:**
```lua
require'lspconfig'.steep.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "steep", "langserver" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby", "eruby" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Steepfile", ".git")
  ```


## stylelint_lsp

https://github.com/bmatcuk/stylelint-lsp

`stylelint-lsp` can be installed via `npm`:

```sh
npm i -g stylelint-lsp
```

Can be configured by passing a `settings.stylelintplus` object to `stylelint_lsp.setup`:

```lua
require'lspconfig'.stylelint_lsp.setup{
  settings = {
    stylelintplus = {
      -- see available options in stylelint-lsp documentation
    }
  }
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.stylelint_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "stylelint-lsp", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "css", "less", "scss", "sugarss", "vue", "wxss", "javascript", "javascriptreact", "typescript", "typescriptreact" }
  ```
  - `root_dir` : 
  ```lua
   root_pattern('.stylelintrc', 'package.json') 
  ```
  - `settings` : 
  ```lua
  {}
  ```


## sumneko_lua

https://github.com/sumneko/lua-language-server

Lua language server.

`lua-language-server` can be installed by following the instructions [here](https://github.com/sumneko/lua-language-server/wiki/Getting-Started#command-line).

The default `cmd` assumes that the `lua-language-server` binary can be found in `$PATH`.

If you primarily use `lua-language-server` for Neovim, and want to provide completions,
analysis, and location handling for plugins on runtime path, you can use the following
settings.

Note: that these settings will meaningfully increase the time until `lua-language-server` can service
initial requests (completion, location) upon starting as well as time to first diagnostics.
Completion results will include a workspace indexing progress message until the server has finished indexing.

```lua
require'lspconfig'.sumneko_lua.setup {
  settings = {
    Lua = {
      runtime = {
        -- Tell the language server which version of Lua you're using (most likely LuaJIT in the case of Neovim)
        version = 'LuaJIT',
      },
      diagnostics = {
        -- Get the language server to recognize the `vim` global
        globals = {'vim'},
      },
      workspace = {
        -- Make the server aware of Neovim runtime files
        library = vim.api.nvim_get_runtime_file("", true),
      },
      -- Do not send telemetry data containing a randomized but unique identifier
      telemetry = {
        enable = false,
      },
    },
  },
}
```

See `lua-language-server`'s [documentation](https://github.com/sumneko/lua-language-server/blob/master/locale/en-us/setting.lua) for an explanation of the above fields:
* [Lua.runtime.path](https://github.com/sumneko/lua-language-server/blob/076dd3e5c4e03f9cef0c5757dfa09a010c0ec6bf/locale/en-us/setting.lua#L5-L13)
* [Lua.workspace.library](https://github.com/sumneko/lua-language-server/blob/076dd3e5c4e03f9cef0c5757dfa09a010c0ec6bf/locale/en-us/setting.lua#L77-L78)




**Snippet to enable the language server:**
```lua
require'lspconfig'.sumneko_lua.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "lua-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "lua" }
  ```
  - `log_level` : 
  ```lua
  2
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".luarc.json", ".luarc.jsonc", ".luacheckrc", ".stylua.toml", "stylua.toml", "selene.toml", "selene.yml", ".git")
  ```
  - `settings` : 
  ```lua
  {
    Lua = {
      telemetry = {
        enable = false
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## svelte

https://github.com/sveltejs/language-tools/tree/master/packages/language-server

Note: assuming that [tsserver](#tsserver) is setup, full JavaScript/TypeScript support (find references, rename, etc of symbols in Svelte files when working in JS/TS files) requires per-project installation and configuration of [typescript-svelte-plugin](https://github.com/sveltejs/language-tools/tree/master/packages/typescript-plugin#usage).

`svelte-language-server` can be installed via `npm`:
```sh
npm install -g svelte-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.svelte.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "svelteserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "svelte" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json", ".git")
  ```


## svlangserver

https://github.com/imc-trading/svlangserver

Language server for SystemVerilog.

`svlangserver` can be installed via `npm`:

```sh
$ npm install -g @imc-trading/svlangserver
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.svlangserver.setup{}
```
**Commands:**
- SvlangserverBuildIndex: Instructs language server to rerun indexing
- SvlangserverReportHierarchy: Generates hierarchy for the given module

**Default values:**
  - `cmd` : 
  ```lua
  { "svlangserver" }
  ```
  - `filetypes` : 
  ```lua
  { "verilog", "systemverilog" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".svlangserver", ".git")
  ```
  - `settings` : 
  ```lua
  {
    systemverilog = {
      includeIndexing = { "*.{v,vh,sv,svh}", "**/*.{v,vh,sv,svh}" }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## svls

https://github.com/dalance/svls

Language server for verilog and SystemVerilog

`svls` can be installed via `cargo`:
 ```sh
 cargo install svls
 ```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.svls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "svls" }
  ```
  - `filetypes` : 
  ```lua
  { "verilog", "systemverilog" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## syntax_tree

https://ruby-syntax-tree.github.io/syntax_tree/

A fast Ruby parser and formatter.

Syntax Tree is a suite of tools built on top of the internal CRuby parser. It
provides the ability to generate a syntax tree from source, as well as the
tools necessary to inspect and manipulate that syntax tree. It can be used to
build formatters, linters, language servers, and more.

```sh
gem install syntax_tree
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.syntax_tree.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "stree", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".streerc", "Gemfile", ".git")
  ```


## tailwindcss

https://github.com/tailwindlabs/tailwindcss-intellisense

Tailwind CSS Language Server can be installed via npm:
```sh
npm install -g @tailwindcss/language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.tailwindcss.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "tailwindcss-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "aspnetcorerazor", "astro", "astro-markdown", "blade", "django-html", "htmldjango", "edge", "eelixir", "elixir", "ejs", "erb", "eruby", "gohtml", "haml", "handlebars", "hbs", "html", "html-eex", "heex", "jade", "leaf", "liquid", "markdown", "mdx", "mustache", "njk", "nunjucks", "php", "razor", "slim", "twig", "css", "less", "postcss", "sass", "scss", "stylus", "sugarss", "javascript", "javascriptreact", "reason", "rescript", "typescript", "typescriptreact", "vue", "svelte" }
  ```
  - `init_options` : 
  ```lua
  {
    userLanguages = {
      eelixir = "html-eex",
      eruby = "erb"
    }
  }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern('tailwind.config.js', 'tailwind.config.ts', 'postcss.config.js', 'postcss.config.ts', 'package.json', 'node_modules', '.git')
  ```
  - `settings` : 
  ```lua
  {
    tailwindCSS = {
      classAttributes = { "class", "className", "classList", "ngClass" },
      lint = {
        cssConflict = "warning",
        invalidApply = "error",
        invalidConfigPath = "error",
        invalidScreen = "error",
        invalidTailwindDirective = "error",
        invalidVariant = "error",
        recommendedVariantOrder = "warning"
      },
      validate = true
    }
  }
  ```


## taplo

https://taplo.tamasfe.dev/cli/usage/language-server.html

Language server for Taplo, a TOML toolkit.

`taplo-cli` can be installed via `cargo`:
```sh
cargo install --features lsp --locked taplo-cli
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.taplo.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "taplo", "lsp", "stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "toml" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("*.toml", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## tblgen_lsp_server

https://mlir.llvm.org/docs/Tools/MLIRLSP/#tablegen-lsp-language-server--tblgen-lsp-server

The Language Server for the LLVM TableGen language

`tblgen-lsp-server` can be installed at the llvm-project repository (https://github.com/llvm/llvm-project)



**Snippet to enable the language server:**
```lua
require'lspconfig'.tblgen_lsp_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "tblgen-lsp-server" }
  ```
  - `filetypes` : 
  ```lua
  { "tablegen" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## teal_ls

https://github.com/teal-language/teal-language-server

Install with:
```
luarocks install --dev teal-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.teal_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "teal-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "teal" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("tlconfig.lua", ".git")
  ```


## terraform_lsp

https://github.com/juliosueiras/terraform-lsp

Terraform language server
Download a released binary from
https://github.com/juliosueiras/terraform-lsp/releases.

From https://github.com/hashicorp/terraform-ls#terraform-ls-vs-terraform-lsp:

Both HashiCorp and the maintainer of terraform-lsp expressed interest in
collaborating on a language server and are working towards a _long-term_
goal of a single stable and feature-complete implementation.

For the time being both projects continue to exist, giving users the
choice:

- `terraform-ls` providing
  - overall stability (by relying only on public APIs)
  - compatibility with any provider and any Terraform >=0.12.0 currently
    less features
  - due to project being younger and relying on public APIs which may
    not offer the same functionality yet

- `terraform-lsp` providing
  - currently more features
  - compatibility with a single particular Terraform (0.12.20 at time of writing)
    - configs designed for other 0.12 versions may work, but interpretation may be inaccurate
  - less stability (due to reliance on Terraform's own internal packages)



**Snippet to enable the language server:**
```lua
require'lspconfig'.terraform_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "terraform-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "terraform", "hcl" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".terraform", ".git")
  ```


## terraformls

https://github.com/hashicorp/terraform-ls

Terraform language server
Download a released binary from https://github.com/hashicorp/terraform-ls/releases.

From https://github.com/hashicorp/terraform-ls#terraform-ls-vs-terraform-lsp:

Both HashiCorp and the maintainer of terraform-lsp expressed interest in
collaborating on a language server and are working towards a _long-term_
goal of a single stable and feature-complete implementation.

For the time being both projects continue to exist, giving users the
choice:

- `terraform-ls` providing
  - overall stability (by relying only on public APIs)
  - compatibility with any provider and any Terraform >=0.12.0 currently
    less features
  - due to project being younger and relying on public APIs which may
    not offer the same functionality yet

- `terraform-lsp` providing
  - currently more features
  - compatibility with a single particular Terraform (0.12.20 at time of writing)
    - configs designed for other 0.12 versions may work, but interpretation may be inaccurate
  - less stability (due to reliance on Terraform's own internal packages)



**Snippet to enable the language server:**
```lua
require'lspconfig'.terraformls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "terraform-ls", "serve" }
  ```
  - `filetypes` : 
  ```lua
  { "terraform" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".terraform", ".git")
  ```


## texlab

https://github.com/latex-lsp/texlab

A completion engine built from scratch for (La)TeX.

See https://github.com/latex-lsp/texlab/wiki/Configuration for configuration options.



**Snippet to enable the language server:**
```lua
require'lspconfig'.texlab.setup{}
```
**Commands:**
- TexlabBuild: Build the current buffer
- TexlabForward: Forward search from current position

**Default values:**
  - `cmd` : 
  ```lua
  { "texlab" }
  ```
  - `filetypes` : 
  ```lua
  { "tex", "plaintex", "bib" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    texlab = {
      auxDirectory = ".",
      bibtexFormatter = "texlab",
      build = {
        args = { "-pdf", "-interaction=nonstopmode", "-synctex=1", "%f" },
        executable = "latexmk",
        forwardSearchAfter = false,
        onSave = false
      },
      chktex = {
        onEdit = false,
        onOpenAndSave = false
      },
      diagnosticsDelay = 300,
      formatterLineLength = 80,
      forwardSearch = {
        args = {}
      },
      latexFormatter = "latexindent",
      latexindent = {
        modifyLineBreaks = false
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## tflint

https://github.com/terraform-linters/tflint

A pluggable Terraform linter that can act as lsp server.
Installation instructions can be found in https://github.com/terraform-linters/tflint#installation.



**Snippet to enable the language server:**
```lua
require'lspconfig'.tflint.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "tflint", "--langserver" }
  ```
  - `filetypes` : 
  ```lua
  { "terraform" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".terraform", ".git", ".tflint.hcl")
  ```


## theme_check

https://github.com/Shopify/shopify-cli

`theme-check-language-server` is bundled with `shopify-cli` or it can also be installed via

https://github.com/Shopify/theme-check#installation

**NOTE:**
If installed via Homebrew, `cmd` must be set to 'theme-check-liquid-server'

```lua
require lspconfig.theme_check.setup {
  cmd = { 'theme-check-liquid-server' }
}
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.theme_check.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "theme-check-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "liquid" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## tilt_ls

https://github.com/tilt-dev/tilt

Tilt language server.

You might need to add filetype detection manually:

```vim
autocmd BufRead Tiltfile setf=tiltfile
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.tilt_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "tilt", "lsp", "start" }
  ```
  - `filetypes` : 
  ```lua
  { "tiltfile" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## tsserver

https://github.com/theia-ide/typescript-language-server

`typescript-language-server` depends on `typescript`. Both packages can be installed via `npm`:
```sh
npm install -g typescript typescript-language-server
```

To configure typescript language server, add a
[`tsconfig.json`](https://www.typescriptlang.org/docs/handbook/tsconfig-json.html) or
[`jsconfig.json`](https://code.visualstudio.com/docs/languages/jsconfig) to the root of your
project.

Here's an example that disables type checking in JavaScript files.

```json
{
  "compilerOptions": {
    "module": "commonjs",
    "target": "es6",
    "checkJs": false
  },
  "exclude": [
    "node_modules"
  ]
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.tsserver.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "typescript-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx", "typescript", "typescriptreact", "typescript.tsx" }
  ```
  - `init_options` : 
  ```lua
  {
    hostInfo = "neovim"
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json", "tsconfig.json", "jsconfig.json", ".git")
  ```


## turtle_ls

https://github.com/stardog-union/stardog-language-servers/tree/master/packages/turtle-language-server
`turtle-language-server`, An editor-agnostic server providing language intelligence (diagnostics, hover tooltips, etc.) for the W3C standard Turtle RDF syntax via the Language Server Protocol.
installable via npm install -g turtle-language-server or yarn global add turtle-language-server.
requires node.



**Snippet to enable the language server:**
```lua
require'lspconfig'.turtle_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "node",
    [3] = "--stdio"
  }
  ```
  - `filetypes` : 
  ```lua
  { "turtle", "ttl" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## typeprof

https://github.com/ruby/typeprof

`typeprof` is the built-in analysis and LSP tool for Ruby 3.1+.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.typeprof.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "typeprof", "--lsp", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby", "eruby" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Gemfile", ".git")
  ```


## unison

https://github.com/unisonweb/unison/blob/trunk/docs/language-server.markdown


    


**Snippet to enable the language server:**
```lua
require'lspconfig'.unison.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nc", "localhost", "5757" }
  ```
  - `filetypes` : 
  ```lua
  { "unison" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## vala_ls

https://github.com/Prince781/vala-language-server


**Snippet to enable the language server:**
```lua
require'lspconfig'.vala_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vala-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "vala", "genie" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("meson.build", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## vdmj

https://github.com/nickbattle/vdmj

The VDMJ language server can be installed by cloning the VDMJ repository and
running `mvn clean install`.

Various options are provided to configure the language server (see below). In
particular:
- `annotation_paths` is a list of folders and/or jar file paths for annotations
that should be used with the language server;
- any value of `debugger_port` less than zero will disable the debugger; note
that if a non-zero value is used, only one instance of the server can be active
at a time.

More settings for VDMJ can be changed in a file called `vdmj.properties` under
`root_dir/.vscode`. For a description of the available settings, see
[Section 7 of the VDMJ User Guide](https://raw.githubusercontent.com/nickbattle/vdmj/master/vdmj/documentation/UserGuide.pdf).

Note: proof obligations and combinatorial testing are not currently supported
by neovim.



**Snippet to enable the language server:**
```lua
require'lspconfig'.vdmj.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  Generated from the options given
  ```
  - `filetypes` : 
  ```lua
  { "vdmsl", "vdmpp", "vdmrt" }
  ```
  - `options` : 
  ```lua
  {
    annotation_paths = {},
    debugger_port = -1,
    high_precision = false,
    java = "$JAVA_HOME/bin/java",
    java_opts = { "-Xmx3000m", "-Xss1m" },
    logfile = "path.join(vim.fn.stdpath 'cache', 'vdm-lsp.log')",
    mavenrepo = "$HOME/.m2/repository/dk/au/ece/vdmj",
    version = "The latest version installed in `mavenrepo`"
  }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor(fname) or find_vscode_ancestor(fname)
  ```


## verible

https://github.com/chipsalliance/verible

A linter and formatter for verilog and SystemVerilog files.

Release binaries can be downloaded from [here](https://github.com/chipsalliance/verible/releases)
and placed in a directory on PATH.

See https://github.com/chipsalliance/verible/tree/master/verilog/tools/ls/README.md for options.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.verible.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "verible-verilog-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "systemverilog", "verilog" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## veridian

https://github.com/vivekmalneedi/veridian

A SystemVerilog LanguageServer.

Download the latest release for your OS from the releases page

# install with slang feature, if C++17 compiler is available
cargo install --git https://github.com/vivekmalneedi/veridian.git --all-features
# install if C++17 compiler is not available
cargo install --git https://github.com/vivekmalneedi/veridian.git
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.veridian.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "veridian" }
  ```
  - `filetypes` : 
  ```lua
  { "systemverilog", "verilog" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## vimls

https://github.com/iamcco/vim-language-server

You can install vim-language-server via npm:
```sh
npm install -g vim-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.vimls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vim-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "vim" }
  ```
  - `init_options` : 
  ```lua
  {
    diagnostic = {
      enable = true
    },
    indexes = {
      count = 3,
      gap = 100,
      projectRootPatterns = { "runtime", "nvim", ".git", "autoload", "plugin" },
      runtimepath = true
    },
    isNeovim = true,
    iskeyword = "@,48-57,_,192-255,-#",
    runtimepath = "",
    suggest = {
      fromRuntimepath = true,
      fromVimruntime = true
    },
    vimruntime = ""
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## visualforce_ls

https://github.com/forcedotcom/salesforcedx-vscode

Language server for Visualforce.

For manual installation, download the .vsix archive file from the
[forcedotcom/salesforcedx-vscode](https://github.com/forcedotcom/salesforcedx-vscode)
GitHub releases. Then, configure `cmd` to run the Node script at the unpacked location:

```lua
require'lspconfig'.visualforce_ls.setup {
  cmd = {
    'node',
    '/path/to/unpacked/archive/extension/node_modules/@salesforce/salesforcedx-visualforce-language-server/out/src/visualforceServer.js',
    '--stdio'
  }
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.visualforce_ls.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "visualforce" }
  ```
  - `init_options` : 
  ```lua
  {
    embeddedLanguages = {
      css = true,
      javascript = true
    }
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('sfdx-project.json')
  ```


## vls

https://github.com/vlang/vls

V language server.

`v-language-server` can be installed by following the instructions [here](https://github.com/vlang/vls#installation).
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.vls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "v", "ls" }
  ```
  - `filetypes` : 
  ```lua
  { "vlang" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("v.mod", ".git")
  ```


## volar

https://github.com/johnsoncodehk/volar/tree/20d713b/packages/vue-language-server

Volar language server for Vue

Volar can be installed via npm:

```sh
npm install -g @volar/vue-language-server
```

Volar by default supports Vue 3 projects. Vue 2 projects need
[additional configuration](https://github.com/johnsoncodehk/volar/blob/master/extensions/vscode-vue-language-features/README.md?plain=1#L28-L63).

**Take Over Mode**

Volar can serve as a language server for both Vue and TypeScript via [Take Over Mode](https://github.com/johnsoncodehk/volar/discussions/471).

To enable Take Over Mode, override the default filetypes in `setup{}` as follows:

```lua
require'lspconfig'.volar.setup{
  filetypes = {'typescript', 'javascript', 'javascriptreact', 'typescriptreact', 'vue', 'json'}
}
```

**Overriding the default TypeScript Server used by Volar**

The default config looks for TS in the local `node_modules`. This can lead to issues
e.g. when working on a [monorepo](https://monorepo.tools/). The alternatives are:

- use a global TypeScript Server installation

```lua
require'lspconfig'.volar.setup{
  init_options = {
    typescript = {
      tsdk = '/path/to/.npm/lib/node_modules/typescript/lib'
      -- Alternative location if installed as root:
      -- tsdk = '/usr/local/lib/node_modules/typescript/lib'
    }
  }
}
```

- use a local server and fall back to a global TypeScript Server installation

```lua
local util = require 'lspconfig.util'
local function get_typescript_server_path(root_dir)

  local global_ts = '/home/[yourusernamehere]/.npm/lib/node_modules/typescript/lib'
  -- Alternative location if installed as root:
  -- local global_ts = '/usr/local/lib/node_modules/typescript/lib'
  local found_ts = ''
  local function check_dir(path)
    found_ts =  util.path.join(path, 'node_modules', 'typescript', 'lib')
    if util.path.exists(found_ts) then
      return path
    end
  end
  if util.search_ancestors(root_dir, check_dir) then
    return found_ts
  else
    return global_ts
  end
end

require'lspconfig'.volar.setup{
  on_new_config = function(new_config, new_root_dir)
    new_config.init_options.typescript.tsdk = get_typescript_server_path(new_root_dir)
  end,
}
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.volar.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vue-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "vue" }
  ```
  - `init_options` : 
  ```lua
  {
    documentFeatures = {
      documentColor = false,
      documentFormatting = {
        defaultPrintWidth = 100
      },
      documentSymbol = true,
      foldingRange = true,
      linkedEditingRange = true,
      selectionRange = true
    },
    languageFeatures = {
      callHierarchy = true,
      codeAction = true,
      codeLens = true,
      completion = {
        defaultAttrNameCase = "kebabCase",
        defaultTagNameCase = "both"
      },
      definition = true,
      diagnostics = true,
      documentHighlight = true,
      documentLink = true,
      hover = true,
      implementation = true,
      references = true,
      rename = true,
      renameFileRefactoring = true,
      schemaRequestService = true,
      semanticTokens = false,
      signatureHelp = true,
      typeDefinition = true
    },
    typescript = {
      tsdk = ""
    }
  }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## vuels

https://github.com/vuejs/vetur/tree/master/server

Vue language server(vls)
`vue-language-server` can be installed via `npm`:
```sh
npm install -g vls
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.vuels.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vls" }
  ```
  - `filetypes` : 
  ```lua
  { "vue" }
  ```
  - `init_options` : 
  ```lua
  {
    config = {
      css = {},
      emmet = {},
      html = {
        suggest = {}
      },
      javascript = {
        format = {}
      },
      stylusSupremacy = {},
      typescript = {
        format = {}
      },
      vetur = {
        completion = {
          autoImport = false,
          tagCasing = "kebab",
          useScaffoldSnippets = false
        },
        format = {
          defaultFormatter = {
            js = "none",
            ts = "none"
          },
          defaultFormatterOptions = {},
          scriptInitialIndent = false,
          styleInitialIndent = false
        },
        useWorkspaceDependencies = false,
        validation = {
          script = true,
          style = true,
          template = true
        }
      }
    }
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json", "vue.config.js")
  ```


## wgsl_analyzer

https://github.com/wgsl-analyzer/wgsl-analyzer

`wgsl_analyzer` can be installed via `cargo`:
```sh
cargo install --git https://github.com/wgsl-analyzer/wgsl-analyzer wgsl_analyzer
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.wgsl_analyzer.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "wgsl_analyzer" }
  ```
  - `filetypes` : 
  ```lua
  { "wgsl" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git"
  ```
  - `settings` : 
  ```lua
  {}
  ```


## yamlls

https://github.com/redhat-developer/yaml-language-server

`yaml-language-server` can be installed via `yarn`:
```sh
yarn global add yaml-language-server
```

To use a schema for validation, there are two options:

1. Add a modeline to the file. A modeline is a comment of the form:

```
# yaml-language-server: $schema=<urlToTheSchema|relativeFilePath|absoluteFilePath}>
```

where the relative filepath is the path relative to the open yaml file, and the absolute filepath
is the filepath relative to the filesystem root ('/' on unix systems)

2. Associated a schema url, relative , or absolute (to root of project, not to filesystem root) path to
the a glob pattern relative to the detected project root. Check `:LspInfo` to determine the resolved project
root.

```lua
require('lspconfig').yamlls.setup {
  ... -- other configuration for setup {}
  settings = {
    yaml = {
      ... -- other settings. note this overrides the lspconfig defaults.
      schemas = {
        ["https://json.schemastore.org/github-workflow.json"] = "/.github/workflows/*"
        ["../path/relative/to/file.yml"] = "/.github/workflows/*"
        ["/path/from/root/of/project"] = "/.github/workflows/*"
      },
    },
  }
}
```

Currently, kubernetes is special-cased in yammls, see the following upstream issues:
* [#211](https://github.com/redhat-developer/yaml-language-server/issues/211).
* [#307](https://github.com/redhat-developer/yaml-language-server/issues/307).

To override a schema to use a specific k8s schema version (for example, to use 1.18):

```lua
require('lspconfig').yamlls.setup {
  ... -- other configuration for setup {}
  settings = {
    yaml = {
      ... -- other settings. note this overrides the lspconfig defaults.
      schemas = {
        ["https://raw.githubusercontent.com/instrumenta/kubernetes-json-schema/master/v1.18.0-standalone-strict/all.json"] = "/*.k8s.yaml",
        ... -- other schemas
      },
    },
  }
}
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.yamlls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "yaml-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "yaml", "yaml.docker-compose" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `settings` : 
  ```lua
  {
    redhat = {
      telemetry = {
        enabled = false
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## zk

https://github.com/mickael-menu/zk

A plain text note-taking assistant



**Snippet to enable the language server:**
```lua
require'lspconfig'.zk.setup{}
```
**Commands:**
- ZkIndex: Index
- ZkNew: ZkNew

**Default values:**
  - `cmd` : 
  ```lua
  { "zk", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "markdown" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".zk")
  ```


## zls

https://github.com/zigtools/zls

Zig LSP implementation + Zig Language Server
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.zls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "zls" }
  ```
  - `filetypes` : 
  ```lua
  { "zig", "zir" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("zls.json", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```



vim:ft=markdown
