/*! For license information please see bookmarks-src_components_FolderPicker_vue.js.LICENSE.txt */
"use strict";(self.webpackChunkbookmarks=self.webpackChunkbookmarks||[]).push([["src_components_FolderPicker_vue"],{49899:(t,e,n)=>{n.d(e,{Z:()=>c});var r=n(87537),o=n.n(r),i=n(23645),l=n.n(i)()(o());l.push([t.id,"\n.folderpicker {\n\tmin-height: 300px;\n\tdisplay: flex;\n\tflex-direction: column;\n}\n.folderpicker .currentfolder {\n\tdisplay: flex;\n\talign-items: center;\n\theight: 45px;\n}\n.currentfolder h2 {\n\tmargin: 0;\n\tdisplay: flex;\n}\n.folderpicker .actions {\n\tflex-grow: 1;\n\tdisplay: flex;\n\tjustify-content: end;\n\talign-items: end;\n}\n","",{version:3,sources:["webpack://./src/components/FolderPicker.vue"],names:[],mappings:";AAiGA;CACA,iBAAA;CACA,aAAA;CACA,sBAAA;AACA;AAEA;CACA,aAAA;CACA,mBAAA;CACA,YAAA;AACA;AAEA;CACA,SAAA;CACA,aAAA;AACA;AAEA;CACA,YAAA;CACA,aAAA;CACA,oBAAA;CACA,gBAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2021. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div class="folderpicker">\n\t\t<h2>{{ title }}</h2>\n\t\t<div class="currentfolder">\n\t\t\t<NcActions v-if="currentFolder.id !== -1">\n\t\t\t\t<NcActionButton @click="onSelect(currentFolder.parent_folder)">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<ArrowLeftIcon />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t(\'bookmarks\', \'Go back\') }}\n\t\t\t\t</NcActionButton>\n\t\t\t</NcActions>\n\t\t\t<h2 v-if="currentFolder.id !== -1">\n\t\t\t\t<FolderIcon /><span>{{ currentFolder.title }}</span>\n\t\t\t</h2>\n\t\t\t<h2 v-else>\n\t\t\t\t<HomeIcon />\n\t\t\t</h2>\n\t\t</div>\n\t\t<TreeFolder v-for="folder of items"\n\t\t\t:key="folder.id"\n\t\t\t:folder="folder"\n\t\t\t:show-children="false"\n\t\t\t@select="folder.children && onSelect(folder.id)" />\n\t\t<div class="actions">\n\t\t\t<button class="button" @click="onSubmit">\n\t\t\t\t{{ t(\'bookmarks\', \'Choose folder\') }}\n\t\t\t</button>\n\t\t</div>\n\t</div>\n</template>\n\n<script>\nimport { NcActions, NcActionButton } from \'@nextcloud/vue\'\nimport FolderIcon from \'vue-material-design-icons/Folder.vue\'\nimport ArrowLeftIcon from \'vue-material-design-icons/ArrowLeft.vue\'\nimport HomeIcon from \'vue-material-design-icons/Home.vue\'\nimport TreeFolder from \'./TreeFolder.vue\'\n\nexport default {\n\tname: \'FolderPicker\',\n\tcomponents: {\n\t\tTreeFolder,\n\t\tNcActions,\n\t\tNcActionButton,\n\t\tFolderIcon,\n\t\tArrowLeftIcon,\n\t\tHomeIcon,\n\t},\n\tprops: {\n\t\ttitle: {\n\t\t\ttype: String,\n\t\t\trequired: true,\n\t\t},\n\t\tfilter: {\n\t\t\ttype: Function,\n\t\t\trequired: false,\n\t\t\tdefault: () => true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tselectedFolderId: -1,\n\t\t}\n\t},\n\tcomputed: {\n\t\tcurrentFolderPath() {\n\t\t\treturn this.$store.getters.getFolder(this.selectedFolderId).reverse()\n\t\t},\n\t\tcurrentFolder() {\n\t\t\treturn this.$store.getters.getFolder(this.selectedFolderId)[0]\n\t\t},\n\t\titems() {\n\t\t\treturn this.currentFolder.children.filter(this.filter)\n\t\t},\n\t},\n\tmethods: {\n\t\tasync onSelect(folderId) {\n\t\t\tif (!this.$store.getters.getFolder(folderId)[0]) {\n\t\t\t\tthis.selectedFolderId = -1\n\t\t\t} else {\n\t\t\t\tthis.selectedFolderId = folderId\n\t\t\t}\n\t\t},\n\t\tasync onSubmit() {\n\t\t\tthis.$emit(\'submit\', this.selectedFolderId)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.folderpicker {\n\tmin-height: 300px;\n\tdisplay: flex;\n\tflex-direction: column;\n}\n\n.folderpicker .currentfolder {\n\tdisplay: flex;\n\talign-items: center;\n\theight: 45px;\n}\n\n.currentfolder h2 {\n\tmargin: 0;\n\tdisplay: flex;\n}\n\n.folderpicker .actions {\n\tflex-grow: 1;\n\tdisplay: flex;\n\tjustify-content: end;\n\talign-items: end;\n}\n</style>\n'],sourceRoot:""}]);const c=l},5554:(t,e,n)=>{n.d(e,{Z:()=>c});var r=n(87537),o=n.n(r),i=n(23645),l=n.n(i)()(o());l.push([t.id,"\n.treefolder__title .material-design-icon {\n\tposition: relative;\n\ttop: 1px;\n\tmargin: 0 15px;\n}\n.treefolder__icon-hover:hover {\n\topacity: 0.8;\n}\n.treefolder__title {\n\tdisplay: flex;\n\talign-items: center;\n\tpadding: 0 10px;\n\tmargin: 0 -10px;\n\tcursor: pointer;\n}\n.treefolder__title * {\n\tcursor: pointer;\n}\n.treefolder.active > .treefolder__title,\n.treefolder__title:hover,\n.treefolder__title:focus {\n\tbackground: var(--color-background-dark);\n}\n.treefolder__title > h3 {\n\tflex: 1;\n\tdisplay: flex;\n}\n.treefolder__children .treefolder__title {\n\tpadding-left: 25px;\n}\n.treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 50px;\n}\n.treefolder__children  .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 75px;\n}\n.treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 100px;\n}\n.treefolder__children .treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 125px;\n}\n","",{version:3,sources:["webpack://./src/components/TreeFolder.vue"],names:[],mappings:";AAwEA;CACA,kBAAA;CACA,QAAA;CACA,cAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,aAAA;CACA,mBAAA;CACA,eAAA;CACA,eAAA;CACA,eAAA;AACA;AAEA;CACA,eAAA;AACA;AAEA;;;CAGA,wCAAA;AACA;AAEA;CACA,OAAA;CACA,aAAA;AACA;AAEA;CACA,kBAAA;AACA;AAEA;CACA,kBAAA;AACA;AAEA;CACA,kBAAA;AACA;AAEA;CACA,mBAAA;AACA;AAEA;CACA,mBAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2022. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div :class="{treefolder:true, active}">\n\t\t<div class="treefolder__title" @click="$emit(\'select\', folder.id)">\n\t\t\t<h3>\n\t\t\t\t<FolderIcon v-if="!childrenShown"\n\t\t\t\t\tclass="treefolder__icon-hover"\n\t\t\t\t\t:fill-color="colorPrimaryElement"\n\t\t\t\t\t@click.stop="folder.children.length && showChildren && (childrenShown = true)" />\n\t\t\t\t<FolderOpenIcon v-else\n\t\t\t\t\tclass="treefolder__icon-hover"\n\t\t\t\t\t:fill-color="colorPrimaryElement"\n\t\t\t\t\t@click.stop="folder.children.length && (childrenShown = false)" />\n\t\t\t\t{{ folder.title }}\n\t\t\t</h3>\n\t\t</div>\n\t\t<div v-if="showChildren && childrenShown" class="treefolder__children">\n\t\t\t<TreeFolder v-for="f in folder.children"\n\t\t\t\t:key="f.id"\n\t\t\t\t:folder="f"\n\t\t\t\t@select="$emit(\'select\', $event)" />\n\t\t</div>\n\t</div>\n</template>\n\n<script>\nimport FolderIcon from \'vue-material-design-icons/Folder.vue\'\nimport FolderOpenIcon from \'vue-material-design-icons/FolderOpen.vue\'\nimport { privateRoutes } from \'../router.js\'\nexport default {\n\tname: \'TreeFolder\',\n\tcomponents: { FolderIcon, FolderOpenIcon },\n\tprops: {\n\t\tfolder: {\n\t\t\ttype: Object,\n\t\t\trequired: true,\n\t\t},\n\t\tshowChildren: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tchildrenShown: false,\n\t\t}\n\t},\n\tcomputed: {\n\t\tactive() {\n\t\t\treturn this.$route.params.folder === this.folder.id\n\t\t},\n\t},\n\twatch: {\n\t\t\'$route\'() {\n\t\t\tif (this.$route.name === privateRoutes.FOLDER\n\t\t\t\t\t&& (this.$route.params.folder === this.folder.id\n\t\t\t\t\t\t\t|| this.folder.children.find(f => f.id === this.$route.params.folder))\n\t\t\t) {\n\t\t\t\tthis.childrenShown = true\n\t\t\t}\n\t\t},\n\t},\n}\n<\/script>\n\n<style>\n\n.treefolder__title .material-design-icon {\n\tposition: relative;\n\ttop: 1px;\n\tmargin: 0 15px;\n}\n\n.treefolder__icon-hover:hover {\n\topacity: 0.8;\n}\n\n.treefolder__title {\n\tdisplay: flex;\n\talign-items: center;\n\tpadding: 0 10px;\n\tmargin: 0 -10px;\n\tcursor: pointer;\n}\n\n.treefolder__title * {\n\tcursor: pointer;\n}\n\n.treefolder.active > .treefolder__title,\n.treefolder__title:hover,\n.treefolder__title:focus {\n\tbackground: var(--color-background-dark);\n}\n\n.treefolder__title > h3 {\n\tflex: 1;\n\tdisplay: flex;\n}\n\n.treefolder__children .treefolder__title {\n\tpadding-left: 25px;\n}\n\n.treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 50px;\n}\n\n.treefolder__children  .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 75px;\n}\n\n.treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 100px;\n}\n\n.treefolder__children .treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 125px;\n}\n</style>\n'],sourceRoot:""}]);const c=l},45618:(t,e,n)=>{n.d(e,{Z:()=>b});var r=n(15961),o=n(44580),i=n(24823),l=n(97974);function c(t){return c="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},c(t)}function d(){d=function(){return t};var t={},e=Object.prototype,n=e.hasOwnProperty,r=Object.defineProperty||function(t,e,n){t[e]=n.value},o="function"==typeof Symbol?Symbol:{},i=o.iterator||"@@iterator",l=o.asyncIterator||"@@asyncIterator",s=o.toStringTag||"@@toStringTag";function a(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{a({},"")}catch(t){a=function(t,e,n){return t[e]=n}}function f(t,e,n,o){var i=e&&e.prototype instanceof A?e:A,l=Object.create(i.prototype),c=new I(o||[]);return r(l,"_invoke",{value:x(t,n,c)}),l}function u(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=f;var h={};function A(){}function p(){}function v(){}var m={};a(m,i,(function(){return this}));var _=Object.getPrototypeOf,y=_&&_(_(E([])));y&&y!==e&&n.call(y,i)&&(m=y);var g=v.prototype=A.prototype=Object.create(m);function C(t){["next","throw","return"].forEach((function(e){a(t,e,(function(t){return this._invoke(e,t)}))}))}function w(t,e){function o(r,i,l,d){var s=u(t[r],t,i);if("throw"!==s.type){var a=s.arg,f=a.value;return f&&"object"==c(f)&&n.call(f,"__await")?e.resolve(f.__await).then((function(t){o("next",t,l,d)}),(function(t){o("throw",t,l,d)})):e.resolve(f).then((function(t){a.value=t,l(a)}),(function(t){return o("throw",t,l,d)}))}d(s.arg)}var i;r(this,"_invoke",{value:function(t,n){function r(){return new e((function(e,r){o(t,n,e,r)}))}return i=i?i.then(r,r):r()}})}function x(t,e,n){var r="suspendedStart";return function(o,i){if("executing"===r)throw new Error("Generator is already running");if("completed"===r){if("throw"===o)throw i;return S()}for(n.method=o,n.arg=i;;){var l=n.delegate;if(l){var c=F(l,n);if(c){if(c===h)continue;return c}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===r)throw r="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);r="executing";var d=u(t,e,n);if("normal"===d.type){if(r=n.done?"completed":"suspendedYield",d.arg===h)continue;return{value:d.arg,done:n.done}}"throw"===d.type&&(r="completed",n.method="throw",n.arg=d.arg)}}}function F(t,e){var n=e.method,r=t.iterator[n];if(void 0===r)return e.delegate=null,"throw"===n&&t.iterator.return&&(e.method="return",e.arg=void 0,F(t,e),"throw"===e.method)||"return"!==n&&(e.method="throw",e.arg=new TypeError("The iterator does not provide a '"+n+"' method")),h;var o=u(r,t.iterator,e.arg);if("throw"===o.type)return e.method="throw",e.arg=o.arg,e.delegate=null,h;var i=o.arg;return i?i.done?(e[t.resultName]=i.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,h):i:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,h)}function k(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function b(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function I(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(k,this),this.reset(!0)}function E(t){if(t){var e=t[i];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var r=-1,o=function e(){for(;++r<t.length;)if(n.call(t,r))return e.value=t[r],e.done=!1,e;return e.value=void 0,e.done=!0,e};return o.next=o}}return{next:S}}function S(){return{value:void 0,done:!0}}return p.prototype=v,r(g,"constructor",{value:v,configurable:!0}),r(v,"constructor",{value:p,configurable:!0}),p.displayName=a(v,s,"GeneratorFunction"),t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===p||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,v):(t.__proto__=v,a(t,s,"GeneratorFunction")),t.prototype=Object.create(g),t},t.awrap=function(t){return{__await:t}},C(w.prototype),a(w.prototype,l,(function(){return this})),t.AsyncIterator=w,t.async=function(e,n,r,o,i){void 0===i&&(i=Promise);var l=new w(f(e,n,r,o),i);return t.isGeneratorFunction(n)?l:l.next().then((function(t){return t.done?t.value:l.next()}))},C(g),a(g,s,"Generator"),a(g,i,(function(){return this})),a(g,"toString",(function(){return"[object Generator]"})),t.keys=function(t){var e=Object(t),n=[];for(var r in e)n.push(r);return n.reverse(),function t(){for(;n.length;){var r=n.pop();if(r in e)return t.value=r,t.done=!1,t}return t.done=!0,t}},t.values=E,I.prototype={constructor:I,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(b),!t)for(var e in this)"t"===e.charAt(0)&&n.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function r(n,r){return l.type="throw",l.arg=t,e.next=n,r&&(e.method="next",e.arg=void 0),!!r}for(var o=this.tryEntries.length-1;o>=0;--o){var i=this.tryEntries[o],l=i.completion;if("root"===i.tryLoc)return r("end");if(i.tryLoc<=this.prev){var c=n.call(i,"catchLoc"),d=n.call(i,"finallyLoc");if(c&&d){if(this.prev<i.catchLoc)return r(i.catchLoc,!0);if(this.prev<i.finallyLoc)return r(i.finallyLoc)}else if(c){if(this.prev<i.catchLoc)return r(i.catchLoc,!0)}else{if(!d)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return r(i.finallyLoc)}}}},abrupt:function(t,e){for(var r=this.tryEntries.length-1;r>=0;--r){var o=this.tryEntries[r];if(o.tryLoc<=this.prev&&n.call(o,"finallyLoc")&&this.prev<o.finallyLoc){var i=o;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var l=i?i.completion:{};return l.type=t,l.arg=e,i?(this.method="next",this.next=i.finallyLoc,h):this.complete(l)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),h},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),b(n),h}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var r=n.completion;if("throw"===r.type){var o=r.arg;b(n)}return o}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:E(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=void 0),h}},t}function s(t,e,n,r,o,i,l){try{var c=t[i](l),d=c.value}catch(t){return void n(t)}c.done?e(d):Promise.resolve(d).then(r,o)}function a(t){return function(){var e=this,n=arguments;return new Promise((function(r,o){var i=t.apply(e,n);function l(t){s(i,r,o,l,c,"next",t)}function c(t){s(i,r,o,l,c,"throw",t)}l(void 0)}))}}const f={name:"FolderPicker",components:{TreeFolder:n(51981).Z,NcActions:r.O3,NcActionButton:r.Js,FolderIcon:o.default,ArrowLeftIcon:i.default,HomeIcon:l.Z},props:{title:{type:String,required:!0},filter:{type:Function,required:!1,default:function(){return!0}}},data:function(){return{selectedFolderId:-1}},computed:{currentFolderPath:function(){return this.$store.getters.getFolder(this.selectedFolderId).reverse()},currentFolder:function(){return this.$store.getters.getFolder(this.selectedFolderId)[0]},items:function(){return this.currentFolder.children.filter(this.filter)}},methods:{onSelect:function(t){var e=this;return a(d().mark((function n(){return d().wrap((function(n){for(;;)switch(n.prev=n.next){case 0:e.$store.getters.getFolder(t)[0]?e.selectedFolderId=t:e.selectedFolderId=-1;case 1:case"end":return n.stop()}}),n)})))()},onSubmit:function(){var t=this;return a(d().mark((function e(){return d().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:t.$emit("submit",t.selectedFolderId);case 1:case"end":return e.stop()}}),e)})))()}}};var u=n(93379),h=n.n(u),A=n(7795),p=n.n(A),v=n(90569),m=n.n(v),_=n(3565),y=n.n(_),g=n(19216),C=n.n(g),w=n(44589),x=n.n(w),F=n(49899),k={};k.styleTagTransform=x(),k.setAttributes=y(),k.insert=m().bind(null,"head"),k.domAPI=p(),k.insertStyleElement=C();h()(F.Z,k);F.Z&&F.Z.locals&&F.Z.locals;const b=(0,n(51900).Z)(f,(function(){var t=this,e=t._self._c;return e("div",{staticClass:"folderpicker"},[e("h2",[t._v(t._s(t.title))]),t._v(" "),e("div",{staticClass:"currentfolder"},[-1!==t.currentFolder.id?e("NcActions",[e("NcActionButton",{on:{click:function(e){return t.onSelect(t.currentFolder.parent_folder)}},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ArrowLeftIcon")]},proxy:!0}],null,!1,3001860362)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Go back"))+"\n\t\t\t")])],1):t._e(),t._v(" "),-1!==t.currentFolder.id?e("h2",[e("FolderIcon"),e("span",[t._v(t._s(t.currentFolder.title))])],1):e("h2",[e("HomeIcon")],1)],1),t._v(" "),t._l(t.items,(function(n){return e("TreeFolder",{key:n.id,attrs:{folder:n,"show-children":!1},on:{select:function(e){n.children&&t.onSelect(n.id)}}})})),t._v(" "),e("div",{staticClass:"actions"},[e("button",{staticClass:"button",on:{click:t.onSubmit}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Choose folder"))+"\n\t\t")])])],2)}),[],!1,null,null,null).exports},51981:(t,e,n)=>{n.d(e,{Z:()=>C});var r=n(44580),o=n(27163),i=n(41209);const l={name:"TreeFolder",components:{FolderIcon:r.default,FolderOpenIcon:o.Z},props:{folder:{type:Object,required:!0},showChildren:{type:Boolean,default:!0}},data:function(){return{childrenShown:!1}},computed:{active:function(){return this.$route.params.folder===this.folder.id}},watch:{$route:function(){var t=this;this.$route.name!==i.xu.FOLDER||this.$route.params.folder!==this.folder.id&&!this.folder.children.find((function(e){return e.id===t.$route.params.folder}))||(this.childrenShown=!0)}}};var c=n(93379),d=n.n(c),s=n(7795),a=n.n(s),f=n(90569),u=n.n(f),h=n(3565),A=n.n(h),p=n(19216),v=n.n(p),m=n(44589),_=n.n(m),y=n(5554),g={};g.styleTagTransform=_(),g.setAttributes=A(),g.insert=u().bind(null,"head"),g.domAPI=a(),g.insertStyleElement=v();d()(y.Z,g);y.Z&&y.Z.locals&&y.Z.locals;const C=(0,n(51900).Z)(l,(function(){var t=this,e=t._self._c;return e("div",{class:{treefolder:!0,active:t.active}},[e("div",{staticClass:"treefolder__title",on:{click:function(e){return t.$emit("select",t.folder.id)}}},[e("h3",[t.childrenShown?e("FolderOpenIcon",{staticClass:"treefolder__icon-hover",attrs:{"fill-color":t.colorPrimaryElement},on:{click:function(e){e.stopPropagation(),t.folder.children.length&&(t.childrenShown=!1)}}}):e("FolderIcon",{staticClass:"treefolder__icon-hover",attrs:{"fill-color":t.colorPrimaryElement},on:{click:function(e){e.stopPropagation(),t.folder.children.length&&t.showChildren&&(t.childrenShown=!0)}}}),t._v("\n\t\t\t"+t._s(t.folder.title)+"\n\t\t")],1)]),t._v(" "),t.showChildren&&t.childrenShown?e("div",{staticClass:"treefolder__children"},t._l(t.folder.children,(function(n){return e("TreeFolder",{key:n.id,attrs:{folder:n},on:{select:function(e){return t.$emit("select",e)}}})})),1):t._e()])}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=bookmarks-src_components_FolderPicker_vue.js.map?v=adeafa906c584cffab02