/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.transport.action.changepolicy;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.commons.authuser.User;
import org.opensearch.index.Index;
import org.opensearch.indexmanagement.indexstatemanagement.DefaultIndexMetadataService;
import org.opensearch.indexmanagement.indexstatemanagement.IndexMetadataProvider;
import org.opensearch.indexmanagement.indexstatemanagement.model.ChangePolicy;
import org.opensearch.indexmanagement.indexstatemanagement.model.Policy;
import org.opensearch.indexmanagement.indexstatemanagement.model.StateFilter;
import org.opensearch.indexmanagement.indexstatemanagement.model.coordinator.SweptManagedIndexConfig;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.ISMStatusResponse;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.changepolicy.ChangePolicyRequest;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.changepolicy.TransportChangePolicyActionKt;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexAction;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexRequest;
import org.opensearch.indexmanagement.indexstatemanagement.util.FailedIndex;
import org.opensearch.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.spi.indexstatemanagement.IndexMetadataService;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ISMIndexMetadata;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StateMetaData;
import org.opensearch.indexmanagement.util.IndexManagementException;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001(B?\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J&\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00022\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006)"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/changepolicy/TransportChangePolicyAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/changepolicy/ChangePolicyRequest;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/ISMStatusResponse;", "client", "Lorg/opensearch/client/node/NodeClient;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "indexMetadataProvider", "Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;", "(Lorg/opensearch/client/node/NodeClient;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/common/xcontent/NamedXContentRegistry;Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;)V", "getClient", "()Lorg/opensearch/client/node/NodeClient;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "getIndexMetadataProvider", "()Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/action/ActionListener;", "ChangePolicyHandler", "opensearch-index-management"})
public final class TransportChangePolicyAction
extends HandledTransportAction<ChangePolicyRequest, ISMStatusResponse> {
    @NotNull
    private final NodeClient client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final IndexMetadataProvider indexMetadataProvider;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportChangePolicyAction(@NotNull NodeClient client, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry, @NotNull IndexMetadataProvider indexMetadataProvider) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)indexMetadataProvider, (String)"indexMetadataProvider");
        super("cluster:admin/opendistro/ism/managedindex/change", transportService, actionFilters, ChangePolicyRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.indexMetadataProvider = indexMetadataProvider;
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportChangePolicyAction._init_$lambda-0(this, arg_0));
    }

    @NotNull
    public final NodeClient getClient() {
        return this.client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @NotNull
    public final IndexMetadataProvider getIndexMetadataProvider() {
        return this.indexMetadataProvider;
    }

    protected void doExecute(@NotNull Task task, @NotNull ChangePolicyRequest request, @NotNull ActionListener<ISMStatusResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        new ChangePolicyHandler(this.client, listener, request, null, 8, null).start();
    }

    private static final void _init_$lambda-0(TransportChangePolicyAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filterByEnabled = it;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020\u001eH\u0002J\b\u0010!\u001a\u00020\u001eH\u0002J\u001b\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130%H\u0002\u00a2\u0006\u0002\u0010&J$\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020,0+H\u0002J\u0014\u0010-\u001a\u00020\u001e2\n\u0010.\u001a\u00060/j\u0002`0H\u0002J\u0010\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\u001e2\u0006\u00102\u001a\u000206H\u0002J\u0010\u00108\u001a\u00020\u001e2\u0006\u00109\u001a\u00020:H\u0002J\u0006\u0010;\u001a\u00020\u001eJ\u0016\u0010<\u001a\u00020\u001e2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0002J\b\u0010@\u001a\u00020\u001eH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00180\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/changepolicy/TransportChangePolicyAction$ChangePolicyHandler;", "", "client", "Lorg/opensearch/client/node/NodeClient;", "actionListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/ISMStatusResponse;", "request", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/changepolicy/ChangePolicyRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "(Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/changepolicy/TransportChangePolicyAction;Lorg/opensearch/client/node/NodeClient;Lorg/opensearch/action/ActionListener;Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/changepolicy/ChangePolicyRequest;Lorg/opensearch/commons/authuser/User;)V", "changePolicy", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/ChangePolicy;", "failedIndices", "", "Lorg/opensearch/indexmanagement/indexstatemanagement/util/FailedIndex;", "indexUuidToCurrentState", "", "", "indexUuidToIndexMetadata", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "indicesToUpdate", "managedIndicesToUpdate", "Lkotlin/Pair;", "policy", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/Policy;", "updated", "", "getClusterState", "", "getIndicesToUpdate", "getManagedIndexMetadata", "getPolicy", "mgetManagedIndexConfigRequest", "Lorg/opensearch/action/get/MultiGetRequest;", "managedIndexUuids", "", "([Ljava/lang/String;)Lorg/opensearch/action/get/MultiGetRequest;", "onBulkResponse", "bulkResponse", "Lorg/opensearch/action/bulk/BulkResponse;", "mapOfItemIdToIndex", "", "Lorg/opensearch/index/Index;", "onFailure", "t", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onGetPolicyResponse", "response", "Lorg/opensearch/action/get/GetResponse;", "onMgetMetadataResponse", "mgetResponse", "Lorg/opensearch/action/get/MultiGetResponse;", "onMultiGetResponse", "onUpdateMapping", "acknowledgedResponse", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "start", "updateManagedIndexConfig", "sweptConfigs", "", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/coordinator/SweptManagedIndexConfig;", "validateAndGetPolicy", "opensearch-index-management"})
    public final class ChangePolicyHandler {
        @NotNull
        private final NodeClient client;
        @NotNull
        private final ActionListener<ISMStatusResponse> actionListener;
        @NotNull
        private final ChangePolicyRequest request;
        @Nullable
        private final User user;
        @NotNull
        private final List<FailedIndex> failedIndices;
        @NotNull
        private final List<Pair<String, String>> managedIndicesToUpdate;
        @NotNull
        private final Map<String, String> indexUuidToCurrentState;
        @NotNull
        private final Map<String, String> indicesToUpdate;
        @NotNull
        private final Map<String, IndexMetadata> indexUuidToIndexMetadata;
        @NotNull
        private final ChangePolicy changePolicy;
        private Policy policy;
        private int updated;

        public ChangePolicyHandler(@NotNull NodeClient client, @NotNull ActionListener<ISMStatusResponse> actionListener, @Nullable ChangePolicyRequest request, User user) {
            Intrinsics.checkNotNullParameter((Object)((Object)TransportChangePolicyAction.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
            this.failedIndices = new ArrayList();
            this.managedIndicesToUpdate = new ArrayList();
            this.indexUuidToCurrentState = new LinkedHashMap();
            this.indicesToUpdate = new LinkedHashMap();
            this.indexUuidToIndexMetadata = new LinkedHashMap();
            this.changePolicy = this.request.getChangePolicy();
        }

        public /* synthetic */ ChangePolicyHandler(NodeClient nodeClient, ActionListener actionListener, ChangePolicyRequest changePolicyRequest, User user, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                ThreadContext threadContext = nodeClient.threadPool().getThreadContext();
                Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"class ChangePolicyHandle\u2026xception)\n        }\n    }");
                user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
            }
            this(nodeClient, (ActionListener<ISMStatusResponse>)actionListener, changePolicyRequest, user);
        }

        public final void start() {
            TransportChangePolicyActionKt.access$getLog$p().debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            if (this.user == null) {
                this.getPolicy();
            } else {
                this.validateAndGetPolicy();
            }
        }

        private final void validateAndGetPolicy() {
            Collection $this$toTypedArray$iv = this.request.getIndices();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            String[] stringArray2 = stringArray;
            ManagedIndexRequest request = (ManagedIndexRequest)new ManagedIndexRequest(new String[0]).indices(Arrays.copyOf(stringArray2, stringArray2.length));
            this.client.execute((ActionType)ManagedIndexAction.Companion.getINSTANCE(), (ActionRequest)request, (ActionListener)new ActionListener<AcknowledgedResponse>(this){
                final /* synthetic */ ChangePolicyHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull AcknowledgedResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    ChangePolicyHandler.access$getPolicy(this.this$0);
                }

                public void onFailure(@NotNull Exception e) {
                    Exception exception;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ActionListener actionListener = ChangePolicyHandler.access$getActionListener$p(this.this$0);
                    boolean bl = e instanceof OpenSearchSecurityException;
                    if (bl) {
                        exception = (Exception)((Object)new OpenSearchStatusException("User doesn't have required index permissions on one or more requested indices: " + ((OpenSearchSecurityException)((Object)e)).getLocalizedMessage(), RestStatus.FORBIDDEN, new Object[0]));
                    } else if (!bl) {
                        exception = e;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    actionListener.onFailure((Exception)((Object)IndexManagementException.Companion.wrap(exception)));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void getPolicy() {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", this.changePolicy.getPolicyID());
            AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
            TransportChangePolicyAction transportChangePolicyAction = TransportChangePolicyAction.this;
            Throwable throwable = null;
            try {
                ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
                boolean bl = false;
                Boolean bl2 = transportChangePolicyAction.filterByEnabled;
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"filterByEnabled");
                if (!SecurityUtils.Companion.validateUserConfiguration(this.user, bl2, this.actionListener)) {
                    return;
                }
                this.client.get(getRequest, ActionListener.wrap(this::onGetPolicyResponse, this::onFailure));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        private final void onGetPolicyResponse(GetResponse response2) {
            if (!response2.isExists() || response2.isSourceEmpty()) {
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Could not find policy=" + this.request.getChangePolicy().getPolicyID(), RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            try {
                this.policy = (Policy)OpenSearchExtensionsKt.parseFromGetResponse(response2, TransportChangePolicyAction.this.getXContentRegistry(), (Function4)new Function4<XContentParser, String, Long, Long, Policy>((Object)Policy.Companion){

                    @NotNull
                    public final Policy invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return ((Policy.Companion)this.receiver).parse(p0, p1, p2, p3);
                    }
                });
            }
            catch (IllegalArgumentException e) {
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Could not find policy=" + this.request.getChangePolicy().getPolicyID(), RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            Policy policy2 = this.policy;
            if (policy2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"policy");
                policy2 = null;
            }
            User user = policy2.getUser();
            Boolean bl = TransportChangePolicyAction.this.filterByEnabled;
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"filterByEnabled");
            if (!SecurityUtils.Companion.userHasPermissionForResource(this.user, user, bl, "policy", this.request.getChangePolicy().getPolicyID(), this.actionListener)) {
                return;
            }
            bl = TransportChangePolicyAction.this.getClusterService().state();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"clusterService.state()");
            Boolean bl2 = bl;
            bl = this.client.admin().indices();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"client.admin().indices()");
            Boolean bl3 = bl;
            bl = ActionListener.wrap(this::onUpdateMapping, this::onFailure);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"wrap(::onUpdateMapping, ::onFailure)");
            IndexUtils.Companion.checkAndUpdateConfigIndexMapping((ClusterState)bl2, (IndicesAdminClient)bl3, (ActionListener<AcknowledgedResponse>)bl);
        }

        private final void onUpdateMapping(AcknowledgedResponse acknowledgedResponse) {
            if (!acknowledgedResponse.isAcknowledged()) {
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Could not update .opendistro-ism-config with new mapping.", RestStatus.FAILED_DEPENDENCY, new Object[0])));
                return;
            }
            this.getIndicesToUpdate();
        }

        private final void getIndicesToUpdate() {
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(TransportChangePolicyAction.this, this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ TransportChangePolicyAction this$0;
                final /* synthetic */ ChangePolicyHandler this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            indexNameToMetadata = new HashMap<K, V>();
                            var12_4 = indexNameToMetadata;
                            this.L$0 = indexNameToMetadata;
                            this.L$1 = var12_4;
                            this.label = 1;
                            v0 = this.this$0.getIndexMetadataProvider().getISMIndexMetadataByType(ChangePolicyHandler.access$getRequest$p(this.this$1).getIndexType(), ChangePolicyHandler.access$getRequest$p(this.this$1).getIndices(), (Continuation<? super Map<String, ISMIndexMetadata>>)((Continuation)this));
                            ** if (v0 != var13_2) goto lbl15
lbl14:
                            // 1 sources

                            return var13_2;
lbl15:
                            // 1 sources

                            ** GOTO lbl23
                        }
                        case 1: {
                            var12_4 = (Map)this.L$1;
                            indexNameToMetadata = (Map)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl23:
                                // 2 sources

                                var12_4.putAll((Map)v0);
                            }
                            catch (Exception e) {
                                v1 = ExceptionsHelper.unwrapCause((Throwable)e);
                                if (v1 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                                }
                                ChangePolicyHandler.access$getActionListener$p(this.this$1).onFailure((Exception)v1);
                                return Unit.INSTANCE;
                            }
                            e = indexNameToMetadata;
                            var4_7 = this.this$1;
                            $i$f$forEach = false;
                            var6_9 = $this$forEach$iv.entrySet().iterator();
                            while (var6_9.hasNext()) {
                                $dstr$indexName$indexMetadata = element$iv = var6_9.next();
                                $i$a$-forEach-TransportChangePolicyAction$ChangePolicyHandler$getIndicesToUpdate$1$1 = false;
                                indexName = (String)$dstr$indexName$indexMetadata.getKey();
                                indexMetadata = (ISMIndexMetadata)$dstr$indexName$indexMetadata.getValue();
                                ChangePolicyHandler.access$getIndicesToUpdate$p(var4_7).putIfAbsent(indexMetadata.getIndexUuid(), indexName);
                            }
                            if (Intrinsics.areEqual((Object)ChangePolicyHandler.access$getRequest$p(this.this$1).getIndexType(), (Object)"_default")) {
                                ChangePolicyHandler.access$getClusterState(this.this$1);
                            } else {
                                ChangePolicyHandler.access$getManagedIndexMetadata(this.this$1);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        private final void getClusterState() {
            IndicesOptions strictExpandOptions = IndicesOptions.strictExpand();
            Collection $this$toTypedArray$iv = this.request.getIndices();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            String[] stringArray2 = stringArray;
            ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(Arrays.copyOf(stringArray2, stringArray2.length)).metadata(true).local(false)).indicesOptions(strictExpandOptions);
            this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(TransportChangePolicyAction.this, this){
                final /* synthetic */ TransportChangePolicyAction this$0;
                final /* synthetic */ ChangePolicyHandler this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onResponse(@NotNull ClusterStateResponse response2) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Map $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    ClusterState clusterState = response2.getState();
                    IndexMetadataService indexMetadataService = this.this$0.getIndexMetadataProvider().getServices().get("_default");
                    if (indexMetadataService == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.opensearch.indexmanagement.indexstatemanagement.DefaultIndexMetadataService");
                    }
                    DefaultIndexMetadataService defaultIndexMetadataService = (DefaultIndexMetadataService)indexMetadataService;
                    Object object = clusterState.getMetadata().getIndices();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clusterState.metadata.indices");
                    object = (Iterable)object;
                    ChangePolicyHandler changePolicyHandler = this.this$1;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv = iterator.next();
                        ObjectObjectCursor it = (ObjectObjectCursor)element$iv;
                        boolean bl = false;
                        Object object2 = it.value;
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.value");
                        String indexUUID = defaultIndexMetadataService.getCustomIndexUUID((IndexMetadata)object2);
                        object2 = ChangePolicyHandler.access$getIndexUuidToIndexMetadata$p(changePolicyHandler);
                        Object object3 = it.value;
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"it.value");
                        object2.put(indexUUID, object3);
                    }
                    $this$forEach$iv = ChangePolicyHandler.access$getIndicesToUpdate$p(this.this$1);
                    changePolicyHandler = this.this$1;
                    boolean $i$f$filter = false;
                    iterator = $this$filter$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$filterTo = false;
                    Iterator<Map.Entry<K, V>> iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<K, V> element$iv$iv;
                        Map.Entry<K, V> it = element$iv$iv = iterator2.next();
                        boolean bl = false;
                        if (!ChangePolicyHandler.access$getIndexUuidToIndexMetadata$p(changePolicyHandler).containsKey(it.getKey())) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    ChangePolicyHandler.access$getManagedIndexMetadata(this.this$1);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                    if (throwable == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    }
                    ChangePolicyHandler.access$getActionListener$p(this.this$1).onFailure((Exception)throwable);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void getManagedIndexMetadata() {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = MapsKt.toList(this.indicesToUpdate);
            NodeClient nodeClient = this.client;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((String)it.getFirst());
            }
            nodeClient.multiGet(org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt.buildMgetMetadataRequest((List)destination$iv$iv), ActionListener.wrap(this::onMgetMetadataResponse, this::onFailure));
        }

        /*
         * WARNING - void declaration
         */
        private final void onMgetMetadataResponse(MultiGetResponse mgetResponse) {
            void $this$toTypedArray$iv;
            Collection<String> collection;
            String indexUuid;
            Collection collection2;
            Object item$iv$iv;
            Object $this$mapTo$iv$iv;
            Map<String, Pair<ManagedIndexMetaData, Exception>> metadataMap = org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt.mgetResponseToMap(mgetResponse);
            Iterable $this$map$iv = this.changePolicy.getInclude();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                item$iv$iv = iterator.next();
                StateFilter stateFilter = (StateFilter)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getState());
            }
            Set includedStates = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Object $this$forEach$iv = this.indicesToUpdate;
            boolean $i$f$forEach = false;
            $this$mapTo$iv$iv = $this$forEach$iv.entrySet().iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                String currentState;
                String string;
                ManagedIndexMetaData managedIndexMetadata;
                IndexMetadata indexMetaData;
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> $dstr$indexUuid$indexName = element$iv = $this$mapTo$iv$iv.next();
                boolean bl = false;
                indexUuid = $dstr$indexUuid$indexName.getKey();
                String indexName = $dstr$indexUuid$indexName.getValue();
                IndexMetadata indexMetadata2 = indexMetaData = this.indexUuidToIndexMetadata.get(indexUuid);
                ManagedIndexMetaData clusterStateMetadata = indexMetadata2 == null ? null : org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt.getManagedIndexMetadata(indexMetadata2);
                Pair<ManagedIndexMetaData, Exception> pair = metadataMap.get(indexUuid);
                Exception mgetFailure = pair == null ? null : (Exception)pair.getSecond();
                Pair<ManagedIndexMetaData, Exception> pair2 = metadataMap.get(ManagedIndexUtils.managedIndexMetadataID(indexUuid));
                ManagedIndexMetaData managedIndexMetaData = managedIndexMetadata = pair2 == null ? null : (ManagedIndexMetaData)pair2.getFirst();
                if (managedIndexMetaData == null) {
                    string = null;
                } else {
                    StateMetaData stateMetaData = managedIndexMetaData.getStateMetaData();
                    string = currentState = stateMetaData == null ? null : stateMetaData.getName();
                }
                if (currentState != null) {
                    this.indexUuidToCurrentState.put(indexUuid, currentState);
                }
                if (mgetFailure != null) {
                    this.failedIndices.add(new FailedIndex(indexName, indexUuid, "Failed to get managed index metadata, " + mgetFailure));
                    continue;
                }
                ManagedIndexMetaData managedIndexMetaData2 = managedIndexMetadata;
                if ((managedIndexMetaData2 == null ? null : managedIndexMetaData2.getTransitionTo()) != null) {
                    this.failedIndices.add(new FailedIndex(indexName, indexUuid, "Cannot change policy while transitioning to new state"));
                    continue;
                }
                if (managedIndexMetadata == null) {
                    if (clusterStateMetadata != null) {
                        this.failedIndices.add(new FailedIndex(indexName, indexUuid, "Cannot change policy until metadata has finished migrating"));
                        continue;
                    }
                    this.managedIndicesToUpdate.add((Pair<String, String>)TuplesKt.to((Object)indexName, (Object)indexUuid));
                    continue;
                }
                if (includedStates.isEmpty()) {
                    this.managedIndicesToUpdate.add((Pair<String, String>)TuplesKt.to((Object)indexName, (Object)indexUuid));
                    continue;
                }
                StateMetaData stateMetaData = managedIndexMetadata.getStateMetaData();
                if (CollectionsKt.contains((Iterable)includedStates, (Object)(stateMetaData == null ? null : stateMetaData.getName()))) {
                    this.managedIndicesToUpdate.add((Pair<String, String>)TuplesKt.to((Object)indexName, (Object)indexUuid));
                    continue;
                }
                TransportChangePolicyActionKt.access$getLog$p().debug("Skipping " + indexName + " as it does not match any of the include state filters");
            }
            if (this.managedIndicesToUpdate.isEmpty()) {
                this.updated = 0;
                this.actionListener.onResponse((Object)new ISMStatusResponse(this.updated, this.failedIndices));
                return;
            }
            $this$forEach$iv = this.managedIndicesToUpdate;
            ChangePolicyHandler changePolicyHandler = this;
            collection2 = this.client;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void $dstr$_u24__u24$indexUuid;
                item$iv$iv = iterator.next();
                indexUuid = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String indexUuid2 = (String)$dstr$_u24__u24$indexUuid.component2();
                collection.add(indexUuid2);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            collection2.multiGet(changePolicyHandler.mgetManagedIndexConfigRequest(stringArray), ActionListener.wrap(this::onMultiGetResponse, this::onFailure));
        }

        /*
         * WARNING - void declaration
         */
        private final void onMultiGetResponse(MultiGetResponse response2) {
            void $this$mapNotNullTo$iv$iv;
            Set foundManagedIndices = new LinkedHashSet();
            MultiGetItemResponse[] multiGetItemResponseArray = response2.getResponses();
            Intrinsics.checkNotNullExpressionValue((Object)multiGetItemResponseArray, (String)"response.responses");
            Object[] $this$mapNotNull$iv = multiGetItemResponseArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            void var11_10 = $this$forEach$iv$iv$iv;
            int n = 0;
            int n2 = ((void)var11_10).length;
            while (n < n2) {
                SweptManagedIndexConfig sweptManagedIndexConfig;
                void element$iv$iv$iv = var11_10[n];
                ++n;
                void element$iv$iv = element$iv$iv$iv;
                boolean bl = false;
                MultiGetItemResponse it = (MultiGetItemResponse)element$iv$iv;
                boolean bl2 = false;
                if (!it.getResponse().isExists()) {
                    String indexName;
                    Object v0;
                    String indexUuid;
                    block7: {
                        indexUuid = it.getResponse().getId();
                        for (Object t : (Iterable)this.managedIndicesToUpdate) {
                            Pair $dstr$_u24__u24$second = (Pair)t;
                            boolean bl3 = false;
                            String second = (String)$dstr$_u24__u24$second.component2();
                            if (!Intrinsics.areEqual((Object)second, (Object)indexUuid)) continue;
                            v0 = t;
                            break block7;
                        }
                        v0 = null;
                    }
                    Pair pair = v0;
                    String string = indexName = pair == null ? null : (String)pair.getFirst();
                    if (indexName != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)indexUuid, (String)"indexUuid");
                        this.failedIndices.add(new FailedIndex(indexName, indexUuid, "This index is not being managed"));
                    }
                }
                if (!it.isFailed() && !it.getResponse().isSourceEmpty()) {
                    String string = it.getResponse().getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.response.id");
                    foundManagedIndices.add(string);
                    string = it.getResponse().getSourceAsBytesRef();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.response.sourceAsBytesRef");
                    sweptManagedIndexConfig = (SweptManagedIndexConfig)OpenSearchExtensionsKt.parseWithType(OpenSearchExtensionsKt.contentParser((BytesReference)string), "", it.getResponse().getSeqNo(), it.getResponse().getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, SweptManagedIndexConfig>((Object)SweptManagedIndexConfig.Companion){

                        @NotNull
                        public final SweptManagedIndexConfig invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            return ((SweptManagedIndexConfig.Companion)this.receiver).parse(p0, p1, p2, p3);
                        }
                    });
                } else {
                    sweptManagedIndexConfig = null;
                }
                if (sweptManagedIndexConfig == null) continue;
                SweptManagedIndexConfig it$iv$iv = sweptManagedIndexConfig;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List sweptConfigs2 = (List)destination$iv$iv;
            if (sweptConfigs2.isEmpty()) {
                this.updated = 0;
                this.actionListener.onResponse((Object)new ISMStatusResponse(this.updated, this.failedIndices));
                return;
            }
            this.updateManagedIndexConfig(sweptConfigs2);
        }

        /*
         * WARNING - void declaration
         */
        private final void updateManagedIndexConfig(List<SweptManagedIndexConfig> sweptConfigs2) {
            Map mapOfItemIdToIndex = new LinkedHashMap();
            BulkRequest bulkUpdateManagedIndexRequest = new BulkRequest();
            Iterable $this$forEachIndexed$iv = sweptConfigs2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                boolean bl;
                void sweptConfig;
                int n = index$iv;
                index$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                SweptManagedIndexConfig sweptManagedIndexConfig = (SweptManagedIndexConfig)item$iv;
                int id2 = n;
                boolean bl2 = false;
                String currentStateName = this.indexUuidToCurrentState.get(sweptConfig.getUuid());
                Policy policy2 = sweptConfig.getPolicy();
                if (policy2 == null) {
                    bl = false;
                } else {
                    Policy policy3 = this.policy;
                    if (policy3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"policy");
                        policy3 = null;
                    }
                    bl = ManagedIndexUtils.isSafeToChange(policy2, currentStateName, policy3, this.changePolicy);
                }
                ChangePolicy updatedChangePolicy = ChangePolicy.copy$default(this.changePolicy, null, null, null, bl, this.user, 7, null);
                bulkUpdateManagedIndexRequest.add(ManagedIndexUtils.updateManagedIndexRequest(SweptManagedIndexConfig.copy$default((SweptManagedIndexConfig)sweptConfig, null, 0L, 0L, null, null, null, updatedChangePolicy, 63, null)));
                Map map = mapOfItemIdToIndex;
                Integer n2 = id2;
                Index index2 = new Index(sweptConfig.getIndex(), sweptConfig.getUuid());
                map.put(n2, index2);
            }
            this.client.bulk(bulkUpdateManagedIndexRequest, (ActionListener)new ActionListener<BulkResponse>(this, (Map<Integer, Index>)mapOfItemIdToIndex){
                final /* synthetic */ ChangePolicyHandler this$0;
                final /* synthetic */ Map<Integer, Index> $mapOfItemIdToIndex;
                {
                    this.this$0 = $receiver;
                    this.$mapOfItemIdToIndex = $mapOfItemIdToIndex;
                }

                public void onResponse(@NotNull BulkResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    ChangePolicyHandler.access$onBulkResponse(this.this$0, response2, this.$mapOfItemIdToIndex);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                    if (throwable == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    }
                    ChangePolicyHandler.access$getActionListener$p(this.this$0).onFailure((Exception)throwable);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void onBulkResponse(BulkResponse bulkResponse2, Map<Integer, ? extends Index> mapOfItemIdToIndex) {
            void $this$filterTo$iv$iv;
            BulkItemResponse[] bulkItemResponseArray = bulkResponse2.getItems();
            if (bulkItemResponseArray == null) {
                bulkItemResponseArray = new BulkItemResponse[]{};
            }
            BulkItemResponse[] $this$filter$iv = bulkItemResponseArray;
            boolean $i$f$filter = false;
            BulkItemResponse[] bulkItemResponseArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                void it = element$iv$iv;
                boolean bl = false;
                if (!it.isFailed()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List failedResponses = (List)destination$iv$iv;
            Iterable $this$forEach$iv = failedResponses;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BulkItemResponse it = (BulkItemResponse)element$iv;
                boolean bl = false;
                Index indexPair = mapOfItemIdToIndex.get(it.getItemId());
                if (indexPair == null) continue;
                String string = indexPair.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"indexPair.name");
                String string2 = string;
                string = indexPair.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"indexPair.uuid");
                String string3 = string;
                string = it.getFailureMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.failureMessage");
                this.failedIndices.add(new FailedIndex(string2, string3, string));
            }
            BulkItemResponse[] bulkItemResponseArray3 = bulkResponse2.getItems();
            if (bulkItemResponseArray3 == null) {
                bulkItemResponseArray3 = new BulkItemResponse[]{};
            }
            this.updated = bulkItemResponseArray3.length - failedResponses.size();
            this.actionListener.onResponse((Object)new ISMStatusResponse(this.updated, this.failedIndices));
        }

        private final MultiGetRequest mgetManagedIndexConfigRequest(String[] managedIndexUuids) {
            MultiGetRequest request = new MultiGetRequest();
            String[] stringArray = new String[]{"managed_index.index", "managed_index.index_uuid", "managed_index.policy_id", "managed_index.policy", "managed_index.change_policy"};
            String[] includes = stringArray;
            boolean $i$f$emptyArray = false;
            String[] excludes = new String[]{};
            FetchSourceContext fetchSourceContext = new FetchSourceContext(true, includes, excludes);
            String[] $this$forEach$iv = managedIndexUuids;
            boolean $i$f$forEach = false;
            for (String element$iv : $this$forEach$iv) {
                String it = element$iv;
                boolean bl = false;
                request.add(new MultiGetRequest.Item(".opendistro-ism-config", it).fetchSourceContext(fetchSourceContext).routing(it));
            }
            return request;
        }

        private final void onFailure(Exception t) {
            Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
            if (throwable == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
            }
            this.actionListener.onFailure((Exception)throwable);
        }

        public static final /* synthetic */ void access$getPolicy(ChangePolicyHandler $this) {
            $this.getPolicy();
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(ChangePolicyHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ ChangePolicyRequest access$getRequest$p(ChangePolicyHandler $this) {
            return $this.request;
        }

        public static final /* synthetic */ void access$getClusterState(ChangePolicyHandler $this) {
            $this.getClusterState();
        }

        public static final /* synthetic */ void access$getManagedIndexMetadata(ChangePolicyHandler $this) {
            $this.getManagedIndexMetadata();
        }

        public static final /* synthetic */ Map access$getIndicesToUpdate$p(ChangePolicyHandler $this) {
            return $this.indicesToUpdate;
        }

        public static final /* synthetic */ Map access$getIndexUuidToIndexMetadata$p(ChangePolicyHandler $this) {
            return $this.indexUuidToIndexMetadata;
        }

        public static final /* synthetic */ void access$onBulkResponse(ChangePolicyHandler $this, BulkResponse bulkResponse2, Map mapOfItemIdToIndex) {
            $this.onBulkResponse(bulkResponse2, mapOfItemIdToIndex);
        }
    }
}

