/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.validation;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Validate;
import org.opensearch.indexmanagement.util.OpenForTesting;
import org.opensearch.monitor.jvm.JvmService;

@OpenForTesting
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/validation/ValidateReadWrite;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Validate;", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "jvmService", "Lorg/opensearch/monitor/jvm/JvmService;", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/monitor/jvm/JvmService;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "execute", "indexName", "", "hasReadOnlyAllowDeleteBlock", "", "Companion", "opensearch-index-management"})
public class ValidateReadWrite
extends Validate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger;
    @NotNull
    public static final String name = "validate_read_write";
    @NotNull
    public static final String settingKey = "read_only_allow_delete";

    public ValidateReadWrite(@NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull JvmService jvmService) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)jvmService, (String)"jvmService");
        super(settings, clusterService, jvmService);
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public Validate execute(@NotNull String indexName) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        if (this.hasReadOnlyAllowDeleteBlock(indexName)) {
            return this;
        }
        this.setValidationMessage(Companion.getValidationPassedMessage(indexName));
        return this;
    }

    public boolean hasReadOnlyAllowDeleteBlock(@NotNull String indexName) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        String readOnlyAllowDeleteBlock = this.getSettings().get(settingKey);
        CharSequence charSequence = readOnlyAllowDeleteBlock;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String message = Companion.getReadOnlyAllowDeleteBlockMessage(indexName);
            this.logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/validation/ValidateReadWrite$Companion;", "", "()V", "name", "", "settingKey", "getReadOnlyAllowDeleteBlockMessage", "index", "getValidationPassedMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getReadOnlyAllowDeleteBlockMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "read_only_allow_delete block is not null for index [index=" + index2 + "]";
        }

        @NotNull
        public final String getValidationPassedMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "read_write validation passed for [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

