/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.util;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.index.Index;
import org.opensearch.indexmanagement.indexstatemanagement.util.RestHandlerUtilsKt;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.script.ScriptType;
import org.opensearch.script.TemplateScript;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/opensearch/indexmanagement/rollup/util/RollupFieldValueExpressionResolver;", "", "()V", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "indexAliasUtils", "Lorg/opensearch/indexmanagement/rollup/util/RollupFieldValueExpressionResolver$IndexAliasUtils;", "getIndexAliasUtils", "()Lorg/opensearch/indexmanagement/rollup/util/RollupFieldValueExpressionResolver$IndexAliasUtils;", "setIndexAliasUtils", "(Lorg/opensearch/indexmanagement/rollup/util/RollupFieldValueExpressionResolver$IndexAliasUtils;)V", "scriptService", "Lorg/opensearch/script/ScriptService;", "validTopContextFields", "", "", "registerServices", "", "resolve", "rollup", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "fieldValue", "IndexAliasUtils", "opensearch-index-management"})
public final class RollupFieldValueExpressionResolver {
    @NotNull
    public static final RollupFieldValueExpressionResolver INSTANCE = new RollupFieldValueExpressionResolver();
    @NotNull
    private static final Set<String> validTopContextFields = SetsKt.setOf((Object)"source_index");
    private static ScriptService scriptService;
    private static ClusterService clusterService;
    public static IndexAliasUtils indexAliasUtils;

    private RollupFieldValueExpressionResolver() {
    }

    @NotNull
    public final IndexAliasUtils getIndexAliasUtils() {
        IndexAliasUtils indexAliasUtils = RollupFieldValueExpressionResolver.indexAliasUtils;
        if (indexAliasUtils != null) {
            return indexAliasUtils;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"indexAliasUtils");
        return null;
    }

    public final void setIndexAliasUtils(@NotNull IndexAliasUtils indexAliasUtils) {
        Intrinsics.checkNotNullParameter((Object)indexAliasUtils, (String)"<set-?>");
        RollupFieldValueExpressionResolver.indexAliasUtils = indexAliasUtils;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String resolve(@NotNull Rollup rollup2, @NotNull String fieldValue) {
        Object object;
        void $this$filterKeys$iv;
        Intrinsics.checkNotNullParameter((Object)rollup2, (String)"rollup");
        Intrinsics.checkNotNullParameter((Object)fieldValue, (String)"fieldValue");
        Script script = new Script(ScriptType.INLINE, "mustache", fieldValue, MapsKt.emptyMap());
        Object object2 = XContentFactory.jsonBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"jsonBuilder()");
        object2 = OpenSearchExtensionsKt.toMap(rollup2.toXContent((XContentBuilder)object2, (ToXContent.Params)RestHandlerUtilsKt.getXCONTENT_WITHOUT_TYPE()));
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String key = (String)entry$iv.getKey();
            boolean bl = false;
            if (!validTopContextFields.contains(key)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map contextMap = result$iv;
        ScriptService scriptService = RollupFieldValueExpressionResolver.scriptService;
        if (scriptService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scriptService");
            scriptService = null;
        }
        TemplateScript.Factory factory = (TemplateScript.Factory)scriptService.compile(script, TemplateScript.CONTEXT);
        Object object3 = script.getParams();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"script.params");
        String compiledValue = factory.newInstance(MapsKt.plus((Map)object3, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"ctx", (Object)contextMap)))).execute();
        IndexAliasUtils indexAliasUtils = this.getIndexAliasUtils();
        object3 = compiledValue;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"compiledValue");
        if (indexAliasUtils.isAlias((String)object3)) {
            IndexAliasUtils indexAliasUtils2 = this.getIndexAliasUtils();
            object3 = compiledValue;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"compiledValue");
            compiledValue = indexAliasUtils2.getWriteIndexNameForAlias((String)object3);
        }
        if ((object3 = (CharSequence)compiledValue) == null || StringsKt.isBlank((CharSequence)object3)) {
            object = fieldValue;
        } else {
            object3 = compiledValue;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"compiledValue");
            object = object3;
        }
        return object;
    }

    public final void registerServices(@NotNull ScriptService scriptService, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"scriptService");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        RollupFieldValueExpressionResolver.scriptService = scriptService;
        RollupFieldValueExpressionResolver.clusterService = clusterService;
        this.setIndexAliasUtils(new IndexAliasUtils(clusterService));
    }

    public final void registerServices(@NotNull ScriptService scriptService, @NotNull ClusterService clusterService, @NotNull IndexAliasUtils indexAliasUtils) {
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"scriptService");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)indexAliasUtils, (String)"indexAliasUtils");
        RollupFieldValueExpressionResolver.scriptService = scriptService;
        RollupFieldValueExpressionResolver.clusterService = clusterService;
        this.setIndexAliasUtils(indexAliasUtils);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/indexmanagement/rollup/util/RollupFieldValueExpressionResolver$IndexAliasUtils;", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "(Lorg/opensearch/cluster/service/ClusterService;)V", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getBackingIndicesForAlias", "", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "alias", "", "getWriteIndexNameForAlias", "hasAlias", "", "index", "isAlias", "opensearch-index-management"})
    public static class IndexAliasUtils {
        @NotNull
        private final ClusterService clusterService;

        public IndexAliasUtils(@NotNull ClusterService clusterService) {
            Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
            this.clusterService = clusterService;
        }

        @NotNull
        public final ClusterService getClusterService() {
            return this.clusterService;
        }

        public boolean hasAlias(@NotNull String index2) {
            ImmutableOpenMap aliases;
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            IndexMetadata indexMetadata2 = (IndexMetadata)this.clusterService.state().metadata().getIndices().get((Object)index2);
            Object object = aliases = indexMetadata2 == null ? null : indexMetadata2.getAliases();
            if (aliases != null) {
                return aliases.size() > 0;
            }
            return false;
        }

        public boolean isAlias(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            SortedMap sortedMap = this.clusterService.state().metadata().getIndicesLookup();
            return (sortedMap == null ? null : (IndexAbstraction)sortedMap.get(index2)) instanceof IndexAbstraction.Alias;
        }

        @Nullable
        public String getWriteIndexNameForAlias(@NotNull String alias) {
            String string;
            Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
            SortedMap sortedMap = this.clusterService.state().metadata().getIndicesLookup();
            if (sortedMap == null) {
                string = null;
            } else {
                IndexAbstraction indexAbstraction = (IndexAbstraction)sortedMap.get(alias);
                if (indexAbstraction == null) {
                    string = null;
                } else {
                    IndexMetadata indexMetadata2 = indexAbstraction.getWriteIndex();
                    if (indexMetadata2 == null) {
                        string = null;
                    } else {
                        Index index2 = indexMetadata2.getIndex();
                        string = index2 == null ? null : index2.getName();
                    }
                }
            }
            return string;
        }

        @Nullable
        public List<IndexMetadata> getBackingIndicesForAlias(@NotNull String alias) {
            List list;
            Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
            SortedMap sortedMap = this.clusterService.state().metadata().getIndicesLookup();
            if (sortedMap == null) {
                list = null;
            } else {
                IndexAbstraction indexAbstraction = (IndexAbstraction)sortedMap.get(alias);
                list = indexAbstraction == null ? null : indexAbstraction.getIndices();
            }
            return list;
        }
    }
}

